/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iqJt
 */

package
{
    import com.adobe.images.JPGEncoder;
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.ColorChooser;
    import com.bit101.components.ComboBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.ProgressBar;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.net.FileReference;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    import flash.utils.Timer;
    import nochump.util.zip.ZipEntry;
    import nochump.util.zip.ZipOutput;

    /**
     * ..
     */
    public class Main extends Sprite
    {
        static public const DATA_SET_COMPLETE:String = "dataSetComplete";
        private var _imageWidth:int;
        private var _imageHeight:int;
        private var _imageLength:int;
        private var _startNumber:int = 0;
        
        private var _tf:TextField;
        private var _tfSize:int = 30;
        private var _tfColor:int = 0xFFFFFF;
        
        private var _inputWidth:InputText;
        private var _inputHeight:InputText;
        private var _inputLength:InputText;
        private var _inputStartNumber:InputText;
        private var _box:ComboBox;
        private var _button1:RadioButton;
        private var _button2:RadioButton;
        private var _isFill:Boolean = true;
        private var _bgColor:int = 0xFF0000;
        private var _bgColorIndex:int = 1;
        private var _isGrey:Boolean = false;
        private var _button3:RadioButton;
        private var _button4:RadioButton;
        private var _isPng:Boolean = true;
        private var _fileType:String = "png";
        private var _inputFileName:InputText;
        private var _fileName:String = "dummy";
        
        private var _bm:Bitmap;
        private var _bmd:BitmapData;
        private var _preBmd:BitmapData;
        private var _slider:HUISlider;
        private var _container:Sprite;
        private var _color:ColorChooser;
        private var _previewLabel:Label;
        private var _zipOut:ZipOutput;
        private var _pbar:ProgressBar;
        private var _loadLabel:Label;
        private var _totalLabel:Label;
        private var _count:int;
        private var _bg:Sprite;
        
        private var _previewImageWidth:int = 240;
        private var _previewImageHeight:int = 240;
        
        private var _uiContainer:Sprite;
        private var _isRandom:Boolean = false;
        private var _creatingZipTimer:Timer;
        private var _creatingZipLabel:Label;
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var title:Label = new Label(this, 10, 10, "sequential images maker");
            title.scaleX = 3;
            title.scaleY = 2;
            
            _uiContainer = new Sprite();
            this.addChild(_uiContainer);
            _uiContainer.x = 255;
            _uiContainer.y = 80;
            
            
            _imageWidth = 100;
            _imageHeight = 100;
            _imageLength = 200;
            
            var _imageBack:Sprite =  createBox(_previewImageWidth, _previewImageHeight,0xEFEFEF);
            addChild(_imageBack);
            _imageBack.filters = [new GlowFilter(0x666666,.5,8,8,1)];
            _imageBack.x = 10;
            _imageBack.y = 90;
            _imageBack.alpha = 1;
            
            _tf = createTextField(10,0);
            
            _bm = new Bitmap();
            _container = new Sprite();
            _container.addChild(_bm);
            this.addChild(_container);
            _container.x = 10;
            _container.y = 90;
            
            _previewLabel = new Label(this, 10, 70, "preview");
            
            createUI();
                        
            
            
            var button:PushButton = new PushButton(this, 10, 375, "", clickHanlder);
            button.width = 445;
            button.height = 50;
            var buttonLabel:Label = new Label(this, 110, 360, "create zip file");
            buttonLabel.scaleX = 4;
            buttonLabel.scaleY = 4;
            buttonLabel.alpha = 0.4;
                        
            _bg = createBox(stage.stageWidth, stage.stageHeight, 0xFFFFFF);
            addChild(_bg);
            _bg.alpha = .8;
            _bg.width
            _bg.height
            _bg.visible = false;
            
            var progressContainer:Sprite = new Sprite();
            this.addChild(progressContainer);
            progressContainer.x = 85;
            progressContainer.y = 190;
            _loadLabel = new Label(progressContainer, 0, 0, "0");
            _loadLabel.visible = false;
            _totalLabel = new Label(progressContainer, 45, 0, " / ");
            _totalLabel.visible = false;
            _pbar = new ProgressBar(progressContainer, 0, 20);
            _pbar.visible = false;
            
            changeHandler(null);
            
            
            _creatingZipLabel = new Label(progressContainer, -40, 0, "creating zip file now...");
            _creatingZipLabel.visible = false;
            _creatingZipLabel.scaleX = 4;
            _creatingZipLabel.scaleY = 4;
            _creatingZipLabel.alpha = 0.4;
        }
        
        private function createBox(w:int, h:int,col:int= 0x000000):Sprite
        {
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(col);
            sp.graphics.drawRect(0, 0, w, h);
            sp.graphics.endFill();
            return sp;
        }
        
        
        private function createTextField(size:int = 10,index:int = 0):TextField
        {
            var tf:TextField = new TextField();
            var tfm:TextFormat = new TextFormat("Arial", size, _tfColor, true);
            tf.autoSize = "left";
            tf.defaultTextFormat = tfm;
            tf.text = index.toString();
            return tf;
        }
        
        private function createUI():void 
        {
            new Label(_uiContainer, 10, 10, "image length");
            _inputLength = new InputText(_uiContainer, 100, 10, "10", changeHandler);
            _inputLength.restrict = "0-9";
            new Label(_uiContainer, 10, 30, "image width");
            _inputWidth = new InputText(_uiContainer, 100, 30, "100", changeHandler);
            _inputWidth.restrict = "0-9";
            new Label(_uiContainer, 10, 50, "image height");
            _inputHeight = new InputText(_uiContainer, 100, 50, "100", changeHandler);
            _inputHeight.restrict = "0-9";
            
            var offsetY1:int = 20;
            new Label(_uiContainer, 10, 70+offsetY1, "number start");
            _inputStartNumber = new InputText(_uiContainer, 100, 70+offsetY1, "0", changeHandler);
            _inputStartNumber.restrict = "0-9";
            _slider = new HUISlider(_uiContainer, 10,90+offsetY1,"number size          ", changeHandler);
            _slider.maximum = 100; // 上限
            _slider.minimum = 10; // 下限
            _slider.value = _tfSize;
            _slider.width = 220;
            new Label(_uiContainer, 10, 110+offsetY1, "number color");
            _color = new ColorChooser(_uiContainer, 100, 110+offsetY1, 0xFFFFFF, changeHandler);
            _color.usePopup = true;
            _color.width = 200;

            
            var offsetY0:int = 50+offsetY1;
            new Label(_uiContainer, 10, 100+offsetY0, "image color");
            _box = new ComboBox(_uiContainer, 100, 100+offsetY0, null, ["red", "geen", "blue" ,"grey","random"]);
            _box.addEventListener(Event.SELECT, changeHandler);
            new Label(_uiContainer, 10, 125+offsetY0, "image type");
            _button1 = new RadioButton(_uiContainer, 100, 130+offsetY0, "fill", true, radioChangeHandler1);
            _button2 = new RadioButton(_uiContainer, 150, 130+offsetY0, "noise", false, radioChangeHandler1);
            _button1.groupName = _button2.groupName = "group1";
            new Label(_uiContainer, 10, 145+offsetY0, "file type");
            _button4 = new RadioButton(_uiContainer, 100, 150+offsetY0, "png", true, radioChangeHandler2);
            _button3 = new RadioButton(_uiContainer, 150, 150+offsetY0, "jpg", false, radioChangeHandler2);
            _button3.groupName = _button4.groupName = "group2";
            
            new Label(_uiContainer, 10, 170+offsetY0, "file name");
            _inputFileName = new InputText(_uiContainer, 100, 170+offsetY0, "dummy", changeHandler);
            _inputFileName.restrict = "0-9a-zA-Z_\\-";
            
            _box.selectedIndex = 0;
        }
        
        private function radioChangeHandler2(e:Event):void 
        {
            var button:RadioButton = e.currentTarget as RadioButton;
            if (button.label == "png")    _isPng = true;
            else _isPng = false;
            _fileType = button.label;
            
            if(_imageWidth && _imageHeight) changePreview();
        }
        
        
        private function radioChangeHandler1(e:Event):void 
        {
            
            var button:RadioButton = e.currentTarget as RadioButton;
            if (button.label == "fill")    
            {
                _box.removeItemAt(4);
                _box.addItem("random");
                _isFill = true;
            }
            else
            {
                _box.removeItemAt(4);
                _box.addItem("colorful");
                _isFill = false;
            }
            _box.selectedIndex = _box.selectedIndex;
            if (button.label == "fill" && _box.selectedIndex == 4) _isRandom = true;
            
            if(_imageWidth && _imageHeight) changePreview();
        }
        
        private function changeHandler(e:Event):void 
        {
            _imageLength = int(_inputLength.text);
            _imageWidth = int(_inputWidth.text);
            if (_imageWidth > 2880)
            {
                _imageWidth = 2880;
                _inputWidth.text = "2880";
            }
            _imageHeight = int(_inputHeight.text);
            if (_imageHeight > 2880)
            {
                _imageHeight = 2880;
                _inputHeight.text = "2880";
            }
            
            _startNumber = int(_inputStartNumber.text);
            _fileName = _inputFileName.text;
            
            _tfSize = int(_slider.value);
            _tfColor = int(_color.value);
            
            _isGrey = false;
            _isRandom = false;
            
            switch(_box.selectedIndex)
            {
                case 0:
                _bgColor = 0xFF0000;
                _bgColorIndex = 1;
                break;
                case 1:
                _bgColor = 0x00FF00;
                _bgColorIndex = 2;
                break;
                case 2:
                _bgColor = 0x0000FF;
                _bgColorIndex = 4;
                break;
                case 3:
                _bgColor = 0x999999;
                _bgColorIndex = 7;
                _isGrey = true;
                break;
                case 4:
                _bgColor = Math.random() * 0xFFFFFF;
                _bgColorIndex = 7;
                if (_box.selectedItem == "random") _isRandom = true;
                
                break;
            }
            if(_imageWidth && _imageHeight) changePreview();
        }
        
        private function createBitmapData(w:int,h:int):BitmapData
        {
            var bmd:BitmapData;
            if (_isRandom) var color:int = Math.random() * 0xFFFFFF;
            else color = _bgColor;
            
            bmd = new BitmapData(w, h, false,color);
            if(!_isFill) bmd.perlinNoise(w / 10, h / 10, 1, Math.random()*1000 , true, true, _bgColorIndex, _isGrey, null);
            
            return bmd;
        }
        
        private function createImage(bmd:BitmapData,text:String):BitmapData
        {
            var copy:BitmapData = bmd.clone();
            _tf.text = text;
            copy.draw(_tf);
            return copy;
        }
        
        private function changePreview():void 
        {
            if (_tf.parent) 
            {
                _container.removeChild(_tf);
                _tf = null;
            }
            _tf = createTextField(_tfSize, _startNumber);
            
            if(_bmd) _bmd.dispose();
            _bmd = createBitmapData(_imageWidth, _imageHeight);
            
            if (_preBmd) _preBmd.dispose();
            _preBmd = new BitmapData(_imageWidth, _imageHeight,true);
            _preBmd.draw(_bmd);
            _preBmd.draw(_tf)
            
            var scaleRatio:Number = 1;
            if (_imageWidth > _imageHeight) scaleRatio = _previewImageWidth / _imageWidth;
            else scaleRatio = _previewImageHeight / _imageHeight;
            
            var matrix:Matrix = new Matrix();
            matrix.scale(scaleRatio, scaleRatio);
            var bmd:BitmapData = new BitmapData(_previewImageWidth, _previewImageHeight, true,0xFFFFFF);
            bmd.draw(_preBmd, matrix);
            _bm.bitmapData = bmd;
            
            _previewLabel.text = "preview (" + _imageWidth + " × " + _imageHeight + ")   " + "< "+_fileName + _startNumber +"."+ _fileType + " >";
        }
        
        private function clickHanlder(e:MouseEvent):void
        {
            if (_zipOut) _zipOut = null;
            
            _zipOut = new ZipOutput();
            
            this.addEventListener(Main.DATA_SET_COMPLETE, completeHandler);
            
            _loadLabel.text = "0";
            _totalLabel.text = " / " + _imageLength;
            _loadLabel.visible = true;
            _totalLabel.visible = true;
            _pbar.visible = true;
            _bg.visible = true;
            
            next();
        }
        
        private function completeHandler(e:Event):void 
        {
            _loadLabel.text = _startNumber.toString();
            _pbar.value = _startNumber / (int(_inputStartNumber.text) + _imageLength);
            
            var timer:Timer = new Timer(0, 1);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }
        
        private function timerHandler(e:TimerEvent):void 
        {
            next();
        }
        private function next():void
        {
            //var imageData:BitmapData = createImage(_bmd, _startNumber.toString());
            var imageData:BitmapData = createImage(createBitmapData(_imageWidth,_imageHeight), _startNumber.toString());
            
            var fileData:ByteArray = new ByteArray();
            if (_isPng) fileData = PNGEncoder.encode(imageData);
            else
            {
                var jpgEncoder:JPGEncoder = new JPGEncoder(80);
                fileData = jpgEncoder.encode(imageData);
            }
            
            _zipOut.putNextEntry(new ZipEntry(_fileName + _startNumber + "."+_fileType));
            _zipOut.write(fileData);
            _zipOut.closeEntry();
            
            imageData.dispose();
            
            _startNumber++;
            
            if (_startNumber >= int(_inputStartNumber.text) + _imageLength)
            {
                _zipOut.finish();

                var fr:FileReference = new FileReference();
                fr.save(_zipOut.byteArray, "dummyImageFiles.zip");
                fr.addEventListener(Event.COMPLETE, fileCompleteHandelr);
                fr.addEventListener(Event.CANCEL, fileCompleteHandelr);
                
                _loadLabel.text = _startNumber.toString();
                _pbar.value = _startNumber / (int(_inputStartNumber.text) + _imageLength);
                
                _loadLabel.visible = false;
                _totalLabel.visible = false;
                _pbar.visible = false;
                
                _creatingZipTimer = new Timer(10);
                _creatingZipTimer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {_creatingZipLabel.visible = !_creatingZipLabel.visible } );
                _creatingZipTimer.start();
            }
            else
            {
                this.dispatchEvent(new Event(Main.DATA_SET_COMPLETE));
            }
        }
        
        private function fileCompleteHandelr(e:Event):void 
        {
            _creatingZipTimer.stop();
            _bg.visible = false;
            _creatingZipTimer = null;
            _startNumber =  int(_inputStartNumber.text);
            _creatingZipLabel.visible = false;
        }
    }
}
