/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iqFM
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;	
	public class Main extends Sprite {
		private var points:Array;
		private var xn:uint = 20, yn:uint = 20;
		private var texture:BitmapData;
		private var ang:Number = 0;
		private var fl:Number = 400;
		private var cx:Number, cy:Number;
		private var canvas:Sprite;
		public function Main() {
			cx = stage.stageWidth / 2;
			cy = stage.stageHeight / 2;
			texture = new BitmapData(480,480,false,0x66aaff);
			var noise:BitmapData = new BitmapData(480,480);
			noise.perlinNoise(100,100,3,1,true,true,7);
			texture.draw(noise, new Matrix(), new ColorTransform(1,1,1,0.8,0,0,0,0), BlendMode.SCREEN);
			
			addChild(canvas = new Sprite);
			
			points = new Array();
			var i:uint, j:uint;
			for (j = 0; j <= yn; j ++) {
				points[j] = new Vector.<Vector3D>();
				for (i = 0; i <= xn; i ++) {
					points[j].push(new Vector3D(	i * texture.width / xn- texture.width / 2,
																250,
																j * texture.width / yn + 200));
					
				}
			}
			addEventListener(Event.ENTER_FRAME, h_enterFrame);
		}
		
		public function h_enterFrame(evt:Event):void {
			var i:uint, j:uint;
			var vertices:Vector.<Number> = new Vector.<Number>;
			var indices:Vector.<int> = new Vector.<int>;
			var uv:Vector.<Number> = new Vector.<Number>;
			var g:Graphics = canvas.graphics;
			
			ang += 0.1;
			for (j = 0; j <= yn; j ++) {
				for (i = 0; i <= xn; i ++) {
					var p3d:Vector3D = new Vector3D(points[j][i].x, points[j][i].y + Math.sin(ang + (j + i) / 2) * 20, points[j][i].z);
					var p:Point = p3dTo2d(p3d);
//					vertices.push(points[j][i].x, points[j][i].z);
					vertices.push(p.x + cx, p.y);
					uv.push(1 / xn * i, 1/ yn * j, points[j][i].z);
				}
			}
			j = 1;
			for (j = 0; j < yn; j ++) {
				for (i = 0; i < xn; i ++) {
					indices.push(j * (xn + 1) + i, j * (xn + 1) + i + 1, (j + 1) * (xn + 1) + i);
					indices.push( j * (xn + 1) + i + 1, (j + 1) * (xn + 1) + i + 1, (j + 1) * (xn + 1) + i);
				}
			}
			
			g.clear();
			//g.lineStyle(0,0xff0000);
			g.beginBitmapFill(texture);
			g.drawTriangles(vertices, indices, uv); 
			g.endFill();
		}
		
		private function createTextField(s:String):TextField {
			var tx:TextField = new TextField();
			var tf:TextFormat = new TextFormat();
			tx.text = s;
			return tx
		}
		
		private function p3dTo2d(p3d:Vector3D):Point {
			var p2d:Point = new Point;
			var ratio:Number = fl / p3d.z; 
			p2d.x = p3d.x * ratio;
			p2d.y = p3d.y * ratio - 100;
			
			return p2d
		}
		
		
	}
}