/**
 * Copyright Geo877 ( http://wonderfl.net/user/Geo877 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iq06
 */

package{
import flash.display.Sprite;
public class Main extends Sprite {
	public function Main(){
		var shapeWriter:Box2DShapeWriter = new Box2DShapeWriter(this, "test", 0xFF0000);
		addChild(shapeWriter);
	}
}

}

import flash.events.*;
import flash.text.*;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.geom.Point;
import flash.ui.Keyboard;
import flash.ui.Mouse;

class Box2DShapeWriter extends Sprite{

public var pointArray:Array = new Array();
public var output:TextField = new TextField();
public var newShape:Boolean = true;
public var getCenter:Boolean = false;
public var shapeSelected:String = "polygon";
public var tempShape:Sprite = new Sprite();
public var spaceDown:Boolean = false;
public var shiftDown:Boolean = false;
public var i:Number;
public var prefix:String;

public var crosshair:Sprite = new Sprite();
public var crosshairLength:int = 7;
public var crosshairColor:uint = 0;


public function Box2DShapeWriter(stage:DisplayObject, prefixVar:String = "shapeWrite", color:uint = 0xFFFFFF){

prefix = prefixVar;

var format:TextFormat = new TextFormat();
format.font = "Arial";
format.color = color;
format.size = 12;

output.defaultTextFormat = format;
output.x = 10;
output.y = 10;
output.width = 300;
output.height = stage.height - 20;
output.appendText("var " + prefix + "Circle:b2CircleDef;\n")
output.appendText("var " + prefix + "Poly:b2PolyDef;\n")
output.appendText("var " + prefix + "Body:b2BodyDef = new b2BodyDef();\n")
addChild(output);
addChild(tempShape);
addChild(crosshair);

addEventListener(MouseEvent.CLICK, spriteClick);
addEventListener(Event.ENTER_FRAME, spriteLoop);
stage.addEventListener(KeyboardEvent.KEY_DOWN, keyIsDown);
stage.addEventListener(KeyboardEvent.KEY_UP, keyIsUp);

graphics.beginFill(0xFFFFFF, 0);
graphics.drawRect(0, 0, stage.width, stage.height);
graphics.endFill();
graphics.lineStyle(1);

}

public function spriteLoop(e:Event):void{

if(shiftDown){
drawPreShape();
drawCrosshair();
}

}

public function drawPreShape():void{
switch(shapeSelected){
case "polygon":
if(!newShape && !getCenter){
if(spaceDown && pointArray.length > 2){
tempShape.graphics.clear();
tempShape.graphics.lineStyle(1);
tempShape.graphics.moveTo(pointArray[pointArray.length-1].x, pointArray[pointArray.length-1].y);
tempShape.graphics.lineTo(pointArray[0].x, pointArray[0].y);
}else{
tempShape.graphics.clear();
tempShape.graphics.lineStyle(1);
tempShape.graphics.moveTo(pointArray[pointArray.length-1].x, pointArray[pointArray.length-1].y);
tempShape.graphics.lineTo(mouseX, mouseY);
}
}
break;

case "circle":
if(!newShape && !getCenter){
var distance:Number = Math.sqrt((mouseX - pointArray[0].x) * (mouseX - pointArray[0].x) + (mouseY - pointArray[0].y) * (mouseY - pointArray[0].y))
tempShape.graphics.clear();
tempShape.graphics.lineStyle(1);
tempShape.graphics.drawCircle(pointArray[0].x, pointArray[0].y, distance);
}
break;
}
}

public function spriteClick(e:Event):void{

if(shiftDown){
switch(shapeSelected){
case "polygon":
if(newShape){
graphics.moveTo(mouseX, mouseY);
tempShape.graphics.moveTo(mouseX, mouseY);
pointArray.push(new Point(mouseX, mouseY));
newShape = false;
}else{
if(spaceDown && pointArray.length > 2){
graphics.lineTo(pointArray[0].x, pointArray[0].y);
crosshairColor = 0xFF0000;
getCenter = true;
}else if(getCenter){

orientPolygon(pointArray);

output.appendText(prefix + "Poly = new b2PolyDef();\n");
output.appendText(prefix + "Poly.vertexCount = " + pointArray.length + ";\n");
//for(i in pointArray){
//output.appendText(prefix + "Poly.vertices[" + i + "].Set(" + (pointArray[i].x - mouseX) + ", " + (pointArray[i].y - mouseY) + ");\n");
//}
output.appendText("//" + prefix + "Poly.density = 0;\n");
output.appendText("//" + prefix + "Poly.friction = 0.2;\n");
output.appendText("//" + prefix + "Poly.localPosition = new b2Vec2(" + mouseX + ", " + mouseY + ");\n");
output.appendText(prefix + "Body.AddShape(" + prefix + "Poly);\n");
output.appendText("//m_world.CreateBody(" + prefix + "Body);\n");

tempShape.graphics.clear();
pointArray.length = 0;
newShape = true;
crosshairColor = 0;
getCenter = false;
}else{
graphics.lineTo(mouseX, mouseY);
tempShape.graphics.moveTo(mouseX, mouseY);
pointArray.push(new Point(mouseX, mouseY));
}
}
break;

case "circle":
if(newShape){
pointArray.push(new Point(mouseX, mouseY));
newShape = false;
}else{
var distance:Number = Math.sqrt((mouseX - pointArray[0].x) * (mouseX - pointArray[0].x) + (mouseY - pointArray[0].y) * (mouseY - pointArray[0].y))
graphics.drawCircle(pointArray[0].x, pointArray[0].y, distance);
newShape = true;

output.appendText(prefix + "Circle = new b2CircleDef();\n");
output.appendText(prefix + "Circle.radius = " + distance + ";\n");
output.appendText("//" + prefix + "Circle.density = 1;\n");
output.appendText("//" + prefix + "Circle.friction = 0.2;\n");
output.appendText("//" + prefix + "Circle.localPosition = new b2Vec2(" + pointArray[0].x + ", " + pointArray[0].y + ");\n");
output.appendText(prefix + "Body.AddShape(" + prefix + "Circle);\n");
output.appendText("//m_world.CreateBody(" + prefix + "Body);\n");
}
break;
}
}

}

public function keyIsDown(e:KeyboardEvent):void{
if(e.keyCode == Keyboard.SPACE){
spaceDown = true;
}
if(e.keyCode == Keyboard.SHIFT){
output.visible = false;
Mouse.hide();
shiftDown = true;
}
}
 public function keyIsUp(e:KeyboardEvent):void{
if(e.keyCode == Keyboard.SPACE){
spaceDown = false;
}
if(e.keyCode == Keyboard.SHIFT){
tempShape.graphics.clear();
crosshair.graphics.clear();
output.visible = true;
Mouse.show();
shiftDown = false;
}
if(e.keyCode == 67){ //C
shapeSelected = "circle";
}
if(e.keyCode == 80){ //P
shapeSelected = "polygon";
}
//trace(e.keyCode);
}

public function orientPolygon(polygonArray:Array):void{
if(orientation2D_Polygon(polygonArray) < 0){
trace("reversed");
polygonArray.reverse();
}
}
public function orientation2D_Polygon(polygonArray:Array):Number{
// first find rightmost lowest vertex of the polygon
var n:int = polygonArray.length
var rmin:int = 0;
var xmin:int = polygonArray[0].x;
var ymin:int = polygonArray[0].y;

for (var i:int=1; i<n; i++) {
if (polygonArray[i].y > ymin){
continue;
}
if (polygonArray[i].y == ymin) { // just as low
if (polygonArray[i].x < xmin){ // and to left
continue;
}
}
rmin = i; // a new rightmost lowest vertex
xmin = polygonArray[i].x;
ymin = polygonArray[i].y;
}

// test orientation at this rmin vertex
// ccw <=> the edge leaving is left of the entering edge
if (rmin == 0){
return( isLeft( polygonArray[n-1], polygonArray[0], polygonArray[1] ) );
}else{
return( isLeft( polygonArray[rmin-1], polygonArray[rmin], polygonArray[rmin+1] ) );
}
}
public function isLeft(P0:Point, P1:Point, P2:Point):Number{
return ( (P1.x - P0.x) * (P2.y - P0.y) - (P2.x - P0.x) * (P1.y - P0.y) );
}

public function drawCrosshair():void{
crosshair.graphics.clear();
crosshair.graphics.lineStyle(1, crosshairColor);
crosshair.graphics.moveTo(mouseX - crosshairLength, mouseY);
crosshair.graphics.lineTo(mouseX + crosshairLength, mouseY);
crosshair.graphics.moveTo(mouseX, mouseY - crosshairLength);
crosshair.graphics.lineTo(mouseX, mouseY + crosshairLength);
}

}

