/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ipEZ
 */

/*
 * Yahoo!Pipesでtwitter簡易ビューア3
 * 
 * http://twitter.com/public_timeline
 * をYahoo!Pipes経由で取得する。
 * 
 * rssだと全てのデータが得られないっぽいので、
 * jsonで取得。
 * 
 * メッセージのリンク先は
 * メッセージ単体表示の画面。
 * リロードなどの機能は無し。
 * 
 * 文字色や背景色は、本人の定義している
 * profile_sidebar_fill_color
 * profile_text_color
 * を使っている。
 * 
 * 課題
 * 画像が読めない場合のエラー対策。
 * 
 * 参考
 * http://blog.flashcast.jp/2008/11/actionscriptjson.html
 * */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	import com.adobe.serialization.json.JSON;
	
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite 
	{
		private var myLoader:URLLoader = new URLLoader();
		public function Main():void 
		{
			myLoader.addEventListener (Event.COMPLETE,COMPLETE);
			myLoader.load(new URLRequest("http://pipes.yahooapis.com/pipes/pipe.run?_id=febf0c71127b8a1538ebe52fb5b30878&_render=json&_rand="+Math.random()));
			
		}
           
		private function COMPLETE(e:Event = null):void 
		{
			var json:Object = JSON.decode(myLoader.data);
			var _length:int = json.value.items[0].status.length;
			var tfY:int = 0;
			for (var i:int = 0; i < _length; i++) {
				var myTextField:TextField = new TextField();
				myTextField.width = 465;
				myTextField.wordWrap = true;
				myTextField.background = true;
				myTextField.backgroundColor = int("0x" + String(json.value.items[0].status[i].user.profile_sidebar_fill_color));
				myTextField.textColor = int("0x" + (json.value.items[0].status[i].user.profile_text_color));
				var imgURL:String = String(json.value.items[0].status[i].user.profile_image_url);
				myTextField.htmlText = "<a href='http://twitter.com/"+json.value.items[0].status[i].user.screen_name+"/status/"+String(json.value.items[0].status[i].id)+"'><img src='"+imgURL.replace(/_normal./,"_mini.")+"' width='24' height='24' /><b>" + json.value.items[0].status[i].user.name + "</b> " + json.value.items[0].status[i].text + "</a>\n";
				myTextField.autoSize = "left";
				myTextField.y = tfY;
				tfY += Math.max(myTextField.height + 1, 41);
				addChild(myTextField);
			}
		}
	}
}