/**
 * Copyright hashito ( http://wonderfl.net/user/hashito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/io2E
 */

// forked from hashito's 文字集まる修正
// MainStage
package {
    import flash.display.Sprite;
    [SWF(frameRate=60,width=456,height=456)]
    public class MainStage extends Sprite {
        public function MainStage(){
            addChild(new Main());
        }
    }
}

import flash.display.*;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.events.*;
import flash.utils.Timer;
import flash.text.TextField;
import flash.text.TextFormat;
import net.hires.debug.Stats;
// debug
class debug{public static var out:TextField=new TextField();}

/*t.hashito*/
class MF{
    public static function AFFORD (x:Number,aim:Number,a:Number):Boolean{return (x<=(a+aim))&&(x>=(a-aim));}
    public static function RAN (n:Number=1):Number{return (Math.random()*n);}
    public static function ISPM (n:Number):Number{if(n<0){return -1;}else if(n>0){return 1;}return 0;}
    public static function MAX (n:Number,max:Number):Number{return (n>max)?max:n;}
    public static function MIN (n:Number,min:Number):Number{return (n<min)?min:n;}
    public static function LIMIT (n:Number,max:Number,min:Number):Number{if(n>max){return max;}else if(n<min){return min;}else{return n};}
    public static function RAD_ANG(n:Number):Number{return n*180/Math.PI}
    public static function ANG_RAD(n:Number):Number{return n*Math.PI/180 }
    public static function LATCH(v:Boolean,s:Boolean,r:Boolean):Boolean{if(s)v=true;if(r)v=false;return v;}
    public static function ONE_SHOT_ON(v:Boolean,o:Boolean):Boolean{var r:Boolean = (v==(!o));o=v;return r;}
    public static function DOT2(x1:Number,y1:Number,x2:Number,y2:Number):Number{return x1 * x2 + y1 * y2; }//内積
    public static function SLOPE(x1:Number,y1:Number,x2:Number,y2:Number):Number{return (y1-y2)/(x1-x2) }//傾き(無限の可能性あり)
    public static function DISTANCE(x1:Number,y1:Number,x2:Number,y2:Number):Number{var a:Number=(x2-x1);var b:Number=(y2-y1);return Math.sqrt(a*a+b*b);}//距離
}

class Main extends Sprite{
    public const H:Number  = 456,W:Number = 456,DFW:Number=W/20,DFH:Number=10,BARW:Number=50,BARH:Number=10;
    public var kal:Boolean =false,kar:Boolean=false,ksp:Boolean;
    public var bar:Shape   = new Shape(),barvx:Number=0;
    public var ball:Shape  = new Shape(),ballvx:Number=0,ballvy:Number=0;
    public var blocks:Sprite = new Sprite();
    public var tx:TextField=new TextField();
    
    // constructor
    public function Main() {addEventListener(Event.ADDED_TO_STAGE, init);}
    
    public function msg(s:String):void{
        tx.text = s;
        tx.x = W/2-tx.textWidth/2;
        tx.y = H/2-tx.textHeight/2;
    }
    // init
    public function init(e:*):void{
        // debug
        // debug.out.autoSize=flash.text.TextFieldAutoSize.LEFT;
        // addChild(debug.out);
        tx.autoSize   = flash.text.TextFieldAutoSize.CENTER;
        tx.selectable = false;
        addChild(tx);
        
        // bar init
        bar.graphics.beginFill(0xff0000);
        bar.graphics.drawRect(0,0,BARW,BARH);
        bar.x = W/2-25;
        bar.y = 400;
        addChild(bar);
        
        // ball init
        ball.graphics.beginFill(0x000000);
        ball.graphics.drawCircle(0,0,2);
        ball.x = W/2;
        ball.y = bar.y - 2;
        addChild(ball);
        
        // blocks init
        var b:Shape;
        for(var xi:int=0;xi<20;xi++){
            for(var yi:int=0;yi<20;yi++){
                b = new Shape();
                b.graphics.beginFill(0x000000);
                b.graphics.drawRect(0,0,DFW,DFH);
                b.graphics.beginFill(0x00ff00);
                b.graphics.drawRect(1,1,DFW-2,DFH-2);
                b.x = DFW*xi;
                b.y = DFH*yi;
                blocks.addChild(b);
            }
        }
        addChild(blocks);
        
        addEventListener(Event.ENTER_FRAME ,ef);
        stage.addEventListener(KeyboardEvent.KEY_DOWN ,key);
        stage.addEventListener(KeyboardEvent.KEY_UP   ,key);
       //stage.addEventListener(MouseEvent.MOUSE_DOWN ,modechg);

        msg("スペースを押してください。");

        var s:Stats = new Stats();
        addChild(s);
    }
    public function key(e:KeyboardEvent=null):void{
        if (e.keyCode == 37) { kal = ( e.type == KeyboardEvent.KEY_DOWN ); }// left
        if (e.keyCode == 39) { kar = ( e.type == KeyboardEvent.KEY_DOWN ); }// right
        if (e.keyCode == 32) { ksp = ( e.type == KeyboardEvent.KEY_DOWN ); }// space
    }
    public var sflag:Boolean=false;    //開始フラグ
    public var oldsflag:Boolean=false; //前の開始フラグ
    public var oldballx:Number=0,oldbally:Number=0; //前ball位置
    public var touchlag:Boolean=true;  //ボールとバー接触フラグ
    
    public function ef(e:Event=null):void{
        sflag = MF.LATCH(sflag,ksp,false);
        
        // goto文の代わりに while to break
        while(1){
            if(blocks.numChildren==0){
                msg("お疲れ様でした。\r\n終了です。")
                return;
            }
            
            // バーの速度の加算
            if(kal){barvx -= 1;}
            if(kar){barvx += 1;}
            barvx = MF.LIMIT(barvx,5,-5);//バー速度制限
            
            // バーの動きの制限
            if((bar.x <= 0    )&&(barvx < 0)){
                barvx = 0;
            }
            if((bar.x >= W-50 )&&(barvx > 0)){
                barvx = 0;
            }
            
            bar.x  += barvx;
            bar.x   = MF.LIMIT(bar.x,W-50,0);
            
            // 開始していない場合 ボールも同様の動きをして終了
            if(!sflag){
                ball.x += barvx;
                break;
            }
            
            // 開始後一回だけ実行
            if(MF.ONE_SHOT_ON(sflag,oldsflag)){
                // yはx方向の移動速度が速いほど遅く設定
                ballvy = Math.abs(barvx)-7;
                if(ballvy > -1)ballvy-=1;
                msg("");
            }
            
            // bar衝突確認
            if(bar.hitTestObject(ball)){
                //右から衝突
                if(ballvx<=0){
                    if(oldballx > (BARW+bar.x)){
                        ballvx=-ballvx;
                        ball.x=(BARW+bar.x)
                    }else{
                        ballvy=-ballvy;
                        ball.y=(bar.y)-1;
                    }
                //左から衝突
                }else{
                    if(oldballx < (bar.x)){
                        ballvx=-ballvx;
                        ball.x=(bar.x)
                    }else{
                        ballvy=-ballvy;
                        ball.y=(bar.y)-1;
                    }
                }
                touchlag = true;
            }
            // ブロック衝突確認
            if(blocks.hitTestObject(ball)){
                var max:int = blocks.numChildren;
                for(var i:int=0;i<max;i++){
                    var b:DisplayObject = blocks.getChildAt(i);
                    if(b.hitTestObject(ball)){
                        //右から衝突
                        if(ballvx<=0){
                            if(oldballx > (DFW+b.x)){// 前ボールの位置がブロックより右だった時
                                ballvx=-ballvx;
                                ball.x=(DFW+b.x)
                            }else{
                                ballvy=-ballvy;
                                if(oldbally < (b.y)){
                                    ball.y=(b.y)
                                }else{
                                    ball.y=(b.y+DFH)
                                }
                            }
                        //左から衝突
                        }else{
                            if(oldballx < (b.x)){
                                ballvx=-ballvx;
                                ball.x=(b.x)
                            }else{
                                ballvy=-ballvy;
                                if(oldbally < (b.y)){
                                    ball.y=(b.y)
                                }else{
                                    ball.y=(b.y+DFH)
                                }
                            }
                        }
                        blocks.removeChild(b);
                        break;
                    }
                }
            }
            
            // 加速
            ballvx = MF.LIMIT(ballvx,5,-5);
            ballvy = MF.LIMIT(ballvy,5,-5);
            ball.x +=ballvx;
            ball.y +=ballvy;
            
            // 壁衝突確認
            if(ball.x < 0){ball.x=0; ballvx=-ballvx;}
            if(ball.y < 0){ball.y=0; ballvy=-ballvy;}
            if(ball.x > W){ball.x=W; ballvx=-ballvx;}
            if(ball.y > H){
                //end
                //ball.y=H; ballvy=-ballvy;
                msg("スペースで再スタート");
                bar.x = W/2-25;
                bar.y = 400;
                ball.x = W/2;
                ball.y = bar.y - 2;
                sflag=false;
            }
            
            
            // 跳ね返り後
            if(touchlag){
                touchlag = false;
                ballvx  += barvx;//速度加算
            }
            
            // 無限に早くならないように・・・
            if(Math.abs(ballvx)>2)ballvx*=0.999;
            if(Math.abs(ballvy)>2)ballvy*=0.999;
            
            break;
        }
        oldsflag = sflag;
        oldballx = ball.x;
        oldbally = ball.y;
        
        
        //debug.out.text="x="+t.bits[0].x+" y="+t.bits[0].y+" vx="+t.bits[0].vx+" vy="+t.bits[0].vy+" ax="+t.bits[0].ax+" ay="+t.bits[0].ay;
    }
}

