/**
 * Copyright checkmate ( http://wonderfl.net/user/checkmate )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/inmV
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.net.*;
	import flash.system.*;
	import jp.progression.commands.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.display.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.events.*;
	
	import caurina.transitions.*;
	public class Professional extends Sprite {
		public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf";
		
		public var stayMotion:MovieClip;
		public var jumpMotion:MovieClip;
		public var highJumpMotion:MovieClip;
		public var walkMotion:MovieClip;
		public var runMotion:MovieClip;
		public var squatMotion:MovieClip;
		public var questionMotion:MovieClip;
		public var exclamationMotion:MovieClip;
		public var heartMotion:MovieClip;
		public var poutMotion:MovieClip;
		public var starMotion:MovieClip;
		public var singMotion:MovieClip;
		public var sleepMotion:MovieClip;
		public var wakeMotion:MovieClip;
		
		
		public function Professional (){
			super();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var com:SerialList = new SerialList();
			com.addCommand(
				new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
				function():void {
					var loader:Loader = Loader( this.latestData );
					var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
					
					stayMotion = new ( domain.getDefinition( "StayMotion" ) as Class );
					jumpMotion = new ( domain.getDefinition( "JumpMotion" ) as Class );
					highJumpMotion = new ( domain.getDefinition( "HighJumpMotion" ) as Class );
					walkMotion = new ( domain.getDefinition( "WalkMotion" ) as Class );
					runMotion = new ( domain.getDefinition( "RunMotion" ) as Class );
					squatMotion = new ( domain.getDefinition( "SquatMotion" ) as Class );
					questionMotion = new ( domain.getDefinition( "QuestionMotion" ) as Class );
					exclamationMotion = new ( domain.getDefinition( "ExclamationMotion" ) as Class );
					heartMotion = new ( domain.getDefinition( "HeartMotion" ) as Class );
					poutMotion = new ( domain.getDefinition( "PoutMotion" ) as Class );
					starMotion = new ( domain.getDefinition( "StarMotion" ) as Class );
					singMotion = new ( domain.getDefinition( "SingMotion" ) as Class );
					sleepMotion = new ( domain.getDefinition( "SleepMotion" ) as Class );
					wakeMotion = new ( domain.getDefinition( "WakeMotion" ) as Class );
					
				}
			);
			com.addEventListener(ExecuteEvent.EXECUTE_COMPLETE,onLoadSWF);
			com.execute();
		}
		private function onLoadSWF(e:Event):void {
			var motionList:Array = [
				stayMotion,
				jumpMotion,
				highJumpMotion,
				walkMotion,
				runMotion,
				squatMotion,
				questionMotion,
				exclamationMotion,
				heartMotion,
				poutMotion,
				starMotion,
				singMotion,
				sleepMotion,
				wakeMotion
			];
			
			var hNum:int = 4;
			var cnt:int = 0;
			for each( var motion:MovieClip in motionList ) {
				addChild(motion);
				motion.x = cnt%hNum * 112 + 70;
				motion.y = Math.floor(cnt/hNum) * 112  + 80;
				
				motion.gotoAndStop(1);
				motion.addEventListener( MouseEvent.CLICK, clickHandler );
				motion.buttonMode = motion.useHandCursor = true;
				
				cnt++;
			}
		}
		private function clickHandler(e:Event):void {
			var motion:MovieClip = e.currentTarget as MovieClip;
			
			motion.gotoAndPlay(1);
                        // A way of rolling.
                        motion.wc2.wc3.gotoAndPlay(2);
		}
	}
}