/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/inXk
 */

// forked from bkzen's forked from: mxmlベースで制作した場合の再描画タイミング実験
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.utils.Timer;
    /**
     * forked from tail_y's mxmlベースで制作した場合の再描画タイミング実験
     * FPSは0.3
     * マウスイベントは一切取ってないけど、クリックすると再描画されている。
     * flexベースでASを使用してプロジェクト組んでると、
     * 遷移時に画面がチラつくなどの表示バグの原因になる。
     * 実行速度低下の原因にもなるかも。
     */
    public class Test extends Sprite
    {
        private static const FPS: Number = 0.3;
        private static const TPS: Number = 10;
        private var tf: TextField;
        private var timer: Timer;
        private var frameCircle: Sprite;
        private var timerCircle: Sprite;
        private var frameCount: int;
        private var timerCount: int;
        
        public function Test() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            stage.frameRate = FPS;
            addChild(tf = new TextField());
            tf.width = 200;
            addChild(frameCircle = createCicle(0, 200, 0xFF8855));
            addChild(timerCircle = createCicle(0, 300, 0x88FF55));
            addEventListener(Event.ENTER_FRAME, frameHandler);
            timer = new Timer(1000 / TPS);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            //mouseChildren = false;
        }
        
        private function frameHandler(e:Event):void 
        {
            frameCount = timerCount;
            frameCircle.x = timerCircle.x;
            draw();
        }
        
        private function timerHandler(e:TimerEvent):void 
        {
            timerCount ++;
            timerCircle.x = (timerCircle.x + 5) % 400;
            draw();
        }
        
        private function draw():void 
        {
            var str: String = "";
            str += "クリックすると\n画面が再描画されている？\n";
            str += "frmaeCount=" + frameCount + "\n";
            str += "timerCount=" + timerCount + "\n";
            tf.text = str;
        }
        
        private function createCicle(x: Number, y: Number, color: uint): Sprite
        {
            var ans: Sprite = new Sprite();
            ans.graphics.beginFill(color);
            ans.graphics.drawCircle(0, 0, 20);
            ans.x = x, ans.y = y;
            return ans;
        }
    }

}