/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/inSm
 */

package {

    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;

    public class Game extends Sprite {
        private var _scoreTextField : TextField;
        private var _score : int;
        private var _cards : Array;
        private var _openCardCount : int;
        private var _openCard1 : Card;
        private var _openCard2 : Card;

        public function Game() : void {
            if (stage) _initialize();
            else addEventListener(Event.ADDED_TO_STAGE, _initialize);
        }

        /**
         * _initialize
         */
        private function _initialize(e : Event = null) : void {
            removeEventListener(Event.ADDED_TO_STAGE, _initialize);


            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;

            // スコア
            _scoreTextField = new TextField();
            score = 10;
            addChild(_scoreTextField);

            // カード
            _openCardCount = 0;
            var offsetX : int = 0;
            var offsetY : int = 40;
            var margin : int = 5;
            var cardCount : int = 0;
            var cardPattern : Array = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
             cardPattern = shuffle(cardPattern);
            _cards = new Array();
            for (var dx : int = 0; dx < 8; dx++) {
                for (var dy : int = 0; dy < 3; dy++) {
                    trace(cardPattern[cardCount]);
                    var card : Card = new Card(cardCount, cardPattern[cardCount]);
                    card.x = dx * (card.width + margin) + offsetX + card.width * 0.5;
                    card.y = dy * (card.height + margin) + offsetY + card.height * 0.5;
                    //カードイベント
                    card.addEventListener(CompoEvent.CARDCOPEN, onCardOpen);
                    card.addEventListener(CompoEvent.CARDCLOSE, onCardClose);
                    // カードを配列に代入
                    _cards.push(card);
                    addChild(card);
                    cardCount++;
                }
            }

            // ゲーム開始処理
            addEventListener(CompoEvent.START, opened);
            // デバッグ用（ベースと繋げるときはコメントアウト
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
        }
        /**
         * カードが閉じた時
         */
        private function onCardClose(event : CompoEvent) : void {
        }

        /**
         * カードが開いた時
         */
        private function onCardOpen(event : CompoEvent) : void {
            if(_openCard1 == null){
                _openCard1 = event.target as Card;
            }else{
                _openCard2 = event.target as Card;
                //カード判定
                checkCard();
            }
        }

        
        /**
         * カード判定
         */
        private function checkCard() : void {
            if (_openCard1 == null || _openCard2 == null) return;
            trace(_openCard1.pattern,_openCard2.pattern);
            if (_openCard1.pattern == _openCard2.pattern) {
                //同じ柄だった場合スコアアップ
                score++;
                //そろったカードスコアアップ（+2
                _openCardCount += 2;
            }else{
                //違った場合スコアダウン
                score --;
                //両方のカード閉じる
                _openCard1.close();
                _openCard2.close();
            }
            _openCard1 = _openCard2 = null;
            
        }

        private function onStageMouseDown(event : MouseEvent) : void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
            addEventListener(Event.ENTER_FRAME, _updateHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDownChangeFPS);
        }

        private function onStageMouseDownChangeFPS(event : MouseEvent) : void {
            if (stage.frameRate < 60) {
                stage.frameRate = 60;
            } else {
                stage.frameRate = 30;
            }
        }

        private function opened(event : CompoEvent) : void {
            addEventListener(Event.ENTER_FRAME, _updateHandler);
        }

        private function _updateHandler(e : Event) : void {
            _interaction();
//            _draw();
        }

        /**
         * インタラクションの反映
         */
        private function _interaction() : void {
            // ゲームエンド判定
            checkGameEnd();
        }

        /**
         * ゲームエンド判定
         */
        private function checkGameEnd() : void {
            // 全部カードそろった？
            if (_openCardCount >= _cards.length) {
                removeEventListener(Event.ENTER_FRAME, _updateHandler);
                dispatchEvent(new CompoEvent(CompoEvent.END, score));
                // スコアがマイナス？
            } else if (score < 0) {
                removeEventListener(Event.ENTER_FRAME, _updateHandler);
                dispatchEvent(new CompoEvent(CompoEvent.END, score));
            }
        }

        /**
         * カードのシャッフル
         */
        private function shuffle(arr : Array) : Array {
            var l : int = arr.length;
            var newArr : Array = arr;
            while (l) {
                var m : int = Math.floor(Math.random() * l);
                var n : Object = newArr[--l];
                newArr[l] = newArr[m];
                newArr[m] = n;
            }
            return newArr;
        }

        public function get score() : int {
            return _score;
        }

        public function set score(score : int) : void {
            _score = score;
            _scoreTextField.text = String(_score);
        }
    }
}

    import flash.events.MouseEvent;
    import a24.tween.events.Tween24Event;
    import a24.tween.Tween24;

    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;
    import flash.display.Sprite;

    /**
     * @author fumix
     */
    class Card extends Sprite {
        private var _id : int;
        private var cardWidth : int = 52;
        private var cardHeight : int = 279 * cardWidth / 200;
        private var _pattern : int;
        private var _tf : TextField;
        private var _tween : Tween24;

        public function Card(id : int, pattern : int) {
            this.id = id;
            this.pattern = pattern;
            buttonMode = true;

            // カード
            graphics.lineStyle(1, 0x999999);
            graphics.beginFill(0xCCCCCC);
            graphics.drawRect(-Math.floor(cardWidth * 0.5), -Math.floor(cardHeight * 0.5), cardWidth, cardHeight);
            graphics.endFill();
            // カードのパターン表示部
            _tf = new TextField();
            _tf.selectable = false;
            _tf.mouseEnabled = false;
            _tf.autoSize = TextFieldAutoSize.LEFT;
            _tf.text = String(pattern);
            _tf.visible = false;
            addChild(_tf);
            //マウスイベント
            addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }

        private function onMouseUp(event : MouseEvent) : void {
            open();
        }

        public function open() : void {
            //オープン中はマウスイベント切る
            removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);    
            buttonMode = false;
            _tween = Tween24.tween(this, 0.3).alpha(0.5);
            _tween.addEventListener(Tween24Event.COMPLETE, onCompleteOpen);
            _tween.play(true);
        }
        private function onCompleteOpen(event : Tween24Event) : void {
            _tf.visible = true;
            _tween.removeEventListener(Tween24Event.COMPLETE, onCompleteOpen);
            dispatchEvent(new CompoEvent(CompoEvent.CARDCOPEN,pattern));
        }

        public function close() : void {
            _tween = Tween24.serial(
                Tween24.wait(0.5),
                Tween24.tween(this, 0.3).alpha(1.0)
            );
            _tween.addEventListener(Tween24Event.COMPLETE, onCompleteClose);
            _tween.play(true);
        }
        private function onCompleteClose(event : Tween24Event) : void {
            //クローズ確定でマウスイベント復活
            addEventListener(MouseEvent.MOUSE_UP, onMouseUp);    
            buttonMode = true;
            _tf.visible = false;
            _tween.removeEventListener(Tween24Event.COMPLETE, onCompleteClose);
            dispatchEvent(new CompoEvent(CompoEvent.CARDCLOSE,pattern));
        }


        public function get pattern() : int {
            return _pattern;
        }

        public function set pattern(pattern : int) : void {
            _pattern = pattern;
        }

        public function get id() : int {
            return _id;
        }

        public function set id(id : int) : void {
            _id = id;
        }

    }
    
    import flash.events.Event;

    class CompoEvent extends Event {
        // プロパティ
        public static const START:String = "start";
        public static const END:String = "end";
        public static const SELECT:String = "select";
        public static const CHANGE:String = "change";
        public static const CARDCOPEN:String = 'open';
        public static const CARDCLOSE:String = 'close';
        public var value:*;

        // コンストラクタ
        public function CompoEvent(type:String, value:*) {
            super(type);
            this.value = value;
        }

        // メソッド
        override public function clone():Event {
            return new CompoEvent(type, value);
        }

    }
