/**
 * Copyright EGO ( http://wonderfl.net/user/EGO )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/inNu
 */

// photo by:
// http://www.flickr.com/photos/51190245@N02/5061024361/in/photostream/ (by 5656life)
//

package {
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.system.Security;
    
    public class InfiniteLoopImage extends Sprite {
        
        private var stageW:Number;
        private var stageH:Number;
        private var vx:int = -5;
        
        private var bai:Number;
        private var baseW:Number;
        
        private var imgURL1:String = "http://farm5.static.flickr.com/4088/5061642526_6d16887199_z.jpg";
        private var imgURL2:String = "http://farm5.static.flickr.com/4131/5061024361_301f44dd91_z.jpg";
        private var imgURL3:String = "http://farm5.static.flickr.com/4108/5061633456_b3dba51743_z.jpg";
        
        private var imgURLs:Array = new Array(imgURL1, imgURL2, imgURL3);
        private var imgs:Array;
        
        private var lImg:LoadImgs;
        private var _mcs:Array = new Array();
        
        public function InfiniteLoopImage() {
            Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm5.static.flickr.com/crossdomain.xml");
            
            stageW = stage.stageWidth;
            stageH = stage.stageHeight;
            
            lImg = new LoadImgs(imgURLs);
            lImg.addEventListener(LoadImgs.ALL_LOAD, _loadComp);
        }
        
        private function _loadComp(e:Event):void{
            imgs = lImg.imgs;
            SetImg();
        }
        
        private function SetImg():void{
            bai = stageH / imgs[0].bitmapData.height;
            baseW = imgs[0].bitmapData.width * bai;
            for(var i:int = 0; i < imgs.length; i++){
                var _mc:MovieClip = new MovieClip();
                _mcs.push(_mc);
                _mc.addChild(imgs[i]);
                _mc.height = stageH;
                _mc.width = baseW;
                _mc.x = i * baseW;
                _mc.y = 0;
                addChild(_mc);
            }
            stage.addEventListener(Event.ENTER_FRAME, onEFrame);
        }
        
        private function onEFrame(e:Event):void{
            for(var j:int = 0; j < _mcs.length; j++){
                _mcs[j].x += vx;
                if(_mcs[j].x < -baseW){
                    if(j == 0){
                        _mcs[j].x = _mcs[_mcs.length - 1].x + baseW + vx;
                    }else{
                        _mcs[j].x = _mcs[j - 1].x + baseW + vx;
                    }
                }
            }
        }

    }
}

import flash.display.MovieClip;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.events.Event;
import flash.system.LoaderContext;
internal class LoadImgs extends MovieClip{
    
    private var imgURLs:Array;
    private var imgNum:int = 0;
    
    private var loaderList:Array = new Array();    
    public var imgs:Array = new Array();
    public static const ALL_LOAD:String = "allLoad";
    
    public function LoadImgs(urls:Array){
        var myLoaderContext:LoaderContext = new LoaderContext(true);
        imgURLs = urls;
        LoadStart();
    }
    
    private function LoadStart():void{
        loaderList[imgNum] = new Loader();
        loaderList[imgNum].contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
        loaderList[imgNum].load(new URLRequest(imgURLs[imgNum]));
    }
    
    private function onImageLoaded(e:Event):void{
        imgs.push(e.target.content);
        imgNum++;
        if(imgNum < imgURLs.length){
            LoadStart();
        }else{
            EndLoad();
        }
    }
    
    private function EndLoad():void{
        dispatchEvent(new Event(ALL_LOAD));
    }

}

