/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/inHX
 */

/*
 * 前回のゆらゆらさせるやつを
 * WEBカメラの映像に適応できないかな？と。
 * 
 * DisplacementMapFilter
 * */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.net.*;
	import flash.system.*;
	import flash.text.*;
	
    public class test extends Sprite {
		//かけるフィルタよう
		private var translate:int = 0;
		private var dpm_filter:DisplacementMapFilter;
		private var rSeed:Number = 0;
		private var mapBmd:BitmapData;
		
		//カメラ用
		private var _canvas:BitmapData;
		private var _mirror:Matrix;
		private var _video:Video;
		private var _bm:Bitmap;
		
        public function test() {
			var _camera:Camera = Camera.getCamera();
			
			//カメラがない
			if (_camera == null) {
				return;
			}
			
			//カメラの設定
			_camera.setMode(stage.stageWidth, stage.stageHeight, stage.frameRate);
			_video = new Video(300, 300);
			_video.attachCamera(_camera);
			_video.x = stage.stageWidth / 2;
			_video.y = stage.stageHeight / 2;
			
			//映像を流し込むbitmap
			_canvas= new BitmapData(stage.stageWidth, stage.stageHeight);
			_bm = new Bitmap(_canvas);
			addChild(_bm);
			
			//中央配置
			_bm.x = stage.stageWidth / 2 - _video.width / 2;
			_bm.y = stage.stageHeight / 2 - _video.height / 2;
			
			//映像を反転
			_mirror = new Matrix();
			_mirror.scale( -1, 1);//scale(sx,sy) X方向にsx倍,Y方向にsy倍
			_mirror.translate(_video.width, 0);
			
			addEventListener(Event.ENTER_FRAME, onEF);
			
			//フィルタ適応
			filter_set();
			
        }
		
		private function onEF(e:Event):void 
		{
			//bitmapに流し込む＆反転のマトリックスをかける。
			_canvas.draw(_video, _mirror);
			
			//なみなみさせる関数
			wave();
		}
		
		private function filter_set():void
		{
			//フィルタをかける用
			mapBmd = new BitmapData(_bm.width,_bm.height);
			
			/*
			 * DisplacementMapFilterの設定
			 * */
			dpm_filter = new DisplacementMapFilter();
		//mapBitmap 置き換えマップイメージを示す
			dpm_filter.mapBitmap = mapBmd;
		//mapPoint 左上を基準とした場合の置き換えマップイメージの左上座標を軸に
			dpm_filter.mapPoint = new Point(0, 0);
		//componentX/Y 置き換えに使用するカラーチャンネル　8=alpha
			dpm_filter.componentX = 8;
			dpm_filter.componentY = 8;
		//scaleX/Y　効果を拡大縮小する係数
			dpm_filter.scaleX = 100;
			dpm_filter.scaleY = 100;
		//フィルタのモード
			dpm_filter.mode = DisplacementMapFilterMode.COLOR;
		//範囲外置き換えに使う代替カラー
			dpm_filter.color = 0x000000;
		//範囲外のアルファ
			dpm_filter.alpha = 0;
			
			rSeed = new Date().getTime();
		}
		
		private function wave():void
		{
			//ぱたぱたするスピード
			translate += 30;
			
			var pt:Point = new Point(translate, 0);
			
			mapBmd.perlinNoise(
				_bm.width,
				_bm.height,
				2,
				rSeed,
				true,
				true,
				BitmapDataChannel.RED | BitmapDataChannel.BLUE | BitmapDataChannel.GREEN | BitmapDataChannel.ALPHA,
				false,
				[pt, pt]
			);
			
			_bm.filters = [dpm_filter];
		}
    }
}