/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/inBy
 */

// forked from hankuro's ＧＵＮＤＡＭ
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
        import net.hires.debug.Stats;
	
	[SWF (width = "500", height = "500", backgroundColor = "0x000000", frameRate = "30")]
	
	/**
	 *  ここ数カ月かけてjavaで３Ｄのフロントエンドツールを作成した。このツールの使い勝手はイマイチだが、がんばって2Dのガンダム
	 * 　画像を手本にガンダムヘッドを作成してみた。結果５０００ポリゴンを超えた大作になってしまった。（私はデザイナーではないので
	 * 　、ガンダムヘッドが不格好になってしまったことに対しては、ガンダムファンに深く謝罪いたします）
	 * 　さて、作成したガンダムヘッドをflashに移植すべく、papervision3dをAPIとしたが、予想通り、移植に失敗した。
	 * 　しかたなく、自作で簡易APIを作成し、フラットシェーディングで回転させることができた。これで止めておけばよかったが、
	 * 　無謀にもグーローシェーディングにも挑戦してみた。結果は？。
	 * 
	 * 　「課題」
	 * 　自作のjavaのツールをフロントエンドとし、flashをバックエンドととした、作品をこれから手掛けて行きたい。
	 * 
	 * 　「ひとりごと」
	 * 　５０過ぎてからJavaとActionscript3.0を独学したジジィとしては、このガンダムヘッドに関しては、なんとなく達成感を
	 * 　感じている。
	 * 
	 * 　「参考文献」
	 * 　・ActionScript3.0 アニメーション　Keith Peters著
	 * 　・実例で学ぶゲーム3D数学　Fletcber Dunn & Ian Parberry著
	 *  ・3Dグラフィックスのための数学 大川　善邦著
	 * 　・Javaによる簡単実習3次元CG入門　小笠原　祐治著
	 **/
	
	public class Main extends Sprite 
	{
		public var t:Number = 0;
		private var vpX:Number = stage.stageWidth / 2;
		private var vpY:Number = stage.stageHeight / 2;	
		public var timer:Timer;
		public var menu:Menu = new Menu();
		
		public function Main() 
		{
			trace("run");
			Static_data.light = new Light(0,0,1000);
			for (var i:Number = 0; i < Static_data.world_cordinate.length; i++) {
				Static_data.world_cordinate[i] = new Array(3);
				Static_data.screen_cordinate[i] = new Array(5);
				for (var j:Number = 0; j < 3; j++) {
					Static_data.world_cordinate[i][j] = new Array(3);
					Static_data.screen_cordinate[i][j] = new Array(2);
				}
			}
			Static_proc.setVanishingPoint(vpX, vpY);
			Static_proc.setCenter(0, 0, 100);
			Static_proc.init_scr();
			this.addChild(menu);
			timer = new Timer(10);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();

                        addChild(new Stats());
		}
		private function onTimer(evt:TimerEvent):void {
			t += 0.1;
			var i:uint , j:uint;
			if (Static_data.z_buf) {
				Static_proc.scr_make();
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					for ( j = 0; j < 3; j++) {
						if (!Static_data.rotate) Static_proc.rotateX(t, i, j);
						else Static_proc.rotateY(t, i, j);
						Static_proc.screenXY(i, j);
					}				
					Static_proc.max_z(i);
				}
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					Static_proc.z_buffer(i);
				}
				this.graphics.beginBitmapFill(Static_data.scr);
				this.graphics.moveTo(0, 0);
				this.graphics.lineTo(0, Static_data.scr_height);
				this.graphics.lineTo(Static_data.scr_width, Static_data.scr_height);
				this.graphics.lineTo(Static_data.scr_width, 0);
				this.graphics.lineTo(0, 0);
				this.graphics.endFill();
			}else {
  				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					for (j = 0; j < 3; j++) {
						if (!Static_data.rotate) Static_proc.rotateX(t, i, j);
						else Static_proc.rotateY(t, i, j);
						Static_proc.screenXY(i, j);
					}
					Static_proc.max_z(i);
					Static_data.screen_cordinate[i][4] = i;
				}
				Static_proc.z_sort();
				this.graphics.clear();
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					if (!Static_data.wire) Static_proc.draw(this.graphics, i);
					else Static_proc.draw_wire(this.graphics,i);
				}
			}
		}
	}
	
}
	class Light
	{
		public var x:Number;
		public var y:Number;
		public var z:Number;
		private var _brightness:Number;
		
		public var triangle_data:Object;
		
		private var color:uint;
		
		public function Light(x:Number = -100, y:Number = -100, z:Number = -100, brightness:Number = 1)
		{
			this.x = x;
			this.y = y;
			this.z = z;
			this.brightness = brightness;

		}
		public function set_Light_point(x:Number , y:Number , z:Number):void{
			this.x = x;
			this.y = y;
			this.z = z;
		}
		
		public function set brightness(b:Number):void
		{
			_brightness = Math.max(b, 0);
			_brightness = Math.min(_brightness, 1);
		}
		
		public function get brightness():Number
		{
			return _brightness;
		}
		
	}
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	class Menu extends Sprite
	{
		public var Flat:Sprite = new Sprite();
		public var Gouraud:Sprite = new Sprite();
		public var Wire:Sprite = new Sprite();
		public var RotationX:Sprite = new Sprite();
		public var RotationY:Sprite = new Sprite();
		public var Flat_text:TextField = new TextField();
		public var Flat_format:TextFormat = new TextFormat();
		public var Gouraud_text:TextField = new TextField();
		public var Gouraud_format:TextFormat = new TextFormat();
		public var Wire_text:TextField = new TextField();
		public var Wire_format:TextFormat = new TextFormat();
		public var RotationX_text:TextField = new TextField();
		public var RotationX_format:TextFormat = new TextFormat();
		public var RotationY_text:TextField = new TextField();
		public var RotationY_format:TextFormat = new TextFormat();
		
		public function Menu() 
		{
			Flat_text.text = "Flat Shading";
			Flat_format.color = 0xFFFFFF;
			Flat_text.setTextFormat(Flat_format);
			Flat.addChild(Flat_text);
			Gouraud_text.text = "Gouraud Shading";
			Gouraud_format.color = 0xFFFFFF;
			Gouraud_text.setTextFormat(Gouraud_format);
			Gouraud.addChild(Gouraud_text);
			Wire_text.text = "Wire";
			Wire_format.color = 0xFFFFFF;
			Wire_text.setTextFormat(Wire_format);
			Wire.addChild(Wire_text);
			RotationX_text.text = "RotationX";
			RotationX_format.color = 0xFFFFFF;
			RotationX_text.setTextFormat(RotationX_format);
			RotationX.addChild(RotationX_text);
			RotationY_text.text = "RotationY";
			RotationY_format.color = 0xFFFFFF;
			RotationY_text.setTextFormat(RotationY_format);
			RotationY.addChild(RotationY_text);
			Flat.x = Gouraud.x = Wire.x = RotationX.x = RotationY.x = 20;
			Flat.y = 20;
			Gouraud.y = 40;
			Wire.y = 60;
			RotationX.y = 80;
			RotationY.y = 100;
			this.addChild(Flat);
			this.addChild(Gouraud);
			this.addChild(Wire);
			this.addChild(RotationX);
			this.addChild(RotationY);
			Flat.addEventListener(MouseEvent.CLICK, onFlat);
			Flat.buttonMode = true;
			Gouraud.addEventListener(MouseEvent.CLICK, onGouraud);
			Gouraud.buttonMode = true;
			Wire.addEventListener(MouseEvent.CLICK, onWire);
			Wire.buttonMode = true;
			RotationX.addEventListener(MouseEvent.CLICK, onRotationX);
			RotationX.buttonMode = true;
			RotationY.addEventListener(MouseEvent.CLICK, onRotationY);
			RotationY.buttonMode = true;
		}
		public function onFlat(evt:MouseEvent):void {
			Static_data.z_buf = false;
			Static_data.wire = false;
		}
		public function onGouraud(evt:MouseEvent):void {
			Static_data.z_buf = true
			Static_data.wire = false;
		}		
		public function onWire(evt:MouseEvent):void {
			Static_data.wire = true;
			Static_data.z_buf = false;
		}
		public function onRotationX(evt:MouseEvent):void {
			Static_data.rotate = false;
		}
		public function onRotationY(evt:MouseEvent):void {
			Static_data.rotate = true;
		}
	}
	class Point3D 
	{
		public var x:Number;
		public var y:Number;
		public var z:Number;
		public function Point3D(x:Number=0,y:Number=0,z:Number=0) 
		{
			this.x = x;
			this.y = y;
			this.z = z;
		}
		
	}
	class Vec 
	{
		public var point:Array = new Array(3);
		public var N:Point3D;
		public var V:Point3D;
		public var L:Point3D;
		public var R:Point3D;
		
		public function Vec(f:Point3D,s:Point3D,t:Point3D,n:Number) 
		{
			point[0] = new Point3D(f.x, f.y, f.z);
			point[1] = new Point3D(s.x, s.y, s.z);
			point[2] = new Point3D(t.x, t.y, t.z);
			n_comp();
			v_comp(n);
			l_comp(n);
			r_comp();
		}
		public function n_comp():void {
			var ab:Object = new Object();
			N = new Point3D();
			ab.x = point[0].x - point[1].x;
			ab.y = point[0].y - point[1].y;
			ab.z = point[0].z - point[1].z;
			
			var bc:Object = new Object();
			bc.x = point[1].x - point[2].x;
			bc.y = point[1].y - point[2].y;
			bc.z = point[1].z - point[2].z;
			
			var norm:Object = new Object();
			N.x = (ab.y * bc.z) - (ab.z * bc.y);
			N.y = -((ab.x * bc.z) - (ab.z * bc.x));
			N.z = (ab.x * bc.y) - (ab.y * bc.x);
		}
		public function v_comp(n:Number):void {
			V = new Point3D();
			V.x = point[n].x - 500;
			V.y = point[n].y - 500;
			V.z = point[n].z - 500;
		}
		public function l_comp(n:Number):void {
			L = new Point3D();
			L.x = point[n].x - Static_data.light.x;
			L.y = point[n].y - Static_data.light.y;
			L.z = point[n].z - Static_data.light.z;
		}
		public function r_comp():void {
			R = new Point3D();
			var n:Number = (N.x * L.x + N.y * L.y + N.z * L.z) * 2;
			R.x = L.x - n * N.x;
			R.y = L.y - n * N.y;
			R.z = L.z - n * N.z;
		}
		
	}
	import flash.display.Graphics;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	/**
	 * ...
	 * @author ...
	 */
	class Static_proc 
	{
		public static function rotateX(angleX:Number,row:Number,column:Number):void
		{
			var cos:Number = Math.cos(angleX);
			var sin:Number = Math.sin(angleX);
			
			Static_data.xRotMatrix[0] = [1,    0,   0];
			Static_data.xRotMatrix[1] = [0,  cos, sin];
			Static_data.xRotMatrix[2] = [0, -sin, cos]
			
			Static_data.position = Static_data.local_cordinate[row][column];			
			Static_data.world_cordinate[row][column] = matrixMultiply(Static_data.position, Static_data.xRotMatrix);
		
		}
		
		public static function rotateY(angleY:Number,row:Number,column:Number):void
		{
			var cos:Number = Math.cos(angleY);
			var sin:Number = Math.sin(angleY);
			
			Static_data.yRotMatrix[0] = [ cos, 0, sin];
			Static_data.yRotMatrix[1] = [   0, 1,   0];
			Static_data.yRotMatrix[2] = [ -sin, 0, cos];
			
			Static_data.position = Static_data.local_cordinate[row][column];
			Static_data.world_cordinate[row][column] = matrixMultiply(Static_data.position, Static_data.yRotMatrix);
		}
		
		public static function rotateZ(angleZ:Number,row:Number,column:Number):void
		{
			var cos:Number = Math.cos(angleZ);
			var sin:Number = Math.sin(angleZ);
			
			Static_data.zRotMatrix[0] = [  cos, sin,   0];
			Static_data.zRotMatrix[1] = [ -sin, cos,   0];
			Static_data.zRotMatrix[2] = [    0,   0,   0];
			
			Static_data.position = Static_data.local_cordinate[row][column];
			Static_data.world_cordinate[row][column] = matrixMultiply(Static_data.position, Static_data.zRotMatrix);
		}
		public static function scale(num:Number,x:Number, y:Number,z:Number,row:Number,column:Number):void
		{
			Static_data.zRotMatrix[0] = [  x,  0,  0];
			Static_data.zRotMatrix[1] = [  0,  y,  0];
			Static_data.zRotMatrix[2] = [  0,  0,  z];
			
			Static_data.position = Static_data.local_cordinate[row][column];
			var result:Array = matrixMultiply(Static_data.position, Static_data.xRotMatrix);
			Static_data.world_cordinate[num] = [result[0], result[0], result[0]];
	
		}
		public static function setVanishingPoint(vpX:Number, vpY:Number):void
		{
			Static_data.vpX = vpX;
			Static_data.vpY = vpY;
		}
		
		public static function setCenter(cX:Number, cY:Number, cZ:Number=0):void
		{
			Static_data.cX = cX;
			Static_data.cY = cY;
			Static_data.cZ = cZ;
		}
		public static function screenXY(row:Number,column:Number):void
		{
			var scale:Number = Static_data.fl / (Static_data.fl + Static_data.world_cordinate [row][column][2]+ Static_data.cZ);
			Static_data.screen_cordinate[row][column][0] = 
				Static_data.vpX + (Static_data.cX + Static_data.world_cordinate[row][column][0]) * scale;
//		}
		
//		public static function screenY(row:Number,column:Number):void
//		{
//			var scale:Number = Static_data.fl / (Static_data.fl + Static_data.world_cordinate[row][column][2] + Static_data.cZ);
			Static_data.screen_cordinate[row][column][1] = 
			     Static_data.vpY - (Static_data.cY + Static_data.world_cordinate[row][column][1]) * scale;
		}
		public static function max_z(row:Number):void
		{
			Static_data.screen_cordinate[row][3] = Math.max(Static_data.world_cordinate[row][0][2],
													Static_data.world_cordinate[row][1][2],
													Static_data.world_cordinate[row][2][2]);
		}
		public static function draw_wire(g:Graphics, row:Number):void {
			g.lineStyle(0.5, 0x00FFFF);
			g.moveTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.lineTo(Static_data.screen_cordinate[row][1][0], Static_data.screen_cordinate[row][1][1]);
			g.lineTo(Static_data.screen_cordinate[row][2][0], Static_data.screen_cordinate[row][2][1]);
			g.lineTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.endFill();
		}
		public static function draw(g:Graphics,row:Number):void
		{
			if(isBackFace(row))
			{
				return;
			}
			g.beginFill(getAdjustedColor(row));
			g.moveTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.lineTo(Static_data.screen_cordinate[row][1][0], Static_data.screen_cordinate[row][1][1]);
			g.lineTo(Static_data.screen_cordinate[row][2][0], Static_data.screen_cordinate[row][2][1]);
			g.lineTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.endFill();
		}
		
		private static function getAdjustedColor(row:Number):uint
		{
			var index:Number = Static_data.screen_cordinate[row][4];
			var red:Number = Static_data.local_cordinate[index][3] >> 16;
			var green:Number = Static_data.local_cordinate[index][3] >> 8 & 0xff;
			var blue:Number = Static_data.local_cordinate[index][3] & 0xff;
			
			var lightFactor:Number = getLightFactor(row);
			
			red *= lightFactor;
			green *= lightFactor;
			blue *= lightFactor;
			
			return red << 16 | green << 8 | blue;
		}
		
		private static function getLightFactor(row:Number):Number
		{
			var index:Number = Static_data.screen_cordinate[row][4];
			var ab:Object = new Object();
			ab.x = Static_data.world_cordinate[index][0][0] - Static_data.world_cordinate[index][1][0];
			ab.y = Static_data.world_cordinate[index][0][1] - Static_data.world_cordinate[index][1][1];
			ab.z = Static_data.world_cordinate[index][0][2] - Static_data.world_cordinate[index][1][2];
			
			var bc:Object = new Object();
			bc.x = Static_data.world_cordinate[index][1][0] - Static_data.world_cordinate[index][2][0];
			bc.y = Static_data.world_cordinate[index][1][1] - Static_data.world_cordinate[index][2][1];
			bc.z = Static_data.world_cordinate[index][1][2] - Static_data.world_cordinate[index][2][2];
			
			var norm:Object = new Object();
			norm.x = (ab.y * bc.z) - (ab.z * bc.y);
			norm.y = -((ab.x * bc.z) - (ab.z * bc.x));
			norm.z = (ab.x * bc.y) - (ab.y * bc.x);
			
			var dotProd:Number = norm.x * Static_data.light.x + 
								 norm.y * Static_data.light.y + 
								 norm.z * Static_data.light.z;
			
			var normMag:Number = Math.sqrt(norm.x * norm.x + 
										   norm.y * norm.y +
										   norm.z * norm.z);
			
			var lightMag:Number = Math.sqrt(Static_data.light.x * Static_data.light.x +
											Static_data.light.y * Static_data.light.y +
											Static_data.light.z * Static_data.light.z);
			
			return (Math.acos(dotProd / (normMag * lightMag)) / Math.PI)
					* Static_data.light.brightness;
		}
		
		private static function isBackFace(row:Number):Boolean
		{
			// http://www.jurjans.lv/flash/shape.html
			var cax:Number = Static_data.screen_cordinate[row][2][0] - Static_data.screen_cordinate[row][0][0] ;
			var cay:Number = Static_data.screen_cordinate[row][2][1] - Static_data.screen_cordinate[row][0][1] ;
			var bcx:Number = Static_data.screen_cordinate[row][1][0] - Static_data.screen_cordinate[row][2][0] ;
			var bcy:Number = Static_data.screen_cordinate[row][1][1] - Static_data.screen_cordinate[row][2][1] ;
			return cax * bcy > cay * bcx;
		}
		
		public static function z_sort():void {
			quicksort(0, Static_data.screen_cordinate.length - 1);
		}
		public static function quicksort(l:Number,r:Number):void {
			if (l >= r) {
				return;
			}
			var v:Number = parition(l, r);
			quicksort (l, v - 1);
			quicksort (v+1, r);
		}
		public static function parition(l:Number, r:Number):Number {
			var i:Number = l - 1;
			var j:Number = r;
			var temp:Array;
			var pivot:Number = Static_data.screen_cordinate[r][3];
			for (;;) {
				while (Static_data.screen_cordinate[++i][3] > pivot);
				while (i <--j && pivot > Static_data.screen_cordinate[j][3]);
				if (i >= j) break;
				temp = Static_data.screen_cordinate[i];
				Static_data.screen_cordinate[i] = Static_data.screen_cordinate[j];
				Static_data.screen_cordinate[j] = temp;
			}
			temp = Static_data.screen_cordinate[i];
			Static_data.screen_cordinate[i] = Static_data.screen_cordinate[r];
			Static_data.screen_cordinate[r] = temp;
			return i;
		}
		private static function matrixMultiply(matrixA:Array, matrixB:Array):Array
		{
			var result:Array = new Array();
			result[0] = matrixA[0] * matrixB[0][0] + 
						matrixA[1] * matrixB[1][0] +
						matrixA[2] * matrixB[2][0];
			
			result[1] = matrixA[0] * matrixB[0][1] +
						matrixA[1] * matrixB[1][1] +
						matrixA[2] * matrixB[2][1];
			
			result[2] = matrixA[0] * matrixB[0][2] +
						matrixA[1] * matrixB[1][2] +
						matrixA[2] * matrixB[2][2];
			return result;
		}
		
		
		public static function z_buffer(row:Number):void
		{
			if (isBackFace(row)) return;
			var top:int = 0 , bot:int = 0 , lft:int = 0 , rit:int = 0 , oth:int = 0;
			var oth_p:Array = [0 , 0 , 0];
			var start_c:Array = new Array() , end_c:Array = new Array(), s_c:Array = new Array(), e_c:Array=new Array();
			var start:Point = new Point() , end:Point = new Point();
			var start1:Point = new Point() , end1:Point = new Point();
			var start2:Point = new Point() , end2:Point = new Point();
			var oth_point:Point = new Point();
			var set_color:Array = average_color(row);
			var ii:Number , jj:Number;
			for (var i:Number = 0; i < 3; i++) {
				if (Static_data.screen_cordinate[row][lft][0] > Static_data.screen_cordinate[row][i][0]) lft = i;
				if (Static_data.screen_cordinate[row][rit][0] < Static_data.screen_cordinate[row][i][0]) rit = i;
				if (Static_data.screen_cordinate[row][top][1] > Static_data.screen_cordinate[row][i][1]) top = i;
				if (Static_data.screen_cordinate[row][bot][1] < Static_data.screen_cordinate[row][i][1]) bot = i;				
			}
			oth_p[top] = 1;
			oth_p[bot] = 1;			
			for (i = 0; i < oth_p.length; i++) {
				if (oth_p[i] == 0) {
					oth = i;
					break;
				}
			}
			for (var y:int = int(Static_data.screen_cordinate[row][top][1]); y < int(Static_data.screen_cordinate[row][bot][1])+1; y++) {
				if (int(Static_data.screen_cordinate[row][top][1]) == int(Static_data.screen_cordinate[row][oth][1]) && y == int(Static_data.screen_cordinate[row][top][1])) {
					start.x = Static_data.screen_cordinate[row][top][0] < Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][top][0]) : int(Static_data.screen_cordinate[row][oth][0]);
					start.y = Static_data.screen_cordinate[row][top][1] < Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][top][1]) : int(Static_data.screen_cordinate[row][oth][1]);
					end.x = Static_data.screen_cordinate[row][top][0] > Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][top][0]) : int(Static_data.screen_cordinate[row][oth][0]);
					end.y = Static_data.screen_cordinate[row][top][1] > Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][top][1]) : int(Static_data.screen_cordinate[row][oth][1]);
					oth_point.x = Static_data.screen_cordinate[row][oth][0];
					oth_point.y = Static_data.screen_cordinate[row][oth][1];
					if (get_oth_point(start, end, oth_point)) {
						s_c = set_color[top];
						e_c = set_color[oth];
						start_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][oth][1]));
						s_c = set_color[top];
						e_c = set_color[bot];
						end_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][bot][1]));
					}else {
						s_c = set_color[top];
						e_c = set_color[bot];
						start_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][bot][1]));
						s_c = set_color[top];
						e_c = set_color[oth];
						end_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][oth][1]));
					}
				}else {
					if (int(Static_data.screen_cordinate[row][bot][1]) == int(Static_data.screen_cordinate[row][oth][1]) && y == int(Static_data.screen_cordinate[row][bot][1])) {
						start.x = Static_data.screen_cordinate[row][bot][0] < Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][bot][0]) : int(Static_data.screen_cordinate[row][oth][0]);
						start.y = Static_data.screen_cordinate[row][bot][1] < Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][bot][1]) : int(Static_data.screen_cordinate[row][oth][1]);
						end.x = Static_data.screen_cordinate[row][bot][0] > Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][bot][0]) : int(Static_data.screen_cordinate[row][oth][0]);
						end.y = Static_data.screen_cordinate[row][bot][1] > Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][bot][1]) : int(Static_data.screen_cordinate[row][oth][1]);
						oth_point.x = Static_data.screen_cordinate[row][oth][0];
						oth_point.y = Static_data.screen_cordinate[row][oth][1];
						if (get_oth_point(start, end, oth_point)) {
							s_c = set_color[top];
							e_c = set_color[oth];
							start_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][oth][1]),0);
							s_c = set_color[top];
							e_c = set_color[bot];
							end_c = sub_c(s_c, e_c,int(Static_data.screen_cordinate[row][bot][1]) ,0);
						}else {
							s_c = set_color[top];
							e_c = set_color[bot];
							start_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][bot][1]),0);
							s_c = set_color[top];
							e_c = set_color[oth];
							end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][oth][1]),0);
						}
					}else {
						start1.x = int(Static_data.screen_cordinate[row][lft][0]);
						start1.y = y;
						end1.x = int(Static_data.screen_cordinate[row][rit][0]);
						end1.y = y;
						start2.x = Static_data.screen_cordinate[row][top][0];
						start2.y = Static_data.screen_cordinate[row][top][1];
						end2.x = Static_data.screen_cordinate[row][bot][0];
						end2.y = Static_data.screen_cordinate[row][bot][1];
						oth_point.x = Static_data.screen_cordinate[row][oth][0];
						oth_point.y = Static_data.screen_cordinate[row][oth][1];
						if (y < Static_data.screen_cordinate[row][oth][1]) {						
							if (get_oth_point(start2, end2, oth_point)) {
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][oth][0]);
								end2.y = int(Static_data.screen_cordinate[row][oth][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][oth][1]) - y);
								s_c = set_color[top];
								e_c = set_color[oth];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][oth][1]) - y);
								if (start_c[0] < 0) trace("no1 start error");
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								end = sub_p(start2, end2, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								s_c = set_color[top];
								e_c = set_color[bot];
								end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								if (end_c[0] < 0) trace("no1 end error");
								if (int(start.x)==int(end.x))end.x++; 
								
							}else {
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								
								s_c = set_color[top];
								e_c = set_color[bot];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								if (start_c[0] < 0) trace("no2 start error");
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][oth][0]);
								end2.y = int(Static_data.screen_cordinate[row][oth][1]);
								end = sub_p(start2, end2, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][oth][1]));
								s_c = set_color[top];
								e_c = set_color[oth];
								end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][oth][1]));
								if (end_c[0] < 0) trace("no2 end error");
								if (int(start.x)==int(end.x)) end.x++;
							}
						}else {
							if (get_oth_point(start2, end2, oth_point)) {
								start2.x = int(Static_data.screen_cordinate[row][oth][0]);
								start2.y = int(Static_data.screen_cordinate[row][oth][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][oth][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								s_c = set_color[oth];
								e_c = set_color[bot];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][oth][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								if (start_c[0] < 0) trace("no3 start error");
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								end = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]-y));
								s_c = set_color[top];
								e_c = set_color[bot];
								end_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]-y));
								if (end_c[0] < 0) trace("no3 end error");
								if (int(start.x)==int(end.x)) end.x++;
							}else {
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								s_c = set_color[top];
								e_c = set_color[bot];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								if (start_c[0] < 0) trace("no4 start error");
								start2.x = int(Static_data.screen_cordinate[row][oth][0]);
								start2.y = int(Static_data.screen_cordinate[row][oth][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								end = sub_p(start2, end2, int(Static_data.screen_cordinate[row][oth][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								s_c = set_color[oth];
								e_c = set_color[bot];
								end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][oth][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								if (end_c[0] < 0) trace("no4 end error");
								if (int(start.x)==int(end.x)) end.x++ ;
							}
						}
					}
				}
				if (int(start.x) == int(end.x)) end.x++;
				if (int(start.x) > int(end.x)) end.x = start.x + 1;	
				
				for (var x:int = int(start.x); x < int(end.x); x++) {
					if (x <= Static_data.scr_width && x > 0 &&
					    y <= Static_data.scr_height && y > 0) {

						if (Static_data.z_buffer[x][y] > int(Static_data.screen_cordinate[row][3])) {
							Static_data.z_buffer[x][y] = Static_data.screen_cordinate[row][3];
							var col:Array = sub_c(start_c, end_c, x - int(start.x), int(end.x) - x);
							var c:uint = col[0] << 16 | col[1] << 8 | col[2];
							Static_data.scr.setPixel(x, y, c);
						}
					}
				}
			}
		}
		
		public static function line_cross(s1:Point , e1:Point , s2:Point , e2:Point,row:Number):Point {
			var rtn:Point = new Point();
			var no1:Point = new Point() , no2:Point = new Point() , no3:Point = new Point();
			var g1:Number , g2:Number , q:Number;
			no1.x = e2.x - s2.x ; no1.y = e2.y - s2.y;
			no2.x = s1.x - s2.x ; no2.y = s1.y - s2.y;
			no3.x = e1.x - s1.x ; no3.y = e1.y - s1.y;
			g1 = no3.x * no1.y - no3.y * no1.x;
			g2 = no3.x * no2.y - no3.y * no2.x;
			if (g1 != 0) {
				q = g2 / g1;
				rtn.x = no1.x * q ; rtn.y = no1.y * q;
				rtn.x += s2.x ; rtn.y += s2.y;
			}else {
				if (s1.x == e1.x && s1.y == e1.y) {
					rtn.x = s1.x;
					rtn.y = s1.y;
				}else{
					trace("not cross " + row);
					trace("start1 x " + s1.x + " y " + s1.y+" end1.x "+e1.x+" end1.y "+e1.y);
					trace("start2 x " + s2.x + " y " + s2.y+" end2.x "+e2.x+" end2.y "+e2.y);
					trace("f x " + Static_data.screen_cordinate[row][0][0] + " y " + Static_data.screen_cordinate[row][0][1]);
					trace("s x " + Static_data.screen_cordinate[row][1][0] + " y " + Static_data.screen_cordinate[row][1][1]);
					trace("t x " + Static_data.screen_cordinate[row][2][0] + " y " + Static_data.screen_cordinate[row][2][1]);
					rtn.x = s1.x;
					rtn.y = s1.y;
				}
			}
			return rtn;
		}
		
		public static function init_scr():void {
			Static_data.z_buffer = new Array(Static_data.scr_height);
			for (var y:Number = 0; y < Static_data.scr_height; y++) {
				Static_data.z_buffer[y] = new Array(Static_data.scr_width);
				for (var x:Number = 0; x < Static_data.scr_width; x++) Static_data.z_buffer[y][x] = 1000.0;
			}
                        Static_data.init_scr.fillRect(Static_data.init_scr.rect, 0x000000);
		}
		public static function scr_make():void {
			Static_data.scr.copyPixels(Static_data.init_scr, Static_data.init_scr.rect, new Point());
			for (var x:Number = 0; x < Static_data.scr_width; x++)
				for (var y:Number = 0; y < Static_data.scr_height; y++) Static_data.z_buffer[x][y] = 1000.0 
		}
		private static function getAdjustedColor_z(row:Number):uint
		{
			var red:Number = Static_data.local_cordinate[row][3] >> 16;
			var green:Number = Static_data.local_cordinate[row][3] >> 8 & 0xff;
			var blue:Number = Static_data.local_cordinate[row][3] & 0xff;
			var lightFactor:Number = getLightFactor_z(row);
			
			red *= lightFactor;
			green *= lightFactor;
			blue *= lightFactor;
			
			return red << 16 | green << 8 | blue;
		}
		
		private static function getLightFactor_z(row:Number):Number
		{
			var ab:Object = new Object();
			ab.x = Static_data.world_cordinate[row][0][0] - Static_data.world_cordinate[row][1][0];
			ab.y = Static_data.world_cordinate[row][0][1] - Static_data.world_cordinate[row][1][1];
			ab.z = Static_data.world_cordinate[row][0][2] - Static_data.world_cordinate[row][1][2];
			
			var bc:Object = new Object();
			bc.x = Static_data.world_cordinate[row][1][0] - Static_data.world_cordinate[row][2][0];
			bc.y = Static_data.world_cordinate[row][1][1] - Static_data.world_cordinate[row][2][1];
			bc.z = Static_data.world_cordinate[row][1][2] - Static_data.world_cordinate[row][2][2];
			
			var norm:Object = new Object();
			norm.x = (ab.y * bc.z) - (ab.z * bc.y);
			norm.y = -((ab.x * bc.z) - (ab.z * bc.x));
			norm.z = (ab.x * bc.y) - (ab.y * bc.x);
			
			var dotProd:Number = norm.x * Static_data.light.x + 
								 norm.y * Static_data.light.y + 
								 norm.z * Static_data.light.z;
			
			var normMag:Number = Math.sqrt(norm.x * norm.x + 
										   norm.y * norm.y +
										   norm.z * norm.z);
			
			var lightMag:Number = Math.sqrt(Static_data.light.x * Static_data.light.x +
											Static_data.light.y * Static_data.light.y +
											Static_data.light.z * Static_data.light.z);
			
			return (Math.acos(dotProd / (normMag * lightMag)) / Math.PI)
					* Static_data.light.brightness;
		}
		private static function get_oth_point(s:Point , e:Point , p:Point):Boolean {
			var xa:Number , ya:Number , xb:Number , yb:Number , det:Number;
			xa = e.x - s.x;
			ya = e.y - s.y;
			xb = p.x - s.x;
			yb = p.y - s.y;
			det = xa * yb - xb * ya;
			return det > 0;
		}
		private static function sub_p(p1:Point , p2:Point , a1:int , a2:int):Point {
			var rtn:Point = new Point();
			if (a1 + a2 == 0) return p1;
			rtn.x = (a2 * p1.x + a1 * p2.x) / (a1 + a2);
			rtn.y = (a2 * p1.y + a1 * p2.y) / (a1 + a2);
			return rtn;
		}
		private static function sub_c(c1:Array , c2:Array , a1:int , a2:int):Array {
			var rtn:Array = new Array(3);
			if (a1 + a2 == 0) return c1;
			for (var i:Number = 0; i < 3; i++) {
				rtn[i] = (a2 / (a1 + a2) * c1[i] + a1 / (a1 + a2) * c2[i]);
				if (rtn[i] < 0) {
					trace("c1 r " + c1[0] + " g " + c1[1] + " b " + c1[2]);
					trace("c2 r " + c2[0] + " g " + c2[1] + " b " + c2[2]);
					trace("a1 " + a1 + " a2 " + a2);
				}
			}
			return rtn;
		}
		private static function average_color(row:Number):Array {
			var kb:Number = 0.7 , ks:Number = 0.7 , ke:Number = 0.3 , e:Number , length:Number;
			var rtn:Array = new Array(3);
			var v_data:Array = new Array(3);
			var f_point:Point3D;
			var s_point:Point3D;
			var t_point:Point3D;			
			var data:Array = new Array(4);
			var v:Vec;
			var red:Number ;
			var green:Number ;
			var blue:Number ;
			for (var i:Number = 0; i < 3; i++) {
				if (Static_data.local_cordinate[row][i + 4].length != 0) {
					rtn[i] = new Array(3);
					v_data = new Array(Static_data.local_cordinate[row][i + 4].length);
					length = 0;
					for (var j:Number = 0; j < Static_data.local_cordinate[row][i + 4].length; j++) {
						e = Static_data.local_cordinate[row][i + 4][j];
						if (!isBackFace(e)){
							f_point =  new Point3D (Static_data.world_cordinate[e][0][0],Static_data.world_cordinate[e][0][1],Static_data.world_cordinate[e][0][2]);
							s_point =  new Point3D (Static_data.world_cordinate[e][1][0],Static_data.world_cordinate[e][1][1],Static_data.world_cordinate[e][1][2]);
							t_point =  new Point3D (Static_data.world_cordinate[e][2][0],Static_data.world_cordinate[e][2][1],Static_data.world_cordinate[e][2][2]);
							v = new Vec(f_point, s_point, t_point,i);
						
							v_data[length] = [v.N, v.V, v.L, v.R];
							length++;
						}
					}
					data = Normalized(v_data,length);
					red = Static_data.local_cordinate[row][3] >> 16 ;
					green = Static_data.local_cordinate[row][3] >> 8 & 0xff;
					blue = Static_data.local_cordinate[row][3] & 0xff;
					rtn[i][0] = kb * spec(data,0) * red + ks * diff(data,0) + ke * red;
					rtn[i][1] = kb * spec(data,1) * green + ks * diff(data,1) + ke * green;
					rtn[i][2] = kb * spec(data,2) * blue + ks * diff(data,2) + ke * blue;
				}
			}
			return rtn;
		}
		public static function Normalized(p:Array,l:Number):Array {
			var rtn:Array = new Array(4);
			var N:Point3D = new Point3D();
			var V:Point3D = new Point3D();
			var L:Point3D = new Point3D();
			var R:Point3D = new Point3D();
			var D:Number;
			for (var i:Number = 0; i < 4; i++) {
				rtn[i] = new Point3D();
			}
			for (i = 0; i < l ; i++) {
				N.x += p[i][0].x;
				N.y += p[i][0].y;
				N.z += p[i][0].z;
				V.x += p[i][1].x;
				V.y += p[i][1].y;
				V.z += p[i][1].z;	
				L.x += p[i][2].x;
				L.y += p[i][2].y;
				L.z += p[i][2].z;	
				R.x += p[i][3].x;
				R.y += p[i][3].y;
				R.z += p[i][3].z;				
			}
			N.x /= l;
			N.y /= l;
			N.z /= l;
			D = Math.sqrt(N.x * N.x + N.y * N.y + N.z * N.z);
			rtn[0].x = N.x / D;
			rtn[0].y = N.y / D;
			rtn[0].z = N.z / D;
			V.x /= l;
			V.y /= l;
			V.z /= l;
			D = Math.sqrt(V.x * V.x + V.y * V.y + V.z * V.z);
			rtn[1].x = V.x / D;
			rtn[1].y = V.y / D;
			rtn[1].z = V.z / D;
			L.x /= l;
			L.y /= l;
			L.z /= l;
			D = Math.sqrt(L.x * L.x + L.y * L.y + L.z * L.z);
			rtn[2].x = L.x / D;
			rtn[2].y = L.y / D;
			rtn[2].z = L.z / D;
			R.x /= l;
			R.y /= l;
			R.z /= l;
			D = Math.sqrt(R.x * R.x + R.y * R.y + R.z * R.z);
			rtn[3].x = R.x / D;
			rtn[3].y = R.y / D;
			rtn[3].z = R.z / D;
			return rtn;
		}
		public static function spec(data:Array,p:Number):Number {
			switch(p) {
				case 0:
					return Math.max(-(data[0].y * data[2].z - data[0].z * data[2].y), 0);
					break;
				case 1:
					return Math.max(data[0].x * data[2].z - data[0].z * data[2].x, 0);
					break;
				case 2:
					return Math.max(-(data[0].x * data[2].y - data[0].y * data[2].x), 0);
					break;
			}
			return 0;
		}
		public static function diff(data:Array,p:Number):Number {
			switch(p) {
				case 0:
					return Math.pow(Math.max(-(data[3].y * data[1].z - data[3].z * data[1].y), 0),20) * 255;
					break;
				case 1:
					return Math.pow(Math.max(data[3].x * data[1].z - data[3].z * data[1].x, 0),20) * 255;
					break;
				case 2:
					return Math.pow(Math.max(-(data[3].x * data[1].y - data[3].y * data[1].x), 0),20) * 255;
					break;
			}
			return 0;
		}

	}
	import flash.display.BitmapData;
	import flash.display.Sprite;
	
	/**
	 * ...
	 * @author ...
	 */
	class Static_data 
	{
		public static var local_cordinate:Array = [

[[-104,42,0],[-102,41,0],[-104,20,0,],0xFFFFFF,[0,5515],[0,1,5515,5516],[0,1,5515,5516]],
[[-104,20,0],[-102,41,0],[-102,20,0,],0xFFFFFF,[0,1,5515,5516],[0,1,5515,5516],[1,5516]],
[[-106,37,0],[-100,37,0],[-107,35,0,],0xFFFFFF,[2,5517],[2,3,5517,5518],[2,3,5517,5518]],
[[-107,35,0],[-100,37,0],[-100,35,0,],0xFFFFFF,[2,3,5517,5518],[2,3,5517,5518],[3,5518]],
[[-104,34,0],[-104,30,0],[-107,27,0,],0xFFFFFF,[4,5519],[4,5,5519,5520],[4,5,5519,5520]],
[[-107,27,0],[-104,30,0],[-106,26,0,],0xFFFFFF,[4,5,5519,5520],[4,5,5519,5520],[5,5520]],
[[-102,33,0],[-101,29,0],[-103,30,0,],0xFFFFFF,[6,7,5521,5522],[6,7,5521,5522],[6,5521]],
[[-102,33,0],[-100,31,0],[-101,29,0,],0xFFFFFF,[6,7,5521,5522],[7,23,5522,5538],[6,7,5521,5522]],
[[-97,41,0],[-98,35,0],[-100,36,0,],0xFFFFFF,[8,9,5523,5524],[8,9,5523,5524],[8,10,11,5523,5525,5526]],
[[-97,41,0],[-95,40,0],[-98,35,0,],0xFFFFFF,[8,9,5523,5524],[9,5524],[8,9,5523,5524]],
[[-96,35,0],[-97,34,0],[-100,36,0,],0xFFFFFF,[10,11,5525,5526],[10,5525],[8,10,11,5523,5525,5526]],
[[-96,35,0],[-100,36,0],[-99,37,0,],0xFFFFFF,[10,11,5525,5526],[8,10,11,5523,5525,5526],[11,5526]],
[[-95,38,0],[-97,32,0],[-99,32,0,],0xFFFFFF,[12,13,5527,5528],[12,13,5527,5528],[12,22,23,5527,5537,5538]],
[[-95,38,0],[-94,37,0],[-97,32,0,],0xFFFFFF,[12,13,5527,5528],[13,5528],[12,13,5527,5528]],
[[-89,41,0],[-90,35,0],[-92,36,0,],0xFFFFFF,[14,15,5529,5530],[14,15,5529,5530],[14,16,17,5529,5531,5532]],
[[-89,41,0],[-88,40,0],[-90,35,0,],0xFFFFFF,[14,15,5529,5530],[15,5530],[14,15,5529,5530]],
[[-88,36,0],[-89,34,0],[-92,36,0,],0xFFFFFF,[16,17,5531,5532],[16,5531],[14,16,17,5529,5531,5532]],
[[-88,36,0],[-92,36,0],[-91,38,0,],0xFFFFFF,[16,17,5531,5532],[14,16,17,5529,5531,5532],[17,5532]],
[[-88,39,0],[-90,33,0],[-91,33,0,],0xFFFFFF,[18,19,5533,5534],[18,19,5533,5534],[18,26,27,5533,5541,5542]],
[[-88,39,0],[-87,38,0],[-90,33,0,],0xFFFFFF,[18,19,5533,5534],[19,5534],[18,19,5533,5534]],
[[-96,34,0],[-95,35,0],[-94,31,0,],0xFFFFFF,[20,5535],[20,21,5535,5536],[20,21,5535,5536]],
[[-95,35,0],[-93,31,0],[-94,31,0,],0xFFFFFF,[20,21,5535,5536],[21,22,23,5536,5537,5538],[20,21,5535,5536]],
[[-99,32,0],[-94,33,0],[-93,31,0,],0xFFFFFF,[12,22,23,5527,5537,5538],[22,5537],[21,22,23,5536,5537,5538]],
[[-99,32,0],[-93,31,0],[-100,31,0,],0xFFFFFF,[12,22,23,5527,5537,5538],[21,22,23,5536,5537,5538],[7,23,5522,5538]],
[[-88,34,0],[-87,35,0],[-87,31,0,],0xFFFFFF,[24,5539],[24,25,5539,5540],[24,25,5539,5540]],
[[-87,35,0],[-86,32,0],[-87,31,0,],0xFFFFFF,[24,25,5539,5540],[25,26,27,5540,5541,5542],[24,25,5539,5540]],
[[-91,33,0],[-86,33,0],[-86,32,0,],0xFFFFFF,[18,26,27,5533,5541,5542],[26,5541],[25,26,27,5540,5541,5542]],
[[-91,33,0],[-86,32,0],[-92,31,0,],0xFFFFFF,[18,26,27,5533,5541,5542],[25,26,27,5540,5541,5542],[27,5542]],
[[-94,41,0],[-92,30,0],[-94,28,0,],0xFFFFFF,[28,29,5543,5544],[28,29,30,5543,5544,5545],[28,30,31,5543,5545,5546]],
[[-92,30,0],[-94,41,0],[-92,41,0,],0xFFFFFF,[28,29,30,5543,5544,5545],[28,29,5543,5544],[29,5544]],
[[-94,28,0],[-92,30,0],[-91,26,0,],0xFFFFFF,[28,30,31,5543,5545,5546],[28,29,30,5543,5544,5545],[30,31,32,5545,5546,5547]],
[[-91,26,0],[-92,24,0],[-94,28,0,],0xFFFFFF,[30,31,32,5545,5546,5547],[31,32,33,5546,5547,5548],[28,30,31,5543,5545,5546]],
[[-91,26,0],[-90,24,0],[-92,24,0,],0xFFFFFF,[30,31,32,5545,5546,5547],[32,33,34,5547,5548,5549],[31,32,33,5546,5547,5548]],
[[-92,24,0],[-90,24,0],[-90,21,0,],0xFFFFFF,[31,32,33,5546,5547,5548],[32,33,34,5547,5548,5549],[33,34,35,5548,5549,5550]],
[[-90,24,0],[-88,22,0],[-90,21,0,],0xFFFFFF,[32,33,34,5547,5548,5549],[34,35,36,37,5549,5550,5551,5552],[33,34,35,5548,5549,5550]],
[[-90,21,0],[-88,22,0],[-87,20,0,],0xFFFFFF,[33,34,35,5548,5549,5550],[34,35,36,37,5549,5550,5551,5552],[35,36,5550,5551]],
[[-88,22,0],[-86,21,0],[-87,20,0,],0xFFFFFF,[34,35,36,37,5549,5550,5551,5552],[36,37,38,5551,5552,5553],[35,36,5550,5551]],
[[-86,21,0],[-88,22,0],[-87,24,0,],0xFFFFFF,[36,37,38,5551,5552,5553],[34,35,36,37,5549,5550,5551,5552],[37,38,5552,5553]],
[[-87,24,0],[-85,23,0],[-86,21,0,],0xFFFFFF,[37,38,5552,5553],[38,5553],[36,37,38,5551,5552,5553]],
[[-100,30,0],[-85,30,0],[-100,28,0,],0xFFFFFF,[39,5554],[39,40,5554,5555],[39,40,5554,5555]],
[[-85,30,0],[-85,28,0],[-100,28,0,],0xFFFFFF,[39,40,5554,5555],[40,5555],[39,40,5554,5555]],
[[-90,31,0],[-88,32,0],[-89,29,0,],0xFFFFFF,[41,5556],[41,42,5556,5557],[41,42,5556,5557]],
[[-88,32,0],[-87,29,0],[-89,29,0,],0xFFFFFF,[41,42,5556,5557],[42,5557],[41,42,5556,5557]],
[[-99,26,0],[-99,29,0],[-97,29,0,],0xFFFFFF,[43,44,48,5558,5559,5563],[43,5558],[43,44,5558,5559]],
[[-99,26,0],[-97,29,0],[-97,25,0,],0xFFFFFF,[43,44,48,5558,5559,5563],[43,44,5558,5559],[44,45,48,5559,5560,5563]],
[[-97,25,0],[-98,22,0],[-100,23,0,],0xFFFFFF,[44,45,48,5559,5560,5563],[45,46,47,5560,5561,5562],[45,46,48,5560,5561,5563]],
[[-100,23,0],[-98,22,0],[-101,21,0,],0xFFFFFF,[45,46,48,5560,5561,5563],[45,46,47,5560,5561,5562],[46,47,5561,5562]],
[[-98,22,0],[-100,20,0],[-101,21,0,],0xFFFFFF,[45,46,47,5560,5561,5562],[47,5562],[46,47,5561,5562]],
[[-99,26,0],[-97,25,0],[-100,23,0,],0xFFFFFF,[43,44,48,5558,5559,5563],[44,45,48,5559,5560,5563],[45,46,48,5560,5561,5563]],
[[-97,27,0],[-95,24,0],[-98,26,0,],0xFFFFFF,[49,50,5564,5565],[49,50,5564,5565],[49,5564]],
[[-95,24,0],[-97,27,0],[-94,25,0,],0xFFFFFF,[49,50,5564,5565],[49,50,5564,5565],[50,5565]],
[[-89,28,0],[-87,27,0],[-89,24,0,],0xFFFFFF,[51,52,5566,5567],[51,5566],[51,52,53,5566,5567,5568]],
[[-89,24,0],[-91,25,0],[-89,28,0,],0xFFFFFF,[51,52,53,5566,5567,5568],[52,53,54,5567,5568,5569],[51,52,5566,5567]],
[[-91,25,0],[-89,24,0],[-92,22,0,],0xFFFFFF,[52,53,54,5567,5568,5569],[51,52,53,5566,5567,5568],[53,54,55,5568,5569,5570]],
[[-92,22,0],[-94,23,0],[-91,25,0,],0xFFFFFF,[53,54,55,5568,5569,5570],[54,55,56,5569,5570,5571],[52,53,54,5567,5568,5569]],
[[-94,23,0],[-92,22,0],[-96,20,0,],0xFFFFFF,[54,55,56,5569,5570,5571],[53,54,55,5568,5569,5570],[55,56,5570,5571]],
[[-96,20,0],[-97,22,0],[-94,23,0,],0xFFFFFF,[55,56,5570,5571],[56,5571],[54,55,56,5569,5570,5571]],
[[-83,40,0],[-78,38,0],[-82,38,0,],0xFFFFFF,[57,58,5572,5573],[57,58,59,60,5572,5573,5574,5575],[57,5572]],
[[-83,40,0],[-78,40,0],[-78,38,0,],0xFFFFFF,[57,58,5572,5573],[58,59,5573,5574],[57,58,59,60,5572,5573,5574,5575]],
[[-78,40,0],[-76,40,0],[-78,38,0,],0xFFFFFF,[58,59,5573,5574],[59,60,61,62,5574,5575,5576,5577],[57,58,59,60,5572,5573,5574,5575]],
[[-78,38,0],[-76,40,0],[-75,38,0,],0xFFFFFF,[57,58,59,60,5572,5573,5574,5575],[59,60,61,62,5574,5575,5576,5577],[60,61,5575,5576]],
[[-75,38,0],[-76,40,0],[-72,39,0,],0xFFFFFF,[60,61,5575,5576],[59,60,61,62,5574,5575,5576,5577],[61,62,5576,5577]],
[[-76,40,0],[-73,41,0],[-72,39,0,],0xFFFFFF,[59,60,61,62,5574,5575,5576,5577],[62,5577],[61,62,5576,5577]],
[[-82,21,0],[-83,23,0],[-72,24,0,],0xFFFFFF,[63,64,5578,5579],[63,5578],[63,64,5578,5579]],
[[-82,21,0],[-72,24,0],[-71,23,0,],0xFFFFFF,[63,64,5578,5579],[63,64,5578,5579],[64,5579]],
[[-83,38,0],[-70,36,0],[-83,36,0,],0xFFFFFF,[65,66,5580,5581],[65,66,5580,5581],[65,5580]],
[[-83,38,0],[-70,38,0],[-70,36,0,],0xFFFFFF,[65,66,5580,5581],[66,5581],[65,66,5580,5581]],
[[-76,38,0],[-77,23,0],[-78,38,0,],0xFFFFFF,[67,68,5582,5583],[67,68,5582,5583],[67,5582]],
[[-76,38,0],[-76,23,0],[-77,23,0,],0xFFFFFF,[67,68,5582,5583],[68,5583],[67,68,5582,5583]],
[[-82,28,0],[-82,35,0],[-80,28,0,],0xFFFFFF,[69,83,84,5584,5598,5599],[69,70,73,5584,5585,5588],[69,70,5584,5585]],
[[-82,35,0],[-80,35,0],[-80,28,0,],0xFFFFFF,[69,70,73,5584,5585,5588],[70,5585],[69,70,5584,5585]],
[[-73,35,0],[-72,28,0],[-73,28,0,],0xFFFFFF,[71,72,5586,5587],[71,72,5586,5587],[71,5586]],
[[-73,35,0],[-71,35,0],[-72,28,0,],0xFFFFFF,[71,72,5586,5587],[72,73,74,5587,5588,5589],[71,72,5586,5587]],
[[-82,35,0],[-71,35,0],[-80,33,0,],0xFFFFFF,[69,70,73,5584,5585,5588],[72,73,74,5587,5588,5589],[73,74,5588,5589]],
[[-80,33,0],[-71,35,0],[-73,33,0,],0xFFFFFF,[73,74,5588,5589],[72,73,74,5587,5588,5589],[74,5589]],
[[-80,32,0],[-78,32,0],[-80,31,0,],0xFFFFFF,[75,5590],[75,76,77,78,5590,5591,5592,5593],[75,76,5590,5591]],
[[-80,31,0],[-78,32,0],[-78,31,0,],0xFFFFFF,[75,76,5590,5591],[75,76,77,78,5590,5591,5592,5593],[76,78,5591,5593]],
[[-76,32,0],[-76,31,0],[-78,32,0,],0xFFFFFF,[77,79,80,5592,5594,5595],[77,78,80,5592,5593,5595],[75,76,77,78,5590,5591,5592,5593]],
[[-76,31,0],[-78,31,0],[-78,32,0,],0xFFFFFF,[77,78,80,5592,5593,5595],[76,78,5591,5593],[75,76,77,78,5590,5591,5592,5593]],
[[-73,32,0],[-73,31,0],[-76,32,0,],0xFFFFFF,[79,81,82,5594,5596,5597],[79,80,82,5594,5595,5597],[77,79,80,5592,5594,5595]],
[[-73,31,0],[-76,31,0],[-76,32,0,],0xFFFFFF,[79,80,82,5594,5595,5597],[77,78,80,5592,5593,5595],[77,79,80,5592,5594,5595]],
[[-71,32,0],[-71,31,0],[-73,32,0,],0xFFFFFF,[81,5596],[81,82,5596,5597],[79,81,82,5594,5596,5597]],
[[-71,31,0],[-73,31,0],[-73,32,0,],0xFFFFFF,[81,82,5596,5597],[79,80,82,5594,5595,5597],[79,81,82,5594,5596,5597]],
[[-82,29,0],[-80,29,0],[-82,28,0,],0xFFFFFF,[83,5598],[83,84,85,5598,5599,5600],[69,83,84,5584,5598,5599]],
[[-82,28,0],[-80,29,0],[-80,28,0,],0xFFFFFF,[69,83,84,5584,5598,5599],[83,84,85,5598,5599,5600],[84,85,86,5599,5600,5601]],
[[-80,29,0],[-78,29,0],[-80,28,0,],0xFFFFFF,[83,84,85,5598,5599,5600],[85,86,87,88,5600,5601,5602,5603],[84,85,86,5599,5600,5601]],
[[-80,28,0],[-78,29,0],[-78,28,0,],0xFFFFFF,[84,85,86,5599,5600,5601],[85,86,87,88,5600,5601,5602,5603],[86,88,5601,5603]],
[[-76,29,0],[-76,28,0],[-78,29,0,],0xFFFFFF,[87,89,90,5602,5604,5605],[87,88,90,5602,5603,5605],[85,86,87,88,5600,5601,5602,5603]],
[[-76,28,0],[-78,28,0],[-78,29,0,],0xFFFFFF,[87,88,90,5602,5603,5605],[86,88,5601,5603],[85,86,87,88,5600,5601,5602,5603]],
[[-73,29,0],[-73,28,0],[-76,29,0,],0xFFFFFF,[89,91,92,5604,5606,5607],[89,90,92,5604,5605,5607],[87,89,90,5602,5604,5605]],
[[-73,28,0],[-76,28,0],[-76,29,0,],0xFFFFFF,[89,90,92,5604,5605,5607],[87,88,90,5602,5603,5605],[87,89,90,5602,5604,5605]],
[[-71,29,0],[-71,28,0],[-73,29,0,],0xFFFFFF,[91,5606],[91,92,5606,5607],[89,91,92,5604,5606,5607]],
[[-71,28,0],[-73,28,0],[-73,29,0,],0xFFFFFF,[91,92,5606,5607],[89,90,92,5604,5605,5607],[89,91,92,5604,5606,5607]],
[[-82,27,0],[-71,27,0],[-81,25,0,],0xFFFFFF,[93,5608],[93,94,5608,5609],[93,94,5608,5609]],
[[-71,27,0],[-71,25,0],[-81,25,0,],0xFFFFFF,[93,94,5608,5609],[94,5609],[93,94,5608,5609]],
[[-69,36,0],[-69,40,0],[-67,36,0,],0xFFFFFF,[95,97,101,102,5610,5612,5616,5617],[95,96,5610,5611],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619]],
[[-67,36,0],[-69,40,0],[-67,40,0,],0xFFFFFF,[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[95,96,5610,5611],[96,5611]],
[[-69,36,0],[-67,36,0],[-69,34,0,],0xFFFFFF,[95,97,101,102,5610,5612,5616,5617],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[97,98,99,102,5612,5613,5614,5617]],
[[-69,34,0],[-67,36,0],[-67,34,0,],0xFFFFFF,[97,98,99,102,5612,5613,5614,5617],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[98,99,100,104,5613,5614,5615,5619]],
[[-69,34,0],[-67,34,0],[-69,28,0,],0xFFFFFF,[97,98,99,102,5612,5613,5614,5617],[98,99,100,104,5613,5614,5615,5619],[99,100,109,110,5614,5615,5624,5625]],
[[-67,34,0],[-67,28,0],[-69,28,0,],0xFFFFFF,[98,99,100,104,5613,5614,5615,5619],[100,109,5615,5624],[99,100,109,110,5614,5615,5624,5625]],
[[-71,36,0],[-69,36,0],[-71,34,0,],0xFFFFFF,[101,5616],[95,97,101,102,5610,5612,5616,5617],[101,102,5616,5617]],
[[-71,34,0],[-69,36,0],[-69,34,0,],0xFFFFFF,[101,102,5616,5617],[95,97,101,102,5610,5612,5616,5617],[97,98,99,102,5612,5613,5614,5617]],
[[-65,36,0],[-65,34,0],[-67,36,0,],0xFFFFFF,[103,105,106,5618,5620,5621],[103,104,106,107,108,5618,5619,5621,5622,5623],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619]],
[[-65,34,0],[-67,34,0],[-67,36,0,],0xFFFFFF,[103,104,106,107,108,5618,5619,5621,5622,5623],[98,99,100,104,5613,5614,5615,5619],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619]],
[[-62,36,0],[-62,34,0],[-65,36,0,],0xFFFFFF,[105,5620],[105,106,107,5620,5621,5622],[103,105,106,5618,5620,5621]],
[[-65,36,0],[-62,34,0],[-65,34,0,],0xFFFFFF,[103,105,106,5618,5620,5621],[105,106,107,5620,5621,5622],[103,104,106,107,108,5618,5619,5621,5622,5623]],
[[-62,34,0],[-62,24,0],[-65,34,0,],0xFFFFFF,[105,106,107,5620,5621,5622],[107,108,114,5622,5623,5629],[103,104,106,107,108,5618,5619,5621,5622,5623]],
[[-65,34,0],[-62,24,0],[-65,24,0,],0xFFFFFF,[103,104,106,107,108,5618,5619,5621,5622,5623],[107,108,114,5622,5623,5629],[108,114,115,5623,5629,5630]],
[[-67,28,0],[-68,24,0],[-69,28,0,],0xFFFFFF,[100,109,5615,5624],[109,110,111,5624,5625,5626],[99,100,109,110,5614,5615,5624,5625]],
[[-69,28,0],[-68,24,0],[-70,24,0,],0xFFFFFF,[99,100,109,110,5614,5615,5624,5625],[109,110,111,5624,5625,5626],[110,111,112,5625,5626,5627]],
[[-70,24,0],[-68,24,0],[-70,21,0,],0xFFFFFF,[110,111,112,5625,5626,5627],[109,110,111,5624,5625,5626],[111,112,113,5626,5627,5628]],
[[-70,21,0],[-74,21,0],[-70,24,0,],0xFFFFFF,[111,112,113,5626,5627,5628],[112,113,5627,5628],[110,111,112,5625,5626,5627]],
[[-74,21,0],[-70,21,0],[-72,20,0,],0xFFFFFF,[112,113,5627,5628],[111,112,113,5626,5627,5628],[113,5628]],
[[-62,24,0],[-63,22,0],[-65,24,0,],0xFFFFFF,[107,108,114,5622,5623,5629],[114,115,116,5629,5630,5631],[108,114,115,5623,5629,5630]],
[[-65,24,0],[-63,22,0],[-65,23,0,],0xFFFFFF,[108,114,115,5623,5629,5630],[114,115,116,5629,5630,5631],[115,116,117,118,5630,5631,5632,5633]],
[[-65,23,0],[-63,22,0],[-65,20,0,],0xFFFFFF,[115,116,117,118,5630,5631,5632,5633],[114,115,116,5629,5630,5631],[116,117,5631,5632]],
[[-68,20,0],[-65,23,0],[-65,20,0,],0xFFFFFF,[117,118,5632,5633],[115,116,117,118,5630,5631,5632,5633],[116,117,5631,5632]],
[[-67,22,0],[-65,23,0],[-68,20,0,],0xFFFFFF,[118,5633],[115,116,117,118,5630,5631,5632,5633],[117,118,5632,5633]],
[[-59,40,0],[-58,41,0],[-57,37,0,],0xFFFFFF,[119,5634],[119,120,5634,5635],[119,120,5634,5635]],
[[-58,41,0],[-55,38,0],[-57,37,0,],0xFFFFFF,[119,120,5634,5635],[120,5635],[119,120,5634,5635]],
[[-55,40,0],[-54,41,0],[-53,37,0,],0xFFFFFF,[121,5636],[121,122,5636,5637],[121,122,5636,5637]],
[[-54,41,0],[-52,38,0],[-53,37,0,],0xFFFFFF,[121,122,5636,5637],[122,5637],[121,122,5636,5637]],
[[-51,37,0],[-49,41,0],[-49,36,0,],0xFFFFFF,[123,5638],[123,124,5638,5639],[123,124,5638,5639]],
[[-49,36,0],[-49,41,0],[-47,40,0,],0xFFFFFF,[123,124,5638,5639],[123,124,5638,5639],[124,5639]],
[[-58,36,0],[-57,36,0],[-58,35,0,],0xFFFFFF,[125,5640],[125,126,127,5640,5641,5642],[125,126,135,5640,5641,5650]],
[[-58,35,0],[-57,36,0],[-57,35,0,],0xFFFFFF,[125,126,135,5640,5641,5650],[125,126,127,5640,5641,5642],[126,127,128,135,136,5641,5642,5643,5650,5651]],
[[-57,36,0],[-54,36,0],[-57,35,0,],0xFFFFFF,[125,126,127,5640,5641,5642],[127,128,129,5642,5643,5644],[126,127,128,135,136,5641,5642,5643,5650,5651]],
[[-57,35,0],[-54,36,0],[-54,35,0,],0xFFFFFF,[126,127,128,135,136,5641,5642,5643,5650,5651],[127,128,129,5642,5643,5644],[128,129,130,137,5643,5644,5645,5652]],
[[-54,36,0],[-52,36,0],[-54,35,0,],0xFFFFFF,[127,128,129,5642,5643,5644],[129,130,131,5644,5645,5646],[128,129,130,137,5643,5644,5645,5652]],
[[-54,35,0],[-52,36,0],[-52,35,0,],0xFFFFFF,[128,129,130,137,5643,5644,5645,5652],[129,130,131,5644,5645,5646],[130,131,132,137,138,5645,5646,5647,5652,5653]],
[[-52,36,0],[-50,36,0],[-52,35,0,],0xFFFFFF,[129,130,131,5644,5645,5646],[131,132,133,5646,5647,5648],[130,131,132,137,138,5645,5646,5647,5652,5653]],
[[-52,35,0],[-50,36,0],[-50,35,0,],0xFFFFFF,[130,131,132,137,138,5645,5646,5647,5652,5653],[131,132,133,5646,5647,5648],[132,133,134,139,5647,5648,5649,5654]],
[[-50,36,0],[-48,36,0],[-50,35,0,],0xFFFFFF,[131,132,133,5646,5647,5648],[133,134,5648,5649],[132,133,134,139,5647,5648,5649,5654]],
[[-50,35,0],[-48,36,0],[-48,35,0,],0xFFFFFF,[132,133,134,139,5647,5648,5649,5654],[133,134,5648,5649],[134,139,140,5649,5654,5655]],
[[-58,35,0],[-57,35,0],[-58,33,0,],0xFFFFFF,[125,126,135,5640,5641,5650],[126,127,128,135,136,5641,5642,5643,5650,5651],[135,136,141,5650,5651,5656]],
[[-58,33,0],[-57,35,0],[-57,33,0,],0xFFFFFF,[135,136,141,5650,5651,5656],[126,127,128,135,136,5641,5642,5643,5650,5651],[136,141,142,143,5651,5656,5657,5658]],
[[-54,35,0],[-52,35,0],[-54,33,0,],0xFFFFFF,[128,129,130,137,5643,5644,5645,5652],[130,131,132,137,138,5645,5646,5647,5652,5653],[137,138,143,144,145,5652,5653,5658,5659,5660]],
[[-54,33,0],[-52,35,0],[-52,33,0,],0xFFFFFF,[137,138,143,144,145,5652,5653,5658,5659,5660],[130,131,132,137,138,5645,5646,5647,5652,5653],[138,145,146,147,5653,5660,5661,5662]],
[[-50,35,0],[-48,35,0],[-50,33,0,],0xFFFFFF,[132,133,134,139,5647,5648,5649,5654],[134,139,140,5649,5654,5655],[139,140,147,148,149,5654,5655,5662,5663,5664]],
[[-50,33,0],[-48,35,0],[-48,33,0,],0xFFFFFF,[139,140,147,148,149,5654,5655,5662,5663,5664],[134,139,140,5649,5654,5655],[140,149,150,5655,5664,5665]],
[[-58,33,0],[-57,33,0],[-58,31,0,],0xFFFFFF,[135,136,141,5650,5651,5656],[136,141,142,143,5651,5656,5657,5658],[141,142,151,5656,5657,5666]],
[[-58,31,0],[-57,33,0],[-57,31,0,],0xFFFFFF,[141,142,151,5656,5657,5666],[136,141,142,143,5651,5656,5657,5658],[142,143,144,151,152,5657,5658,5659,5666,5667]],
[[-57,33,0],[-54,33,0],[-57,31,0,],0xFFFFFF,[136,141,142,143,5651,5656,5657,5658],[137,138,143,144,145,5652,5653,5658,5659,5660],[142,143,144,151,152,5657,5658,5659,5666,5667]],
[[-57,31,0],[-54,33,0],[-54,31,0,],0xFFFFFF,[142,143,144,151,152,5657,5658,5659,5666,5667],[137,138,143,144,145,5652,5653,5658,5659,5660],[144,145,146,153,5659,5660,5661,5668]],
[[-54,33,0],[-52,33,0],[-54,31,0,],0xFFFFFF,[137,138,143,144,145,5652,5653,5658,5659,5660],[138,145,146,147,5653,5660,5661,5662],[144,145,146,153,5659,5660,5661,5668]],
[[-54,31,0],[-52,33,0],[-52,31,0,],0xFFFFFF,[144,145,146,153,5659,5660,5661,5668],[138,145,146,147,5653,5660,5661,5662],[146,147,148,153,154,5661,5662,5663,5668,5669]],
[[-52,33,0],[-50,33,0],[-52,31,0,],0xFFFFFF,[138,145,146,147,5653,5660,5661,5662],[139,140,147,148,149,5654,5655,5662,5663,5664],[146,147,148,153,154,5661,5662,5663,5668,5669]],
[[-52,31,0],[-50,33,0],[-50,31,0,],0xFFFFFF,[146,147,148,153,154,5661,5662,5663,5668,5669],[139,140,147,148,149,5654,5655,5662,5663,5664],[148,149,150,155,5663,5664,5665,5670]],
[[-50,33,0],[-48,33,0],[-50,31,0,],0xFFFFFF,[139,140,147,148,149,5654,5655,5662,5663,5664],[140,149,150,5655,5664,5665],[148,149,150,155,5663,5664,5665,5670]],
[[-50,31,0],[-48,33,0],[-48,31,0,],0xFFFFFF,[148,149,150,155,5663,5664,5665,5670],[140,149,150,5655,5664,5665],[150,155,156,5665,5670,5671]],
[[-58,31,0],[-57,31,0],[-58,30,0,],0xFFFFFF,[141,142,151,5656,5657,5666],[142,143,144,151,152,5657,5658,5659,5666,5667],[151,152,157,5666,5667,5672]],
[[-58,30,0],[-57,31,0],[-57,30,0,],0xFFFFFF,[151,152,157,5666,5667,5672],[142,143,144,151,152,5657,5658,5659,5666,5667],[152,157,158,161,5667,5672,5673,5676]],
[[-54,31,0],[-52,31,0],[-54,30,0,],0xFFFFFF,[144,145,146,153,5659,5660,5661,5668],[146,147,148,153,154,5661,5662,5663,5668,5669],[153,154,161,162,163,5668,5669,5676,5677,5678]],
[[-54,30,0],[-52,31,0],[-52,30,0,],0xFFFFFF,[153,154,161,162,163,5668,5669,5676,5677,5678],[146,147,148,153,154,5661,5662,5663,5668,5669],[154,163,164,165,5669,5678,5679,5680]],
[[-50,31,0],[-48,31,0],[-50,30,0,],0xFFFFFF,[148,149,150,155,5663,5664,5665,5670],[150,155,156,5665,5670,5671],[155,156,165,166,167,5670,5671,5680,5681,5682]],
[[-50,30,0],[-48,31,0],[-48,30,0,],0xFFFFFF,[155,156,165,166,167,5670,5671,5680,5681,5682],[150,155,156,5665,5670,5671],[156,167,168,5671,5682,5683]],
[[-58,30,0],[-57,30,0],[-58,28,0,],0xFFFFFF,[151,152,157,5666,5667,5672],[152,157,158,161,5667,5672,5673,5676],[157,158,159,5672,5673,5674]],
[[-58,28,0],[-57,30,0],[-57,28,0,],0xFFFFFF,[157,158,159,5672,5673,5674],[152,157,158,161,5667,5672,5673,5676],[158,159,160,161,162,5673,5674,5675,5676,5677]],
[[-58,28,0],[-57,28,0],[-58,27,0,],0xFFFFFF,[157,158,159,5672,5673,5674],[158,159,160,161,162,5673,5674,5675,5676,5677],[159,160,5674,5675]],
[[-58,27,0],[-57,28,0],[-57,27,0,],0xFFFFFF,[159,160,5674,5675],[158,159,160,161,162,5673,5674,5675,5676,5677],[160,5675]],
[[-57,30,0],[-54,30,0],[-57,28,0,],0xFFFFFF,[152,157,158,161,5667,5672,5673,5676],[153,154,161,162,163,5668,5669,5676,5677,5678],[158,159,160,161,162,5673,5674,5675,5676,5677]],
[[-57,28,0],[-54,30,0],[-54,28,0,],0xFFFFFF,[158,159,160,161,162,5673,5674,5675,5676,5677],[153,154,161,162,163,5668,5669,5676,5677,5678],[162,163,164,179,5677,5678,5679,5694]],
[[-54,30,0],[-52,30,0],[-54,28,0,],0xFFFFFF,[153,154,161,162,163,5668,5669,5676,5677,5678],[154,163,164,165,5669,5678,5679,5680],[162,163,164,179,5677,5678,5679,5694]],
[[-54,28,0],[-52,30,0],[-52,28,0,],0xFFFFFF,[162,163,164,179,5677,5678,5679,5694],[154,163,164,165,5669,5678,5679,5680],[164,165,166,179,180,5679,5680,5681,5694,5695]],
[[-52,30,0],[-50,30,0],[-52,28,0,],0xFFFFFF,[154,163,164,165,5669,5678,5679,5680],[155,156,165,166,167,5670,5671,5680,5681,5682],[164,165,166,179,180,5679,5680,5681,5694,5695]],
[[-52,28,0],[-50,30,0],[-50,28,0,],0xFFFFFF,[164,165,166,179,180,5679,5680,5681,5694,5695],[155,156,165,166,167,5670,5671,5680,5681,5682],[166,167,168,169,5681,5682,5683,5684]],
[[-50,30,0],[-48,30,0],[-50,28,0,],0xFFFFFF,[155,156,165,166,167,5670,5671,5680,5681,5682],[156,167,168,5671,5682,5683],[166,167,168,169,5681,5682,5683,5684]],
[[-50,28,0],[-48,30,0],[-48,28,0,],0xFFFFFF,[166,167,168,169,5681,5682,5683,5684],[156,167,168,5671,5682,5683],[168,169,170,5683,5684,5685]],
[[-50,28,0],[-48,28,0],[-50,27,0,],0xFFFFFF,[166,167,168,169,5681,5682,5683,5684],[168,169,170,5683,5684,5685],[169,170,5684,5685]],
[[-50,27,0],[-48,28,0],[-48,27,0,],0xFFFFFF,[169,170,5684,5685],[168,169,170,5683,5684,5685],[170,5685]],
[[-54,26,0],[-54,25,0],[-59,26,0,],0xFFFFFF,[171,173,179,180,5686,5688,5694,5695],[171,172,173,174,177,5686,5687,5688,5689,5692],[171,172,5686,5687]],
[[-54,25,0],[-59,25,0],[-59,26,0,],0xFFFFFF,[171,172,173,174,177,5686,5687,5688,5689,5692],[172,5687],[171,172,5686,5687]],
[[-54,26,0],[-52,26,0],[-54,25,0,],0xFFFFFF,[171,173,179,180,5686,5688,5694,5695],[173,174,175,180,5688,5689,5690,5695],[171,172,173,174,177,5686,5687,5688,5689,5692]],
[[-54,25,0],[-52,26,0],[-52,25,0,],0xFFFFFF,[171,172,173,174,177,5686,5687,5688,5689,5692],[173,174,175,180,5688,5689,5690,5695],[174,175,176,177,178,5689,5690,5691,5692,5693]],
[[-52,26,0],[-47,26,0],[-52,25,0,],0xFFFFFF,[173,174,175,180,5688,5689,5690,5695],[175,176,5690,5691],[174,175,176,177,178,5689,5690,5691,5692,5693]],
[[-52,25,0],[-47,26,0],[-47,25,0,],0xFFFFFF,[174,175,176,177,178,5689,5690,5691,5692,5693],[175,176,5690,5691],[176,5691]],
[[-54,25,0],[-52,25,0],[-54,20,0,],0xFFFFFF,[171,172,173,174,177,5686,5687,5688,5689,5692],[174,175,176,177,178,5689,5690,5691,5692,5693],[177,178,5692,5693]],
[[-52,25,0],[-52,20,0],[-54,20,0,],0xFFFFFF,[174,175,176,177,178,5689,5690,5691,5692,5693],[178,5693],[177,178,5692,5693]],
[[-54,28,0],[-52,28,0],[-54,26,0,],0xFFFFFF,[162,163,164,179,5677,5678,5679,5694],[164,165,166,179,180,5679,5680,5681,5694,5695],[171,173,179,180,5686,5688,5694,5695]],
[[-52,28,0],[-52,26,0],[-54,26,0,],0xFFFFFF,[164,165,166,179,180,5679,5680,5681,5694,5695],[173,174,175,180,5688,5689,5690,5695],[171,173,179,180,5686,5688,5694,5695]],
[[-46,41,0],[-44,41,0],[-45,33,0,],0xFFFFFF,[181,5696],[181,182,5696,5697],[181,182,183,5696,5697,5698]],
[[-44,41,0],[-44,33,0],[-45,33,0,],0xFFFFFF,[181,182,5696,5697],[182,183,184,5697,5698,5699],[181,182,183,5696,5697,5698]],
[[-45,33,0],[-44,33,0],[-45,29,0,],0xFFFFFF,[181,182,183,5696,5697,5698],[182,183,184,5697,5698,5699],[183,184,198,5698,5699,5700,5700,5713]],
[[-44,33,0],[-43,28,0],[-45,29,0,],0xFFFFFF,[182,183,184,5697,5698,5699],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[183,184,198,5698,5699,5700,5700,5713]],
[[-45,28,0],[-45,28,0],[-44,25,0,],0xFFFFFF,[185,185],[185,185],[185]],
[[-44,26,0],[-43,28,0],[-43,24,0,],0xFFFFFF,[186,188,198,5700,5701,5703,5713],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[186,187,188,189,192,5701,5702,5703,5704,5707]],
[[-43,28,0],[-42,26,0],[-43,24,0,],0xFFFFFF,[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[187,192,193,199,5702,5707,5708,5714],[186,187,188,189,192,5701,5702,5703,5704,5707]],
[[-44,26,0],[-43,24,0],[-47,24,0,],0xFFFFFF,[186,188,198,5700,5701,5703,5713],[186,187,188,189,192,5701,5702,5703,5704,5707],[188,189,190,5703,5704,5705]],
[[-47,24,0],[-43,24,0],[-47,21,0,],0xFFFFFF,[188,189,190,5703,5704,5705],[186,187,188,189,192,5701,5702,5703,5704,5707],[189,190,191,5704,5705,5706]],
[[-47,21,0],[-50,22,0],[-47,24,0,],0xFFFFFF,[189,190,191,5704,5705,5706],[190,191,5705,5706],[188,189,190,5703,5704,5705]],
[[-50,22,0],[-47,21,0],[-49,19,0,],0xFFFFFF,[190,191,5705,5706],[189,190,191,5704,5705,5706],[191,5706]],
[[-43,24,0],[-42,26,0],[-42,21,0,],0xFFFFFF,[186,187,188,189,192,5701,5702,5703,5704,5707],[187,192,193,199,5702,5707,5708,5714],[192,193,5707,5708]],
[[-42,26,0],[-40,23,0],[-42,21,0,],0xFFFFFF,[187,192,193,199,5702,5707,5708,5714],[193,194,195,197,5708,5709,5710,5712],[192,193,5707,5708]],
[[-40,23,0],[-40,20,0],[-42,22,0,],0xFFFFFF,[193,194,195,197,5708,5709,5710,5712],[194,195,5709,5710],[194,5709]],
[[-40,23,0],[-38,22,0],[-40,20,0,],0xFFFFFF,[193,194,195,197,5708,5709,5710,5712],[195,196,197,5710,5711,5712],[194,195,5709,5710]],
[[-38,22,0],[-40,26,0],[-38,24,0,],0xFFFFFF,[195,196,197,5710,5711,5712],[196,197,5711,5712],[196,5711]],
[[-40,26,0],[-38,22,0],[-40,23,0,],0xFFFFFF,[196,197,5711,5712],[195,196,197,5710,5711,5712],[193,194,195,197,5708,5709,5710,5712]],
[[-45,29,0],[-43,28,0],[-44,26,0,],0xFFFFFF,[183,184,198,5698,5699,5700,5700,5713],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[186,188,198,5700,5701,5703,5713]],
[[-43,28,0],[-40,29,0],[-42,26,0,],0xFFFFFF,[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[199,200,201,5714,5715,5716],[187,192,193,199,5702,5707,5708,5714]],
[[-40,29,0],[-43,28,0],[-41,32,0,],0xFFFFFF,[199,200,201,5714,5715,5716],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[200,201,5715,5716]],
[[-41,32,0],[-39,32,0],[-40,29,0,],0xFFFFFF,[200,201,5715,5716],[201,5716],[199,200,201,5714,5715,5716]],
[[-48,35,0],[-39,35,0],[-48,33,0,],0xFFFFFF,[202,5717],[202,203,5717,5718],[202,203,5717,5718]],
[[-48,33,0],[-39,35,0],[-39,33,0,],0xFFFFFF,[202,203,5717,5718],[202,203,5717,5718],[203,5718]],
[[-43,39,0],[-41,40,0],[-41,36,0,],0xFFFFFF,[204,5719],[204,205,5719,5720],[204,205,5719,5720]],
[[-41,40,0],[-40,37,0],[-41,36,0,],0xFFFFFF,[204,205,5719,5720],[205,5720],[204,205,5719,5720]],
[[-24,35,0],[-24,32,0],[-26,35,0,],0xFFFFFF,[206,212,213,216,5721,5727,5728,5731],[206,207,213,218,5721,5722,5728,5733],[206,207,210,216,217,5721,5722,5725,5731,5732]],
[[-24,32,0],[-26,32,0],[-26,35,0,],0xFFFFFF,[206,207,213,218,5721,5722,5728,5733],[207,210,211,218,219,5722,5725,5726,5733,5734],[206,207,210,216,217,5721,5722,5725,5731,5732]],
[[-35,35,0],[-34,35,0],[-35,32,0,],0xFFFFFF,[208,5723],[208,209,210,211,5723,5724,5725,5726],[208,209,5723,5724]],
[[-35,32,0],[-34,35,0],[-34,32,0,],0xFFFFFF,[208,209,5723,5724],[208,209,210,211,5723,5724,5725,5726],[209,211,5724,5726]],
[[-26,35,0],[-26,32,0],[-34,35,0,],0xFFFFFF,[206,207,210,216,217,5721,5722,5725,5731,5732],[207,210,211,218,219,5722,5725,5726,5733,5734],[208,209,210,211,5723,5724,5725,5726]],
[[-26,32,0],[-34,32,0],[-34,35,0,],0xFFFFFF,[207,210,211,218,219,5722,5725,5726,5733,5734],[209,211,5724,5726],[208,209,210,211,5723,5724,5725,5726]],
[[-17,35,0],[-17,32,0],[-24,35,0,],0xFFFFFF,[212,214,215,5727,5729,5730],[212,213,215,5727,5728,5730],[206,212,213,216,5721,5727,5728,5731]],
[[-17,32,0],[-24,32,0],[-24,35,0,],0xFFFFFF,[212,213,215,5727,5728,5730],[206,207,213,218,5721,5722,5728,5733],[206,212,213,216,5721,5727,5728,5731]],
[[-15,35,0],[-15,32,0],[-17,35,0,],0xFFFFFF,[214,5729],[214,215,5729,5730],[212,214,215,5727,5729,5730]],
[[-15,32,0],[-17,32,0],[-17,35,0,],0xFFFFFF,[214,215,5729,5730],[212,213,215,5727,5728,5730],[212,214,215,5727,5729,5730]],
[[-24,35,0],[-26,35,0],[-24,40,0,],0xFFFFFF,[206,212,213,216,5721,5727,5728,5731],[206,207,210,216,217,5721,5722,5725,5731,5732],[216,217,5731,5732]],
[[-26,35,0],[-26,40,0],[-24,40,0,],0xFFFFFF,[206,207,210,216,217,5721,5722,5725,5731,5732],[217,5732],[216,217,5731,5732]],
[[-24,32,0],[-24,24,0],[-26,32,0,],0xFFFFFF,[206,207,213,218,5721,5722,5728,5733],[218,219,220,224,225,5733,5734,5735,5739,5740],[207,210,211,218,219,5722,5725,5726,5733,5734]],
[[-24,24,0],[-26,24,0],[-26,32,0,],0xFFFFFF,[218,219,220,224,225,5733,5734,5735,5739,5740],[219,220,221,222,5734,5735,5736,5737],[207,210,211,218,219,5722,5725,5726,5733,5734]],
[[-24,24,0],[-24,22,0],[-26,24,0,],0xFFFFFF,[218,219,220,224,225,5733,5734,5735,5739,5740],[220,221,225,5735,5736,5740],[219,220,221,222,5734,5735,5736,5737]],
[[-24,22,0],[-26,22,0],[-26,24,0,],0xFFFFFF,[220,221,225,5735,5736,5740],[221,222,223,5736,5737,5738],[219,220,221,222,5734,5735,5736,5737]],
[[-26,24,0],[-26,22,0],[-34,24,0,],0xFFFFFF,[219,220,221,222,5734,5735,5736,5737],[221,222,223,5736,5737,5738],[222,223,5737,5738]],
[[-26,22,0],[-34,22,0],[-34,24,0,],0xFFFFFF,[221,222,223,5736,5737,5738],[223,5738],[222,223,5737,5738]],
[[-17,24,0],[-17,22,0],[-24,24,0,],0xFFFFFF,[224,5739],[224,225,5739,5740],[218,219,220,224,225,5733,5734,5735,5739,5740]],
[[-17,22,0],[-24,22,0],[-24,24,0,],0xFFFFFF,[224,225,5739,5740],[220,221,225,5735,5736,5740],[218,219,220,224,225,5733,5734,5735,5739,5740]],
[[-165,0,0],[-159,0,0],[-170,-10,0,],0xFFFFFF,[226,360],[226,227,229,230,360,361,363,364],[226,227,360,361]],
[[-159,0,0],[-165,-10,0],[-170,-10,0,],0xFFFFFF,[226,227,229,230,360,361,363,364],[227,228,229,232,361,362,363,366],[226,227,360,361]],
[[-165,-10,0],[-164,-38,0],[-177,-38,0,],0xFFFFFF,[227,228,229,232,361,362,363,366],[228,232,362,366],[228,362]],
[[-165,-10,0],[-159,0,0],[-154,-10,0,],0xFFFFFF,[227,228,229,232,361,362,363,366],[226,227,229,230,360,361,363,364],[229,230,231,232,233,363,364,365,366,367]],
[[-154,-10,0],[-159,0,0],[-155,7,0,],0xFFFFFF,[229,230,231,232,233,363,364,365,366,367],[226,227,229,230,360,361,363,364],[230,231,364,365]],
[[-155,7,0],[-148,7,0],[-154,-10,0,],0xFFFFFF,[230,231,364,365],[231,365],[229,230,231,232,233,363,364,365,366,367]],
[[-165,-10,0],[-154,-10,0],[-164,-38,0,],0xFFFFFF,[227,228,229,232,361,362,363,366],[229,230,231,232,233,363,364,365,366,367],[228,232,362,366]],
[[-154,-10,0],[-150,0,0],[-149,-10,0,],0xFFFFFF,[229,230,231,232,233,363,364,365,366,367],[233,234,235,367,368,369],[233,234,236,367,368,370]],
[[-150,0,0],[-139,-4,0],[-149,-10,0,],0xFFFFFF,[233,234,235,367,368,369],[234,235,236,237,368,369,370,371],[233,234,236,367,368,370]],
[[-150,0,0],[-134,0,0],[-139,-4,0,],0xFFFFFF,[233,234,235,367,368,369],[235,369],[234,235,236,237,368,369,370,371]],
[[-149,-10,0],[-139,-4,0],[-158,-38,0,],0xFFFFFF,[233,234,236,367,368,370],[234,235,236,237,368,369,370,371],[236,237,370,371]],
[[-139,-4,0],[-148,-38,0],[-158,-38,0,],0xFFFFFF,[234,235,236,237,368,369,370,371],[237,371],[236,237,370,371]],
[[-131,2,0],[-124,-11,0],[-135,-11,0,],0xFFFFFF,[238,239,240,372,373,374],[238,239,372,373],[238,372]],
[[-131,2,0],[-123,-2,0],[-124,-11,0,],0xFFFFFF,[238,239,240,372,373,374],[239,240,373,374],[238,239,372,373]],
[[-131,2,0],[-117,3,0],[-123,-2,0,],0xFFFFFF,[238,239,240,372,373,374],[240,374],[239,240,373,374]],
[[-145,10,0],[-138,10,0],[-145,2,0,],0xFFFFFF,[241,375],[241,242,243,375,376,377],[241,375]],
[[-138,10,0],[-130,10,0],[-138,2,0,],0xFFFFFF,[241,242,243,375,376,377],[242,376],[242,243,376,377]],
[[-138,2,0],[-141,6,0],[-138,10,0,],0xFFFFFF,[242,243,376,377],[243,377],[241,242,243,375,376,377]],
[[-86,10,0],[-79,10,0],[-86,2,0,],0xFFFFFF,[244,378],[244,245,246,378,379,380],[244,378]],
[[-79,10,0],[-70,10,0],[-78,2,0,],0xFFFFFF,[244,245,246,378,379,380],[245,379],[245,246,379,380]],
[[-78,2,0],[-82,6,0],[-79,10,0,],0xFFFFFF,[245,246,379,380],[246,380],[244,245,246,378,379,380]],
[[-140,-26,0],[-121,-38,0],[-144,-37,0,],0xFFFFFF,[247,248,381,382],[247,248,249,250,381,382,383,384],[247,381]],
[[-140,-26,0],[-130,-25,0],[-121,-38,0,],0xFFFFFF,[247,248,381,382],[248,249,382,383],[247,248,249,250,381,382,383,384]],
[[-130,-25,0],[-117,-4,0],[-121,-38,0,],0xFFFFFF,[248,249,382,383],[249,250,251,383,384,385],[247,248,249,250,381,382,383,384]],
[[-117,-4,0],[-111,-8,0],[-121,-38,0,],0xFFFFFF,[249,250,251,383,384,385],[250,251,384,385],[247,248,249,250,381,382,383,384]],
[[-117,-4,0],[-107,-4,0],[-111,-8,0,],0xFFFFFF,[249,250,251,383,384,385],[251,385],[250,251,384,385]],
[[-103,1,0],[-101,-11,0],[-110,-11,0,],0xFFFFFF,[252,253,254,255,386,387,388,389],[252,253,386,387],[252,386]],
[[-101,-11,0],[-103,1,0],[-98,-8,0,],0xFFFFFF,[252,253,386,387],[252,253,254,255,386,387,388,389],[253,254,387,388]],
[[-98,-8,0],[-103,1,0],[-90,-8,0,],0xFFFFFF,[253,254,387,388],[252,253,254,255,386,387,388,389],[254,255,388,389]],
[[-90,-8,0],[-103,1,0],[-85,1,0,],0xFFFFFF,[254,255,388,389],[252,253,254,255,386,387,388,389],[255,256,257,258,389,390,391,392]],
[[-85,1,0],[-95,-37,0],[-94,-15,0,],0xFFFFFF,[255,256,257,258,389,390,391,392],[256,257,261,270,390,391,395,404],[256,259,260,270,390,393,394,404]],
[[-85,1,0],[-79,-2,0],[-95,-37,0,],0xFFFFFF,[255,256,257,258,389,390,391,392],[257,258,391,392],[256,257,261,270,390,391,395,404]],
[[-85,1,0],[-71,1,0],[-79,-2,0,],0xFFFFFF,[255,256,257,258,389,390,391,392],[258,392],[257,258,391,392]],
[[-94,-15,0],[-109,-20,0],[-105,-15,0,],0xFFFFFF,[256,259,260,270,390,393,394,404],[259,260,393,394],[259,393]],
[[-109,-20,0],[-94,-15,0],[-102,-25,0,],0xFFFFFF,[259,260,393,394],[256,259,260,270,390,393,394,404],[260,261,270,394,395,404]],
[[-102,-25,0],[-95,-37,0],[-109,-37,0,],0xFFFFFF,[260,261,270,394,395,404],[256,257,261,270,390,391,395,404],[261,395]],
[[-66,9,0],[-72,-24,0],[-90,-37,0,],0xFFFFFF,[262,263,264,396,397,398],[262,263,265,266,396,397,399,400],[262,265,396,399]],
[[-66,9,0],[-59,5,0],[-72,-24,0,],0xFFFFFF,[262,263,264,396,397,398],[263,264,397,398],[262,263,265,266,396,397,399,400]],
[[-66,9,0],[-48,9,0],[-59,5,0,],0xFFFFFF,[262,263,264,396,397,398],[264,398],[263,264,397,398]],
[[-72,-24,0],[-50,-38,0],[-90,-37,0,],0xFFFFFF,[262,263,265,266,396,397,399,400],[265,266,267,268,399,400,401,402],[262,265,396,399]],
[[-72,-24,0],[-62,-24,0],[-50,-38,0,],0xFFFFFF,[262,263,265,266,396,397,399,400],[266,267,400,401],[265,266,267,268,399,400,401,402]],
[[-62,-24,0],[-64,-9,0],[-50,-38,0,],0xFFFFFF,[266,267,400,401],[267,268,269,401,402,403],[265,266,267,268,399,400,401,402]],
[[-64,-9,0],[-54,-15,0],[-50,-38,0,],0xFFFFFF,[267,268,269,401,402,403],[268,269,402,403],[265,266,267,268,399,400,401,402]],
[[-64,-9,0],[-37,-9,0],[-54,-15,0,],0xFFFFFF,[267,268,269,401,402,403],[269,403],[268,269,402,403]],
[[-94,-15,0],[-95,-37,0],[-102,-25,0,],0xFFFFFF,[256,259,260,270,390,393,394,404],[256,257,261,270,390,391,395,404],[260,261,270,394,395,404]],
[[-125,-41,0],[-118,-78,0],[-125,-78,0,],0x00FFFF,[271,322,405,456],[271,273,274,275,276,322,405,407,408,409,410,456],[271,273,405,407]],
[[-112,-41,0],[-105,-78,0],[-112,-78,0,],0x00FFFF,[272,323,406,457],[272,279,323,406,413,457],[272,279,280,281,321,406,413,414,415,455]],
[[-118,-78,0],[-124,-83,0],[-125,-78,0,],0x00FFFF,[271,273,274,275,276,322,405,407,408,409,410,456],[273,274,407,408],[271,273,405,407]],
[[-118,-78,0],[-122,-86,0],[-124,-83,0,],0x00FFFF,[271,273,274,275,276,322,405,407,408,409,410,456],[274,275,408,409],[273,274,407,408]],
[[-118,-78,0],[-118,-89,0],[-122,-86,0,],0x00FFFF,[271,273,274,275,276,322,405,407,408,409,410,456],[275,276,277,409,410,411],[274,275,408,409]],
[[-118,-89,0],[-118,-78,0],[-115,-82,0,],0x00FFFF,[275,276,277,409,410,411],[271,273,274,275,276,322,405,407,408,409,410,456],[276,277,278,321,410,411,412,455]],
[[-115,-82,0],[-115,-90,0],[-118,-89,0,],0x00FFFF,[276,277,278,321,410,411,412,455],[277,278,411,412],[275,276,277,409,410,411]],
[[-115,-90,0],[-115,-82,0],[-112,-89,0,],0x00FFFF,[277,278,411,412],[276,277,278,321,410,411,412,455],[278,281,321,412,415,455]],
[[-112,-78,0],[-105,-78,0],[-107,-83,0,],0x00FFFF,[272,279,280,281,321,406,413,414,415,455],[272,279,323,406,413,457],[279,280,413,414]],
[[-112,-78,0],[-107,-83,0],[-108,-87,0,],0x00FFFF,[272,279,280,281,321,406,413,414,415,455],[279,280,413,414],[280,281,414,415]],
[[-112,-78,0],[-108,-87,0],[-112,-89,0,],0x00FFFF,[272,279,280,281,321,406,413,414,415,455],[280,281,414,415],[278,281,321,412,415,455]],
[[-105,-41,0],[-99,-41,0],[-105,-89,0,],0x00FFFF,[282,323,416,457],[282,283,284,285,416,417,418,419],[282,283,416,417]],
[[-99,-41,0],[-99,-89,0],[-105,-89,0,],0x00FFFF,[282,283,284,285,416,417,418,419],[283,417],[282,283,416,417]],
[[-99,-41,0],[-93,-64,0],[-93,-89,0,],0x00FFFF,[282,283,284,285,416,417,418,419],[284,418],[284,285,286,287,418,419,420,421]],
[[-99,-41,0],[-93,-89,0],[-99,-66,0,],0x00FFFF,[282,283,284,285,416,417,418,419],[284,285,286,287,418,419,420,421],[285,419]],
[[-93,-89,0],[-93,-41,0],[-86,-41,0,],0x00FFFF,[284,285,286,287,418,419,420,421],[286,420],[286,287,288,420,421,422]],
[[-86,-41,0],[-86,-89,0],[-93,-89,0,],0x00FFFF,[286,287,288,420,421,422],[287,288,289,421,422,423],[284,285,286,287,418,419,420,421]],
[[-86,-41,0],[-80,-41,0],[-86,-89,0,],0x00FFFF,[286,287,288,420,421,422],[288,289,295,422,423,429],[287,288,289,421,422,423]],
[[-80,-41,0],[-80,-89,0],[-86,-89,0,],0x00FFFF,[288,289,295,422,423,429],[289,290,291,423,424,425],[287,288,289,421,422,423]],
[[-76,-79,0],[-80,-89,0],[-80,-81,0,],0x00FFFF,[290,291,292,293,294,424,425,426,427,428],[289,290,291,423,424,425],[290,424]],
[[-76,-79,0],[-72,-86,0],[-80,-89,0,],0x00FFFF,[290,291,292,293,294,424,425,426,427,428],[291,292,425,426],[289,290,291,423,424,425]],
[[-76,-79,0],[-70,-83,0],[-72,-86,0,],0x00FFFF,[290,291,292,293,294,424,425,426,427,428],[292,293,426,427],[291,292,425,426]],
[[-76,-79,0],[-67,-73,0],[-70,-83,0,],0x00FFFF,[290,291,292,293,294,424,425,426,427,428],[293,294,303,427,428,437],[292,293,426,427]],
[[-76,-79,0],[-75,-75,0],[-67,-73,0,],0x00FFFF,[290,291,292,293,294,424,425,426,427,428],[294,302,303,428,436,437],[293,294,303,427,428,437]],
[[-80,-50,0],[-80,-41,0],[-73,-43,0,],0x00FFFF,[295,296,429,430],[288,289,295,422,423,429],[295,296,297,429,430,431]],
[[-73,-43,0],[-77,-50,0],[-80,-50,0,],0x00FFFF,[295,296,297,429,430,431],[296,297,298,299,430,431,432,433],[295,296,429,430]],
[[-77,-50,0],[-73,-43,0],[-71,-46,0,],0x00FFFF,[296,297,298,299,430,431,432,433],[295,296,297,429,430,431],[297,298,431,432]],
[[-77,-50,0],[-71,-46,0],[-67,-57,0,],0x00FFFF,[296,297,298,299,430,431,432,433],[297,298,431,432],[298,299,300,301,432,433,434,435]],
[[-67,-57,0],[-75,-54,0],[-77,-50,0,],0x00FFFF,[298,299,300,301,432,433,434,435],[299,300,433,434],[296,297,298,299,430,431,432,433]],
[[-75,-54,0],[-67,-57,0],[-74,-65,0,],0x00FFFF,[299,300,433,434],[298,299,300,301,432,433,434,435],[300,301,302,434,435,436]],
[[-67,-57,0],[-66,-65,0],[-74,-65,0,],0x00FFFF,[298,299,300,301,432,433,434,435],[301,302,303,435,436,437],[300,301,302,434,435,436]],
[[-74,-65,0],[-66,-65,0],[-75,-75,0,],0x00FFFF,[300,301,302,434,435,436],[301,302,303,435,436,437],[294,302,303,428,436,437]],
[[-66,-65,0],[-67,-73,0],[-75,-75,0,],0x00FFFF,[301,302,303,435,436,437],[293,294,303,427,428,437],[294,302,303,428,436,437]],
[[-62,-41,0],[-55,-41,0],[-69,-89,0,],0x00FFFF,[304,307,438,441],[304,305,306,307,438,439,440,441],[304,305,438,439]],
[[-55,-41,0],[-63,-89,0],[-69,-89,0,],0x00FFFF,[304,305,306,307,438,439,440,441],[305,439],[304,305,438,439]],
[[-55,-41,0],[-47,-89,0],[-54,-89,0,],0x00FFFF,[304,305,306,307,438,439,440,441],[306,440],[306,307,440,441]],
[[-54,-89,0],[-62,-41,0],[-55,-41,0,],0x00FFFF,[306,307,440,441],[304,307,438,441],[304,305,306,307,438,439,440,441]],
[[-60,-72,0],[-57,-72,0],[-62,-81,0,],0x00FFFF,[308,442],[308,309,442,443],[308,309,442,443]],
[[-57,-72,0],[-55,-81,0],[-62,-81,0,],0x00FFFF,[308,309,442,443],[309,443],[308,309,442,443]],
[[-39,-89,0],[-47,-41,0],[-40,-41,0,],0x00FFFF,[310,311,312,444,445,446],[310,313,444,447],[310,311,444,445]],
[[-40,-41,0],[-37,-73,0],[-39,-89,0,],0x00FFFF,[310,311,444,445],[311,312,315,316,445,446,449,450],[310,311,312,444,445,446]],
[[-37,-73,0],[-35,-89,0],[-39,-89,0,],0x00FFFF,[311,312,315,316,445,446,449,450],[312,315,316,317,446,449,450,451],[310,311,312,444,445,446]],
[[-43,-67,0],[-47,-89,0],[-47,-41,0,],0x00FFFF,[313,314,447,448],[313,314,447,448],[310,313,444,447]],
[[-43,-67,0],[-43,-89,0],[-47,-89,0,],0x00FFFF,[313,314,447,448],[314,448],[313,314,447,448]],
[[-37,-73,0],[-33,-41,0],[-35,-89,0,],0x00FFFF,[311,312,315,316,445,446,449,450],[315,316,317,318,449,450,451,452],[312,315,316,317,446,449,450,451]],
[[-33,-41,0],[-35,-89,0],[-37,-73,0,],0x00FFFF,[315,316,317,318,449,450,451,452],[312,315,316,317,446,449,450,451],[311,312,315,316,445,446,449,450]],
[[-33,-41,0],[-32,-67,0],[-35,-89,0,],0x00FFFF,[315,316,317,318,449,450,451,452],[317,318,319,320,451,452,453,454],[312,315,316,317,446,449,450,451]],
[[-32,-67,0],[-33,-41,0],[-27,-41,0,],0x00FFFF,[317,318,319,320,451,452,453,454],[315,316,317,318,449,450,451,452],[318,319,452,453]],
[[-32,-67,0],[-27,-41,0],[-27,-89,0,],0x00FFFF,[317,318,319,320,451,452,453,454],[318,319,452,453],[319,320,453,454]],
[[-32,-67,0],[-27,-89,0],[-32,-89,0,],0x00FFFF,[317,318,319,320,451,452,453,454],[319,320,453,454],[320,454]],
[[-115,-82,0],[-112,-78,0],[-112,-89,0,],0x00FFFF,[276,277,278,321,410,411,412,455],[272,279,280,281,321,406,413,414,415,455],[278,281,321,412,415,455]],
[[-125,-41,0],[-118,-41,0],[-118,-78,0,],0x00FFFF,[271,322,405,456],[322,456],[271,273,274,275,276,322,405,407,408,409,410,456]],
[[-112,-41,0],[-105,-41,0],[-105,-78,0,],0x00FFFF,[272,323,406,457],[282,323,416,457],[272,279,323,406,413,457]],
[[-152,13,0],[-116,50,0],[-113,40,0,],0x00FFFF,[324,325,326,327,356,458,459,460,461,490],[324,325,458,459],[324,356,458,490]],
[[-152,13,0],[-120,56,0],[-116,50,0,],0x00FFFF,[324,325,326,327,356,458,459,460,461,490],[325,326,459,460],[324,325,458,459]],
[[-152,13,0],[-127,59,0],[-120,56,0,],0x00FFFF,[324,325,326,327,356,458,459,460,461,490],[326,327,357,358,460,461,491,492],[325,326,459,460]],
[[-127,59,0],[-152,13,0],[-151,29,0,],0x00FFFF,[326,327,357,358,460,461,491,492],[324,325,326,327,356,458,459,460,461,490],[327,357,461,491]],
[[-154,31,0],[-178,32,0],[-191,59,0,],0x00FFFF,[328,357,358,462,491,492],[328,329,462,463],[328,329,330,331,358,462,463,464,465,492]],
[[-191,59,0],[-178,32,0],[-181,31,0,],0x00FFFF,[328,329,330,331,358,462,463,464,465,492],[328,329,462,463],[329,330,463,464]],
[[-181,31,0],[-188,28,0],[-191,59,0,],0x00FFFF,[329,330,463,464],[330,331,332,333,334,355,464,465,466,467,468,489],[328,329,330,331,358,462,463,464,465,492]],
[[-191,59,0],[-188,28,0],[-203,58,0,],0x00FFFF,[328,329,330,331,358,462,463,464,465,492],[330,331,332,333,334,355,464,465,466,467,468,489],[331,332,465,466]],
[[-188,28,0],[-210,52,0],[-203,58,0,],0x00FFFF,[330,331,332,333,334,355,464,465,466,467,468,489],[332,333,466,467],[331,332,465,466]],
[[-210,52,0],[-188,28,0],[-216,44,0,],0x00FFFF,[332,333,466,467],[330,331,332,333,334,355,464,465,466,467,468,489],[333,334,467,468]],
[[-216,44,0],[-188,28,0],[-218,36,0,],0x00FFFF,[333,334,467,468],[330,331,332,333,334,355,464,465,466,467,468,489],[334,335,355,468,469,489]],
[[-190,22,0],[-239,-95,0],[-218,36,0,],0x00FFFF,[335,354,355,469,488,489],[335,336,337,338,354,469,470,471,472,488],[334,335,355,468,469,489]],
[[-205,-89,0],[-239,-95,0],[-206,-86,0,],0x00FFFF,[336,337,470,471],[335,336,337,338,354,469,470,471,472,488],[336,354,470,488]],
[[-239,-95,0],[-205,-89,0],[-201,-94,0,],0x00FFFF,[335,336,337,338,354,469,470,471,472,488],[336,337,470,471],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-239,-95,0],[-201,-94,0],[-237,-104,0,],0x00FFFF,[335,336,337,338,354,469,470,471,472,488],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[338,339,472,473]],
[[-237,-104,0],[-201,-94,0],[-234,-112,0,],0x00FFFF,[338,339,472,473],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[339,340,473,474]],
[[-234,-112,0],[-201,-94,0],[-229,-118,0,],0x00FFFF,[339,340,473,474],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[340,341,474,475]],
[[-229,-118,0],[-201,-94,0],[-216,-126,0,],0x00FFFF,[340,341,474,475],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[341,342,475,476]],
[[-216,-126,0],[-201,-94,0],[-183,-126,0,],0x00FFFF,[341,342,475,476],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[342,343,476,477]],
[[-201,-94,0],[-177,-123,0],[-183,-126,0,],0x00FFFF,[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[343,344,477,478],[342,343,476,477]],
[[-177,-123,0],[-201,-94,0],[-169,-117,0,],0x00FFFF,[343,344,477,478],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[344,345,346,347,348,478,479,480,481,482]],
[[-201,-94,0],[-176,-91,0],[-169,-117,0,],0x00FFFF,[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[345,346,479,480],[344,345,346,347,348,478,479,480,481,482]],
[[-176,-91,0],[-170,-88,0],[-169,-117,0,],0x00FFFF,[345,346,479,480],[346,348,349,480,482,483],[344,345,346,347,348,478,479,480,481,482]],
[[-169,-117,0],[-142,-127,0],[-172,-127,0,],0x00FFFF,[344,345,346,347,348,478,479,480,481,482],[347,481],[347,481]],
[[-142,-127,0],[-169,-117,0],[-170,-88,0,],0x00FFFF,[348,349,350,351,353,482,483,484,485,487],[344,345,346,347,348,478,479,480,481,482],[346,348,349,480,482,483]],
[[-170,-88,0],[-167,-85,0],[-142,-127,0,],0x00FFFF,[346,348,349,480,482,483],[349,350,353,483,484,487],[348,349,350,351,353,482,483,484,485,487]],
[[-142,-127,0],[-167,-85,0],[-164,-66,0,],0x00FFFF,[348,349,350,351,353,482,483,484,485,487],[349,350,353,483,484,487],[350,351,352,353,359,484,485,486,487,493]],
[[-164,-66,0],[-125,-40,0],[-142,-127,0,],0x00FFFF,[350,351,352,353,359,484,485,486,487,493],[351,352,485,486],[348,349,350,351,353,482,483,484,485,487]],
[[-125,-40,0],[-164,-66,0],[-178,-40,0,],0x00FFFF,[351,352,485,486],[350,351,352,353,359,484,485,486,487,493],[352,359,486,493]],
[[-167,-85,0],[-164,-66,0],[-142,-127,0,],0x00FFFF,[349,350,353,483,484,487],[350,351,352,353,359,484,485,486,487,493],[348,349,350,351,353,482,483,484,485,487]],
[[-190,22,0],[-206,-86,0],[-239,-95,0,],0x00FFFF,[335,354,355,469,488,489],[336,354,470,488],[335,336,337,338,354,469,470,471,472,488]],
[[-188,28,0],[-190,22,0],[-218,36,0,],0x00FFFF,[330,331,332,333,334,355,464,465,466,467,468,489],[335,354,355,469,488,489],[334,335,355,468,469,489]],
[[-152,13,0],[-113,40,0],[-119,13,0,],0x00FFFF,[324,325,326,327,356,458,459,460,461,490],[324,356,458,490],[356,490]],
[[-154,31,0],[-127,59,0],[-151,29,0,],0x00FFFF,[328,357,358,462,491,492],[326,327,357,358,460,461,491,492],[327,357,461,491]],
[[-127,59,0],[-154,31,0],[-191,59,0,],0x00FFFF,[326,327,357,358,460,461,491,492],[328,357,358,462,491,492],[328,329,330,331,358,462,463,464,465,492]],
[[-164,-66,0],[-182,-66,0],[-178,-40,0,],0x00FFFF,[350,351,352,353,359,484,485,486,487,493],[359,493],[352,359,486,493]],
[[-165,0,0],[-170,-10,0],[-159,0,0,],0xFFFFFF,[226,360],[226,227,360,361],[226,227,229,230,360,361,363,364]],
[[-159,0,0],[-170,-10,0],[-165,-10,0,],0xFFFFFF,[226,227,229,230,360,361,363,364],[226,227,360,361],[227,228,229,232,361,362,363,366]],
[[-165,-10,0],[-177,-38,0],[-164,-38,0,],0xFFFFFF,[227,228,229,232,361,362,363,366],[228,362],[228,232,362,366]],
[[-165,-10,0],[-154,-10,0],[-159,0,0,],0xFFFFFF,[227,228,229,232,361,362,363,366],[229,230,231,232,233,363,364,365,366,367],[226,227,229,230,360,361,363,364]],
[[-154,-10,0],[-155,7,0],[-159,0,0,],0xFFFFFF,[229,230,231,232,233,363,364,365,366,367],[230,231,364,365],[226,227,229,230,360,361,363,364]],
[[-155,7,0],[-154,-10,0],[-148,7,0,],0xFFFFFF,[230,231,364,365],[229,230,231,232,233,363,364,365,366,367],[231,365]],
[[-165,-10,0],[-164,-38,0],[-154,-10,0,],0xFFFFFF,[227,228,229,232,361,362,363,366],[228,232,362,366],[229,230,231,232,233,363,364,365,366,367]],
[[-154,-10,0],[-149,-10,0],[-150,0,0,],0xFFFFFF,[229,230,231,232,233,363,364,365,366,367],[233,234,236,367,368,370],[233,234,235,367,368,369]],
[[-150,0,0],[-149,-10,0],[-139,-4,0,],0xFFFFFF,[233,234,235,367,368,369],[233,234,236,367,368,370],[234,235,236,237,368,369,370,371]],
[[-150,0,0],[-139,-4,0],[-134,0,0,],0xFFFFFF,[233,234,235,367,368,369],[234,235,236,237,368,369,370,371],[235,369]],
[[-149,-10,0],[-158,-38,0],[-139,-4,0,],0xFFFFFF,[233,234,236,367,368,370],[236,237,370,371],[234,235,236,237,368,369,370,371]],
[[-139,-4,0],[-158,-38,0],[-148,-38,0,],0xFFFFFF,[234,235,236,237,368,369,370,371],[236,237,370,371],[237,371]],
[[-131,2,0],[-135,-11,0],[-124,-11,0,],0xFFFFFF,[238,239,240,372,373,374],[238,372],[238,239,372,373]],
[[-131,2,0],[-124,-11,0],[-123,-2,0,],0xFFFFFF,[238,239,240,372,373,374],[238,239,372,373],[239,240,373,374]],
[[-131,2,0],[-123,-2,0],[-117,3,0,],0xFFFFFF,[238,239,240,372,373,374],[239,240,373,374],[240,374]],
[[-145,10,0],[-145,2,0],[-138,10,0,],0xFFFFFF,[241,375],[241,375],[241,242,243,375,376,377]],
[[-138,10,0],[-138,2,0],[-130,10,0,],0xFFFFFF,[241,242,243,375,376,377],[242,243,376,377],[242,376]],
[[-138,2,0],[-138,10,0],[-141,6,0,],0xFFFFFF,[242,243,376,377],[241,242,243,375,376,377],[243,377]],
[[-86,10,0],[-86,2,0],[-79,10,0,],0xFFFFFF,[244,378],[244,378],[244,245,246,378,379,380]],
[[-79,10,0],[-78,2,0],[-70,10,0,],0xFFFFFF,[244,245,246,378,379,380],[245,246,379,380],[245,379]],
[[-78,2,0],[-79,10,0],[-82,6,0,],0xFFFFFF,[245,246,379,380],[244,245,246,378,379,380],[246,380]],
[[-140,-26,0],[-144,-37,0],[-121,-38,0,],0xFFFFFF,[247,248,381,382],[247,381],[247,248,249,250,381,382,383,384]],
[[-140,-26,0],[-121,-38,0],[-130,-25,0,],0xFFFFFF,[247,248,381,382],[247,248,249,250,381,382,383,384],[248,249,382,383]],
[[-130,-25,0],[-121,-38,0],[-117,-4,0,],0xFFFFFF,[248,249,382,383],[247,248,249,250,381,382,383,384],[249,250,251,383,384,385]],
[[-117,-4,0],[-121,-38,0],[-111,-8,0,],0xFFFFFF,[249,250,251,383,384,385],[247,248,249,250,381,382,383,384],[250,251,384,385]],
[[-117,-4,0],[-111,-8,0],[-107,-4,0,],0xFFFFFF,[249,250,251,383,384,385],[250,251,384,385],[251,385]],
[[-103,1,0],[-110,-11,0],[-101,-11,0,],0xFFFFFF,[252,253,254,255,386,387,388,389],[252,386],[252,253,386,387]],
[[-101,-11,0],[-98,-8,0],[-103,1,0,],0xFFFFFF,[252,253,386,387],[253,254,387,388],[252,253,254,255,386,387,388,389]],
[[-98,-8,0],[-90,-8,0],[-103,1,0,],0xFFFFFF,[253,254,387,388],[254,255,388,389],[252,253,254,255,386,387,388,389]],
[[-90,-8,0],[-85,1,0],[-103,1,0,],0xFFFFFF,[254,255,388,389],[255,256,257,258,389,390,391,392],[252,253,254,255,386,387,388,389]],
[[-85,1,0],[-94,-15,0],[-95,-37,0,],0xFFFFFF,[255,256,257,258,389,390,391,392],[256,259,260,270,390,393,394,404],[256,257,261,270,390,391,395,404]],
[[-85,1,0],[-95,-37,0],[-79,-2,0,],0xFFFFFF,[255,256,257,258,389,390,391,392],[256,257,261,270,390,391,395,404],[257,258,391,392]],
[[-85,1,0],[-79,-2,0],[-71,1,0,],0xFFFFFF,[255,256,257,258,389,390,391,392],[257,258,391,392],[258,392]],
[[-94,-15,0],[-105,-15,0],[-109,-20,0,],0xFFFFFF,[256,259,260,270,390,393,394,404],[259,393],[259,260,393,394]],
[[-109,-20,0],[-102,-25,0],[-94,-15,0,],0xFFFFFF,[259,260,393,394],[260,261,270,394,395,404],[256,259,260,270,390,393,394,404]],
[[-102,-25,0],[-109,-37,0],[-95,-37,0,],0xFFFFFF,[260,261,270,394,395,404],[261,395],[256,257,261,270,390,391,395,404]],
[[-66,9,0],[-90,-37,0],[-72,-24,0,],0xFFFFFF,[262,263,264,396,397,398],[262,265,396,399],[262,263,265,266,396,397,399,400]],
[[-66,9,0],[-72,-24,0],[-59,5,0,],0xFFFFFF,[262,263,264,396,397,398],[262,263,265,266,396,397,399,400],[263,264,397,398]],
[[-66,9,0],[-59,5,0],[-48,9,0,],0xFFFFFF,[262,263,264,396,397,398],[263,264,397,398],[264,398]],
[[-72,-24,0],[-90,-37,0],[-50,-38,0,],0xFFFFFF,[262,263,265,266,396,397,399,400],[262,265,396,399],[265,266,267,268,399,400,401,402]],
[[-72,-24,0],[-50,-38,0],[-62,-24,0,],0xFFFFFF,[262,263,265,266,396,397,399,400],[265,266,267,268,399,400,401,402],[266,267,400,401]],
[[-62,-24,0],[-50,-38,0],[-64,-9,0,],0xFFFFFF,[266,267,400,401],[265,266,267,268,399,400,401,402],[267,268,269,401,402,403]],
[[-64,-9,0],[-50,-38,0],[-54,-15,0,],0xFFFFFF,[267,268,269,401,402,403],[265,266,267,268,399,400,401,402],[268,269,402,403]],
[[-64,-9,0],[-54,-15,0],[-37,-9,0,],0xFFFFFF,[267,268,269,401,402,403],[268,269,402,403],[269,403]],
[[-94,-15,0],[-102,-25,0],[-95,-37,0,],0xFFFFFF,[256,259,260,270,390,393,394,404],[260,261,270,394,395,404],[256,257,261,270,390,391,395,404]],
[[-125,-41,0],[-125,-78,0],[-118,-78,0,],0x0000FF,[271,322,405,456],[271,273,405,407],[271,273,274,275,276,322,405,407,408,409,410,456]],
[[-112,-41,0],[-112,-78,0],[-105,-78,0,],0x0000FF,[272,323,406,457],[272,279,280,281,321,406,413,414,415,455],[272,279,323,406,413,457]],
[[-118,-78,0],[-125,-78,0],[-124,-83,0,],0x0000FF,[271,273,274,275,276,322,405,407,408,409,410,456],[271,273,405,407],[273,274,407,408]],
[[-118,-78,0],[-124,-83,0],[-122,-86,0,],0x0000FF,[271,273,274,275,276,322,405,407,408,409,410,456],[273,274,407,408],[274,275,408,409]],
[[-118,-78,0],[-122,-86,0],[-118,-89,0,],0x0000FF,[271,273,274,275,276,322,405,407,408,409,410,456],[274,275,408,409],[275,276,277,409,410,411]],
[[-118,-89,0],[-115,-82,0],[-118,-78,0,],0x0000FF,[275,276,277,409,410,411],[276,277,278,321,410,411,412,455],[271,273,274,275,276,322,405,407,408,409,410,456]],
[[-115,-82,0],[-118,-89,0],[-115,-90,0,],0x0000FF,[276,277,278,321,410,411,412,455],[275,276,277,409,410,411],[277,278,411,412]],
[[-115,-90,0],[-112,-89,0],[-115,-82,0,],0x0000FF,[277,278,411,412],[278,281,321,412,415,455],[276,277,278,321,410,411,412,455]],
[[-112,-78,0],[-107,-83,0],[-105,-78,0,],0x0000FF,[272,279,280,281,321,406,413,414,415,455],[279,280,413,414],[272,279,323,406,413,457]],
[[-112,-78,0],[-108,-87,0],[-107,-83,0,],0x0000FF,[272,279,280,281,321,406,413,414,415,455],[280,281,414,415],[279,280,413,414]],
[[-112,-78,0],[-112,-89,0],[-108,-87,0,],0x0000FF,[272,279,280,281,321,406,413,414,415,455],[278,281,321,412,415,455],[280,281,414,415]],
[[-105,-41,0],[-105,-89,0],[-99,-41,0,],0x0000FF,[282,323,416,457],[282,283,416,417],[282,283,284,285,416,417,418,419]],
[[-99,-41,0],[-105,-89,0],[-99,-89,0,],0x0000FF,[282,283,284,285,416,417,418,419],[282,283,416,417],[283,417]],
[[-99,-41,0],[-93,-89,0],[-93,-64,0,],0x0000FF,[282,283,284,285,416,417,418,419],[284,285,286,287,418,419,420,421],[284,418]],
[[-99,-41,0],[-99,-66,0],[-93,-89,0,],0x0000FF,[282,283,284,285,416,417,418,419],[285,419],[284,285,286,287,418,419,420,421]],
[[-93,-89,0],[-86,-41,0],[-93,-41,0,],0x0000FF,[284,285,286,287,418,419,420,421],[286,287,288,420,421,422],[286,420]],
[[-86,-41,0],[-93,-89,0],[-86,-89,0,],0x0000FF,[286,287,288,420,421,422],[284,285,286,287,418,419,420,421],[287,288,289,421,422,423]],
[[-86,-41,0],[-86,-89,0],[-80,-41,0,],0x0000FF,[286,287,288,420,421,422],[287,288,289,421,422,423],[288,289,295,422,423,429]],
[[-80,-41,0],[-86,-89,0],[-80,-89,0,],0x0000FF,[288,289,295,422,423,429],[287,288,289,421,422,423],[289,290,291,423,424,425]],
[[-76,-79,0],[-80,-81,0],[-80,-89,0,],0x0000FF,[290,291,292,293,294,424,425,426,427,428],[290,424],[289,290,291,423,424,425]],
[[-76,-79,0],[-80,-89,0],[-72,-86,0,],0x0000FF,[290,291,292,293,294,424,425,426,427,428],[289,290,291,423,424,425],[291,292,425,426]],
[[-76,-79,0],[-72,-86,0],[-70,-83,0,],0x0000FF,[290,291,292,293,294,424,425,426,427,428],[291,292,425,426],[292,293,426,427]],
[[-76,-79,0],[-70,-83,0],[-67,-73,0,],0x0000FF,[290,291,292,293,294,424,425,426,427,428],[292,293,426,427],[293,294,303,427,428,437]],
[[-76,-79,0],[-67,-73,0],[-75,-75,0,],0x0000FF,[290,291,292,293,294,424,425,426,427,428],[293,294,303,427,428,437],[294,302,303,428,436,437]],
[[-80,-50,0],[-73,-43,0],[-80,-41,0,],0x0000FF,[295,296,429,430],[295,296,297,429,430,431],[288,289,295,422,423,429]],
[[-73,-43,0],[-80,-50,0],[-77,-50,0,],0x0000FF,[295,296,297,429,430,431],[295,296,429,430],[296,297,298,299,430,431,432,433]],
[[-77,-50,0],[-71,-46,0],[-73,-43,0,],0x0000FF,[296,297,298,299,430,431,432,433],[297,298,431,432],[295,296,297,429,430,431]],
[[-77,-50,0],[-67,-57,0],[-71,-46,0,],0x0000FF,[296,297,298,299,430,431,432,433],[298,299,300,301,432,433,434,435],[297,298,431,432]],
[[-67,-57,0],[-77,-50,0],[-75,-54,0,],0x0000FF,[298,299,300,301,432,433,434,435],[296,297,298,299,430,431,432,433],[299,300,433,434]],
[[-75,-54,0],[-74,-65,0],[-67,-57,0,],0x0000FF,[299,300,433,434],[300,301,302,434,435,436],[298,299,300,301,432,433,434,435]],
[[-67,-57,0],[-74,-65,0],[-66,-65,0,],0x0000FF,[298,299,300,301,432,433,434,435],[300,301,302,434,435,436],[301,302,303,435,436,437]],
[[-74,-65,0],[-75,-75,0],[-66,-65,0,],0x0000FF,[300,301,302,434,435,436],[294,302,303,428,436,437],[301,302,303,435,436,437]],
[[-66,-65,0],[-75,-75,0],[-67,-73,0,],0x0000FF,[301,302,303,435,436,437],[294,302,303,428,436,437],[293,294,303,427,428,437]],
[[-62,-41,0],[-69,-89,0],[-55,-41,0,],0x0000FF,[304,307,438,441],[304,305,438,439],[304,305,306,307,438,439,440,441]],
[[-55,-41,0],[-69,-89,0],[-63,-89,0,],0x0000FF,[304,305,306,307,438,439,440,441],[304,305,438,439],[305,439]],
[[-55,-41,0],[-54,-89,0],[-47,-89,0,],0x0000FF,[304,305,306,307,438,439,440,441],[306,307,440,441],[306,440]],
[[-54,-89,0],[-55,-41,0],[-62,-41,0,],0x0000FF,[306,307,440,441],[304,305,306,307,438,439,440,441],[304,307,438,441]],
[[-60,-72,0],[-62,-81,0],[-57,-72,0,],0x0000FF,[308,442],[308,309,442,443],[308,309,442,443]],
[[-57,-72,0],[-62,-81,0],[-55,-81,0,],0x0000FF,[308,309,442,443],[308,309,442,443],[309,443]],
[[-39,-89,0],[-40,-41,0],[-47,-41,0,],0x0000FF,[310,311,312,444,445,446],[310,311,444,445],[310,313,444,447]],
[[-40,-41,0],[-39,-89,0],[-37,-73,0,],0x0000FF,[310,311,444,445],[310,311,312,444,445,446],[311,312,315,316,445,446,449,450]],
[[-37,-73,0],[-39,-89,0],[-35,-89,0,],0x0000FF,[311,312,315,316,445,446,449,450],[310,311,312,444,445,446],[312,315,316,317,446,449,450,451]],
[[-43,-67,0],[-47,-41,0],[-47,-89,0,],0x0000FF,[313,314,447,448],[310,313,444,447],[313,314,447,448]],
[[-43,-67,0],[-47,-89,0],[-43,-89,0,],0x0000FF,[313,314,447,448],[313,314,447,448],[314,448]],
[[-37,-73,0],[-35,-89,0],[-33,-41,0,],0x0000FF,[311,312,315,316,445,446,449,450],[312,315,316,317,446,449,450,451],[315,316,317,318,449,450,451,452]],
[[-33,-41,0],[-37,-73,0],[-35,-89,0,],0x0000FF,[315,316,317,318,449,450,451,452],[311,312,315,316,445,446,449,450],[312,315,316,317,446,449,450,451]],
[[-33,-41,0],[-35,-89,0],[-32,-67,0,],0x0000FF,[315,316,317,318,449,450,451,452],[312,315,316,317,446,449,450,451],[317,318,319,320,451,452,453,454]],
[[-32,-67,0],[-27,-41,0],[-33,-41,0,],0x0000FF,[317,318,319,320,451,452,453,454],[318,319,452,453],[315,316,317,318,449,450,451,452]],
[[-32,-67,0],[-27,-89,0],[-27,-41,0,],0x0000FF,[317,318,319,320,451,452,453,454],[319,320,453,454],[318,319,452,453]],
[[-32,-67,0],[-32,-89,0],[-27,-89,0,],0x0000FF,[317,318,319,320,451,452,453,454],[320,454],[319,320,453,454]],
[[-115,-82,0],[-112,-89,0],[-112,-78,0,],0x0000FF,[276,277,278,321,410,411,412,455],[278,281,321,412,415,455],[272,279,280,281,321,406,413,414,415,455]],
[[-125,-41,0],[-118,-78,0],[-118,-41,0,],0x0000FF,[271,322,405,456],[271,273,274,275,276,322,405,407,408,409,410,456],[322,456]],
[[-112,-41,0],[-105,-78,0],[-105,-41,0,],0x0000FF,[272,323,406,457],[272,279,323,406,413,457],[282,323,416,457]],
[[-152,13,0],[-113,40,0],[-116,50,0,],0x0000FF,[324,325,326,327,356,458,459,460,461,490],[324,356,458,490],[324,325,458,459]],
[[-152,13,0],[-116,50,0],[-120,56,0,],0x0000FF,[324,325,326,327,356,458,459,460,461,490],[324,325,458,459],[325,326,459,460]],
[[-152,13,0],[-120,56,0],[-127,59,0,],0x0000FF,[324,325,326,327,356,458,459,460,461,490],[325,326,459,460],[326,327,357,358,460,461,491,492]],
[[-127,59,0],[-151,29,0],[-152,13,0,],0x0000FF,[326,327,357,358,460,461,491,492],[327,357,461,491],[324,325,326,327,356,458,459,460,461,490]],
[[-154,31,0],[-191,59,0],[-178,32,0,],0x0000FF,[328,357,358,462,491,492],[328,329,330,331,358,462,463,464,465,492],[328,329,462,463]],
[[-191,59,0],[-181,31,0],[-178,32,0,],0x0000FF,[328,329,330,331,358,462,463,464,465,492],[329,330,463,464],[328,329,462,463]],
[[-181,31,0],[-191,59,0],[-188,28,0,],0x0000FF,[329,330,463,464],[328,329,330,331,358,462,463,464,465,492],[330,331,332,333,334,355,464,465,466,467,468,489]],
[[-191,59,0],[-203,58,0],[-188,28,0,],0x0000FF,[328,329,330,331,358,462,463,464,465,492],[331,332,465,466],[330,331,332,333,334,355,464,465,466,467,468,489]],
[[-188,28,0],[-203,58,0],[-210,52,0,],0x0000FF,[330,331,332,333,334,355,464,465,466,467,468,489],[331,332,465,466],[332,333,466,467]],
[[-210,52,0],[-216,44,0],[-188,28,0,],0x0000FF,[332,333,466,467],[333,334,467,468],[330,331,332,333,334,355,464,465,466,467,468,489]],
[[-216,44,0],[-218,36,0],[-188,28,0,],0x0000FF,[333,334,467,468],[334,335,355,468,469,489],[330,331,332,333,334,355,464,465,466,467,468,489]],
[[-190,22,0],[-218,36,0],[-239,-95,0,],0x0000FF,[335,354,355,469,488,489],[334,335,355,468,469,489],[335,336,337,338,354,469,470,471,472,488]],
[[-205,-89,0],[-206,-86,0],[-239,-95,0,],0x0000FF,[336,337,470,471],[336,354,470,488],[335,336,337,338,354,469,470,471,472,488]],
[[-239,-95,0],[-201,-94,0],[-205,-89,0,],0x0000FF,[335,336,337,338,354,469,470,471,472,488],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[336,337,470,471]],
[[-239,-95,0],[-237,-104,0],[-201,-94,0,],0x0000FF,[335,336,337,338,354,469,470,471,472,488],[338,339,472,473],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-237,-104,0],[-234,-112,0],[-201,-94,0,],0x0000FF,[338,339,472,473],[339,340,473,474],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-234,-112,0],[-229,-118,0],[-201,-94,0,],0x0000FF,[339,340,473,474],[340,341,474,475],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-229,-118,0],[-216,-126,0],[-201,-94,0,],0x0000FF,[340,341,474,475],[341,342,475,476],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-216,-126,0],[-183,-126,0],[-201,-94,0,],0x0000FF,[341,342,475,476],[342,343,476,477],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-201,-94,0],[-183,-126,0],[-177,-123,0,],0x0000FF,[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[342,343,476,477],[343,344,477,478]],
[[-177,-123,0],[-169,-117,0],[-201,-94,0,],0x0000FF,[343,344,477,478],[344,345,346,347,348,478,479,480,481,482],[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479]],
[[-201,-94,0],[-169,-117,0],[-176,-91,0,],0x0000FF,[337,338,339,340,341,342,343,344,345,471,472,473,474,475,476,477,478,479],[344,345,346,347,348,478,479,480,481,482],[345,346,479,480]],
[[-176,-91,0],[-169,-117,0],[-170,-88,0,],0x0000FF,[345,346,479,480],[344,345,346,347,348,478,479,480,481,482],[346,348,349,480,482,483]],
[[-169,-117,0],[-172,-127,0],[-142,-127,0,],0x0000FF,[344,345,346,347,348,478,479,480,481,482],[347,481],[347,481]],
[[-142,-127,0],[-170,-88,0],[-169,-117,0,],0x0000FF,[348,349,350,351,353,482,483,484,485,487],[346,348,349,480,482,483],[344,345,346,347,348,478,479,480,481,482]],
[[-170,-88,0],[-142,-127,0],[-167,-85,0,],0x0000FF,[346,348,349,480,482,483],[348,349,350,351,353,482,483,484,485,487],[349,350,353,483,484,487]],
[[-142,-127,0],[-164,-66,0],[-167,-85,0,],0x0000FF,[348,349,350,351,353,482,483,484,485,487],[350,351,352,353,359,484,485,486,487,493],[349,350,353,483,484,487]],
[[-164,-66,0],[-142,-127,0],[-125,-40,0,],0x0000FF,[350,351,352,353,359,484,485,486,487,493],[348,349,350,351,353,482,483,484,485,487],[351,352,485,486]],
[[-125,-40,0],[-178,-40,0],[-164,-66,0,],0x0000FF,[351,352,485,486],[352,359,486,493],[350,351,352,353,359,484,485,486,487,493]],
[[-167,-85,0],[-142,-127,0],[-164,-66,0,],0x0000FF,[349,350,353,483,484,487],[348,349,350,351,353,482,483,484,485,487],[350,351,352,353,359,484,485,486,487,493]],
[[-190,22,0],[-239,-95,0],[-206,-86,0,],0x0000FF,[335,354,355,469,488,489],[335,336,337,338,354,469,470,471,472,488],[336,354,470,488]],
[[-188,28,0],[-218,36,0],[-190,22,0,],0x0000FF,[330,331,332,333,334,355,464,465,466,467,468,489],[334,335,355,468,469,489],[335,354,355,469,488,489]],
[[-152,13,0],[-119,13,0],[-113,40,0,],0x0000FF,[324,325,326,327,356,458,459,460,461,490],[356,490],[324,356,458,490]],
[[-154,31,0],[-151,29,0],[-127,59,0,],0x0000FF,[328,357,358,462,491,492],[327,357,461,491],[326,327,357,358,460,461,491,492]],
[[-127,59,0],[-191,59,0],[-154,31,0,],0x0000FF,[326,327,357,358,460,461,491,492],[328,329,330,331,358,462,463,464,465,492],[328,357,358,462,491,492]],
[[-164,-66,0],[-178,-40,0],[-182,-66,0,],0x0000FF,[350,351,352,353,359,484,485,486,487,493],[352,359,486,493],[359,493]],
[[35,60,-24],[41,60,-37],[18,55,-31,],0xFFFFFF,[494,664],[494,495,664,665,836],[494,495,496,664,665,666]],
[[41,60,-37],[25,55,-46],[18,55,-31,],0xFFFFFF,[494,495,664,665,836],[495,496,497,665,666,667,836,837,838],[494,495,496,664,665,666]],
[[18,55,-31],[25,55,-46],[10,49,-34,],0xFFFFFF,[494,495,496,664,665,666],[495,496,497,665,666,667,836,837,838],[496,497,498,666,667,668]],
[[25,55,-46],[18,49,-50],[10,49,-34,],0xFFFFFF,[495,496,497,665,666,667,836,837,838],[497,498,499,667,668,669,838,839,840],[496,497,498,666,667,668]],
[[10,49,-34],[18,49,-50],[4,39,-36,],0xFFFFFF,[496,497,498,666,667,668],[497,498,499,667,668,669,838,839,840],[498,499,500,668,669,670]],
[[18,49,-50],[12,39,-53],[4,39,-36,],0xFFFFFF,[497,498,499,667,668,669,838,839,840],[499,500,501,669,670,671,840,841],[498,499,500,668,669,670]],
[[4,39,-36],[12,39,-53],[1,29,-37,],0xFFFFFF,[498,499,500,668,669,670],[499,500,501,669,670,671,840,841],[500,501,502,670,671,672]],
[[12,39,-53],[10,29,-55],[1,29,-37,],0xFFFFFF,[499,500,501,669,670,671,840,841],[501,502,503,671,672,673,841,842,843],[500,501,502,670,671,672]],
[[1,29,-37],[10,29,-55],[0,19,-38,],0xFFFFFF,[500,501,502,670,671,672],[501,502,503,671,672,673,841,842,843],[502,503,504,672,673,674]],
[[10,29,-55],[8,19,-56],[0,19,-38,],0xFFFFFF,[501,502,503,671,672,673,841,842,843],[503,504,505,661,673,674,675,831],[502,503,504,672,673,674]],
[[0,19,-38],[8,19,-56],[-1,9,-39,],0xFFFFFF,[502,503,504,672,673,674],[503,504,505,661,673,674,675,831],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[8,19,-56],[6,9,-57],[-1,9,-39,],0xFFFFFF,[503,504,505,661,673,674,675,831],[505,506,507,675,676,677],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[-1,9,-39],[6,9,-57],[-3,-1,-39,],0xFFFFFF,[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611],[505,506,507,675,676,677],[506,507,508,676,677,678]],
[[6,9,-57],[5,-1,-58],[-3,-1,-39,],0xFFFFFF,[505,506,507,675,676,677],[507,508,509,590,677,678,679,760],[506,507,508,676,677,678]],
[[-3,-1,-39],[5,-1,-58],[-4,-11,-40,],0xFFFFFF,[506,507,508,676,677,678],[507,508,509,590,677,678,679,760],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[5,-1,-58],[4,-11,-58],[-4,-11,-40,],0xFFFFFF,[507,508,509,590,677,678,679,760],[509,510,511,679,680,681],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[-4,-11,-40],[4,-11,-58],[-5,-21,-40,],0xFFFFFF,[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[509,510,511,679,680,681],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943]],
[[4,-11,-58],[3,-21,-59],[-5,-21,-40,],0xFFFFFF,[509,510,511,679,680,681],[511,512,513,681,682,683],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943]],
[[-5,-21,-40],[3,-21,-59],[-5,-31,-40,],0xFFFFFF,[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[511,512,513,681,682,683],[512,513,514,682,683,684]],
[[3,-21,-59],[3,-31,-59],[-5,-31,-40,],0xFFFFFF,[511,512,513,681,682,683],[513,514,515,594,595,596,683,684,685,764,765,766],[512,513,514,682,683,684]],
[[-5,-31,-40],[3,-31,-59],[-5,-41,-40,],0xFFFFFF,[512,513,514,682,683,684],[513,514,515,594,595,596,683,684,685,764,765,766],[514,515,516,684,685,686]],
[[3,-31,-59],[3,-41,-59],[-5,-41,-40,],0xFFFFFF,[513,514,515,594,595,596,683,684,685,764,765,766],[515,516,517,685,686,687],[514,515,516,684,685,686]],
[[-5,-41,-40],[3,-41,-59],[-4,-51,-40,],0xFFFFFF,[514,515,516,684,685,686],[515,516,517,685,686,687],[516,517,518,686,687,688]],
[[3,-41,-59],[3,-51,-58],[-4,-51,-40,],0xFFFFFF,[515,516,517,685,686,687],[517,518,519,687,688,689],[516,517,518,686,687,688]],
[[-4,-51,-40],[3,-51,-58],[-3,-61,-39,],0xFFFFFF,[516,517,518,686,687,688],[517,518,519,687,688,689],[518,519,520,688,689,690]],
[[3,-51,-58],[4,-61,-58],[-3,-61,-39,],0xFFFFFF,[517,518,519,687,688,689],[519,520,521,689,690,691],[518,519,520,688,689,690]],
[[-3,-61,-39],[4,-61,-58],[-2,-71,-39,],0xFFFFFF,[518,519,520,688,689,690],[519,520,521,689,690,691],[520,521,522,690,691,692]],
[[4,-61,-58],[6,-71,-57],[-2,-71,-39,],0xFFFFFF,[519,520,521,689,690,691],[521,522,523,691,692,693],[520,521,522,690,691,692]],
[[-2,-71,-39],[6,-71,-57],[0,-81,-38,],0xFFFFFF,[520,521,522,690,691,692],[521,522,523,691,692,693],[522,523,524,692,693,694]],
[[6,-71,-57],[8,-81,-56],[0,-81,-38,],0xFFFFFF,[521,522,523,691,692,693],[523,524,525,604,605,606,693,694,695,774,775,776],[522,523,524,692,693,694]],
[[0,-81,-38],[8,-81,-56],[3,-91,-37,],0xFFFFFF,[522,523,524,692,693,694],[523,524,525,604,605,606,693,694,695,774,775,776],[524,525,694,695]],
[[8,-81,-56],[11,-91,-54],[3,-91,-37,],0xFFFFFF,[523,524,525,604,605,606,693,694,695,774,775,776],[525,606,607,695,776,777],[524,525,694,695]],
[[171,60,-35],[177,60,-22],[187,55,-44,],0xFFFFFF,[526,696,881],[526,527,696,697],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[177,60,-22],[193,55,-30],[187,55,-44,],0xFFFFFF,[526,527,696,697],[527,528,529,697,698,699],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[187,55,-44],[193,55,-30],[194,49,-49,],0xFFFFFF,[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[527,528,529,697,698,699],[528,529,530,698,699,700,885,889]],
[[193,55,-30],[201,49,-33],[194,49,-49,],0xFFFFFF,[527,528,529,697,698,699],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[528,529,530,698,699,700,885,889]],
[[194,49,-49],[201,49,-33],[200,39,-52,],0xFFFFFF,[528,529,530,698,699,700,885,889],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[530,531,532,700,701,702,889,890]],
[[201,49,-33],[207,39,-35],[200,39,-52,],0xFFFFFF,[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[531,532,533,701,702,703],[530,531,532,700,701,702,889,890]],
[[200,39,-52],[207,39,-35],[202,29,-53,],0xFFFFFF,[530,531,532,700,701,702,889,890],[531,532,533,701,702,703],[532,533,534,663,702,703,704,833,890,891,892]],
[[207,39,-35],[210,29,-36],[202,29,-53,],0xFFFFFF,[531,532,533,701,702,703],[533,534,535,703,704,705],[532,533,534,663,702,703,704,833,890,891,892]],
[[202,29,-53],[210,29,-36],[204,19,-54,],0xFFFFFF,[532,533,534,663,702,703,704,833,890,891,892],[533,534,535,703,704,705],[534,535,536,704,705,706,892,893,894,938,939,945]],
[[210,29,-36],[212,19,-36],[204,19,-54,],0xFFFFFF,[533,534,535,703,704,705],[535,536,537,705,706,707],[534,535,536,704,705,706,892,893,894,938,939,945]],
[[204,19,-54],[212,19,-36],[206,9,-55,],0xFFFFFF,[534,535,536,704,705,706,892,893,894,938,939,945],[535,536,537,705,706,707],[536,537,538,706,707,708]],
[[212,19,-36],[214,9,-37],[206,9,-55,],0xFFFFFF,[535,536,537,705,706,707],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[536,537,538,706,707,708]],
[[206,9,-55],[214,9,-37],[207,-1,-56,],0xFFFFFF,[536,537,538,706,707,708],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[538,539,540,626,662,663,708,709,710,796,832,833]],
[[214,9,-37],[216,-1,-37],[207,-1,-56,],0xFFFFFF,[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[539,540,541,709,710,711],[538,539,540,626,662,663,708,709,710,796,832,833]],
[[207,-1,-56],[216,-1,-37],[208,-11,-56,],0xFFFFFF,[538,539,540,626,662,663,708,709,710,796,832,833],[539,540,541,709,710,711],[540,541,542,710,711,712]],
[[216,-1,-37],[217,-11,-38],[208,-11,-56,],0xFFFFFF,[539,540,541,709,710,711],[541,542,543,711,712,713],[540,541,542,710,711,712]],
[[208,-11,-56],[217,-11,-38],[209,-21,-57,],0xFFFFFF,[540,541,542,710,711,712],[541,542,543,711,712,713],[542,543,544,712,713,714]],
[[217,-11,-38],[217,-21,-38],[209,-21,-57,],0xFFFFFF,[541,542,543,711,712,713],[543,544,545,713,714,715],[542,543,544,712,713,714]],
[[209,-21,-57],[217,-21,-38],[209,-31,-57,],0xFFFFFF,[542,543,544,712,713,714],[543,544,545,713,714,715],[544,545,546,630,631,632,714,715,716,800,801,802]],
[[217,-21,-38],[218,-31,-38],[209,-31,-57,],0xFFFFFF,[543,544,545,713,714,715],[545,546,547,715,716,717],[544,545,546,630,631,632,714,715,716,800,801,802]],
[[209,-31,-57],[218,-31,-38],[209,-41,-57,],0xFFFFFF,[544,545,546,630,631,632,714,715,716,800,801,802],[545,546,547,715,716,717],[546,547,548,716,717,718]],
[[218,-31,-38],[217,-41,-38],[209,-41,-57,],0xFFFFFF,[545,546,547,715,716,717],[547,548,549,717,718,719],[546,547,548,716,717,718]],
[[209,-41,-57],[217,-41,-38],[209,-51,-57,],0xFFFFFF,[546,547,548,716,717,718],[547,548,549,717,718,719],[548,549,550,718,719,720]],
[[217,-41,-38],[217,-51,-38],[209,-51,-57,],0xFFFFFF,[547,548,549,717,718,719],[549,550,551,719,720,721],[548,549,550,718,719,720]],
[[209,-51,-57],[217,-51,-38],[208,-61,-56,],0xFFFFFF,[548,549,550,718,719,720],[549,550,551,719,720,721],[550,551,552,720,721,722]],
[[217,-51,-38],[216,-61,-38],[208,-61,-56,],0xFFFFFF,[549,550,551,719,720,721],[551,552,553,721,722,723],[550,551,552,720,721,722]],
[[208,-61,-56],[216,-61,-38],[206,-71,-55,],0xFFFFFF,[550,551,552,720,721,722],[551,552,553,721,722,723],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[216,-61,-38],[214,-71,-37],[206,-71,-55,],0xFFFFFF,[551,552,553,721,722,723],[553,554,555,723,724,725],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[206,-71,-55],[214,-71,-37],[204,-81,-54,],0xFFFFFF,[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659],[553,554,555,723,724,725],[554,555,556,640,641,642,724,725,726,810,811,812]],
[[214,-71,-37],[212,-81,-36],[204,-81,-54,],0xFFFFFF,[553,554,555,723,724,725],[555,556,557,725,726,727],[554,555,556,640,641,642,724,725,726,810,811,812]],
[[204,-81,-54],[212,-81,-36],[201,-91,-52,],0xFFFFFF,[554,555,556,640,641,642,724,725,726,810,811,812],[555,556,557,725,726,727],[556,557,642,726,727,812]],
[[212,-81,-36],[209,-91,-35],[201,-91,-52,],0xFFFFFF,[555,556,557,725,726,727],[557,727],[556,557,642,726,727,812]],
[[116,60,73],[105,55,92],[120,55,91,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[116,60,73],[107,60,74],[105,55,92,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[559,729,1586,1589,2371,2664],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[120,55,91],[106,49,101],[121,49,100,],0xFFFFFF,[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[560,562,730,732,2372,2374,2665,2667]],
[[105,55,92],[106,49,101],[120,55,91,],0xFFFFFF,[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[121,49,100],[106,49,101],[122,39,106,],0xFFFFFF,[560,562,730,732,2372,2374,2665,2667],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[106,49,101],[105,39,107],[122,39,106,],0xFFFFFF,[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[122,39,106],[105,39,107],[123,29,109,],0xFFFFFF,[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[105,39,107],[106,29,110],[123,29,109,],0xFFFFFF,[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[123,29,109],[106,29,110],[123,19,111,],0xFFFFFF,[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[106,29,110],[106,19,113],[123,19,111,],0xFFFFFF,[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[123,19,111],[106,19,113],[123,9,113,],0xFFFFFF,[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[106,19,113],[106,9,114],[123,9,113,],0xFFFFFF,[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[123,9,113],[106,9,114],[124,-1,114,],0xFFFFFF,[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[106,9,114],[105,-1,116],[124,-1,114,],0xFFFFFF,[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[124,-1,114],[105,-1,116],[124,-11,116,],0xFFFFFF,[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[105,-1,116],[105,-11,117],[124,-11,116,],0xFFFFFF,[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[124,-11,116],[105,-11,117],[124,-21,116,],0xFFFFFF,[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[105,-11,117],[106,-21,118],[124,-21,116,],0xFFFFFF,[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[124,-21,116],[106,-21,118],[124,-31,117,],0xFFFFFF,[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[106,-21,118],[106,-31,118],[124,-31,117,],0xFFFFFF,[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[124,-31,117],[106,-31,118],[124,-41,116,],0xFFFFFF,[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[106,-31,118],[104,-41,118],[124,-41,116,],0xFFFFFF,[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[124,-41,116],[104,-41,118],[124,-51,116,],0xFFFFFF,[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[104,-41,118],[104,-51,117],[124,-51,116,],0xFFFFFF,[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[124,-51,116],[104,-51,117],[124,-61,115,],0xFFFFFF,[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[104,-51,117],[105,-61,116],[124,-61,115,],0xFFFFFF,[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[124,-61,115],[105,-61,116],[123,-71,113,],0xFFFFFF,[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[105,-61,116],[105,-71,114],[123,-71,113,],0xFFFFFF,[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[123,-71,113],[105,-71,114],[123,-81,111,],0xFFFFFF,[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[105,-71,114],[105,-81,112],[123,-81,111,],0xFFFFFF,[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[123,-81,111],[105,-81,112],[123,-91,107,],0xFFFFFF,[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[588,589,758,759,2400,2401,2693,2694]],
[[105,-81,112],[106,-91,109],[123,-91,107,],0xFFFFFF,[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[589,759,2401,2694],[588,589,758,759,2400,2401,2693,2694]],
[[5,-1,-58],[19,-1,-74],[4,-11,-58,],0xFFFFFF,[507,508,509,590,677,678,679,760],[590,591,760,761],[590,591,592,760,761,762]],
[[19,-1,-74],[16,-11,-75],[4,-11,-58,],0xFFFFFF,[590,591,760,761],[591,592,593,608,609,610,761,762,763,778,779,780],[590,591,592,760,761,762]],
[[4,-11,-58],[16,-11,-75],[3,-21,-59,],0xFFFFFF,[590,591,592,760,761,762],[591,592,593,608,609,610,761,762,763,778,779,780],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618]],
[[16,-11,-75],[15,-21,-75],[3,-21,-59,],0xFFFFFF,[591,592,593,608,609,610,761,762,763,778,779,780],[593,594,595,763,764,765],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618]],
[[3,-21,-59],[15,-21,-75],[3,-31,-59,],0xFFFFFF,[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[593,594,595,763,764,765],[513,514,515,594,595,596,683,684,685,764,765,766]],
[[15,-21,-75],[15,-31,-76],[3,-31,-59,],0xFFFFFF,[593,594,595,763,764,765],[595,596,597,612,613,614,765,766,767,782,783,784],[513,514,515,594,595,596,683,684,685,764,765,766]],
[[3,-31,-59],[15,-31,-76],[3,-41,-59,],0xFFFFFF,[513,514,515,594,595,596,683,684,685,764,765,766],[595,596,597,612,613,614,765,766,767,782,783,784],[596,597,598,766,767,768]],
[[15,-31,-76],[15,-41,-76],[3,-41,-59,],0xFFFFFF,[595,596,597,612,613,614,765,766,767,782,783,784],[597,598,599,614,615,616,767,768,769,784,785,786],[596,597,598,766,767,768]],
[[3,-41,-59],[15,-41,-76],[3,-51,-58,],0xFFFFFF,[596,597,598,766,767,768],[597,598,599,614,615,616,767,768,769,784,785,786],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[15,-41,-76],[15,-51,-75],[3,-51,-58,],0xFFFFFF,[597,598,599,614,615,616,767,768,769,784,785,786],[599,600,601,616,617,618,769,770,771,786,787,788],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[3,-51,-58],[15,-51,-75],[4,-61,-58,],0xFFFFFF,[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705],[599,600,601,616,617,618,769,770,771,786,787,788],[600,601,602,770,771,772]],
[[15,-51,-75],[16,-61,-75],[4,-61,-58,],0xFFFFFF,[599,600,601,616,617,618,769,770,771,786,787,788],[601,602,603,618,619,620,771,772,773,788,789,790],[600,601,602,770,771,772]],
[[4,-61,-58],[16,-61,-75],[6,-71,-57,],0xFFFFFF,[600,601,602,770,771,772],[601,602,603,618,619,620,771,772,773,788,789,790],[602,603,604,772,773,774]],
[[16,-61,-75],[17,-71,-73],[6,-71,-57,],0xFFFFFF,[601,602,603,618,619,620,771,772,773,788,789,790],[603,604,605,773,774,775],[602,603,604,772,773,774]],
[[6,-71,-57],[17,-71,-73],[8,-81,-56,],0xFFFFFF,[602,603,604,772,773,774],[603,604,605,773,774,775],[523,524,525,604,605,606,693,694,695,774,775,776]],
[[17,-71,-73],[19,-81,-72],[8,-81,-56,],0xFFFFFF,[603,604,605,773,774,775],[605,606,607,775,776,777],[523,524,525,604,605,606,693,694,695,774,775,776]],
[[8,-81,-56],[19,-81,-72],[11,-91,-54,],0xFFFFFF,[523,524,525,604,605,606,693,694,695,774,775,776],[605,606,607,775,776,777],[525,606,607,695,776,777]],
[[19,-81,-72],[22,-91,-70],[11,-91,-54,],0xFFFFFF,[605,606,607,775,776,777],[607,624,625,777,794,795],[525,606,607,695,776,777]],
[[19,-1,-74],[31,-1,-89],[16,-11,-75,],0xFFFFFF,[608,778],[608,609,661,778,779,831],[591,592,593,608,609,610,761,762,763,778,779,780]],
[[31,-1,-89],[30,-11,-89],[16,-11,-75,],0xFFFFFF,[608,609,661,778,779,831],[609,610,611,779,780,781,855,856],[591,592,593,608,609,610,761,762,763,778,779,780]],
[[16,-11,-75],[30,-11,-89],[15,-21,-75,],0xFFFFFF,[591,592,593,608,609,610,761,762,763,778,779,780],[609,610,611,779,780,781,855,856],[610,611,612,780,781,782]],
[[30,-11,-89],[30,-21,-90],[15,-21,-75,],0xFFFFFF,[609,610,611,779,780,781,855,856],[611,612,613,781,782,783,856,857],[610,611,612,780,781,782]],
[[15,-21,-75],[30,-21,-90],[15,-31,-76,],0xFFFFFF,[610,611,612,780,781,782],[611,612,613,781,782,783,856,857],[595,596,597,612,613,614,765,766,767,782,783,784]],
[[30,-21,-90],[29,-31,-90],[15,-31,-76,],0xFFFFFF,[611,612,613,781,782,783,856,857],[613,614,615,783,784,785,857,858,859],[595,596,597,612,613,614,765,766,767,782,783,784]],
[[15,-31,-76],[29,-31,-90],[15,-41,-76,],0xFFFFFF,[595,596,597,612,613,614,765,766,767,782,783,784],[613,614,615,783,784,785,857,858,859],[597,598,599,614,615,616,767,768,769,784,785,786]],
[[29,-31,-90],[29,-41,-90],[15,-41,-76,],0xFFFFFF,[613,614,615,783,784,785,857,858,859],[615,616,617,785,786,787,859,860],[597,598,599,614,615,616,767,768,769,784,785,786]],
[[15,-41,-76],[29,-41,-90],[15,-51,-75,],0xFFFFFF,[597,598,599,614,615,616,767,768,769,784,785,786],[615,616,617,785,786,787,859,860],[599,600,601,616,617,618,769,770,771,786,787,788]],
[[29,-41,-90],[30,-51,-90],[15,-51,-75,],0xFFFFFF,[615,616,617,785,786,787,859,860],[617,618,619,787,788,789,860,861],[599,600,601,616,617,618,769,770,771,786,787,788]],
[[15,-51,-75],[30,-51,-90],[16,-61,-75,],0xFFFFFF,[599,600,601,616,617,618,769,770,771,786,787,788],[617,618,619,787,788,789,860,861],[601,602,603,618,619,620,771,772,773,788,789,790]],
[[30,-51,-90],[30,-61,-89],[16,-61,-75,],0xFFFFFF,[617,618,619,787,788,789,860,861],[619,620,621,789,790,791,861,862],[601,602,603,618,619,620,771,772,773,788,789,790]],
[[16,-61,-75],[30,-61,-89],[17,-71,-73,],0xFFFFFF,[601,602,603,618,619,620,771,772,773,788,789,790],[619,620,621,789,790,791,861,862],[620,621,622,790,791,792]],
[[30,-61,-89],[32,-71,-88],[17,-71,-73,],0xFFFFFF,[619,620,621,789,790,791,861,862],[621,622,623,791,792,793,862,863,864],[620,621,622,790,791,792]],
[[17,-71,-73],[32,-71,-88],[19,-81,-72,],0xFFFFFF,[620,621,622,790,791,792],[621,622,623,791,792,793,862,863,864],[622,623,624,792,793,794,5352]],
[[32,-71,-88],[33,-81,-86],[19,-81,-72,],0xFFFFFF,[621,622,623,791,792,793,862,863,864],[623,624,625,793,794,795,864,865,5351,5352],[622,623,624,792,793,794,5352]],
[[19,-81,-72],[33,-81,-86],[22,-91,-70,],0xFFFFFF,[622,623,624,792,793,794,5352],[623,624,625,793,794,795,864,865,5351,5352],[607,624,625,777,794,795]],
[[33,-81,-86],[35,-91,-83],[22,-91,-70,],0xFFFFFF,[623,624,625,793,794,795,864,865,5351,5352],[625,795,865,866],[607,624,625,777,794,795]],
[[207,-1,-56],[208,-11,-56],[197,-11,-73,],0xFFFFFF,[538,539,540,626,662,663,708,709,710,796,832,833],[626,627,628,796,797,798],[626,627,644,645,646,662,796,797,814,815,816,832]],
[[197,-11,-73],[208,-11,-56],[197,-21,-74,],0xFFFFFF,[626,627,644,645,646,662,796,797,814,815,816,832],[626,627,628,796,797,798],[627,628,629,797,798,799]],
[[208,-11,-56],[209,-21,-57],[197,-21,-74,],0xFFFFFF,[626,627,628,796,797,798],[628,629,630,798,799,800],[627,628,629,797,798,799]],
[[197,-21,-74],[209,-21,-57],[198,-31,-74,],0xFFFFFF,[627,628,629,797,798,799],[628,629,630,798,799,800],[629,630,631,648,649,650,799,800,801,818,819,820]],
[[209,-21,-57],[209,-31,-57],[198,-31,-74,],0xFFFFFF,[628,629,630,798,799,800],[544,545,546,630,631,632,714,715,716,800,801,802],[629,630,631,648,649,650,799,800,801,818,819,820]],
[[198,-31,-74],[209,-31,-57],[198,-41,-74,],0xFFFFFF,[629,630,631,648,649,650,799,800,801,818,819,820],[544,545,546,630,631,632,714,715,716,800,801,802],[631,632,633,801,802,803]],
[[209,-31,-57],[209,-41,-57],[198,-41,-74,],0xFFFFFF,[544,545,546,630,631,632,714,715,716,800,801,802],[632,633,634,802,803,804],[631,632,633,801,802,803]],
[[198,-41,-74],[209,-41,-57],[197,-51,-74,],0xFFFFFF,[631,632,633,801,802,803],[632,633,634,802,803,804],[633,634,635,803,804,805]],
[[209,-41,-57],[209,-51,-57],[197,-51,-74,],0xFFFFFF,[632,633,634,802,803,804],[634,635,636,804,805,806],[633,634,635,803,804,805]],
[[197,-51,-74],[209,-51,-57],[196,-61,-73,],0xFFFFFF,[633,634,635,803,804,805],[634,635,636,804,805,806],[635,636,637,805,806,807]],
[[209,-51,-57],[208,-61,-56],[196,-61,-73,],0xFFFFFF,[634,635,636,804,805,806],[636,637,638,806,807,808],[635,636,637,805,806,807]],
[[196,-61,-73],[208,-61,-56],[195,-71,-72,],0xFFFFFF,[635,636,637,805,806,807],[636,637,638,806,807,808],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[208,-61,-56],[206,-71,-55],[195,-71,-72,],0xFFFFFF,[636,637,638,806,807,808],[638,639,640,808,809,810],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[195,-71,-72],[206,-71,-55],[193,-81,-70,],0xFFFFFF,[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744],[638,639,640,808,809,810],[639,640,641,809,810,811]],
[[206,-71,-55],[204,-81,-54],[193,-81,-70,],0xFFFFFF,[638,639,640,808,809,810],[554,555,556,640,641,642,724,725,726,810,811,812],[639,640,641,809,810,811]],
[[193,-81,-70],[204,-81,-54],[190,-91,-68,],0xFFFFFF,[639,640,641,809,810,811],[554,555,556,640,641,642,724,725,726,810,811,812],[641,642,811,812]],
[[204,-81,-54],[201,-91,-52],[190,-91,-68,],0xFFFFFF,[554,555,556,640,641,642,724,725,726,810,811,812],[556,557,642,726,727,812],[641,642,811,812]],
[[182,-1,-87],[194,-1,-73],[183,-11,-88,],0xFFFFFF,[643,663,813,833],[643,644,662,813,814,832],[643,644,645,813,814,815,923,924]],
[[194,-1,-73],[197,-11,-73],[183,-11,-88,],0xFFFFFF,[643,644,662,813,814,832],[626,627,644,645,646,662,796,797,814,815,816,832],[643,644,645,813,814,815,923,924]],
[[183,-11,-88],[197,-11,-73],[183,-21,-89,],0xFFFFFF,[643,644,645,813,814,815,923,924],[626,627,644,645,646,662,796,797,814,815,816,832],[645,646,647,815,816,817,921,922,923]],
[[197,-11,-73],[197,-21,-74],[183,-21,-89,],0xFFFFFF,[626,627,644,645,646,662,796,797,814,815,816,832],[646,647,648,816,817,818],[645,646,647,815,816,817,921,922,923]],
[[183,-21,-89],[197,-21,-74],[183,-31,-89,],0xFFFFFF,[645,646,647,815,816,817,921,922,923],[646,647,648,816,817,818],[647,648,649,817,818,819,920,921]],
[[197,-21,-74],[198,-31,-74],[183,-31,-89,],0xFFFFFF,[646,647,648,816,817,818],[629,630,631,648,649,650,799,800,801,818,819,820],[647,648,649,817,818,819,920,921]],
[[183,-31,-89],[198,-31,-74],[183,-41,-89,],0xFFFFFF,[647,648,649,817,818,819,920,921],[629,630,631,648,649,650,799,800,801,818,819,820],[649,650,651,819,820,821,919,920]],
[[198,-31,-74],[198,-41,-74],[183,-41,-89,],0xFFFFFF,[629,630,631,648,649,650,799,800,801,818,819,820],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[649,650,651,819,820,821,919,920]],
[[183,-41,-89],[198,-41,-74],[183,-51,-88,],0xFFFFFF,[649,650,651,819,820,821,919,920],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[651,652,653,821,822,823,918,919]],
[[198,-41,-74],[197,-51,-74],[183,-51,-88,],0xFFFFFF,[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[652,653,654,822,823,824],[651,652,653,821,822,823,918,919]],
[[183,-51,-88],[197,-51,-74],[182,-61,-88,],0xFFFFFF,[651,652,653,821,822,823,918,919],[652,653,654,822,823,824],[653,654,655,823,824,825,916,917,918]],
[[197,-51,-74],[196,-61,-73],[182,-61,-88,],0xFFFFFF,[652,653,654,822,823,824],[654,655,656,824,825,826],[653,654,655,823,824,825,916,917,918]],
[[182,-61,-88],[196,-61,-73],[181,-71,-86,],0xFFFFFF,[653,654,655,823,824,825,916,917,918],[654,655,656,824,825,826],[655,656,657,825,826,827,915,916]],
[[196,-61,-73],[195,-71,-72],[181,-71,-86,],0xFFFFFF,[654,655,656,824,825,826],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[655,656,657,825,826,827,915,916]],
[[181,-71,-86],[195,-71,-72],[179,-81,-84,],0xFFFFFF,[655,656,657,825,826,827,915,916],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[657,658,659,827,828,829,914,915]],
[[195,-71,-72],[193,-81,-70],[179,-81,-84,],0xFFFFFF,[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[658,659,660,828,829,830],[657,658,659,827,828,829,914,915]],
[[179,-81,-84],[193,-81,-70],[177,-91,-82,],0xFFFFFF,[657,658,659,827,828,829,914,915],[658,659,660,828,829,830],[659,660,829,830,912,913,914]],
[[193,-81,-70],[190,-91,-68],[177,-91,-82,],0xFFFFFF,[658,659,660,828,829,830],[660,830],[659,660,829,830,912,913,914]],
[[31,-1,-89],[5,-1,-57],[8,19,-56,],0xFFFFFF,[608,609,661,778,779,831],[661,831],[503,504,505,661,673,674,675,831]],
[[207,-1,-56],[197,-11,-73],[194,-1,-73,],0xFFFFFF,[538,539,540,626,662,663,708,709,710,796,832,833],[626,627,644,645,646,662,796,797,814,815,816,832],[643,644,662,813,814,832]],
[[202,29,-53],[207,-1,-56],[182,-1,-87,],0xFFFFFF,[532,533,534,663,702,703,704,833,890,891,892],[538,539,540,626,662,663,708,709,710,796,832,833],[643,663,813,833]],
[[35,60,-24],[41,60,-37],[18,55,-31,],0xFFFFFF,[494,664],[494,495,664,665,836],[494,495,496,664,665,666]],
[[41,60,-37],[25,55,-46],[18,55,-31,],0xFFFFFF,[494,495,664,665,836],[495,496,497,665,666,667,836,837,838],[494,495,496,664,665,666]],
[[18,55,-31],[25,55,-46],[10,49,-34,],0xFFFFFF,[494,495,496,664,665,666],[495,496,497,665,666,667,836,837,838],[496,497,498,666,667,668]],
[[25,55,-46],[18,49,-50],[10,49,-34,],0xFFFFFF,[495,496,497,665,666,667,836,837,838],[497,498,499,667,668,669,838,839,840],[496,497,498,666,667,668]],
[[10,49,-34],[18,49,-50],[4,39,-36,],0xFFFFFF,[496,497,498,666,667,668],[497,498,499,667,668,669,838,839,840],[498,499,500,668,669,670]],
[[18,49,-50],[12,39,-53],[4,39,-36,],0xFFFFFF,[497,498,499,667,668,669,838,839,840],[499,500,501,669,670,671,840,841],[498,499,500,668,669,670]],
[[4,39,-36],[12,39,-53],[1,29,-37,],0xFFFFFF,[498,499,500,668,669,670],[499,500,501,669,670,671,840,841],[500,501,502,670,671,672]],
[[12,39,-53],[10,29,-55],[1,29,-37,],0xFFFFFF,[499,500,501,669,670,671,840,841],[501,502,503,671,672,673,841,842,843],[500,501,502,670,671,672]],
[[1,29,-37],[10,29,-55],[0,19,-38,],0xFFFFFF,[500,501,502,670,671,672],[501,502,503,671,672,673,841,842,843],[502,503,504,672,673,674]],
[[10,29,-55],[8,19,-56],[0,19,-38,],0xFFFFFF,[501,502,503,671,672,673,841,842,843],[503,504,505,661,673,674,675,831],[502,503,504,672,673,674]],
[[0,19,-38],[8,19,-56],[-1,9,-39,],0xFFFFFF,[502,503,504,672,673,674],[503,504,505,661,673,674,675,831],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[8,19,-56],[6,9,-57],[-1,9,-39,],0xFFFFFF,[503,504,505,661,673,674,675,831],[505,506,507,675,676,677],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[-1,9,-39],[6,9,-57],[-3,-1,-39,],0xFFFFFF,[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611],[505,506,507,675,676,677],[506,507,508,676,677,678]],
[[6,9,-57],[5,-1,-58],[-3,-1,-39,],0xFFFFFF,[505,506,507,675,676,677],[507,508,509,590,677,678,679,760],[506,507,508,676,677,678]],
[[-3,-1,-39],[5,-1,-58],[-4,-11,-40,],0xFFFFFF,[506,507,508,676,677,678],[507,508,509,590,677,678,679,760],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[5,-1,-58],[4,-11,-58],[-4,-11,-40,],0xFFFFFF,[507,508,509,590,677,678,679,760],[509,510,511,679,680,681],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[-4,-11,-40],[4,-11,-58],[-5,-21,-40,],0xFFFFFF,[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[509,510,511,679,680,681],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943]],
[[4,-11,-58],[3,-21,-59],[-5,-21,-40,],0xFFFFFF,[509,510,511,679,680,681],[511,512,513,681,682,683],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943]],
[[-5,-21,-40],[3,-21,-59],[-5,-31,-40,],0xFFFFFF,[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[511,512,513,681,682,683],[512,513,514,682,683,684]],
[[3,-21,-59],[3,-31,-59],[-5,-31,-40,],0xFFFFFF,[511,512,513,681,682,683],[513,514,515,594,595,596,683,684,685,764,765,766],[512,513,514,682,683,684]],
[[-5,-31,-40],[3,-31,-59],[-5,-41,-40,],0xFFFFFF,[512,513,514,682,683,684],[513,514,515,594,595,596,683,684,685,764,765,766],[514,515,516,684,685,686]],
[[3,-31,-59],[3,-41,-59],[-5,-41,-40,],0xFFFFFF,[513,514,515,594,595,596,683,684,685,764,765,766],[515,516,517,685,686,687],[514,515,516,684,685,686]],
[[-5,-41,-40],[3,-41,-59],[-4,-51,-40,],0xFFFFFF,[514,515,516,684,685,686],[515,516,517,685,686,687],[516,517,518,686,687,688]],
[[3,-41,-59],[3,-51,-58],[-4,-51,-40,],0xFFFFFF,[515,516,517,685,686,687],[517,518,519,687,688,689],[516,517,518,686,687,688]],
[[-4,-51,-40],[3,-51,-58],[-3,-61,-39,],0xFFFFFF,[516,517,518,686,687,688],[517,518,519,687,688,689],[518,519,520,688,689,690]],
[[3,-51,-58],[4,-61,-58],[-3,-61,-39,],0xFFFFFF,[517,518,519,687,688,689],[519,520,521,689,690,691],[518,519,520,688,689,690]],
[[-3,-61,-39],[4,-61,-58],[-2,-71,-39,],0xFFFFFF,[518,519,520,688,689,690],[519,520,521,689,690,691],[520,521,522,690,691,692]],
[[4,-61,-58],[6,-71,-57],[-2,-71,-39,],0xFFFFFF,[519,520,521,689,690,691],[521,522,523,691,692,693],[520,521,522,690,691,692]],
[[-2,-71,-39],[6,-71,-57],[0,-81,-38,],0xFFFFFF,[520,521,522,690,691,692],[521,522,523,691,692,693],[522,523,524,692,693,694]],
[[6,-71,-57],[8,-81,-56],[0,-81,-38,],0xFFFFFF,[521,522,523,691,692,693],[523,524,525,604,605,606,693,694,695,774,775,776],[522,523,524,692,693,694]],
[[0,-81,-38],[8,-81,-56],[3,-91,-37,],0xFFFFFF,[522,523,524,692,693,694],[523,524,525,604,605,606,693,694,695,774,775,776],[524,525,694,695]],
[[8,-81,-56],[11,-91,-54],[3,-91,-37,],0xFFFFFF,[523,524,525,604,605,606,693,694,695,774,775,776],[525,606,607,695,776,777],[524,525,694,695]],
[[171,60,-35],[177,60,-22],[187,55,-44,],0xFFFFFF,[526,696,881],[526,527,696,697],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[177,60,-22],[193,55,-30],[187,55,-44,],0xFFFFFF,[526,527,696,697],[527,528,529,697,698,699],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[187,55,-44],[193,55,-30],[194,49,-49,],0xFFFFFF,[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[527,528,529,697,698,699],[528,529,530,698,699,700,885,889]],
[[193,55,-30],[201,49,-33],[194,49,-49,],0xFFFFFF,[527,528,529,697,698,699],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[528,529,530,698,699,700,885,889]],
[[194,49,-49],[201,49,-33],[200,39,-52,],0xFFFFFF,[528,529,530,698,699,700,885,889],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[530,531,532,700,701,702,889,890]],
[[201,49,-33],[207,39,-35],[200,39,-52,],0xFFFFFF,[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[531,532,533,701,702,703],[530,531,532,700,701,702,889,890]],
[[200,39,-52],[207,39,-35],[202,29,-53,],0xFFFFFF,[530,531,532,700,701,702,889,890],[531,532,533,701,702,703],[532,533,534,663,702,703,704,833,890,891,892]],
[[207,39,-35],[210,29,-36],[202,29,-53,],0xFFFFFF,[531,532,533,701,702,703],[533,534,535,703,704,705],[532,533,534,663,702,703,704,833,890,891,892]],
[[202,29,-53],[210,29,-36],[204,19,-54,],0xFFFFFF,[532,533,534,663,702,703,704,833,890,891,892],[533,534,535,703,704,705],[534,535,536,704,705,706,892,893,894,938,939,945]],
[[210,29,-36],[212,19,-36],[204,19,-54,],0xFFFFFF,[533,534,535,703,704,705],[535,536,537,705,706,707],[534,535,536,704,705,706,892,893,894,938,939,945]],
[[204,19,-54],[212,19,-36],[206,9,-55,],0xFFFFFF,[534,535,536,704,705,706,892,893,894,938,939,945],[535,536,537,705,706,707],[536,537,538,706,707,708]],
[[212,19,-36],[214,9,-37],[206,9,-55,],0xFFFFFF,[535,536,537,705,706,707],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[536,537,538,706,707,708]],
[[206,9,-55],[214,9,-37],[207,-1,-56,],0xFFFFFF,[536,537,538,706,707,708],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[538,539,540,626,662,663,708,709,710,796,832,833]],
[[214,9,-37],[216,-1,-37],[207,-1,-56,],0xFFFFFF,[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[539,540,541,709,710,711],[538,539,540,626,662,663,708,709,710,796,832,833]],
[[207,-1,-56],[216,-1,-37],[208,-11,-56,],0xFFFFFF,[538,539,540,626,662,663,708,709,710,796,832,833],[539,540,541,709,710,711],[540,541,542,710,711,712]],
[[216,-1,-37],[217,-11,-38],[208,-11,-56,],0xFFFFFF,[539,540,541,709,710,711],[541,542,543,711,712,713],[540,541,542,710,711,712]],
[[208,-11,-56],[217,-11,-38],[209,-21,-57,],0xFFFFFF,[540,541,542,710,711,712],[541,542,543,711,712,713],[542,543,544,712,713,714]],
[[217,-11,-38],[217,-21,-38],[209,-21,-57,],0xFFFFFF,[541,542,543,711,712,713],[543,544,545,713,714,715],[542,543,544,712,713,714]],
[[209,-21,-57],[217,-21,-38],[209,-31,-57,],0xFFFFFF,[542,543,544,712,713,714],[543,544,545,713,714,715],[544,545,546,630,631,632,714,715,716,800,801,802]],
[[217,-21,-38],[218,-31,-38],[209,-31,-57,],0xFFFFFF,[543,544,545,713,714,715],[545,546,547,715,716,717],[544,545,546,630,631,632,714,715,716,800,801,802]],
[[209,-31,-57],[218,-31,-38],[209,-41,-57,],0xFFFFFF,[544,545,546,630,631,632,714,715,716,800,801,802],[545,546,547,715,716,717],[546,547,548,716,717,718]],
[[218,-31,-38],[217,-41,-38],[209,-41,-57,],0xFFFFFF,[545,546,547,715,716,717],[547,548,549,717,718,719],[546,547,548,716,717,718]],
[[209,-41,-57],[217,-41,-38],[209,-51,-57,],0xFFFFFF,[546,547,548,716,717,718],[547,548,549,717,718,719],[548,549,550,718,719,720]],
[[217,-41,-38],[217,-51,-38],[209,-51,-57,],0xFFFFFF,[547,548,549,717,718,719],[549,550,551,719,720,721],[548,549,550,718,719,720]],
[[209,-51,-57],[217,-51,-38],[208,-61,-56,],0xFFFFFF,[548,549,550,718,719,720],[549,550,551,719,720,721],[550,551,552,720,721,722]],
[[217,-51,-38],[216,-61,-38],[208,-61,-56,],0xFFFFFF,[549,550,551,719,720,721],[551,552,553,721,722,723],[550,551,552,720,721,722]],
[[208,-61,-56],[216,-61,-38],[206,-71,-55,],0xFFFFFF,[550,551,552,720,721,722],[551,552,553,721,722,723],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[216,-61,-38],[214,-71,-37],[206,-71,-55,],0xFFFFFF,[551,552,553,721,722,723],[553,554,555,723,724,725],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[206,-71,-55],[214,-71,-37],[204,-81,-54,],0xFFFFFF,[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659],[553,554,555,723,724,725],[554,555,556,640,641,642,724,725,726,810,811,812]],
[[214,-71,-37],[212,-81,-36],[204,-81,-54,],0xFFFFFF,[553,554,555,723,724,725],[555,556,557,725,726,727],[554,555,556,640,641,642,724,725,726,810,811,812]],
[[204,-81,-54],[212,-81,-36],[201,-91,-52,],0xFFFFFF,[554,555,556,640,641,642,724,725,726,810,811,812],[555,556,557,725,726,727],[556,557,642,726,727,812]],
[[212,-81,-36],[209,-91,-35],[201,-91,-52,],0xFFFFFF,[555,556,557,725,726,727],[557,727],[556,557,642,726,727,812]],
[[116,60,73],[105,55,92],[120,55,91,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[116,60,73],[107,60,74],[105,55,92,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[559,729,1586,1589,2371,2664],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[120,55,91],[106,49,101],[121,49,100,],0xFFFFFF,[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[560,562,730,732,2372,2374,2665,2667]],
[[105,55,92],[106,49,101],[120,55,91,],0xFFFFFF,[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[121,49,100],[106,49,101],[122,39,106,],0xFFFFFF,[560,562,730,732,2372,2374,2665,2667],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[106,49,101],[105,39,107],[122,39,106,],0xFFFFFF,[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[122,39,106],[105,39,107],[123,29,109,],0xFFFFFF,[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[105,39,107],[106,29,110],[123,29,109,],0xFFFFFF,[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[123,29,109],[106,29,110],[123,19,111,],0xFFFFFF,[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[106,29,110],[106,19,113],[123,19,111,],0xFFFFFF,[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[123,19,111],[106,19,113],[123,9,113,],0xFFFFFF,[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[106,19,113],[106,9,114],[123,9,113,],0xFFFFFF,[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[123,9,113],[106,9,114],[124,-1,114,],0xFFFFFF,[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[106,9,114],[105,-1,116],[124,-1,114,],0xFFFFFF,[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[124,-1,114],[105,-1,116],[124,-11,116,],0xFFFFFF,[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[105,-1,116],[105,-11,117],[124,-11,116,],0xFFFFFF,[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[124,-11,116],[105,-11,117],[124,-21,116,],0xFFFFFF,[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[105,-11,117],[106,-21,118],[124,-21,116,],0xFFFFFF,[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[124,-21,116],[106,-21,118],[124,-31,117,],0xFFFFFF,[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[106,-21,118],[106,-31,118],[124,-31,117,],0xFFFFFF,[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[124,-31,117],[106,-31,118],[124,-41,116,],0xFFFFFF,[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[106,-31,118],[104,-41,118],[124,-41,116,],0xFFFFFF,[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[124,-41,116],[104,-41,118],[124,-51,116,],0xFFFFFF,[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[104,-41,118],[104,-51,117],[124,-51,116,],0xFFFFFF,[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[124,-51,116],[104,-51,117],[124,-61,115,],0xFFFFFF,[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[104,-51,117],[105,-61,116],[124,-61,115,],0xFFFFFF,[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[124,-61,115],[105,-61,116],[123,-71,113,],0xFFFFFF,[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[105,-61,116],[105,-71,114],[123,-71,113,],0xFFFFFF,[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[123,-71,113],[105,-71,114],[123,-81,111,],0xFFFFFF,[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[105,-71,114],[105,-81,112],[123,-81,111,],0xFFFFFF,[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[123,-81,111],[105,-81,112],[123,-91,107,],0xFFFFFF,[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[588,589,758,759,2400,2401,2693,2694]],
[[105,-81,112],[106,-91,109],[123,-91,107,],0xFFFFFF,[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[589,759,2401,2694],[588,589,758,759,2400,2401,2693,2694]],
[[5,-1,-58],[19,-1,-74],[4,-11,-58,],0xFFFFFF,[507,508,509,590,677,678,679,760],[590,591,760,761],[590,591,592,760,761,762]],
[[19,-1,-74],[16,-11,-75],[4,-11,-58,],0xFFFFFF,[590,591,760,761],[591,592,593,608,609,610,761,762,763,778,779,780],[590,591,592,760,761,762]],
[[4,-11,-58],[16,-11,-75],[3,-21,-59,],0xFFFFFF,[590,591,592,760,761,762],[591,592,593,608,609,610,761,762,763,778,779,780],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618]],
[[16,-11,-75],[15,-21,-75],[3,-21,-59,],0xFFFFFF,[591,592,593,608,609,610,761,762,763,778,779,780],[593,594,595,763,764,765],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618]],
[[3,-21,-59],[15,-21,-75],[3,-31,-59,],0xFFFFFF,[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[593,594,595,763,764,765],[513,514,515,594,595,596,683,684,685,764,765,766]],
[[15,-21,-75],[15,-31,-76],[3,-31,-59,],0xFFFFFF,[593,594,595,763,764,765],[595,596,597,612,613,614,765,766,767,782,783,784],[513,514,515,594,595,596,683,684,685,764,765,766]],
[[3,-31,-59],[15,-31,-76],[3,-41,-59,],0xFFFFFF,[513,514,515,594,595,596,683,684,685,764,765,766],[595,596,597,612,613,614,765,766,767,782,783,784],[596,597,598,766,767,768]],
[[15,-31,-76],[15,-41,-76],[3,-41,-59,],0xFFFFFF,[595,596,597,612,613,614,765,766,767,782,783,784],[597,598,599,614,615,616,767,768,769,784,785,786],[596,597,598,766,767,768]],
[[3,-41,-59],[15,-41,-76],[3,-51,-58,],0xFFFFFF,[596,597,598,766,767,768],[597,598,599,614,615,616,767,768,769,784,785,786],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[15,-41,-76],[15,-51,-75],[3,-51,-58,],0xFFFFFF,[597,598,599,614,615,616,767,768,769,784,785,786],[599,600,601,616,617,618,769,770,771,786,787,788],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[3,-51,-58],[15,-51,-75],[4,-61,-58,],0xFFFFFF,[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705],[599,600,601,616,617,618,769,770,771,786,787,788],[600,601,602,770,771,772]],
[[15,-51,-75],[16,-61,-75],[4,-61,-58,],0xFFFFFF,[599,600,601,616,617,618,769,770,771,786,787,788],[601,602,603,618,619,620,771,772,773,788,789,790],[600,601,602,770,771,772]],
[[4,-61,-58],[16,-61,-75],[6,-71,-57,],0xFFFFFF,[600,601,602,770,771,772],[601,602,603,618,619,620,771,772,773,788,789,790],[602,603,604,772,773,774]],
[[16,-61,-75],[17,-71,-73],[6,-71,-57,],0xFFFFFF,[601,602,603,618,619,620,771,772,773,788,789,790],[603,604,605,773,774,775],[602,603,604,772,773,774]],
[[6,-71,-57],[17,-71,-73],[8,-81,-56,],0xFFFFFF,[602,603,604,772,773,774],[603,604,605,773,774,775],[523,524,525,604,605,606,693,694,695,774,775,776]],
[[17,-71,-73],[19,-81,-72],[8,-81,-56,],0xFFFFFF,[603,604,605,773,774,775],[605,606,607,775,776,777],[523,524,525,604,605,606,693,694,695,774,775,776]],
[[8,-81,-56],[19,-81,-72],[11,-91,-54,],0xFFFFFF,[523,524,525,604,605,606,693,694,695,774,775,776],[605,606,607,775,776,777],[525,606,607,695,776,777]],
[[19,-81,-72],[22,-91,-70],[11,-91,-54,],0xFFFFFF,[605,606,607,775,776,777],[607,624,625,777,794,795],[525,606,607,695,776,777]],
[[19,-1,-74],[31,-1,-89],[16,-11,-75,],0xFFFFFF,[608,778],[608,609,661,778,779,831],[591,592,593,608,609,610,761,762,763,778,779,780]],
[[31,-1,-89],[30,-11,-89],[16,-11,-75,],0xFFFFFF,[608,609,661,778,779,831],[609,610,611,779,780,781,855,856],[591,592,593,608,609,610,761,762,763,778,779,780]],
[[16,-11,-75],[30,-11,-89],[15,-21,-75,],0xFFFFFF,[591,592,593,608,609,610,761,762,763,778,779,780],[609,610,611,779,780,781,855,856],[610,611,612,780,781,782]],
[[30,-11,-89],[30,-21,-90],[15,-21,-75,],0xFFFFFF,[609,610,611,779,780,781,855,856],[611,612,613,781,782,783,856,857],[610,611,612,780,781,782]],
[[15,-21,-75],[30,-21,-90],[15,-31,-76,],0xFFFFFF,[610,611,612,780,781,782],[611,612,613,781,782,783,856,857],[595,596,597,612,613,614,765,766,767,782,783,784]],
[[30,-21,-90],[29,-31,-90],[15,-31,-76,],0xFFFFFF,[611,612,613,781,782,783,856,857],[613,614,615,783,784,785,857,858,859],[595,596,597,612,613,614,765,766,767,782,783,784]],
[[15,-31,-76],[29,-31,-90],[15,-41,-76,],0xFFFFFF,[595,596,597,612,613,614,765,766,767,782,783,784],[613,614,615,783,784,785,857,858,859],[597,598,599,614,615,616,767,768,769,784,785,786]],
[[29,-31,-90],[29,-41,-90],[15,-41,-76,],0xFFFFFF,[613,614,615,783,784,785,857,858,859],[615,616,617,785,786,787,859,860],[597,598,599,614,615,616,767,768,769,784,785,786]],
[[15,-41,-76],[29,-41,-90],[15,-51,-75,],0xFFFFFF,[597,598,599,614,615,616,767,768,769,784,785,786],[615,616,617,785,786,787,859,860],[599,600,601,616,617,618,769,770,771,786,787,788]],
[[29,-41,-90],[30,-51,-90],[15,-51,-75,],0xFFFFFF,[615,616,617,785,786,787,859,860],[617,618,619,787,788,789,860,861],[599,600,601,616,617,618,769,770,771,786,787,788]],
[[15,-51,-75],[30,-51,-90],[16,-61,-75,],0xFFFFFF,[599,600,601,616,617,618,769,770,771,786,787,788],[617,618,619,787,788,789,860,861],[601,602,603,618,619,620,771,772,773,788,789,790]],
[[30,-51,-90],[30,-61,-89],[16,-61,-75,],0xFFFFFF,[617,618,619,787,788,789,860,861],[619,620,621,789,790,791,861,862],[601,602,603,618,619,620,771,772,773,788,789,790]],
[[16,-61,-75],[30,-61,-89],[17,-71,-73,],0xFFFFFF,[601,602,603,618,619,620,771,772,773,788,789,790],[619,620,621,789,790,791,861,862],[620,621,622,790,791,792]],
[[30,-61,-89],[32,-71,-88],[17,-71,-73,],0xFFFFFF,[619,620,621,789,790,791,861,862],[621,622,623,791,792,793,862,863,864],[620,621,622,790,791,792]],
[[17,-71,-73],[32,-71,-88],[19,-81,-72,],0xFFFFFF,[620,621,622,790,791,792],[621,622,623,791,792,793,862,863,864],[622,623,624,792,793,794,5352]],
[[32,-71,-88],[33,-81,-86],[19,-81,-72,],0xFFFFFF,[621,622,623,791,792,793,862,863,864],[623,624,625,793,794,795,864,865,5351,5352],[622,623,624,792,793,794,5352]],
[[19,-81,-72],[33,-81,-86],[22,-91,-70,],0xFFFFFF,[622,623,624,792,793,794,5352],[623,624,625,793,794,795,864,865,5351,5352],[607,624,625,777,794,795]],
[[33,-81,-86],[35,-91,-83],[22,-91,-70,],0xFFFFFF,[623,624,625,793,794,795,864,865,5351,5352],[625,795,865,866],[607,624,625,777,794,795]],
[[207,-1,-56],[208,-11,-56],[197,-11,-73,],0xFFFFFF,[538,539,540,626,662,663,708,709,710,796,832,833],[626,627,628,796,797,798],[626,627,644,645,646,662,796,797,814,815,816,832]],
[[197,-11,-73],[208,-11,-56],[197,-21,-74,],0xFFFFFF,[626,627,644,645,646,662,796,797,814,815,816,832],[626,627,628,796,797,798],[627,628,629,797,798,799]],
[[208,-11,-56],[209,-21,-57],[197,-21,-74,],0xFFFFFF,[626,627,628,796,797,798],[628,629,630,798,799,800],[627,628,629,797,798,799]],
[[197,-21,-74],[209,-21,-57],[198,-31,-74,],0xFFFFFF,[627,628,629,797,798,799],[628,629,630,798,799,800],[629,630,631,648,649,650,799,800,801,818,819,820]],
[[209,-21,-57],[209,-31,-57],[198,-31,-74,],0xFFFFFF,[628,629,630,798,799,800],[544,545,546,630,631,632,714,715,716,800,801,802],[629,630,631,648,649,650,799,800,801,818,819,820]],
[[198,-31,-74],[209,-31,-57],[198,-41,-74,],0xFFFFFF,[629,630,631,648,649,650,799,800,801,818,819,820],[544,545,546,630,631,632,714,715,716,800,801,802],[631,632,633,801,802,803]],
[[209,-31,-57],[209,-41,-57],[198,-41,-74,],0xFFFFFF,[544,545,546,630,631,632,714,715,716,800,801,802],[632,633,634,802,803,804],[631,632,633,801,802,803]],
[[198,-41,-74],[209,-41,-57],[197,-51,-74,],0xFFFFFF,[631,632,633,801,802,803],[632,633,634,802,803,804],[633,634,635,803,804,805]],
[[209,-41,-57],[209,-51,-57],[197,-51,-74,],0xFFFFFF,[632,633,634,802,803,804],[634,635,636,804,805,806],[633,634,635,803,804,805]],
[[197,-51,-74],[209,-51,-57],[196,-61,-73,],0xFFFFFF,[633,634,635,803,804,805],[634,635,636,804,805,806],[635,636,637,805,806,807]],
[[209,-51,-57],[208,-61,-56],[196,-61,-73,],0xFFFFFF,[634,635,636,804,805,806],[636,637,638,806,807,808],[635,636,637,805,806,807]],
[[196,-61,-73],[208,-61,-56],[195,-71,-72,],0xFFFFFF,[635,636,637,805,806,807],[636,637,638,806,807,808],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[208,-61,-56],[206,-71,-55],[195,-71,-72,],0xFFFFFF,[636,637,638,806,807,808],[638,639,640,808,809,810],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[195,-71,-72],[206,-71,-55],[193,-81,-70,],0xFFFFFF,[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744],[638,639,640,808,809,810],[639,640,641,809,810,811]],
[[206,-71,-55],[204,-81,-54],[193,-81,-70,],0xFFFFFF,[638,639,640,808,809,810],[554,555,556,640,641,642,724,725,726,810,811,812],[639,640,641,809,810,811]],
[[193,-81,-70],[204,-81,-54],[190,-91,-68,],0xFFFFFF,[639,640,641,809,810,811],[554,555,556,640,641,642,724,725,726,810,811,812],[641,642,811,812]],
[[204,-81,-54],[201,-91,-52],[190,-91,-68,],0xFFFFFF,[554,555,556,640,641,642,724,725,726,810,811,812],[556,557,642,726,727,812],[641,642,811,812]],
[[182,-1,-87],[194,-1,-73],[183,-11,-88,],0xFFFFFF,[643,663,813,833],[643,644,662,813,814,832],[643,644,645,813,814,815,923,924]],
[[194,-1,-73],[197,-11,-73],[183,-11,-88,],0xFFFFFF,[643,644,662,813,814,832],[626,627,644,645,646,662,796,797,814,815,816,832],[643,644,645,813,814,815,923,924]],
[[183,-11,-88],[197,-11,-73],[183,-21,-89,],0xFFFFFF,[643,644,645,813,814,815,923,924],[626,627,644,645,646,662,796,797,814,815,816,832],[645,646,647,815,816,817,921,922,923]],
[[197,-11,-73],[197,-21,-74],[183,-21,-89,],0xFFFFFF,[626,627,644,645,646,662,796,797,814,815,816,832],[646,647,648,816,817,818],[645,646,647,815,816,817,921,922,923]],
[[183,-21,-89],[197,-21,-74],[183,-31,-89,],0xFFFFFF,[645,646,647,815,816,817,921,922,923],[646,647,648,816,817,818],[647,648,649,817,818,819,920,921]],
[[197,-21,-74],[198,-31,-74],[183,-31,-89,],0xFFFFFF,[646,647,648,816,817,818],[629,630,631,648,649,650,799,800,801,818,819,820],[647,648,649,817,818,819,920,921]],
[[183,-31,-89],[198,-31,-74],[183,-41,-89,],0xFFFFFF,[647,648,649,817,818,819,920,921],[629,630,631,648,649,650,799,800,801,818,819,820],[649,650,651,819,820,821,919,920]],
[[198,-31,-74],[198,-41,-74],[183,-41,-89,],0xFFFFFF,[629,630,631,648,649,650,799,800,801,818,819,820],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[649,650,651,819,820,821,919,920]],
[[183,-41,-89],[198,-41,-74],[183,-51,-88,],0xFFFFFF,[649,650,651,819,820,821,919,920],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[651,652,653,821,822,823,918,919]],
[[198,-41,-74],[197,-51,-74],[183,-51,-88,],0xFFFFFF,[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[652,653,654,822,823,824],[651,652,653,821,822,823,918,919]],
[[183,-51,-88],[197,-51,-74],[182,-61,-88,],0xFFFFFF,[651,652,653,821,822,823,918,919],[652,653,654,822,823,824],[653,654,655,823,824,825,916,917,918]],
[[197,-51,-74],[196,-61,-73],[182,-61,-88,],0xFFFFFF,[652,653,654,822,823,824],[654,655,656,824,825,826],[653,654,655,823,824,825,916,917,918]],
[[182,-61,-88],[196,-61,-73],[181,-71,-86,],0xFFFFFF,[653,654,655,823,824,825,916,917,918],[654,655,656,824,825,826],[655,656,657,825,826,827,915,916]],
[[196,-61,-73],[195,-71,-72],[181,-71,-86,],0xFFFFFF,[654,655,656,824,825,826],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[655,656,657,825,826,827,915,916]],
[[181,-71,-86],[195,-71,-72],[179,-81,-84,],0xFFFFFF,[655,656,657,825,826,827,915,916],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[657,658,659,827,828,829,914,915]],
[[195,-71,-72],[193,-81,-70],[179,-81,-84,],0xFFFFFF,[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[658,659,660,828,829,830],[657,658,659,827,828,829,914,915]],
[[179,-81,-84],[193,-81,-70],[177,-91,-82,],0xFFFFFF,[657,658,659,827,828,829,914,915],[658,659,660,828,829,830],[659,660,829,830,912,913,914]],
[[193,-81,-70],[190,-91,-68],[177,-91,-82,],0xFFFFFF,[658,659,660,828,829,830],[660,830],[659,660,829,830,912,913,914]],
[[31,-1,-89],[5,-1,-57],[8,19,-56,],0xFFFFFF,[608,609,661,778,779,831],[661,831],[503,504,505,661,673,674,675,831]],
[[207,-1,-56],[197,-11,-73],[194,-1,-73,],0xFFFFFF,[538,539,540,626,662,663,708,709,710,796,832,833],[626,627,644,645,646,662,796,797,814,815,816,832],[643,644,662,813,814,832]],
[[202,29,-53],[207,-1,-56],[182,-1,-87,],0xFFFFFF,[532,533,534,663,702,703,704,833,890,891,892],[538,539,540,626,662,663,708,709,710,796,832,833],[643,663,813,833]],
[[20,45,-49],[25,45,-46],[14,24,-53,],0xFFFFFF,[834,839,840,841,842],[834,835,837,838,839,848,849],[834,835,842,843,844,845]],
[[25,45,-46],[22,24,-48],[14,24,-53,],0x000000,[834,835,837,838,839,848,849],[835,845,846,847,848],[834,835,842,843,844,845]],
[[25,55,-46],[41,60,-37],[30,48,-43,],0xFFFFFF,[495,496,497,665,666,667,836,837,838],[494,495,664,665,836],[836,837,849]],
[[25,55,-46],[30,48,-43],[25,45,-46,],0xFFFFFF,[495,496,497,665,666,667,836,837,838],[836,837,849],[834,835,837,838,839,848,849]],
[[25,45,-46],[18,49,-50],[25,55,-46,],0xFFFFFF,[834,835,837,838,839,848,849],[497,498,499,667,668,669,838,839,840],[495,496,497,665,666,667,836,837,838]],
[[18,49,-50],[25,45,-46],[20,45,-49,],0xFFFFFF,[497,498,499,667,668,669,838,839,840],[834,835,837,838,839,848,849],[834,839,840,841,842]],
[[20,45,-49],[12,39,-53],[18,49,-50,],0xFFFFFF,[834,839,840,841,842],[499,500,501,669,670,671,840,841],[497,498,499,667,668,669,838,839,840]],
[[20,45,-49],[10,29,-55],[12,39,-53,],0xFFFFFF,[834,839,840,841,842],[501,502,503,671,672,673,841,842,843],[499,500,501,669,670,671,840,841]],
[[20,45,-49],[14,24,-53],[10,29,-55,],0xFFFFFF,[834,839,840,841,842],[834,835,842,843,844,845],[501,502,503,671,672,673,841,842,843]],
[[10,29,-55],[14,24,-53],[7,19,-57,],0xFFFFFF,[501,502,503,671,672,673,841,842,843],[834,835,842,843,844,845],[843,844,930,936,937]],
[[7,19,-57],[14,24,-53],[25,18,-45,],0xFFFFFF,[843,844,930,936,937],[834,835,842,843,844,845],[844,845,846,930,931,934,935]],
[[22,24,-48],[25,18,-45],[14,24,-53,],0x000000,[835,845,846,847,848],[844,845,846,930,931,934,935],[834,835,842,843,844,845]],
[[22,24,-48],[26,28,-45],[25,18,-45,],0xFFFFFF,[835,845,846,847,848],[846,847,4265,4266,4267,4320,4321,4322],[844,845,846,930,931,934,935]],
[[22,24,-48],[28,38,-44],[26,28,-45,],0xFFFFFF,[835,845,846,847,848],[847,848,849],[846,847,4265,4266,4267,4320,4321,4322]],
[[25,45,-46],[28,38,-44],[22,24,-48,],0xFFFFFF,[834,835,837,838,839,848,849],[847,848,849],[835,845,846,847,848]],
[[25,45,-46],[30,48,-43],[28,38,-44,],0xFFFFFF,[834,835,837,838,839,848,849],[836,837,849],[847,848,849]],
[[30,-7,-90],[40,-7,-77],[36,-45,-83,],0x000000,[850,854,855,856,857,858,929],[850,851,854,876,877,878],[850,851,852,853,858,859,860,861,862,863]],
[[40,-7,-77],[43,-45,-74],[36,-45,-83,],0x000000,[850,851,854,876,877,878],[851,853,871,872,873,874,875,876],[850,851,852,853,858,859,860,861,862,863]],
[[38,-83,-80],[36,-45,-83],[46,-83,-70,],0x000000,[852,863,864,865,866,867],[850,851,852,853,858,859,860,861,862,863],[852,853,867,868,869,870,871]],
[[46,-83,-70],[36,-45,-83],[43,-45,-74,],0x000000,[852,853,867,868,869,870,871],[850,851,852,853,858,859,860,861,862,863],[851,853,871,872,873,874,875,876]],
[[30,-7,-90],[45,-2,-71],[40,-7,-77,],0xFFFFFF,[850,854,855,856,857,858,929],[854,878,929,932,933,934],[850,851,854,876,877,878]],
[[30,-1,-89],[30,-11,-89],[30,-7,-90,],0xFFFFFF,[855,929,932,937],[609,610,611,779,780,781,855,856],[850,854,855,856,857,858,929]],
[[30,-11,-89],[30,-21,-90],[30,-7,-90,],0xFFFFFF,[609,610,611,779,780,781,855,856],[611,612,613,781,782,783,856,857],[850,854,855,856,857,858,929]],
[[30,-21,-90],[30,-7,-90],[29,-31,-90,],0xFFFFFF,[611,612,613,781,782,783,856,857],[850,854,855,856,857,858,929],[613,614,615,783,784,785,857,858,859]],
[[30,-7,-90],[36,-45,-83],[29,-31,-90,],0xFFFFFF,[850,854,855,856,857,858,929],[850,851,852,853,858,859,860,861,862,863],[613,614,615,783,784,785,857,858,859]],
[[29,-31,-90],[36,-45,-83],[29,-41,-90,],0xFFFFFF,[613,614,615,783,784,785,857,858,859],[850,851,852,853,858,859,860,861,862,863],[615,616,617,785,786,787,859,860]],
[[29,-41,-90],[36,-45,-83],[30,-51,-90,],0xFFFFFF,[615,616,617,785,786,787,859,860],[850,851,852,853,858,859,860,861,862,863],[617,618,619,787,788,789,860,861]],
[[30,-51,-90],[36,-45,-83],[30,-61,-89,],0xFFFFFF,[617,618,619,787,788,789,860,861],[850,851,852,853,858,859,860,861,862,863],[619,620,621,789,790,791,861,862]],
[[30,-61,-89],[36,-45,-83],[32,-71,-88,],0xFFFFFF,[619,620,621,789,790,791,861,862],[850,851,852,853,858,859,860,861,862,863],[621,622,623,791,792,793,862,863,864]],
[[36,-45,-83],[38,-83,-80],[32,-71,-88,],0xFFFFFF,[850,851,852,853,858,859,860,861,862,863],[852,863,864,865,866,867],[621,622,623,791,792,793,862,863,864]],
[[32,-71,-88],[38,-83,-80],[33,-81,-86,],0xFFFFFF,[621,622,623,791,792,793,862,863,864],[852,863,864,865,866,867],[623,624,625,793,794,795,864,865,5351,5352]],
[[33,-81,-86],[38,-83,-80],[35,-91,-83,],0xFFFFFF,[623,624,625,793,794,795,864,865,5351,5352],[852,863,864,865,866,867],[625,795,865,866]],
[[38,-83,-80],[55,-92,-59],[35,-91,-83,],0xFFFFFF,[852,863,864,865,866,867],[866,867,868],[625,795,865,866]],
[[46,-83,-70],[55,-92,-59],[38,-83,-80,],0xFFFFFF,[852,853,867,868,869,870,871],[866,867,868],[852,863,864,865,866,867]],
[[46,-83,-70],[53,-82,-62],[55,-92,-59,],0xFFFFFF,[852,853,867,868,869,870,871],[868,869],[866,867,868]],
[[46,-83,-70],[51,-72,-65],[53,-82,-62,],0xFFFFFF,[852,853,867,868,869,870,871],[869,870],[868,869]],
[[46,-83,-70],[49,-62,-67],[51,-72,-65,],0xFFFFFF,[852,853,867,868,869,870,871],[870,871,872,4424,4425,4426],[869,870]],
[[43,-45,-74],[49,-62,-67],[46,-83,-70,],0xFFFFFF,[851,853,871,872,873,874,875,876],[870,871,872,4424,4425,4426],[852,853,867,868,869,870,871]],
[[43,-45,-74],[47,-52,-69],[49,-62,-67,],0xFFFFFF,[851,853,871,872,873,874,875,876],[872,873],[870,871,872,4424,4425,4426]],
[[43,-45,-74],[46,-42,-70],[47,-52,-69,],0xFFFFFF,[851,853,871,872,873,874,875,876],[873,874],[872,873]],
[[43,-45,-74],[45,-32,-71],[46,-42,-70,],0xFFFFFF,[851,853,871,872,873,874,875,876],[874,875],[873,874]],
[[43,-45,-74],[45,-22,-72],[45,-32,-71,],0xFFFFFF,[851,853,871,872,873,874,875,876],[875,876,877],[874,875]],
[[43,-45,-74],[40,-7,-77],[45,-22,-72,],0xFFFFFF,[851,853,871,872,873,874,875,876],[850,851,854,876,877,878],[875,876,877]],
[[40,-7,-77],[44,-12,-72],[45,-22,-72,],0xFFFFFF,[850,851,854,876,877,878],[877,878],[875,876,877]],
[[40,-7,-77],[45,-2,-71],[44,-12,-72,],0xFFFFFF,[850,851,854,876,877,878],[854,878,929,932,933,934],[877,878]],
[[185,43,-45],[191,44,-49],[189,23,-48,],0x000000,[879,882,883,884,886],[879,880,884,885,889,890,891],[879,880,886,887,888,893,894]],
[[189,23,-48],[191,44,-49],[196,23,-52,],0x000000,[879,880,886,887,888,893,894],[879,880,884,885,889,890,891],[880,891,892,894]],
[[171,60,-35],[187,55,-44],[180,48,-44,],0xFFFFFF,[526,696,881],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[881,882,883]],
[[180,48,-44],[185,43,-45],[182,38,-46,],0xFFFFFF,[881,882,883],[879,882,883,884,886],[882,886,887]],
[[180,48,-44],[187,55,-44],[185,43,-45,],0xFFFFFF,[881,882,883],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[879,882,883,884,886]],
[[185,43,-45],[187,55,-44],[191,44,-49,],0xFFFFFF,[879,882,883,884,886],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[879,880,884,885,889,890,891]],
[[191,44,-49],[187,55,-44],[194,49,-49,],0xFFFFFF,[879,880,884,885,889,890,891],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[528,529,530,698,699,700,885,889]],
[[185,43,-45],[189,23,-48],[182,38,-46,],0xFFFFFF,[879,882,883,884,886],[879,880,886,887,888,893,894],[882,886,887]],
[[182,38,-46],[189,23,-48],[184,28,-47,],0xFFFFFF,[882,886,887],[879,880,886,887,888,893,894],[887,888]],
[[189,23,-48],[185,18,-47],[184,28,-47,],0xFFFFFF,[879,880,886,887,888,893,894],[888,893,938,940,2596,2597,2889,2890],[887,888]],
[[191,44,-49],[194,49,-49],[200,39,-52,],0xFFFFFF,[879,880,884,885,889,890,891],[528,529,530,698,699,700,885,889],[530,531,532,700,701,702,889,890]],
[[191,44,-49],[200,39,-52],[202,29,-53,],0xFFFFFF,[879,880,884,885,889,890,891],[530,531,532,700,701,702,889,890],[532,533,534,663,702,703,704,833,890,891,892]],
[[191,44,-49],[202,29,-53],[196,23,-52,],0xFFFFFF,[879,880,884,885,889,890,891],[532,533,534,663,702,703,704,833,890,891,892],[880,891,892,894]],
[[202,29,-53],[204,19,-54],[196,23,-52,],0xFFFFFF,[532,533,534,663,702,703,704,833,890,891,892],[534,535,536,704,705,706,892,893,894,938,939,945],[880,891,892,894]],
[[189,23,-48],[204,19,-54],[185,18,-47,],0xFFFFFF,[879,880,886,887,888,893,894],[534,535,536,704,705,706,892,893,894,938,939,945],[888,893,938,940,2596,2597,2889,2890]],
[[189,23,-48],[196,23,-52],[204,19,-54,],0x000000,[879,880,886,887,888,893,894],[880,891,892,894],[534,535,536,704,705,706,892,893,894,938,939,945]],
[[169,-7,-76],[176,-7,-83],[167,-43,-72,],0x000000,[895,899,900,901,902,903],[895,896,900,922,923,924],[895,896,897,898,903,904,905,906,907,908]],
[[176,-7,-83],[174,-43,-81],[167,-43,-72,],0x000000,[895,896,900,922,923,924],[896,898,917,918,919,920,921,922],[895,896,897,898,903,904,905,906,907,908]],
[[164,-85,-69],[167,-43,-72],[171,-85,-78,],0xFFFFFF,[897,908,909,910,911,912,913],[895,896,897,898,903,904,905,906,907,908],[897,898,913,914,915,916,917]],
[[171,-85,-78],[167,-43,-72],[174,-43,-81,],0xFFFFFF,[897,898,913,914,915,916,917],[895,896,897,898,903,904,905,906,907,908],[896,898,917,918,919,920,921,922]],
[[165,-2,-73],[178,-1,-87],[169,-7,-76,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[899,900,924,942,943,944,945],[895,899,900,901,902,903]],
[[178,-1,-87],[176,-7,-83],[169,-7,-76,],0xFFFFFF,[899,900,924,942,943,944,945],[895,896,900,922,923,924],[895,899,900,901,902,903]],
[[165,-2,-73],[169,-7,-76],[165,-12,-73,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[895,899,900,901,902,903],[901,902,2576,2577,2869,2870]],
[[165,-12,-73],[169,-7,-76],[165,-22,-73,],0xFFFFFF,[901,902,2576,2577,2869,2870],[895,899,900,901,902,903],[902,903,904]],
[[165,-22,-73],[169,-7,-76],[167,-43,-72,],0xFFFFFF,[902,903,904],[895,899,900,901,902,903],[895,896,897,898,903,904,905,906,907,908]],
[[165,-22,-73],[167,-43,-72],[165,-32,-72,],0xFFFFFF,[902,903,904],[895,896,897,898,903,904,905,906,907,908],[904,905]],
[[165,-32,-72],[167,-43,-72],[164,-42,-71,],0xFFFFFF,[904,905],[895,896,897,898,903,904,905,906,907,908],[905,906,2580,2581,2873,2874]],
[[164,-42,-71],[167,-43,-72],[163,-52,-70,],0xFFFFFF,[905,906,2580,2581,2873,2874],[895,896,897,898,903,904,905,906,907,908],[906,907]],
[[167,-43,-72],[161,-62,-68],[163,-52,-70,],0xFFFFFF,[895,896,897,898,903,904,905,906,907,908],[907,908,909],[906,907]],
[[161,-62,-68],[167,-43,-72],[164,-85,-69,],0xFFFFFF,[907,908,909],[895,896,897,898,903,904,905,906,907,908],[897,908,909,910,911,912,913]],
[[161,-62,-68],[164,-85,-69],[159,-72,-66,],0xFFFFFF,[907,908,909],[897,908,909,910,911,912,913],[909,910]],
[[159,-72,-66],[164,-85,-69],[157,-82,-63,],0xFFFFFF,[909,910],[897,908,909,910,911,912,913],[910,911]],
[[157,-82,-63],[164,-85,-69],[155,-92,-60,],0xFFFFFF,[910,911],[897,908,909,910,911,912,913],[911,912]],
[[164,-85,-69],[177,-91,-82],[155,-92,-60,],0xFFFFFF,[897,908,909,910,911,912,913],[659,660,829,830,912,913,914],[911,912]],
[[164,-85,-69],[171,-85,-78],[177,-91,-82,],0xFFFFFF,[897,908,909,910,911,912,913],[897,898,913,914,915,916,917],[659,660,829,830,912,913,914]],
[[171,-85,-78],[179,-81,-84],[177,-91,-82,],0xFFFFFF,[897,898,913,914,915,916,917],[657,658,659,827,828,829,914,915],[659,660,829,830,912,913,914]],
[[171,-85,-78],[181,-71,-86],[179,-81,-84,],0xFFFFFF,[897,898,913,914,915,916,917],[655,656,657,825,826,827,915,916],[657,658,659,827,828,829,914,915]],
[[171,-85,-78],[182,-61,-88],[181,-71,-86,],0xFFFFFF,[897,898,913,914,915,916,917],[653,654,655,823,824,825,916,917,918],[655,656,657,825,826,827,915,916]],
[[174,-43,-81],[182,-61,-88],[171,-85,-78,],0xFFFFFF,[896,898,917,918,919,920,921,922],[653,654,655,823,824,825,916,917,918],[897,898,913,914,915,916,917]],
[[174,-43,-81],[183,-51,-88],[182,-61,-88,],0xFFFFFF,[896,898,917,918,919,920,921,922],[651,652,653,821,822,823,918,919],[653,654,655,823,824,825,916,917,918]],
[[174,-43,-81],[183,-41,-89],[183,-51,-88,],0xFFFFFF,[896,898,917,918,919,920,921,922],[649,650,651,819,820,821,919,920],[651,652,653,821,822,823,918,919]],
[[174,-43,-81],[183,-31,-89],[183,-41,-89,],0xFFFFFF,[896,898,917,918,919,920,921,922],[647,648,649,817,818,819,920,921],[649,650,651,819,820,821,919,920]],
[[174,-43,-81],[183,-21,-89],[183,-31,-89,],0xFFFFFF,[896,898,917,918,919,920,921,922],[645,646,647,815,816,817,921,922,923],[647,648,649,817,818,819,920,921]],
[[176,-7,-83],[183,-21,-89],[174,-43,-81,],0xFFFFFF,[895,896,900,922,923,924],[645,646,647,815,816,817,921,922,923],[896,898,917,918,919,920,921,922]],
[[176,-7,-83],[183,-11,-88],[183,-21,-89,],0xFFFFFF,[895,896,900,922,923,924],[643,644,645,813,814,815,923,924],[645,646,647,815,816,817,921,922,923]],
[[176,-7,-83],[178,-1,-87],[183,-11,-88,],0xFFFFFF,[895,896,900,922,923,924],[899,900,924,942,943,944,945],[643,644,645,813,814,815,923,924]],
[[17,15,-61],[29,15,-53],[33,2,-85,],0xFFFFFF,[925,930,931,936],[925,926,931,935],[925,926,932,933,936,937]],
[[29,15,-53],[42,2,-72],[33,2,-85,],0xFFFFFF,[925,926,931,935],[926,933,934,935],[925,926,932,933,936,937]],
[[183,13,-55],[191,13,-61],[172,3,-72,],0xFFFFFF,[927,938,939,940,941],[927,928,939,944,945],[927,928,941,942,943]],
[[191,13,-61],[180,2,-79],[172,3,-72,],0xFFFFFF,[927,928,939,944,945],[928,943,944],[927,928,941,942,943]],
[[30,-1,-89],[45,-2,-71],[30,-7,-90,],0xFFFFFF,[855,929,932,937],[854,878,929,932,933,934],[850,854,855,856,857,858,929]],
[[7,19,-57],[25,18,-45],[17,15,-61,],0xFFFFFF,[843,844,930,936,937],[844,845,846,930,931,934,935],[925,930,931,936]],
[[25,18,-45],[29,15,-53],[17,15,-61,],0xFFFFFF,[844,845,846,930,931,934,935],[925,926,931,935],[925,930,931,936]],
[[33,2,-85],[45,-2,-71],[30,-1,-89,],0xFFFFFF,[925,926,932,933,936,937],[854,878,929,932,933,934],[855,929,932,937]],
[[33,2,-85],[42,2,-72],[45,-2,-71,],0xFFFFFF,[925,926,932,933,936,937],[926,933,934,935],[854,878,929,932,933,934]],
[[42,2,-72],[45,-2,-71],[25,18,-45,],0xFFFFFF,[926,933,934,935],[854,878,929,932,933,934],[844,845,846,930,931,934,935]],
[[42,2,-72],[25,18,-45],[29,15,-53,],0xFFFFFF,[926,933,934,935],[844,845,846,930,931,934,935],[925,926,931,935]],
[[33,2,-85],[7,19,-57],[17,15,-61,],0xFFFFFF,[925,926,932,933,936,937],[843,844,930,936,937],[925,930,931,936]],
[[7,19,-57],[33,2,-85],[30,-1,-89,],0xFFFFFF,[843,844,930,936,937],[925,926,932,933,936,937],[855,929,932,937]],
[[185,18,-47],[204,19,-54],[183,13,-55,],0xFFFFFF,[888,893,938,940,2596,2597,2889,2890],[534,535,536,704,705,706,892,893,894,938,939,945],[927,938,939,940,941]],
[[204,19,-54],[191,13,-61],[183,13,-55,],0xFFFFFF,[534,535,536,704,705,706,892,893,894,938,939,945],[927,928,939,944,945],[927,938,939,940,941]],
[[185,18,-47],[183,13,-55],[165,-2,-73,],0xFFFFFF,[888,893,938,940,2596,2597,2889,2890],[927,938,939,940,941],[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883]],
[[183,13,-55],[172,3,-72],[165,-2,-73,],0xFFFFFF,[927,938,939,940,941],[927,928,941,942,943],[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883]],
[[172,3,-72],[178,-1,-87],[165,-2,-73,],0xFFFFFF,[927,928,941,942,943],[899,900,924,942,943,944,945],[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883]],
[[172,3,-72],[180,2,-79],[178,-1,-87,],0xFFFFFF,[927,928,941,942,943],[928,943,944],[899,900,924,942,943,944,945]],
[[180,2,-79],[191,13,-61],[178,-1,-87,],0xFFFFFF,[928,943,944],[927,928,939,944,945],[899,900,924,942,943,944,945]],
[[191,13,-61],[204,19,-54],[178,-1,-87,],0xFFFFFF,[927,928,939,944,945],[534,535,536,704,705,706,892,893,894,938,939,945],[899,900,924,942,943,944,945]],
[[32,60,-11],[36,60,-25],[14,55,-16,],0xFFFFFF,[946,949],[946,947,949,950],[946,947,948,949,950,951]],
[[36,60,-25],[18,55,-31],[14,55,-16,],0xFFFFFF,[946,947,949,950],[947,948,950,951,952,958],[946,947,948,949,950,951]],
[[14,55,-16],[18,55,-31],[6,49,-17,],0xFFFFFF,[946,947,948,949,950,951],[947,948,950,951,952,958],[948,951,952,953,958,959]],
[[32,60,-11],[36,60,-25],[14,55,-16,],0xFFFFFF,[946,949],[946,947,949,950],[946,947,948,949,950,951]],
[[36,60,-25],[18,55,-31],[14,55,-16,],0xFFFFFF,[946,947,949,950],[947,948,950,951,952,958],[946,947,948,949,950,951]],
[[14,55,-16],[18,55,-31],[6,49,-17,],0xFFFFFF,[946,947,948,949,950,951],[947,948,950,951,952,958],[948,951,952,953,958,959]],
[[18,55,-31],[10,49,-34],[6,49,-17,],0xFFFFFF,[947,948,950,951,952,958],[952,953,954,958,959,960],[948,951,952,953,958,959]],
[[6,49,-17],[10,49,-34],[0,39,-18,],0xFFFFFF,[948,951,952,953,958,959],[952,953,954,958,959,960],[953,954,955,959,960,961]],
[[10,49,-34],[4,39,-36],[0,39,-18,],0xFFFFFF,[952,953,954,958,959,960],[954,955,956,960,961,962],[953,954,955,959,960,961]],
[[0,39,-18],[4,39,-36],[-3,29,-19,],0xFFFFFF,[953,954,955,959,960,961],[954,955,956,960,961,962],[955,956,957,961,962,963]],
[[4,39,-36],[1,29,-37],[-3,29,-19,],0xFFFFFF,[954,955,956,960,961,962],[956,957,962,963,964,966],[955,956,957,961,962,963]],
[[-3,29,-19],[1,29,-37],[-5,19,-19,],0xFFFFFF,[955,956,957,961,962,963],[956,957,962,963,964,966],[957,963,964,965,966,967]],
[[18,55,-31],[10,49,-34],[6,49,-17,],0xFFFFFF,[947,948,950,951,952,958],[952,953,954,958,959,960],[948,951,952,953,958,959]],
[[6,49,-17],[10,49,-34],[0,39,-18,],0xFFFFFF,[948,951,952,953,958,959],[952,953,954,958,959,960],[953,954,955,959,960,961]],
[[10,49,-34],[4,39,-36],[0,39,-18,],0xFFFFFF,[952,953,954,958,959,960],[954,955,956,960,961,962],[953,954,955,959,960,961]],
[[0,39,-18],[4,39,-36],[-3,29,-19,],0xFFFFFF,[953,954,955,959,960,961],[954,955,956,960,961,962],[955,956,957,961,962,963]],
[[4,39,-36],[1,29,-37],[-3,29,-19,],0xFFFFFF,[954,955,956,960,961,962],[956,957,962,963,964,966],[955,956,957,961,962,963]],
[[-3,29,-19],[1,29,-37],[-5,19,-19,],0xFFFFFF,[955,956,957,961,962,963],[956,957,962,963,964,966],[957,963,964,965,966,967]],
[[1,29,-37],[0,19,-38],[-5,19,-19,],0xFFFFFF,[956,957,962,963,964,966],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[957,963,964,965,966,967]],
[[-5,19,-19],[0,19,-38],[-7,9,-19,],0xFFFFFF,[957,963,964,965,966,967],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[1,29,-37],[0,19,-38],[-5,19,-19,],0xFFFFFF,[956,957,962,963,964,966],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[957,963,964,965,966,967]],
[[-5,19,-19],[0,19,-38],[-7,9,-19,],0xFFFFFF,[957,963,964,965,966,967],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[-7,9,-19],[-1,9,-39],[-8,-1,-20,],0xFFFFFF,[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936],[968,969,977,978,986,987],[968,969,970,977,978,979]],
[[-1,9,-39],[-3,-1,-39],[-8,-1,-20,],0xFFFFFF,[968,969,977,978,986,987],[969,970,971,978,979,980],[968,969,970,977,978,979]],
[[-8,-1,-20],[-3,-1,-39],[-9,-11,-20,],0xFFFFFF,[968,969,970,977,978,979],[969,970,971,978,979,980],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-3,-1,-39],[-4,-11,-40],[-9,-11,-20,],0xFFFFFF,[969,970,971,978,979,980],[971,972,973,980,981,982],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-9,-11,-20],[-4,-11,-40],[-10,-21,-20,],0xFFFFFF,[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940],[971,972,973,980,981,982],[972,973,974,981,982,983]],
[[-4,-11,-40],[-5,-21,-40],[-10,-21,-20,],0xFFFFFF,[971,972,973,980,981,982],[973,974,975,982,983,984],[972,973,974,981,982,983]],
[[-10,-21,-20],[-5,-21,-40],[-10,-31,-20,],0xFFFFFF,[972,973,974,981,982,983],[973,974,975,982,983,984],[974,975,976,983,984,985]],
[[-5,-21,-40],[-5,-31,-40],[-10,-31,-20,],0xFFFFFF,[973,974,975,982,983,984],[975,976,984,985,988,999],[974,975,976,983,984,985]],
[[-10,-31,-20],[-5,-31,-40],[-10,-41,-20,],0xFFFFFF,[974,975,976,983,984,985],[975,976,984,985,988,999],[976,985,988,989,999,1000]],
[[-7,9,-19],[-1,9,-39],[-8,-1,-20,],0xFFFFFF,[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936],[968,969,977,978,986,987],[968,969,970,977,978,979]],
[[-1,9,-39],[-3,-1,-39],[-8,-1,-20,],0xFFFFFF,[968,969,977,978,986,987],[969,970,971,978,979,980],[968,969,970,977,978,979]],
[[-8,-1,-20],[-3,-1,-39],[-9,-11,-20,],0xFFFFFF,[968,969,970,977,978,979],[969,970,971,978,979,980],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-3,-1,-39],[-4,-11,-40],[-9,-11,-20,],0xFFFFFF,[969,970,971,978,979,980],[971,972,973,980,981,982],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-9,-11,-20],[-4,-11,-40],[-10,-21,-20,],0xFFFFFF,[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940],[971,972,973,980,981,982],[972,973,974,981,982,983]],
[[-4,-11,-40],[-5,-21,-40],[-10,-21,-20,],0xFFFFFF,[971,972,973,980,981,982],[973,974,975,982,983,984],[972,973,974,981,982,983]],
[[-10,-21,-20],[-5,-21,-40],[-10,-31,-20,],0xFFFFFF,[972,973,974,981,982,983],[973,974,975,982,983,984],[974,975,976,983,984,985]],
[[-5,-21,-40],[-5,-31,-40],[-10,-31,-20,],0xFFFFFF,[973,974,975,982,983,984],[975,976,984,985,988,999],[974,975,976,983,984,985]],
[[-10,-31,-20],[-5,-31,-40],[-10,-41,-20,],0xFFFFFF,[974,975,976,983,984,985],[975,976,984,985,988,999],[976,985,988,989,999,1000]],
[[0,19,-38],[-1,9,-39],[-7,9,-19,],0xFFFFFF,[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[968,969,977,978,986,987],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[0,19,-38],[-1,9,-39],[-7,9,-19,],0xFFFFFF,[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[968,969,977,978,986,987],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[-5,-31,-40],[-5,-41,-40],[-10,-41,-20,],0xFFFFFF,[975,976,984,985,988,999],[988,989,990,999,1000,1001],[976,985,988,989,999,1000]],
[[-10,-41,-20],[-5,-41,-40],[-10,-51,-20,],0xFFFFFF,[976,985,988,989,999,1000],[988,989,990,999,1000,1001],[989,990,991,1000,1001,1002]],
[[-5,-41,-40],[-4,-51,-40],[-10,-51,-20,],0xFFFFFF,[988,989,990,999,1000,1001],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[989,990,991,1000,1001,1002]],
[[-10,-51,-20],[-4,-51,-40],[-8,-61,-20,],0xFFFFFF,[989,990,991,1000,1001,1002],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[991,992,993,1002,1003,1004]],
[[-4,-51,-40],[-3,-61,-39],[-8,-61,-20,],0xFFFFFF,[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[992,993,994,1003,1004,1005],[991,992,993,1002,1003,1004]],
[[-8,-61,-20],[-3,-61,-39],[-7,-71,-19,],0xFFFFFF,[991,992,993,1002,1003,1004],[992,993,994,1003,1004,1005],[993,994,995,1004,1005,1006]],
[[-3,-61,-39],[-2,-71,-39],[-7,-71,-19,],0xFFFFFF,[992,993,994,1003,1004,1005],[994,995,996,1005,1006,1007],[993,994,995,1004,1005,1006]],
[[-7,-71,-19],[-2,-71,-39],[-4,-81,-19,],0xFFFFFF,[993,994,995,1004,1005,1006],[994,995,996,1005,1006,1007],[995,996,997,1006,1007,1008]],
[[-2,-71,-39],[0,-81,-38],[-4,-81,-19,],0xFFFFFF,[994,995,996,1005,1006,1007],[996,997,998,1007,1008,1009],[995,996,997,1006,1007,1008]],
[[-4,-81,-19],[0,-81,-38],[-1,-91,-18,],0xFFFFFF,[995,996,997,1006,1007,1008],[996,997,998,1007,1008,1009],[997,998,1008,1009]],
[[0,-81,-38],[3,-91,-37],[-1,-91,-18,],0xFFFFFF,[996,997,998,1007,1008,1009],[998,1009],[997,998,1008,1009]],
[[-5,-31,-40],[-5,-41,-40],[-10,-41,-20,],0xFFFFFF,[975,976,984,985,988,999],[988,989,990,999,1000,1001],[976,985,988,989,999,1000]],
[[-10,-41,-20],[-5,-41,-40],[-10,-51,-20,],0xFFFFFF,[976,985,988,989,999,1000],[988,989,990,999,1000,1001],[989,990,991,1000,1001,1002]],
[[-5,-41,-40],[-4,-51,-40],[-10,-51,-20,],0xFFFFFF,[988,989,990,999,1000,1001],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[989,990,991,1000,1001,1002]],
[[-10,-51,-20],[-4,-51,-40],[-8,-61,-20,],0xFFFFFF,[989,990,991,1000,1001,1002],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[991,992,993,1002,1003,1004]],
[[-4,-51,-40],[-3,-61,-39],[-8,-61,-20,],0xFFFFFF,[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[992,993,994,1003,1004,1005],[991,992,993,1002,1003,1004]],
[[-8,-61,-20],[-3,-61,-39],[-7,-71,-19,],0xFFFFFF,[991,992,993,1002,1003,1004],[992,993,994,1003,1004,1005],[993,994,995,1004,1005,1006]],
[[-3,-61,-39],[-2,-71,-39],[-7,-71,-19,],0xFFFFFF,[992,993,994,1003,1004,1005],[994,995,996,1005,1006,1007],[993,994,995,1004,1005,1006]],
[[-7,-71,-19],[-2,-71,-39],[-4,-81,-19,],0xFFFFFF,[993,994,995,1004,1005,1006],[994,995,996,1005,1006,1007],[995,996,997,1006,1007,1008]],
[[-2,-71,-39],[0,-81,-38],[-4,-81,-19,],0xFFFFFF,[994,995,996,1005,1006,1007],[996,997,998,1007,1008,1009],[995,996,997,1006,1007,1008]],
[[-4,-81,-19],[0,-81,-38],[-1,-91,-18,],0xFFFFFF,[995,996,997,1006,1007,1008],[996,997,998,1007,1008,1009],[997,998,1008,1009]],
[[0,-81,-38],[3,-91,-37],[-1,-91,-18,],0xFFFFFF,[996,997,998,1007,1008,1009],[998,1009],[997,998,1008,1009]],
[[31,60,1],[32,60,-12],[13,55,0,],0xFFFFFF,[1010,1013],[1010,1011,1013,1014],[1010,1011,1012,1013,1014,1015]],
[[32,60,-12],[14,55,-16],[13,55,0,],0xFFFFFF,[1010,1011,1013,1014],[1011,1012,1014,1015,1016,1022],[1010,1011,1012,1013,1014,1015]],
[[13,55,0],[14,55,-16],[4,49,0,],0xFFFFFF,[1010,1011,1012,1013,1014,1015],[1011,1012,1014,1015,1016,1022],[1012,1015,1016,1017,1022,1023]],
[[31,60,1],[32,60,-12],[13,55,0,],0xFFFFFF,[1010,1013],[1010,1011,1013,1014],[1010,1011,1012,1013,1014,1015]],
[[32,60,-12],[14,55,-16],[13,55,0,],0xFFFFFF,[1010,1011,1013,1014],[1011,1012,1014,1015,1016,1022],[1010,1011,1012,1013,1014,1015]],
[[13,55,0],[14,55,-16],[4,49,0,],0xFFFFFF,[1010,1011,1012,1013,1014,1015],[1011,1012,1014,1015,1016,1022],[1012,1015,1016,1017,1022,1023]],
[[14,55,-16],[6,49,-17],[4,49,0,],0xFFFFFF,[1011,1012,1014,1015,1016,1022],[1016,1017,1018,1022,1023,1024],[1012,1015,1016,1017,1022,1023]],
[[4,49,0],[6,49,-17],[-1,39,0,],0xFFFFFF,[1012,1015,1016,1017,1022,1023],[1016,1017,1018,1022,1023,1024],[1017,1018,1019,1023,1024,1025]],
[[6,49,-17],[0,39,-18],[-1,39,0,],0xFFFFFF,[1016,1017,1018,1022,1023,1024],[1018,1019,1020,1024,1025,1026],[1017,1018,1019,1023,1024,1025]],
[[-1,39,0],[0,39,-18],[-4,29,0,],0xFFFFFF,[1017,1018,1019,1023,1024,1025],[1018,1019,1020,1024,1025,1026],[1019,1020,1021,1025,1026,1027]],
[[0,39,-18],[-3,29,-19],[-4,29,0,],0xFFFFFF,[1018,1019,1020,1024,1025,1026],[1020,1021,1026,1027,1028,1030],[1019,1020,1021,1025,1026,1027]],
[[-4,29,0],[-3,29,-19],[-7,19,0,],0xFFFFFF,[1019,1020,1021,1025,1026,1027],[1020,1021,1026,1027,1028,1030],[1021,1027,1028,1029,1030,1031]],
[[14,55,-16],[6,49,-17],[4,49,0,],0xFFFFFF,[1011,1012,1014,1015,1016,1022],[1016,1017,1018,1022,1023,1024],[1012,1015,1016,1017,1022,1023]],
[[4,49,0],[6,49,-17],[-1,39,0,],0xFFFFFF,[1012,1015,1016,1017,1022,1023],[1016,1017,1018,1022,1023,1024],[1017,1018,1019,1023,1024,1025]],
[[6,49,-17],[0,39,-18],[-1,39,0,],0xFFFFFF,[1016,1017,1018,1022,1023,1024],[1018,1019,1020,1024,1025,1026],[1017,1018,1019,1023,1024,1025]],
[[-1,39,0],[0,39,-18],[-4,29,0,],0xFFFFFF,[1017,1018,1019,1023,1024,1025],[1018,1019,1020,1024,1025,1026],[1019,1020,1021,1025,1026,1027]],
[[0,39,-18],[-3,29,-19],[-4,29,0,],0xFFFFFF,[1018,1019,1020,1024,1025,1026],[1020,1021,1026,1027,1028,1030],[1019,1020,1021,1025,1026,1027]],
[[-4,29,0],[-3,29,-19],[-7,19,0,],0xFFFFFF,[1019,1020,1021,1025,1026,1027],[1020,1021,1026,1027,1028,1030],[1021,1027,1028,1029,1030,1031]],
[[-3,29,-19],[-5,19,-19],[-7,19,0,],0xFFFFFF,[1020,1021,1026,1027,1028,1030],[1028,1029,1030,1031,1050,1051],[1021,1027,1028,1029,1030,1031]],
[[-7,19,0],[-5,19,-19],[-8,9,0,],0xFFFFFF,[1021,1027,1028,1029,1030,1031],[1028,1029,1030,1031,1050,1051],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-3,29,-19],[-5,19,-19],[-7,19,0,],0xFFFFFF,[1020,1021,1026,1027,1028,1030],[1028,1029,1030,1031,1050,1051],[1021,1027,1028,1029,1030,1031]],
[[-7,19,0],[-5,19,-19],[-8,9,0,],0xFFFFFF,[1021,1027,1028,1029,1030,1031],[1028,1029,1030,1031,1050,1051],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-8,9,0],[-7,9,-19],[-10,-1,0,],0xFFFFFF,[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000],[1032,1033,1041,1042,1050,1051],[1032,1033,1034,1041,1042,1043]],
[[-7,9,-19],[-8,-1,-20],[-10,-1,0,],0xFFFFFF,[1032,1033,1041,1042,1050,1051],[1033,1034,1035,1042,1043,1044],[1032,1033,1034,1041,1042,1043]],
[[-10,-1,0],[-8,-1,-20],[-11,-11,0,],0xFFFFFF,[1032,1033,1034,1041,1042,1043],[1033,1034,1035,1042,1043,1044],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-8,-1,-20],[-9,-11,-20],[-11,-11,0,],0xFFFFFF,[1033,1034,1035,1042,1043,1044],[1035,1036,1037,1044,1045,1046],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-11,-11,0],[-9,-11,-20],[-12,-21,0,],0xFFFFFF,[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004],[1035,1036,1037,1044,1045,1046],[1036,1037,1038,1045,1046,1047]],
[[-9,-11,-20],[-10,-21,-20],[-12,-21,0,],0xFFFFFF,[1035,1036,1037,1044,1045,1046],[1037,1038,1039,1046,1047,1048],[1036,1037,1038,1045,1046,1047]],
[[-12,-21,0],[-10,-21,-20],[-12,-31,0,],0xFFFFFF,[1036,1037,1038,1045,1046,1047],[1037,1038,1039,1046,1047,1048],[1038,1039,1040,1047,1048,1049]],
[[-10,-21,-20],[-10,-31,-20],[-12,-31,0,],0xFFFFFF,[1037,1038,1039,1046,1047,1048],[1039,1040,1048,1049,1052,1063],[1038,1039,1040,1047,1048,1049]],
[[-12,-31,0],[-10,-31,-20],[-12,-41,0,],0xFFFFFF,[1038,1039,1040,1047,1048,1049],[1039,1040,1048,1049,1052,1063],[1040,1049,1052,1053,1063,1064]],
[[-8,9,0],[-7,9,-19],[-10,-1,0,],0xFFFFFF,[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000],[1032,1033,1041,1042,1050,1051],[1032,1033,1034,1041,1042,1043]],
[[-7,9,-19],[-8,-1,-20],[-10,-1,0,],0xFFFFFF,[1032,1033,1041,1042,1050,1051],[1033,1034,1035,1042,1043,1044],[1032,1033,1034,1041,1042,1043]],
[[-10,-1,0],[-8,-1,-20],[-11,-11,0,],0xFFFFFF,[1032,1033,1034,1041,1042,1043],[1033,1034,1035,1042,1043,1044],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-8,-1,-20],[-9,-11,-20],[-11,-11,0,],0xFFFFFF,[1033,1034,1035,1042,1043,1044],[1035,1036,1037,1044,1045,1046],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-11,-11,0],[-9,-11,-20],[-12,-21,0,],0xFFFFFF,[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004],[1035,1036,1037,1044,1045,1046],[1036,1037,1038,1045,1046,1047]],
[[-9,-11,-20],[-10,-21,-20],[-12,-21,0,],0xFFFFFF,[1035,1036,1037,1044,1045,1046],[1037,1038,1039,1046,1047,1048],[1036,1037,1038,1045,1046,1047]],
[[-12,-21,0],[-10,-21,-20],[-12,-31,0,],0xFFFFFF,[1036,1037,1038,1045,1046,1047],[1037,1038,1039,1046,1047,1048],[1038,1039,1040,1047,1048,1049]],
[[-10,-21,-20],[-10,-31,-20],[-12,-31,0,],0xFFFFFF,[1037,1038,1039,1046,1047,1048],[1039,1040,1048,1049,1052,1063],[1038,1039,1040,1047,1048,1049]],
[[-12,-31,0],[-10,-31,-20],[-12,-41,0,],0xFFFFFF,[1038,1039,1040,1047,1048,1049],[1039,1040,1048,1049,1052,1063],[1040,1049,1052,1053,1063,1064]],
[[-5,19,-19],[-7,9,-19],[-8,9,0,],0xFFFFFF,[1028,1029,1030,1031,1050,1051],[1032,1033,1041,1042,1050,1051],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-5,19,-19],[-7,9,-19],[-8,9,0,],0xFFFFFF,[1028,1029,1030,1031,1050,1051],[1032,1033,1041,1042,1050,1051],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-10,-31,-20],[-10,-41,-20],[-12,-41,0,],0xFFFFFF,[1039,1040,1048,1049,1052,1063],[1052,1053,1054,1063,1064,1065],[1040,1049,1052,1053,1063,1064]],
[[-12,-41,0],[-10,-41,-20],[-11,-51,0,],0xFFFFFF,[1040,1049,1052,1053,1063,1064],[1052,1053,1054,1063,1064,1065],[1053,1054,1055,1064,1065,1066]],
[[-10,-41,-20],[-10,-51,-20],[-11,-51,0,],0xFFFFFF,[1052,1053,1054,1063,1064,1065],[1054,1055,1056,1065,1066,1067],[1053,1054,1055,1064,1065,1066]],
[[-11,-51,0],[-10,-51,-20],[-10,-61,0,],0xFFFFFF,[1053,1054,1055,1064,1065,1066],[1054,1055,1056,1065,1066,1067],[1055,1056,1057,1066,1067,1068]],
[[-10,-51,-20],[-8,-61,-20],[-10,-61,0,],0xFFFFFF,[1054,1055,1056,1065,1066,1067],[1056,1057,1058,1067,1068,1069],[1055,1056,1057,1066,1067,1068]],
[[-10,-61,0],[-8,-61,-20],[-8,-71,0,],0xFFFFFF,[1055,1056,1057,1066,1067,1068],[1056,1057,1058,1067,1068,1069],[1057,1058,1059,1068,1069,1070]],
[[-8,-61,-20],[-7,-71,-19],[-8,-71,0,],0xFFFFFF,[1056,1057,1058,1067,1068,1069],[1058,1059,1060,1069,1070,1071],[1057,1058,1059,1068,1069,1070]],
[[-8,-71,0],[-7,-71,-19],[-6,-81,0,],0xFFFFFF,[1057,1058,1059,1068,1069,1070],[1058,1059,1060,1069,1070,1071],[1059,1060,1061,1070,1071,1072,5361,5362]],
[[-7,-71,-19],[-4,-81,-19],[-6,-81,0,],0xFFFFFF,[1058,1059,1060,1069,1070,1071],[1060,1061,1062,1071,1072,1073],[1059,1060,1061,1070,1071,1072,5361,5362]],
[[-6,-81,0],[-4,-81,-19],[-3,-91,0,],0xFFFFFF,[1059,1060,1061,1070,1071,1072,5361,5362],[1060,1061,1062,1071,1072,1073],[1061,1062,1072,1073]],
[[-4,-81,-19],[-1,-91,-18],[-3,-91,0,],0xFFFFFF,[1060,1061,1062,1071,1072,1073],[1062,1073],[1061,1062,1072,1073]],
[[-10,-31,-20],[-10,-41,-20],[-12,-41,0,],0xFFFFFF,[1039,1040,1048,1049,1052,1063],[1052,1053,1054,1063,1064,1065],[1040,1049,1052,1053,1063,1064]],
[[-12,-41,0],[-10,-41,-20],[-11,-51,0,],0xFFFFFF,[1040,1049,1052,1053,1063,1064],[1052,1053,1054,1063,1064,1065],[1053,1054,1055,1064,1065,1066]],
[[-10,-41,-20],[-10,-51,-20],[-11,-51,0,],0xFFFFFF,[1052,1053,1054,1063,1064,1065],[1054,1055,1056,1065,1066,1067],[1053,1054,1055,1064,1065,1066]],
[[-11,-51,0],[-10,-51,-20],[-10,-61,0,],0xFFFFFF,[1053,1054,1055,1064,1065,1066],[1054,1055,1056,1065,1066,1067],[1055,1056,1057,1066,1067,1068]],
[[-10,-51,-20],[-8,-61,-20],[-10,-61,0,],0xFFFFFF,[1054,1055,1056,1065,1066,1067],[1056,1057,1058,1067,1068,1069],[1055,1056,1057,1066,1067,1068]],
[[-10,-61,0],[-8,-61,-20],[-8,-71,0,],0xFFFFFF,[1055,1056,1057,1066,1067,1068],[1056,1057,1058,1067,1068,1069],[1057,1058,1059,1068,1069,1070]],
[[-8,-61,-20],[-7,-71,-19],[-8,-71,0,],0xFFFFFF,[1056,1057,1058,1067,1068,1069],[1058,1059,1060,1069,1070,1071],[1057,1058,1059,1068,1069,1070]],
[[-8,-71,0],[-7,-71,-19],[-6,-81,0,],0xFFFFFF,[1057,1058,1059,1068,1069,1070],[1058,1059,1060,1069,1070,1071],[1059,1060,1061,1070,1071,1072,5361,5362]],
[[-7,-71,-19],[-4,-81,-19],[-6,-81,0,],0xFFFFFF,[1058,1059,1060,1069,1070,1071],[1060,1061,1062,1071,1072,1073],[1059,1060,1061,1070,1071,1072,5361,5362]],
[[-6,-81,0],[-4,-81,-19],[-3,-91,0,],0xFFFFFF,[1059,1060,1061,1070,1071,1072,5361,5362],[1060,1061,1062,1071,1072,1073],[1061,1062,1072,1073]],
[[-4,-81,-19],[-1,-91,-18],[-3,-91,0,],0xFFFFFF,[1060,1061,1062,1071,1072,1073],[1062,1073],[1061,1062,1072,1073]],
[[32,60,14],[31,60,0],[14,55,16,],0xFFFFFF,[1074,1077],[1074,1075,1077,1078],[1074,1075,1076,1077,1078,1079]],
[[31,60,0],[13,55,0],[14,55,16,],0xFFFFFF,[1074,1075,1077,1078],[1075,1076,1078,1079,1080,1086],[1074,1075,1076,1077,1078,1079]],
[[14,55,16],[13,55,0],[6,49,17,],0xFFFFFF,[1074,1075,1076,1077,1078,1079],[1075,1076,1078,1079,1080,1086],[1076,1079,1080,1081,1086,1087]],
[[32,60,14],[31,60,0],[14,55,16,],0xFFFFFF,[1074,1077],[1074,1075,1077,1078],[1074,1075,1076,1077,1078,1079]],
[[31,60,0],[13,55,0],[14,55,16,],0xFFFFFF,[1074,1075,1077,1078],[1075,1076,1078,1079,1080,1086],[1074,1075,1076,1077,1078,1079]],
[[14,55,16],[13,55,0],[6,49,17,],0xFFFFFF,[1074,1075,1076,1077,1078,1079],[1075,1076,1078,1079,1080,1086],[1076,1079,1080,1081,1086,1087]],
[[13,55,0],[4,49,0],[6,49,17,],0xFFFFFF,[1075,1076,1078,1079,1080,1086],[1080,1081,1082,1086,1087,1088],[1076,1079,1080,1081,1086,1087]],
[[6,49,17],[4,49,0],[0,39,18,],0xFFFFFF,[1076,1079,1080,1081,1086,1087],[1080,1081,1082,1086,1087,1088],[1081,1082,1083,1087,1088,1089]],
[[4,49,0],[-1,39,0],[0,39,18,],0xFFFFFF,[1080,1081,1082,1086,1087,1088],[1082,1083,1084,1088,1089,1090],[1081,1082,1083,1087,1088,1089]],
[[0,39,18],[-1,39,0],[-3,29,19,],0xFFFFFF,[1081,1082,1083,1087,1088,1089],[1082,1083,1084,1088,1089,1090],[1083,1084,1085,1089,1090,1091]],
[[-1,39,0],[-4,29,0],[-3,29,19,],0xFFFFFF,[1082,1083,1084,1088,1089,1090],[1084,1085,1090,1091,1092,1094],[1083,1084,1085,1089,1090,1091]],
[[-3,29,19],[-4,29,0],[-5,19,19,],0xFFFFFF,[1083,1084,1085,1089,1090,1091],[1084,1085,1090,1091,1092,1094],[1085,1091,1092,1093,1094,1095]],
[[13,55,0],[4,49,0],[6,49,17,],0xFFFFFF,[1075,1076,1078,1079,1080,1086],[1080,1081,1082,1086,1087,1088],[1076,1079,1080,1081,1086,1087]],
[[6,49,17],[4,49,0],[0,39,18,],0xFFFFFF,[1076,1079,1080,1081,1086,1087],[1080,1081,1082,1086,1087,1088],[1081,1082,1083,1087,1088,1089]],
[[4,49,0],[-1,39,0],[0,39,18,],0xFFFFFF,[1080,1081,1082,1086,1087,1088],[1082,1083,1084,1088,1089,1090],[1081,1082,1083,1087,1088,1089]],
[[0,39,18],[-1,39,0],[-3,29,19,],0xFFFFFF,[1081,1082,1083,1087,1088,1089],[1082,1083,1084,1088,1089,1090],[1083,1084,1085,1089,1090,1091]],
[[-1,39,0],[-4,29,0],[-3,29,19,],0xFFFFFF,[1082,1083,1084,1088,1089,1090],[1084,1085,1090,1091,1092,1094],[1083,1084,1085,1089,1090,1091]],
[[-3,29,19],[-4,29,0],[-5,19,19,],0xFFFFFF,[1083,1084,1085,1089,1090,1091],[1084,1085,1090,1091,1092,1094],[1085,1091,1092,1093,1094,1095]],
[[-4,29,0],[-7,19,0],[-5,19,19,],0xFFFFFF,[1084,1085,1090,1091,1092,1094],[1092,1093,1094,1095,1114,1115],[1085,1091,1092,1093,1094,1095]],
[[-5,19,19],[-7,19,0],[-7,9,19,],0xFFFFFF,[1085,1091,1092,1093,1094,1095],[1092,1093,1094,1095,1114,1115],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-4,29,0],[-7,19,0],[-5,19,19,],0xFFFFFF,[1084,1085,1090,1091,1092,1094],[1092,1093,1094,1095,1114,1115],[1085,1091,1092,1093,1094,1095]],
[[-5,19,19],[-7,19,0],[-7,9,19,],0xFFFFFF,[1085,1091,1092,1093,1094,1095],[1092,1093,1094,1095,1114,1115],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-7,9,19],[-8,9,0],[-8,-1,20,],0xFFFFFF,[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064],[1096,1097,1105,1106,1114,1115],[1096,1097,1098,1105,1106,1107]],
[[-8,9,0],[-10,-1,0],[-8,-1,20,],0xFFFFFF,[1096,1097,1105,1106,1114,1115],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[1096,1097,1098,1105,1106,1107]],
[[-8,-1,20],[-10,-1,0],[-9,-11,20,],0xFFFFFF,[1096,1097,1098,1105,1106,1107],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-10,-1,0],[-11,-11,0],[-9,-11,20,],0xFFFFFF,[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[1099,1100,1101,1108,1109,1110],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-9,-11,20],[-11,-11,0],[-10,-21,20,],0xFFFFFF,[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068],[1099,1100,1101,1108,1109,1110],[1100,1101,1102,1109,1110,1111]],
[[-11,-11,0],[-12,-21,0],[-10,-21,20,],0xFFFFFF,[1099,1100,1101,1108,1109,1110],[1101,1102,1103,1110,1111,1112],[1100,1101,1102,1109,1110,1111]],
[[-10,-21,20],[-12,-21,0],[-10,-31,20,],0xFFFFFF,[1100,1101,1102,1109,1110,1111],[1101,1102,1103,1110,1111,1112],[1102,1103,1104,1111,1112,1113]],
[[-12,-21,0],[-12,-31,0],[-10,-31,20,],0xFFFFFF,[1101,1102,1103,1110,1111,1112],[1103,1104,1112,1113,1116,1127],[1102,1103,1104,1111,1112,1113]],
[[-10,-31,20],[-12,-31,0],[-10,-41,20,],0xFFFFFF,[1102,1103,1104,1111,1112,1113],[1103,1104,1112,1113,1116,1127],[1104,1113,1116,1117,1127,1128]],
[[-7,9,19],[-8,9,0],[-8,-1,20,],0xFFFFFF,[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064],[1096,1097,1105,1106,1114,1115],[1096,1097,1098,1105,1106,1107]],
[[-8,9,0],[-10,-1,0],[-8,-1,20,],0xFFFFFF,[1096,1097,1105,1106,1114,1115],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[1096,1097,1098,1105,1106,1107]],
[[-8,-1,20],[-10,-1,0],[-9,-11,20,],0xFFFFFF,[1096,1097,1098,1105,1106,1107],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-10,-1,0],[-11,-11,0],[-9,-11,20,],0xFFFFFF,[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[1099,1100,1101,1108,1109,1110],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-9,-11,20],[-11,-11,0],[-10,-21,20,],0xFFFFFF,[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068],[1099,1100,1101,1108,1109,1110],[1100,1101,1102,1109,1110,1111]],
[[-11,-11,0],[-12,-21,0],[-10,-21,20,],0xFFFFFF,[1099,1100,1101,1108,1109,1110],[1101,1102,1103,1110,1111,1112],[1100,1101,1102,1109,1110,1111]],
[[-10,-21,20],[-12,-21,0],[-10,-31,20,],0xFFFFFF,[1100,1101,1102,1109,1110,1111],[1101,1102,1103,1110,1111,1112],[1102,1103,1104,1111,1112,1113]],
[[-12,-21,0],[-12,-31,0],[-10,-31,20,],0xFFFFFF,[1101,1102,1103,1110,1111,1112],[1103,1104,1112,1113,1116,1127],[1102,1103,1104,1111,1112,1113]],
[[-10,-31,20],[-12,-31,0],[-10,-41,20,],0xFFFFFF,[1102,1103,1104,1111,1112,1113],[1103,1104,1112,1113,1116,1127],[1104,1113,1116,1117,1127,1128]],
[[-7,19,0],[-8,9,0],[-7,9,19,],0xFFFFFF,[1092,1093,1094,1095,1114,1115],[1096,1097,1105,1106,1114,1115],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-7,19,0],[-8,9,0],[-7,9,19,],0xFFFFFF,[1092,1093,1094,1095,1114,1115],[1096,1097,1105,1106,1114,1115],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-12,-31,0],[-12,-41,0],[-10,-41,20,],0xFFFFFF,[1103,1104,1112,1113,1116,1127],[1116,1117,1118,1127,1128,1129],[1104,1113,1116,1117,1127,1128]],
[[-10,-41,20],[-12,-41,0],[-10,-51,20,],0xFFFFFF,[1104,1113,1116,1117,1127,1128],[1116,1117,1118,1127,1128,1129],[1117,1118,1119,1128,1129,1130]],
[[-12,-41,0],[-11,-51,0],[-10,-51,20,],0xFFFFFF,[1116,1117,1118,1127,1128,1129],[1118,1119,1120,1129,1130,1131],[1117,1118,1119,1128,1129,1130]],
[[-10,-51,20],[-11,-51,0],[-8,-61,20,],0xFFFFFF,[1117,1118,1119,1128,1129,1130],[1118,1119,1120,1129,1130,1131],[1119,1120,1121,1130,1131,1132]],
[[-11,-51,0],[-10,-61,0],[-8,-61,20,],0xFFFFFF,[1118,1119,1120,1129,1130,1131],[1120,1121,1122,1131,1132,1133],[1119,1120,1121,1130,1131,1132]],
[[-8,-61,20],[-10,-61,0],[-7,-71,19,],0xFFFFFF,[1119,1120,1121,1130,1131,1132],[1120,1121,1122,1131,1132,1133],[1121,1122,1123,1132,1133,1134]],
[[-10,-61,0],[-8,-71,0],[-7,-71,19,],0xFFFFFF,[1120,1121,1122,1131,1132,1133],[1122,1123,1124,1133,1134,1135],[1121,1122,1123,1132,1133,1134]],
[[-7,-71,19],[-8,-71,0],[-4,-81,19,],0xFFFFFF,[1121,1122,1123,1132,1133,1134],[1122,1123,1124,1133,1134,1135],[1123,1124,1125,1134,1135,1136,5361]],
[[-8,-71,0],[-6,-81,0],[-4,-81,19,],0xFFFFFF,[1122,1123,1124,1133,1134,1135],[1124,1125,1126,1135,1136,1137],[1123,1124,1125,1134,1135,1136,5361]],
[[-4,-81,19],[-6,-81,0],[-1,-91,18,],0xFFFFFF,[1123,1124,1125,1134,1135,1136,5361],[1124,1125,1126,1135,1136,1137],[1125,1126,1136,1137]],
[[-6,-81,0],[-3,-91,0],[-1,-91,18,],0xFFFFFF,[1124,1125,1126,1135,1136,1137],[1126,1137],[1125,1126,1136,1137]],
[[-12,-31,0],[-12,-41,0],[-10,-41,20,],0xFFFFFF,[1103,1104,1112,1113,1116,1127],[1116,1117,1118,1127,1128,1129],[1104,1113,1116,1117,1127,1128]],
[[-10,-41,20],[-12,-41,0],[-10,-51,20,],0xFFFFFF,[1104,1113,1116,1117,1127,1128],[1116,1117,1118,1127,1128,1129],[1117,1118,1119,1128,1129,1130]],
[[-12,-41,0],[-11,-51,0],[-10,-51,20,],0xFFFFFF,[1116,1117,1118,1127,1128,1129],[1118,1119,1120,1129,1130,1131],[1117,1118,1119,1128,1129,1130]],
[[-10,-51,20],[-11,-51,0],[-8,-61,20,],0xFFFFFF,[1117,1118,1119,1128,1129,1130],[1118,1119,1120,1129,1130,1131],[1119,1120,1121,1130,1131,1132]],
[[-11,-51,0],[-10,-61,0],[-8,-61,20,],0xFFFFFF,[1118,1119,1120,1129,1130,1131],[1120,1121,1122,1131,1132,1133],[1119,1120,1121,1130,1131,1132]],
[[-8,-61,20],[-10,-61,0],[-7,-71,19,],0xFFFFFF,[1119,1120,1121,1130,1131,1132],[1120,1121,1122,1131,1132,1133],[1121,1122,1123,1132,1133,1134]],
[[-10,-61,0],[-8,-71,0],[-7,-71,19,],0xFFFFFF,[1120,1121,1122,1131,1132,1133],[1122,1123,1124,1133,1134,1135],[1121,1122,1123,1132,1133,1134]],
[[-7,-71,19],[-8,-71,0],[-4,-81,19,],0xFFFFFF,[1121,1122,1123,1132,1133,1134],[1122,1123,1124,1133,1134,1135],[1123,1124,1125,1134,1135,1136,5361]],
[[-8,-71,0],[-6,-81,0],[-4,-81,19,],0xFFFFFF,[1122,1123,1124,1133,1134,1135],[1124,1125,1126,1135,1136,1137],[1123,1124,1125,1134,1135,1136,5361]],
[[-4,-81,19],[-6,-81,0],[-1,-91,18,],0xFFFFFF,[1123,1124,1125,1134,1135,1136,5361],[1124,1125,1126,1135,1136,1137],[1125,1126,1136,1137]],
[[-6,-81,0],[-3,-91,0],[-1,-91,18,],0xFFFFFF,[1124,1125,1126,1135,1136,1137],[1126,1137],[1125,1126,1136,1137]],
[[36,60,26],[32,60,12],[18,55,31,],0xFFFFFF,[1138,1141],[1138,1139,1141,1142],[1138,1139,1140,1141,1142,1143]],
[[32,60,12],[14,55,16],[18,55,31,],0xFFFFFF,[1138,1139,1141,1142],[1139,1140,1142,1143,1144,1150],[1138,1139,1140,1141,1142,1143]],
[[18,55,31],[14,55,16],[10,49,34,],0xFFFFFF,[1138,1139,1140,1141,1142,1143],[1139,1140,1142,1143,1144,1150],[1140,1143,1144,1145,1150,1151]],
[[36,60,26],[32,60,12],[18,55,31,],0xFFFFFF,[1138,1141],[1138,1139,1141,1142],[1138,1139,1140,1141,1142,1143]],
[[32,60,12],[14,55,16],[18,55,31,],0xFFFFFF,[1138,1139,1141,1142],[1139,1140,1142,1143,1144,1150],[1138,1139,1140,1141,1142,1143]],
[[18,55,31],[14,55,16],[10,49,34,],0xFFFFFF,[1138,1139,1140,1141,1142,1143],[1139,1140,1142,1143,1144,1150],[1140,1143,1144,1145,1150,1151]],
[[14,55,16],[6,49,17],[10,49,34,],0xFFFFFF,[1139,1140,1142,1143,1144,1150],[1144,1145,1146,1150,1151,1152],[1140,1143,1144,1145,1150,1151]],
[[10,49,34],[6,49,17],[4,39,36,],0xFFFFFF,[1140,1143,1144,1145,1150,1151],[1144,1145,1146,1150,1151,1152],[1145,1146,1147,1151,1152,1153]],
[[6,49,17],[0,39,18],[4,39,36,],0xFFFFFF,[1144,1145,1146,1150,1151,1152],[1146,1147,1148,1152,1153,1154],[1145,1146,1147,1151,1152,1153]],
[[4,39,36],[0,39,18],[1,29,37,],0xFFFFFF,[1145,1146,1147,1151,1152,1153],[1146,1147,1148,1152,1153,1154],[1147,1148,1149,1153,1154,1155]],
[[0,39,18],[-3,29,19],[1,29,37,],0xFFFFFF,[1146,1147,1148,1152,1153,1154],[1148,1149,1154,1155,1156,1158],[1147,1148,1149,1153,1154,1155]],
[[1,29,37],[-3,29,19],[0,19,38,],0xFFFFFF,[1147,1148,1149,1153,1154,1155],[1148,1149,1154,1155,1156,1158],[1149,1155,1156,1157,1158,1159]],
[[14,55,16],[6,49,17],[10,49,34,],0xFFFFFF,[1139,1140,1142,1143,1144,1150],[1144,1145,1146,1150,1151,1152],[1140,1143,1144,1145,1150,1151]],
[[10,49,34],[6,49,17],[4,39,36,],0xFFFFFF,[1140,1143,1144,1145,1150,1151],[1144,1145,1146,1150,1151,1152],[1145,1146,1147,1151,1152,1153]],
[[6,49,17],[0,39,18],[4,39,36,],0xFFFFFF,[1144,1145,1146,1150,1151,1152],[1146,1147,1148,1152,1153,1154],[1145,1146,1147,1151,1152,1153]],
[[4,39,36],[0,39,18],[1,29,37,],0xFFFFFF,[1145,1146,1147,1151,1152,1153],[1146,1147,1148,1152,1153,1154],[1147,1148,1149,1153,1154,1155]],
[[0,39,18],[-3,29,19],[1,29,37,],0xFFFFFF,[1146,1147,1148,1152,1153,1154],[1148,1149,1154,1155,1156,1158],[1147,1148,1149,1153,1154,1155]],
[[1,29,37],[-3,29,19],[0,19,38,],0xFFFFFF,[1147,1148,1149,1153,1154,1155],[1148,1149,1154,1155,1156,1158],[1149,1155,1156,1157,1158,1159]],
[[-3,29,19],[-5,19,19],[0,19,38,],0xFFFFFF,[1148,1149,1154,1155,1156,1158],[1156,1157,1158,1159,1178,1179],[1149,1155,1156,1157,1158,1159]],
[[0,19,38],[-5,19,19],[-1,9,39,],0xFFFFFF,[1149,1155,1156,1157,1158,1159],[1156,1157,1158,1159,1178,1179],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-3,29,19],[-5,19,19],[0,19,38,],0xFFFFFF,[1148,1149,1154,1155,1156,1158],[1156,1157,1158,1159,1178,1179],[1149,1155,1156,1157,1158,1159]],
[[0,19,38],[-5,19,19],[-1,9,39,],0xFFFFFF,[1149,1155,1156,1157,1158,1159],[1156,1157,1158,1159,1178,1179],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-1,9,39],[-7,9,19],[-3,-1,39,],0xFFFFFF,[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128],[1160,1161,1169,1170,1178,1179],[1160,1161,1162,1169,1170,1171]],
[[-7,9,19],[-8,-1,20],[-3,-1,39,],0xFFFFFF,[1160,1161,1169,1170,1178,1179],[1161,1162,1163,1170,1171,1172],[1160,1161,1162,1169,1170,1171]],
[[-3,-1,39],[-8,-1,20],[-4,-11,40,],0xFFFFFF,[1160,1161,1162,1169,1170,1171],[1161,1162,1163,1170,1171,1172],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-8,-1,20],[-9,-11,20],[-4,-11,40,],0xFFFFFF,[1161,1162,1163,1170,1171,1172],[1163,1164,1165,1172,1173,1174],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-4,-11,40],[-9,-11,20],[-5,-21,40,],0xFFFFFF,[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132],[1163,1164,1165,1172,1173,1174],[1164,1165,1166,1173,1174,1175]],
[[-9,-11,20],[-10,-21,20],[-5,-21,40,],0xFFFFFF,[1163,1164,1165,1172,1173,1174],[1165,1166,1167,1174,1175,1176],[1164,1165,1166,1173,1174,1175]],
[[-5,-21,40],[-10,-21,20],[-5,-31,40,],0xFFFFFF,[1164,1165,1166,1173,1174,1175],[1165,1166,1167,1174,1175,1176],[1166,1167,1168,1175,1176,1177]],
[[-10,-21,20],[-10,-31,20],[-5,-31,40,],0xFFFFFF,[1165,1166,1167,1174,1175,1176],[1167,1168,1176,1177,1180,1191],[1166,1167,1168,1175,1176,1177]],
[[-5,-31,40],[-10,-31,20],[-5,-41,40,],0xFFFFFF,[1166,1167,1168,1175,1176,1177],[1167,1168,1176,1177,1180,1191],[1168,1177,1180,1181,1191,1192]],
[[-1,9,39],[-7,9,19],[-3,-1,39,],0xFFFFFF,[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128],[1160,1161,1169,1170,1178,1179],[1160,1161,1162,1169,1170,1171]],
[[-7,9,19],[-8,-1,20],[-3,-1,39,],0xFFFFFF,[1160,1161,1169,1170,1178,1179],[1161,1162,1163,1170,1171,1172],[1160,1161,1162,1169,1170,1171]],
[[-3,-1,39],[-8,-1,20],[-4,-11,40,],0xFFFFFF,[1160,1161,1162,1169,1170,1171],[1161,1162,1163,1170,1171,1172],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-8,-1,20],[-9,-11,20],[-4,-11,40,],0xFFFFFF,[1161,1162,1163,1170,1171,1172],[1163,1164,1165,1172,1173,1174],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-4,-11,40],[-9,-11,20],[-5,-21,40,],0xFFFFFF,[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132],[1163,1164,1165,1172,1173,1174],[1164,1165,1166,1173,1174,1175]],
[[-9,-11,20],[-10,-21,20],[-5,-21,40,],0xFFFFFF,[1163,1164,1165,1172,1173,1174],[1165,1166,1167,1174,1175,1176],[1164,1165,1166,1173,1174,1175]],
[[-5,-21,40],[-10,-21,20],[-5,-31,40,],0xFFFFFF,[1164,1165,1166,1173,1174,1175],[1165,1166,1167,1174,1175,1176],[1166,1167,1168,1175,1176,1177]],
[[-10,-21,20],[-10,-31,20],[-5,-31,40,],0xFFFFFF,[1165,1166,1167,1174,1175,1176],[1167,1168,1176,1177,1180,1191],[1166,1167,1168,1175,1176,1177]],
[[-5,-31,40],[-10,-31,20],[-5,-41,40,],0xFFFFFF,[1166,1167,1168,1175,1176,1177],[1167,1168,1176,1177,1180,1191],[1168,1177,1180,1181,1191,1192]],
[[-5,19,19],[-7,9,19],[-1,9,39,],0xFFFFFF,[1156,1157,1158,1159,1178,1179],[1160,1161,1169,1170,1178,1179],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-5,19,19],[-7,9,19],[-1,9,39,],0xFFFFFF,[1156,1157,1158,1159,1178,1179],[1160,1161,1169,1170,1178,1179],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-10,-31,20],[-10,-41,20],[-5,-41,40,],0xFFFFFF,[1167,1168,1176,1177,1180,1191],[1180,1181,1182,1191,1192,1193],[1168,1177,1180,1181,1191,1192]],
[[-5,-41,40],[-10,-41,20],[-4,-51,40,],0xFFFFFF,[1168,1177,1180,1181,1191,1192],[1180,1181,1182,1191,1192,1193],[1181,1182,1183,1192,1193,1194]],
[[-10,-41,20],[-10,-51,20],[-4,-51,40,],0xFFFFFF,[1180,1181,1182,1191,1192,1193],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[1181,1182,1183,1192,1193,1194]],
[[-4,-51,40],[-10,-51,20],[-3,-61,39,],0xFFFFFF,[1181,1182,1183,1192,1193,1194],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[1183,1184,1185,1194,1195,1196]],
[[-10,-51,20],[-8,-61,20],[-3,-61,39,],0xFFFFFF,[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[1184,1185,1186,1195,1196,1197],[1183,1184,1185,1194,1195,1196]],
[[-3,-61,39],[-8,-61,20],[-2,-71,39,],0xFFFFFF,[1183,1184,1185,1194,1195,1196],[1184,1185,1186,1195,1196,1197],[1185,1186,1187,1196,1197,1198]],
[[-8,-61,20],[-7,-71,19],[-2,-71,39,],0xFFFFFF,[1184,1185,1186,1195,1196,1197],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1185,1186,1187,1196,1197,1198]],
[[-2,-71,39],[-7,-71,19],[0,-81,38,],0xFFFFFF,[1185,1186,1187,1196,1197,1198],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[-7,-71,19],[-4,-81,19],[0,-81,38,],0xFFFFFF,[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1188,1189,1190,1199,1200,1201],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[0,-81,38],[-4,-81,19],[3,-91,37,],0xFFFFFF,[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146],[1188,1189,1190,1199,1200,1201],[1189,1190,1200,1201]],
[[-4,-81,19],[-1,-91,18],[3,-91,37,],0xFFFFFF,[1188,1189,1190,1199,1200,1201],[1190,1201],[1189,1190,1200,1201]],
[[-10,-31,20],[-10,-41,20],[-5,-41,40,],0xFFFFFF,[1167,1168,1176,1177,1180,1191],[1180,1181,1182,1191,1192,1193],[1168,1177,1180,1181,1191,1192]],
[[-5,-41,40],[-10,-41,20],[-4,-51,40,],0xFFFFFF,[1168,1177,1180,1181,1191,1192],[1180,1181,1182,1191,1192,1193],[1181,1182,1183,1192,1193,1194]],
[[-10,-41,20],[-10,-51,20],[-4,-51,40,],0xFFFFFF,[1180,1181,1182,1191,1192,1193],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[1181,1182,1183,1192,1193,1194]],
[[-4,-51,40],[-10,-51,20],[-3,-61,39,],0xFFFFFF,[1181,1182,1183,1192,1193,1194],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[1183,1184,1185,1194,1195,1196]],
[[-10,-51,20],[-8,-61,20],[-3,-61,39,],0xFFFFFF,[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[1184,1185,1186,1195,1196,1197],[1183,1184,1185,1194,1195,1196]],
[[-3,-61,39],[-8,-61,20],[-2,-71,39,],0xFFFFFF,[1183,1184,1185,1194,1195,1196],[1184,1185,1186,1195,1196,1197],[1185,1186,1187,1196,1197,1198]],
[[-8,-61,20],[-7,-71,19],[-2,-71,39,],0xFFFFFF,[1184,1185,1186,1195,1196,1197],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1185,1186,1187,1196,1197,1198]],
[[-2,-71,39],[-7,-71,19],[0,-81,38,],0xFFFFFF,[1185,1186,1187,1196,1197,1198],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[-7,-71,19],[-4,-81,19],[0,-81,38,],0xFFFFFF,[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1188,1189,1190,1199,1200,1201],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[0,-81,38],[-4,-81,19],[3,-91,37,],0xFFFFFF,[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146],[1188,1189,1190,1199,1200,1201],[1189,1190,1200,1201]],
[[-4,-81,19],[-1,-91,18],[3,-91,37,],0xFFFFFF,[1188,1189,1190,1199,1200,1201],[1190,1201],[1189,1190,1200,1201]],
[[42,60,38],[36,60,25],[25,55,46,],0xFFFFFF,[1202,1205],[1202,1203,1205,1206],[1202,1203,1204,1205,1206,1207]],
[[36,60,25],[18,55,31],[25,55,46,],0xFFFFFF,[1202,1203,1205,1206],[1203,1204,1206,1207,1208,1214],[1202,1203,1204,1205,1206,1207]],
[[25,55,46],[18,55,31],[18,49,50,],0xFFFFFF,[1202,1203,1204,1205,1206,1207],[1203,1204,1206,1207,1208,1214],[1204,1207,1208,1209,1214,1215]],
[[42,60,38],[36,60,25],[25,55,46,],0xFFFFFF,[1202,1205],[1202,1203,1205,1206],[1202,1203,1204,1205,1206,1207]],
[[36,60,25],[18,55,31],[25,55,46,],0xFFFFFF,[1202,1203,1205,1206],[1203,1204,1206,1207,1208,1214],[1202,1203,1204,1205,1206,1207]],
[[25,55,46],[18,55,31],[18,49,50,],0xFFFFFF,[1202,1203,1204,1205,1206,1207],[1203,1204,1206,1207,1208,1214],[1204,1207,1208,1209,1214,1215]],
[[18,55,31],[10,49,34],[18,49,50,],0xFFFFFF,[1203,1204,1206,1207,1208,1214],[1208,1209,1210,1214,1215,1216],[1204,1207,1208,1209,1214,1215]],
[[18,49,50],[10,49,34],[12,39,53,],0xFFFFFF,[1204,1207,1208,1209,1214,1215],[1208,1209,1210,1214,1215,1216],[1209,1210,1211,1215,1216,1217]],
[[10,49,34],[4,39,36],[12,39,53,],0xFFFFFF,[1208,1209,1210,1214,1215,1216],[1210,1211,1212,1216,1217,1218],[1209,1210,1211,1215,1216,1217]],
[[12,39,53],[4,39,36],[10,29,55,],0xFFFFFF,[1209,1210,1211,1215,1216,1217],[1210,1211,1212,1216,1217,1218],[1211,1212,1213,1217,1218,1219]],
[[4,39,36],[1,29,37],[10,29,55,],0xFFFFFF,[1210,1211,1212,1216,1217,1218],[1212,1213,1218,1219,1220,1222],[1211,1212,1213,1217,1218,1219]],
[[10,29,55],[1,29,37],[8,19,56,],0xFFFFFF,[1211,1212,1213,1217,1218,1219],[1212,1213,1218,1219,1220,1222],[1213,1219,1220,1221,1222,1223]],
[[18,55,31],[10,49,34],[18,49,50,],0xFFFFFF,[1203,1204,1206,1207,1208,1214],[1208,1209,1210,1214,1215,1216],[1204,1207,1208,1209,1214,1215]],
[[18,49,50],[10,49,34],[12,39,53,],0xFFFFFF,[1204,1207,1208,1209,1214,1215],[1208,1209,1210,1214,1215,1216],[1209,1210,1211,1215,1216,1217]],
[[10,49,34],[4,39,36],[12,39,53,],0xFFFFFF,[1208,1209,1210,1214,1215,1216],[1210,1211,1212,1216,1217,1218],[1209,1210,1211,1215,1216,1217]],
[[12,39,53],[4,39,36],[10,29,55,],0xFFFFFF,[1209,1210,1211,1215,1216,1217],[1210,1211,1212,1216,1217,1218],[1211,1212,1213,1217,1218,1219]],
[[4,39,36],[1,29,37],[10,29,55,],0xFFFFFF,[1210,1211,1212,1216,1217,1218],[1212,1213,1218,1219,1220,1222],[1211,1212,1213,1217,1218,1219]],
[[10,29,55],[1,29,37],[8,19,56,],0xFFFFFF,[1211,1212,1213,1217,1218,1219],[1212,1213,1218,1219,1220,1222],[1213,1219,1220,1221,1222,1223]],
[[1,29,37],[0,19,38],[8,19,56,],0xFFFFFF,[1212,1213,1218,1219,1220,1222],[1220,1221,1222,1223,1242,1243],[1213,1219,1220,1221,1222,1223]],
[[8,19,56],[0,19,38],[6,9,57,],0xFFFFFF,[1213,1219,1220,1221,1222,1223],[1220,1221,1222,1223,1242,1243],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[1,29,37],[0,19,38],[8,19,56,],0xFFFFFF,[1212,1213,1218,1219,1220,1222],[1220,1221,1222,1223,1242,1243],[1213,1219,1220,1221,1222,1223]],
[[8,19,56],[0,19,38],[6,9,57,],0xFFFFFF,[1213,1219,1220,1221,1222,1223],[1220,1221,1222,1223,1242,1243],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[6,9,57],[-1,9,39],[5,-1,58,],0xFFFFFF,[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192],[1224,1225,1233,1234,1242,1243],[1224,1225,1226,1233,1234,1235]],
[[-1,9,39],[-3,-1,39],[5,-1,58,],0xFFFFFF,[1224,1225,1233,1234,1242,1243],[1225,1226,1227,1234,1235,1236],[1224,1225,1226,1233,1234,1235]],
[[5,-1,58],[-3,-1,39],[4,-11,58,],0xFFFFFF,[1224,1225,1226,1233,1234,1235],[1225,1226,1227,1234,1235,1236],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[-3,-1,39],[-4,-11,40],[4,-11,58,],0xFFFFFF,[1225,1226,1227,1234,1235,1236],[1227,1228,1229,1236,1237,1238],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[4,-11,58],[-4,-11,40],[3,-21,59,],0xFFFFFF,[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196],[1227,1228,1229,1236,1237,1238],[1228,1229,1230,1237,1238,1239]],
[[-4,-11,40],[-5,-21,40],[3,-21,59,],0xFFFFFF,[1227,1228,1229,1236,1237,1238],[1229,1230,1231,1238,1239,1240],[1228,1229,1230,1237,1238,1239]],
[[3,-21,59],[-5,-21,40],[3,-31,59,],0xFFFFFF,[1228,1229,1230,1237,1238,1239],[1229,1230,1231,1238,1239,1240],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265]],
[[-5,-21,40],[-5,-31,40],[3,-31,59,],0xFFFFFF,[1229,1230,1231,1238,1239,1240],[1231,1232,1240,1241,1244,1255],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265]],
[[3,-31,59],[-5,-31,40],[3,-41,59,],0xFFFFFF,[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[1231,1232,1240,1241,1244,1255],[1232,1241,1244,1245,1255,1256]],
[[6,9,57],[-1,9,39],[5,-1,58,],0xFFFFFF,[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192],[1224,1225,1233,1234,1242,1243],[1224,1225,1226,1233,1234,1235]],
[[-1,9,39],[-3,-1,39],[5,-1,58,],0xFFFFFF,[1224,1225,1233,1234,1242,1243],[1225,1226,1227,1234,1235,1236],[1224,1225,1226,1233,1234,1235]],
[[5,-1,58],[-3,-1,39],[4,-11,58,],0xFFFFFF,[1224,1225,1226,1233,1234,1235],[1225,1226,1227,1234,1235,1236],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[-3,-1,39],[-4,-11,40],[4,-11,58,],0xFFFFFF,[1225,1226,1227,1234,1235,1236],[1227,1228,1229,1236,1237,1238],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[4,-11,58],[-4,-11,40],[3,-21,59,],0xFFFFFF,[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196],[1227,1228,1229,1236,1237,1238],[1228,1229,1230,1237,1238,1239]],
[[-4,-11,40],[-5,-21,40],[3,-21,59,],0xFFFFFF,[1227,1228,1229,1236,1237,1238],[1229,1230,1231,1238,1239,1240],[1228,1229,1230,1237,1238,1239]],
[[3,-21,59],[-5,-21,40],[3,-31,59,],0xFFFFFF,[1228,1229,1230,1237,1238,1239],[1229,1230,1231,1238,1239,1240],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265]],
[[-5,-21,40],[-5,-31,40],[3,-31,59,],0xFFFFFF,[1229,1230,1231,1238,1239,1240],[1231,1232,1240,1241,1244,1255],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265]],
[[3,-31,59],[-5,-31,40],[3,-41,59,],0xFFFFFF,[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[1231,1232,1240,1241,1244,1255],[1232,1241,1244,1245,1255,1256]],
[[0,19,38],[-1,9,39],[6,9,57,],0xFFFFFF,[1220,1221,1222,1223,1242,1243],[1224,1225,1233,1234,1242,1243],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[0,19,38],[-1,9,39],[6,9,57,],0xFFFFFF,[1220,1221,1222,1223,1242,1243],[1224,1225,1233,1234,1242,1243],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[-5,-31,40],[-5,-41,40],[3,-41,59,],0xFFFFFF,[1231,1232,1240,1241,1244,1255],[1244,1245,1246,1255,1256,1257],[1232,1241,1244,1245,1255,1256]],
[[3,-41,59],[-5,-41,40],[3,-51,58,],0xFFFFFF,[1232,1241,1244,1245,1255,1256],[1244,1245,1246,1255,1256,1257],[1245,1246,1247,1256,1257,1258]],
[[-5,-41,40],[-4,-51,40],[3,-51,58,],0xFFFFFF,[1244,1245,1246,1255,1256,1257],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[1245,1246,1247,1256,1257,1258]],
[[3,-51,58],[-4,-51,40],[4,-61,58,],0xFFFFFF,[1245,1246,1247,1256,1257,1258],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[1247,1248,1249,1258,1259,1260]],
[[-4,-51,40],[-3,-61,39],[4,-61,58,],0xFFFFFF,[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[1248,1249,1250,1259,1260,1261],[1247,1248,1249,1258,1259,1260]],
[[4,-61,58],[-3,-61,39],[6,-71,57,],0xFFFFFF,[1247,1248,1249,1258,1259,1260],[1248,1249,1250,1259,1260,1261],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273]],
[[-3,-61,39],[-2,-71,39],[6,-71,57,],0xFFFFFF,[1248,1249,1250,1259,1260,1261],[1250,1251,1252,1261,1262,1263],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273]],
[[6,-71,57],[-2,-71,39],[8,-81,56,],0xFFFFFF,[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1250,1251,1252,1261,1262,1263],[1251,1252,1253,1262,1263,1264]],
[[-2,-71,39],[0,-81,38],[8,-81,56,],0xFFFFFF,[1250,1251,1252,1261,1262,1263],[1252,1253,1254,1263,1264,1265],[1251,1252,1253,1262,1263,1264]],
[[8,-81,56],[0,-81,38],[11,-91,54,],0xFFFFFF,[1251,1252,1253,1262,1263,1264],[1252,1253,1254,1263,1264,1265],[1253,1254,1264,1265]],
[[0,-81,38],[3,-91,37],[11,-91,54,],0xFFFFFF,[1252,1253,1254,1263,1264,1265],[1254,1265],[1253,1254,1264,1265]],
[[-5,-31,40],[-5,-41,40],[3,-41,59,],0xFFFFFF,[1231,1232,1240,1241,1244,1255],[1244,1245,1246,1255,1256,1257],[1232,1241,1244,1245,1255,1256]],
[[3,-41,59],[-5,-41,40],[3,-51,58,],0xFFFFFF,[1232,1241,1244,1245,1255,1256],[1244,1245,1246,1255,1256,1257],[1245,1246,1247,1256,1257,1258]],
[[-5,-41,40],[-4,-51,40],[3,-51,58,],0xFFFFFF,[1244,1245,1246,1255,1256,1257],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[1245,1246,1247,1256,1257,1258]],
[[3,-51,58],[-4,-51,40],[4,-61,58,],0xFFFFFF,[1245,1246,1247,1256,1257,1258],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[1247,1248,1249,1258,1259,1260]],
[[-4,-51,40],[-3,-61,39],[4,-61,58,],0xFFFFFF,[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[1248,1249,1250,1259,1260,1261],[1247,1248,1249,1258,1259,1260]],
[[4,-61,58],[-3,-61,39],[6,-71,57,],0xFFFFFF,[1247,1248,1249,1258,1259,1260],[1248,1249,1250,1259,1260,1261],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273]],
[[-3,-61,39],[-2,-71,39],[6,-71,57,],0xFFFFFF,[1248,1249,1250,1259,1260,1261],[1250,1251,1252,1261,1262,1263],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273]],
[[6,-71,57],[-2,-71,39],[8,-81,56,],0xFFFFFF,[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1250,1251,1252,1261,1262,1263],[1251,1252,1253,1262,1263,1264]],
[[-2,-71,39],[0,-81,38],[8,-81,56,],0xFFFFFF,[1250,1251,1252,1261,1262,1263],[1252,1253,1254,1263,1264,1265],[1251,1252,1253,1262,1263,1264]],
[[8,-81,56],[0,-81,38],[11,-91,54,],0xFFFFFF,[1251,1252,1253,1262,1263,1264],[1252,1253,1254,1263,1264,1265],[1253,1254,1264,1265]],
[[0,-81,38],[3,-91,37],[11,-91,54,],0xFFFFFF,[1252,1253,1254,1263,1264,1265],[1254,1265],[1253,1254,1264,1265]],
[[49,60,49],[41,60,37],[34,55,59,],0xFFFFFF,[1266,1269,3212,3244],[1266,1267,1269,1270],[1266,1267,1268,1269,1270,1271]],
[[41,60,37],[25,55,46],[34,55,59,],0xFFFFFF,[1266,1267,1269,1270],[1267,1268,1270,1271,1272,1278],[1266,1267,1268,1269,1270,1271]],
[[34,55,59],[25,55,46],[28,49,65,],0xFFFFFF,[1266,1267,1268,1269,1270,1271],[1267,1268,1270,1271,1272,1278],[1268,1271,1272,1273,1278,1279]],
[[49,60,49],[41,60,37],[34,55,59,],0xFFFFFF,[1266,1269,3212,3244],[1266,1267,1269,1270],[1266,1267,1268,1269,1270,1271]],
[[41,60,37],[25,55,46],[34,55,59,],0xFFFFFF,[1266,1267,1269,1270],[1267,1268,1270,1271,1272,1278],[1266,1267,1268,1269,1270,1271]],
[[34,55,59],[25,55,46],[28,49,65,],0xFFFFFF,[1266,1267,1268,1269,1270,1271],[1267,1268,1270,1271,1272,1278],[1268,1271,1272,1273,1278,1279]],
[[25,55,46],[18,49,50],[28,49,65,],0xFFFFFF,[1267,1268,1270,1271,1272,1278],[1272,1273,1274,1278,1279,1280],[1268,1271,1272,1273,1278,1279]],
[[28,49,65],[18,49,50],[23,39,69,],0xFFFFFF,[1268,1271,1272,1273,1278,1279],[1272,1273,1274,1278,1279,1280],[1273,1274,1275,1279,1280,1281]],
[[18,49,50],[12,39,53],[23,39,69,],0xFFFFFF,[1272,1273,1274,1278,1279,1280],[1274,1275,1276,1280,1281,1282],[1273,1274,1275,1279,1280,1281]],
[[23,39,69],[12,39,53],[21,29,71,],0xFFFFFF,[1273,1274,1275,1279,1280,1281],[1274,1275,1276,1280,1281,1282],[1275,1276,1277,1281,1282,1283]],
[[12,39,53],[10,29,55],[21,29,71,],0xFFFFFF,[1274,1275,1276,1280,1281,1282],[1276,1277,1282,1283,1284,1286],[1275,1276,1277,1281,1282,1283]],
[[21,29,71],[10,29,55],[19,19,72,],0xFFFFFF,[1275,1276,1277,1281,1282,1283],[1276,1277,1282,1283,1284,1286],[1277,1283,1284,1285,1286,1287]],
[[25,55,46],[18,49,50],[28,49,65,],0xFFFFFF,[1267,1268,1270,1271,1272,1278],[1272,1273,1274,1278,1279,1280],[1268,1271,1272,1273,1278,1279]],
[[28,49,65],[18,49,50],[23,39,69,],0xFFFFFF,[1268,1271,1272,1273,1278,1279],[1272,1273,1274,1278,1279,1280],[1273,1274,1275,1279,1280,1281]],
[[18,49,50],[12,39,53],[23,39,69,],0xFFFFFF,[1272,1273,1274,1278,1279,1280],[1274,1275,1276,1280,1281,1282],[1273,1274,1275,1279,1280,1281]],
[[23,39,69],[12,39,53],[21,29,71,],0xFFFFFF,[1273,1274,1275,1279,1280,1281],[1274,1275,1276,1280,1281,1282],[1275,1276,1277,1281,1282,1283]],
[[12,39,53],[10,29,55],[21,29,71,],0xFFFFFF,[1274,1275,1276,1280,1281,1282],[1276,1277,1282,1283,1284,1286],[1275,1276,1277,1281,1282,1283]],
[[21,29,71],[10,29,55],[19,19,72,],0xFFFFFF,[1275,1276,1277,1281,1282,1283],[1276,1277,1282,1283,1284,1286],[1277,1283,1284,1285,1286,1287]],
[[10,29,55],[8,19,56],[19,19,72,],0xFFFFFF,[1276,1277,1282,1283,1284,1286],[1284,1285,1286,1287,1306,1307],[1277,1283,1284,1285,1286,1287]],
[[19,19,72],[8,19,56],[17,9,73,],0xFFFFFF,[1277,1283,1284,1285,1286,1287],[1284,1285,1286,1287,1306,1307],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[10,29,55],[8,19,56],[19,19,72,],0xFFFFFF,[1276,1277,1282,1283,1284,1286],[1284,1285,1286,1287,1306,1307],[1277,1283,1284,1285,1286,1287]],
[[19,19,72],[8,19,56],[17,9,73,],0xFFFFFF,[1277,1283,1284,1285,1286,1287],[1284,1285,1286,1287,1306,1307],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[17,9,73],[6,9,57],[16,-1,74,],0xFFFFFF,[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256],[1288,1289,1297,1298,1306,1307],[1288,1289,1290,1297,1298,1299]],
[[6,9,57],[5,-1,58],[16,-1,74,],0xFFFFFF,[1288,1289,1297,1298,1306,1307],[1289,1290,1291,1298,1299,1300],[1288,1289,1290,1297,1298,1299]],
[[16,-1,74],[5,-1,58],[16,-11,75,],0xFFFFFF,[1288,1289,1290,1297,1298,1299],[1289,1290,1291,1298,1299,1300],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[5,-1,58],[4,-11,58],[16,-11,75,],0xFFFFFF,[1289,1290,1291,1298,1299,1300],[1291,1292,1293,1300,1301,1302],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[16,-11,75],[4,-11,58],[15,-21,75,],0xFFFFFF,[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260],[1291,1292,1293,1300,1301,1302],[1292,1293,1294,1301,1302,1303]],
[[4,-11,58],[3,-21,59],[15,-21,75,],0xFFFFFF,[1291,1292,1293,1300,1301,1302],[1293,1294,1295,1302,1303,1304],[1292,1293,1294,1301,1302,1303]],
[[15,-21,75],[3,-21,59],[15,-31,76,],0xFFFFFF,[1292,1293,1294,1301,1302,1303],[1293,1294,1295,1302,1303,1304],[1294,1295,1296,1303,1304,1305]],
[[3,-21,59],[3,-31,59],[15,-31,76,],0xFFFFFF,[1293,1294,1295,1302,1303,1304],[1295,1296,1304,1305,1308,1319],[1294,1295,1296,1303,1304,1305]],
[[15,-31,76],[3,-31,59],[15,-41,76,],0xFFFFFF,[1294,1295,1296,1303,1304,1305],[1295,1296,1304,1305,1308,1319],[1296,1305,1308,1309,1319,1320]],
[[17,9,73],[6,9,57],[16,-1,74,],0xFFFFFF,[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256],[1288,1289,1297,1298,1306,1307],[1288,1289,1290,1297,1298,1299]],
[[6,9,57],[5,-1,58],[16,-1,74,],0xFFFFFF,[1288,1289,1297,1298,1306,1307],[1289,1290,1291,1298,1299,1300],[1288,1289,1290,1297,1298,1299]],
[[16,-1,74],[5,-1,58],[16,-11,75,],0xFFFFFF,[1288,1289,1290,1297,1298,1299],[1289,1290,1291,1298,1299,1300],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[5,-1,58],[4,-11,58],[16,-11,75,],0xFFFFFF,[1289,1290,1291,1298,1299,1300],[1291,1292,1293,1300,1301,1302],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[16,-11,75],[4,-11,58],[15,-21,75,],0xFFFFFF,[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260],[1291,1292,1293,1300,1301,1302],[1292,1293,1294,1301,1302,1303]],
[[4,-11,58],[3,-21,59],[15,-21,75,],0xFFFFFF,[1291,1292,1293,1300,1301,1302],[1293,1294,1295,1302,1303,1304],[1292,1293,1294,1301,1302,1303]],
[[15,-21,75],[3,-21,59],[15,-31,76,],0xFFFFFF,[1292,1293,1294,1301,1302,1303],[1293,1294,1295,1302,1303,1304],[1294,1295,1296,1303,1304,1305]],
[[3,-21,59],[3,-31,59],[15,-31,76,],0xFFFFFF,[1293,1294,1295,1302,1303,1304],[1295,1296,1304,1305,1308,1319],[1294,1295,1296,1303,1304,1305]],
[[15,-31,76],[3,-31,59],[15,-41,76,],0xFFFFFF,[1294,1295,1296,1303,1304,1305],[1295,1296,1304,1305,1308,1319],[1296,1305,1308,1309,1319,1320]],
[[8,19,56],[6,9,57],[17,9,73,],0xFFFFFF,[1284,1285,1286,1287,1306,1307],[1288,1289,1297,1298,1306,1307],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[8,19,56],[6,9,57],[17,9,73,],0xFFFFFF,[1284,1285,1286,1287,1306,1307],[1288,1289,1297,1298,1306,1307],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[3,-31,59],[3,-41,59],[15,-41,76,],0xFFFFFF,[1295,1296,1304,1305,1308,1319],[1308,1309,1310,1319,1320,1321],[1296,1305,1308,1309,1319,1320]],
[[15,-41,76],[3,-41,59],[15,-51,75,],0xFFFFFF,[1296,1305,1308,1309,1319,1320],[1308,1309,1310,1319,1320,1321],[1309,1310,1311,1320,1321,1322]],
[[3,-41,59],[3,-51,58],[15,-51,75,],0xFFFFFF,[1308,1309,1310,1319,1320,1321],[1310,1311,1312,1321,1322,1323],[1309,1310,1311,1320,1321,1322]],
[[15,-51,75],[3,-51,58],[16,-61,75,],0xFFFFFF,[1309,1310,1311,1320,1321,1322],[1310,1311,1312,1321,1322,1323],[1311,1312,1313,1322,1323,1324]],
[[3,-51,58],[4,-61,58],[16,-61,75,],0xFFFFFF,[1310,1311,1312,1321,1322,1323],[1312,1313,1314,1323,1324,1325],[1311,1312,1313,1322,1323,1324]],
[[16,-61,75],[4,-61,58],[17,-71,73,],0xFFFFFF,[1311,1312,1313,1322,1323,1324],[1312,1313,1314,1323,1324,1325],[1313,1314,1315,1324,1325,1326]],
[[4,-61,58],[6,-71,57],[17,-71,73,],0xFFFFFF,[1312,1313,1314,1323,1324,1325],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1313,1314,1315,1324,1325,1326]],
[[17,-71,73],[6,-71,57],[19,-81,72,],0xFFFFFF,[1313,1314,1315,1324,1325,1326],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[6,-71,57],[8,-81,56],[19,-81,72,],0xFFFFFF,[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1316,1317,1318,1327,1328,1329],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[19,-81,72],[8,-81,56],[22,-91,70,],0xFFFFFF,[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370],[1316,1317,1318,1327,1328,1329],[1317,1318,1328,1329,3307,3339]],
[[8,-81,56],[11,-91,54],[22,-91,70,],0xFFFFFF,[1316,1317,1318,1327,1328,1329],[1318,1329],[1317,1318,1328,1329,3307,3339]],
[[3,-31,59],[3,-41,59],[15,-41,76,],0xFFFFFF,[1295,1296,1304,1305,1308,1319],[1308,1309,1310,1319,1320,1321],[1296,1305,1308,1309,1319,1320]],
[[15,-41,76],[3,-41,59],[15,-51,75,],0xFFFFFF,[1296,1305,1308,1309,1319,1320],[1308,1309,1310,1319,1320,1321],[1309,1310,1311,1320,1321,1322]],
[[3,-41,59],[3,-51,58],[15,-51,75,],0xFFFFFF,[1308,1309,1310,1319,1320,1321],[1310,1311,1312,1321,1322,1323],[1309,1310,1311,1320,1321,1322]],
[[15,-51,75],[3,-51,58],[16,-61,75,],0xFFFFFF,[1309,1310,1311,1320,1321,1322],[1310,1311,1312,1321,1322,1323],[1311,1312,1313,1322,1323,1324]],
[[3,-51,58],[4,-61,58],[16,-61,75,],0xFFFFFF,[1310,1311,1312,1321,1322,1323],[1312,1313,1314,1323,1324,1325],[1311,1312,1313,1322,1323,1324]],
[[16,-61,75],[4,-61,58],[17,-71,73,],0xFFFFFF,[1311,1312,1313,1322,1323,1324],[1312,1313,1314,1323,1324,1325],[1313,1314,1315,1324,1325,1326]],
[[4,-61,58],[6,-71,57],[17,-71,73,],0xFFFFFF,[1312,1313,1314,1323,1324,1325],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1313,1314,1315,1324,1325,1326]],
[[17,-71,73],[6,-71,57],[19,-81,72,],0xFFFFFF,[1313,1314,1315,1324,1325,1326],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[6,-71,57],[8,-81,56],[19,-81,72,],0xFFFFFF,[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1316,1317,1318,1327,1328,1329],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[19,-81,72],[8,-81,56],[22,-91,70,],0xFFFFFF,[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370],[1316,1317,1318,1327,1328,1329],[1317,1318,1328,1329,3307,3339]],
[[8,-81,56],[11,-91,54],[22,-91,70,],0xFFFFFF,[1316,1317,1318,1327,1328,1329],[1318,1329],[1317,1318,1328,1329,3307,3339]],
[[59,60,58],[48,60,47],[46,55,71,],0xFFFFFF,[1330,1333],[1330,1331,1333,1334],[1330,1331,1332,1333,1334,1335]],
[[48,60,47],[34,55,59],[46,55,71,],0xFFFFFF,[1330,1331,1333,1334],[1331,1332,1334,1335,1336,1342],[1330,1331,1332,1333,1334,1335]],
[[46,55,71],[34,55,59],[40,49,77,],0xFFFFFF,[1330,1331,1332,1333,1334,1335],[1331,1332,1334,1335,1336,1342],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377]],
[[59,60,58],[48,60,47],[46,55,71,],0xFFFFFF,[1330,1333],[1330,1331,1333,1334],[1330,1331,1332,1333,1334,1335]],
[[48,60,47],[34,55,59],[46,55,71,],0xFFFFFF,[1330,1331,1333,1334],[1331,1332,1334,1335,1336,1342],[1330,1331,1332,1333,1334,1335]],
[[46,55,71],[34,55,59],[40,49,77,],0xFFFFFF,[1330,1331,1332,1333,1334,1335],[1331,1332,1334,1335,1336,1342],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377]],
[[34,55,59],[28,49,65],[40,49,77,],0xFFFFFF,[1331,1332,1334,1335,1336,1342],[1336,1337,1338,1342,1343,1344],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377]],
[[40,49,77],[28,49,65],[36,39,82,],0xFFFFFF,[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[1336,1337,1338,1342,1343,1344],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[28,49,65],[23,39,69],[36,39,82,],0xFFFFFF,[1336,1337,1338,1342,1343,1344],[1338,1339,1340,1344,1345,1346],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[36,39,82],[23,39,69],[34,29,84,],0xFFFFFF,[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314],[1338,1339,1340,1344,1345,1346],[1339,1340,1341,1345,1346,1347]],
[[23,39,69],[21,29,71],[34,29,84,],0xFFFFFF,[1338,1339,1340,1344,1345,1346],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1339,1340,1341,1345,1346,1347]],
[[34,29,84],[21,29,71],[33,19,86,],0xFFFFFF,[1339,1340,1341,1345,1346,1347],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1341,1347,1348,1349,1350,1351]],
[[34,55,59],[28,49,65],[40,49,77,],0xFFFFFF,[1331,1332,1334,1335,1336,1342],[1336,1337,1338,1342,1343,1344],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377]],
[[40,49,77],[28,49,65],[36,39,82,],0xFFFFFF,[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[1336,1337,1338,1342,1343,1344],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[28,49,65],[23,39,69],[36,39,82,],0xFFFFFF,[1336,1337,1338,1342,1343,1344],[1338,1339,1340,1344,1345,1346],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[36,39,82],[23,39,69],[34,29,84,],0xFFFFFF,[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314],[1338,1339,1340,1344,1345,1346],[1339,1340,1341,1345,1346,1347]],
[[23,39,69],[21,29,71],[34,29,84,],0xFFFFFF,[1338,1339,1340,1344,1345,1346],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1339,1340,1341,1345,1346,1347]],
[[34,29,84],[21,29,71],[33,19,86,],0xFFFFFF,[1339,1340,1341,1345,1346,1347],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1341,1347,1348,1349,1350,1351]],
[[21,29,71],[19,19,72],[33,19,86,],0xFFFFFF,[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1341,1347,1348,1349,1350,1351]],
[[33,19,86],[19,19,72],[32,9,88,],0xFFFFFF,[1341,1347,1348,1349,1350,1351],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[21,29,71],[19,19,72],[33,19,86,],0xFFFFFF,[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1341,1347,1348,1349,1350,1351]],
[[33,19,86],[19,19,72],[32,9,88,],0xFFFFFF,[1341,1347,1348,1349,1350,1351],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[32,9,88],[17,9,73],[31,-1,89,],0xFFFFFF,[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1352,1353,1354,1361,1362,1363]],
[[17,9,73],[16,-1,74],[31,-1,89,],0xFFFFFF,[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[1352,1353,1354,1361,1362,1363]],
[[31,-1,89],[16,-1,74],[30,-11,89,],0xFFFFFF,[1352,1353,1354,1361,1362,1363],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[16,-1,74],[16,-11,75],[30,-11,89,],0xFFFFFF,[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[1355,1356,1357,1364,1365,1366],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[30,-11,89],[16,-11,75],[30,-21,90,],0xFFFFFF,[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324],[1355,1356,1357,1364,1365,1366],[1356,1357,1358,1365,1366,1367]],
[[16,-11,75],[15,-21,75],[30,-21,90,],0xFFFFFF,[1355,1356,1357,1364,1365,1366],[1357,1358,1359,1366,1367,1368],[1356,1357,1358,1365,1366,1367]],
[[30,-21,90],[15,-21,75],[29,-31,90,],0xFFFFFF,[1356,1357,1358,1365,1366,1367],[1357,1358,1359,1366,1367,1368],[1358,1359,1360,1367,1368,1369]],
[[15,-21,75],[15,-31,76],[29,-31,90,],0xFFFFFF,[1357,1358,1359,1366,1367,1368],[1359,1360,1368,1369,1372,1383],[1358,1359,1360,1367,1368,1369]],
[[29,-31,90],[15,-31,76],[29,-41,90,],0xFFFFFF,[1358,1359,1360,1367,1368,1369],[1359,1360,1368,1369,1372,1383],[1360,1369,1372,1373,1383,1384]],
[[32,9,88],[17,9,73],[31,-1,89,],0xFFFFFF,[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1352,1353,1354,1361,1362,1363]],
[[17,9,73],[16,-1,74],[31,-1,89,],0xFFFFFF,[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[1352,1353,1354,1361,1362,1363]],
[[31,-1,89],[16,-1,74],[30,-11,89,],0xFFFFFF,[1352,1353,1354,1361,1362,1363],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[16,-1,74],[16,-11,75],[30,-11,89,],0xFFFFFF,[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[1355,1356,1357,1364,1365,1366],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[30,-11,89],[16,-11,75],[30,-21,90,],0xFFFFFF,[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324],[1355,1356,1357,1364,1365,1366],[1356,1357,1358,1365,1366,1367]],
[[16,-11,75],[15,-21,75],[30,-21,90,],0xFFFFFF,[1355,1356,1357,1364,1365,1366],[1357,1358,1359,1366,1367,1368],[1356,1357,1358,1365,1366,1367]],
[[30,-21,90],[15,-21,75],[29,-31,90,],0xFFFFFF,[1356,1357,1358,1365,1366,1367],[1357,1358,1359,1366,1367,1368],[1358,1359,1360,1367,1368,1369]],
[[15,-21,75],[15,-31,76],[29,-31,90,],0xFFFFFF,[1357,1358,1359,1366,1367,1368],[1359,1360,1368,1369,1372,1383],[1358,1359,1360,1367,1368,1369]],
[[29,-31,90],[15,-31,76],[29,-41,90,],0xFFFFFF,[1358,1359,1360,1367,1368,1369],[1359,1360,1368,1369,1372,1383],[1360,1369,1372,1373,1383,1384]],
[[19,19,72],[17,9,73],[32,9,88,],0xFFFFFF,[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[19,19,72],[17,9,73],[32,9,88,],0xFFFFFF,[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[15,-31,76],[15,-41,76],[29,-41,90,],0xFFFFFF,[1359,1360,1368,1369,1372,1383],[1372,1373,1374,1383,1384,1385],[1360,1369,1372,1373,1383,1384]],
[[29,-41,90],[15,-41,76],[30,-51,90,],0xFFFFFF,[1360,1369,1372,1373,1383,1384],[1372,1373,1374,1383,1384,1385],[1373,1374,1375,1384,1385,1386]],
[[15,-41,76],[15,-51,75],[30,-51,90,],0xFFFFFF,[1372,1373,1374,1383,1384,1385],[1374,1375,1376,1385,1386,1387],[1373,1374,1375,1384,1385,1386]],
[[30,-51,90],[15,-51,75],[30,-61,89,],0xFFFFFF,[1373,1374,1375,1384,1385,1386],[1374,1375,1376,1385,1386,1387],[1375,1376,1377,1386,1387,1388]],
[[15,-51,75],[16,-61,75],[30,-61,89,],0xFFFFFF,[1374,1375,1376,1385,1386,1387],[1376,1377,1378,1387,1388,1389],[1375,1376,1377,1386,1387,1388]],
[[30,-61,89],[16,-61,75],[32,-71,88,],0xFFFFFF,[1375,1376,1377,1386,1387,1388],[1376,1377,1378,1387,1388,1389],[1377,1378,1379,1388,1389,1390]],
[[16,-61,75],[17,-71,73],[32,-71,88,],0xFFFFFF,[1376,1377,1378,1387,1388,1389],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1377,1378,1379,1388,1389,1390]],
[[32,-71,88],[17,-71,73],[33,-81,86,],0xFFFFFF,[1377,1378,1379,1388,1389,1390],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[17,-71,73],[19,-81,72],[33,-81,86,],0xFFFFFF,[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1380,1381,1382,1391,1392,1393],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[33,-81,86],[19,-81,72],[35,-91,83,],0xFFFFFF,[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338],[1380,1381,1382,1391,1392,1393],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[19,-81,72],[22,-91,70],[35,-91,83,],0xFFFFFF,[1380,1381,1382,1391,1392,1393],[1382,1393],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[15,-31,76],[15,-41,76],[29,-41,90,],0xFFFFFF,[1359,1360,1368,1369,1372,1383],[1372,1373,1374,1383,1384,1385],[1360,1369,1372,1373,1383,1384]],
[[29,-41,90],[15,-41,76],[30,-51,90,],0xFFFFFF,[1360,1369,1372,1373,1383,1384],[1372,1373,1374,1383,1384,1385],[1373,1374,1375,1384,1385,1386]],
[[15,-41,76],[15,-51,75],[30,-51,90,],0xFFFFFF,[1372,1373,1374,1383,1384,1385],[1374,1375,1376,1385,1386,1387],[1373,1374,1375,1384,1385,1386]],
[[30,-51,90],[15,-51,75],[30,-61,89,],0xFFFFFF,[1373,1374,1375,1384,1385,1386],[1374,1375,1376,1385,1386,1387],[1375,1376,1377,1386,1387,1388]],
[[15,-51,75],[16,-61,75],[30,-61,89,],0xFFFFFF,[1374,1375,1376,1385,1386,1387],[1376,1377,1378,1387,1388,1389],[1375,1376,1377,1386,1387,1388]],
[[30,-61,89],[16,-61,75],[32,-71,88,],0xFFFFFF,[1375,1376,1377,1386,1387,1388],[1376,1377,1378,1387,1388,1389],[1377,1378,1379,1388,1389,1390]],
[[16,-61,75],[17,-71,73],[32,-71,88,],0xFFFFFF,[1376,1377,1378,1387,1388,1389],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1377,1378,1379,1388,1389,1390]],
[[32,-71,88],[17,-71,73],[33,-81,86,],0xFFFFFF,[1377,1378,1379,1388,1389,1390],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[17,-71,73],[19,-81,72],[33,-81,86,],0xFFFFFF,[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1380,1381,1382,1391,1392,1393],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[33,-81,86],[19,-81,72],[35,-91,83,],0xFFFFFF,[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338],[1380,1381,1382,1391,1392,1393],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[19,-81,72],[22,-91,70],[35,-91,83,],0xFFFFFF,[1380,1381,1382,1391,1392,1393],[1382,1393],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[69,60,65],[58,60,57],[59,55,80,],0xFFFFFF,[1394,1397,3340,3372],[1394,1395,1397,1398],[1394,1395,1396,1397,1398,1399]],
[[58,60,57],[46,55,71],[59,55,80,],0xFFFFFF,[1394,1395,1397,1398],[1395,1396,1398,1399,1400,1406],[1394,1395,1396,1397,1398,1399]],
[[59,55,80],[46,55,71],[55,49,87,],0xFFFFFF,[1394,1395,1396,1397,1398,1399],[1395,1396,1398,1399,1400,1406],[1396,1399,1400,1401,1406,1407]],
[[69,60,65],[58,60,57],[59,55,80,],0xFFFFFF,[1394,1397,3340,3372],[1394,1395,1397,1398],[1394,1395,1396,1397,1398,1399]],
[[58,60,57],[46,55,71],[59,55,80,],0xFFFFFF,[1394,1395,1397,1398],[1395,1396,1398,1399,1400,1406],[1394,1395,1396,1397,1398,1399]],
[[59,55,80],[46,55,71],[55,49,87,],0xFFFFFF,[1394,1395,1396,1397,1398,1399],[1395,1396,1398,1399,1400,1406],[1396,1399,1400,1401,1406,1407]],
[[46,55,71],[40,49,77],[55,49,87,],0xFFFFFF,[1395,1396,1398,1399,1400,1406],[1400,1401,1402,1406,1407,1408],[1396,1399,1400,1401,1406,1407]],
[[55,49,87],[40,49,77],[52,39,93,],0xFFFFFF,[1396,1399,1400,1401,1406,1407],[1400,1401,1402,1406,1407,1408],[1401,1402,1403,1407,1408,1409]],
[[40,49,77],[36,39,82],[52,39,93,],0xFFFFFF,[1400,1401,1402,1406,1407,1408],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[1401,1402,1403,1407,1408,1409]],
[[52,39,93],[36,39,82],[50,29,95,],0xFFFFFF,[1401,1402,1403,1407,1408,1409],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[1403,1404,1405,1409,1410,1411]],
[[36,39,82],[34,29,84],[50,29,95,],0xFFFFFF,[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[1404,1405,1410,1411,1412,1414],[1403,1404,1405,1409,1410,1411]],
[[50,29,95],[34,29,84],[49,19,97,],0xFFFFFF,[1403,1404,1405,1409,1410,1411],[1404,1405,1410,1411,1412,1414],[1405,1411,1412,1413,1414,1415]],
[[46,55,71],[40,49,77],[55,49,87,],0xFFFFFF,[1395,1396,1398,1399,1400,1406],[1400,1401,1402,1406,1407,1408],[1396,1399,1400,1401,1406,1407]],
[[55,49,87],[40,49,77],[52,39,93,],0xFFFFFF,[1396,1399,1400,1401,1406,1407],[1400,1401,1402,1406,1407,1408],[1401,1402,1403,1407,1408,1409]],
[[40,49,77],[36,39,82],[52,39,93,],0xFFFFFF,[1400,1401,1402,1406,1407,1408],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[1401,1402,1403,1407,1408,1409]],
[[52,39,93],[36,39,82],[50,29,95,],0xFFFFFF,[1401,1402,1403,1407,1408,1409],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[1403,1404,1405,1409,1410,1411]],
[[36,39,82],[34,29,84],[50,29,95,],0xFFFFFF,[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[1404,1405,1410,1411,1412,1414],[1403,1404,1405,1409,1410,1411]],
[[50,29,95],[34,29,84],[49,19,97,],0xFFFFFF,[1403,1404,1405,1409,1410,1411],[1404,1405,1410,1411,1412,1414],[1405,1411,1412,1413,1414,1415]],
[[34,29,84],[33,19,86],[49,19,97,],0xFFFFFF,[1404,1405,1410,1411,1412,1414],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1405,1411,1412,1413,1414,1415]],
[[49,19,97],[33,19,86],[48,9,99,],0xFFFFFF,[1405,1411,1412,1413,1414,1415],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[34,29,84],[33,19,86],[49,19,97,],0xFFFFFF,[1404,1405,1410,1411,1412,1414],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1405,1411,1412,1413,1414,1415]],
[[49,19,97],[33,19,86],[48,9,99,],0xFFFFFF,[1405,1411,1412,1413,1414,1415],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[48,9,99],[32,9,88],[47,-1,100,],0xFFFFFF,[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384],[1416,1417,1425,1426,1434,1435],[1416,1417,1418,1425,1426,1427]],
[[32,9,88],[31,-1,89],[47,-1,100,],0xFFFFFF,[1416,1417,1425,1426,1434,1435],[1417,1418,1419,1426,1427,1428],[1416,1417,1418,1425,1426,1427]],
[[47,-1,100],[31,-1,89],[47,-11,101,],0xFFFFFF,[1416,1417,1418,1425,1426,1427],[1417,1418,1419,1426,1427,1428],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[31,-1,89],[30,-11,89],[47,-11,101,],0xFFFFFF,[1417,1418,1419,1426,1427,1428],[1419,1420,1421,1428,1429,1430],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[47,-11,101],[30,-11,89],[46,-21,102,],0xFFFFFF,[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388],[1419,1420,1421,1428,1429,1430],[1420,1421,1422,1429,1430,1431]],
[[30,-11,89],[30,-21,90],[46,-21,102,],0xFFFFFF,[1419,1420,1421,1428,1429,1430],[1421,1422,1423,1430,1431,1432],[1420,1421,1422,1429,1430,1431]],
[[46,-21,102],[30,-21,90],[46,-31,102,],0xFFFFFF,[1420,1421,1422,1429,1430,1431],[1421,1422,1423,1430,1431,1432],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511]],
[[30,-21,90],[29,-31,90],[46,-31,102,],0xFFFFFF,[1421,1422,1423,1430,1431,1432],[1423,1424,1432,1433,1436,1447],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511]],
[[46,-31,102],[29,-31,90],[46,-41,102,],0xFFFFFF,[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1423,1424,1432,1433,1436,1447],[1424,1433,1436,1437,1447,1448]],
[[48,9,99],[32,9,88],[47,-1,100,],0xFFFFFF,[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384],[1416,1417,1425,1426,1434,1435],[1416,1417,1418,1425,1426,1427]],
[[32,9,88],[31,-1,89],[47,-1,100,],0xFFFFFF,[1416,1417,1425,1426,1434,1435],[1417,1418,1419,1426,1427,1428],[1416,1417,1418,1425,1426,1427]],
[[47,-1,100],[31,-1,89],[47,-11,101,],0xFFFFFF,[1416,1417,1418,1425,1426,1427],[1417,1418,1419,1426,1427,1428],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[31,-1,89],[30,-11,89],[47,-11,101,],0xFFFFFF,[1417,1418,1419,1426,1427,1428],[1419,1420,1421,1428,1429,1430],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[47,-11,101],[30,-11,89],[46,-21,102,],0xFFFFFF,[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388],[1419,1420,1421,1428,1429,1430],[1420,1421,1422,1429,1430,1431]],
[[30,-11,89],[30,-21,90],[46,-21,102,],0xFFFFFF,[1419,1420,1421,1428,1429,1430],[1421,1422,1423,1430,1431,1432],[1420,1421,1422,1429,1430,1431]],
[[46,-21,102],[30,-21,90],[46,-31,102,],0xFFFFFF,[1420,1421,1422,1429,1430,1431],[1421,1422,1423,1430,1431,1432],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511]],
[[30,-21,90],[29,-31,90],[46,-31,102,],0xFFFFFF,[1421,1422,1423,1430,1431,1432],[1423,1424,1432,1433,1436,1447],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511]],
[[46,-31,102],[29,-31,90],[46,-41,102,],0xFFFFFF,[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1423,1424,1432,1433,1436,1447],[1424,1433,1436,1437,1447,1448]],
[[33,19,86],[32,9,88],[48,9,99,],0xFFFFFF,[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1416,1417,1425,1426,1434,1435],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[33,19,86],[32,9,88],[48,9,99,],0xFFFFFF,[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1416,1417,1425,1426,1434,1435],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[29,-31,90],[29,-41,90],[46,-41,102,],0xFFFFFF,[1423,1424,1432,1433,1436,1447],[1436,1437,1438,1447,1448,1449],[1424,1433,1436,1437,1447,1448]],
[[46,-41,102],[29,-41,90],[47,-51,102,],0xFFFFFF,[1424,1433,1436,1437,1447,1448],[1436,1437,1438,1447,1448,1449],[1437,1438,1439,1448,1449,1450]],
[[29,-41,90],[30,-51,90],[47,-51,102,],0xFFFFFF,[1436,1437,1438,1447,1448,1449],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[1437,1438,1439,1448,1449,1450]],
[[47,-51,102],[30,-51,90],[47,-61,101,],0xFFFFFF,[1437,1438,1439,1448,1449,1450],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[1439,1440,1441,1450,1451,1452]],
[[30,-51,90],[30,-61,89],[47,-61,101,],0xFFFFFF,[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[1440,1441,1442,1451,1452,1453],[1439,1440,1441,1450,1451,1452]],
[[47,-61,101],[30,-61,89],[48,-71,99,],0xFFFFFF,[1439,1440,1441,1450,1451,1452],[1440,1441,1442,1451,1452,1453],[1441,1442,1443,1452,1453,1454]],
[[30,-61,89],[32,-71,88],[48,-71,99,],0xFFFFFF,[1440,1441,1442,1451,1452,1453],[1442,1443,1444,1453,1454,1455],[1441,1442,1443,1452,1453,1454]],
[[48,-71,99],[32,-71,88],[49,-81,97,],0xFFFFFF,[1441,1442,1443,1452,1453,1454],[1442,1443,1444,1453,1454,1455],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[32,-71,88],[33,-81,86],[49,-81,97,],0xFFFFFF,[1442,1443,1444,1453,1454,1455],[1444,1445,1446,1455,1456,1457],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[49,-81,97],[33,-81,86],[51,-91,94,],0xFFFFFF,[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402],[1444,1445,1446,1455,1456,1457],[1445,1446,1456,1457]],
[[33,-81,86],[35,-91,83],[51,-91,94,],0xFFFFFF,[1444,1445,1446,1455,1456,1457],[1446,1457],[1445,1446,1456,1457]],
[[29,-31,90],[29,-41,90],[46,-41,102,],0xFFFFFF,[1423,1424,1432,1433,1436,1447],[1436,1437,1438,1447,1448,1449],[1424,1433,1436,1437,1447,1448]],
[[46,-41,102],[29,-41,90],[47,-51,102,],0xFFFFFF,[1424,1433,1436,1437,1447,1448],[1436,1437,1438,1447,1448,1449],[1437,1438,1439,1448,1449,1450]],
[[29,-41,90],[30,-51,90],[47,-51,102,],0xFFFFFF,[1436,1437,1438,1447,1448,1449],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[1437,1438,1439,1448,1449,1450]],
[[47,-51,102],[30,-51,90],[47,-61,101,],0xFFFFFF,[1437,1438,1439,1448,1449,1450],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[1439,1440,1441,1450,1451,1452]],
[[30,-51,90],[30,-61,89],[47,-61,101,],0xFFFFFF,[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[1440,1441,1442,1451,1452,1453],[1439,1440,1441,1450,1451,1452]],
[[47,-61,101],[30,-61,89],[48,-71,99,],0xFFFFFF,[1439,1440,1441,1450,1451,1452],[1440,1441,1442,1451,1452,1453],[1441,1442,1443,1452,1453,1454]],
[[30,-61,89],[32,-71,88],[48,-71,99,],0xFFFFFF,[1440,1441,1442,1451,1452,1453],[1442,1443,1444,1453,1454,1455],[1441,1442,1443,1452,1453,1454]],
[[48,-71,99],[32,-71,88],[49,-81,97,],0xFFFFFF,[1441,1442,1443,1452,1453,1454],[1442,1443,1444,1453,1454,1455],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[32,-71,88],[33,-81,86],[49,-81,97,],0xFFFFFF,[1442,1443,1444,1453,1454,1455],[1444,1445,1446,1455,1456,1457],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[49,-81,97],[33,-81,86],[51,-91,94,],0xFFFFFF,[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402],[1444,1445,1446,1455,1456,1457],[1445,1446,1456,1457]],
[[33,-81,86],[35,-91,83],[51,-91,94,],0xFFFFFF,[1444,1445,1446,1455,1456,1457],[1446,1457],[1445,1446,1456,1457]],
[[81,60,70],[68,60,64],[74,55,87,],0xFFFFFF,[1458,1461,3404,3436],[1458,1459,1461,1462,3404,3405,3436,3437],[1458,1459,1460,1461,1462,1463]],
[[68,60,64],[59,55,80],[74,55,87,],0xFFFFFF,[1458,1459,1461,1462,3404,3405,3436,3437],[1459,1460,1462,1463,1464,1470],[1458,1459,1460,1461,1462,1463]],
[[74,55,87],[59,55,80],[71,49,95,],0xFFFFFF,[1458,1459,1460,1461,1462,1463],[1459,1460,1462,1463,1464,1470],[1460,1463,1464,1465,1470,1471]],
[[81,60,70],[68,60,64],[74,55,87,],0xFFFFFF,[1458,1461,3404,3436],[1458,1459,1461,1462,3404,3405,3436,3437],[1458,1459,1460,1461,1462,1463]],
[[68,60,64],[59,55,80],[74,55,87,],0xFFFFFF,[1458,1459,1461,1462,3404,3405,3436,3437],[1459,1460,1462,1463,1464,1470],[1458,1459,1460,1461,1462,1463]],
[[74,55,87],[59,55,80],[71,49,95,],0xFFFFFF,[1458,1459,1460,1461,1462,1463],[1459,1460,1462,1463,1464,1470],[1460,1463,1464,1465,1470,1471]],
[[59,55,80],[55,49,87],[71,49,95,],0xFFFFFF,[1459,1460,1462,1463,1464,1470],[1464,1465,1466,1470,1471,1472],[1460,1463,1464,1465,1470,1471]],
[[71,49,95],[55,49,87],[69,39,101,],0xFFFFFF,[1460,1463,1464,1465,1470,1471],[1464,1465,1466,1470,1471,1472],[1465,1466,1467,1471,1472,1473]],
[[55,49,87],[52,39,93],[69,39,101,],0xFFFFFF,[1464,1465,1466,1470,1471,1472],[1466,1467,1468,1472,1473,1474],[1465,1466,1467,1471,1472,1473]],
[[69,39,101],[52,39,93],[68,29,104,],0xFFFFFF,[1465,1466,1467,1471,1472,1473],[1466,1467,1468,1472,1473,1474],[1467,1468,1469,1473,1474,1475]],
[[52,39,93],[50,29,95],[68,29,104,],0xFFFFFF,[1466,1467,1468,1472,1473,1474],[1468,1469,1474,1475,1476,1478],[1467,1468,1469,1473,1474,1475]],
[[68,29,104],[50,29,95],[67,19,106,],0xFFFFFF,[1467,1468,1469,1473,1474,1475],[1468,1469,1474,1475,1476,1478],[1469,1475,1476,1477,1478,1479]],
[[59,55,80],[55,49,87],[71,49,95,],0xFFFFFF,[1459,1460,1462,1463,1464,1470],[1464,1465,1466,1470,1471,1472],[1460,1463,1464,1465,1470,1471]],
[[71,49,95],[55,49,87],[69,39,101,],0xFFFFFF,[1460,1463,1464,1465,1470,1471],[1464,1465,1466,1470,1471,1472],[1465,1466,1467,1471,1472,1473]],
[[55,49,87],[52,39,93],[69,39,101,],0xFFFFFF,[1464,1465,1466,1470,1471,1472],[1466,1467,1468,1472,1473,1474],[1465,1466,1467,1471,1472,1473]],
[[69,39,101],[52,39,93],[68,29,104,],0xFFFFFF,[1465,1466,1467,1471,1472,1473],[1466,1467,1468,1472,1473,1474],[1467,1468,1469,1473,1474,1475]],
[[52,39,93],[50,29,95],[68,29,104,],0xFFFFFF,[1466,1467,1468,1472,1473,1474],[1468,1469,1474,1475,1476,1478],[1467,1468,1469,1473,1474,1475]],
[[68,29,104],[50,29,95],[67,19,106,],0xFFFFFF,[1467,1468,1469,1473,1474,1475],[1468,1469,1474,1475,1476,1478],[1469,1475,1476,1477,1478,1479]],
[[50,29,95],[49,19,97],[67,19,106,],0xFFFFFF,[1468,1469,1474,1475,1476,1478],[1476,1477,1478,1479,1498,1499],[1469,1475,1476,1477,1478,1479]],
[[67,19,106],[49,19,97],[66,9,107,],0xFFFFFF,[1469,1475,1476,1477,1478,1479],[1476,1477,1478,1479,1498,1499],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[50,29,95],[49,19,97],[67,19,106,],0xFFFFFF,[1468,1469,1474,1475,1476,1478],[1476,1477,1478,1479,1498,1499],[1469,1475,1476,1477,1478,1479]],
[[67,19,106],[49,19,97],[66,9,107,],0xFFFFFF,[1469,1475,1476,1477,1478,1479],[1476,1477,1478,1479,1498,1499],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[66,9,107],[48,9,99],[66,-1,109,],0xFFFFFF,[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[1480,1481,1489,1490,1498,1499],[1480,1481,1482,1489,1490,1491]],
[[48,9,99],[47,-1,100],[66,-1,109,],0xFFFFFF,[1480,1481,1489,1490,1498,1499],[1481,1482,1483,1490,1491,1492],[1480,1481,1482,1489,1490,1491]],
[[66,-1,109],[47,-1,100],[65,-11,110,],0xFFFFFF,[1480,1481,1482,1489,1490,1491],[1481,1482,1483,1490,1491,1492],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[47,-1,100],[47,-11,101],[65,-11,110,],0xFFFFFF,[1481,1482,1483,1490,1491,1492],[1483,1484,1485,1492,1493,1494],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[65,-11,110],[47,-11,101],[65,-21,111,],0xFFFFFF,[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1483,1484,1485,1492,1493,1494],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519]],
[[47,-11,101],[46,-21,102],[65,-21,111,],0xFFFFFF,[1483,1484,1485,1492,1493,1494],[1485,1486,1487,1494,1495,1496],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519]],
[[65,-21,111],[46,-21,102],[65,-31,111,],0xFFFFFF,[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[1485,1486,1487,1494,1495,1496],[1486,1487,1488,1495,1496,1497]],
[[46,-21,102],[46,-31,102],[65,-31,111,],0xFFFFFF,[1485,1486,1487,1494,1495,1496],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1486,1487,1488,1495,1496,1497]],
[[65,-31,111],[46,-31,102],[65,-41,111,],0xFFFFFF,[1486,1487,1488,1495,1496,1497],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1488,1497,1500,1501,1511,1512]],
[[66,9,107],[48,9,99],[66,-1,109,],0xFFFFFF,[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[1480,1481,1489,1490,1498,1499],[1480,1481,1482,1489,1490,1491]],
[[48,9,99],[47,-1,100],[66,-1,109,],0xFFFFFF,[1480,1481,1489,1490,1498,1499],[1481,1482,1483,1490,1491,1492],[1480,1481,1482,1489,1490,1491]],
[[66,-1,109],[47,-1,100],[65,-11,110,],0xFFFFFF,[1480,1481,1482,1489,1490,1491],[1481,1482,1483,1490,1491,1492],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[47,-1,100],[47,-11,101],[65,-11,110,],0xFFFFFF,[1481,1482,1483,1490,1491,1492],[1483,1484,1485,1492,1493,1494],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[65,-11,110],[47,-11,101],[65,-21,111,],0xFFFFFF,[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1483,1484,1485,1492,1493,1494],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519]],
[[47,-11,101],[46,-21,102],[65,-21,111,],0xFFFFFF,[1483,1484,1485,1492,1493,1494],[1485,1486,1487,1494,1495,1496],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519]],
[[65,-21,111],[46,-21,102],[65,-31,111,],0xFFFFFF,[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[1485,1486,1487,1494,1495,1496],[1486,1487,1488,1495,1496,1497]],
[[46,-21,102],[46,-31,102],[65,-31,111,],0xFFFFFF,[1485,1486,1487,1494,1495,1496],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1486,1487,1488,1495,1496,1497]],
[[65,-31,111],[46,-31,102],[65,-41,111,],0xFFFFFF,[1486,1487,1488,1495,1496,1497],[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1488,1497,1500,1501,1511,1512]],
[[49,19,97],[48,9,99],[66,9,107,],0xFFFFFF,[1476,1477,1478,1479,1498,1499],[1480,1481,1489,1490,1498,1499],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[49,19,97],[48,9,99],[66,9,107,],0xFFFFFF,[1476,1477,1478,1479,1498,1499],[1480,1481,1489,1490,1498,1499],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[46,-31,102],[46,-41,102],[65,-41,111,],0xFFFFFF,[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1500,1501,1502,1511,1512,1513],[1488,1497,1500,1501,1511,1512]],
[[65,-41,111],[46,-41,102],[65,-51,110,],0xFFFFFF,[1488,1497,1500,1501,1511,1512],[1500,1501,1502,1511,1512,1513],[1501,1502,1503,1512,1513,1514]],
[[46,-41,102],[47,-51,102],[65,-51,110,],0xFFFFFF,[1500,1501,1502,1511,1512,1513],[1502,1503,1504,1513,1514,1515],[1501,1502,1503,1512,1513,1514]],
[[65,-51,110],[47,-51,102],[66,-61,109,],0xFFFFFF,[1501,1502,1503,1512,1513,1514],[1502,1503,1504,1513,1514,1515],[1503,1504,1505,1514,1515,1516]],
[[47,-51,102],[47,-61,101],[66,-61,109,],0xFFFFFF,[1502,1503,1504,1513,1514,1515],[1504,1505,1506,1515,1516,1517],[1503,1504,1505,1514,1515,1516]],
[[66,-61,109],[47,-61,101],[66,-71,108,],0xFFFFFF,[1503,1504,1505,1514,1515,1516],[1504,1505,1506,1515,1516,1517],[1505,1506,1507,1516,1517,1518]],
[[47,-61,101],[48,-71,99],[66,-71,108,],0xFFFFFF,[1504,1505,1506,1515,1516,1517],[1506,1507,1508,1517,1518,1519],[1505,1506,1507,1516,1517,1518]],
[[66,-71,108],[48,-71,99],[67,-81,105,],0xFFFFFF,[1505,1506,1507,1516,1517,1518],[1506,1507,1508,1517,1518,1519],[1507,1508,1509,1518,1519,1520,5373]],
[[48,-71,99],[49,-81,97],[67,-81,105,],0xFFFFFF,[1506,1507,1508,1517,1518,1519],[1508,1509,1510,1519,1520,1521],[1507,1508,1509,1518,1519,1520,5373]],
[[67,-81,105],[49,-81,97],[68,-91,102,],0xFFFFFF,[1507,1508,1509,1518,1519,1520,5373],[1508,1509,1510,1519,1520,1521],[1509,1510,1520,1521,3499,3531]],
[[49,-81,97],[51,-91,94],[68,-91,102,],0xFFFFFF,[1508,1509,1510,1519,1520,1521],[1510,1521],[1509,1510,1520,1521,3499,3531]],
[[46,-31,102],[46,-41,102],[65,-41,111,],0xFFFFFF,[1422,1423,1424,1431,1432,1433,1487,1488,1496,1497,1500,1511],[1500,1501,1502,1511,1512,1513],[1488,1497,1500,1501,1511,1512]],
[[65,-41,111],[46,-41,102],[65,-51,110,],0xFFFFFF,[1488,1497,1500,1501,1511,1512],[1500,1501,1502,1511,1512,1513],[1501,1502,1503,1512,1513,1514]],
[[46,-41,102],[47,-51,102],[65,-51,110,],0xFFFFFF,[1500,1501,1502,1511,1512,1513],[1502,1503,1504,1513,1514,1515],[1501,1502,1503,1512,1513,1514]],
[[65,-51,110],[47,-51,102],[66,-61,109,],0xFFFFFF,[1501,1502,1503,1512,1513,1514],[1502,1503,1504,1513,1514,1515],[1503,1504,1505,1514,1515,1516]],
[[47,-51,102],[47,-61,101],[66,-61,109,],0xFFFFFF,[1502,1503,1504,1513,1514,1515],[1504,1505,1506,1515,1516,1517],[1503,1504,1505,1514,1515,1516]],
[[66,-61,109],[47,-61,101],[66,-71,108,],0xFFFFFF,[1503,1504,1505,1514,1515,1516],[1504,1505,1506,1515,1516,1517],[1505,1506,1507,1516,1517,1518]],
[[47,-61,101],[48,-71,99],[66,-71,108,],0xFFFFFF,[1504,1505,1506,1515,1516,1517],[1506,1507,1508,1517,1518,1519],[1505,1506,1507,1516,1517,1518]],
[[66,-71,108],[48,-71,99],[67,-81,105,],0xFFFFFF,[1505,1506,1507,1516,1517,1518],[1506,1507,1508,1517,1518,1519],[1507,1508,1509,1518,1519,1520,5373]],
[[48,-71,99],[49,-81,97],[67,-81,105,],0xFFFFFF,[1506,1507,1508,1517,1518,1519],[1508,1509,1510,1519,1520,1521],[1507,1508,1509,1518,1519,1520,5373]],
[[67,-81,105],[49,-81,97],[68,-91,102,],0xFFFFFF,[1507,1508,1509,1518,1519,1520,5373],[1508,1509,1510,1519,1520,1521],[1509,1510,1520,1521,3499,3531]],
[[49,-81,97],[51,-91,94],[68,-91,102,],0xFFFFFF,[1508,1509,1510,1519,1520,1521],[1510,1521],[1509,1510,1520,1521,3499,3531]],
[[94,60,73],[80,60,69],[89,55,91,],0xFFFFFF,[1522,1525,3468,3500],[1522,1523,1525,1526,3468,3469,3500,3501],[1522,1523,1524,1525,1526,1527]],
[[80,60,69],[74,55,87],[89,55,91,],0xFFFFFF,[1522,1523,1525,1526,3468,3469,3500,3501],[1523,1524,1526,1527,1528,1534],[1522,1523,1524,1525,1526,1527]],
[[89,55,91],[74,55,87],[88,49,99,],0xFFFFFF,[1522,1523,1524,1525,1526,1527],[1523,1524,1526,1527,1528,1534],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[94,60,73],[80,60,69],[89,55,91,],0xFFFFFF,[1522,1525,3468,3500],[1522,1523,1525,1526,3468,3469,3500,3501],[1522,1523,1524,1525,1526,1527]],
[[80,60,69],[74,55,87],[89,55,91,],0xFFFFFF,[1522,1523,1525,1526,3468,3469,3500,3501],[1523,1524,1526,1527,1528,1534],[1522,1523,1524,1525,1526,1527]],
[[89,55,91],[74,55,87],[88,49,99,],0xFFFFFF,[1522,1523,1524,1525,1526,1527],[1523,1524,1526,1527,1528,1534],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[74,55,87],[71,49,95],[88,49,99,],0xFFFFFF,[1523,1524,1526,1527,1528,1534],[1528,1529,1530,1534,1535,1536],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[88,49,99],[71,49,95],[87,39,106,],0xFFFFFF,[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504],[1528,1529,1530,1534,1535,1536],[1529,1530,1531,1535,1536,1537]],
[[71,49,95],[69,39,101],[87,39,106,],0xFFFFFF,[1528,1529,1530,1534,1535,1536],[1530,1531,1532,1536,1537,1538],[1529,1530,1531,1535,1536,1537]],
[[87,39,106],[69,39,101],[86,29,109,],0xFFFFFF,[1529,1530,1531,1535,1536,1537],[1530,1531,1532,1536,1537,1538],[1531,1532,1533,1537,1538,1539]],
[[69,39,101],[68,29,104],[86,29,109,],0xFFFFFF,[1530,1531,1532,1536,1537,1538],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[1531,1532,1533,1537,1538,1539]],
[[86,29,109],[68,29,104],[86,19,111,],0xFFFFFF,[1531,1532,1533,1537,1538,1539],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[1533,1539,1540,1541,1542,1543]],
[[74,55,87],[71,49,95],[88,49,99,],0xFFFFFF,[1523,1524,1526,1527,1528,1534],[1528,1529,1530,1534,1535,1536],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[88,49,99],[71,49,95],[87,39,106,],0xFFFFFF,[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504],[1528,1529,1530,1534,1535,1536],[1529,1530,1531,1535,1536,1537]],
[[71,49,95],[69,39,101],[87,39,106,],0xFFFFFF,[1528,1529,1530,1534,1535,1536],[1530,1531,1532,1536,1537,1538],[1529,1530,1531,1535,1536,1537]],
[[87,39,106],[69,39,101],[86,29,109,],0xFFFFFF,[1529,1530,1531,1535,1536,1537],[1530,1531,1532,1536,1537,1538],[1531,1532,1533,1537,1538,1539]],
[[69,39,101],[68,29,104],[86,29,109,],0xFFFFFF,[1530,1531,1532,1536,1537,1538],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[1531,1532,1533,1537,1538,1539]],
[[86,29,109],[68,29,104],[86,19,111,],0xFFFFFF,[1531,1532,1533,1537,1538,1539],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[1533,1539,1540,1541,1542,1543]],
[[68,29,104],[67,19,106],[86,19,111,],0xFFFFFF,[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[1540,1541,1542,1543,1562,1563],[1533,1539,1540,1541,1542,1543]],
[[86,19,111],[67,19,106],[86,9,113,],0xFFFFFF,[1533,1539,1540,1541,1542,1543],[1540,1541,1542,1543,1562,1563],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[68,29,104],[67,19,106],[86,19,111,],0xFFFFFF,[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[1540,1541,1542,1543,1562,1563],[1533,1539,1540,1541,1542,1543]],
[[86,19,111],[67,19,106],[86,9,113,],0xFFFFFF,[1533,1539,1540,1541,1542,1543],[1540,1541,1542,1543,1562,1563],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[86,9,113],[66,9,107],[85,-1,114,],0xFFFFFF,[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512],[1544,1545,1553,1554,1562,1563],[1544,1545,1546,1553,1554,1555]],
[[66,9,107],[66,-1,109],[85,-1,114,],0xFFFFFF,[1544,1545,1553,1554,1562,1563],[1545,1546,1547,1554,1555,1556],[1544,1545,1546,1553,1554,1555]],
[[85,-1,114],[66,-1,109],[85,-11,115,],0xFFFFFF,[1544,1545,1546,1553,1554,1555],[1545,1546,1547,1554,1555,1556],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[66,-1,109],[65,-11,110],[85,-11,115,],0xFFFFFF,[1545,1546,1547,1554,1555,1556],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[85,-11,115],[65,-11,110],[85,-21,116,],0xFFFFFF,[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1548,1549,1550,1557,1558,1559]],
[[65,-11,110],[65,-21,111],[85,-21,116,],0xFFFFFF,[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1549,1550,1551,1558,1559,1560],[1548,1549,1550,1557,1558,1559]],
[[85,-21,116],[65,-21,111],[85,-31,116,],0xFFFFFF,[1548,1549,1550,1557,1558,1559],[1549,1550,1551,1558,1559,1560],[1550,1551,1552,1559,1560,1561]],
[[65,-21,111],[65,-31,111],[85,-31,116,],0xFFFFFF,[1549,1550,1551,1558,1559,1560],[1551,1552,1560,1561,1564,1575],[1550,1551,1552,1559,1560,1561]],
[[85,-31,116],[65,-31,111],[85,-41,116,],0xFFFFFF,[1550,1551,1552,1559,1560,1561],[1551,1552,1560,1561,1564,1575],[1552,1561,1564,1565,1575,1576]],
[[86,9,113],[66,9,107],[85,-1,114,],0xFFFFFF,[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512],[1544,1545,1553,1554,1562,1563],[1544,1545,1546,1553,1554,1555]],
[[66,9,107],[66,-1,109],[85,-1,114,],0xFFFFFF,[1544,1545,1553,1554,1562,1563],[1545,1546,1547,1554,1555,1556],[1544,1545,1546,1553,1554,1555]],
[[85,-1,114],[66,-1,109],[85,-11,115,],0xFFFFFF,[1544,1545,1546,1553,1554,1555],[1545,1546,1547,1554,1555,1556],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[66,-1,109],[65,-11,110],[85,-11,115,],0xFFFFFF,[1545,1546,1547,1554,1555,1556],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[85,-11,115],[65,-11,110],[85,-21,116,],0xFFFFFF,[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1548,1549,1550,1557,1558,1559]],
[[65,-11,110],[65,-21,111],[85,-21,116,],0xFFFFFF,[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[1549,1550,1551,1558,1559,1560],[1548,1549,1550,1557,1558,1559]],
[[85,-21,116],[65,-21,111],[85,-31,116,],0xFFFFFF,[1548,1549,1550,1557,1558,1559],[1549,1550,1551,1558,1559,1560],[1550,1551,1552,1559,1560,1561]],
[[65,-21,111],[65,-31,111],[85,-31,116,],0xFFFFFF,[1549,1550,1551,1558,1559,1560],[1551,1552,1560,1561,1564,1575],[1550,1551,1552,1559,1560,1561]],
[[85,-31,116],[65,-31,111],[85,-41,116,],0xFFFFFF,[1550,1551,1552,1559,1560,1561],[1551,1552,1560,1561,1564,1575],[1552,1561,1564,1565,1575,1576]],
[[67,19,106],[66,9,107],[86,9,113,],0xFFFFFF,[1540,1541,1542,1543,1562,1563],[1544,1545,1553,1554,1562,1563],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[67,19,106],[66,9,107],[86,9,113,],0xFFFFFF,[1540,1541,1542,1543,1562,1563],[1544,1545,1553,1554,1562,1563],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[65,-31,111],[65,-41,111],[85,-41,116,],0xFFFFFF,[1551,1552,1560,1561,1564,1575],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1552,1561,1564,1565,1575,1576]],
[[85,-41,116],[65,-41,111],[85,-51,116,],0xFFFFFF,[1552,1561,1564,1565,1575,1576],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1565,1566,1567,1576,1577,1578]],
[[65,-41,111],[65,-51,110],[85,-51,116,],0xFFFFFF,[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[1565,1566,1567,1576,1577,1578]],
[[85,-51,116],[65,-51,110],[85,-61,114,],0xFFFFFF,[1565,1566,1567,1576,1577,1578],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[1567,1568,1569,1578,1579,1580]],
[[65,-51,110],[66,-61,109],[85,-61,114,],0xFFFFFF,[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[1568,1569,1570,1579,1580,1581],[1567,1568,1569,1578,1579,1580]],
[[85,-61,114],[66,-61,109],[86,-71,113,],0xFFFFFF,[1567,1568,1569,1578,1579,1580],[1568,1569,1570,1579,1580,1581],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647]],
[[66,-61,109],[66,-71,108],[86,-71,113,],0xFFFFFF,[1568,1569,1570,1579,1580,1581],[1570,1571,1572,1581,1582,1583],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647]],
[[86,-71,113],[66,-71,108],[86,-81,110,],0xFFFFFF,[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[1570,1571,1572,1581,1582,1583],[1571,1572,1573,1582,1583,1584]],
[[66,-71,108],[67,-81,105],[86,-81,110,],0xFFFFFF,[1570,1571,1572,1581,1582,1583],[1572,1573,1574,1583,1584,1585],[1571,1572,1573,1582,1583,1584]],
[[86,-81,110],[67,-81,105],[87,-91,107,],0xFFFFFF,[1571,1572,1573,1582,1583,1584],[1572,1573,1574,1583,1584,1585],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[67,-81,105],[68,-91,102],[87,-91,107,],0xFFFFFF,[1572,1573,1574,1583,1584,1585],[1574,1585],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[65,-31,111],[65,-41,111],[85,-41,116,],0xFFFFFF,[1551,1552,1560,1561,1564,1575],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1552,1561,1564,1565,1575,1576]],
[[85,-41,116],[65,-41,111],[85,-51,116,],0xFFFFFF,[1552,1561,1564,1565,1575,1576],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1565,1566,1567,1576,1577,1578]],
[[65,-41,111],[65,-51,110],[85,-51,116,],0xFFFFFF,[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[1565,1566,1567,1576,1577,1578]],
[[85,-51,116],[65,-51,110],[85,-61,114,],0xFFFFFF,[1565,1566,1567,1576,1577,1578],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[1567,1568,1569,1578,1579,1580]],
[[65,-51,110],[66,-61,109],[85,-61,114,],0xFFFFFF,[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[1568,1569,1570,1579,1580,1581],[1567,1568,1569,1578,1579,1580]],
[[85,-61,114],[66,-61,109],[86,-71,113,],0xFFFFFF,[1567,1568,1569,1578,1579,1580],[1568,1569,1570,1579,1580,1581],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647]],
[[66,-61,109],[66,-71,108],[86,-71,113,],0xFFFFFF,[1568,1569,1570,1579,1580,1581],[1570,1571,1572,1581,1582,1583],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647]],
[[86,-71,113],[66,-71,108],[86,-81,110,],0xFFFFFF,[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[1570,1571,1572,1581,1582,1583],[1571,1572,1573,1582,1583,1584]],
[[66,-71,108],[67,-81,105],[86,-81,110,],0xFFFFFF,[1570,1571,1572,1581,1582,1583],[1572,1573,1574,1583,1584,1585],[1571,1572,1573,1582,1583,1584]],
[[86,-81,110],[67,-81,105],[87,-91,107,],0xFFFFFF,[1571,1572,1573,1582,1583,1584],[1572,1573,1574,1583,1584,1585],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[67,-81,105],[68,-91,102],[87,-91,107,],0xFFFFFF,[1572,1573,1574,1583,1584,1585],[1574,1585],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[107,60,74],[93,60,73],[105,55,92,],0xFFFFFF,[559,729,1586,1589,2371,2664],[1586,1587,1589,1590],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[93,60,73],[89,55,91],[105,55,92,],0xFFFFFF,[1586,1587,1589,1590],[1587,1588,1590,1591,1592,1598],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[105,55,92],[89,55,91],[106,49,101,],0xFFFFFF,[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[1587,1588,1590,1591,1592,1598],[1588,1591,1592,1593,1598,1599]],
[[107,60,74],[93,60,73],[105,55,92,],0xFFFFFF,[559,729,1586,1589,2371,2664],[1586,1587,1589,1590],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[93,60,73],[89,55,91],[105,55,92,],0xFFFFFF,[1586,1587,1589,1590],[1587,1588,1590,1591,1592,1598],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[105,55,92],[89,55,91],[106,49,101,],0xFFFFFF,[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[1587,1588,1590,1591,1592,1598],[1588,1591,1592,1593,1598,1599]],
[[89,55,91],[88,49,99],[106,49,101,],0xFFFFFF,[1587,1588,1590,1591,1592,1598],[1592,1593,1594,1598,1599,1600],[1588,1591,1592,1593,1598,1599]],
[[106,49,101],[88,49,99],[105,39,107,],0xFFFFFF,[1588,1591,1592,1593,1598,1599],[1592,1593,1594,1598,1599,1600],[1593,1594,1595,1599,1600,1601]],
[[88,49,99],[87,39,106],[105,39,107,],0xFFFFFF,[1592,1593,1594,1598,1599,1600],[1594,1595,1596,1600,1601,1602],[1593,1594,1595,1599,1600,1601]],
[[105,39,107],[87,39,106],[106,29,110,],0xFFFFFF,[1593,1594,1595,1599,1600,1601],[1594,1595,1596,1600,1601,1602],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[87,39,106],[86,29,109],[106,29,110,],0xFFFFFF,[1594,1595,1596,1600,1601,1602],[1596,1597,1602,1603,1604,1606],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[106,29,110],[86,29,109],[105,19,113,],0xFFFFFF,[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572],[1596,1597,1602,1603,1604,1606],[1597,1603,1604,1605,1606,1607]],
[[89,55,91],[88,49,99],[106,49,101,],0xFFFFFF,[1587,1588,1590,1591,1592,1598],[1592,1593,1594,1598,1599,1600],[1588,1591,1592,1593,1598,1599]],
[[106,49,101],[88,49,99],[105,39,107,],0xFFFFFF,[1588,1591,1592,1593,1598,1599],[1592,1593,1594,1598,1599,1600],[1593,1594,1595,1599,1600,1601]],
[[88,49,99],[87,39,106],[105,39,107,],0xFFFFFF,[1592,1593,1594,1598,1599,1600],[1594,1595,1596,1600,1601,1602],[1593,1594,1595,1599,1600,1601]],
[[105,39,107],[87,39,106],[106,29,110,],0xFFFFFF,[1593,1594,1595,1599,1600,1601],[1594,1595,1596,1600,1601,1602],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[87,39,106],[86,29,109],[106,29,110,],0xFFFFFF,[1594,1595,1596,1600,1601,1602],[1596,1597,1602,1603,1604,1606],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[106,29,110],[86,29,109],[105,19,113,],0xFFFFFF,[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572],[1596,1597,1602,1603,1604,1606],[1597,1603,1604,1605,1606,1607]],
[[86,29,109],[86,19,111],[105,19,113,],0xFFFFFF,[1596,1597,1602,1603,1604,1606],[1604,1605,1606,1607,1626,1627],[1597,1603,1604,1605,1606,1607]],
[[105,19,113],[86,19,111],[106,9,114,],0xFFFFFF,[1597,1603,1604,1605,1606,1607],[1604,1605,1606,1607,1626,1627],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[86,29,109],[86,19,111],[105,19,113,],0xFFFFFF,[1596,1597,1602,1603,1604,1606],[1604,1605,1606,1607,1626,1627],[1597,1603,1604,1605,1606,1607]],
[[105,19,113],[86,19,111],[106,9,114,],0xFFFFFF,[1597,1603,1604,1605,1606,1607],[1604,1605,1606,1607,1626,1627],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[106,9,114],[86,9,113],[105,-1,116,],0xFFFFFF,[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576],[1608,1609,1617,1618,1626,1627],[1608,1609,1610,1617,1618,1619]],
[[86,9,113],[85,-1,114],[105,-1,116,],0xFFFFFF,[1608,1609,1617,1618,1626,1627],[1609,1610,1611,1618,1619,1620],[1608,1609,1610,1617,1618,1619]],
[[105,-1,116],[85,-1,114],[106,-11,117,],0xFFFFFF,[1608,1609,1610,1617,1618,1619],[1609,1610,1611,1618,1619,1620],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[85,-1,114],[85,-11,115],[106,-11,117,],0xFFFFFF,[1609,1610,1611,1618,1619,1620],[1611,1612,1613,1620,1621,1622],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[106,-11,117],[85,-11,115],[106,-21,118,],0xFFFFFF,[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580],[1611,1612,1613,1620,1621,1622],[1612,1613,1614,1621,1622,1623]],
[[85,-11,115],[85,-21,116],[106,-21,118,],0xFFFFFF,[1611,1612,1613,1620,1621,1622],[1613,1614,1615,1622,1623,1624],[1612,1613,1614,1621,1622,1623]],
[[106,-21,118],[85,-21,116],[106,-31,118,],0xFFFFFF,[1612,1613,1614,1621,1622,1623],[1613,1614,1615,1622,1623,1624],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684]],
[[85,-21,116],[85,-31,116],[106,-31,118,],0xFFFFFF,[1613,1614,1615,1622,1623,1624],[1615,1616,1624,1625,1628,1639],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684]],
[[106,-31,118],[85,-31,116],[105,-41,118,],0xFFFFFF,[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[1615,1616,1624,1625,1628,1639],[1616,1625,1628,1629,1639,1640]],
[[106,9,114],[86,9,113],[105,-1,116,],0xFFFFFF,[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576],[1608,1609,1617,1618,1626,1627],[1608,1609,1610,1617,1618,1619]],
[[86,9,113],[85,-1,114],[105,-1,116,],0xFFFFFF,[1608,1609,1617,1618,1626,1627],[1609,1610,1611,1618,1619,1620],[1608,1609,1610,1617,1618,1619]],
[[105,-1,116],[85,-1,114],[106,-11,117,],0xFFFFFF,[1608,1609,1610,1617,1618,1619],[1609,1610,1611,1618,1619,1620],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[85,-1,114],[85,-11,115],[106,-11,117,],0xFFFFFF,[1609,1610,1611,1618,1619,1620],[1611,1612,1613,1620,1621,1622],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[106,-11,117],[85,-11,115],[106,-21,118,],0xFFFFFF,[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580],[1611,1612,1613,1620,1621,1622],[1612,1613,1614,1621,1622,1623]],
[[85,-11,115],[85,-21,116],[106,-21,118,],0xFFFFFF,[1611,1612,1613,1620,1621,1622],[1613,1614,1615,1622,1623,1624],[1612,1613,1614,1621,1622,1623]],
[[106,-21,118],[85,-21,116],[106,-31,118,],0xFFFFFF,[1612,1613,1614,1621,1622,1623],[1613,1614,1615,1622,1623,1624],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684]],
[[85,-21,116],[85,-31,116],[106,-31,118,],0xFFFFFF,[1613,1614,1615,1622,1623,1624],[1615,1616,1624,1625,1628,1639],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684]],
[[106,-31,118],[85,-31,116],[105,-41,118,],0xFFFFFF,[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[1615,1616,1624,1625,1628,1639],[1616,1625,1628,1629,1639,1640]],
[[86,19,111],[86,9,113],[106,9,114,],0xFFFFFF,[1604,1605,1606,1607,1626,1627],[1608,1609,1617,1618,1626,1627],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[86,19,111],[86,9,113],[106,9,114,],0xFFFFFF,[1604,1605,1606,1607,1626,1627],[1608,1609,1617,1618,1626,1627],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[85,-31,116],[85,-41,116],[105,-41,118,],0xFFFFFF,[1615,1616,1624,1625,1628,1639],[1628,1629,1630,1639,1640,1641],[1616,1625,1628,1629,1639,1640]],
[[105,-41,118],[85,-41,116],[105,-51,117,],0xFFFFFF,[1616,1625,1628,1629,1639,1640],[1628,1629,1630,1639,1640,1641],[1629,1630,1631,1640,1641,1642]],
[[85,-41,116],[85,-51,116],[105,-51,117,],0xFFFFFF,[1628,1629,1630,1639,1640,1641],[1630,1631,1632,1641,1642,1643],[1629,1630,1631,1640,1641,1642]],
[[105,-51,117],[85,-51,116],[105,-61,116,],0xFFFFFF,[1629,1630,1631,1640,1641,1642],[1630,1631,1632,1641,1642,1643],[1631,1632,1633,1642,1643,1644]],
[[85,-51,116],[85,-61,114],[105,-61,116,],0xFFFFFF,[1630,1631,1632,1641,1642,1643],[1632,1633,1634,1643,1644,1645],[1631,1632,1633,1642,1643,1644]],
[[105,-61,116],[85,-61,114],[105,-71,114,],0xFFFFFF,[1631,1632,1633,1642,1643,1644],[1632,1633,1634,1643,1644,1645],[1633,1634,1635,1644,1645,1646]],
[[85,-61,114],[86,-71,113],[105,-71,114,],0xFFFFFF,[1632,1633,1634,1643,1644,1645],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[1633,1634,1635,1644,1645,1646]],
[[105,-71,114],[86,-71,113],[105,-81,112,],0xFFFFFF,[1633,1634,1635,1644,1645,1646],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694]],
[[86,-71,113],[86,-81,110],[105,-81,112,],0xFFFFFF,[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[1636,1637,1638,1647,1648,1649],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694]],
[[105,-81,112],[86,-81,110],[106,-91,109,],0xFFFFFF,[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[1636,1637,1638,1647,1648,1649],[1637,1638,1648,1649]],
[[86,-81,110],[87,-91,107],[106,-91,109,],0xFFFFFF,[1636,1637,1638,1647,1648,1649],[1638,1649],[1637,1638,1648,1649]],
[[85,-31,116],[85,-41,116],[105,-41,118,],0xFFFFFF,[1615,1616,1624,1625,1628,1639],[1628,1629,1630,1639,1640,1641],[1616,1625,1628,1629,1639,1640]],
[[105,-41,118],[85,-41,116],[105,-51,117,],0xFFFFFF,[1616,1625,1628,1629,1639,1640],[1628,1629,1630,1639,1640,1641],[1629,1630,1631,1640,1641,1642]],
[[85,-41,116],[85,-51,116],[105,-51,117,],0xFFFFFF,[1628,1629,1630,1639,1640,1641],[1630,1631,1632,1641,1642,1643],[1629,1630,1631,1640,1641,1642]],
[[105,-51,117],[85,-51,116],[105,-61,116,],0xFFFFFF,[1629,1630,1631,1640,1641,1642],[1630,1631,1632,1641,1642,1643],[1631,1632,1633,1642,1643,1644]],
[[85,-51,116],[85,-61,114],[105,-61,116,],0xFFFFFF,[1630,1631,1632,1641,1642,1643],[1632,1633,1634,1643,1644,1645],[1631,1632,1633,1642,1643,1644]],
[[105,-61,116],[85,-61,114],[105,-71,114,],0xFFFFFF,[1631,1632,1633,1642,1643,1644],[1632,1633,1634,1643,1644,1645],[1633,1634,1635,1644,1645,1646]],
[[85,-61,114],[86,-71,113],[105,-71,114,],0xFFFFFF,[1632,1633,1634,1643,1644,1645],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[1633,1634,1635,1644,1645,1646]],
[[105,-71,114],[86,-71,113],[105,-81,112,],0xFFFFFF,[1633,1634,1635,1644,1645,1646],[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694]],
[[86,-71,113],[86,-81,110],[105,-81,112,],0xFFFFFF,[1569,1570,1571,1580,1581,1582,1634,1635,1636,1645,1646,1647],[1636,1637,1638,1647,1648,1649],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694]],
[[105,-81,112],[86,-81,110],[106,-91,109,],0xFFFFFF,[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[1636,1637,1638,1647,1648,1649],[1637,1638,1648,1649]],
[[86,-81,110],[87,-91,107],[106,-91,109,],0xFFFFFF,[1636,1637,1638,1647,1648,1649],[1638,1649],[1637,1638,1648,1649]],
[[176,60,-24],[179,60,-10],[193,55,-30,],0xFFFFFF,[1650,1656],[1650,1651,1656,1657],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[179,60,-10],[197,55,-14],[193,55,-30,],0xFFFFFF,[1650,1651,1656,1657],[1651,1652,1653,1657,1658,1659],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[193,55,-30],[197,55,-14],[201,49,-33,],0xFFFFFF,[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604],[1651,1652,1653,1657,1658,1659],[1652,1653,1654,1658,1659,1660]],
[[197,55,-14],[206,49,-15],[201,49,-33,],0xFFFFFF,[1651,1652,1653,1657,1658,1659],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[1652,1653,1654,1658,1659,1660]],
[[201,49,-33],[206,49,-15],[207,39,-35,],0xFFFFFF,[1652,1653,1654,1658,1659,1660],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[1654,1655,1660,1661,1662,1672]],
[[206,49,-15],[212,39,-16],[207,39,-35,],0xFFFFFF,[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[1655,1661,1662,1663,1672,1673],[1654,1655,1660,1661,1662,1672]],
[[176,60,-24],[179,60,-10],[193,55,-30,],0xFFFFFF,[1650,1656],[1650,1651,1656,1657],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[179,60,-10],[197,55,-14],[193,55,-30,],0xFFFFFF,[1650,1651,1656,1657],[1651,1652,1653,1657,1658,1659],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[193,55,-30],[197,55,-14],[201,49,-33,],0xFFFFFF,[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604],[1651,1652,1653,1657,1658,1659],[1652,1653,1654,1658,1659,1660]],
[[197,55,-14],[206,49,-15],[201,49,-33,],0xFFFFFF,[1651,1652,1653,1657,1658,1659],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[1652,1653,1654,1658,1659,1660]],
[[201,49,-33],[206,49,-15],[207,39,-35,],0xFFFFFF,[1652,1653,1654,1658,1659,1660],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[1654,1655,1660,1661,1662,1672]],
[[206,49,-15],[212,39,-16],[207,39,-35,],0xFFFFFF,[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[1655,1661,1662,1663,1672,1673],[1654,1655,1660,1661,1662,1672]],
[[207,39,-35],[212,39,-16],[210,29,-36,],0xFFFFFF,[1654,1655,1660,1661,1662,1672],[1655,1661,1662,1663,1672,1673],[1662,1663,1664,1672,1673,1674]],
[[212,39,-16],[215,29,-17],[210,29,-36,],0xFFFFFF,[1655,1661,1662,1663,1672,1673],[1663,1664,1665,1673,1674,1675],[1662,1663,1664,1672,1673,1674]],
[[210,29,-36],[215,29,-17],[212,19,-36,],0xFFFFFF,[1662,1663,1664,1672,1673,1674],[1663,1664,1665,1673,1674,1675],[1664,1665,1666,1674,1675,1676]],
[[215,29,-17],[217,19,-17],[212,19,-36,],0xFFFFFF,[1663,1664,1665,1673,1674,1675],[1665,1666,1667,1675,1676,1677],[1664,1665,1666,1674,1675,1676]],
[[212,19,-36],[217,19,-17],[214,9,-37,],0xFFFFFF,[1664,1665,1666,1674,1675,1676],[1665,1666,1667,1675,1676,1677],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678]],
[[217,19,-17],[219,9,-17],[214,9,-37,],0xFFFFFF,[1665,1666,1667,1675,1676,1677],[1667,1668,1669,1677,1678,1679],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678]],
[[214,9,-37],[219,9,-17],[216,-1,-37,],0xFFFFFF,[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[1667,1668,1669,1677,1678,1679],[1668,1669,1670,1678,1679,1680]],
[[219,9,-17],[220,-1,-18],[216,-1,-37,],0xFFFFFF,[1667,1668,1669,1677,1678,1679],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1668,1669,1670,1678,1679,1680]],
[[216,-1,-37],[220,-1,-18],[217,-11,-38,],0xFFFFFF,[1668,1669,1670,1678,1679,1680],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1670,1671,1680,1681,1682,1690]],
[[220,-1,-18],[222,-11,-18],[217,-11,-38,],0xFFFFFF,[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1671,1681,1682,1683,1690,1691],[1670,1671,1680,1681,1682,1690]],
[[207,39,-35],[212,39,-16],[210,29,-36,],0xFFFFFF,[1654,1655,1660,1661,1662,1672],[1655,1661,1662,1663,1672,1673],[1662,1663,1664,1672,1673,1674]],
[[212,39,-16],[215,29,-17],[210,29,-36,],0xFFFFFF,[1655,1661,1662,1663,1672,1673],[1663,1664,1665,1673,1674,1675],[1662,1663,1664,1672,1673,1674]],
[[210,29,-36],[215,29,-17],[212,19,-36,],0xFFFFFF,[1662,1663,1664,1672,1673,1674],[1663,1664,1665,1673,1674,1675],[1664,1665,1666,1674,1675,1676]],
[[215,29,-17],[217,19,-17],[212,19,-36,],0xFFFFFF,[1663,1664,1665,1673,1674,1675],[1665,1666,1667,1675,1676,1677],[1664,1665,1666,1674,1675,1676]],
[[212,19,-36],[217,19,-17],[214,9,-37,],0xFFFFFF,[1664,1665,1666,1674,1675,1676],[1665,1666,1667,1675,1676,1677],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678]],
[[217,19,-17],[219,9,-17],[214,9,-37,],0xFFFFFF,[1665,1666,1667,1675,1676,1677],[1667,1668,1669,1677,1678,1679],[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678]],
[[214,9,-37],[219,9,-17],[216,-1,-37,],0xFFFFFF,[537,538,539,707,708,709,1666,1667,1668,1676,1677,1678],[1667,1668,1669,1677,1678,1679],[1668,1669,1670,1678,1679,1680]],
[[219,9,-17],[220,-1,-18],[216,-1,-37,],0xFFFFFF,[1667,1668,1669,1677,1678,1679],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1668,1669,1670,1678,1679,1680]],
[[216,-1,-37],[220,-1,-18],[217,-11,-38,],0xFFFFFF,[1668,1669,1670,1678,1679,1680],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1670,1671,1680,1681,1682,1690]],
[[220,-1,-18],[222,-11,-18],[217,-11,-38,],0xFFFFFF,[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1671,1681,1682,1683,1690,1691],[1670,1671,1680,1681,1682,1690]],
[[217,-11,-38],[222,-11,-18],[217,-21,-38,],0xFFFFFF,[1670,1671,1680,1681,1682,1690],[1671,1681,1682,1683,1690,1691],[1682,1683,1684,1690,1691,1692]],
[[222,-11,-18],[222,-21,-18],[217,-21,-38,],0xFFFFFF,[1671,1681,1682,1683,1690,1691],[1683,1684,1685,1691,1692,1693],[1682,1683,1684,1690,1691,1692]],
[[217,-21,-38],[222,-21,-18],[218,-31,-38,],0xFFFFFF,[1682,1683,1684,1690,1691,1692],[1683,1684,1685,1691,1692,1693],[1684,1685,1686,1692,1693,1694]],
[[222,-21,-18],[223,-31,-18],[218,-31,-38,],0xFFFFFF,[1683,1684,1685,1691,1692,1693],[1685,1686,1687,1693,1694,1695],[1684,1685,1686,1692,1693,1694]],
[[218,-31,-38],[223,-31,-18],[217,-41,-38,],0xFFFFFF,[1684,1685,1686,1692,1693,1694],[1685,1686,1687,1693,1694,1695],[1686,1687,1688,1694,1695,1696]],
[[223,-31,-18],[222,-41,-18],[217,-41,-38,],0xFFFFFF,[1685,1686,1687,1693,1694,1695],[1687,1688,1689,1695,1696,1697],[1686,1687,1688,1694,1695,1696]],
[[217,-41,-38],[222,-41,-18],[217,-51,-38,],0xFFFFFF,[1686,1687,1688,1694,1695,1696],[1687,1688,1689,1695,1696,1697],[1688,1689,1696,1697,1698,1706]],
[[222,-41,-18],[222,-51,-18],[217,-51,-38,],0xFFFFFF,[1687,1688,1689,1695,1696,1697],[1689,1697,1698,1699,1706,1707],[1688,1689,1696,1697,1698,1706]],
[[217,-11,-38],[222,-11,-18],[217,-21,-38,],0xFFFFFF,[1670,1671,1680,1681,1682,1690],[1671,1681,1682,1683,1690,1691],[1682,1683,1684,1690,1691,1692]],
[[222,-11,-18],[222,-21,-18],[217,-21,-38,],0xFFFFFF,[1671,1681,1682,1683,1690,1691],[1683,1684,1685,1691,1692,1693],[1682,1683,1684,1690,1691,1692]],
[[217,-21,-38],[222,-21,-18],[218,-31,-38,],0xFFFFFF,[1682,1683,1684,1690,1691,1692],[1683,1684,1685,1691,1692,1693],[1684,1685,1686,1692,1693,1694]],
[[222,-21,-18],[223,-31,-18],[218,-31,-38,],0xFFFFFF,[1683,1684,1685,1691,1692,1693],[1685,1686,1687,1693,1694,1695],[1684,1685,1686,1692,1693,1694]],
[[218,-31,-38],[223,-31,-18],[217,-41,-38,],0xFFFFFF,[1684,1685,1686,1692,1693,1694],[1685,1686,1687,1693,1694,1695],[1686,1687,1688,1694,1695,1696]],
[[223,-31,-18],[222,-41,-18],[217,-41,-38,],0xFFFFFF,[1685,1686,1687,1693,1694,1695],[1687,1688,1689,1695,1696,1697],[1686,1687,1688,1694,1695,1696]],
[[217,-41,-38],[222,-41,-18],[217,-51,-38,],0xFFFFFF,[1686,1687,1688,1694,1695,1696],[1687,1688,1689,1695,1696,1697],[1688,1689,1696,1697,1698,1706]],
[[222,-41,-18],[222,-51,-18],[217,-51,-38,],0xFFFFFF,[1687,1688,1689,1695,1696,1697],[1689,1697,1698,1699,1706,1707],[1688,1689,1696,1697,1698,1706]],
[[217,-51,-38],[222,-51,-18],[216,-61,-38,],0xFFFFFF,[1688,1689,1696,1697,1698,1706],[1689,1697,1698,1699,1706,1707],[1698,1699,1700,1706,1707,1708]],
[[222,-51,-18],[221,-61,-18],[216,-61,-38,],0xFFFFFF,[1689,1697,1698,1699,1706,1707],[1699,1700,1701,1707,1708,1709],[1698,1699,1700,1706,1707,1708]],
[[216,-61,-38],[221,-61,-18],[214,-71,-37,],0xFFFFFF,[1698,1699,1700,1706,1707,1708],[1699,1700,1701,1707,1708,1709],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[221,-61,-18],[219,-71,-17],[214,-71,-37,],0xFFFFFF,[1699,1700,1701,1707,1708,1709],[1701,1702,1703,1709,1710,1711],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[214,-71,-37],[219,-71,-17],[212,-81,-36,],0xFFFFFF,[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[1701,1702,1703,1709,1710,1711],[1702,1703,1704,1710,1711,1712]],
[[219,-71,-17],[217,-81,-17],[212,-81,-36,],0xFFFFFF,[1701,1702,1703,1709,1710,1711],[1703,1704,1705,1711,1712,1713],[1702,1703,1704,1710,1711,1712]],
[[212,-81,-36],[217,-81,-17],[209,-91,-35,],0xFFFFFF,[1702,1703,1704,1710,1711,1712],[1703,1704,1705,1711,1712,1713],[1704,1705,1712,1713]],
[[217,-81,-17],[213,-91,-17],[209,-91,-35,],0xFFFFFF,[1703,1704,1705,1711,1712,1713],[1705,1713],[1704,1705,1712,1713]],
[[217,-51,-38],[222,-51,-18],[216,-61,-38,],0xFFFFFF,[1688,1689,1696,1697,1698,1706],[1689,1697,1698,1699,1706,1707],[1698,1699,1700,1706,1707,1708]],
[[222,-51,-18],[221,-61,-18],[216,-61,-38,],0xFFFFFF,[1689,1697,1698,1699,1706,1707],[1699,1700,1701,1707,1708,1709],[1698,1699,1700,1706,1707,1708]],
[[216,-61,-38],[221,-61,-18],[214,-71,-37,],0xFFFFFF,[1698,1699,1700,1706,1707,1708],[1699,1700,1701,1707,1708,1709],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[221,-61,-18],[219,-71,-17],[214,-71,-37,],0xFFFFFF,[1699,1700,1701,1707,1708,1709],[1701,1702,1703,1709,1710,1711],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[214,-71,-37],[219,-71,-17],[212,-81,-36,],0xFFFFFF,[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[1701,1702,1703,1709,1710,1711],[1702,1703,1704,1710,1711,1712]],
[[219,-71,-17],[217,-81,-17],[212,-81,-36,],0xFFFFFF,[1701,1702,1703,1709,1710,1711],[1703,1704,1705,1711,1712,1713],[1702,1703,1704,1710,1711,1712]],
[[212,-81,-36],[217,-81,-17],[209,-91,-35,],0xFFFFFF,[1702,1703,1704,1710,1711,1712],[1703,1704,1705,1711,1712,1713],[1704,1705,1712,1713]],
[[217,-81,-17],[213,-91,-17],[209,-91,-35,],0xFFFFFF,[1703,1704,1705,1711,1712,1713],[1705,1713],[1704,1705,1712,1713]],
[[179,60,-11],[180,60,2],[197,55,-14,],0xFFFFFF,[1714,1720],[1714,1715,1720,1721],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[180,60,2],[198,55,1],[197,55,-14,],0xFFFFFF,[1714,1715,1720,1721],[1715,1716,1717,1721,1722,1723],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[197,55,-14],[198,55,1],[206,49,-15,],0xFFFFFF,[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668],[1715,1716,1717,1721,1722,1723],[1716,1717,1718,1722,1723,1724]],
[[198,55,1],[207,49,1],[206,49,-15,],0xFFFFFF,[1715,1716,1717,1721,1722,1723],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[1716,1717,1718,1722,1723,1724]],
[[206,49,-15],[207,49,1],[212,39,-16,],0xFFFFFF,[1716,1717,1718,1722,1723,1724],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[1718,1719,1724,1725,1726,1736]],
[[207,49,1],[213,39,1],[212,39,-16,],0xFFFFFF,[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[1719,1725,1726,1727,1736,1737],[1718,1719,1724,1725,1726,1736]],
[[179,60,-11],[180,60,2],[197,55,-14,],0xFFFFFF,[1714,1720],[1714,1715,1720,1721],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[180,60,2],[198,55,1],[197,55,-14,],0xFFFFFF,[1714,1715,1720,1721],[1715,1716,1717,1721,1722,1723],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[197,55,-14],[198,55,1],[206,49,-15,],0xFFFFFF,[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668],[1715,1716,1717,1721,1722,1723],[1716,1717,1718,1722,1723,1724]],
[[198,55,1],[207,49,1],[206,49,-15,],0xFFFFFF,[1715,1716,1717,1721,1722,1723],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[1716,1717,1718,1722,1723,1724]],
[[206,49,-15],[207,49,1],[212,39,-16,],0xFFFFFF,[1716,1717,1718,1722,1723,1724],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[1718,1719,1724,1725,1726,1736]],
[[207,49,1],[213,39,1],[212,39,-16,],0xFFFFFF,[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[1719,1725,1726,1727,1736,1737],[1718,1719,1724,1725,1726,1736]],
[[212,39,-16],[213,39,1],[215,29,-17,],0xFFFFFF,[1718,1719,1724,1725,1726,1736],[1719,1725,1726,1727,1736,1737],[1726,1727,1728,1736,1737,1738]],
[[213,39,1],[216,29,1],[215,29,-17,],0xFFFFFF,[1719,1725,1726,1727,1736,1737],[1727,1728,1729,1737,1738,1739],[1726,1727,1728,1736,1737,1738]],
[[215,29,-17],[216,29,1],[217,19,-17,],0xFFFFFF,[1726,1727,1728,1736,1737,1738],[1727,1728,1729,1737,1738,1739],[1728,1729,1730,1738,1739,1740]],
[[216,29,1],[218,19,1],[217,19,-17,],0xFFFFFF,[1727,1728,1729,1737,1738,1739],[1729,1730,1731,1739,1740,1741],[1728,1729,1730,1738,1739,1740]],
[[217,19,-17],[218,19,1],[219,9,-17,],0xFFFFFF,[1728,1729,1730,1738,1739,1740],[1729,1730,1731,1739,1740,1741],[1730,1731,1732,1740,1741,1742]],
[[218,19,1],[220,9,2],[219,9,-17,],0xFFFFFF,[1729,1730,1731,1739,1740,1741],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1730,1731,1732,1740,1741,1742]],
[[219,9,-17],[220,9,2],[220,-1,-18,],0xFFFFFF,[1730,1731,1732,1740,1741,1742],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744]],
[[220,9,2],[222,-1,2],[220,-1,-18,],0xFFFFFF,[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744]],
[[220,-1,-18],[222,-1,2],[222,-11,-18,],0xFFFFFF,[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1734,1735,1744,1745,1746,1754]],
[[222,-1,2],[223,-11,2],[222,-11,-18,],0xFFFFFF,[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1735,1745,1746,1747,1754,1755],[1734,1735,1744,1745,1746,1754]],
[[212,39,-16],[213,39,1],[215,29,-17,],0xFFFFFF,[1718,1719,1724,1725,1726,1736],[1719,1725,1726,1727,1736,1737],[1726,1727,1728,1736,1737,1738]],
[[213,39,1],[216,29,1],[215,29,-17,],0xFFFFFF,[1719,1725,1726,1727,1736,1737],[1727,1728,1729,1737,1738,1739],[1726,1727,1728,1736,1737,1738]],
[[215,29,-17],[216,29,1],[217,19,-17,],0xFFFFFF,[1726,1727,1728,1736,1737,1738],[1727,1728,1729,1737,1738,1739],[1728,1729,1730,1738,1739,1740]],
[[216,29,1],[218,19,1],[217,19,-17,],0xFFFFFF,[1727,1728,1729,1737,1738,1739],[1729,1730,1731,1739,1740,1741],[1728,1729,1730,1738,1739,1740]],
[[217,19,-17],[218,19,1],[219,9,-17,],0xFFFFFF,[1728,1729,1730,1738,1739,1740],[1729,1730,1731,1739,1740,1741],[1730,1731,1732,1740,1741,1742]],
[[218,19,1],[220,9,2],[219,9,-17,],0xFFFFFF,[1729,1730,1731,1739,1740,1741],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1730,1731,1732,1740,1741,1742]],
[[219,9,-17],[220,9,2],[220,-1,-18,],0xFFFFFF,[1730,1731,1732,1740,1741,1742],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744]],
[[220,9,2],[222,-1,2],[220,-1,-18,],0xFFFFFF,[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744]],
[[220,-1,-18],[222,-1,2],[222,-11,-18,],0xFFFFFF,[1669,1670,1671,1679,1680,1681,1732,1733,1734,1742,1743,1744],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1734,1735,1744,1745,1746,1754]],
[[222,-1,2],[223,-11,2],[222,-11,-18,],0xFFFFFF,[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1735,1745,1746,1747,1754,1755],[1734,1735,1744,1745,1746,1754]],
[[222,-11,-18],[223,-11,2],[222,-21,-18,],0xFFFFFF,[1734,1735,1744,1745,1746,1754],[1735,1745,1746,1747,1754,1755],[1746,1747,1748,1754,1755,1756]],
[[223,-11,2],[224,-21,2],[222,-21,-18,],0xFFFFFF,[1735,1745,1746,1747,1754,1755],[1747,1748,1749,1755,1756,1757],[1746,1747,1748,1754,1755,1756]],
[[222,-21,-18],[224,-21,2],[223,-31,-18,],0xFFFFFF,[1746,1747,1748,1754,1755,1756],[1747,1748,1749,1755,1756,1757],[1748,1749,1750,1756,1757,1758]],
[[224,-21,2],[224,-31,2],[223,-31,-18,],0xFFFFFF,[1747,1748,1749,1755,1756,1757],[1749,1750,1751,1757,1758,1759],[1748,1749,1750,1756,1757,1758]],
[[223,-31,-18],[224,-31,2],[222,-41,-18,],0xFFFFFF,[1748,1749,1750,1756,1757,1758],[1749,1750,1751,1757,1758,1759],[1750,1751,1752,1758,1759,1760]],
[[224,-31,2],[224,-41,2],[222,-41,-18,],0xFFFFFF,[1749,1750,1751,1757,1758,1759],[1751,1752,1753,1759,1760,1761],[1750,1751,1752,1758,1759,1760]],
[[222,-41,-18],[224,-41,2],[222,-51,-18,],0xFFFFFF,[1750,1751,1752,1758,1759,1760],[1751,1752,1753,1759,1760,1761],[1752,1753,1760,1761,1762,1770]],
[[224,-41,2],[223,-51,2],[222,-51,-18,],0xFFFFFF,[1751,1752,1753,1759,1760,1761],[1753,1761,1762,1763,1770,1771],[1752,1753,1760,1761,1762,1770]],
[[222,-11,-18],[223,-11,2],[222,-21,-18,],0xFFFFFF,[1734,1735,1744,1745,1746,1754],[1735,1745,1746,1747,1754,1755],[1746,1747,1748,1754,1755,1756]],
[[223,-11,2],[224,-21,2],[222,-21,-18,],0xFFFFFF,[1735,1745,1746,1747,1754,1755],[1747,1748,1749,1755,1756,1757],[1746,1747,1748,1754,1755,1756]],
[[222,-21,-18],[224,-21,2],[223,-31,-18,],0xFFFFFF,[1746,1747,1748,1754,1755,1756],[1747,1748,1749,1755,1756,1757],[1748,1749,1750,1756,1757,1758]],
[[224,-21,2],[224,-31,2],[223,-31,-18,],0xFFFFFF,[1747,1748,1749,1755,1756,1757],[1749,1750,1751,1757,1758,1759],[1748,1749,1750,1756,1757,1758]],
[[223,-31,-18],[224,-31,2],[222,-41,-18,],0xFFFFFF,[1748,1749,1750,1756,1757,1758],[1749,1750,1751,1757,1758,1759],[1750,1751,1752,1758,1759,1760]],
[[224,-31,2],[224,-41,2],[222,-41,-18,],0xFFFFFF,[1749,1750,1751,1757,1758,1759],[1751,1752,1753,1759,1760,1761],[1750,1751,1752,1758,1759,1760]],
[[222,-41,-18],[224,-41,2],[222,-51,-18,],0xFFFFFF,[1750,1751,1752,1758,1759,1760],[1751,1752,1753,1759,1760,1761],[1752,1753,1760,1761,1762,1770]],
[[224,-41,2],[223,-51,2],[222,-51,-18,],0xFFFFFF,[1751,1752,1753,1759,1760,1761],[1753,1761,1762,1763,1770,1771],[1752,1753,1760,1761,1762,1770]],
[[222,-51,-18],[223,-51,2],[221,-61,-18,],0xFFFFFF,[1752,1753,1760,1761,1762,1770],[1753,1761,1762,1763,1770,1771],[1762,1763,1764,1770,1771,1772]],
[[223,-51,2],[222,-61,2],[221,-61,-18,],0xFFFFFF,[1753,1761,1762,1763,1770,1771],[1763,1764,1765,1771,1772,1773],[1762,1763,1764,1770,1771,1772]],
[[221,-61,-18],[222,-61,2],[219,-71,-17,],0xFFFFFF,[1762,1763,1764,1770,1771,1772],[1763,1764,1765,1771,1772,1773],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[222,-61,2],[220,-71,2],[219,-71,-17,],0xFFFFFF,[1763,1764,1765,1771,1772,1773],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[219,-71,-17],[220,-71,2],[217,-81,-17,],0xFFFFFF,[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1766,1767,1768,1774,1775,1776]],
[[220,-71,2],[218,-81,1],[217,-81,-17,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1767,1768,1769,1775,1776,1777],[1766,1767,1768,1774,1775,1776]],
[[217,-81,-17],[218,-81,1],[213,-91,-17,],0xFFFFFF,[1766,1767,1768,1774,1775,1776],[1767,1768,1769,1775,1776,1777],[1768,1769,1776,1777]],
[[218,-81,1],[215,-91,1],[213,-91,-17,],0xFFFFFF,[1767,1768,1769,1775,1776,1777],[1769,1777],[1768,1769,1776,1777]],
[[222,-51,-18],[223,-51,2],[221,-61,-18,],0xFFFFFF,[1752,1753,1760,1761,1762,1770],[1753,1761,1762,1763,1770,1771],[1762,1763,1764,1770,1771,1772]],
[[223,-51,2],[222,-61,2],[221,-61,-18,],0xFFFFFF,[1753,1761,1762,1763,1770,1771],[1763,1764,1765,1771,1772,1773],[1762,1763,1764,1770,1771,1772]],
[[221,-61,-18],[222,-61,2],[219,-71,-17,],0xFFFFFF,[1762,1763,1764,1770,1771,1772],[1763,1764,1765,1771,1772,1773],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[222,-61,2],[220,-71,2],[219,-71,-17,],0xFFFFFF,[1763,1764,1765,1771,1772,1773],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[219,-71,-17],[220,-71,2],[217,-81,-17,],0xFFFFFF,[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1766,1767,1768,1774,1775,1776]],
[[220,-71,2],[218,-81,1],[217,-81,-17,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1767,1768,1769,1775,1776,1777],[1766,1767,1768,1774,1775,1776]],
[[217,-81,-17],[218,-81,1],[213,-91,-17,],0xFFFFFF,[1766,1767,1768,1774,1775,1776],[1767,1768,1769,1775,1776,1777],[1768,1769,1776,1777]],
[[218,-81,1],[215,-91,1],[213,-91,-17,],0xFFFFFF,[1767,1768,1769,1775,1776,1777],[1769,1777],[1768,1769,1776,1777]],
[[180,60,1],[178,60,15],[198,55,1,],0xFFFFFF,[1778,1784],[1778,1779,1784,1785],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[178,60,15],[197,55,17],[198,55,1,],0xFFFFFF,[1778,1779,1784,1785],[1779,1780,1781,1785,1786,1787],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[198,55,1],[197,55,17],[207,49,1,],0xFFFFFF,[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732],[1779,1780,1781,1785,1786,1787],[1780,1781,1782,1786,1787,1788]],
[[197,55,17],[205,49,19],[207,49,1,],0xFFFFFF,[1779,1780,1781,1785,1786,1787],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[1780,1781,1782,1786,1787,1788]],
[[207,49,1],[205,49,19],[213,39,1,],0xFFFFFF,[1780,1781,1782,1786,1787,1788],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[1782,1783,1788,1789,1790,1800]],
[[205,49,19],[211,39,20],[213,39,1,],0xFFFFFF,[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[1783,1789,1790,1791,1800,1801],[1782,1783,1788,1789,1790,1800]],
[[180,60,1],[178,60,15],[198,55,1,],0xFFFFFF,[1778,1784],[1778,1779,1784,1785],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[178,60,15],[197,55,17],[198,55,1,],0xFFFFFF,[1778,1779,1784,1785],[1779,1780,1781,1785,1786,1787],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[198,55,1],[197,55,17],[207,49,1,],0xFFFFFF,[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732],[1779,1780,1781,1785,1786,1787],[1780,1781,1782,1786,1787,1788]],
[[197,55,17],[205,49,19],[207,49,1,],0xFFFFFF,[1779,1780,1781,1785,1786,1787],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[1780,1781,1782,1786,1787,1788]],
[[207,49,1],[205,49,19],[213,39,1,],0xFFFFFF,[1780,1781,1782,1786,1787,1788],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[1782,1783,1788,1789,1790,1800]],
[[205,49,19],[211,39,20],[213,39,1,],0xFFFFFF,[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[1783,1789,1790,1791,1800,1801],[1782,1783,1788,1789,1790,1800]],
[[213,39,1],[211,39,20],[216,29,1,],0xFFFFFF,[1782,1783,1788,1789,1790,1800],[1783,1789,1790,1791,1800,1801],[1790,1791,1792,1800,1801,1802]],
[[211,39,20],[214,29,21],[216,29,1,],0xFFFFFF,[1783,1789,1790,1791,1800,1801],[1791,1792,1793,1801,1802,1803],[1790,1791,1792,1800,1801,1802]],
[[216,29,1],[214,29,21],[218,19,1,],0xFFFFFF,[1790,1791,1792,1800,1801,1802],[1791,1792,1793,1801,1802,1803],[1792,1793,1794,1802,1803,1804]],
[[214,29,21],[216,19,21],[218,19,1,],0xFFFFFF,[1791,1792,1793,1801,1802,1803],[1793,1794,1795,1803,1804,1805],[1792,1793,1794,1802,1803,1804]],
[[218,19,1],[216,19,21],[220,9,2,],0xFFFFFF,[1792,1793,1794,1802,1803,1804],[1793,1794,1795,1803,1804,1805],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806]],
[[216,19,21],[218,9,21],[220,9,2,],0xFFFFFF,[1793,1794,1795,1803,1804,1805],[1795,1796,1797,1805,1806,1807],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806]],
[[220,9,2],[218,9,21],[222,-1,2,],0xFFFFFF,[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1795,1796,1797,1805,1806,1807],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808]],
[[218,9,21],[220,-1,22],[222,-1,2,],0xFFFFFF,[1795,1796,1797,1805,1806,1807],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808]],
[[222,-1,2],[220,-1,22],[223,-11,2,],0xFFFFFF,[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1798,1799,1808,1809,1810,1818]],
[[220,-1,22],[221,-11,22],[223,-11,2,],0xFFFFFF,[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1799,1809,1810,1811,1818,1819],[1798,1799,1808,1809,1810,1818]],
[[213,39,1],[211,39,20],[216,29,1,],0xFFFFFF,[1782,1783,1788,1789,1790,1800],[1783,1789,1790,1791,1800,1801],[1790,1791,1792,1800,1801,1802]],
[[211,39,20],[214,29,21],[216,29,1,],0xFFFFFF,[1783,1789,1790,1791,1800,1801],[1791,1792,1793,1801,1802,1803],[1790,1791,1792,1800,1801,1802]],
[[216,29,1],[214,29,21],[218,19,1,],0xFFFFFF,[1790,1791,1792,1800,1801,1802],[1791,1792,1793,1801,1802,1803],[1792,1793,1794,1802,1803,1804]],
[[214,29,21],[216,19,21],[218,19,1,],0xFFFFFF,[1791,1792,1793,1801,1802,1803],[1793,1794,1795,1803,1804,1805],[1792,1793,1794,1802,1803,1804]],
[[218,19,1],[216,19,21],[220,9,2,],0xFFFFFF,[1792,1793,1794,1802,1803,1804],[1793,1794,1795,1803,1804,1805],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806]],
[[216,19,21],[218,9,21],[220,9,2,],0xFFFFFF,[1793,1794,1795,1803,1804,1805],[1795,1796,1797,1805,1806,1807],[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806]],
[[220,9,2],[218,9,21],[222,-1,2,],0xFFFFFF,[1731,1732,1733,1741,1742,1743,1794,1795,1796,1804,1805,1806],[1795,1796,1797,1805,1806,1807],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808]],
[[218,9,21],[220,-1,22],[222,-1,2,],0xFFFFFF,[1795,1796,1797,1805,1806,1807],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808]],
[[222,-1,2],[220,-1,22],[223,-11,2,],0xFFFFFF,[1733,1734,1735,1743,1744,1745,1796,1797,1798,1806,1807,1808],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1798,1799,1808,1809,1810,1818]],
[[220,-1,22],[221,-11,22],[223,-11,2,],0xFFFFFF,[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1799,1809,1810,1811,1818,1819],[1798,1799,1808,1809,1810,1818]],
[[223,-11,2],[221,-11,22],[224,-21,2,],0xFFFFFF,[1798,1799,1808,1809,1810,1818],[1799,1809,1810,1811,1818,1819],[1810,1811,1812,1818,1819,1820]],
[[221,-11,22],[222,-21,22],[224,-21,2,],0xFFFFFF,[1799,1809,1810,1811,1818,1819],[1811,1812,1813,1819,1820,1821],[1810,1811,1812,1818,1819,1820]],
[[224,-21,2],[222,-21,22],[224,-31,2,],0xFFFFFF,[1810,1811,1812,1818,1819,1820],[1811,1812,1813,1819,1820,1821],[1812,1813,1814,1820,1821,1822]],
[[222,-21,22],[222,-31,22],[224,-31,2,],0xFFFFFF,[1811,1812,1813,1819,1820,1821],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[1812,1813,1814,1820,1821,1822]],
[[224,-31,2],[222,-31,22],[224,-41,2,],0xFFFFFF,[1812,1813,1814,1820,1821,1822],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[1814,1815,1816,1822,1823,1824]],
[[222,-31,22],[222,-41,22],[224,-41,2,],0xFFFFFF,[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[1815,1816,1817,1823,1824,1825],[1814,1815,1816,1822,1823,1824]],
[[224,-41,2],[222,-41,22],[223,-51,2,],0xFFFFFF,[1814,1815,1816,1822,1823,1824],[1815,1816,1817,1823,1824,1825],[1816,1817,1824,1825,1826,1834]],
[[222,-41,22],[221,-51,22],[223,-51,2,],0xFFFFFF,[1815,1816,1817,1823,1824,1825],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[1816,1817,1824,1825,1826,1834]],
[[223,-11,2],[221,-11,22],[224,-21,2,],0xFFFFFF,[1798,1799,1808,1809,1810,1818],[1799,1809,1810,1811,1818,1819],[1810,1811,1812,1818,1819,1820]],
[[221,-11,22],[222,-21,22],[224,-21,2,],0xFFFFFF,[1799,1809,1810,1811,1818,1819],[1811,1812,1813,1819,1820,1821],[1810,1811,1812,1818,1819,1820]],
[[224,-21,2],[222,-21,22],[224,-31,2,],0xFFFFFF,[1810,1811,1812,1818,1819,1820],[1811,1812,1813,1819,1820,1821],[1812,1813,1814,1820,1821,1822]],
[[222,-21,22],[222,-31,22],[224,-31,2,],0xFFFFFF,[1811,1812,1813,1819,1820,1821],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[1812,1813,1814,1820,1821,1822]],
[[224,-31,2],[222,-31,22],[224,-41,2,],0xFFFFFF,[1812,1813,1814,1820,1821,1822],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[1814,1815,1816,1822,1823,1824]],
[[222,-31,22],[222,-41,22],[224,-41,2,],0xFFFFFF,[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[1815,1816,1817,1823,1824,1825],[1814,1815,1816,1822,1823,1824]],
[[224,-41,2],[222,-41,22],[223,-51,2,],0xFFFFFF,[1814,1815,1816,1822,1823,1824],[1815,1816,1817,1823,1824,1825],[1816,1817,1824,1825,1826,1834]],
[[222,-41,22],[221,-51,22],[223,-51,2,],0xFFFFFF,[1815,1816,1817,1823,1824,1825],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[1816,1817,1824,1825,1826,1834]],
[[223,-51,2],[221,-51,22],[222,-61,2,],0xFFFFFF,[1816,1817,1824,1825,1826,1834],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[1826,1827,1828,1834,1835,1836]],
[[221,-51,22],[220,-61,22],[222,-61,2,],0xFFFFFF,[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[1827,1828,1829,1835,1836,1837],[1826,1827,1828,1834,1835,1836]],
[[222,-61,2],[220,-61,22],[220,-71,2,],0xFFFFFF,[1826,1827,1828,1834,1835,1836],[1827,1828,1829,1835,1836,1837],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-61,22],[218,-71,21],[220,-71,2,],0xFFFFFF,[1827,1828,1829,1835,1836,1837],[1829,1830,1831,1837,1838,1839],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-71,2],[218,-71,21],[218,-81,1,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1829,1830,1831,1837,1838,1839],[1830,1831,1832,1838,1839,1840]],
[[218,-71,21],[216,-81,21],[218,-81,1,],0xFFFFFF,[1829,1830,1831,1837,1838,1839],[1831,1832,1833,1839,1840,1841],[1830,1831,1832,1838,1839,1840]],
[[218,-81,1],[216,-81,21],[215,-91,1,],0xFFFFFF,[1830,1831,1832,1838,1839,1840],[1831,1832,1833,1839,1840,1841],[1832,1833,1840,1841]],
[[216,-81,21],[213,-91,20],[215,-91,1,],0xFFFFFF,[1831,1832,1833,1839,1840,1841],[1833,1841],[1832,1833,1840,1841]],
[[223,-51,2],[221,-51,22],[222,-61,2,],0xFFFFFF,[1816,1817,1824,1825,1826,1834],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[1826,1827,1828,1834,1835,1836]],
[[221,-51,22],[220,-61,22],[222,-61,2,],0xFFFFFF,[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[1827,1828,1829,1835,1836,1837],[1826,1827,1828,1834,1835,1836]],
[[222,-61,2],[220,-61,22],[220,-71,2,],0xFFFFFF,[1826,1827,1828,1834,1835,1836],[1827,1828,1829,1835,1836,1837],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-61,22],[218,-71,21],[220,-71,2,],0xFFFFFF,[1827,1828,1829,1835,1836,1837],[1829,1830,1831,1837,1838,1839],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-71,2],[218,-71,21],[218,-81,1,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1829,1830,1831,1837,1838,1839],[1830,1831,1832,1838,1839,1840]],
[[218,-71,21],[216,-81,21],[218,-81,1,],0xFFFFFF,[1829,1830,1831,1837,1838,1839],[1831,1832,1833,1839,1840,1841],[1830,1831,1832,1838,1839,1840]],
[[218,-81,1],[216,-81,21],[215,-91,1,],0xFFFFFF,[1830,1831,1832,1838,1839,1840],[1831,1832,1833,1839,1840,1841],[1832,1833,1840,1841]],
[[216,-81,21],[213,-91,20],[215,-91,1,],0xFFFFFF,[1831,1832,1833,1839,1840,1841],[1833,1841],[1832,1833,1840,1841]],
[[179,60,14],[175,60,28],[197,55,17,],0xFFFFFF,[1842,1848],[1842,1843,1848,1849],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[175,60,28],[192,55,33],[197,55,17,],0xFFFFFF,[1842,1843,1848,1849],[1843,1844,1845,1849,1850,1851],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[197,55,17],[192,55,33],[205,49,19,],0xFFFFFF,[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796],[1843,1844,1845,1849,1850,1851],[1844,1845,1846,1850,1851,1852]],
[[192,55,33],[200,49,36],[205,49,19,],0xFFFFFF,[1843,1844,1845,1849,1850,1851],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[1844,1845,1846,1850,1851,1852]],
[[205,49,19],[200,49,36],[211,39,20,],0xFFFFFF,[1844,1845,1846,1850,1851,1852],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[1846,1847,1852,1853,1854,1864]],
[[200,49,36],[206,39,38],[211,39,20,],0xFFFFFF,[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[1847,1853,1854,1855,1864,1865],[1846,1847,1852,1853,1854,1864]],
[[179,60,14],[175,60,28],[197,55,17,],0xFFFFFF,[1842,1848],[1842,1843,1848,1849],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[175,60,28],[192,55,33],[197,55,17,],0xFFFFFF,[1842,1843,1848,1849],[1843,1844,1845,1849,1850,1851],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[197,55,17],[192,55,33],[205,49,19,],0xFFFFFF,[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796],[1843,1844,1845,1849,1850,1851],[1844,1845,1846,1850,1851,1852]],
[[192,55,33],[200,49,36],[205,49,19,],0xFFFFFF,[1843,1844,1845,1849,1850,1851],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[1844,1845,1846,1850,1851,1852]],
[[205,49,19],[200,49,36],[211,39,20,],0xFFFFFF,[1844,1845,1846,1850,1851,1852],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[1846,1847,1852,1853,1854,1864]],
[[200,49,36],[206,39,38],[211,39,20,],0xFFFFFF,[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[1847,1853,1854,1855,1864,1865],[1846,1847,1852,1853,1854,1864]],
[[211,39,20],[206,39,38],[214,29,21,],0xFFFFFF,[1846,1847,1852,1853,1854,1864],[1847,1853,1854,1855,1864,1865],[1854,1855,1856,1864,1865,1866]],
[[206,39,38],[209,29,39],[214,29,21,],0xFFFFFF,[1847,1853,1854,1855,1864,1865],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[1854,1855,1856,1864,1865,1866]],
[[214,29,21],[209,29,39],[216,19,21,],0xFFFFFF,[1854,1855,1856,1864,1865,1866],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[1856,1857,1858,1866,1867,1868]],
[[209,29,39],[211,19,40],[216,19,21,],0xFFFFFF,[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[1857,1858,1859,1867,1868,1869],[1856,1857,1858,1866,1867,1868]],
[[216,19,21],[211,19,40],[218,9,21,],0xFFFFFF,[1856,1857,1858,1866,1867,1868],[1857,1858,1859,1867,1868,1869],[1858,1859,1860,1868,1869,1870]],
[[211,19,40],[213,9,41],[218,9,21,],0xFFFFFF,[1857,1858,1859,1867,1868,1869],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[1858,1859,1860,1868,1869,1870]],
[[218,9,21],[213,9,41],[220,-1,22,],0xFFFFFF,[1858,1859,1860,1868,1869,1870],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872]],
[[213,9,41],[214,-1,41],[220,-1,22,],0xFFFFFF,[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872]],
[[220,-1,22],[214,-1,41],[221,-11,22,],0xFFFFFF,[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[214,-1,41],[215,-11,42],[221,-11,22,],0xFFFFFF,[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1863,1873,1874,1875,1882,1883],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[211,39,20],[206,39,38],[214,29,21,],0xFFFFFF,[1846,1847,1852,1853,1854,1864],[1847,1853,1854,1855,1864,1865],[1854,1855,1856,1864,1865,1866]],
[[206,39,38],[209,29,39],[214,29,21,],0xFFFFFF,[1847,1853,1854,1855,1864,1865],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[1854,1855,1856,1864,1865,1866]],
[[214,29,21],[209,29,39],[216,19,21,],0xFFFFFF,[1854,1855,1856,1864,1865,1866],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[1856,1857,1858,1866,1867,1868]],
[[209,29,39],[211,19,40],[216,19,21,],0xFFFFFF,[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[1857,1858,1859,1867,1868,1869],[1856,1857,1858,1866,1867,1868]],
[[216,19,21],[211,19,40],[218,9,21,],0xFFFFFF,[1856,1857,1858,1866,1867,1868],[1857,1858,1859,1867,1868,1869],[1858,1859,1860,1868,1869,1870]],
[[211,19,40],[213,9,41],[218,9,21,],0xFFFFFF,[1857,1858,1859,1867,1868,1869],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[1858,1859,1860,1868,1869,1870]],
[[218,9,21],[213,9,41],[220,-1,22,],0xFFFFFF,[1858,1859,1860,1868,1869,1870],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872]],
[[213,9,41],[214,-1,41],[220,-1,22,],0xFFFFFF,[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872]],
[[220,-1,22],[214,-1,41],[221,-11,22,],0xFFFFFF,[1797,1798,1799,1807,1808,1809,1860,1861,1862,1870,1871,1872],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[214,-1,41],[215,-11,42],[221,-11,22,],0xFFFFFF,[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1863,1873,1874,1875,1882,1883],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[221,-11,22],[215,-11,42],[222,-21,22,],0xFFFFFF,[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836],[1863,1873,1874,1875,1882,1883],[1874,1875,1876,1882,1883,1884]],
[[215,-11,42],[216,-21,42],[222,-21,22,],0xFFFFFF,[1863,1873,1874,1875,1882,1883],[1875,1876,1877,1883,1884,1885],[1874,1875,1876,1882,1883,1884]],
[[222,-21,22],[216,-21,42],[222,-31,22,],0xFFFFFF,[1874,1875,1876,1882,1883,1884],[1875,1876,1877,1883,1884,1885],[1876,1877,1878,1884,1885,1886]],
[[216,-21,42],[216,-31,42],[222,-31,22,],0xFFFFFF,[1875,1876,1877,1883,1884,1885],[1877,1878,1879,1885,1886,1887],[1876,1877,1878,1884,1885,1886]],
[[222,-31,22],[216,-31,42],[222,-41,22,],0xFFFFFF,[1876,1877,1878,1884,1885,1886],[1877,1878,1879,1885,1886,1887],[1878,1879,1880,1886,1887,1888]],
[[216,-31,42],[216,-41,42],[222,-41,22,],0xFFFFFF,[1877,1878,1879,1885,1886,1887],[1879,1880,1881,1887,1888,1889],[1878,1879,1880,1886,1887,1888]],
[[222,-41,22],[216,-41,42],[221,-51,22,],0xFFFFFF,[1878,1879,1880,1886,1887,1888],[1879,1880,1881,1887,1888,1889],[1880,1881,1888,1889,1890,1898]],
[[216,-41,42],[216,-51,42],[221,-51,22,],0xFFFFFF,[1879,1880,1881,1887,1888,1889],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[1880,1881,1888,1889,1890,1898]],
[[221,-11,22],[215,-11,42],[222,-21,22,],0xFFFFFF,[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836],[1863,1873,1874,1875,1882,1883],[1874,1875,1876,1882,1883,1884]],
[[215,-11,42],[216,-21,42],[222,-21,22,],0xFFFFFF,[1863,1873,1874,1875,1882,1883],[1875,1876,1877,1883,1884,1885],[1874,1875,1876,1882,1883,1884]],
[[222,-21,22],[216,-21,42],[222,-31,22,],0xFFFFFF,[1874,1875,1876,1882,1883,1884],[1875,1876,1877,1883,1884,1885],[1876,1877,1878,1884,1885,1886]],
[[216,-21,42],[216,-31,42],[222,-31,22,],0xFFFFFF,[1875,1876,1877,1883,1884,1885],[1877,1878,1879,1885,1886,1887],[1876,1877,1878,1884,1885,1886]],
[[222,-31,22],[216,-31,42],[222,-41,22,],0xFFFFFF,[1876,1877,1878,1884,1885,1886],[1877,1878,1879,1885,1886,1887],[1878,1879,1880,1886,1887,1888]],
[[216,-31,42],[216,-41,42],[222,-41,22,],0xFFFFFF,[1877,1878,1879,1885,1886,1887],[1879,1880,1881,1887,1888,1889],[1878,1879,1880,1886,1887,1888]],
[[222,-41,22],[216,-41,42],[221,-51,22,],0xFFFFFF,[1878,1879,1880,1886,1887,1888],[1879,1880,1881,1887,1888,1889],[1880,1881,1888,1889,1890,1898]],
[[216,-41,42],[216,-51,42],[221,-51,22,],0xFFFFFF,[1879,1880,1881,1887,1888,1889],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[1880,1881,1888,1889,1890,1898]],
[[221,-51,22],[216,-51,42],[220,-61,22,],0xFFFFFF,[1880,1881,1888,1889,1890,1898],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[1890,1891,1892,1898,1899,1900]],
[[216,-51,42],[214,-61,41],[220,-61,22,],0xFFFFFF,[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[1891,1892,1893,1899,1900,1901],[1890,1891,1892,1898,1899,1900]],
[[220,-61,22],[214,-61,41],[218,-71,21,],0xFFFFFF,[1890,1891,1892,1898,1899,1900],[1891,1892,1893,1899,1900,1901],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[214,-61,41],[213,-71,41],[218,-71,21,],0xFFFFFF,[1891,1892,1893,1899,1900,1901],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[218,-71,21],[213,-71,41],[216,-81,21,],0xFFFFFF,[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1894,1895,1896,1902,1903,1904]],
[[213,-71,41],[211,-81,40],[216,-81,21,],0xFFFFFF,[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1895,1896,1897,1903,1904,1905],[1894,1895,1896,1902,1903,1904]],
[[216,-81,21],[211,-81,40],[213,-91,20,],0xFFFFFF,[1894,1895,1896,1902,1903,1904],[1895,1896,1897,1903,1904,1905],[1896,1897,1904,1905]],
[[211,-81,40],[207,-91,39],[213,-91,20,],0xFFFFFF,[1895,1896,1897,1903,1904,1905],[1897,1905],[1896,1897,1904,1905]],
[[221,-51,22],[216,-51,42],[220,-61,22,],0xFFFFFF,[1880,1881,1888,1889,1890,1898],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[1890,1891,1892,1898,1899,1900]],
[[216,-51,42],[214,-61,41],[220,-61,22,],0xFFFFFF,[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[1891,1892,1893,1899,1900,1901],[1890,1891,1892,1898,1899,1900]],
[[220,-61,22],[214,-61,41],[218,-71,21,],0xFFFFFF,[1890,1891,1892,1898,1899,1900],[1891,1892,1893,1899,1900,1901],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[214,-61,41],[213,-71,41],[218,-71,21,],0xFFFFFF,[1891,1892,1893,1899,1900,1901],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[218,-71,21],[213,-71,41],[216,-81,21,],0xFFFFFF,[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1894,1895,1896,1902,1903,1904]],
[[213,-71,41],[211,-81,40],[216,-81,21,],0xFFFFFF,[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1895,1896,1897,1903,1904,1905],[1894,1895,1896,1902,1903,1904]],
[[216,-81,21],[211,-81,40],[213,-91,20,],0xFFFFFF,[1894,1895,1896,1902,1903,1904],[1895,1896,1897,1903,1904,1905],[1896,1897,1904,1905]],
[[211,-81,40],[207,-91,39],[213,-91,20,],0xFFFFFF,[1895,1896,1897,1903,1904,1905],[1897,1905],[1896,1897,1904,1905]],
[[175,60,26],[169,60,39],[192,55,33,],0xFFFFFF,[1906,1912],[1906,1907,1912,1913],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[169,60,39],[185,55,47],[192,55,33,],0xFFFFFF,[1906,1907,1912,1913],[1907,1908,1909,1913,1914,1915],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[192,55,33],[185,55,47],[200,49,36,],0xFFFFFF,[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860],[1907,1908,1909,1913,1914,1915],[1908,1909,1910,1914,1915,1916]],
[[185,55,47],[193,49,52],[200,49,36,],0xFFFFFF,[1907,1908,1909,1913,1914,1915],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[1908,1909,1910,1914,1915,1916]],
[[200,49,36],[193,49,52],[206,39,38,],0xFFFFFF,[1908,1909,1910,1914,1915,1916],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[1910,1911,1916,1917,1918,1928]],
[[193,49,52],[198,39,55],[206,39,38,],0xFFFFFF,[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[1911,1917,1918,1919,1928,1929],[1910,1911,1916,1917,1918,1928]],
[[175,60,26],[169,60,39],[192,55,33,],0xFFFFFF,[1906,1912],[1906,1907,1912,1913],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[169,60,39],[185,55,47],[192,55,33,],0xFFFFFF,[1906,1907,1912,1913],[1907,1908,1909,1913,1914,1915],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[192,55,33],[185,55,47],[200,49,36,],0xFFFFFF,[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860],[1907,1908,1909,1913,1914,1915],[1908,1909,1910,1914,1915,1916]],
[[185,55,47],[193,49,52],[200,49,36,],0xFFFFFF,[1907,1908,1909,1913,1914,1915],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[1908,1909,1910,1914,1915,1916]],
[[200,49,36],[193,49,52],[206,39,38,],0xFFFFFF,[1908,1909,1910,1914,1915,1916],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[1910,1911,1916,1917,1918,1928]],
[[193,49,52],[198,39,55],[206,39,38,],0xFFFFFF,[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[1911,1917,1918,1919,1928,1929],[1910,1911,1916,1917,1918,1928]],
[[206,39,38],[198,39,55],[209,29,39,],0xFFFFFF,[1910,1911,1916,1917,1918,1928],[1911,1917,1918,1919,1928,1929],[1918,1919,1920,1928,1929,1930]],
[[198,39,55],[200,29,57],[209,29,39,],0xFFFFFF,[1911,1917,1918,1919,1928,1929],[1919,1920,1921,1929,1930,1931],[1918,1919,1920,1928,1929,1930]],
[[209,29,39],[200,29,57],[211,19,40,],0xFFFFFF,[1918,1919,1920,1928,1929,1930],[1919,1920,1921,1929,1930,1931],[1920,1921,1922,1930,1931,1932]],
[[200,29,57],[202,19,58],[211,19,40,],0xFFFFFF,[1919,1920,1921,1929,1930,1931],[1921,1922,1923,1931,1932,1933],[1920,1921,1922,1930,1931,1932]],
[[211,19,40],[202,19,58],[213,9,41,],0xFFFFFF,[1920,1921,1922,1930,1931,1932],[1921,1922,1923,1931,1932,1933],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[202,19,58],[204,9,59],[213,9,41,],0xFFFFFF,[1921,1922,1923,1931,1932,1933],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[213,9,41],[204,9,59],[214,-1,41,],0xFFFFFF,[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936]],
[[204,9,59],[205,-1,59],[214,-1,41,],0xFFFFFF,[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1925,1926,1927,1935,1936,1937],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936]],
[[214,-1,41],[205,-1,59],[215,-11,42,],0xFFFFFF,[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1925,1926,1927,1935,1936,1937],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[205,-1,59],[206,-11,60],[215,-11,42,],0xFFFFFF,[1925,1926,1927,1935,1936,1937],[1927,1937,1938,1939,1946,1947],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[206,39,38],[198,39,55],[209,29,39,],0xFFFFFF,[1910,1911,1916,1917,1918,1928],[1911,1917,1918,1919,1928,1929],[1918,1919,1920,1928,1929,1930]],
[[198,39,55],[200,29,57],[209,29,39,],0xFFFFFF,[1911,1917,1918,1919,1928,1929],[1919,1920,1921,1929,1930,1931],[1918,1919,1920,1928,1929,1930]],
[[209,29,39],[200,29,57],[211,19,40,],0xFFFFFF,[1918,1919,1920,1928,1929,1930],[1919,1920,1921,1929,1930,1931],[1920,1921,1922,1930,1931,1932]],
[[200,29,57],[202,19,58],[211,19,40,],0xFFFFFF,[1919,1920,1921,1929,1930,1931],[1921,1922,1923,1931,1932,1933],[1920,1921,1922,1930,1931,1932]],
[[211,19,40],[202,19,58],[213,9,41,],0xFFFFFF,[1920,1921,1922,1930,1931,1932],[1921,1922,1923,1931,1932,1933],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[202,19,58],[204,9,59],[213,9,41,],0xFFFFFF,[1921,1922,1923,1931,1932,1933],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[213,9,41],[204,9,59],[214,-1,41,],0xFFFFFF,[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936]],
[[204,9,59],[205,-1,59],[214,-1,41,],0xFFFFFF,[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1925,1926,1927,1935,1936,1937],[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936]],
[[214,-1,41],[205,-1,59],[215,-11,42,],0xFFFFFF,[1861,1862,1863,1871,1872,1873,1924,1925,1926,1934,1935,1936],[1925,1926,1927,1935,1936,1937],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[205,-1,59],[206,-11,60],[215,-11,42,],0xFFFFFF,[1925,1926,1927,1935,1936,1937],[1927,1937,1938,1939,1946,1947],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[215,-11,42],[206,-11,60],[216,-21,42,],0xFFFFFF,[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900],[1927,1937,1938,1939,1946,1947],[1938,1939,1940,1946,1947,1948]],
[[206,-11,60],[207,-21,60],[216,-21,42,],0xFFFFFF,[1927,1937,1938,1939,1946,1947],[1939,1940,1941,1947,1948,1949],[1938,1939,1940,1946,1947,1948]],
[[216,-21,42],[207,-21,60],[216,-31,42,],0xFFFFFF,[1938,1939,1940,1946,1947,1948],[1939,1940,1941,1947,1948,1949],[1940,1941,1942,1948,1949,1950]],
[[207,-21,60],[207,-31,61],[216,-31,42,],0xFFFFFF,[1939,1940,1941,1947,1948,1949],[1941,1942,1943,1949,1950,1951],[1940,1941,1942,1948,1949,1950]],
[[216,-31,42],[207,-31,61],[216,-41,42,],0xFFFFFF,[1940,1941,1942,1948,1949,1950],[1941,1942,1943,1949,1950,1951],[1942,1943,1944,1950,1951,1952]],
[[207,-31,61],[207,-41,60],[216,-41,42,],0xFFFFFF,[1941,1942,1943,1949,1950,1951],[1943,1944,1945,1951,1952,1953],[1942,1943,1944,1950,1951,1952]],
[[216,-41,42],[207,-41,60],[216,-51,42,],0xFFFFFF,[1942,1943,1944,1950,1951,1952],[1943,1944,1945,1951,1952,1953],[1944,1945,1952,1953,1954,1962]],
[[207,-41,60],[207,-51,60],[216,-51,42,],0xFFFFFF,[1943,1944,1945,1951,1952,1953],[1945,1953,1954,1955,1962,1963],[1944,1945,1952,1953,1954,1962]],
[[215,-11,42],[206,-11,60],[216,-21,42,],0xFFFFFF,[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900],[1927,1937,1938,1939,1946,1947],[1938,1939,1940,1946,1947,1948]],
[[206,-11,60],[207,-21,60],[216,-21,42,],0xFFFFFF,[1927,1937,1938,1939,1946,1947],[1939,1940,1941,1947,1948,1949],[1938,1939,1940,1946,1947,1948]],
[[216,-21,42],[207,-21,60],[216,-31,42,],0xFFFFFF,[1938,1939,1940,1946,1947,1948],[1939,1940,1941,1947,1948,1949],[1940,1941,1942,1948,1949,1950]],
[[207,-21,60],[207,-31,61],[216,-31,42,],0xFFFFFF,[1939,1940,1941,1947,1948,1949],[1941,1942,1943,1949,1950,1951],[1940,1941,1942,1948,1949,1950]],
[[216,-31,42],[207,-31,61],[216,-41,42,],0xFFFFFF,[1940,1941,1942,1948,1949,1950],[1941,1942,1943,1949,1950,1951],[1942,1943,1944,1950,1951,1952]],
[[207,-31,61],[207,-41,60],[216,-41,42,],0xFFFFFF,[1941,1942,1943,1949,1950,1951],[1943,1944,1945,1951,1952,1953],[1942,1943,1944,1950,1951,1952]],
[[216,-41,42],[207,-41,60],[216,-51,42,],0xFFFFFF,[1942,1943,1944,1950,1951,1952],[1943,1944,1945,1951,1952,1953],[1944,1945,1952,1953,1954,1962]],
[[207,-41,60],[207,-51,60],[216,-51,42,],0xFFFFFF,[1943,1944,1945,1951,1952,1953],[1945,1953,1954,1955,1962,1963],[1944,1945,1952,1953,1954,1962]],
[[216,-51,42],[207,-51,60],[214,-61,41,],0xFFFFFF,[1944,1945,1952,1953,1954,1962],[1945,1953,1954,1955,1962,1963],[1954,1955,1956,1962,1963,1964]],
[[207,-51,60],[206,-61,60],[214,-61,41,],0xFFFFFF,[1945,1953,1954,1955,1962,1963],[1955,1956,1957,1963,1964,1965],[1954,1955,1956,1962,1963,1964]],
[[214,-61,41],[206,-61,60],[213,-71,41,],0xFFFFFF,[1954,1955,1956,1962,1963,1964],[1955,1956,1957,1963,1964,1965],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[206,-61,60],[204,-71,59],[213,-71,41,],0xFFFFFF,[1955,1956,1957,1963,1964,1965],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[213,-71,41],[204,-71,59],[211,-81,40,],0xFFFFFF,[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[1958,1959,1960,1966,1967,1968]],
[[204,-71,59],[202,-81,57],[211,-81,40,],0xFFFFFF,[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[1959,1960,1961,1967,1968,1969],[1958,1959,1960,1966,1967,1968]],
[[211,-81,40],[202,-81,57],[207,-91,39,],0xFFFFFF,[1958,1959,1960,1966,1967,1968],[1959,1960,1961,1967,1968,1969],[1960,1961,1968,1969]],
[[202,-81,57],[199,-91,56],[207,-91,39,],0xFFFFFF,[1959,1960,1961,1967,1968,1969],[1961,1969],[1960,1961,1968,1969]],
[[216,-51,42],[207,-51,60],[214,-61,41,],0xFFFFFF,[1944,1945,1952,1953,1954,1962],[1945,1953,1954,1955,1962,1963],[1954,1955,1956,1962,1963,1964]],
[[207,-51,60],[206,-61,60],[214,-61,41,],0xFFFFFF,[1945,1953,1954,1955,1962,1963],[1955,1956,1957,1963,1964,1965],[1954,1955,1956,1962,1963,1964]],
[[214,-61,41],[206,-61,60],[213,-71,41,],0xFFFFFF,[1954,1955,1956,1962,1963,1964],[1955,1956,1957,1963,1964,1965],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[206,-61,60],[204,-71,59],[213,-71,41,],0xFFFFFF,[1955,1956,1957,1963,1964,1965],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[213,-71,41],[204,-71,59],[211,-81,40,],0xFFFFFF,[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[1958,1959,1960,1966,1967,1968]],
[[204,-71,59],[202,-81,57],[211,-81,40,],0xFFFFFF,[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[1959,1960,1961,1967,1968,1969],[1958,1959,1960,1966,1967,1968]],
[[211,-81,40],[202,-81,57],[207,-91,39,],0xFFFFFF,[1958,1959,1960,1966,1967,1968],[1959,1960,1961,1967,1968,1969],[1960,1961,1968,1969]],
[[202,-81,57],[199,-91,56],[207,-91,39,],0xFFFFFF,[1959,1960,1961,1967,1968,1969],[1961,1969],[1960,1961,1968,1969]],
[[169,60,38],[161,60,50],[185,55,47,],0xFFFFFF,[1970,1976,3916,3922],[1970,1971,1976,1977],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[161,60,50],[176,55,60],[185,55,47,],0xFFFFFF,[1970,1971,1976,1977],[1971,1972,1973,1977,1978,1979],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[185,55,47],[176,55,60],[193,49,52,],0xFFFFFF,[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[1971,1972,1973,1977,1978,1979],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[176,55,60],[182,49,66],[193,49,52,],0xFFFFFF,[1971,1972,1973,1977,1978,1979],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[193,49,52],[182,49,66],[198,39,55,],0xFFFFFF,[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1974,1975,1980,1981,1982,1992]],
[[182,49,66],[187,39,70],[198,39,55,],0xFFFFFF,[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1975,1981,1982,1983,1992,1993],[1974,1975,1980,1981,1982,1992]],
[[169,60,38],[161,60,50],[185,55,47,],0xFFFFFF,[1970,1976,3916,3922],[1970,1971,1976,1977],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[161,60,50],[176,55,60],[185,55,47,],0xFFFFFF,[1970,1971,1976,1977],[1971,1972,1973,1977,1978,1979],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[185,55,47],[176,55,60],[193,49,52,],0xFFFFFF,[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[1971,1972,1973,1977,1978,1979],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[176,55,60],[182,49,66],[193,49,52,],0xFFFFFF,[1971,1972,1973,1977,1978,1979],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[193,49,52],[182,49,66],[198,39,55,],0xFFFFFF,[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1974,1975,1980,1981,1982,1992]],
[[182,49,66],[187,39,70],[198,39,55,],0xFFFFFF,[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1975,1981,1982,1983,1992,1993],[1974,1975,1980,1981,1982,1992]],
[[198,39,55],[187,39,70],[200,29,57,],0xFFFFFF,[1974,1975,1980,1981,1982,1992],[1975,1981,1982,1983,1992,1993],[1982,1983,1984,1992,1993,1994]],
[[187,39,70],[189,29,72],[200,29,57,],0xFFFFFF,[1975,1981,1982,1983,1992,1993],[1983,1984,1985,1993,1994,1995],[1982,1983,1984,1992,1993,1994]],
[[200,29,57],[189,29,72],[202,19,58,],0xFFFFFF,[1982,1983,1984,1992,1993,1994],[1983,1984,1985,1993,1994,1995],[1984,1985,1986,1994,1995,1996]],
[[189,29,72],[191,19,74],[202,19,58,],0xFFFFFF,[1983,1984,1985,1993,1994,1995],[1985,1986,1987,1995,1996,1997],[1984,1985,1986,1994,1995,1996]],
[[202,19,58],[191,19,74],[204,9,59,],0xFFFFFF,[1984,1985,1986,1994,1995,1996],[1985,1986,1987,1995,1996,1997],[1986,1987,1988,1996,1997,1998]],
[[191,19,74],[192,9,75],[204,9,59,],0xFFFFFF,[1985,1986,1987,1995,1996,1997],[1987,1988,1989,1997,1998,1999],[1986,1987,1988,1996,1997,1998]],
[[204,9,59],[192,9,75],[205,-1,59,],0xFFFFFF,[1986,1987,1988,1996,1997,1998],[1987,1988,1989,1997,1998,1999],[1988,1989,1990,1998,1999,2000]],
[[192,9,75],[193,-1,76],[205,-1,59,],0xFFFFFF,[1987,1988,1989,1997,1998,1999],[1989,1990,1991,1999,2000,2001],[1988,1989,1990,1998,1999,2000]],
[[205,-1,59],[193,-1,76],[206,-11,60,],0xFFFFFF,[1988,1989,1990,1998,1999,2000],[1989,1990,1991,1999,2000,2001],[1990,1991,2000,2001,2002,2010]],
[[193,-1,76],[194,-11,77],[206,-11,60,],0xFFFFFF,[1989,1990,1991,1999,2000,2001],[1991,2001,2002,2003,2010,2011],[1990,1991,2000,2001,2002,2010]],
[[198,39,55],[187,39,70],[200,29,57,],0xFFFFFF,[1974,1975,1980,1981,1982,1992],[1975,1981,1982,1983,1992,1993],[1982,1983,1984,1992,1993,1994]],
[[187,39,70],[189,29,72],[200,29,57,],0xFFFFFF,[1975,1981,1982,1983,1992,1993],[1983,1984,1985,1993,1994,1995],[1982,1983,1984,1992,1993,1994]],
[[200,29,57],[189,29,72],[202,19,58,],0xFFFFFF,[1982,1983,1984,1992,1993,1994],[1983,1984,1985,1993,1994,1995],[1984,1985,1986,1994,1995,1996]],
[[189,29,72],[191,19,74],[202,19,58,],0xFFFFFF,[1983,1984,1985,1993,1994,1995],[1985,1986,1987,1995,1996,1997],[1984,1985,1986,1994,1995,1996]],
[[202,19,58],[191,19,74],[204,9,59,],0xFFFFFF,[1984,1985,1986,1994,1995,1996],[1985,1986,1987,1995,1996,1997],[1986,1987,1988,1996,1997,1998]],
[[191,19,74],[192,9,75],[204,9,59,],0xFFFFFF,[1985,1986,1987,1995,1996,1997],[1987,1988,1989,1997,1998,1999],[1986,1987,1988,1996,1997,1998]],
[[204,9,59],[192,9,75],[205,-1,59,],0xFFFFFF,[1986,1987,1988,1996,1997,1998],[1987,1988,1989,1997,1998,1999],[1988,1989,1990,1998,1999,2000]],
[[192,9,75],[193,-1,76],[205,-1,59,],0xFFFFFF,[1987,1988,1989,1997,1998,1999],[1989,1990,1991,1999,2000,2001],[1988,1989,1990,1998,1999,2000]],
[[205,-1,59],[193,-1,76],[206,-11,60,],0xFFFFFF,[1988,1989,1990,1998,1999,2000],[1989,1990,1991,1999,2000,2001],[1990,1991,2000,2001,2002,2010]],
[[193,-1,76],[194,-11,77],[206,-11,60,],0xFFFFFF,[1989,1990,1991,1999,2000,2001],[1991,2001,2002,2003,2010,2011],[1990,1991,2000,2001,2002,2010]],
[[206,-11,60],[194,-11,77],[207,-21,60,],0xFFFFFF,[1990,1991,2000,2001,2002,2010],[1991,2001,2002,2003,2010,2011],[2002,2003,2004,2010,2011,2012]],
[[194,-11,77],[195,-21,77],[207,-21,60,],0xFFFFFF,[1991,2001,2002,2003,2010,2011],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[2002,2003,2004,2010,2011,2012]],
[[207,-21,60],[195,-21,77],[207,-31,61,],0xFFFFFF,[2002,2003,2004,2010,2011,2012],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[195,-21,77],[195,-31,77],[207,-31,61,],0xFFFFFF,[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[207,-31,61],[195,-31,77],[207,-41,60,],0xFFFFFF,[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2006,2007,2008,2014,2015,2016]],
[[195,-31,77],[195,-41,77],[207,-41,60,],0xFFFFFF,[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2007,2008,2009,2015,2016,2017],[2006,2007,2008,2014,2015,2016]],
[[207,-41,60],[195,-41,77],[207,-51,60,],0xFFFFFF,[2006,2007,2008,2014,2015,2016],[2007,2008,2009,2015,2016,2017],[2008,2009,2016,2017,2018,2026]],
[[195,-41,77],[194,-51,77],[207,-51,60,],0xFFFFFF,[2007,2008,2009,2015,2016,2017],[2009,2017,2018,2019,2026,2027],[2008,2009,2016,2017,2018,2026]],
[[206,-11,60],[194,-11,77],[207,-21,60,],0xFFFFFF,[1990,1991,2000,2001,2002,2010],[1991,2001,2002,2003,2010,2011],[2002,2003,2004,2010,2011,2012]],
[[194,-11,77],[195,-21,77],[207,-21,60,],0xFFFFFF,[1991,2001,2002,2003,2010,2011],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[2002,2003,2004,2010,2011,2012]],
[[207,-21,60],[195,-21,77],[207,-31,61,],0xFFFFFF,[2002,2003,2004,2010,2011,2012],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[195,-21,77],[195,-31,77],[207,-31,61,],0xFFFFFF,[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[207,-31,61],[195,-31,77],[207,-41,60,],0xFFFFFF,[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2006,2007,2008,2014,2015,2016]],
[[195,-31,77],[195,-41,77],[207,-41,60,],0xFFFFFF,[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2007,2008,2009,2015,2016,2017],[2006,2007,2008,2014,2015,2016]],
[[207,-41,60],[195,-41,77],[207,-51,60,],0xFFFFFF,[2006,2007,2008,2014,2015,2016],[2007,2008,2009,2015,2016,2017],[2008,2009,2016,2017,2018,2026]],
[[195,-41,77],[194,-51,77],[207,-51,60,],0xFFFFFF,[2007,2008,2009,2015,2016,2017],[2009,2017,2018,2019,2026,2027],[2008,2009,2016,2017,2018,2026]],
[[207,-51,60],[194,-51,77],[206,-61,60,],0xFFFFFF,[2008,2009,2016,2017,2018,2026],[2009,2017,2018,2019,2026,2027],[2018,2019,2020,2026,2027,2028]],
[[194,-51,77],[194,-61,76],[206,-61,60,],0xFFFFFF,[2009,2017,2018,2019,2026,2027],[2019,2020,2021,2027,2028,2029],[2018,2019,2020,2026,2027,2028]],
[[206,-61,60],[194,-61,76],[204,-71,59,],0xFFFFFF,[2018,2019,2020,2026,2027,2028],[2019,2020,2021,2027,2028,2029],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[194,-61,76],[192,-71,75],[204,-71,59,],0xFFFFFF,[2019,2020,2021,2027,2028,2029],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[204,-71,59],[192,-71,75],[202,-81,57,],0xFFFFFF,[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[2022,2023,2024,2030,2031,2032]],
[[192,-71,75],[190,-81,73],[202,-81,57,],0xFFFFFF,[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[2023,2024,2025,2031,2032,2033],[2022,2023,2024,2030,2031,2032]],
[[202,-81,57],[190,-81,73],[199,-91,56,],0xFFFFFF,[2022,2023,2024,2030,2031,2032],[2023,2024,2025,2031,2032,2033],[2024,2025,2032,2033]],
[[190,-81,73],[188,-91,71],[199,-91,56,],0xFFFFFF,[2023,2024,2025,2031,2032,2033],[2025,2033],[2024,2025,2032,2033]],
[[207,-51,60],[194,-51,77],[206,-61,60,],0xFFFFFF,[2008,2009,2016,2017,2018,2026],[2009,2017,2018,2019,2026,2027],[2018,2019,2020,2026,2027,2028]],
[[194,-51,77],[194,-61,76],[206,-61,60,],0xFFFFFF,[2009,2017,2018,2019,2026,2027],[2019,2020,2021,2027,2028,2029],[2018,2019,2020,2026,2027,2028]],
[[206,-61,60],[194,-61,76],[204,-71,59,],0xFFFFFF,[2018,2019,2020,2026,2027,2028],[2019,2020,2021,2027,2028,2029],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[194,-61,76],[192,-71,75],[204,-71,59,],0xFFFFFF,[2019,2020,2021,2027,2028,2029],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[204,-71,59],[192,-71,75],[202,-81,57,],0xFFFFFF,[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[2022,2023,2024,2030,2031,2032]],
[[192,-71,75],[190,-81,73],[202,-81,57,],0xFFFFFF,[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[2023,2024,2025,2031,2032,2033],[2022,2023,2024,2030,2031,2032]],
[[202,-81,57],[190,-81,73],[199,-91,56,],0xFFFFFF,[2022,2023,2024,2030,2031,2032],[2023,2024,2025,2031,2032,2033],[2024,2025,2032,2033]],
[[190,-81,73],[188,-91,71],[199,-91,56,],0xFFFFFF,[2023,2024,2025,2031,2032,2033],[2025,2033],[2024,2025,2032,2033]],
[[162,60,48],[151,60,58],[176,55,60,],0xFFFFFF,[2034,2040,3980,3986],[2034,2035,2040,2041],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[151,60,58],[164,55,72],[176,55,60,],0xFFFFFF,[2034,2035,2040,2041],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[176,55,60],[164,55,72],[182,49,66,],0xFFFFFF,[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2036,2037,2038,2042,2043,2044]],
[[164,55,72],[169,49,78],[182,49,66,],0xFFFFFF,[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2036,2037,2038,2042,2043,2044]],
[[182,49,66],[169,49,78],[187,39,70,],0xFFFFFF,[2036,2037,2038,2042,2043,2044],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[169,49,78],[173,39,83],[187,39,70,],0xFFFFFF,[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2039,2045,2046,2047,2056,2057],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[162,60,48],[151,60,58],[176,55,60,],0xFFFFFF,[2034,2040,3980,3986],[2034,2035,2040,2041],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[151,60,58],[164,55,72],[176,55,60,],0xFFFFFF,[2034,2035,2040,2041],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[176,55,60],[164,55,72],[182,49,66,],0xFFFFFF,[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2036,2037,2038,2042,2043,2044]],
[[164,55,72],[169,49,78],[182,49,66,],0xFFFFFF,[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2036,2037,2038,2042,2043,2044]],
[[182,49,66],[169,49,78],[187,39,70,],0xFFFFFF,[2036,2037,2038,2042,2043,2044],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[169,49,78],[173,39,83],[187,39,70,],0xFFFFFF,[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2039,2045,2046,2047,2056,2057],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[187,39,70],[173,39,83],[189,29,72,],0xFFFFFF,[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018],[2039,2045,2046,2047,2056,2057],[2046,2047,2048,2056,2057,2058]],
[[173,39,83],[175,29,86],[189,29,72,],0xFFFFFF,[2039,2045,2046,2047,2056,2057],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2046,2047,2048,2056,2057,2058]],
[[189,29,72],[175,29,86],[191,19,74,],0xFFFFFF,[2046,2047,2048,2056,2057,2058],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2048,2049,2050,2058,2059,2060]],
[[175,29,86],[177,19,87],[191,19,74,],0xFFFFFF,[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[2048,2049,2050,2058,2059,2060]],
[[191,19,74],[177,19,87],[192,9,75,],0xFFFFFF,[2048,2049,2050,2058,2059,2060],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961]],
[[177,19,87],[178,9,89],[192,9,75,],0xFFFFFF,[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[2051,2052,2053,2061,2062,2063],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961]],
[[192,9,75],[178,9,89],[193,-1,76,],0xFFFFFF,[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[2051,2052,2053,2061,2062,2063],[2052,2053,2054,2062,2063,2064]],
[[178,9,89],[179,-1,90],[193,-1,76,],0xFFFFFF,[2051,2052,2053,2061,2062,2063],[2053,2054,2055,2063,2064,2065],[2052,2053,2054,2062,2063,2064]],
[[193,-1,76],[179,-1,90],[194,-11,77,],0xFFFFFF,[2052,2053,2054,2062,2063,2064],[2053,2054,2055,2063,2064,2065],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[179,-1,90],[179,-11,91],[194,-11,77,],0xFFFFFF,[2053,2054,2055,2063,2064,2065],[2055,2065,2066,2067,2074,2075],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[187,39,70],[173,39,83],[189,29,72,],0xFFFFFF,[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018],[2039,2045,2046,2047,2056,2057],[2046,2047,2048,2056,2057,2058]],
[[173,39,83],[175,29,86],[189,29,72,],0xFFFFFF,[2039,2045,2046,2047,2056,2057],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2046,2047,2048,2056,2057,2058]],
[[189,29,72],[175,29,86],[191,19,74,],0xFFFFFF,[2046,2047,2048,2056,2057,2058],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2048,2049,2050,2058,2059,2060]],
[[175,29,86],[177,19,87],[191,19,74,],0xFFFFFF,[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[2048,2049,2050,2058,2059,2060]],
[[191,19,74],[177,19,87],[192,9,75,],0xFFFFFF,[2048,2049,2050,2058,2059,2060],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961]],
[[177,19,87],[178,9,89],[192,9,75,],0xFFFFFF,[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[2051,2052,2053,2061,2062,2063],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961]],
[[192,9,75],[178,9,89],[193,-1,76,],0xFFFFFF,[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[2051,2052,2053,2061,2062,2063],[2052,2053,2054,2062,2063,2064]],
[[178,9,89],[179,-1,90],[193,-1,76,],0xFFFFFF,[2051,2052,2053,2061,2062,2063],[2053,2054,2055,2063,2064,2065],[2052,2053,2054,2062,2063,2064]],
[[193,-1,76],[179,-1,90],[194,-11,77,],0xFFFFFF,[2052,2053,2054,2062,2063,2064],[2053,2054,2055,2063,2064,2065],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[179,-1,90],[179,-11,91],[194,-11,77,],0xFFFFFF,[2053,2054,2055,2063,2064,2065],[2055,2065,2066,2067,2074,2075],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[194,-11,77],[179,-11,91],[195,-21,77,],0xFFFFFF,[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028],[2055,2065,2066,2067,2074,2075],[2066,2067,2068,2074,2075,2076]],
[[179,-11,91],[180,-21,91],[195,-21,77,],0xFFFFFF,[2055,2065,2066,2067,2074,2075],[2067,2068,2069,2075,2076,2077],[2066,2067,2068,2074,2075,2076]],
[[195,-21,77],[180,-21,91],[195,-31,77,],0xFFFFFF,[2066,2067,2068,2074,2075,2076],[2067,2068,2069,2075,2076,2077],[2068,2069,2070,2076,2077,2078]],
[[180,-21,91],[180,-31,92],[195,-31,77,],0xFFFFFF,[2067,2068,2069,2075,2076,2077],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2068,2069,2070,2076,2077,2078]],
[[195,-31,77],[180,-31,92],[195,-41,77,],0xFFFFFF,[2068,2069,2070,2076,2077,2078],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[180,-31,92],[180,-41,92],[195,-41,77,],0xFFFFFF,[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2071,2072,2073,2079,2080,2081],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[195,-41,77],[180,-41,92],[194,-51,77,],0xFFFFFF,[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034],[2071,2072,2073,2079,2080,2081],[2072,2073,2080,2081,2082,2090]],
[[180,-41,92],[180,-51,91],[194,-51,77,],0xFFFFFF,[2071,2072,2073,2079,2080,2081],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2072,2073,2080,2081,2082,2090]],
[[194,-11,77],[179,-11,91],[195,-21,77,],0xFFFFFF,[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028],[2055,2065,2066,2067,2074,2075],[2066,2067,2068,2074,2075,2076]],
[[179,-11,91],[180,-21,91],[195,-21,77,],0xFFFFFF,[2055,2065,2066,2067,2074,2075],[2067,2068,2069,2075,2076,2077],[2066,2067,2068,2074,2075,2076]],
[[195,-21,77],[180,-21,91],[195,-31,77,],0xFFFFFF,[2066,2067,2068,2074,2075,2076],[2067,2068,2069,2075,2076,2077],[2068,2069,2070,2076,2077,2078]],
[[180,-21,91],[180,-31,92],[195,-31,77,],0xFFFFFF,[2067,2068,2069,2075,2076,2077],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2068,2069,2070,2076,2077,2078]],
[[195,-31,77],[180,-31,92],[195,-41,77,],0xFFFFFF,[2068,2069,2070,2076,2077,2078],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[180,-31,92],[180,-41,92],[195,-41,77,],0xFFFFFF,[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2071,2072,2073,2079,2080,2081],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[195,-41,77],[180,-41,92],[194,-51,77,],0xFFFFFF,[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034],[2071,2072,2073,2079,2080,2081],[2072,2073,2080,2081,2082,2090]],
[[180,-41,92],[180,-51,91],[194,-51,77,],0xFFFFFF,[2071,2072,2073,2079,2080,2081],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2072,2073,2080,2081,2082,2090]],
[[194,-51,77],[180,-51,91],[194,-61,76,],0xFFFFFF,[2072,2073,2080,2081,2082,2090],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[180,-51,91],[179,-61,90],[194,-61,76,],0xFFFFFF,[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2083,2084,2085,2091,2092,2093],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[194,-61,76],[179,-61,90],[192,-71,75,],0xFFFFFF,[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038],[2083,2084,2085,2091,2092,2093],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[179,-61,90],[178,-71,89],[192,-71,75,],0xFFFFFF,[2083,2084,2085,2091,2092,2093],[2085,2086,2087,2093,2094,2095],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[192,-71,75],[178,-71,89],[190,-81,73,],0xFFFFFF,[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040],[2085,2086,2087,2093,2094,2095],[2086,2087,2088,2094,2095,2096]],
[[178,-71,89],[176,-81,87],[190,-81,73,],0xFFFFFF,[2085,2086,2087,2093,2094,2095],[2087,2088,2089,2095,2096,2097],[2086,2087,2088,2094,2095,2096]],
[[190,-81,73],[176,-81,87],[188,-91,71,],0xFFFFFF,[2086,2087,2088,2094,2095,2096],[2087,2088,2089,2095,2096,2097],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[176,-81,87],[174,-91,84],[188,-91,71,],0xFFFFFF,[2087,2088,2089,2095,2096,2097],[2089,2097],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[194,-51,77],[180,-51,91],[194,-61,76,],0xFFFFFF,[2072,2073,2080,2081,2082,2090],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[180,-51,91],[179,-61,90],[194,-61,76,],0xFFFFFF,[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2083,2084,2085,2091,2092,2093],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[194,-61,76],[179,-61,90],[192,-71,75,],0xFFFFFF,[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038],[2083,2084,2085,2091,2092,2093],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[179,-61,90],[178,-71,89],[192,-71,75,],0xFFFFFF,[2083,2084,2085,2091,2092,2093],[2085,2086,2087,2093,2094,2095],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[192,-71,75],[178,-71,89],[190,-81,73,],0xFFFFFF,[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040],[2085,2086,2087,2093,2094,2095],[2086,2087,2088,2094,2095,2096]],
[[178,-71,89],[176,-81,87],[190,-81,73,],0xFFFFFF,[2085,2086,2087,2093,2094,2095],[2087,2088,2089,2095,2096,2097],[2086,2087,2088,2094,2095,2096]],
[[190,-81,73],[176,-81,87],[188,-91,71,],0xFFFFFF,[2086,2087,2088,2094,2095,2096],[2087,2088,2089,2095,2096,2097],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[176,-81,87],[174,-91,84],[188,-91,71,],0xFFFFFF,[2087,2088,2089,2095,2096,2097],[2089,2097],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[152,60,57],[140,60,65],[164,55,72,],0xFFFFFF,[2098,2104,4044,4050],[2098,2099,2104,2105,4044,4045,4050,4051],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[140,60,65],[150,55,81],[164,55,72,],0xFFFFFF,[2098,2099,2104,2105,4044,4045,4050,4051],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[164,55,72],[150,55,81],[169,49,78,],0xFFFFFF,[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2100,2101,2102,2106,2107,2108]],
[[150,55,81],[155,49,88],[169,49,78,],0xFFFFFF,[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2100,2101,2102,2106,2107,2108]],
[[169,49,78],[155,49,88],[173,39,83,],0xFFFFFF,[2100,2101,2102,2106,2107,2108],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2102,2103,2108,2109,2110,2120]],
[[155,49,88],[158,39,94],[173,39,83,],0xFFFFFF,[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2103,2109,2110,2111,2120,2121],[2102,2103,2108,2109,2110,2120]],
[[152,60,57],[140,60,65],[164,55,72,],0xFFFFFF,[2098,2104,4044,4050],[2098,2099,2104,2105,4044,4045,4050,4051],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[140,60,65],[150,55,81],[164,55,72,],0xFFFFFF,[2098,2099,2104,2105,4044,4045,4050,4051],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[164,55,72],[150,55,81],[169,49,78,],0xFFFFFF,[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2100,2101,2102,2106,2107,2108]],
[[150,55,81],[155,49,88],[169,49,78,],0xFFFFFF,[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2100,2101,2102,2106,2107,2108]],
[[169,49,78],[155,49,88],[173,39,83,],0xFFFFFF,[2100,2101,2102,2106,2107,2108],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2102,2103,2108,2109,2110,2120]],
[[155,49,88],[158,39,94],[173,39,83,],0xFFFFFF,[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2103,2109,2110,2111,2120,2121],[2102,2103,2108,2109,2110,2120]],
[[173,39,83],[158,39,94],[175,29,86,],0xFFFFFF,[2102,2103,2108,2109,2110,2120],[2103,2109,2110,2111,2120,2121],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[158,39,94],[159,29,96],[175,29,86,],0xFFFFFF,[2103,2109,2110,2111,2120,2121],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[175,29,86],[159,29,96],[177,19,87,],0xFFFFFF,[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2112,2113,2114,2122,2123,2124]],
[[159,29,96],[160,19,98],[177,19,87,],0xFFFFFF,[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2112,2113,2114,2122,2123,2124]],
[[177,19,87],[160,19,98],[178,9,89,],0xFFFFFF,[2112,2113,2114,2122,2123,2124],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2114,2115,2116,2124,2125,2126]],
[[160,19,98],[161,9,100],[178,9,89,],0xFFFFFF,[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2114,2115,2116,2124,2125,2126]],
[[178,9,89],[161,9,100],[179,-1,90,],0xFFFFFF,[2114,2115,2116,2124,2125,2126],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2116,2117,2118,2126,2127,2128]],
[[161,9,100],[162,-1,101],[179,-1,90,],0xFFFFFF,[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2117,2118,2119,2127,2128,2129],[2116,2117,2118,2126,2127,2128]],
[[179,-1,90],[162,-1,101],[179,-11,91,],0xFFFFFF,[2116,2117,2118,2126,2127,2128],[2117,2118,2119,2127,2128,2129],[2118,2119,2128,2129,2130,2138]],
[[162,-1,101],[162,-11,102],[179,-11,91,],0xFFFFFF,[2117,2118,2119,2127,2128,2129],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[2118,2119,2128,2129,2130,2138]],
[[173,39,83],[158,39,94],[175,29,86,],0xFFFFFF,[2102,2103,2108,2109,2110,2120],[2103,2109,2110,2111,2120,2121],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[158,39,94],[159,29,96],[175,29,86,],0xFFFFFF,[2103,2109,2110,2111,2120,2121],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[175,29,86],[159,29,96],[177,19,87,],0xFFFFFF,[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2112,2113,2114,2122,2123,2124]],
[[159,29,96],[160,19,98],[177,19,87,],0xFFFFFF,[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2112,2113,2114,2122,2123,2124]],
[[177,19,87],[160,19,98],[178,9,89,],0xFFFFFF,[2112,2113,2114,2122,2123,2124],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2114,2115,2116,2124,2125,2126]],
[[160,19,98],[161,9,100],[178,9,89,],0xFFFFFF,[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2114,2115,2116,2124,2125,2126]],
[[178,9,89],[161,9,100],[179,-1,90,],0xFFFFFF,[2114,2115,2116,2124,2125,2126],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2116,2117,2118,2126,2127,2128]],
[[161,9,100],[162,-1,101],[179,-1,90,],0xFFFFFF,[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2117,2118,2119,2127,2128,2129],[2116,2117,2118,2126,2127,2128]],
[[179,-1,90],[162,-1,101],[179,-11,91,],0xFFFFFF,[2116,2117,2118,2126,2127,2128],[2117,2118,2119,2127,2128,2129],[2118,2119,2128,2129,2130,2138]],
[[162,-1,101],[162,-11,102],[179,-11,91,],0xFFFFFF,[2117,2118,2119,2127,2128,2129],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[2118,2119,2128,2129,2130,2138]],
[[179,-11,91],[162,-11,102],[180,-21,91,],0xFFFFFF,[2118,2119,2128,2129,2130,2138],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[2130,2131,2132,2138,2139,2140]],
[[162,-11,102],[163,-21,103],[180,-21,91,],0xFFFFFF,[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[2131,2132,2133,2139,2140,2141],[2130,2131,2132,2138,2139,2140]],
[[180,-21,91],[163,-21,103],[180,-31,92,],0xFFFFFF,[2130,2131,2132,2138,2139,2140],[2131,2132,2133,2139,2140,2141],[2132,2133,2134,2140,2141,2142]],
[[163,-21,103],[163,-31,103],[180,-31,92,],0xFFFFFF,[2131,2132,2133,2139,2140,2141],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[2132,2133,2134,2140,2141,2142]],
[[180,-31,92],[163,-31,103],[180,-41,92,],0xFFFFFF,[2132,2133,2134,2140,2141,2142],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[2134,2135,2136,2142,2143,2144]],
[[163,-31,103],[163,-41,103],[180,-41,92,],0xFFFFFF,[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[2135,2136,2137,2143,2144,2145],[2134,2135,2136,2142,2143,2144]],
[[180,-41,92],[163,-41,103],[180,-51,91,],0xFFFFFF,[2134,2135,2136,2142,2143,2144],[2135,2136,2137,2143,2144,2145],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[163,-41,103],[163,-51,103],[180,-51,91,],0xFFFFFF,[2135,2136,2137,2143,2144,2145],[2137,2145,2146,2147,2154,2155],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[179,-11,91],[162,-11,102],[180,-21,91,],0xFFFFFF,[2118,2119,2128,2129,2130,2138],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[2130,2131,2132,2138,2139,2140]],
[[162,-11,102],[163,-21,103],[180,-21,91,],0xFFFFFF,[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[2131,2132,2133,2139,2140,2141],[2130,2131,2132,2138,2139,2140]],
[[180,-21,91],[163,-21,103],[180,-31,92,],0xFFFFFF,[2130,2131,2132,2138,2139,2140],[2131,2132,2133,2139,2140,2141],[2132,2133,2134,2140,2141,2142]],
[[163,-21,103],[163,-31,103],[180,-31,92,],0xFFFFFF,[2131,2132,2133,2139,2140,2141],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[2132,2133,2134,2140,2141,2142]],
[[180,-31,92],[163,-31,103],[180,-41,92,],0xFFFFFF,[2132,2133,2134,2140,2141,2142],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[2134,2135,2136,2142,2143,2144]],
[[163,-31,103],[163,-41,103],[180,-41,92,],0xFFFFFF,[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[2135,2136,2137,2143,2144,2145],[2134,2135,2136,2142,2143,2144]],
[[180,-41,92],[163,-41,103],[180,-51,91,],0xFFFFFF,[2134,2135,2136,2142,2143,2144],[2135,2136,2137,2143,2144,2145],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[163,-41,103],[163,-51,103],[180,-51,91,],0xFFFFFF,[2135,2136,2137,2143,2144,2145],[2137,2145,2146,2147,2154,2155],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[180,-51,91],[163,-51,103],[179,-61,90,],0xFFFFFF,[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100],[2137,2145,2146,2147,2154,2155],[2146,2147,2148,2154,2155,2156]],
[[163,-51,103],[162,-61,102],[179,-61,90,],0xFFFFFF,[2137,2145,2146,2147,2154,2155],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2146,2147,2148,2154,2155,2156]],
[[179,-61,90],[162,-61,102],[178,-71,89,],0xFFFFFF,[2146,2147,2148,2154,2155,2156],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[162,-61,102],[161,-71,100],[178,-71,89,],0xFFFFFF,[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[178,-71,89],[161,-71,100],[176,-81,87,],0xFFFFFF,[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2150,2151,2152,2158,2159,2160]],
[[161,-71,100],[160,-81,98],[176,-81,87,],0xFFFFFF,[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2151,2152,2153,2159,2160,2161],[2150,2151,2152,2158,2159,2160]],
[[176,-81,87],[160,-81,98],[174,-91,84,],0xFFFFFF,[2150,2151,2152,2158,2159,2160],[2151,2152,2153,2159,2160,2161],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[160,-81,98],[158,-91,95],[174,-91,84,],0xFFFFFF,[2151,2152,2153,2159,2160,2161],[2153,2161],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[180,-51,91],[163,-51,103],[179,-61,90,],0xFFFFFF,[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100],[2137,2145,2146,2147,2154,2155],[2146,2147,2148,2154,2155,2156]],
[[163,-51,103],[162,-61,102],[179,-61,90,],0xFFFFFF,[2137,2145,2146,2147,2154,2155],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2146,2147,2148,2154,2155,2156]],
[[179,-61,90],[162,-61,102],[178,-71,89,],0xFFFFFF,[2146,2147,2148,2154,2155,2156],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[162,-61,102],[161,-71,100],[178,-71,89,],0xFFFFFF,[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[178,-71,89],[161,-71,100],[176,-81,87,],0xFFFFFF,[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2150,2151,2152,2158,2159,2160]],
[[161,-71,100],[160,-81,98],[176,-81,87,],0xFFFFFF,[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2151,2152,2153,2159,2160,2161],[2150,2151,2152,2158,2159,2160]],
[[176,-81,87],[160,-81,98],[174,-91,84,],0xFFFFFF,[2150,2151,2152,2158,2159,2160],[2151,2152,2153,2159,2160,2161],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[160,-81,98],[158,-91,95],[174,-91,84,],0xFFFFFF,[2151,2152,2153,2159,2160,2161],[2153,2161],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[141,60,65],[128,60,71],[150,55,81,],0xFFFFFF,[2162,2168],[2162,2163,2168,2169,4108,4109,4114,4115],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[128,60,71],[136,55,87],[150,55,81,],0xFFFFFF,[2162,2163,2168,2169,4108,4109,4114,4115],[2163,2164,2165,2169,2170,2171],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[150,55,81],[136,55,87],[155,49,88,],0xFFFFFF,[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116],[2163,2164,2165,2169,2170,2171],[2164,2165,2166,2170,2171,2172]],
[[136,55,87],[139,49,95],[155,49,88,],0xFFFFFF,[2163,2164,2165,2169,2170,2171],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2164,2165,2166,2170,2171,2172]],
[[155,49,88],[139,49,95],[158,39,94,],0xFFFFFF,[2164,2165,2166,2170,2171,2172],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083]],
[[139,49,95],[141,39,101],[158,39,94,],0xFFFFFF,[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2167,2173,2174,2175,2184,2185],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083]],
[[141,60,65],[128,60,71],[150,55,81,],0xFFFFFF,[2162,2168],[2162,2163,2168,2169,4108,4109,4114,4115],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[128,60,71],[136,55,87],[150,55,81,],0xFFFFFF,[2162,2163,2168,2169,4108,4109,4114,4115],[2163,2164,2165,2169,2170,2171],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[150,55,81],[136,55,87],[155,49,88,],0xFFFFFF,[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116],[2163,2164,2165,2169,2170,2171],[2164,2165,2166,2170,2171,2172]],
[[136,55,87],[139,49,95],[155,49,88,],0xFFFFFF,[2163,2164,2165,2169,2170,2171],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2164,2165,2166,2170,2171,2172]],
[[155,49,88],[139,49,95],[158,39,94,],0xFFFFFF,[2164,2165,2166,2170,2171,2172],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083]],
[[139,49,95],[141,39,101],[158,39,94,],0xFFFFFF,[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2167,2173,2174,2175,2184,2185],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083]],
[[158,39,94],[141,39,101],[159,29,96,],0xFFFFFF,[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[2167,2173,2174,2175,2184,2185],[2174,2175,2176,2184,2185,2186]],
[[141,39,101],[142,29,104],[159,29,96,],0xFFFFFF,[2167,2173,2174,2175,2184,2185],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2174,2175,2176,2184,2185,2186]],
[[159,29,96],[142,29,104],[160,19,98,],0xFFFFFF,[2174,2175,2176,2184,2185,2186],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2176,2177,2178,2186,2187,2188]],
[[142,29,104],[142,19,106],[160,19,98,],0xFFFFFF,[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2176,2177,2178,2186,2187,2188]],
[[160,19,98],[142,19,106],[161,9,100,],0xFFFFFF,[2176,2177,2178,2186,2187,2188],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2178,2179,2180,2188,2189,2190]],
[[142,19,106],[143,9,108],[161,9,100,],0xFFFFFF,[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2178,2179,2180,2188,2189,2190]],
[[161,9,100],[143,9,108],[162,-1,101,],0xFFFFFF,[2178,2179,2180,2188,2189,2190],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[143,9,108],[143,-1,110],[162,-1,101,],0xFFFFFF,[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2181,2182,2183,2191,2192,2193],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[162,-1,101],[143,-1,110],[162,-11,102,],0xFFFFFF,[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[2181,2182,2183,2191,2192,2193],[2182,2183,2192,2193,2194,2202]],
[[143,-1,110],[144,-11,111],[162,-11,102,],0xFFFFFF,[2181,2182,2183,2191,2192,2193],[2183,2193,2194,2195,2202,2203],[2182,2183,2192,2193,2194,2202]],
[[158,39,94],[141,39,101],[159,29,96,],0xFFFFFF,[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[2167,2173,2174,2175,2184,2185],[2174,2175,2176,2184,2185,2186]],
[[141,39,101],[142,29,104],[159,29,96,],0xFFFFFF,[2167,2173,2174,2175,2184,2185],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2174,2175,2176,2184,2185,2186]],
[[159,29,96],[142,29,104],[160,19,98,],0xFFFFFF,[2174,2175,2176,2184,2185,2186],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2176,2177,2178,2186,2187,2188]],
[[142,29,104],[142,19,106],[160,19,98,],0xFFFFFF,[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2176,2177,2178,2186,2187,2188]],
[[160,19,98],[142,19,106],[161,9,100,],0xFFFFFF,[2176,2177,2178,2186,2187,2188],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2178,2179,2180,2188,2189,2190]],
[[142,19,106],[143,9,108],[161,9,100,],0xFFFFFF,[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2178,2179,2180,2188,2189,2190]],
[[161,9,100],[143,9,108],[162,-1,101,],0xFFFFFF,[2178,2179,2180,2188,2189,2190],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[143,9,108],[143,-1,110],[162,-1,101,],0xFFFFFF,[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2181,2182,2183,2191,2192,2193],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[162,-1,101],[143,-1,110],[162,-11,102,],0xFFFFFF,[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[2181,2182,2183,2191,2192,2193],[2182,2183,2192,2193,2194,2202]],
[[143,-1,110],[144,-11,111],[162,-11,102,],0xFFFFFF,[2181,2182,2183,2191,2192,2193],[2183,2193,2194,2195,2202,2203],[2182,2183,2192,2193,2194,2202]],
[[162,-11,102],[144,-11,111],[163,-21,103,],0xFFFFFF,[2182,2183,2192,2193,2194,2202],[2183,2193,2194,2195,2202,2203],[2194,2195,2196,2202,2203,2204]],
[[144,-11,111],[144,-21,111],[163,-21,103,],0xFFFFFF,[2183,2193,2194,2195,2202,2203],[2195,2196,2197,2203,2204,2205],[2194,2195,2196,2202,2203,2204]],
[[163,-21,103],[144,-21,111],[163,-31,103,],0xFFFFFF,[2194,2195,2196,2202,2203,2204],[2195,2196,2197,2203,2204,2205],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[144,-21,111],[144,-31,112],[163,-31,103,],0xFFFFFF,[2195,2196,2197,2203,2204,2205],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[163,-31,103],[144,-31,112],[163,-41,103,],0xFFFFFF,[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2198,2199,2200,2206,2207,2208]],
[[144,-31,112],[144,-41,111],[163,-41,103,],0xFFFFFF,[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2199,2200,2201,2207,2208,2209],[2198,2199,2200,2206,2207,2208]],
[[163,-41,103],[144,-41,111],[163,-51,103,],0xFFFFFF,[2198,2199,2200,2206,2207,2208],[2199,2200,2201,2207,2208,2209],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[144,-41,111],[144,-51,111],[163,-51,103,],0xFFFFFF,[2199,2200,2201,2207,2208,2209],[2201,2209,2210,2211,2218,2219],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[162,-11,102],[144,-11,111],[163,-21,103,],0xFFFFFF,[2182,2183,2192,2193,2194,2202],[2183,2193,2194,2195,2202,2203],[2194,2195,2196,2202,2203,2204]],
[[144,-11,111],[144,-21,111],[163,-21,103,],0xFFFFFF,[2183,2193,2194,2195,2202,2203],[2195,2196,2197,2203,2204,2205],[2194,2195,2196,2202,2203,2204]],
[[163,-21,103],[144,-21,111],[163,-31,103,],0xFFFFFF,[2194,2195,2196,2202,2203,2204],[2195,2196,2197,2203,2204,2205],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[144,-21,111],[144,-31,112],[163,-31,103,],0xFFFFFF,[2195,2196,2197,2203,2204,2205],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[163,-31,103],[144,-31,112],[163,-41,103,],0xFFFFFF,[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2198,2199,2200,2206,2207,2208]],
[[144,-31,112],[144,-41,111],[163,-41,103,],0xFFFFFF,[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2199,2200,2201,2207,2208,2209],[2198,2199,2200,2206,2207,2208]],
[[163,-41,103],[144,-41,111],[163,-51,103,],0xFFFFFF,[2198,2199,2200,2206,2207,2208],[2199,2200,2201,2207,2208,2209],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[144,-41,111],[144,-51,111],[163,-51,103,],0xFFFFFF,[2199,2200,2201,2207,2208,2209],[2201,2209,2210,2211,2218,2219],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[163,-51,103],[144,-51,111],[162,-61,102,],0xFFFFFF,[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164],[2201,2209,2210,2211,2218,2219],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[144,-51,111],[144,-61,110],[162,-61,102,],0xFFFFFF,[2201,2209,2210,2211,2218,2219],[2211,2212,2213,2219,2220,2221],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[162,-61,102],[144,-61,110],[161,-71,100,],0xFFFFFF,[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166],[2211,2212,2213,2219,2220,2221],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[144,-61,110],[143,-71,108],[161,-71,100,],0xFFFFFF,[2211,2212,2213,2219,2220,2221],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[161,-71,100],[143,-71,108],[160,-81,98,],0xFFFFFF,[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2214,2215,2216,2222,2223,2224]],
[[143,-71,108],[142,-81,106],[160,-81,98,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2215,2216,2217,2223,2224,2225],[2214,2215,2216,2222,2223,2224]],
[[160,-81,98],[142,-81,106],[158,-91,95,],0xFFFFFF,[2214,2215,2216,2222,2223,2224],[2215,2216,2217,2223,2224,2225],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[142,-81,106],[141,-91,103],[158,-91,95,],0xFFFFFF,[2215,2216,2217,2223,2224,2225],[2217,2225,4145,4171],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[163,-51,103],[144,-51,111],[162,-61,102,],0xFFFFFF,[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164],[2201,2209,2210,2211,2218,2219],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[144,-51,111],[144,-61,110],[162,-61,102,],0xFFFFFF,[2201,2209,2210,2211,2218,2219],[2211,2212,2213,2219,2220,2221],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[162,-61,102],[144,-61,110],[161,-71,100,],0xFFFFFF,[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166],[2211,2212,2213,2219,2220,2221],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[144,-61,110],[143,-71,108],[161,-71,100,],0xFFFFFF,[2211,2212,2213,2219,2220,2221],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[161,-71,100],[143,-71,108],[160,-81,98,],0xFFFFFF,[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2214,2215,2216,2222,2223,2224]],
[[143,-71,108],[142,-81,106],[160,-81,98,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2215,2216,2217,2223,2224,2225],[2214,2215,2216,2222,2223,2224]],
[[160,-81,98],[142,-81,106],[158,-91,95,],0xFFFFFF,[2214,2215,2216,2222,2223,2224],[2215,2216,2217,2223,2224,2225],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[142,-81,106],[141,-91,103],[158,-91,95,],0xFFFFFF,[2215,2216,2217,2223,2224,2225],[2217,2225,4145,4171],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[130,60,70],[116,60,73],[136,55,87,],0xFFFFFF,[2226,2232,4172,4178],[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[116,60,73],[120,55,91],[136,55,87,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[2227,2228,2229,2233,2234,2235],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[136,55,87],[120,55,91],[139,49,95,],0xFFFFFF,[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180],[2227,2228,2229,2233,2234,2235],[2228,2229,2230,2234,2235,2236]],
[[120,55,91],[121,49,100],[139,49,95,],0xFFFFFF,[2227,2228,2229,2233,2234,2235],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[2228,2229,2230,2234,2235,2236]],
[[139,49,95],[121,49,100],[141,39,101,],0xFFFFFF,[2228,2229,2230,2234,2235,2236],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[2230,2231,2236,2237,2238,2248]],
[[121,49,100],[122,39,106],[141,39,101,],0xFFFFFF,[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[2231,2237,2238,2239,2248,2249],[2230,2231,2236,2237,2238,2248]],
[[130,60,70],[116,60,73],[136,55,87,],0xFFFFFF,[2226,2232,4172,4178],[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[116,60,73],[120,55,91],[136,55,87,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[2227,2228,2229,2233,2234,2235],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[136,55,87],[120,55,91],[139,49,95,],0xFFFFFF,[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180],[2227,2228,2229,2233,2234,2235],[2228,2229,2230,2234,2235,2236]],
[[120,55,91],[121,49,100],[139,49,95,],0xFFFFFF,[2227,2228,2229,2233,2234,2235],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[2228,2229,2230,2234,2235,2236]],
[[139,49,95],[121,49,100],[141,39,101,],0xFFFFFF,[2228,2229,2230,2234,2235,2236],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[2230,2231,2236,2237,2238,2248]],
[[121,49,100],[122,39,106],[141,39,101,],0xFFFFFF,[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[2231,2237,2238,2239,2248,2249],[2230,2231,2236,2237,2238,2248]],
[[141,39,101],[122,39,106],[142,29,104,],0xFFFFFF,[2230,2231,2236,2237,2238,2248],[2231,2237,2238,2239,2248,2249],[2238,2239,2240,2248,2249,2250]],
[[122,39,106],[123,29,109],[142,29,104,],0xFFFFFF,[2231,2237,2238,2239,2248,2249],[2239,2240,2241,2249,2250,2251],[2238,2239,2240,2248,2249,2250]],
[[142,29,104],[123,29,109],[142,19,106,],0xFFFFFF,[2238,2239,2240,2248,2249,2250],[2239,2240,2241,2249,2250,2251],[2240,2241,2242,2250,2251,2252]],
[[123,29,109],[123,19,111],[142,19,106,],0xFFFFFF,[2239,2240,2241,2249,2250,2251],[2241,2242,2243,2251,2252,2253],[2240,2241,2242,2250,2251,2252]],
[[142,19,106],[123,19,111],[143,9,108,],0xFFFFFF,[2240,2241,2242,2250,2251,2252],[2241,2242,2243,2251,2252,2253],[2242,2243,2244,2252,2253,2254]],
[[123,19,111],[123,9,113],[143,9,108,],0xFFFFFF,[2241,2242,2243,2251,2252,2253],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[2242,2243,2244,2252,2253,2254]],
[[143,9,108],[123,9,113],[143,-1,110,],0xFFFFFF,[2242,2243,2244,2252,2253,2254],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[2244,2245,2246,2254,2255,2256]],
[[123,9,113],[124,-1,114],[143,-1,110,],0xFFFFFF,[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[2245,2246,2247,2255,2256,2257],[2244,2245,2246,2254,2255,2256]],
[[143,-1,110],[124,-1,114],[144,-11,111,],0xFFFFFF,[2244,2245,2246,2254,2255,2256],[2245,2246,2247,2255,2256,2257],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[124,-1,114],[124,-11,116],[144,-11,111,],0xFFFFFF,[2245,2246,2247,2255,2256,2257],[2247,2257,2258,2259,2266,2267],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[141,39,101],[122,39,106],[142,29,104,],0xFFFFFF,[2230,2231,2236,2237,2238,2248],[2231,2237,2238,2239,2248,2249],[2238,2239,2240,2248,2249,2250]],
[[122,39,106],[123,29,109],[142,29,104,],0xFFFFFF,[2231,2237,2238,2239,2248,2249],[2239,2240,2241,2249,2250,2251],[2238,2239,2240,2248,2249,2250]],
[[142,29,104],[123,29,109],[142,19,106,],0xFFFFFF,[2238,2239,2240,2248,2249,2250],[2239,2240,2241,2249,2250,2251],[2240,2241,2242,2250,2251,2252]],
[[123,29,109],[123,19,111],[142,19,106,],0xFFFFFF,[2239,2240,2241,2249,2250,2251],[2241,2242,2243,2251,2252,2253],[2240,2241,2242,2250,2251,2252]],
[[142,19,106],[123,19,111],[143,9,108,],0xFFFFFF,[2240,2241,2242,2250,2251,2252],[2241,2242,2243,2251,2252,2253],[2242,2243,2244,2252,2253,2254]],
[[123,19,111],[123,9,113],[143,9,108,],0xFFFFFF,[2241,2242,2243,2251,2252,2253],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[2242,2243,2244,2252,2253,2254]],
[[143,9,108],[123,9,113],[143,-1,110,],0xFFFFFF,[2242,2243,2244,2252,2253,2254],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[2244,2245,2246,2254,2255,2256]],
[[123,9,113],[124,-1,114],[143,-1,110,],0xFFFFFF,[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[2245,2246,2247,2255,2256,2257],[2244,2245,2246,2254,2255,2256]],
[[143,-1,110],[124,-1,114],[144,-11,111,],0xFFFFFF,[2244,2245,2246,2254,2255,2256],[2245,2246,2247,2255,2256,2257],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[124,-1,114],[124,-11,116],[144,-11,111,],0xFFFFFF,[2245,2246,2247,2255,2256,2257],[2247,2257,2258,2259,2266,2267],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[144,-11,111],[124,-11,116],[144,-21,111,],0xFFFFFF,[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220],[2247,2257,2258,2259,2266,2267],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[124,-11,116],[124,-21,116],[144,-21,111,],0xFFFFFF,[2247,2257,2258,2259,2266,2267],[2259,2260,2261,2267,2268,2269],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[144,-21,111],[124,-21,116],[144,-31,112,],0xFFFFFF,[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222],[2259,2260,2261,2267,2268,2269],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[124,-21,116],[124,-31,117],[144,-31,112,],0xFFFFFF,[2259,2260,2261,2267,2268,2269],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[144,-31,112],[124,-31,117],[144,-41,111,],0xFFFFFF,[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[124,-31,117],[124,-41,116],[144,-41,111,],0xFFFFFF,[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2263,2264,2265,2271,2272,2273],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[144,-41,111],[124,-41,116],[144,-51,111,],0xFFFFFF,[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226],[2263,2264,2265,2271,2272,2273],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[124,-41,116],[124,-51,116],[144,-51,111,],0xFFFFFF,[2263,2264,2265,2271,2272,2273],[2265,2273,2274,2275,2282,2283],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[144,-11,111],[124,-11,116],[144,-21,111,],0xFFFFFF,[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220],[2247,2257,2258,2259,2266,2267],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[124,-11,116],[124,-21,116],[144,-21,111,],0xFFFFFF,[2247,2257,2258,2259,2266,2267],[2259,2260,2261,2267,2268,2269],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[144,-21,111],[124,-21,116],[144,-31,112,],0xFFFFFF,[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222],[2259,2260,2261,2267,2268,2269],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[124,-21,116],[124,-31,117],[144,-31,112,],0xFFFFFF,[2259,2260,2261,2267,2268,2269],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[144,-31,112],[124,-31,117],[144,-41,111,],0xFFFFFF,[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[124,-31,117],[124,-41,116],[144,-41,111,],0xFFFFFF,[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2263,2264,2265,2271,2272,2273],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[144,-41,111],[124,-41,116],[144,-51,111,],0xFFFFFF,[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226],[2263,2264,2265,2271,2272,2273],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[124,-41,116],[124,-51,116],[144,-51,111,],0xFFFFFF,[2263,2264,2265,2271,2272,2273],[2265,2273,2274,2275,2282,2283],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[144,-51,111],[124,-51,116],[144,-61,110,],0xFFFFFF,[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228],[2265,2273,2274,2275,2282,2283],[2274,2275,2276,2282,2283,2284]],
[[124,-51,116],[124,-61,115],[144,-61,110,],0xFFFFFF,[2265,2273,2274,2275,2282,2283],[2275,2276,2277,2283,2284,2285],[2274,2275,2276,2282,2283,2284]],
[[144,-61,110],[124,-61,115],[143,-71,108,],0xFFFFFF,[2274,2275,2276,2282,2283,2284],[2275,2276,2277,2283,2284,2285],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[124,-61,115],[123,-71,113],[143,-71,108,],0xFFFFFF,[2275,2276,2277,2283,2284,2285],[2277,2278,2279,2285,2286,2287],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[143,-71,108],[123,-71,113],[142,-81,106,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2277,2278,2279,2285,2286,2287],[2278,2279,2280,2286,2287,2288]],
[[123,-71,113],[123,-81,111],[142,-81,106,],0xFFFFFF,[2277,2278,2279,2285,2286,2287],[2279,2280,2281,2287,2288,2289],[2278,2279,2280,2286,2287,2288]],
[[142,-81,106],[123,-81,111],[141,-91,103,],0xFFFFFF,[2278,2279,2280,2286,2287,2288],[2279,2280,2281,2287,2288,2289],[2280,2281,2288,2289]],
[[123,-81,111],[123,-91,107],[141,-91,103,],0xFFFFFF,[2279,2280,2281,2287,2288,2289],[2281,2289,4209,4235],[2280,2281,2288,2289]],
[[144,-51,111],[124,-51,116],[144,-61,110,],0xFFFFFF,[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228],[2265,2273,2274,2275,2282,2283],[2274,2275,2276,2282,2283,2284]],
[[124,-51,116],[124,-61,115],[144,-61,110,],0xFFFFFF,[2265,2273,2274,2275,2282,2283],[2275,2276,2277,2283,2284,2285],[2274,2275,2276,2282,2283,2284]],
[[144,-61,110],[124,-61,115],[143,-71,108,],0xFFFFFF,[2274,2275,2276,2282,2283,2284],[2275,2276,2277,2283,2284,2285],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[124,-61,115],[123,-71,113],[143,-71,108,],0xFFFFFF,[2275,2276,2277,2283,2284,2285],[2277,2278,2279,2285,2286,2287],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[143,-71,108],[123,-71,113],[142,-81,106,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2277,2278,2279,2285,2286,2287],[2278,2279,2280,2286,2287,2288]],
[[123,-71,113],[123,-81,111],[142,-81,106,],0xFFFFFF,[2277,2278,2279,2285,2286,2287],[2279,2280,2281,2287,2288,2289],[2278,2279,2280,2286,2287,2288]],
[[142,-81,106],[123,-81,111],[141,-91,103,],0xFFFFFF,[2278,2279,2280,2286,2287,2288],[2279,2280,2281,2287,2288,2289],[2280,2281,2288,2289]],
[[123,-81,111],[123,-91,107],[141,-91,103,],0xFFFFFF,[2279,2280,2281,2287,2288,2289],[2281,2289,4209,4235],[2280,2281,2288,2289]],
[[40,60,-36],[48,60,-47],[25,55,-46,],0xFFFFFF,[2290,2292],[2290,2291,2292,2293],[2290,2291,2292,2293]],
[[48,60,-47],[34,55,-59],[25,55,-46,],0xFFFFFF,[2290,2291,2292,2293],[2291,2293],[2290,2291,2292,2293]],
[[40,60,-36],[48,60,-47],[25,55,-46,],0xFFFFFF,[2290,2292],[2290,2291,2292,2293],[2290,2291,2292,2293]],
[[48,60,-47],[34,55,-59],[25,55,-46,],0xFFFFFF,[2290,2291,2292,2293],[2291,2293],[2290,2291,2292,2293]],
[[47,60,-46],[58,60,-57],[34,55,-59,],0xFFFFFF,[2294,2296],[2294,2295,2296,2297],[2294,2295,2296,2297]],
[[58,60,-57],[46,55,-71],[34,55,-59,],0xFFFFFF,[2294,2295,2296,2297],[2295,2297],[2294,2295,2296,2297]],
[[47,60,-46],[58,60,-57],[34,55,-59,],0xFFFFFF,[2294,2296],[2294,2295,2296,2297],[2294,2295,2296,2297]],
[[58,60,-57],[46,55,-71],[34,55,-59,],0xFFFFFF,[2294,2295,2296,2297],[2295,2297],[2294,2295,2296,2297]],
[[163,60,-46],[171,60,-34],[178,55,-58,],0xFFFFFF,[2298,2300],[2298,2299,2300,2301],[2298,2299,2300,2301]],
[[171,60,-34],[187,55,-44],[178,55,-58,],0xFFFFFF,[2298,2299,2300,2301],[2299,2301],[2298,2299,2300,2301]],
[[163,60,-46],[171,60,-34],[178,55,-58,],0xFFFFFF,[2298,2300],[2298,2299,2300,2301],[2298,2299,2300,2301]],
[[171,60,-34],[187,55,-44],[178,55,-58,],0xFFFFFF,[2298,2299,2300,2301],[2299,2301],[2298,2299,2300,2301]],
[[154,60,-56],[164,60,-45],[166,55,-70,],0xFFFFFF,[2302,2304],[2302,2303,2304,2305],[2302,2303,2304,2305]],
[[164,60,-45],[178,55,-58],[166,55,-70,],0xFFFFFF,[2302,2303,2304,2305],[2303,2305],[2302,2303,2304,2305]],
[[154,60,-56],[164,60,-45],[166,55,-70,],0xFFFFFF,[2302,2304],[2302,2303,2304,2305],[2302,2303,2304,2305]],
[[164,60,-45],[178,55,-58],[166,55,-70,],0xFFFFFF,[2302,2303,2304,2305],[2303,2305],[2302,2303,2304,2305]],
[[35,60,-24],[41,60,-37],[18,55,-31,],0xFFFFFF,[2306,2599],[2306,2307,2477,2599,2600,2770],[2306,2307,2308,2599,2600,2601]],
[[41,60,-37],[25,55,-46],[18,55,-31,],0xFFFFFF,[2306,2307,2477,2599,2600,2770],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2306,2307,2308,2599,2600,2601]],
[[18,55,-31],[25,55,-46],[10,49,-34,],0xFFFFFF,[2306,2307,2308,2599,2600,2601],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2308,2309,2310,2601,2602,2603]],
[[25,55,-46],[18,49,-50],[10,49,-34,],0xFFFFFF,[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2308,2309,2310,2601,2602,2603]],
[[10,49,-34],[18,49,-50],[4,39,-36,],0xFFFFFF,[2308,2309,2310,2601,2602,2603],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2310,2311,2312,2603,2604,2605]],
[[18,49,-50],[12,39,-53],[4,39,-36,],0xFFFFFF,[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2310,2311,2312,2603,2604,2605]],
[[4,39,-36],[12,39,-53],[1,29,-37,],0xFFFFFF,[2310,2311,2312,2603,2604,2605],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2312,2313,2314,2605,2606,2607]],
[[12,39,-53],[10,29,-55],[1,29,-37,],0xFFFFFF,[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[2312,2313,2314,2605,2606,2607]],
[[1,29,-37],[10,29,-55],[0,19,-38,],0xFFFFFF,[2312,2313,2314,2605,2606,2607],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609]],
[[10,29,-55],[8,19,-56],[0,19,-38,],0xFFFFFF,[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609]],
[[0,19,-38],[8,19,-56],[-1,9,-39,],0xFFFFFF,[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[8,19,-56],[6,9,-57],[-1,9,-39,],0xFFFFFF,[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[-1,9,-39],[6,9,-57],[-3,-1,-39,],0xFFFFFF,[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[2318,2319,2320,2611,2612,2613]],
[[6,9,-57],[5,-1,-58],[-3,-1,-39,],0xFFFFFF,[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[2319,2320,2321,2402,2612,2613,2614,2695],[2318,2319,2320,2611,2612,2613]],
[[-3,-1,-39],[5,-1,-58],[-4,-11,-40,],0xFFFFFF,[2318,2319,2320,2611,2612,2613],[2319,2320,2321,2402,2612,2613,2614,2695],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[5,-1,-58],[4,-11,-58],[-4,-11,-40,],0xFFFFFF,[2319,2320,2321,2402,2612,2613,2614,2695],[2321,2322,2323,2614,2615,2616],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[-4,-11,-40],[4,-11,-58],[-5,-21,-40,],0xFFFFFF,[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[2321,2322,2323,2614,2615,2616],[2322,2323,2324,2615,2616,2617]],
[[4,-11,-58],[3,-21,-59],[-5,-21,-40,],0xFFFFFF,[2321,2322,2323,2614,2615,2616],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[2322,2323,2324,2615,2616,2617]],
[[-5,-21,-40],[3,-21,-59],[-5,-31,-40,],0xFFFFFF,[2322,2323,2324,2615,2616,2617],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945]],
[[3,-21,-59],[3,-31,-59],[-5,-31,-40,],0xFFFFFF,[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945]],
[[-5,-31,-40],[3,-31,-59],[-5,-41,-40,],0xFFFFFF,[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2326,2327,2328,2619,2620,2621]],
[[3,-31,-59],[3,-41,-59],[-5,-41,-40,],0xFFFFFF,[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2327,2328,2329,2620,2621,2622],[2326,2327,2328,2619,2620,2621]],
[[-5,-41,-40],[3,-41,-59],[-4,-51,-40,],0xFFFFFF,[2326,2327,2328,2619,2620,2621],[2327,2328,2329,2620,2621,2622],[2328,2329,2330,2621,2622,2623]],
[[3,-41,-59],[3,-51,-58],[-4,-51,-40,],0xFFFFFF,[2327,2328,2329,2620,2621,2622],[2329,2330,2331,2622,2623,2624],[2328,2329,2330,2621,2622,2623]],
[[-4,-51,-40],[3,-51,-58],[-3,-61,-39,],0xFFFFFF,[2328,2329,2330,2621,2622,2623],[2329,2330,2331,2622,2623,2624],[2330,2331,2332,2623,2624,2625]],
[[3,-51,-58],[4,-61,-58],[-3,-61,-39,],0xFFFFFF,[2329,2330,2331,2622,2623,2624],[2331,2332,2333,2624,2625,2626],[2330,2331,2332,2623,2624,2625]],
[[-3,-61,-39],[4,-61,-58],[-2,-71,-39,],0xFFFFFF,[2330,2331,2332,2623,2624,2625],[2331,2332,2333,2624,2625,2626],[2332,2333,2334,2625,2626,2627]],
[[4,-61,-58],[6,-71,-57],[-2,-71,-39,],0xFFFFFF,[2331,2332,2333,2624,2625,2626],[2333,2334,2335,2626,2627,2628],[2332,2333,2334,2625,2626,2627]],
[[-2,-71,-39],[6,-71,-57],[0,-81,-38,],0xFFFFFF,[2332,2333,2334,2625,2626,2627],[2333,2334,2335,2626,2627,2628],[2334,2335,2336,2627,2628,2629]],
[[6,-71,-57],[8,-81,-56],[0,-81,-38,],0xFFFFFF,[2333,2334,2335,2626,2627,2628],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2334,2335,2336,2627,2628,2629]],
[[0,-81,-38],[8,-81,-56],[3,-91,-37,],0xFFFFFF,[2334,2335,2336,2627,2628,2629],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2336,2337,2629,2630]],
[[8,-81,-56],[11,-91,-54],[3,-91,-37,],0xFFFFFF,[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2337,2418,2419,2630,2711,2712],[2336,2337,2629,2630]],
[[171,60,-35],[177,60,-22],[187,55,-44,],0xFFFFFF,[2338,2541,2631,2834],[2338,2339,2631,2632],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[177,60,-22],[193,55,-30],[187,55,-44,],0xFFFFFF,[2338,2339,2631,2632],[2339,2340,2341,2632,2633,2634],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[187,55,-44],[193,55,-30],[194,49,-49,],0xFFFFFF,[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2339,2340,2341,2632,2633,2634],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[193,55,-30],[201,49,-33],[194,49,-49,],0xFFFFFF,[2339,2340,2341,2632,2633,2634],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[194,49,-49],[201,49,-33],[200,39,-52,],0xFFFFFF,[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843]],
[[201,49,-33],[207,39,-35],[200,39,-52,],0xFFFFFF,[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[2343,2344,2345,2636,2637,2638],[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843]],
[[200,39,-52],[207,39,-35],[202,29,-53,],0xFFFFFF,[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843],[2343,2344,2345,2636,2637,2638],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885]],
[[207,39,-35],[210,29,-36],[202,29,-53,],0xFFFFFF,[2343,2344,2345,2636,2637,2638],[2345,2346,2347,2638,2639,2640],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885]],
[[202,29,-53],[210,29,-36],[204,19,-54,],0xFFFFFF,[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2345,2346,2347,2638,2639,2640],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840]],
[[210,29,-36],[212,19,-36],[204,19,-54,],0xFFFFFF,[2345,2346,2347,2638,2639,2640],[2347,2348,2349,2640,2641,2642],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840]],
[[204,19,-54],[212,19,-36],[206,9,-55,],0xFFFFFF,[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840],[2347,2348,2349,2640,2641,2642],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884]],
[[212,19,-36],[214,9,-37],[206,9,-55,],0xFFFFFF,[2347,2348,2349,2640,2641,2642],[2349,2350,2351,2642,2643,2644],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884]],
[[206,9,-55],[214,9,-37],[207,-1,-56,],0xFFFFFF,[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2349,2350,2351,2642,2643,2644],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[214,9,-37],[216,-1,-37],[207,-1,-56,],0xFFFFFF,[2349,2350,2351,2642,2643,2644],[2351,2352,2353,2644,2645,2646],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[207,-1,-56],[216,-1,-37],[208,-11,-56,],0xFFFFFF,[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2351,2352,2353,2644,2645,2646],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733]],
[[216,-1,-37],[217,-11,-38],[208,-11,-56,],0xFFFFFF,[2351,2352,2353,2644,2645,2646],[2353,2354,2355,2646,2647,2648],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733]],
[[208,-11,-56],[217,-11,-38],[209,-21,-57,],0xFFFFFF,[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2353,2354,2355,2646,2647,2648],[2354,2355,2356,2647,2648,2649]],
[[217,-11,-38],[217,-21,-38],[209,-21,-57,],0xFFFFFF,[2353,2354,2355,2646,2647,2648],[2355,2356,2357,2648,2649,2650],[2354,2355,2356,2647,2648,2649]],
[[209,-21,-57],[217,-21,-38],[209,-31,-57,],0xFFFFFF,[2354,2355,2356,2647,2648,2649],[2355,2356,2357,2648,2649,2650],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737]],
[[217,-21,-38],[218,-31,-38],[209,-31,-57,],0xFFFFFF,[2355,2356,2357,2648,2649,2650],[2357,2358,2359,2650,2651,2652],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737]],
[[209,-31,-57],[218,-31,-38],[209,-41,-57,],0xFFFFFF,[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[2357,2358,2359,2650,2651,2652],[2358,2359,2360,2651,2652,2653]],
[[218,-31,-38],[217,-41,-38],[209,-41,-57,],0xFFFFFF,[2357,2358,2359,2650,2651,2652],[2359,2360,2361,2652,2653,2654],[2358,2359,2360,2651,2652,2653]],
[[209,-41,-57],[217,-41,-38],[209,-51,-57,],0xFFFFFF,[2358,2359,2360,2651,2652,2653],[2359,2360,2361,2652,2653,2654],[2360,2361,2362,2653,2654,2655]],
[[217,-41,-38],[217,-51,-38],[209,-51,-57,],0xFFFFFF,[2359,2360,2361,2652,2653,2654],[2361,2362,2363,2654,2655,2656],[2360,2361,2362,2653,2654,2655]],
[[209,-51,-57],[217,-51,-38],[208,-61,-56,],0xFFFFFF,[2360,2361,2362,2653,2654,2655],[2361,2362,2363,2654,2655,2656],[2362,2363,2364,2655,2656,2657]],
[[217,-51,-38],[216,-61,-38],[208,-61,-56,],0xFFFFFF,[2361,2362,2363,2654,2655,2656],[2363,2364,2365,2656,2657,2658],[2362,2363,2364,2655,2656,2657]],
[[208,-61,-56],[216,-61,-38],[206,-71,-55,],0xFFFFFF,[2362,2363,2364,2655,2656,2657],[2363,2364,2365,2656,2657,2658],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[216,-61,-38],[214,-71,-37],[206,-71,-55,],0xFFFFFF,[2363,2364,2365,2656,2657,2658],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[206,-71,-55],[214,-71,-37],[204,-81,-54,],0xFFFFFF,[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747]],
[[214,-71,-37],[212,-81,-36],[204,-81,-54,],0xFFFFFF,[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747]],
[[204,-81,-54],[212,-81,-36],[201,-91,-52,],0xFFFFFF,[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[2368,2369,2454,2661,2662,2747]],
[[212,-81,-36],[209,-91,-35],[201,-91,-52,],0xFFFFFF,[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[2369,2662],[2368,2369,2454,2661,2662,2747]],
[[116,60,73],[105,55,92],[120,55,91,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[116,60,73],[107,60,74],[105,55,92,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[559,729,1586,1589,2371,2664],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[120,55,91],[106,49,101],[121,49,100,],0xFFFFFF,[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[560,562,730,732,2372,2374,2665,2667]],
[[105,55,92],[106,49,101],[120,55,91,],0xFFFFFF,[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[121,49,100],[106,49,101],[122,39,106,],0xFFFFFF,[560,562,730,732,2372,2374,2665,2667],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[106,49,101],[105,39,107],[122,39,106,],0xFFFFFF,[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[122,39,106],[105,39,107],[123,29,109,],0xFFFFFF,[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[105,39,107],[106,29,110],[123,29,109,],0xFFFFFF,[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[123,29,109],[106,29,110],[123,19,111,],0xFFFFFF,[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[106,29,110],[106,19,113],[123,19,111,],0xFFFFFF,[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[123,19,111],[106,19,113],[123,9,113,],0xFFFFFF,[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[106,19,113],[106,9,114],[123,9,113,],0xFFFFFF,[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[123,9,113],[106,9,114],[124,-1,114,],0xFFFFFF,[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[106,9,114],[105,-1,116],[124,-1,114,],0xFFFFFF,[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[124,-1,114],[105,-1,116],[124,-11,116,],0xFFFFFF,[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[105,-1,116],[105,-11,117],[124,-11,116,],0xFFFFFF,[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[124,-11,116],[105,-11,117],[124,-21,116,],0xFFFFFF,[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[105,-11,117],[106,-21,118],[124,-21,116,],0xFFFFFF,[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[124,-21,116],[106,-21,118],[124,-31,117,],0xFFFFFF,[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[106,-21,118],[106,-31,118],[124,-31,117,],0xFFFFFF,[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[124,-31,117],[106,-31,118],[124,-41,116,],0xFFFFFF,[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[106,-31,118],[104,-41,118],[124,-41,116,],0xFFFFFF,[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[124,-41,116],[104,-41,118],[124,-51,116,],0xFFFFFF,[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[104,-41,118],[104,-51,117],[124,-51,116,],0xFFFFFF,[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[124,-51,116],[104,-51,117],[124,-61,115,],0xFFFFFF,[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[104,-51,117],[105,-61,116],[124,-61,115,],0xFFFFFF,[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[124,-61,115],[105,-61,116],[123,-71,113,],0xFFFFFF,[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[105,-61,116],[105,-71,114],[123,-71,113,],0xFFFFFF,[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[123,-71,113],[105,-71,114],[123,-81,111,],0xFFFFFF,[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[105,-71,114],[105,-81,112],[123,-81,111,],0xFFFFFF,[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[123,-81,111],[105,-81,112],[123,-91,107,],0xFFFFFF,[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[588,589,758,759,2400,2401,2693,2694]],
[[105,-81,112],[106,-91,109],[123,-91,107,],0xFFFFFF,[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[589,759,2401,2694],[588,589,758,759,2400,2401,2693,2694]],
[[5,-1,-58],[19,-1,-74],[4,-11,-58,],0xFFFFFF,[2319,2320,2321,2402,2612,2613,2614,2695],[2402,2403,2695,2696],[2402,2403,2404,2695,2696,2697]],
[[19,-1,-74],[16,-11,-75],[4,-11,-58,],0xFFFFFF,[2402,2403,2695,2696],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2402,2403,2404,2695,2696,2697]],
[[4,-11,-58],[16,-11,-75],[3,-21,-59,],0xFFFFFF,[2402,2403,2404,2695,2696,2697],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2404,2405,2406,2697,2698,2699]],
[[16,-11,-75],[15,-21,-75],[3,-21,-59,],0xFFFFFF,[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2405,2406,2407,2698,2699,2700],[2404,2405,2406,2697,2698,2699]],
[[3,-21,-59],[15,-21,-75],[3,-31,-59,],0xFFFFFF,[2404,2405,2406,2697,2698,2699],[2405,2406,2407,2698,2699,2700],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701]],
[[15,-21,-75],[15,-31,-76],[3,-31,-59,],0xFFFFFF,[2405,2406,2407,2698,2699,2700],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701]],
[[3,-31,-59],[15,-31,-76],[3,-41,-59,],0xFFFFFF,[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2408,2409,2410,2701,2702,2703]],
[[15,-31,-76],[15,-41,-76],[3,-41,-59,],0xFFFFFF,[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[2408,2409,2410,2701,2702,2703]],
[[3,-41,-59],[15,-41,-76],[3,-51,-58,],0xFFFFFF,[2408,2409,2410,2701,2702,2703],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[15,-41,-76],[15,-51,-75],[3,-51,-58,],0xFFFFFF,[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[3,-51,-58],[15,-51,-75],[4,-61,-58,],0xFFFFFF,[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[2412,2413,2414,2705,2706,2707]],
[[15,-51,-75],[16,-61,-75],[4,-61,-58,],0xFFFFFF,[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2412,2413,2414,2705,2706,2707]],
[[4,-61,-58],[16,-61,-75],[6,-71,-57,],0xFFFFFF,[2412,2413,2414,2705,2706,2707],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2414,2415,2416,2707,2708,2709]],
[[16,-61,-75],[17,-71,-73],[6,-71,-57,],0xFFFFFF,[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2415,2416,2417,2708,2709,2710],[2414,2415,2416,2707,2708,2709]],
[[6,-71,-57],[17,-71,-73],[8,-81,-56,],0xFFFFFF,[2414,2415,2416,2707,2708,2709],[2415,2416,2417,2708,2709,2710],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711]],
[[17,-71,-73],[19,-81,-72],[8,-81,-56,],0xFFFFFF,[2415,2416,2417,2708,2709,2710],[2417,2418,2419,2710,2711,2712],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711]],
[[8,-81,-56],[19,-81,-72],[11,-91,-54,],0xFFFFFF,[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2417,2418,2419,2710,2711,2712],[2337,2418,2419,2630,2711,2712]],
[[19,-81,-72],[22,-91,-70],[11,-91,-54,],0xFFFFFF,[2417,2418,2419,2710,2711,2712],[2419,2712],[2337,2418,2419,2630,2711,2712]],
[[19,-1,-74],[31,-1,-89],[16,-11,-75,],0xFFFFFF,[2420,2713],[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715]],
[[31,-1,-89],[30,-11,-89],[16,-11,-75,],0xFFFFFF,[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715]],
[[16,-11,-75],[30,-11,-89],[15,-21,-75,],0xFFFFFF,[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2422,2423,2424,2715,2716,2717]],
[[30,-11,-89],[30,-21,-90],[15,-21,-75,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2422,2423,2424,2715,2716,2717]],
[[15,-21,-75],[30,-21,-90],[15,-31,-76,],0xFFFFFF,[2422,2423,2424,2715,2716,2717],[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719]],
[[30,-21,-90],[29,-31,-90],[15,-31,-76,],0xFFFFFF,[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719]],
[[15,-31,-76],[29,-31,-90],[15,-41,-76,],0xFFFFFF,[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721]],
[[29,-31,-90],[29,-41,-90],[15,-41,-76,],0xFFFFFF,[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721]],
[[15,-41,-76],[29,-41,-90],[15,-51,-75,],0xFFFFFF,[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723]],
[[29,-41,-90],[30,-51,-90],[15,-51,-75,],0xFFFFFF,[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723]],
[[15,-51,-75],[30,-51,-90],[16,-61,-75,],0xFFFFFF,[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725]],
[[30,-51,-90],[30,-61,-89],[16,-61,-75,],0xFFFFFF,[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725]],
[[16,-61,-75],[30,-61,-89],[17,-71,-73,],0xFFFFFF,[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2432,2433,2434,2725,2726,2727]],
[[30,-61,-89],[32,-71,-88],[17,-71,-73,],0xFFFFFF,[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2432,2433,2434,2725,2726,2727]],
[[17,-71,-73],[32,-71,-88],[19,-81,-72,],0xFFFFFF,[2432,2433,2434,2725,2726,2727],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2434,2435,2436,2727,2728,2729]],
[[32,-71,-88],[33,-81,-86],[19,-81,-72,],0xFFFFFF,[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2434,2435,2436,2727,2728,2729]],
[[19,-81,-72],[33,-81,-86],[22,-91,-70,],0xFFFFFF,[2434,2435,2436,2727,2728,2729],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2436,2437,2729,2730]],
[[33,-81,-86],[35,-91,-83],[22,-91,-70,],0xFFFFFF,[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2437,2516,2527,2730,2809,2820],[2436,2437,2729,2730]],
[[207,-1,-56],[208,-11,-56],[197,-11,-73,],0xFFFFFF,[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829]],
[[197,-11,-73],[208,-11,-56],[197,-21,-74,],0xFFFFFF,[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2439,2440,2441,2732,2733,2734]],
[[208,-11,-56],[209,-21,-57],[197,-21,-74,],0xFFFFFF,[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2440,2441,2442,2733,2734,2735],[2439,2440,2441,2732,2733,2734]],
[[197,-21,-74],[209,-21,-57],[198,-31,-74,],0xFFFFFF,[2439,2440,2441,2732,2733,2734],[2440,2441,2442,2733,2734,2735],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755]],
[[209,-21,-57],[209,-31,-57],[198,-31,-74,],0xFFFFFF,[2440,2441,2442,2733,2734,2735],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755]],
[[198,-31,-74],[209,-31,-57],[198,-41,-74,],0xFFFFFF,[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757]],
[[209,-31,-57],[209,-41,-57],[198,-41,-74,],0xFFFFFF,[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[2444,2445,2446,2737,2738,2739],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757]],
[[198,-41,-74],[209,-41,-57],[197,-51,-74,],0xFFFFFF,[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2444,2445,2446,2737,2738,2739],[2445,2446,2447,2738,2739,2740]],
[[209,-41,-57],[209,-51,-57],[197,-51,-74,],0xFFFFFF,[2444,2445,2446,2737,2738,2739],[2446,2447,2448,2739,2740,2741],[2445,2446,2447,2738,2739,2740]],
[[197,-51,-74],[209,-51,-57],[196,-61,-73,],0xFFFFFF,[2445,2446,2447,2738,2739,2740],[2446,2447,2448,2739,2740,2741],[2447,2448,2449,2740,2741,2742]],
[[209,-51,-57],[208,-61,-56],[196,-61,-73,],0xFFFFFF,[2446,2447,2448,2739,2740,2741],[2448,2449,2450,2741,2742,2743],[2447,2448,2449,2740,2741,2742]],
[[196,-61,-73],[208,-61,-56],[195,-71,-72,],0xFFFFFF,[2447,2448,2449,2740,2741,2742],[2448,2449,2450,2741,2742,2743],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[208,-61,-56],[206,-71,-55],[195,-71,-72,],0xFFFFFF,[2448,2449,2450,2741,2742,2743],[2450,2451,2452,2743,2744,2745],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[195,-71,-72],[206,-71,-55],[193,-81,-70,],0xFFFFFF,[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744],[2450,2451,2452,2743,2744,2745],[2451,2452,2453,2744,2745,2746]],
[[206,-71,-55],[204,-81,-54],[193,-81,-70,],0xFFFFFF,[2450,2451,2452,2743,2744,2745],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2451,2452,2453,2744,2745,2746]],
[[193,-81,-70],[204,-81,-54],[190,-91,-68,],0xFFFFFF,[2451,2452,2453,2744,2745,2746],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2453,2454,2746,2747]],
[[204,-81,-54],[201,-91,-52],[190,-91,-68,],0xFFFFFF,[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2368,2369,2454,2661,2662,2747],[2453,2454,2746,2747]],
[[182,-1,-87],[194,-1,-73],[183,-11,-88,],0xFFFFFF,[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2455,2456,2536,2748,2749,2829],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[194,-1,-73],[197,-11,-73],[183,-11,-88,],0xFFFFFF,[2455,2456,2536,2748,2749,2829],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[183,-11,-88],[197,-11,-73],[183,-21,-89,],0xFFFFFF,[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866]],
[[197,-11,-73],[197,-21,-74],[183,-21,-89,],0xFFFFFF,[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2458,2459,2460,2751,2752,2753],[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866]],
[[183,-21,-89],[197,-21,-74],[183,-31,-89,],0xFFFFFF,[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2458,2459,2460,2751,2752,2753],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864]],
[[197,-21,-74],[198,-31,-74],[183,-31,-89,],0xFFFFFF,[2458,2459,2460,2751,2752,2753],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864]],
[[183,-31,-89],[198,-31,-74],[183,-41,-89,],0xFFFFFF,[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863]],
[[198,-31,-74],[198,-41,-74],[183,-41,-89,],0xFFFFFF,[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863]],
[[183,-41,-89],[198,-41,-74],[183,-51,-88,],0xFFFFFF,[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862]],
[[198,-41,-74],[197,-51,-74],[183,-51,-88,],0xFFFFFF,[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2464,2465,2466,2757,2758,2759],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862]],
[[183,-51,-88],[197,-51,-74],[182,-61,-88,],0xFFFFFF,[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862],[2464,2465,2466,2757,2758,2759],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[197,-51,-74],[196,-61,-73],[182,-61,-88,],0xFFFFFF,[2464,2465,2466,2757,2758,2759],[2466,2467,2468,2759,2760,2761],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[182,-61,-88],[196,-61,-73],[181,-71,-86,],0xFFFFFF,[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861],[2466,2467,2468,2759,2760,2761],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859]],
[[196,-61,-73],[195,-71,-72],[181,-71,-86,],0xFFFFFF,[2466,2467,2468,2759,2760,2761],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859]],
[[181,-71,-86],[195,-71,-72],[179,-81,-84,],0xFFFFFF,[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858]],
[[195,-71,-72],[193,-81,-70],[179,-81,-84,],0xFFFFFF,[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[2470,2471,2472,2763,2764,2765],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858]],
[[179,-81,-84],[193,-81,-70],[177,-91,-82,],0xFFFFFF,[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858],[2470,2471,2472,2763,2764,2765],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[193,-81,-70],[190,-91,-68],[177,-91,-82,],0xFFFFFF,[2470,2471,2472,2763,2764,2765],[2472,2765],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[19,43,-49],[25,43,-46],[14,14,-53,],0x000000,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779]],
[[25,43,-46],[20,14,-49],[14,14,-53,],0x000000,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779]],
[[14,14,-53],[20,14,-49],[13,9,-53,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2475,2476,2486,2495,2768,2769,2779,2788]],
[[13,9,-53],[20,14,-49],[19,9,-49,],0xFFFFFF,[2475,2476,2486,2495,2768,2769,2779,2788],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790]],
[[30,48,-43],[25,55,-46],[41,60,-37,],0xFFFFFF,[2477,2478,2488,2770,2771,2781],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2306,2307,2477,2599,2600,2770]],
[[25,43,-46],[25,55,-46],[30,48,-43,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2477,2478,2488,2770,2771,2781]],
[[25,43,-46],[19,43,-49],[25,55,-46,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773]],
[[19,43,-49],[18,49,-50],[25,55,-46,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773]],
[[19,43,-49],[12,39,-53],[18,49,-50,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774]],
[[19,43,-49],[10,29,-55],[12,39,-53,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775]],
[[19,43,-49],[14,14,-53],[10,29,-55,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777]],
[[14,14,-53],[8,19,-56],[10,29,-55,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777]],
[[14,14,-53],[6,9,-57],[8,19,-56,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828]],
[[14,14,-53],[13,9,-53],[6,9,-57,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2475,2476,2486,2495,2768,2769,2779,2788],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779]],
[[13,9,-53],[5,-1,-57],[7,9,-57,],0xFFFFFF,[2487,2780],[2487,2535,2780,2828],[2487,2780]],
[[25,43,-46],[30,48,-43],[28,38,-44,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2477,2478,2488,2770,2771,2781],[2488,2489,2781,2782]],
[[25,43,-46],[28,38,-44],[26,28,-45,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2488,2489,2781,2782],[2489,2490,2491,2782,2783,2784]],
[[25,43,-46],[26,28,-45],[20,14,-49,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2489,2490,2491,2782,2783,2784],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785]],
[[20,14,-49],[26,28,-45],[25,18,-46,],0xFFFFFF,[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2489,2490,2491,2782,2783,2784],[2491,2492,2493,2784,2785,2786]],
[[20,14,-49],[25,18,-46],[19,9,-49,],0xFFFFFF,[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2491,2492,2493,2784,2785,2786],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790]],
[[25,18,-46],[24,8,-47],[19,9,-49,],0xFFFFFF,[2491,2492,2493,2784,2785,2786],[2493,2494,2786,2787],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790]],
[[19,9,-49],[24,8,-47],[23,-2,-47,],0xFFFFFF,[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2493,2494,2786,2787],[2494,2497,2787,2790]],
[[13,9,-53],[19,9,-49],[21,-1,-70,],0xFFFFFF,[2475,2476,2486,2495,2768,2769,2779,2788],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2495,2496,2498,2501,2788,2789,2791,2794]],
[[19,9,-49],[30,-1,-63],[21,-1,-70,],0xFFFFFF,[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2495,2496,2498,2501,2788,2789,2791,2794]],
[[23,-2,-47],[19,9,-49],[30,-1,-63,],0xFFFFFF,[2494,2497,2787,2790],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797]],
[[21,-1,-70],[30,-1,-63],[33,-5,-86,],0xFFFFFF,[2495,2496,2498,2501,2788,2789,2791,2794],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796]],
[[30,-1,-63],[41,-5,-76],[33,-5,-86,],0xFFFFFF,[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796]],
[[33,-5,-86],[41,-5,-76],[33,-10,-86,],0xFFFFFF,[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796],[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825]],
[[21,-1,-70],[31,-1,-89],[33,-5,-86,],0xFFFFFF,[2495,2496,2498,2501,2788,2789,2791,2794],[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796]],
[[31,-1,-89],[33,-5,-86],[30,-11,-89,],0xFFFFFF,[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796],[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826]],
[[30,-11,-89],[33,-5,-86],[33,-10,-86,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825]],
[[41,-5,-76],[30,-1,-63],[45,-2,-72,],0xFFFFFF,[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2504,2505,2506,2797,2798,2799]],
[[41,-5,-76],[45,-2,-72],[41,-10,-77,],0xFFFFFF,[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2504,2505,2506,2797,2798,2799],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[41,-10,-77],[45,-2,-72],[44,-12,-72,],0xFFFFFF,[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822],[2504,2505,2506,2797,2798,2799],[2506,2517,2799,2810]],
[[41,-10,-76],[43,-46,-74],[36,-46,-82,],0x000000,[2507,2530,2800,2823],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827]],
[[36,-46,-82],[43,-46,-74],[39,-83,-78,],0x000000,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821]],
[[43,-46,-74],[47,-83,-70],[39,-83,-78,],0x000000,[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821]],
[[36,-46,-82],[29,-41,-90],[29,-31,-90,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827]],
[[36,-46,-82],[30,-51,-90],[29,-41,-90,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804]],
[[36,-46,-82],[30,-61,-89],[30,-51,-90,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805]],
[[36,-46,-82],[32,-71,-88],[30,-61,-89,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806]],
[[36,-46,-82],[39,-83,-78],[32,-71,-88,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808]],
[[39,-83,-78],[33,-81,-86],[32,-71,-88,],0xFFFFFF,[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808]],
[[39,-83,-78],[35,-91,-83],[33,-81,-86,],0xFFFFFF,[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2437,2516,2527,2730,2809,2820],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809]],
[[44,-12,-72],[45,-22,-72],[41,-10,-77,],0xFFFFFF,[2506,2517,2799,2810],[2517,2518,2810,2811],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[45,-22,-72],[45,-32,-71],[41,-10,-77,],0xFFFFFF,[2517,2518,2810,2811],[2518,2519,2520,2811,2812,2813],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[45,-32,-71],[43,-46,-74],[41,-10,-77,],0xFFFFFF,[2518,2519,2520,2811,2812,2813],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[45,-32,-71],[46,-42,-70],[43,-46,-74,],0xFFFFFF,[2518,2519,2520,2811,2812,2813],[2520,2521,2813,2814],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816]],
[[43,-46,-74],[46,-42,-70],[47,-52,-69,],0xFFFFFF,[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2520,2521,2813,2814],[2521,2522,2814,2815]],
[[43,-46,-74],[47,-52,-69],[49,-62,-67,],0xFFFFFF,[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2521,2522,2814,2815],[2522,2523,2524,2815,2816,2817]],
[[49,-62,-67],[47,-83,-70],[43,-46,-74,],0xFFFFFF,[2522,2523,2524,2815,2816,2817],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816]],
[[49,-62,-67],[51,-72,-65],[47,-83,-70,],0xFFFFFF,[2522,2523,2524,2815,2816,2817],[2524,2525,2817,2818],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821]],
[[51,-72,-65],[53,-82,-62],[47,-83,-70,],0xFFFFFF,[2524,2525,2817,2818],[2525,2526,2818,2819],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821]],
[[47,-83,-70],[53,-82,-62],[55,-92,-59,],0xFFFFFF,[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821],[2525,2526,2818,2819],[2526,2527,2528,2819,2820,2821]],
[[39,-83,-78],[55,-92,-59],[35,-91,-83,],0xFFFFFF,[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2526,2527,2528,2819,2820,2821],[2437,2516,2527,2730,2809,2820]],
[[55,-92,-59],[39,-83,-78],[47,-83,-70,],0xFFFFFF,[2526,2527,2528,2819,2820,2821],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821]],
[[33,-10,-86],[41,-5,-76],[41,-10,-77,],0xFFFFFF,[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825],[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[41,-10,-76],[36,-46,-82],[33,-10,-86,],0x000000,[2507,2530,2800,2823],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825]],
[[30,-11,-89],[33,-10,-86],[36,-46,-82,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827]],
[[30,-11,-89],[33,-10,-86],[36,-46,-82,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827]],
[[30,-11,-89],[36,-46,-82],[30,-21,-90,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827]],
[[30,-21,-90],[36,-46,-82],[29,-31,-90,],0xFFFFFF,[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827]],
[[31,-1,-89],[5,-1,-57],[8,19,-56,],0xFFFFFF,[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2487,2535,2780,2828],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828]],
[[207,-1,-56],[197,-11,-73],[194,-1,-73,],0xFFFFFF,[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2455,2456,2536,2748,2749,2829]],
[[185,43,-45],[191,43,-49],[190,11,-48,],0x000000,[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891]],
[[190,11,-48],[191,43,-49],[198,11,-53,],0x000000,[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841]],
[[190,11,-48],[198,11,-53],[191,6,-49,],0xFFFFFF,[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2539,2540,2590,2598,2832,2833,2883,2891]],
[[191,6,-49],[198,11,-53],[199,6,-54,],0xFFFFFF,[2539,2540,2590,2598,2832,2833,2883,2891],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2540,2544,2545,2833,2837,2838]],
[[171,60,-35],[187,55,-44],[180,48,-44,],0xFFFFFF,[2338,2541,2631,2834],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2541,2542,2834,2835]],
[[180,48,-44],[187,55,-44],[185,43,-45,],0xFFFFFF,[2541,2542,2834,2835],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888]],
[[187,55,-44],[191,43,-49],[185,43,-45,],0xFFFFFF,[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888]],
[[199,6,-54],[206,9,-55],[207,-1,-56,],0xFFFFFF,[2540,2544,2545,2833,2837,2838],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[206,9,-55],[199,6,-54],[198,11,-53,],0xFFFFFF,[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2540,2544,2545,2833,2837,2838],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841]],
[[198,11,-53],[204,19,-54],[206,9,-55,],0xFFFFFF,[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884]],
[[198,11,-53],[202,29,-53],[204,19,-54,],0xFFFFFF,[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840]],
[[202,29,-53],[198,11,-53],[191,43,-49,],0xFFFFFF,[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844]],
[[191,43,-49],[200,39,-52],[202,29,-53,],0xFFFFFF,[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885]],
[[200,39,-52],[191,43,-49],[194,49,-49,],0xFFFFFF,[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[191,43,-49],[187,55,-44],[194,49,-49,],0xFFFFFF,[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[181,1,-63],[180,5,-62],[188,1,-69,],0xFFFFFF,[2552,2845],[2552,2553,2590,2845,2846,2883],[2552,2553,2554,2845,2846,2847]],
[[188,1,-69],[180,5,-62],[187,5,-68,],0xFFFFFF,[2552,2553,2554,2845,2846,2847],[2552,2553,2590,2845,2846,2883],[2553,2554,2846,2847]],
[[188,1,-69],[187,5,-68],[207,-1,-56,],0xFFFFFF,[2552,2553,2554,2845,2846,2847],[2553,2554,2846,2847],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[168,-1,-74],[168,1,-74],[174,-1,-81,],0xFFFFFF,[2555,2557,2563,2575,2848,2850,2856,2868],[2555,2556,2563,2848,2849,2856],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884]],
[[174,-1,-81],[168,1,-74],[173,1,-80,],0xFFFFFF,[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884],[2555,2556,2563,2848,2849,2856],[2556,2849]],
[[168,-1,-74],[174,-1,-81],[169,-6,-75,],0xFFFFFF,[2555,2557,2563,2575,2848,2850,2856,2868],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871]],
[[174,-1,-81],[176,-6,-84],[169,-6,-75,],0xFFFFFF,[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871]],
[[169,-6,-75],[176,-6,-84],[167,-41,-73,],0x000000,[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876]],
[[167,-41,-73],[176,-6,-84],[175,-41,-82,],0x000000,[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865]],
[[167,-41,-73],[175,-41,-82],[165,-85,-70,],0x000000,[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881]],
[[175,-41,-82],[172,-85,-79],[165,-85,-70,],0x000000,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881]],
[[168,1,-74],[168,-1,-74],[165,-2,-73,],0xFFFFFF,[2555,2556,2563,2848,2849,2856],[2555,2557,2563,2575,2848,2850,2856,2868],[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883]],
[[172,-85,-79],[179,-81,-84],[177,-91,-82,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[172,-85,-79],[181,-71,-86],[179,-81,-84,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858]],
[[172,-85,-79],[182,-61,-88],[181,-71,-86,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859]],
[[172,-85,-79],[175,-41,-82],[182,-61,-88,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[175,-41,-82],[183,-51,-88],[182,-61,-88,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[175,-41,-82],[183,-41,-89],[183,-51,-88,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862]],
[[175,-41,-82],[183,-31,-89],[183,-41,-89,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863]],
[[175,-41,-82],[183,-21,-89],[183,-31,-89,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864]],
[[183,-21,-89],[175,-41,-82],[176,-6,-84,],0xFFFFFF,[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882]],
[[183,-21,-89],[176,-6,-84],[183,-11,-88,],0xFFFFFF,[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[176,-6,-84],[182,-1,-87],[183,-11,-88,],0xFFFFFF,[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[165,-2,-73],[168,-1,-74],[169,-6,-75,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[2555,2557,2563,2575,2848,2850,2856,2868],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871]],
[[165,-2,-73],[169,-6,-75],[165,-12,-73,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[901,902,2576,2577,2869,2870]],
[[165,-12,-73],[169,-6,-75],[165,-22,-73,],0xFFFFFF,[901,902,2576,2577,2869,2870],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[2577,2578,2579,2870,2871,2872]],
[[169,-6,-75],[167,-41,-73],[165,-22,-73,],0xFFFFFF,[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2577,2578,2579,2870,2871,2872]],
[[165,-22,-73],[167,-41,-73],[165,-32,-72,],0xFFFFFF,[2577,2578,2579,2870,2871,2872],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2579,2580,2872,2873]],
[[165,-32,-72],[167,-41,-73],[164,-42,-71,],0xFFFFFF,[2579,2580,2872,2873],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[905,906,2580,2581,2873,2874]],
[[164,-42,-71],[167,-41,-73],[163,-52,-70,],0xFFFFFF,[905,906,2580,2581,2873,2874],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2581,2582,2874,2875]],
[[163,-52,-70],[167,-41,-73],[161,-62,-68,],0xFFFFFF,[2581,2582,2874,2875],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2582,2583,2584,2875,2876,2877,4539,4540,4541]],
[[167,-41,-73],[165,-85,-70],[161,-62,-68,],0xFFFFFF,[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2582,2583,2584,2875,2876,2877,4539,4540,4541]],
[[161,-62,-68],[165,-85,-70],[159,-72,-66,],0xFFFFFF,[2582,2583,2584,2875,2876,2877,4539,4540,4541],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2584,2585,2877,2878,4541,4542,4543,4589,4595]],
[[159,-72,-66],[165,-85,-70],[157,-82,-63,],0xFFFFFF,[2584,2585,2877,2878,4541,4542,4543,4589,4595],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2585,2586,2878,2879]],
[[157,-82,-63],[165,-85,-70],[155,-92,-60,],0xFFFFFF,[2585,2586,2878,2879],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2586,2587,2879,2880]],
[[165,-85,-70],[177,-91,-82],[155,-92,-60,],0xFFFFFF,[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881],[2586,2587,2879,2880]],
[[165,-85,-70],[172,-85,-79],[177,-91,-82,],0xFFFFFF,[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[182,-1,-87],[176,-6,-84],[174,-1,-81,],0xFFFFFF,[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884]],
[[165,-2,-73],[180,5,-62],[191,6,-49,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[2552,2553,2590,2845,2846,2883],[2539,2540,2590,2598,2832,2833,2883,2891]],
[[206,9,-55],[182,-1,-87],[174,-1,-81,],0xFFFFFF,[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884]],
[[202,29,-53],[207,-1,-56],[182,-1,-87,],0xFFFFFF,[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885]],
[[180,48,-44],[185,43,-45],[182,38,-46,],0xFFFFFF,[2593,2886],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2593,2594,2886,2887,4474,4475,4476]],
[[182,38,-46],[185,43,-45],[184,28,-47,],0xFFFFFF,[2593,2594,2886,2887,4474,4475,4476],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2594,2595,2596,2887,2888,2889]],
[[184,28,-47],[185,43,-45],[190,11,-48,],0xFFFFFF,[2594,2595,2596,2887,2888,2889],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891]],
[[184,28,-47],[190,11,-48],[185,18,-47,],0xFFFFFF,[2594,2595,2596,2887,2888,2889],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[888,893,938,940,2596,2597,2889,2890]],
[[185,18,-47],[190,11,-48],[186,8,-48,],0xFFFFFF,[888,893,938,940,2596,2597,2889,2890],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2597,2598,2890,2891]],
[[190,11,-48],[191,6,-49],[186,8,-48,],0xFFFFFF,[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2539,2540,2590,2598,2832,2833,2883,2891],[2597,2598,2890,2891]],
[[35,60,-24],[41,60,-37],[18,55,-31,],0xFFFFFF,[2306,2599],[2306,2307,2477,2599,2600,2770],[2306,2307,2308,2599,2600,2601]],
[[41,60,-37],[25,55,-46],[18,55,-31,],0xFFFFFF,[2306,2307,2477,2599,2600,2770],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2306,2307,2308,2599,2600,2601]],
[[18,55,-31],[25,55,-46],[10,49,-34,],0xFFFFFF,[2306,2307,2308,2599,2600,2601],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2308,2309,2310,2601,2602,2603]],
[[25,55,-46],[18,49,-50],[10,49,-34,],0xFFFFFF,[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2308,2309,2310,2601,2602,2603]],
[[10,49,-34],[18,49,-50],[4,39,-36,],0xFFFFFF,[2308,2309,2310,2601,2602,2603],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2310,2311,2312,2603,2604,2605]],
[[18,49,-50],[12,39,-53],[4,39,-36,],0xFFFFFF,[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2310,2311,2312,2603,2604,2605]],
[[4,39,-36],[12,39,-53],[1,29,-37,],0xFFFFFF,[2310,2311,2312,2603,2604,2605],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2312,2313,2314,2605,2606,2607]],
[[12,39,-53],[10,29,-55],[1,29,-37,],0xFFFFFF,[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[2312,2313,2314,2605,2606,2607]],
[[1,29,-37],[10,29,-55],[0,19,-38,],0xFFFFFF,[2312,2313,2314,2605,2606,2607],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609]],
[[10,29,-55],[8,19,-56],[0,19,-38,],0xFFFFFF,[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609]],
[[0,19,-38],[8,19,-56],[-1,9,-39,],0xFFFFFF,[964,965,966,967,986,987,2314,2315,2316,2607,2608,2609],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[8,19,-56],[6,9,-57],[-1,9,-39,],0xFFFFFF,[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611]],
[[-1,9,-39],[6,9,-57],[-3,-1,-39,],0xFFFFFF,[504,505,506,674,675,676,2316,2317,2318,2609,2610,2611],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[2318,2319,2320,2611,2612,2613]],
[[6,9,-57],[5,-1,-58],[-3,-1,-39,],0xFFFFFF,[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[2319,2320,2321,2402,2612,2613,2614,2695],[2318,2319,2320,2611,2612,2613]],
[[-3,-1,-39],[5,-1,-58],[-4,-11,-40,],0xFFFFFF,[2318,2319,2320,2611,2612,2613],[2319,2320,2321,2402,2612,2613,2614,2695],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[5,-1,-58],[4,-11,-58],[-4,-11,-40,],0xFFFFFF,[2319,2320,2321,2402,2612,2613,2614,2695],[2321,2322,2323,2614,2615,2616],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941]],
[[-4,-11,-40],[4,-11,-58],[-5,-21,-40,],0xFFFFFF,[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[2321,2322,2323,2614,2615,2616],[2322,2323,2324,2615,2616,2617]],
[[4,-11,-58],[3,-21,-59],[-5,-21,-40,],0xFFFFFF,[2321,2322,2323,2614,2615,2616],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[2322,2323,2324,2615,2616,2617]],
[[-5,-21,-40],[3,-21,-59],[-5,-31,-40,],0xFFFFFF,[2322,2323,2324,2615,2616,2617],[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945]],
[[3,-21,-59],[3,-31,-59],[-5,-31,-40,],0xFFFFFF,[592,593,594,762,763,764,2323,2324,2325,2616,2617,2618],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945]],
[[-5,-31,-40],[3,-31,-59],[-5,-41,-40,],0xFFFFFF,[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2326,2327,2328,2619,2620,2621]],
[[3,-31,-59],[3,-41,-59],[-5,-41,-40,],0xFFFFFF,[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2327,2328,2329,2620,2621,2622],[2326,2327,2328,2619,2620,2621]],
[[-5,-41,-40],[3,-41,-59],[-4,-51,-40,],0xFFFFFF,[2326,2327,2328,2619,2620,2621],[2327,2328,2329,2620,2621,2622],[2328,2329,2330,2621,2622,2623]],
[[3,-41,-59],[3,-51,-58],[-4,-51,-40,],0xFFFFFF,[2327,2328,2329,2620,2621,2622],[2329,2330,2331,2622,2623,2624],[2328,2329,2330,2621,2622,2623]],
[[-4,-51,-40],[3,-51,-58],[-3,-61,-39,],0xFFFFFF,[2328,2329,2330,2621,2622,2623],[2329,2330,2331,2622,2623,2624],[2330,2331,2332,2623,2624,2625]],
[[3,-51,-58],[4,-61,-58],[-3,-61,-39,],0xFFFFFF,[2329,2330,2331,2622,2623,2624],[2331,2332,2333,2624,2625,2626],[2330,2331,2332,2623,2624,2625]],
[[-3,-61,-39],[4,-61,-58],[-2,-71,-39,],0xFFFFFF,[2330,2331,2332,2623,2624,2625],[2331,2332,2333,2624,2625,2626],[2332,2333,2334,2625,2626,2627]],
[[4,-61,-58],[6,-71,-57],[-2,-71,-39,],0xFFFFFF,[2331,2332,2333,2624,2625,2626],[2333,2334,2335,2626,2627,2628],[2332,2333,2334,2625,2626,2627]],
[[-2,-71,-39],[6,-71,-57],[0,-81,-38,],0xFFFFFF,[2332,2333,2334,2625,2626,2627],[2333,2334,2335,2626,2627,2628],[2334,2335,2336,2627,2628,2629]],
[[6,-71,-57],[8,-81,-56],[0,-81,-38,],0xFFFFFF,[2333,2334,2335,2626,2627,2628],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2334,2335,2336,2627,2628,2629]],
[[0,-81,-38],[8,-81,-56],[3,-91,-37,],0xFFFFFF,[2334,2335,2336,2627,2628,2629],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2336,2337,2629,2630]],
[[8,-81,-56],[11,-91,-54],[3,-91,-37,],0xFFFFFF,[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2337,2418,2419,2630,2711,2712],[2336,2337,2629,2630]],
[[171,60,-35],[177,60,-22],[187,55,-44,],0xFFFFFF,[2338,2541,2631,2834],[2338,2339,2631,2632],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[177,60,-22],[193,55,-30],[187,55,-44,],0xFFFFFF,[2338,2339,2631,2632],[2339,2340,2341,2632,2633,2634],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844]],
[[187,55,-44],[193,55,-30],[194,49,-49,],0xFFFFFF,[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2339,2340,2341,2632,2633,2634],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[193,55,-30],[201,49,-33],[194,49,-49,],0xFFFFFF,[2339,2340,2341,2632,2633,2634],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[194,49,-49],[201,49,-33],[200,39,-52,],0xFFFFFF,[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844],[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843]],
[[201,49,-33],[207,39,-35],[200,39,-52,],0xFFFFFF,[529,530,531,699,700,701,2341,2342,2343,2634,2635,2636],[2343,2344,2345,2636,2637,2638],[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843]],
[[200,39,-52],[207,39,-35],[202,29,-53,],0xFFFFFF,[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843],[2343,2344,2345,2636,2637,2638],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885]],
[[207,39,-35],[210,29,-36],[202,29,-53,],0xFFFFFF,[2343,2344,2345,2636,2637,2638],[2345,2346,2347,2638,2639,2640],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885]],
[[202,29,-53],[210,29,-36],[204,19,-54,],0xFFFFFF,[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2345,2346,2347,2638,2639,2640],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840]],
[[210,29,-36],[212,19,-36],[204,19,-54,],0xFFFFFF,[2345,2346,2347,2638,2639,2640],[2347,2348,2349,2640,2641,2642],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840]],
[[204,19,-54],[212,19,-36],[206,9,-55,],0xFFFFFF,[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840],[2347,2348,2349,2640,2641,2642],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884]],
[[212,19,-36],[214,9,-37],[206,9,-55,],0xFFFFFF,[2347,2348,2349,2640,2641,2642],[2349,2350,2351,2642,2643,2644],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884]],
[[206,9,-55],[214,9,-37],[207,-1,-56,],0xFFFFFF,[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2349,2350,2351,2642,2643,2644],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[214,9,-37],[216,-1,-37],[207,-1,-56,],0xFFFFFF,[2349,2350,2351,2642,2643,2644],[2351,2352,2353,2644,2645,2646],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[207,-1,-56],[216,-1,-37],[208,-11,-56,],0xFFFFFF,[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2351,2352,2353,2644,2645,2646],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733]],
[[216,-1,-37],[217,-11,-38],[208,-11,-56,],0xFFFFFF,[2351,2352,2353,2644,2645,2646],[2353,2354,2355,2646,2647,2648],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733]],
[[208,-11,-56],[217,-11,-38],[209,-21,-57,],0xFFFFFF,[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2353,2354,2355,2646,2647,2648],[2354,2355,2356,2647,2648,2649]],
[[217,-11,-38],[217,-21,-38],[209,-21,-57,],0xFFFFFF,[2353,2354,2355,2646,2647,2648],[2355,2356,2357,2648,2649,2650],[2354,2355,2356,2647,2648,2649]],
[[209,-21,-57],[217,-21,-38],[209,-31,-57,],0xFFFFFF,[2354,2355,2356,2647,2648,2649],[2355,2356,2357,2648,2649,2650],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737]],
[[217,-21,-38],[218,-31,-38],[209,-31,-57,],0xFFFFFF,[2355,2356,2357,2648,2649,2650],[2357,2358,2359,2650,2651,2652],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737]],
[[209,-31,-57],[218,-31,-38],[209,-41,-57,],0xFFFFFF,[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[2357,2358,2359,2650,2651,2652],[2358,2359,2360,2651,2652,2653]],
[[218,-31,-38],[217,-41,-38],[209,-41,-57,],0xFFFFFF,[2357,2358,2359,2650,2651,2652],[2359,2360,2361,2652,2653,2654],[2358,2359,2360,2651,2652,2653]],
[[209,-41,-57],[217,-41,-38],[209,-51,-57,],0xFFFFFF,[2358,2359,2360,2651,2652,2653],[2359,2360,2361,2652,2653,2654],[2360,2361,2362,2653,2654,2655]],
[[217,-41,-38],[217,-51,-38],[209,-51,-57,],0xFFFFFF,[2359,2360,2361,2652,2653,2654],[2361,2362,2363,2654,2655,2656],[2360,2361,2362,2653,2654,2655]],
[[209,-51,-57],[217,-51,-38],[208,-61,-56,],0xFFFFFF,[2360,2361,2362,2653,2654,2655],[2361,2362,2363,2654,2655,2656],[2362,2363,2364,2655,2656,2657]],
[[217,-51,-38],[216,-61,-38],[208,-61,-56,],0xFFFFFF,[2361,2362,2363,2654,2655,2656],[2363,2364,2365,2656,2657,2658],[2362,2363,2364,2655,2656,2657]],
[[208,-61,-56],[216,-61,-38],[206,-71,-55,],0xFFFFFF,[2362,2363,2364,2655,2656,2657],[2363,2364,2365,2656,2657,2658],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[216,-61,-38],[214,-71,-37],[206,-71,-55,],0xFFFFFF,[2363,2364,2365,2656,2657,2658],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659]],
[[206,-71,-55],[214,-71,-37],[204,-81,-54,],0xFFFFFF,[552,553,554,722,723,724,2364,2365,2366,2657,2658,2659],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747]],
[[214,-71,-37],[212,-81,-36],[204,-81,-54,],0xFFFFFF,[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747]],
[[204,-81,-54],[212,-81,-36],[201,-91,-52,],0xFFFFFF,[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[2368,2369,2454,2661,2662,2747]],
[[212,-81,-36],[209,-91,-35],[201,-91,-52,],0xFFFFFF,[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[2369,2662],[2368,2369,2454,2661,2662,2747]],
[[116,60,73],[105,55,92],[120,55,91,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[116,60,73],[107,60,74],[105,55,92,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[559,729,1586,1589,2371,2664],[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666]],
[[120,55,91],[106,49,101],[121,49,100,],0xFFFFFF,[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[560,562,730,732,2372,2374,2665,2667]],
[[105,55,92],[106,49,101],[120,55,91,],0xFFFFFF,[558,559,561,728,729,731,1586,1587,1588,1589,1590,1591,2370,2371,2373,2663,2664,2666],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[558,560,561,728,730,731,2370,2372,2373,2663,2665,2666]],
[[121,49,100],[106,49,101],[122,39,106,],0xFFFFFF,[560,562,730,732,2372,2374,2665,2667],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[106,49,101],[105,39,107],[122,39,106,],0xFFFFFF,[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669]],
[[122,39,106],[105,39,107],[123,29,109,],0xFFFFFF,[562,563,564,732,733,734,2374,2375,2376,2667,2668,2669],[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[105,39,107],[106,29,110],[123,29,109,],0xFFFFFF,[563,564,565,733,734,735,2375,2376,2377,2668,2669,2670],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671]],
[[123,29,109],[106,29,110],[123,19,111,],0xFFFFFF,[564,565,566,734,735,736,2376,2377,2378,2669,2670,2671],[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[106,29,110],[106,19,113],[123,19,111,],0xFFFFFF,[565,566,567,735,736,737,2377,2378,2379,2670,2671,2672],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673]],
[[123,19,111],[106,19,113],[123,9,113,],0xFFFFFF,[566,567,568,736,737,738,2378,2379,2380,2671,2672,2673],[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[106,19,113],[106,9,114],[123,9,113,],0xFFFFFF,[567,568,569,737,738,739,2379,2380,2381,2672,2673,2674],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675]],
[[123,9,113],[106,9,114],[124,-1,114,],0xFFFFFF,[568,569,570,738,739,740,2380,2381,2382,2673,2674,2675],[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[106,9,114],[105,-1,116],[124,-1,114,],0xFFFFFF,[569,570,571,739,740,741,2381,2382,2383,2674,2675,2676],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677]],
[[124,-1,114],[105,-1,116],[124,-11,116,],0xFFFFFF,[570,571,572,740,741,742,2382,2383,2384,2675,2676,2677],[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[105,-1,116],[105,-11,117],[124,-11,116,],0xFFFFFF,[571,572,573,741,742,743,2383,2384,2385,2676,2677,2678],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221]],
[[124,-11,116],[105,-11,117],[124,-21,116,],0xFFFFFF,[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[105,-11,117],[106,-21,118],[124,-21,116,],0xFFFFFF,[573,574,575,743,744,745,2385,2386,2387,2678,2679,2680],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681]],
[[124,-21,116],[106,-21,118],[124,-31,117,],0xFFFFFF,[574,575,576,744,745,746,2386,2387,2388,2679,2680,2681],[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[106,-21,118],[106,-31,118],[124,-31,117,],0xFFFFFF,[575,576,577,745,746,747,2387,2388,2389,2680,2681,2682],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683]],
[[124,-31,117],[106,-31,118],[124,-41,116,],0xFFFFFF,[576,577,578,746,747,748,2388,2389,2390,2681,2682,2683],[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[106,-31,118],[104,-41,118],[124,-41,116,],0xFFFFFF,[577,578,579,747,748,749,1614,1615,1616,1623,1624,1625,2389,2390,2391,2682,2683,2684],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227]],
[[124,-41,116],[104,-41,118],[124,-51,116,],0xFFFFFF,[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[104,-41,118],[104,-51,117],[124,-51,116,],0xFFFFFF,[579,580,581,749,750,751,2391,2392,2393,2684,2685,2686],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687]],
[[124,-51,116],[104,-51,117],[124,-61,115,],0xFFFFFF,[580,581,582,750,751,752,2392,2393,2394,2685,2686,2687],[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[104,-51,117],[105,-61,116],[124,-61,115,],0xFFFFFF,[581,582,583,751,752,753,2393,2394,2395,2686,2687,2688],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689]],
[[124,-61,115],[105,-61,116],[123,-71,113,],0xFFFFFF,[582,583,584,752,753,754,2394,2395,2396,2687,2688,2689],[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[105,-61,116],[105,-71,114],[123,-71,113,],0xFFFFFF,[583,584,585,753,754,755,2395,2396,2397,2688,2689,2690],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691]],
[[123,-71,113],[105,-71,114],[123,-81,111,],0xFFFFFF,[584,585,586,754,755,756,2396,2397,2398,2689,2690,2691],[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[105,-71,114],[105,-81,112],[123,-81,111,],0xFFFFFF,[585,586,587,755,756,757,2397,2398,2399,2690,2691,2692],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693]],
[[123,-81,111],[105,-81,112],[123,-91,107,],0xFFFFFF,[586,587,588,756,757,758,2398,2399,2400,2691,2692,2693],[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[588,589,758,759,2400,2401,2693,2694]],
[[105,-81,112],[106,-91,109],[123,-91,107,],0xFFFFFF,[587,588,589,757,758,759,1635,1636,1637,1646,1647,1648,2399,2400,2401,2692,2693,2694],[589,759,2401,2694],[588,589,758,759,2400,2401,2693,2694]],
[[5,-1,-58],[19,-1,-74],[4,-11,-58,],0xFFFFFF,[2319,2320,2321,2402,2612,2613,2614,2695],[2402,2403,2695,2696],[2402,2403,2404,2695,2696,2697]],
[[19,-1,-74],[16,-11,-75],[4,-11,-58,],0xFFFFFF,[2402,2403,2695,2696],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2402,2403,2404,2695,2696,2697]],
[[4,-11,-58],[16,-11,-75],[3,-21,-59,],0xFFFFFF,[2402,2403,2404,2695,2696,2697],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2404,2405,2406,2697,2698,2699]],
[[16,-11,-75],[15,-21,-75],[3,-21,-59,],0xFFFFFF,[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2405,2406,2407,2698,2699,2700],[2404,2405,2406,2697,2698,2699]],
[[3,-21,-59],[15,-21,-75],[3,-31,-59,],0xFFFFFF,[2404,2405,2406,2697,2698,2699],[2405,2406,2407,2698,2699,2700],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701]],
[[15,-21,-75],[15,-31,-76],[3,-31,-59,],0xFFFFFF,[2405,2406,2407,2698,2699,2700],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701]],
[[3,-31,-59],[15,-31,-76],[3,-41,-59,],0xFFFFFF,[2325,2326,2327,2406,2407,2408,2618,2619,2620,2699,2700,2701],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2408,2409,2410,2701,2702,2703]],
[[15,-31,-76],[15,-41,-76],[3,-41,-59,],0xFFFFFF,[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[2408,2409,2410,2701,2702,2703]],
[[3,-41,-59],[15,-41,-76],[3,-51,-58,],0xFFFFFF,[2408,2409,2410,2701,2702,2703],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[15,-41,-76],[15,-51,-75],[3,-51,-58,],0xFFFFFF,[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705]],
[[3,-51,-58],[15,-51,-75],[4,-61,-58,],0xFFFFFF,[598,599,600,768,769,770,2410,2411,2412,2703,2704,2705],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[2412,2413,2414,2705,2706,2707]],
[[15,-51,-75],[16,-61,-75],[4,-61,-58,],0xFFFFFF,[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2412,2413,2414,2705,2706,2707]],
[[4,-61,-58],[16,-61,-75],[6,-71,-57,],0xFFFFFF,[2412,2413,2414,2705,2706,2707],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2414,2415,2416,2707,2708,2709]],
[[16,-61,-75],[17,-71,-73],[6,-71,-57,],0xFFFFFF,[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2415,2416,2417,2708,2709,2710],[2414,2415,2416,2707,2708,2709]],
[[6,-71,-57],[17,-71,-73],[8,-81,-56,],0xFFFFFF,[2414,2415,2416,2707,2708,2709],[2415,2416,2417,2708,2709,2710],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711]],
[[17,-71,-73],[19,-81,-72],[8,-81,-56,],0xFFFFFF,[2415,2416,2417,2708,2709,2710],[2417,2418,2419,2710,2711,2712],[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711]],
[[8,-81,-56],[19,-81,-72],[11,-91,-54,],0xFFFFFF,[2335,2336,2337,2416,2417,2418,2628,2629,2630,2709,2710,2711],[2417,2418,2419,2710,2711,2712],[2337,2418,2419,2630,2711,2712]],
[[19,-81,-72],[22,-91,-70],[11,-91,-54,],0xFFFFFF,[2417,2418,2419,2710,2711,2712],[2419,2712],[2337,2418,2419,2630,2711,2712]],
[[19,-1,-74],[31,-1,-89],[16,-11,-75,],0xFFFFFF,[2420,2713],[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715]],
[[31,-1,-89],[30,-11,-89],[16,-11,-75,],0xFFFFFF,[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715]],
[[16,-11,-75],[30,-11,-89],[15,-21,-75,],0xFFFFFF,[2403,2404,2405,2420,2421,2422,2696,2697,2698,2713,2714,2715],[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2422,2423,2424,2715,2716,2717]],
[[30,-11,-89],[30,-21,-90],[15,-21,-75,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2422,2423,2424,2715,2716,2717]],
[[15,-21,-75],[30,-21,-90],[15,-31,-76,],0xFFFFFF,[2422,2423,2424,2715,2716,2717],[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719]],
[[30,-21,-90],[29,-31,-90],[15,-31,-76,],0xFFFFFF,[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827],[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719]],
[[15,-31,-76],[29,-31,-90],[15,-41,-76,],0xFFFFFF,[2407,2408,2409,2424,2425,2426,2700,2701,2702,2717,2718,2719],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721]],
[[29,-31,-90],[29,-41,-90],[15,-41,-76,],0xFFFFFF,[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721]],
[[15,-41,-76],[29,-41,-90],[15,-51,-75,],0xFFFFFF,[2409,2410,2411,2426,2427,2428,2702,2703,2704,2719,2720,2721],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723]],
[[29,-41,-90],[30,-51,-90],[15,-51,-75,],0xFFFFFF,[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723]],
[[15,-51,-75],[30,-51,-90],[16,-61,-75,],0xFFFFFF,[2411,2412,2413,2428,2429,2430,2704,2705,2706,2721,2722,2723],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725]],
[[30,-51,-90],[30,-61,-89],[16,-61,-75,],0xFFFFFF,[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725]],
[[16,-61,-75],[30,-61,-89],[17,-71,-73,],0xFFFFFF,[2413,2414,2415,2430,2431,2432,2706,2707,2708,2723,2724,2725],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2432,2433,2434,2725,2726,2727]],
[[30,-61,-89],[32,-71,-88],[17,-71,-73,],0xFFFFFF,[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2432,2433,2434,2725,2726,2727]],
[[17,-71,-73],[32,-71,-88],[19,-81,-72,],0xFFFFFF,[2432,2433,2434,2725,2726,2727],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2434,2435,2436,2727,2728,2729]],
[[32,-71,-88],[33,-81,-86],[19,-81,-72,],0xFFFFFF,[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2434,2435,2436,2727,2728,2729]],
[[19,-81,-72],[33,-81,-86],[22,-91,-70,],0xFFFFFF,[2434,2435,2436,2727,2728,2729],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2436,2437,2729,2730]],
[[33,-81,-86],[35,-91,-83],[22,-91,-70,],0xFFFFFF,[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2437,2516,2527,2730,2809,2820],[2436,2437,2729,2730]],
[[207,-1,-56],[208,-11,-56],[197,-11,-73,],0xFFFFFF,[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829]],
[[197,-11,-73],[208,-11,-56],[197,-21,-74,],0xFFFFFF,[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2439,2440,2441,2732,2733,2734]],
[[208,-11,-56],[209,-21,-57],[197,-21,-74,],0xFFFFFF,[2352,2353,2354,2438,2439,2440,2645,2646,2647,2731,2732,2733],[2440,2441,2442,2733,2734,2735],[2439,2440,2441,2732,2733,2734]],
[[197,-21,-74],[209,-21,-57],[198,-31,-74,],0xFFFFFF,[2439,2440,2441,2732,2733,2734],[2440,2441,2442,2733,2734,2735],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755]],
[[209,-21,-57],[209,-31,-57],[198,-31,-74,],0xFFFFFF,[2440,2441,2442,2733,2734,2735],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755]],
[[198,-31,-74],[209,-31,-57],[198,-41,-74,],0xFFFFFF,[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757]],
[[209,-31,-57],[209,-41,-57],[198,-41,-74,],0xFFFFFF,[2356,2357,2358,2442,2443,2444,2649,2650,2651,2735,2736,2737],[2444,2445,2446,2737,2738,2739],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757]],
[[198,-41,-74],[209,-41,-57],[197,-51,-74,],0xFFFFFF,[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2444,2445,2446,2737,2738,2739],[2445,2446,2447,2738,2739,2740]],
[[209,-41,-57],[209,-51,-57],[197,-51,-74,],0xFFFFFF,[2444,2445,2446,2737,2738,2739],[2446,2447,2448,2739,2740,2741],[2445,2446,2447,2738,2739,2740]],
[[197,-51,-74],[209,-51,-57],[196,-61,-73,],0xFFFFFF,[2445,2446,2447,2738,2739,2740],[2446,2447,2448,2739,2740,2741],[2447,2448,2449,2740,2741,2742]],
[[209,-51,-57],[208,-61,-56],[196,-61,-73,],0xFFFFFF,[2446,2447,2448,2739,2740,2741],[2448,2449,2450,2741,2742,2743],[2447,2448,2449,2740,2741,2742]],
[[196,-61,-73],[208,-61,-56],[195,-71,-72,],0xFFFFFF,[2447,2448,2449,2740,2741,2742],[2448,2449,2450,2741,2742,2743],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[208,-61,-56],[206,-71,-55],[195,-71,-72,],0xFFFFFF,[2448,2449,2450,2741,2742,2743],[2450,2451,2452,2743,2744,2745],[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744]],
[[195,-71,-72],[206,-71,-55],[193,-81,-70,],0xFFFFFF,[637,638,639,807,808,809,2449,2450,2451,2742,2743,2744],[2450,2451,2452,2743,2744,2745],[2451,2452,2453,2744,2745,2746]],
[[206,-71,-55],[204,-81,-54],[193,-81,-70,],0xFFFFFF,[2450,2451,2452,2743,2744,2745],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2451,2452,2453,2744,2745,2746]],
[[193,-81,-70],[204,-81,-54],[190,-91,-68,],0xFFFFFF,[2451,2452,2453,2744,2745,2746],[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2453,2454,2746,2747]],
[[204,-81,-54],[201,-91,-52],[190,-91,-68,],0xFFFFFF,[2366,2367,2368,2452,2453,2454,2659,2660,2661,2745,2746,2747],[2368,2369,2454,2661,2662,2747],[2453,2454,2746,2747]],
[[182,-1,-87],[194,-1,-73],[183,-11,-88,],0xFFFFFF,[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2455,2456,2536,2748,2749,2829],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[194,-1,-73],[197,-11,-73],[183,-11,-88,],0xFFFFFF,[2455,2456,2536,2748,2749,2829],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[183,-11,-88],[197,-11,-73],[183,-21,-89,],0xFFFFFF,[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866]],
[[197,-11,-73],[197,-21,-74],[183,-21,-89,],0xFFFFFF,[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2458,2459,2460,2751,2752,2753],[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866]],
[[183,-21,-89],[197,-21,-74],[183,-31,-89,],0xFFFFFF,[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2458,2459,2460,2751,2752,2753],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864]],
[[197,-21,-74],[198,-31,-74],[183,-31,-89,],0xFFFFFF,[2458,2459,2460,2751,2752,2753],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864]],
[[183,-31,-89],[198,-31,-74],[183,-41,-89,],0xFFFFFF,[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864],[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863]],
[[198,-31,-74],[198,-41,-74],[183,-41,-89,],0xFFFFFF,[2441,2442,2443,2460,2461,2462,2734,2735,2736,2753,2754,2755],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863]],
[[183,-41,-89],[198,-41,-74],[183,-51,-88,],0xFFFFFF,[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863],[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862]],
[[198,-41,-74],[197,-51,-74],[183,-51,-88,],0xFFFFFF,[650,651,652,820,821,822,2443,2444,2445,2462,2463,2464,2736,2737,2738,2755,2756,2757],[2464,2465,2466,2757,2758,2759],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862]],
[[183,-51,-88],[197,-51,-74],[182,-61,-88,],0xFFFFFF,[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862],[2464,2465,2466,2757,2758,2759],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[197,-51,-74],[196,-61,-73],[182,-61,-88,],0xFFFFFF,[2464,2465,2466,2757,2758,2759],[2466,2467,2468,2759,2760,2761],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[182,-61,-88],[196,-61,-73],[181,-71,-86,],0xFFFFFF,[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861],[2466,2467,2468,2759,2760,2761],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859]],
[[196,-61,-73],[195,-71,-72],[181,-71,-86,],0xFFFFFF,[2466,2467,2468,2759,2760,2761],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859]],
[[181,-71,-86],[195,-71,-72],[179,-81,-84,],0xFFFFFF,[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859],[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858]],
[[195,-71,-72],[193,-81,-70],[179,-81,-84,],0xFFFFFF,[656,657,658,826,827,828,2468,2469,2470,2761,2762,2763],[2470,2471,2472,2763,2764,2765],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858]],
[[179,-81,-84],[193,-81,-70],[177,-91,-82,],0xFFFFFF,[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858],[2470,2471,2472,2763,2764,2765],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[193,-81,-70],[190,-91,-68],[177,-91,-82,],0xFFFFFF,[2470,2471,2472,2763,2764,2765],[2472,2765],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[19,43,-49],[25,43,-46],[14,14,-53,],0x000000,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779]],
[[25,43,-46],[20,14,-49],[14,14,-53,],0x000000,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779]],
[[14,14,-53],[20,14,-49],[13,9,-53,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2475,2476,2486,2495,2768,2769,2779,2788]],
[[13,9,-53],[20,14,-49],[19,9,-49,],0xFFFFFF,[2475,2476,2486,2495,2768,2769,2779,2788],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790]],
[[30,48,-43],[25,55,-46],[41,60,-37,],0xFFFFFF,[2477,2478,2488,2770,2771,2781],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2306,2307,2477,2599,2600,2770]],
[[25,43,-46],[25,55,-46],[30,48,-43,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773],[2477,2478,2488,2770,2771,2781]],
[[25,43,-46],[19,43,-49],[25,55,-46,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773]],
[[19,43,-49],[18,49,-50],[25,55,-46,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774],[2307,2308,2309,2477,2478,2479,2480,2600,2601,2602,2770,2771,2772,2773]],
[[19,43,-49],[12,39,-53],[18,49,-50,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775],[2309,2310,2311,2480,2481,2602,2603,2604,2773,2774]],
[[19,43,-49],[10,29,-55],[12,39,-53,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777],[2311,2312,2313,2481,2482,2604,2605,2606,2774,2775]],
[[19,43,-49],[14,14,-53],[10,29,-55,],0xFFFFFF,[2473,2479,2480,2481,2482,2483,2766,2772,2773,2774,2775,2776],[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777]],
[[14,14,-53],[8,19,-56],[10,29,-55,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828],[2313,2314,2315,2482,2483,2484,2606,2607,2608,2775,2776,2777]],
[[14,14,-53],[6,9,-57],[8,19,-56,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828]],
[[14,14,-53],[13,9,-53],[6,9,-57,],0xFFFFFF,[2473,2474,2475,2483,2484,2485,2486,2766,2767,2768,2776,2777,2778,2779],[2475,2476,2486,2495,2768,2769,2779,2788],[2317,2318,2319,2485,2486,2610,2611,2612,2778,2779]],
[[13,9,-53],[5,-1,-57],[7,9,-57,],0xFFFFFF,[2487,2780],[2487,2535,2780,2828],[2487,2780]],
[[25,43,-46],[30,48,-43],[28,38,-44,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2477,2478,2488,2770,2771,2781],[2488,2489,2781,2782]],
[[25,43,-46],[28,38,-44],[26,28,-45,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2488,2489,2781,2782],[2489,2490,2491,2782,2783,2784]],
[[25,43,-46],[26,28,-45],[20,14,-49,],0xFFFFFF,[2473,2474,2478,2479,2488,2489,2490,2766,2767,2771,2772,2781,2782,2783],[2489,2490,2491,2782,2783,2784],[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785]],
[[20,14,-49],[26,28,-45],[25,18,-46,],0xFFFFFF,[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2489,2490,2491,2782,2783,2784],[2491,2492,2493,2784,2785,2786]],
[[20,14,-49],[25,18,-46],[19,9,-49,],0xFFFFFF,[2474,2475,2476,2490,2491,2492,2767,2768,2769,2783,2784,2785],[2491,2492,2493,2784,2785,2786],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790]],
[[25,18,-46],[24,8,-47],[19,9,-49,],0xFFFFFF,[2491,2492,2493,2784,2785,2786],[2493,2494,2786,2787],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790]],
[[19,9,-49],[24,8,-47],[23,-2,-47,],0xFFFFFF,[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2493,2494,2786,2787],[2494,2497,2787,2790]],
[[13,9,-53],[19,9,-49],[21,-1,-70,],0xFFFFFF,[2475,2476,2486,2495,2768,2769,2779,2788],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2495,2496,2498,2501,2788,2789,2791,2794]],
[[19,9,-49],[30,-1,-63],[21,-1,-70,],0xFFFFFF,[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2495,2496,2498,2501,2788,2789,2791,2794]],
[[23,-2,-47],[19,9,-49],[30,-1,-63,],0xFFFFFF,[2494,2497,2787,2790],[2476,2492,2493,2494,2495,2496,2497,2769,2785,2786,2787,2788,2789,2790],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797]],
[[21,-1,-70],[30,-1,-63],[33,-5,-86,],0xFFFFFF,[2495,2496,2498,2501,2788,2789,2791,2794],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796]],
[[30,-1,-63],[41,-5,-76],[33,-5,-86,],0xFFFFFF,[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796]],
[[33,-5,-86],[41,-5,-76],[33,-10,-86,],0xFFFFFF,[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796],[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825]],
[[21,-1,-70],[31,-1,-89],[33,-5,-86,],0xFFFFFF,[2495,2496,2498,2501,2788,2789,2791,2794],[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796]],
[[31,-1,-89],[33,-5,-86],[30,-11,-89,],0xFFFFFF,[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796],[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826]],
[[30,-11,-89],[33,-5,-86],[33,-10,-86,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2498,2499,2500,2501,2502,2503,2791,2792,2793,2794,2795,2796],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825]],
[[41,-5,-76],[30,-1,-63],[45,-2,-72,],0xFFFFFF,[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2496,2497,2498,2499,2504,2789,2790,2791,2792,2797],[2504,2505,2506,2797,2798,2799]],
[[41,-5,-76],[45,-2,-72],[41,-10,-77,],0xFFFFFF,[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2504,2505,2506,2797,2798,2799],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[41,-10,-77],[45,-2,-72],[44,-12,-72,],0xFFFFFF,[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822],[2504,2505,2506,2797,2798,2799],[2506,2517,2799,2810]],
[[41,-10,-76],[43,-46,-74],[36,-46,-82,],0x000000,[2507,2530,2800,2823],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827]],
[[36,-46,-82],[43,-46,-74],[39,-83,-78,],0x000000,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821]],
[[43,-46,-74],[47,-83,-70],[39,-83,-78,],0x000000,[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821]],
[[36,-46,-82],[29,-41,-90],[29,-31,-90,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827]],
[[36,-46,-82],[30,-51,-90],[29,-41,-90,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805],[2427,2428,2429,2510,2511,2720,2721,2722,2803,2804]],
[[36,-46,-82],[30,-61,-89],[30,-51,-90,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806],[2429,2430,2431,2511,2512,2722,2723,2724,2804,2805]],
[[36,-46,-82],[32,-71,-88],[30,-61,-89,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808],[2431,2432,2433,2512,2513,2724,2725,2726,2805,2806]],
[[36,-46,-82],[39,-83,-78],[32,-71,-88,],0xFFFFFF,[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808]],
[[39,-83,-78],[33,-81,-86],[32,-71,-88,],0xFFFFFF,[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809],[2433,2434,2435,2513,2514,2515,2726,2727,2728,2806,2807,2808]],
[[39,-83,-78],[35,-91,-83],[33,-81,-86,],0xFFFFFF,[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2437,2516,2527,2730,2809,2820],[2435,2436,2437,2515,2516,2728,2729,2730,2808,2809]],
[[44,-12,-72],[45,-22,-72],[41,-10,-77,],0xFFFFFF,[2506,2517,2799,2810],[2517,2518,2810,2811],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[45,-22,-72],[45,-32,-71],[41,-10,-77,],0xFFFFFF,[2517,2518,2810,2811],[2518,2519,2520,2811,2812,2813],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[45,-32,-71],[43,-46,-74],[41,-10,-77,],0xFFFFFF,[2518,2519,2520,2811,2812,2813],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[45,-32,-71],[46,-42,-70],[43,-46,-74,],0xFFFFFF,[2518,2519,2520,2811,2812,2813],[2520,2521,2813,2814],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816]],
[[43,-46,-74],[46,-42,-70],[47,-52,-69,],0xFFFFFF,[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2520,2521,2813,2814],[2521,2522,2814,2815]],
[[43,-46,-74],[47,-52,-69],[49,-62,-67,],0xFFFFFF,[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816],[2521,2522,2814,2815],[2522,2523,2524,2815,2816,2817]],
[[49,-62,-67],[47,-83,-70],[43,-46,-74,],0xFFFFFF,[2522,2523,2524,2815,2816,2817],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821],[2507,2508,2509,2519,2520,2521,2522,2523,2800,2801,2802,2812,2813,2814,2815,2816]],
[[49,-62,-67],[51,-72,-65],[47,-83,-70,],0xFFFFFF,[2522,2523,2524,2815,2816,2817],[2524,2525,2817,2818],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821]],
[[51,-72,-65],[53,-82,-62],[47,-83,-70,],0xFFFFFF,[2524,2525,2817,2818],[2525,2526,2818,2819],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821]],
[[47,-83,-70],[53,-82,-62],[55,-92,-59,],0xFFFFFF,[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821],[2525,2526,2818,2819],[2526,2527,2528,2819,2820,2821]],
[[39,-83,-78],[55,-92,-59],[35,-91,-83,],0xFFFFFF,[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2526,2527,2528,2819,2820,2821],[2437,2516,2527,2730,2809,2820]],
[[55,-92,-59],[39,-83,-78],[47,-83,-70,],0xFFFFFF,[2526,2527,2528,2819,2820,2821],[2508,2509,2514,2515,2516,2527,2528,2801,2802,2807,2808,2809,2820,2821],[2509,2523,2524,2525,2526,2528,2802,2816,2817,2818,2819,2821]],
[[33,-10,-86],[41,-5,-76],[41,-10,-77,],0xFFFFFF,[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825],[2499,2500,2504,2505,2529,2792,2793,2797,2798,2822],[2505,2506,2517,2518,2519,2529,2798,2799,2810,2811,2812,2822]],
[[41,-10,-76],[36,-46,-82],[33,-10,-86,],0x000000,[2507,2530,2800,2823],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825]],
[[30,-11,-89],[33,-10,-86],[36,-46,-82,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827]],
[[30,-11,-89],[33,-10,-86],[36,-46,-82,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2500,2503,2529,2530,2531,2532,2793,2796,2822,2823,2824,2825],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827]],
[[30,-11,-89],[36,-46,-82],[30,-21,-90,],0xFFFFFF,[2421,2422,2423,2502,2503,2531,2532,2533,2714,2715,2716,2795,2796,2824,2825,2826],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827]],
[[30,-21,-90],[36,-46,-82],[29,-31,-90,],0xFFFFFF,[2423,2424,2425,2533,2534,2716,2717,2718,2826,2827],[2507,2508,2510,2511,2512,2513,2514,2530,2531,2532,2533,2534,2800,2801,2803,2804,2805,2806,2807,2823,2824,2825,2826,2827],[2425,2426,2427,2510,2534,2718,2719,2720,2803,2827]],
[[31,-1,-89],[5,-1,-57],[8,19,-56,],0xFFFFFF,[2420,2421,2501,2502,2535,2713,2714,2794,2795,2828],[2487,2535,2780,2828],[2315,2316,2317,2484,2485,2535,2608,2609,2610,2777,2778,2828]],
[[207,-1,-56],[197,-11,-73],[194,-1,-73,],0xFFFFFF,[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2438,2439,2456,2457,2458,2536,2731,2732,2749,2750,2751,2829],[2455,2456,2536,2748,2749,2829]],
[[185,43,-45],[191,43,-49],[190,11,-48,],0x000000,[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891]],
[[190,11,-48],[191,43,-49],[198,11,-53,],0x000000,[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841]],
[[190,11,-48],[198,11,-53],[191,6,-49,],0xFFFFFF,[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2539,2540,2590,2598,2832,2833,2883,2891]],
[[191,6,-49],[198,11,-53],[199,6,-54,],0xFFFFFF,[2539,2540,2590,2598,2832,2833,2883,2891],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2540,2544,2545,2833,2837,2838]],
[[171,60,-35],[187,55,-44],[180,48,-44,],0xFFFFFF,[2338,2541,2631,2834],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2541,2542,2834,2835]],
[[180,48,-44],[187,55,-44],[185,43,-45,],0xFFFFFF,[2541,2542,2834,2835],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888]],
[[187,55,-44],[191,43,-49],[185,43,-45,],0xFFFFFF,[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888]],
[[199,6,-54],[206,9,-55],[207,-1,-56,],0xFFFFFF,[2540,2544,2545,2833,2837,2838],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[206,9,-55],[199,6,-54],[198,11,-53,],0xFFFFFF,[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2540,2544,2545,2833,2837,2838],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841]],
[[198,11,-53],[204,19,-54],[206,9,-55,],0xFFFFFF,[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840],[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884]],
[[198,11,-53],[202,29,-53],[204,19,-54,],0xFFFFFF,[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2346,2347,2348,2546,2547,2639,2640,2641,2839,2840]],
[[202,29,-53],[198,11,-53],[191,43,-49,],0xFFFFFF,[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2538,2539,2540,2545,2546,2547,2548,2831,2832,2833,2838,2839,2840,2841],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844]],
[[191,43,-49],[200,39,-52],[202,29,-53,],0xFFFFFF,[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843],[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885]],
[[200,39,-52],[191,43,-49],[194,49,-49,],0xFFFFFF,[2342,2343,2344,2549,2550,2635,2636,2637,2842,2843],[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[191,43,-49],[187,55,-44],[194,49,-49,],0xFFFFFF,[2537,2538,2543,2548,2549,2550,2551,2830,2831,2836,2841,2842,2843,2844],[526,527,528,696,697,698,881,883,884,885,2338,2339,2340,2541,2542,2543,2551,2631,2632,2633,2834,2835,2836,2844],[2340,2341,2342,2550,2551,2633,2634,2635,2843,2844]],
[[181,1,-63],[180,5,-62],[188,1,-69,],0xFFFFFF,[2552,2845],[2552,2553,2590,2845,2846,2883],[2552,2553,2554,2845,2846,2847]],
[[188,1,-69],[180,5,-62],[187,5,-68,],0xFFFFFF,[2552,2553,2554,2845,2846,2847],[2552,2553,2590,2845,2846,2883],[2553,2554,2846,2847]],
[[188,1,-69],[187,5,-68],[207,-1,-56,],0xFFFFFF,[2552,2553,2554,2845,2846,2847],[2553,2554,2846,2847],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885]],
[[168,-1,-74],[168,1,-74],[174,-1,-81,],0xFFFFFF,[2555,2557,2563,2575,2848,2850,2856,2868],[2555,2556,2563,2848,2849,2856],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884]],
[[174,-1,-81],[168,1,-74],[173,1,-80,],0xFFFFFF,[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884],[2555,2556,2563,2848,2849,2856],[2556,2849]],
[[168,-1,-74],[174,-1,-81],[169,-6,-75,],0xFFFFFF,[2555,2557,2563,2575,2848,2850,2856,2868],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871]],
[[174,-1,-81],[176,-6,-84],[169,-6,-75,],0xFFFFFF,[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871]],
[[169,-6,-75],[176,-6,-84],[167,-41,-73,],0x000000,[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876]],
[[167,-41,-73],[176,-6,-84],[175,-41,-82,],0x000000,[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865]],
[[167,-41,-73],[175,-41,-82],[165,-85,-70,],0x000000,[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881]],
[[175,-41,-82],[172,-85,-79],[165,-85,-70,],0x000000,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881]],
[[168,1,-74],[168,-1,-74],[165,-2,-73,],0xFFFFFF,[2555,2556,2563,2848,2849,2856],[2555,2557,2563,2575,2848,2850,2856,2868],[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883]],
[[172,-85,-79],[179,-81,-84],[177,-91,-82,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[172,-85,-79],[181,-71,-86],[179,-81,-84,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859],[2469,2470,2471,2564,2565,2762,2763,2764,2857,2858]],
[[172,-85,-79],[182,-61,-88],[181,-71,-86,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861],[2467,2468,2469,2565,2566,2760,2761,2762,2858,2859]],
[[172,-85,-79],[175,-41,-82],[182,-61,-88,],0xFFFFFF,[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[175,-41,-82],[183,-51,-88],[182,-61,-88,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862],[2465,2466,2467,2566,2567,2568,2758,2759,2760,2859,2860,2861]],
[[175,-41,-82],[183,-41,-89],[183,-51,-88,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863],[2463,2464,2465,2568,2569,2756,2757,2758,2861,2862]],
[[175,-41,-82],[183,-31,-89],[183,-41,-89,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864],[2461,2462,2463,2569,2570,2754,2755,2756,2862,2863]],
[[175,-41,-82],[183,-21,-89],[183,-31,-89,],0xFFFFFF,[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2459,2460,2461,2570,2571,2752,2753,2754,2863,2864]],
[[183,-21,-89],[175,-41,-82],[176,-6,-84,],0xFFFFFF,[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2560,2561,2562,2567,2568,2569,2570,2571,2572,2853,2854,2855,2860,2861,2862,2863,2864,2865],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882]],
[[183,-21,-89],[176,-6,-84],[183,-11,-88,],0xFFFFFF,[2457,2458,2459,2571,2572,2573,2750,2751,2752,2864,2865,2866],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[176,-6,-84],[182,-1,-87],[183,-11,-88,],0xFFFFFF,[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2455,2456,2457,2573,2574,2748,2749,2750,2866,2867]],
[[165,-2,-73],[168,-1,-74],[169,-6,-75,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[2555,2557,2563,2575,2848,2850,2856,2868],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871]],
[[165,-2,-73],[169,-6,-75],[165,-12,-73,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[901,902,2576,2577,2869,2870]],
[[165,-12,-73],[169,-6,-75],[165,-22,-73,],0xFFFFFF,[901,902,2576,2577,2869,2870],[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[2577,2578,2579,2870,2871,2872]],
[[169,-6,-75],[167,-41,-73],[165,-22,-73,],0xFFFFFF,[2557,2558,2559,2575,2576,2577,2578,2850,2851,2852,2868,2869,2870,2871],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2577,2578,2579,2870,2871,2872]],
[[165,-22,-73],[167,-41,-73],[165,-32,-72,],0xFFFFFF,[2577,2578,2579,2870,2871,2872],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2579,2580,2872,2873]],
[[165,-32,-72],[167,-41,-73],[164,-42,-71,],0xFFFFFF,[2579,2580,2872,2873],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[905,906,2580,2581,2873,2874]],
[[164,-42,-71],[167,-41,-73],[163,-52,-70,],0xFFFFFF,[905,906,2580,2581,2873,2874],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2581,2582,2874,2875]],
[[163,-52,-70],[167,-41,-73],[161,-62,-68,],0xFFFFFF,[2581,2582,2874,2875],[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2582,2583,2584,2875,2876,2877,4539,4540,4541]],
[[167,-41,-73],[165,-85,-70],[161,-62,-68,],0xFFFFFF,[2559,2560,2561,2578,2579,2580,2581,2582,2583,2852,2853,2854,2871,2872,2873,2874,2875,2876],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2582,2583,2584,2875,2876,2877,4539,4540,4541]],
[[161,-62,-68],[165,-85,-70],[159,-72,-66,],0xFFFFFF,[2582,2583,2584,2875,2876,2877,4539,4540,4541],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2584,2585,2877,2878,4541,4542,4543,4589,4595]],
[[159,-72,-66],[165,-85,-70],[157,-82,-63,],0xFFFFFF,[2584,2585,2877,2878,4541,4542,4543,4589,4595],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2585,2586,2878,2879]],
[[157,-82,-63],[165,-85,-70],[155,-92,-60,],0xFFFFFF,[2585,2586,2878,2879],[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2586,2587,2879,2880]],
[[165,-85,-70],[177,-91,-82],[155,-92,-60,],0xFFFFFF,[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881],[2586,2587,2879,2880]],
[[165,-85,-70],[172,-85,-79],[177,-91,-82,],0xFFFFFF,[2561,2562,2583,2584,2585,2586,2587,2588,2854,2855,2876,2877,2878,2879,2880,2881],[2562,2564,2565,2566,2567,2588,2855,2857,2858,2859,2860,2881],[2471,2472,2564,2587,2588,2764,2765,2857,2880,2881]],
[[182,-1,-87],[176,-6,-84],[174,-1,-81,],0xFFFFFF,[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2558,2559,2560,2572,2573,2574,2589,2851,2852,2853,2865,2866,2867,2882],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884]],
[[165,-2,-73],[180,5,-62],[191,6,-49,],0xFFFFFF,[899,901,940,941,942,2563,2575,2576,2590,2856,2868,2869,2883],[2552,2553,2590,2845,2846,2883],[2539,2540,2590,2598,2832,2833,2883,2891]],
[[206,9,-55],[182,-1,-87],[174,-1,-81,],0xFFFFFF,[2348,2349,2350,2544,2545,2546,2591,2641,2642,2643,2837,2838,2839,2884],[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885],[2555,2556,2557,2558,2589,2591,2848,2849,2850,2851,2882,2884]],
[[202,29,-53],[207,-1,-56],[182,-1,-87,],0xFFFFFF,[2344,2345,2346,2547,2548,2549,2592,2637,2638,2639,2840,2841,2842,2885],[2350,2351,2352,2438,2536,2544,2554,2592,2643,2644,2645,2731,2829,2837,2847,2885],[2455,2574,2589,2591,2592,2748,2867,2882,2884,2885]],
[[180,48,-44],[185,43,-45],[182,38,-46,],0xFFFFFF,[2593,2886],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2593,2594,2886,2887,4474,4475,4476]],
[[182,38,-46],[185,43,-45],[184,28,-47,],0xFFFFFF,[2593,2594,2886,2887,4474,4475,4476],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2594,2595,2596,2887,2888,2889]],
[[184,28,-47],[185,43,-45],[190,11,-48,],0xFFFFFF,[2594,2595,2596,2887,2888,2889],[2537,2542,2543,2593,2594,2595,2830,2835,2836,2886,2887,2888],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891]],
[[184,28,-47],[190,11,-48],[185,18,-47,],0xFFFFFF,[2594,2595,2596,2887,2888,2889],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[888,893,938,940,2596,2597,2889,2890]],
[[185,18,-47],[190,11,-48],[186,8,-48,],0xFFFFFF,[888,893,938,940,2596,2597,2889,2890],[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2597,2598,2890,2891]],
[[190,11,-48],[191,6,-49],[186,8,-48,],0xFFFFFF,[2537,2538,2539,2595,2596,2597,2598,2830,2831,2832,2888,2889,2890,2891],[2539,2540,2590,2598,2832,2833,2883,2891],[2597,2598,2890,2891]],
[[32,60,-11],[36,60,-25],[14,55,-16,],0xFFFFFF,[2892,2924],[2892,2893,2924,2925],[2892,2893,2894,2924,2925,2926]],
[[36,60,-25],[18,55,-31],[14,55,-16,],0xFFFFFF,[2892,2893,2924,2925],[2893,2894,2895,2925,2926,2927],[2892,2893,2894,2924,2925,2926]],
[[14,55,-16],[18,55,-31],[6,49,-17,],0xFFFFFF,[2892,2893,2894,2924,2925,2926],[2893,2894,2895,2925,2926,2927],[2894,2895,2896,2926,2927,2928]],
[[18,55,-31],[10,49,-34],[6,49,-17,],0xFFFFFF,[2893,2894,2895,2925,2926,2927],[2895,2896,2897,2927,2928,2929],[2894,2895,2896,2926,2927,2928]],
[[6,49,-17],[10,49,-34],[0,39,-18,],0xFFFFFF,[2894,2895,2896,2926,2927,2928],[2895,2896,2897,2927,2928,2929],[2896,2897,2898,2928,2929,2930]],
[[10,49,-34],[4,39,-36],[0,39,-18,],0xFFFFFF,[2895,2896,2897,2927,2928,2929],[2897,2898,2899,2929,2930,2931],[2896,2897,2898,2928,2929,2930]],
[[0,39,-18],[4,39,-36],[-3,29,-19,],0xFFFFFF,[2896,2897,2898,2928,2929,2930],[2897,2898,2899,2929,2930,2931],[2898,2899,2900,2930,2931,2932]],
[[4,39,-36],[1,29,-37],[-3,29,-19,],0xFFFFFF,[2897,2898,2899,2929,2930,2931],[2899,2900,2901,2931,2932,2933],[2898,2899,2900,2930,2931,2932]],
[[-3,29,-19],[1,29,-37],[-5,19,-19,],0xFFFFFF,[2898,2899,2900,2930,2931,2932],[2899,2900,2901,2931,2932,2933],[2900,2901,2902,2932,2933,2934]],
[[1,29,-37],[0,19,-38],[-5,19,-19,],0xFFFFFF,[2899,2900,2901,2931,2932,2933],[2901,2902,2903,2933,2934,2935],[2900,2901,2902,2932,2933,2934]],
[[-5,19,-19],[0,19,-38],[-7,9,-19,],0xFFFFFF,[2900,2901,2902,2932,2933,2934],[2901,2902,2903,2933,2934,2935],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[0,19,-38],[-1,9,-39],[-7,9,-19,],0xFFFFFF,[2901,2902,2903,2933,2934,2935],[2903,2904,2905,2935,2936,2937],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[-7,9,-19],[-1,9,-39],[-8,-1,-20,],0xFFFFFF,[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936],[2903,2904,2905,2935,2936,2937],[2904,2905,2906,2936,2937,2938]],
[[-1,9,-39],[-3,-1,-39],[-8,-1,-20,],0xFFFFFF,[2903,2904,2905,2935,2936,2937],[2905,2906,2907,2937,2938,2939],[2904,2905,2906,2936,2937,2938]],
[[-8,-1,-20],[-3,-1,-39],[-9,-11,-20,],0xFFFFFF,[2904,2905,2906,2936,2937,2938],[2905,2906,2907,2937,2938,2939],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-3,-1,-39],[-4,-11,-40],[-9,-11,-20,],0xFFFFFF,[2905,2906,2907,2937,2938,2939],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-9,-11,-20],[-4,-11,-40],[-10,-21,-20,],0xFFFFFF,[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[2908,2909,2910,2940,2941,2942]],
[[-4,-11,-40],[-5,-21,-40],[-10,-21,-20,],0xFFFFFF,[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[2908,2909,2910,2940,2941,2942]],
[[-10,-21,-20],[-5,-21,-40],[-10,-31,-20,],0xFFFFFF,[2908,2909,2910,2940,2941,2942],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[2910,2911,2912,2942,2943,2944]],
[[-5,-21,-40],[-5,-31,-40],[-10,-31,-20,],0xFFFFFF,[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2910,2911,2912,2942,2943,2944]],
[[-10,-31,-20],[-5,-31,-40],[-10,-41,-20,],0xFFFFFF,[2910,2911,2912,2942,2943,2944],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2912,2913,2914,2944,2945,2946]],
[[-5,-31,-40],[-5,-41,-40],[-10,-41,-20,],0xFFFFFF,[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2913,2914,2915,2945,2946,2947],[2912,2913,2914,2944,2945,2946]],
[[-10,-41,-20],[-5,-41,-40],[-10,-51,-20,],0xFFFFFF,[2912,2913,2914,2944,2945,2946],[2913,2914,2915,2945,2946,2947],[2914,2915,2916,2946,2947,2948]],
[[-5,-41,-40],[-4,-51,-40],[-10,-51,-20,],0xFFFFFF,[2913,2914,2915,2945,2946,2947],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[2914,2915,2916,2946,2947,2948]],
[[-10,-51,-20],[-4,-51,-40],[-8,-61,-20,],0xFFFFFF,[2914,2915,2916,2946,2947,2948],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[2916,2917,2918,2948,2949,2950]],
[[-4,-51,-40],[-3,-61,-39],[-8,-61,-20,],0xFFFFFF,[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[2917,2918,2919,2949,2950,2951],[2916,2917,2918,2948,2949,2950]],
[[-8,-61,-20],[-3,-61,-39],[-7,-71,-19,],0xFFFFFF,[2916,2917,2918,2948,2949,2950],[2917,2918,2919,2949,2950,2951],[2918,2919,2920,2950,2951,2952]],
[[-3,-61,-39],[-2,-71,-39],[-7,-71,-19,],0xFFFFFF,[2917,2918,2919,2949,2950,2951],[2919,2920,2921,2951,2952,2953],[2918,2919,2920,2950,2951,2952]],
[[-7,-71,-19],[-2,-71,-39],[-4,-81,-19,],0xFFFFFF,[2918,2919,2920,2950,2951,2952],[2919,2920,2921,2951,2952,2953],[2920,2921,2922,2952,2953,2954]],
[[-2,-71,-39],[0,-81,-38],[-4,-81,-19,],0xFFFFFF,[2919,2920,2921,2951,2952,2953],[2921,2922,2923,2953,2954,2955],[2920,2921,2922,2952,2953,2954]],
[[-4,-81,-19],[0,-81,-38],[-1,-91,-18,],0xFFFFFF,[2920,2921,2922,2952,2953,2954],[2921,2922,2923,2953,2954,2955],[2922,2923,2954,2955]],
[[0,-81,-38],[3,-91,-37],[-1,-91,-18,],0xFFFFFF,[2921,2922,2923,2953,2954,2955],[2923,2955],[2922,2923,2954,2955]],
[[32,60,-11],[36,60,-25],[14,55,-16,],0xFFFFFF,[2892,2924],[2892,2893,2924,2925],[2892,2893,2894,2924,2925,2926]],
[[36,60,-25],[18,55,-31],[14,55,-16,],0xFFFFFF,[2892,2893,2924,2925],[2893,2894,2895,2925,2926,2927],[2892,2893,2894,2924,2925,2926]],
[[14,55,-16],[18,55,-31],[6,49,-17,],0xFFFFFF,[2892,2893,2894,2924,2925,2926],[2893,2894,2895,2925,2926,2927],[2894,2895,2896,2926,2927,2928]],
[[18,55,-31],[10,49,-34],[6,49,-17,],0xFFFFFF,[2893,2894,2895,2925,2926,2927],[2895,2896,2897,2927,2928,2929],[2894,2895,2896,2926,2927,2928]],
[[6,49,-17],[10,49,-34],[0,39,-18,],0xFFFFFF,[2894,2895,2896,2926,2927,2928],[2895,2896,2897,2927,2928,2929],[2896,2897,2898,2928,2929,2930]],
[[10,49,-34],[4,39,-36],[0,39,-18,],0xFFFFFF,[2895,2896,2897,2927,2928,2929],[2897,2898,2899,2929,2930,2931],[2896,2897,2898,2928,2929,2930]],
[[0,39,-18],[4,39,-36],[-3,29,-19,],0xFFFFFF,[2896,2897,2898,2928,2929,2930],[2897,2898,2899,2929,2930,2931],[2898,2899,2900,2930,2931,2932]],
[[4,39,-36],[1,29,-37],[-3,29,-19,],0xFFFFFF,[2897,2898,2899,2929,2930,2931],[2899,2900,2901,2931,2932,2933],[2898,2899,2900,2930,2931,2932]],
[[-3,29,-19],[1,29,-37],[-5,19,-19,],0xFFFFFF,[2898,2899,2900,2930,2931,2932],[2899,2900,2901,2931,2932,2933],[2900,2901,2902,2932,2933,2934]],
[[1,29,-37],[0,19,-38],[-5,19,-19,],0xFFFFFF,[2899,2900,2901,2931,2932,2933],[2901,2902,2903,2933,2934,2935],[2900,2901,2902,2932,2933,2934]],
[[-5,19,-19],[0,19,-38],[-7,9,-19,],0xFFFFFF,[2900,2901,2902,2932,2933,2934],[2901,2902,2903,2933,2934,2935],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[0,19,-38],[-1,9,-39],[-7,9,-19,],0xFFFFFF,[2901,2902,2903,2933,2934,2935],[2903,2904,2905,2935,2936,2937],[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936]],
[[-7,9,-19],[-1,9,-39],[-8,-1,-20,],0xFFFFFF,[965,967,968,977,986,987,2902,2903,2904,2934,2935,2936],[2903,2904,2905,2935,2936,2937],[2904,2905,2906,2936,2937,2938]],
[[-1,9,-39],[-3,-1,-39],[-8,-1,-20,],0xFFFFFF,[2903,2904,2905,2935,2936,2937],[2905,2906,2907,2937,2938,2939],[2904,2905,2906,2936,2937,2938]],
[[-8,-1,-20],[-3,-1,-39],[-9,-11,-20,],0xFFFFFF,[2904,2905,2906,2936,2937,2938],[2905,2906,2907,2937,2938,2939],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-3,-1,-39],[-4,-11,-40],[-9,-11,-20,],0xFFFFFF,[2905,2906,2907,2937,2938,2939],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940]],
[[-9,-11,-20],[-4,-11,-40],[-10,-21,-20,],0xFFFFFF,[970,971,972,979,980,981,2906,2907,2908,2938,2939,2940],[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[2908,2909,2910,2940,2941,2942]],
[[-4,-11,-40],[-5,-21,-40],[-10,-21,-20,],0xFFFFFF,[508,509,510,678,679,680,2320,2321,2322,2613,2614,2615,2907,2908,2909,2939,2940,2941],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[2908,2909,2910,2940,2941,2942]],
[[-10,-21,-20],[-5,-21,-40],[-10,-31,-20,],0xFFFFFF,[2908,2909,2910,2940,2941,2942],[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[2910,2911,2912,2942,2943,2944]],
[[-5,-21,-40],[-5,-31,-40],[-10,-31,-20,],0xFFFFFF,[510,511,512,680,681,682,2909,2910,2911,2941,2942,2943],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2910,2911,2912,2942,2943,2944]],
[[-10,-31,-20],[-5,-31,-40],[-10,-41,-20,],0xFFFFFF,[2910,2911,2912,2942,2943,2944],[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2912,2913,2914,2944,2945,2946]],
[[-5,-31,-40],[-5,-41,-40],[-10,-41,-20,],0xFFFFFF,[2324,2325,2326,2617,2618,2619,2911,2912,2913,2943,2944,2945],[2913,2914,2915,2945,2946,2947],[2912,2913,2914,2944,2945,2946]],
[[-10,-41,-20],[-5,-41,-40],[-10,-51,-20,],0xFFFFFF,[2912,2913,2914,2944,2945,2946],[2913,2914,2915,2945,2946,2947],[2914,2915,2916,2946,2947,2948]],
[[-5,-41,-40],[-4,-51,-40],[-10,-51,-20,],0xFFFFFF,[2913,2914,2915,2945,2946,2947],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[2914,2915,2916,2946,2947,2948]],
[[-10,-51,-20],[-4,-51,-40],[-8,-61,-20,],0xFFFFFF,[2914,2915,2916,2946,2947,2948],[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[2916,2917,2918,2948,2949,2950]],
[[-4,-51,-40],[-3,-61,-39],[-8,-61,-20,],0xFFFFFF,[990,991,992,1001,1002,1003,2915,2916,2917,2947,2948,2949],[2917,2918,2919,2949,2950,2951],[2916,2917,2918,2948,2949,2950]],
[[-8,-61,-20],[-3,-61,-39],[-7,-71,-19,],0xFFFFFF,[2916,2917,2918,2948,2949,2950],[2917,2918,2919,2949,2950,2951],[2918,2919,2920,2950,2951,2952]],
[[-3,-61,-39],[-2,-71,-39],[-7,-71,-19,],0xFFFFFF,[2917,2918,2919,2949,2950,2951],[2919,2920,2921,2951,2952,2953],[2918,2919,2920,2950,2951,2952]],
[[-7,-71,-19],[-2,-71,-39],[-4,-81,-19,],0xFFFFFF,[2918,2919,2920,2950,2951,2952],[2919,2920,2921,2951,2952,2953],[2920,2921,2922,2952,2953,2954]],
[[-2,-71,-39],[0,-81,-38],[-4,-81,-19,],0xFFFFFF,[2919,2920,2921,2951,2952,2953],[2921,2922,2923,2953,2954,2955],[2920,2921,2922,2952,2953,2954]],
[[-4,-81,-19],[0,-81,-38],[-1,-91,-18,],0xFFFFFF,[2920,2921,2922,2952,2953,2954],[2921,2922,2923,2953,2954,2955],[2922,2923,2954,2955]],
[[0,-81,-38],[3,-91,-37],[-1,-91,-18,],0xFFFFFF,[2921,2922,2923,2953,2954,2955],[2923,2955],[2922,2923,2954,2955]],
[[31,60,1],[32,60,-12],[13,55,0,],0xFFFFFF,[2956,2988],[2956,2957,2988,2989],[2956,2957,2958,2988,2989,2990]],
[[32,60,-12],[14,55,-16],[13,55,0,],0xFFFFFF,[2956,2957,2988,2989],[2957,2958,2959,2989,2990,2991],[2956,2957,2958,2988,2989,2990]],
[[13,55,0],[14,55,-16],[4,49,0,],0xFFFFFF,[2956,2957,2958,2988,2989,2990],[2957,2958,2959,2989,2990,2991],[2958,2959,2960,2990,2991,2992]],
[[14,55,-16],[6,49,-17],[4,49,0,],0xFFFFFF,[2957,2958,2959,2989,2990,2991],[2959,2960,2961,2991,2992,2993],[2958,2959,2960,2990,2991,2992]],
[[4,49,0],[6,49,-17],[-1,39,0,],0xFFFFFF,[2958,2959,2960,2990,2991,2992],[2959,2960,2961,2991,2992,2993],[2960,2961,2962,2992,2993,2994]],
[[6,49,-17],[0,39,-18],[-1,39,0,],0xFFFFFF,[2959,2960,2961,2991,2992,2993],[2961,2962,2963,2993,2994,2995],[2960,2961,2962,2992,2993,2994]],
[[-1,39,0],[0,39,-18],[-4,29,0,],0xFFFFFF,[2960,2961,2962,2992,2993,2994],[2961,2962,2963,2993,2994,2995],[2962,2963,2964,2994,2995,2996]],
[[0,39,-18],[-3,29,-19],[-4,29,0,],0xFFFFFF,[2961,2962,2963,2993,2994,2995],[2963,2964,2965,2995,2996,2997],[2962,2963,2964,2994,2995,2996]],
[[-4,29,0],[-3,29,-19],[-7,19,0,],0xFFFFFF,[2962,2963,2964,2994,2995,2996],[2963,2964,2965,2995,2996,2997],[2964,2965,2966,2996,2997,2998]],
[[-3,29,-19],[-5,19,-19],[-7,19,0,],0xFFFFFF,[2963,2964,2965,2995,2996,2997],[2965,2966,2967,2997,2998,2999],[2964,2965,2966,2996,2997,2998]],
[[-7,19,0],[-5,19,-19],[-8,9,0,],0xFFFFFF,[2964,2965,2966,2996,2997,2998],[2965,2966,2967,2997,2998,2999],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-5,19,-19],[-7,9,-19],[-8,9,0,],0xFFFFFF,[2965,2966,2967,2997,2998,2999],[2967,2968,2969,2999,3000,3001],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-8,9,0],[-7,9,-19],[-10,-1,0,],0xFFFFFF,[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000],[2967,2968,2969,2999,3000,3001],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002]],
[[-7,9,-19],[-8,-1,-20],[-10,-1,0,],0xFFFFFF,[2967,2968,2969,2999,3000,3001],[2969,2970,2971,3001,3002,3003],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002]],
[[-10,-1,0],[-8,-1,-20],[-11,-11,0,],0xFFFFFF,[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[2969,2970,2971,3001,3002,3003],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-8,-1,-20],[-9,-11,-20],[-11,-11,0,],0xFFFFFF,[2969,2970,2971,3001,3002,3003],[2971,2972,2973,3003,3004,3005],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-11,-11,0],[-9,-11,-20],[-12,-21,0,],0xFFFFFF,[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004],[2971,2972,2973,3003,3004,3005],[2972,2973,2974,3004,3005,3006]],
[[-9,-11,-20],[-10,-21,-20],[-12,-21,0,],0xFFFFFF,[2971,2972,2973,3003,3004,3005],[2973,2974,2975,3005,3006,3007],[2972,2973,2974,3004,3005,3006]],
[[-12,-21,0],[-10,-21,-20],[-12,-31,0,],0xFFFFFF,[2972,2973,2974,3004,3005,3006],[2973,2974,2975,3005,3006,3007],[2974,2975,2976,3006,3007,3008]],
[[-10,-21,-20],[-10,-31,-20],[-12,-31,0,],0xFFFFFF,[2973,2974,2975,3005,3006,3007],[2975,2976,2977,3007,3008,3009],[2974,2975,2976,3006,3007,3008]],
[[-12,-31,0],[-10,-31,-20],[-12,-41,0,],0xFFFFFF,[2974,2975,2976,3006,3007,3008],[2975,2976,2977,3007,3008,3009],[2976,2977,2978,3008,3009,3010]],
[[-10,-31,-20],[-10,-41,-20],[-12,-41,0,],0xFFFFFF,[2975,2976,2977,3007,3008,3009],[2977,2978,2979,3009,3010,3011],[2976,2977,2978,3008,3009,3010]],
[[-12,-41,0],[-10,-41,-20],[-11,-51,0,],0xFFFFFF,[2976,2977,2978,3008,3009,3010],[2977,2978,2979,3009,3010,3011],[2978,2979,2980,3010,3011,3012]],
[[-10,-41,-20],[-10,-51,-20],[-11,-51,0,],0xFFFFFF,[2977,2978,2979,3009,3010,3011],[2979,2980,2981,3011,3012,3013],[2978,2979,2980,3010,3011,3012]],
[[-11,-51,0],[-10,-51,-20],[-10,-61,0,],0xFFFFFF,[2978,2979,2980,3010,3011,3012],[2979,2980,2981,3011,3012,3013],[2980,2981,2982,3012,3013,3014]],
[[-10,-51,-20],[-8,-61,-20],[-10,-61,0,],0xFFFFFF,[2979,2980,2981,3011,3012,3013],[2981,2982,2983,3013,3014,3015],[2980,2981,2982,3012,3013,3014]],
[[-10,-61,0],[-8,-61,-20],[-8,-71,0,],0xFFFFFF,[2980,2981,2982,3012,3013,3014],[2981,2982,2983,3013,3014,3015],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081]],
[[-8,-61,-20],[-7,-71,-19],[-8,-71,0,],0xFFFFFF,[2981,2982,2983,3013,3014,3015],[2983,2984,2985,3015,3016,3017],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081]],
[[-8,-71,0],[-7,-71,-19],[-6,-81,0,],0xFFFFFF,[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[2983,2984,2985,3015,3016,3017],[2984,2985,2986,3016,3017,3018]],
[[-7,-71,-19],[-4,-81,-19],[-6,-81,0,],0xFFFFFF,[2983,2984,2985,3015,3016,3017],[2985,2986,2987,3017,3018,3019],[2984,2985,2986,3016,3017,3018]],
[[-6,-81,0],[-4,-81,-19],[-3,-91,0,],0xFFFFFF,[2984,2985,2986,3016,3017,3018],[2985,2986,2987,3017,3018,3019],[2986,2987,3018,3019]],
[[-4,-81,-19],[-1,-91,-18],[-3,-91,0,],0xFFFFFF,[2985,2986,2987,3017,3018,3019],[2987,3019],[2986,2987,3018,3019]],
[[31,60,1],[32,60,-12],[13,55,0,],0xFFFFFF,[2956,2988],[2956,2957,2988,2989],[2956,2957,2958,2988,2989,2990]],
[[32,60,-12],[14,55,-16],[13,55,0,],0xFFFFFF,[2956,2957,2988,2989],[2957,2958,2959,2989,2990,2991],[2956,2957,2958,2988,2989,2990]],
[[13,55,0],[14,55,-16],[4,49,0,],0xFFFFFF,[2956,2957,2958,2988,2989,2990],[2957,2958,2959,2989,2990,2991],[2958,2959,2960,2990,2991,2992]],
[[14,55,-16],[6,49,-17],[4,49,0,],0xFFFFFF,[2957,2958,2959,2989,2990,2991],[2959,2960,2961,2991,2992,2993],[2958,2959,2960,2990,2991,2992]],
[[4,49,0],[6,49,-17],[-1,39,0,],0xFFFFFF,[2958,2959,2960,2990,2991,2992],[2959,2960,2961,2991,2992,2993],[2960,2961,2962,2992,2993,2994]],
[[6,49,-17],[0,39,-18],[-1,39,0,],0xFFFFFF,[2959,2960,2961,2991,2992,2993],[2961,2962,2963,2993,2994,2995],[2960,2961,2962,2992,2993,2994]],
[[-1,39,0],[0,39,-18],[-4,29,0,],0xFFFFFF,[2960,2961,2962,2992,2993,2994],[2961,2962,2963,2993,2994,2995],[2962,2963,2964,2994,2995,2996]],
[[0,39,-18],[-3,29,-19],[-4,29,0,],0xFFFFFF,[2961,2962,2963,2993,2994,2995],[2963,2964,2965,2995,2996,2997],[2962,2963,2964,2994,2995,2996]],
[[-4,29,0],[-3,29,-19],[-7,19,0,],0xFFFFFF,[2962,2963,2964,2994,2995,2996],[2963,2964,2965,2995,2996,2997],[2964,2965,2966,2996,2997,2998]],
[[-3,29,-19],[-5,19,-19],[-7,19,0,],0xFFFFFF,[2963,2964,2965,2995,2996,2997],[2965,2966,2967,2997,2998,2999],[2964,2965,2966,2996,2997,2998]],
[[-7,19,0],[-5,19,-19],[-8,9,0,],0xFFFFFF,[2964,2965,2966,2996,2997,2998],[2965,2966,2967,2997,2998,2999],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-5,19,-19],[-7,9,-19],[-8,9,0,],0xFFFFFF,[2965,2966,2967,2997,2998,2999],[2967,2968,2969,2999,3000,3001],[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000]],
[[-8,9,0],[-7,9,-19],[-10,-1,0,],0xFFFFFF,[1029,1031,1032,1041,1050,1051,2966,2967,2968,2998,2999,3000],[2967,2968,2969,2999,3000,3001],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002]],
[[-7,9,-19],[-8,-1,-20],[-10,-1,0,],0xFFFFFF,[2967,2968,2969,2999,3000,3001],[2969,2970,2971,3001,3002,3003],[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002]],
[[-10,-1,0],[-8,-1,-20],[-11,-11,0,],0xFFFFFF,[1097,1098,1099,1106,1107,1108,2968,2969,2970,3000,3001,3002],[2969,2970,2971,3001,3002,3003],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-8,-1,-20],[-9,-11,-20],[-11,-11,0,],0xFFFFFF,[2969,2970,2971,3001,3002,3003],[2971,2972,2973,3003,3004,3005],[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004]],
[[-11,-11,0],[-9,-11,-20],[-12,-21,0,],0xFFFFFF,[1034,1035,1036,1043,1044,1045,2970,2971,2972,3002,3003,3004],[2971,2972,2973,3003,3004,3005],[2972,2973,2974,3004,3005,3006]],
[[-9,-11,-20],[-10,-21,-20],[-12,-21,0,],0xFFFFFF,[2971,2972,2973,3003,3004,3005],[2973,2974,2975,3005,3006,3007],[2972,2973,2974,3004,3005,3006]],
[[-12,-21,0],[-10,-21,-20],[-12,-31,0,],0xFFFFFF,[2972,2973,2974,3004,3005,3006],[2973,2974,2975,3005,3006,3007],[2974,2975,2976,3006,3007,3008]],
[[-10,-21,-20],[-10,-31,-20],[-12,-31,0,],0xFFFFFF,[2973,2974,2975,3005,3006,3007],[2975,2976,2977,3007,3008,3009],[2974,2975,2976,3006,3007,3008]],
[[-12,-31,0],[-10,-31,-20],[-12,-41,0,],0xFFFFFF,[2974,2975,2976,3006,3007,3008],[2975,2976,2977,3007,3008,3009],[2976,2977,2978,3008,3009,3010]],
[[-10,-31,-20],[-10,-41,-20],[-12,-41,0,],0xFFFFFF,[2975,2976,2977,3007,3008,3009],[2977,2978,2979,3009,3010,3011],[2976,2977,2978,3008,3009,3010]],
[[-12,-41,0],[-10,-41,-20],[-11,-51,0,],0xFFFFFF,[2976,2977,2978,3008,3009,3010],[2977,2978,2979,3009,3010,3011],[2978,2979,2980,3010,3011,3012]],
[[-10,-41,-20],[-10,-51,-20],[-11,-51,0,],0xFFFFFF,[2977,2978,2979,3009,3010,3011],[2979,2980,2981,3011,3012,3013],[2978,2979,2980,3010,3011,3012]],
[[-11,-51,0],[-10,-51,-20],[-10,-61,0,],0xFFFFFF,[2978,2979,2980,3010,3011,3012],[2979,2980,2981,3011,3012,3013],[2980,2981,2982,3012,3013,3014]],
[[-10,-51,-20],[-8,-61,-20],[-10,-61,0,],0xFFFFFF,[2979,2980,2981,3011,3012,3013],[2981,2982,2983,3013,3014,3015],[2980,2981,2982,3012,3013,3014]],
[[-10,-61,0],[-8,-61,-20],[-8,-71,0,],0xFFFFFF,[2980,2981,2982,3012,3013,3014],[2981,2982,2983,3013,3014,3015],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081]],
[[-8,-61,-20],[-7,-71,-19],[-8,-71,0,],0xFFFFFF,[2981,2982,2983,3013,3014,3015],[2983,2984,2985,3015,3016,3017],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081]],
[[-8,-71,0],[-7,-71,-19],[-6,-81,0,],0xFFFFFF,[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[2983,2984,2985,3015,3016,3017],[2984,2985,2986,3016,3017,3018]],
[[-7,-71,-19],[-4,-81,-19],[-6,-81,0,],0xFFFFFF,[2983,2984,2985,3015,3016,3017],[2985,2986,2987,3017,3018,3019],[2984,2985,2986,3016,3017,3018]],
[[-6,-81,0],[-4,-81,-19],[-3,-91,0,],0xFFFFFF,[2984,2985,2986,3016,3017,3018],[2985,2986,2987,3017,3018,3019],[2986,2987,3018,3019]],
[[-4,-81,-19],[-1,-91,-18],[-3,-91,0,],0xFFFFFF,[2985,2986,2987,3017,3018,3019],[2987,3019],[2986,2987,3018,3019]],
[[32,60,14],[31,60,0],[14,55,16,],0xFFFFFF,[3020,3052],[3020,3021,3052,3053],[3020,3021,3022,3052,3053,3054]],
[[31,60,0],[13,55,0],[14,55,16,],0xFFFFFF,[3020,3021,3052,3053],[3021,3022,3023,3053,3054,3055],[3020,3021,3022,3052,3053,3054]],
[[14,55,16],[13,55,0],[6,49,17,],0xFFFFFF,[3020,3021,3022,3052,3053,3054],[3021,3022,3023,3053,3054,3055],[3022,3023,3024,3054,3055,3056]],
[[13,55,0],[4,49,0],[6,49,17,],0xFFFFFF,[3021,3022,3023,3053,3054,3055],[3023,3024,3025,3055,3056,3057],[3022,3023,3024,3054,3055,3056]],
[[6,49,17],[4,49,0],[0,39,18,],0xFFFFFF,[3022,3023,3024,3054,3055,3056],[3023,3024,3025,3055,3056,3057],[3024,3025,3026,3056,3057,3058]],
[[4,49,0],[-1,39,0],[0,39,18,],0xFFFFFF,[3023,3024,3025,3055,3056,3057],[3025,3026,3027,3057,3058,3059],[3024,3025,3026,3056,3057,3058]],
[[0,39,18],[-1,39,0],[-3,29,19,],0xFFFFFF,[3024,3025,3026,3056,3057,3058],[3025,3026,3027,3057,3058,3059],[3026,3027,3028,3058,3059,3060]],
[[-1,39,0],[-4,29,0],[-3,29,19,],0xFFFFFF,[3025,3026,3027,3057,3058,3059],[3027,3028,3029,3059,3060,3061],[3026,3027,3028,3058,3059,3060]],
[[-3,29,19],[-4,29,0],[-5,19,19,],0xFFFFFF,[3026,3027,3028,3058,3059,3060],[3027,3028,3029,3059,3060,3061],[3028,3029,3030,3060,3061,3062]],
[[-4,29,0],[-7,19,0],[-5,19,19,],0xFFFFFF,[3027,3028,3029,3059,3060,3061],[3029,3030,3031,3061,3062,3063],[3028,3029,3030,3060,3061,3062]],
[[-5,19,19],[-7,19,0],[-7,9,19,],0xFFFFFF,[3028,3029,3030,3060,3061,3062],[3029,3030,3031,3061,3062,3063],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-7,19,0],[-8,9,0],[-7,9,19,],0xFFFFFF,[3029,3030,3031,3061,3062,3063],[3031,3032,3033,3063,3064,3065],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-7,9,19],[-8,9,0],[-8,-1,20,],0xFFFFFF,[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064],[3031,3032,3033,3063,3064,3065],[3032,3033,3034,3064,3065,3066]],
[[-8,9,0],[-10,-1,0],[-8,-1,20,],0xFFFFFF,[3031,3032,3033,3063,3064,3065],[3033,3034,3035,3065,3066,3067],[3032,3033,3034,3064,3065,3066]],
[[-8,-1,20],[-10,-1,0],[-9,-11,20,],0xFFFFFF,[3032,3033,3034,3064,3065,3066],[3033,3034,3035,3065,3066,3067],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-10,-1,0],[-11,-11,0],[-9,-11,20,],0xFFFFFF,[3033,3034,3035,3065,3066,3067],[3035,3036,3037,3067,3068,3069],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-9,-11,20],[-11,-11,0],[-10,-21,20,],0xFFFFFF,[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068],[3035,3036,3037,3067,3068,3069],[3036,3037,3038,3068,3069,3070]],
[[-11,-11,0],[-12,-21,0],[-10,-21,20,],0xFFFFFF,[3035,3036,3037,3067,3068,3069],[3037,3038,3039,3069,3070,3071],[3036,3037,3038,3068,3069,3070]],
[[-10,-21,20],[-12,-21,0],[-10,-31,20,],0xFFFFFF,[3036,3037,3038,3068,3069,3070],[3037,3038,3039,3069,3070,3071],[3038,3039,3040,3070,3071,3072]],
[[-12,-21,0],[-12,-31,0],[-10,-31,20,],0xFFFFFF,[3037,3038,3039,3069,3070,3071],[3039,3040,3041,3071,3072,3073],[3038,3039,3040,3070,3071,3072]],
[[-10,-31,20],[-12,-31,0],[-10,-41,20,],0xFFFFFF,[3038,3039,3040,3070,3071,3072],[3039,3040,3041,3071,3072,3073],[3040,3041,3042,3072,3073,3074]],
[[-12,-31,0],[-12,-41,0],[-10,-41,20,],0xFFFFFF,[3039,3040,3041,3071,3072,3073],[3041,3042,3043,3073,3074,3075],[3040,3041,3042,3072,3073,3074]],
[[-10,-41,20],[-12,-41,0],[-10,-51,20,],0xFFFFFF,[3040,3041,3042,3072,3073,3074],[3041,3042,3043,3073,3074,3075],[3042,3043,3044,3074,3075,3076]],
[[-12,-41,0],[-11,-51,0],[-10,-51,20,],0xFFFFFF,[3041,3042,3043,3073,3074,3075],[3043,3044,3045,3075,3076,3077],[3042,3043,3044,3074,3075,3076]],
[[-10,-51,20],[-11,-51,0],[-8,-61,20,],0xFFFFFF,[3042,3043,3044,3074,3075,3076],[3043,3044,3045,3075,3076,3077],[3044,3045,3046,3076,3077,3078]],
[[-11,-51,0],[-10,-61,0],[-8,-61,20,],0xFFFFFF,[3043,3044,3045,3075,3076,3077],[3045,3046,3047,3077,3078,3079],[3044,3045,3046,3076,3077,3078]],
[[-8,-61,20],[-10,-61,0],[-7,-71,19,],0xFFFFFF,[3044,3045,3046,3076,3077,3078],[3045,3046,3047,3077,3078,3079],[3046,3047,3048,3078,3079,3080]],
[[-10,-61,0],[-8,-71,0],[-7,-71,19,],0xFFFFFF,[3045,3046,3047,3077,3078,3079],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[3046,3047,3048,3078,3079,3080]],
[[-7,-71,19],[-8,-71,0],[-4,-81,19,],0xFFFFFF,[3046,3047,3048,3078,3079,3080],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[3048,3049,3050,3080,3081,3082]],
[[-8,-71,0],[-6,-81,0],[-4,-81,19,],0xFFFFFF,[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[3049,3050,3051,3081,3082,3083],[3048,3049,3050,3080,3081,3082]],
[[-4,-81,19],[-6,-81,0],[-1,-91,18,],0xFFFFFF,[3048,3049,3050,3080,3081,3082],[3049,3050,3051,3081,3082,3083],[3050,3051,3082,3083]],
[[-6,-81,0],[-3,-91,0],[-1,-91,18,],0xFFFFFF,[3049,3050,3051,3081,3082,3083],[3051,3083],[3050,3051,3082,3083]],
[[32,60,14],[31,60,0],[14,55,16,],0xFFFFFF,[3020,3052],[3020,3021,3052,3053],[3020,3021,3022,3052,3053,3054]],
[[31,60,0],[13,55,0],[14,55,16,],0xFFFFFF,[3020,3021,3052,3053],[3021,3022,3023,3053,3054,3055],[3020,3021,3022,3052,3053,3054]],
[[14,55,16],[13,55,0],[6,49,17,],0xFFFFFF,[3020,3021,3022,3052,3053,3054],[3021,3022,3023,3053,3054,3055],[3022,3023,3024,3054,3055,3056]],
[[13,55,0],[4,49,0],[6,49,17,],0xFFFFFF,[3021,3022,3023,3053,3054,3055],[3023,3024,3025,3055,3056,3057],[3022,3023,3024,3054,3055,3056]],
[[6,49,17],[4,49,0],[0,39,18,],0xFFFFFF,[3022,3023,3024,3054,3055,3056],[3023,3024,3025,3055,3056,3057],[3024,3025,3026,3056,3057,3058]],
[[4,49,0],[-1,39,0],[0,39,18,],0xFFFFFF,[3023,3024,3025,3055,3056,3057],[3025,3026,3027,3057,3058,3059],[3024,3025,3026,3056,3057,3058]],
[[0,39,18],[-1,39,0],[-3,29,19,],0xFFFFFF,[3024,3025,3026,3056,3057,3058],[3025,3026,3027,3057,3058,3059],[3026,3027,3028,3058,3059,3060]],
[[-1,39,0],[-4,29,0],[-3,29,19,],0xFFFFFF,[3025,3026,3027,3057,3058,3059],[3027,3028,3029,3059,3060,3061],[3026,3027,3028,3058,3059,3060]],
[[-3,29,19],[-4,29,0],[-5,19,19,],0xFFFFFF,[3026,3027,3028,3058,3059,3060],[3027,3028,3029,3059,3060,3061],[3028,3029,3030,3060,3061,3062]],
[[-4,29,0],[-7,19,0],[-5,19,19,],0xFFFFFF,[3027,3028,3029,3059,3060,3061],[3029,3030,3031,3061,3062,3063],[3028,3029,3030,3060,3061,3062]],
[[-5,19,19],[-7,19,0],[-7,9,19,],0xFFFFFF,[3028,3029,3030,3060,3061,3062],[3029,3030,3031,3061,3062,3063],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-7,19,0],[-8,9,0],[-7,9,19,],0xFFFFFF,[3029,3030,3031,3061,3062,3063],[3031,3032,3033,3063,3064,3065],[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064]],
[[-7,9,19],[-8,9,0],[-8,-1,20,],0xFFFFFF,[1093,1095,1096,1105,1114,1115,3030,3031,3032,3062,3063,3064],[3031,3032,3033,3063,3064,3065],[3032,3033,3034,3064,3065,3066]],
[[-8,9,0],[-10,-1,0],[-8,-1,20,],0xFFFFFF,[3031,3032,3033,3063,3064,3065],[3033,3034,3035,3065,3066,3067],[3032,3033,3034,3064,3065,3066]],
[[-8,-1,20],[-10,-1,0],[-9,-11,20,],0xFFFFFF,[3032,3033,3034,3064,3065,3066],[3033,3034,3035,3065,3066,3067],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-10,-1,0],[-11,-11,0],[-9,-11,20,],0xFFFFFF,[3033,3034,3035,3065,3066,3067],[3035,3036,3037,3067,3068,3069],[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068]],
[[-9,-11,20],[-11,-11,0],[-10,-21,20,],0xFFFFFF,[1098,1099,1100,1107,1108,1109,3034,3035,3036,3066,3067,3068],[3035,3036,3037,3067,3068,3069],[3036,3037,3038,3068,3069,3070]],
[[-11,-11,0],[-12,-21,0],[-10,-21,20,],0xFFFFFF,[3035,3036,3037,3067,3068,3069],[3037,3038,3039,3069,3070,3071],[3036,3037,3038,3068,3069,3070]],
[[-10,-21,20],[-12,-21,0],[-10,-31,20,],0xFFFFFF,[3036,3037,3038,3068,3069,3070],[3037,3038,3039,3069,3070,3071],[3038,3039,3040,3070,3071,3072]],
[[-12,-21,0],[-12,-31,0],[-10,-31,20,],0xFFFFFF,[3037,3038,3039,3069,3070,3071],[3039,3040,3041,3071,3072,3073],[3038,3039,3040,3070,3071,3072]],
[[-10,-31,20],[-12,-31,0],[-10,-41,20,],0xFFFFFF,[3038,3039,3040,3070,3071,3072],[3039,3040,3041,3071,3072,3073],[3040,3041,3042,3072,3073,3074]],
[[-12,-31,0],[-12,-41,0],[-10,-41,20,],0xFFFFFF,[3039,3040,3041,3071,3072,3073],[3041,3042,3043,3073,3074,3075],[3040,3041,3042,3072,3073,3074]],
[[-10,-41,20],[-12,-41,0],[-10,-51,20,],0xFFFFFF,[3040,3041,3042,3072,3073,3074],[3041,3042,3043,3073,3074,3075],[3042,3043,3044,3074,3075,3076]],
[[-12,-41,0],[-11,-51,0],[-10,-51,20,],0xFFFFFF,[3041,3042,3043,3073,3074,3075],[3043,3044,3045,3075,3076,3077],[3042,3043,3044,3074,3075,3076]],
[[-10,-51,20],[-11,-51,0],[-8,-61,20,],0xFFFFFF,[3042,3043,3044,3074,3075,3076],[3043,3044,3045,3075,3076,3077],[3044,3045,3046,3076,3077,3078]],
[[-11,-51,0],[-10,-61,0],[-8,-61,20,],0xFFFFFF,[3043,3044,3045,3075,3076,3077],[3045,3046,3047,3077,3078,3079],[3044,3045,3046,3076,3077,3078]],
[[-8,-61,20],[-10,-61,0],[-7,-71,19,],0xFFFFFF,[3044,3045,3046,3076,3077,3078],[3045,3046,3047,3077,3078,3079],[3046,3047,3048,3078,3079,3080]],
[[-10,-61,0],[-8,-71,0],[-7,-71,19,],0xFFFFFF,[3045,3046,3047,3077,3078,3079],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[3046,3047,3048,3078,3079,3080]],
[[-7,-71,19],[-8,-71,0],[-4,-81,19,],0xFFFFFF,[3046,3047,3048,3078,3079,3080],[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[3048,3049,3050,3080,3081,3082]],
[[-8,-71,0],[-6,-81,0],[-4,-81,19,],0xFFFFFF,[2982,2983,2984,3014,3015,3016,3047,3048,3049,3079,3080,3081],[3049,3050,3051,3081,3082,3083],[3048,3049,3050,3080,3081,3082]],
[[-4,-81,19],[-6,-81,0],[-1,-91,18,],0xFFFFFF,[3048,3049,3050,3080,3081,3082],[3049,3050,3051,3081,3082,3083],[3050,3051,3082,3083]],
[[-6,-81,0],[-3,-91,0],[-1,-91,18,],0xFFFFFF,[3049,3050,3051,3081,3082,3083],[3051,3083],[3050,3051,3082,3083]],
[[36,60,26],[32,60,12],[18,55,31,],0xFFFFFF,[3084,3116],[3084,3085,3116,3117],[3084,3085,3086,3116,3117,3118]],
[[32,60,12],[14,55,16],[18,55,31,],0xFFFFFF,[3084,3085,3116,3117],[3085,3086,3087,3117,3118,3119],[3084,3085,3086,3116,3117,3118]],
[[18,55,31],[14,55,16],[10,49,34,],0xFFFFFF,[3084,3085,3086,3116,3117,3118],[3085,3086,3087,3117,3118,3119],[3086,3087,3088,3118,3119,3120]],
[[14,55,16],[6,49,17],[10,49,34,],0xFFFFFF,[3085,3086,3087,3117,3118,3119],[3087,3088,3089,3119,3120,3121],[3086,3087,3088,3118,3119,3120]],
[[10,49,34],[6,49,17],[4,39,36,],0xFFFFFF,[3086,3087,3088,3118,3119,3120],[3087,3088,3089,3119,3120,3121],[3088,3089,3090,3120,3121,3122]],
[[6,49,17],[0,39,18],[4,39,36,],0xFFFFFF,[3087,3088,3089,3119,3120,3121],[3089,3090,3091,3121,3122,3123],[3088,3089,3090,3120,3121,3122]],
[[4,39,36],[0,39,18],[1,29,37,],0xFFFFFF,[3088,3089,3090,3120,3121,3122],[3089,3090,3091,3121,3122,3123],[3090,3091,3092,3122,3123,3124]],
[[0,39,18],[-3,29,19],[1,29,37,],0xFFFFFF,[3089,3090,3091,3121,3122,3123],[3091,3092,3093,3123,3124,3125],[3090,3091,3092,3122,3123,3124]],
[[1,29,37],[-3,29,19],[0,19,38,],0xFFFFFF,[3090,3091,3092,3122,3123,3124],[3091,3092,3093,3123,3124,3125],[3092,3093,3094,3124,3125,3126]],
[[-3,29,19],[-5,19,19],[0,19,38,],0xFFFFFF,[3091,3092,3093,3123,3124,3125],[3093,3094,3095,3125,3126,3127],[3092,3093,3094,3124,3125,3126]],
[[0,19,38],[-5,19,19],[-1,9,39,],0xFFFFFF,[3092,3093,3094,3124,3125,3126],[3093,3094,3095,3125,3126,3127],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-5,19,19],[-7,9,19],[-1,9,39,],0xFFFFFF,[3093,3094,3095,3125,3126,3127],[3095,3096,3097,3127,3128,3129],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-1,9,39],[-7,9,19],[-3,-1,39,],0xFFFFFF,[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128],[3095,3096,3097,3127,3128,3129],[3096,3097,3098,3128,3129,3130]],
[[-7,9,19],[-8,-1,20],[-3,-1,39,],0xFFFFFF,[3095,3096,3097,3127,3128,3129],[3097,3098,3099,3129,3130,3131],[3096,3097,3098,3128,3129,3130]],
[[-3,-1,39],[-8,-1,20],[-4,-11,40,],0xFFFFFF,[3096,3097,3098,3128,3129,3130],[3097,3098,3099,3129,3130,3131],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-8,-1,20],[-9,-11,20],[-4,-11,40,],0xFFFFFF,[3097,3098,3099,3129,3130,3131],[3099,3100,3101,3131,3132,3133],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-4,-11,40],[-9,-11,20],[-5,-21,40,],0xFFFFFF,[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132],[3099,3100,3101,3131,3132,3133],[3100,3101,3102,3132,3133,3134]],
[[-9,-11,20],[-10,-21,20],[-5,-21,40,],0xFFFFFF,[3099,3100,3101,3131,3132,3133],[3101,3102,3103,3133,3134,3135],[3100,3101,3102,3132,3133,3134]],
[[-5,-21,40],[-10,-21,20],[-5,-31,40,],0xFFFFFF,[3100,3101,3102,3132,3133,3134],[3101,3102,3103,3133,3134,3135],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201]],
[[-10,-21,20],[-10,-31,20],[-5,-31,40,],0xFFFFFF,[3101,3102,3103,3133,3134,3135],[3103,3104,3105,3135,3136,3137],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201]],
[[-5,-31,40],[-10,-31,20],[-5,-41,40,],0xFFFFFF,[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3103,3104,3105,3135,3136,3137],[3104,3105,3106,3136,3137,3138]],
[[-10,-31,20],[-10,-41,20],[-5,-41,40,],0xFFFFFF,[3103,3104,3105,3135,3136,3137],[3105,3106,3107,3137,3138,3139],[3104,3105,3106,3136,3137,3138]],
[[-5,-41,40],[-10,-41,20],[-4,-51,40,],0xFFFFFF,[3104,3105,3106,3136,3137,3138],[3105,3106,3107,3137,3138,3139],[3106,3107,3108,3138,3139,3140]],
[[-10,-41,20],[-10,-51,20],[-4,-51,40,],0xFFFFFF,[3105,3106,3107,3137,3138,3139],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[3106,3107,3108,3138,3139,3140]],
[[-4,-51,40],[-10,-51,20],[-3,-61,39,],0xFFFFFF,[3106,3107,3108,3138,3139,3140],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[3108,3109,3110,3140,3141,3142]],
[[-10,-51,20],[-8,-61,20],[-3,-61,39,],0xFFFFFF,[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[3109,3110,3111,3141,3142,3143],[3108,3109,3110,3140,3141,3142]],
[[-3,-61,39],[-8,-61,20],[-2,-71,39,],0xFFFFFF,[3108,3109,3110,3140,3141,3142],[3109,3110,3111,3141,3142,3143],[3110,3111,3112,3142,3143,3144]],
[[-8,-61,20],[-7,-71,19],[-2,-71,39,],0xFFFFFF,[3109,3110,3111,3141,3142,3143],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[3110,3111,3112,3142,3143,3144]],
[[-2,-71,39],[-7,-71,19],[0,-81,38,],0xFFFFFF,[3110,3111,3112,3142,3143,3144],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[-7,-71,19],[-4,-81,19],[0,-81,38,],0xFFFFFF,[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[3113,3114,3115,3145,3146,3147],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[0,-81,38],[-4,-81,19],[3,-91,37,],0xFFFFFF,[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146],[3113,3114,3115,3145,3146,3147],[3114,3115,3146,3147]],
[[-4,-81,19],[-1,-91,18],[3,-91,37,],0xFFFFFF,[3113,3114,3115,3145,3146,3147],[3115,3147],[3114,3115,3146,3147]],
[[36,60,26],[32,60,12],[18,55,31,],0xFFFFFF,[3084,3116],[3084,3085,3116,3117],[3084,3085,3086,3116,3117,3118]],
[[32,60,12],[14,55,16],[18,55,31,],0xFFFFFF,[3084,3085,3116,3117],[3085,3086,3087,3117,3118,3119],[3084,3085,3086,3116,3117,3118]],
[[18,55,31],[14,55,16],[10,49,34,],0xFFFFFF,[3084,3085,3086,3116,3117,3118],[3085,3086,3087,3117,3118,3119],[3086,3087,3088,3118,3119,3120]],
[[14,55,16],[6,49,17],[10,49,34,],0xFFFFFF,[3085,3086,3087,3117,3118,3119],[3087,3088,3089,3119,3120,3121],[3086,3087,3088,3118,3119,3120]],
[[10,49,34],[6,49,17],[4,39,36,],0xFFFFFF,[3086,3087,3088,3118,3119,3120],[3087,3088,3089,3119,3120,3121],[3088,3089,3090,3120,3121,3122]],
[[6,49,17],[0,39,18],[4,39,36,],0xFFFFFF,[3087,3088,3089,3119,3120,3121],[3089,3090,3091,3121,3122,3123],[3088,3089,3090,3120,3121,3122]],
[[4,39,36],[0,39,18],[1,29,37,],0xFFFFFF,[3088,3089,3090,3120,3121,3122],[3089,3090,3091,3121,3122,3123],[3090,3091,3092,3122,3123,3124]],
[[0,39,18],[-3,29,19],[1,29,37,],0xFFFFFF,[3089,3090,3091,3121,3122,3123],[3091,3092,3093,3123,3124,3125],[3090,3091,3092,3122,3123,3124]],
[[1,29,37],[-3,29,19],[0,19,38,],0xFFFFFF,[3090,3091,3092,3122,3123,3124],[3091,3092,3093,3123,3124,3125],[3092,3093,3094,3124,3125,3126]],
[[-3,29,19],[-5,19,19],[0,19,38,],0xFFFFFF,[3091,3092,3093,3123,3124,3125],[3093,3094,3095,3125,3126,3127],[3092,3093,3094,3124,3125,3126]],
[[0,19,38],[-5,19,19],[-1,9,39,],0xFFFFFF,[3092,3093,3094,3124,3125,3126],[3093,3094,3095,3125,3126,3127],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-5,19,19],[-7,9,19],[-1,9,39,],0xFFFFFF,[3093,3094,3095,3125,3126,3127],[3095,3096,3097,3127,3128,3129],[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128]],
[[-1,9,39],[-7,9,19],[-3,-1,39,],0xFFFFFF,[1157,1159,1160,1169,1178,1179,3094,3095,3096,3126,3127,3128],[3095,3096,3097,3127,3128,3129],[3096,3097,3098,3128,3129,3130]],
[[-7,9,19],[-8,-1,20],[-3,-1,39,],0xFFFFFF,[3095,3096,3097,3127,3128,3129],[3097,3098,3099,3129,3130,3131],[3096,3097,3098,3128,3129,3130]],
[[-3,-1,39],[-8,-1,20],[-4,-11,40,],0xFFFFFF,[3096,3097,3098,3128,3129,3130],[3097,3098,3099,3129,3130,3131],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-8,-1,20],[-9,-11,20],[-4,-11,40,],0xFFFFFF,[3097,3098,3099,3129,3130,3131],[3099,3100,3101,3131,3132,3133],[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132]],
[[-4,-11,40],[-9,-11,20],[-5,-21,40,],0xFFFFFF,[1162,1163,1164,1171,1172,1173,3098,3099,3100,3130,3131,3132],[3099,3100,3101,3131,3132,3133],[3100,3101,3102,3132,3133,3134]],
[[-9,-11,20],[-10,-21,20],[-5,-21,40,],0xFFFFFF,[3099,3100,3101,3131,3132,3133],[3101,3102,3103,3133,3134,3135],[3100,3101,3102,3132,3133,3134]],
[[-5,-21,40],[-10,-21,20],[-5,-31,40,],0xFFFFFF,[3100,3101,3102,3132,3133,3134],[3101,3102,3103,3133,3134,3135],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201]],
[[-10,-21,20],[-10,-31,20],[-5,-31,40,],0xFFFFFF,[3101,3102,3103,3133,3134,3135],[3103,3104,3105,3135,3136,3137],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201]],
[[-5,-31,40],[-10,-31,20],[-5,-41,40,],0xFFFFFF,[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3103,3104,3105,3135,3136,3137],[3104,3105,3106,3136,3137,3138]],
[[-10,-31,20],[-10,-41,20],[-5,-41,40,],0xFFFFFF,[3103,3104,3105,3135,3136,3137],[3105,3106,3107,3137,3138,3139],[3104,3105,3106,3136,3137,3138]],
[[-5,-41,40],[-10,-41,20],[-4,-51,40,],0xFFFFFF,[3104,3105,3106,3136,3137,3138],[3105,3106,3107,3137,3138,3139],[3106,3107,3108,3138,3139,3140]],
[[-10,-41,20],[-10,-51,20],[-4,-51,40,],0xFFFFFF,[3105,3106,3107,3137,3138,3139],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[3106,3107,3108,3138,3139,3140]],
[[-4,-51,40],[-10,-51,20],[-3,-61,39,],0xFFFFFF,[3106,3107,3108,3138,3139,3140],[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[3108,3109,3110,3140,3141,3142]],
[[-10,-51,20],[-8,-61,20],[-3,-61,39,],0xFFFFFF,[1182,1183,1184,1193,1194,1195,3107,3108,3109,3139,3140,3141],[3109,3110,3111,3141,3142,3143],[3108,3109,3110,3140,3141,3142]],
[[-3,-61,39],[-8,-61,20],[-2,-71,39,],0xFFFFFF,[3108,3109,3110,3140,3141,3142],[3109,3110,3111,3141,3142,3143],[3110,3111,3112,3142,3143,3144]],
[[-8,-61,20],[-7,-71,19],[-2,-71,39,],0xFFFFFF,[3109,3110,3111,3141,3142,3143],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[3110,3111,3112,3142,3143,3144]],
[[-2,-71,39],[-7,-71,19],[0,-81,38,],0xFFFFFF,[3110,3111,3112,3142,3143,3144],[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[-7,-71,19],[-4,-81,19],[0,-81,38,],0xFFFFFF,[1186,1187,1188,1197,1198,1199,3111,3112,3113,3143,3144,3145],[3113,3114,3115,3145,3146,3147],[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146]],
[[0,-81,38],[-4,-81,19],[3,-91,37,],0xFFFFFF,[1187,1188,1189,1198,1199,1200,3112,3113,3114,3144,3145,3146],[3113,3114,3115,3145,3146,3147],[3114,3115,3146,3147]],
[[-4,-81,19],[-1,-91,18],[3,-91,37,],0xFFFFFF,[3113,3114,3115,3145,3146,3147],[3115,3147],[3114,3115,3146,3147]],
[[42,60,38],[36,60,25],[25,55,46,],0xFFFFFF,[3148,3180],[3148,3149,3180,3181],[3148,3149,3150,3180,3181,3182]],
[[36,60,25],[18,55,31],[25,55,46,],0xFFFFFF,[3148,3149,3180,3181],[3149,3150,3151,3181,3182,3183],[3148,3149,3150,3180,3181,3182]],
[[25,55,46],[18,55,31],[18,49,50,],0xFFFFFF,[3148,3149,3150,3180,3181,3182],[3149,3150,3151,3181,3182,3183],[3150,3151,3152,3182,3183,3184]],
[[18,55,31],[10,49,34],[18,49,50,],0xFFFFFF,[3149,3150,3151,3181,3182,3183],[3151,3152,3153,3183,3184,3185],[3150,3151,3152,3182,3183,3184]],
[[18,49,50],[10,49,34],[12,39,53,],0xFFFFFF,[3150,3151,3152,3182,3183,3184],[3151,3152,3153,3183,3184,3185],[3152,3153,3154,3184,3185,3186]],
[[10,49,34],[4,39,36],[12,39,53,],0xFFFFFF,[3151,3152,3153,3183,3184,3185],[3153,3154,3155,3185,3186,3187],[3152,3153,3154,3184,3185,3186]],
[[12,39,53],[4,39,36],[10,29,55,],0xFFFFFF,[3152,3153,3154,3184,3185,3186],[3153,3154,3155,3185,3186,3187],[3154,3155,3156,3186,3187,3188]],
[[4,39,36],[1,29,37],[10,29,55,],0xFFFFFF,[3153,3154,3155,3185,3186,3187],[3155,3156,3157,3187,3188,3189],[3154,3155,3156,3186,3187,3188]],
[[10,29,55],[1,29,37],[8,19,56,],0xFFFFFF,[3154,3155,3156,3186,3187,3188],[3155,3156,3157,3187,3188,3189],[3156,3157,3158,3188,3189,3190]],
[[1,29,37],[0,19,38],[8,19,56,],0xFFFFFF,[3155,3156,3157,3187,3188,3189],[3157,3158,3159,3189,3190,3191],[3156,3157,3158,3188,3189,3190]],
[[8,19,56],[0,19,38],[6,9,57,],0xFFFFFF,[3156,3157,3158,3188,3189,3190],[3157,3158,3159,3189,3190,3191],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[0,19,38],[-1,9,39],[6,9,57,],0xFFFFFF,[3157,3158,3159,3189,3190,3191],[3159,3160,3161,3191,3192,3193],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[6,9,57],[-1,9,39],[5,-1,58,],0xFFFFFF,[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192],[3159,3160,3161,3191,3192,3193],[3160,3161,3162,3192,3193,3194]],
[[-1,9,39],[-3,-1,39],[5,-1,58,],0xFFFFFF,[3159,3160,3161,3191,3192,3193],[3161,3162,3163,3193,3194,3195],[3160,3161,3162,3192,3193,3194]],
[[5,-1,58],[-3,-1,39],[4,-11,58,],0xFFFFFF,[3160,3161,3162,3192,3193,3194],[3161,3162,3163,3193,3194,3195],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[-3,-1,39],[-4,-11,40],[4,-11,58,],0xFFFFFF,[3161,3162,3163,3193,3194,3195],[3163,3164,3165,3195,3196,3197],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[4,-11,58],[-4,-11,40],[3,-21,59,],0xFFFFFF,[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196],[3163,3164,3165,3195,3196,3197],[3164,3165,3166,3196,3197,3198]],
[[-4,-11,40],[-5,-21,40],[3,-21,59,],0xFFFFFF,[3163,3164,3165,3195,3196,3197],[3165,3166,3167,3197,3198,3199],[3164,3165,3166,3196,3197,3198]],
[[3,-21,59],[-5,-21,40],[3,-31,59,],0xFFFFFF,[3164,3165,3166,3196,3197,3198],[3165,3166,3167,3197,3198,3199],[3166,3167,3168,3198,3199,3200]],
[[-5,-21,40],[-5,-31,40],[3,-31,59,],0xFFFFFF,[3165,3166,3167,3197,3198,3199],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3166,3167,3168,3198,3199,3200]],
[[3,-31,59],[-5,-31,40],[3,-41,59,],0xFFFFFF,[3166,3167,3168,3198,3199,3200],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3168,3169,3170,3200,3201,3202]],
[[-5,-31,40],[-5,-41,40],[3,-41,59,],0xFFFFFF,[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3169,3170,3171,3201,3202,3203],[3168,3169,3170,3200,3201,3202]],
[[3,-41,59],[-5,-41,40],[3,-51,58,],0xFFFFFF,[3168,3169,3170,3200,3201,3202],[3169,3170,3171,3201,3202,3203],[3170,3171,3172,3202,3203,3204]],
[[-5,-41,40],[-4,-51,40],[3,-51,58,],0xFFFFFF,[3169,3170,3171,3201,3202,3203],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[3170,3171,3172,3202,3203,3204]],
[[3,-51,58],[-4,-51,40],[4,-61,58,],0xFFFFFF,[3170,3171,3172,3202,3203,3204],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[3172,3173,3174,3204,3205,3206]],
[[-4,-51,40],[-3,-61,39],[4,-61,58,],0xFFFFFF,[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[3173,3174,3175,3205,3206,3207],[3172,3173,3174,3204,3205,3206]],
[[4,-61,58],[-3,-61,39],[6,-71,57,],0xFFFFFF,[3172,3173,3174,3204,3205,3206],[3173,3174,3175,3205,3206,3207],[3174,3175,3176,3206,3207,3208]],
[[-3,-61,39],[-2,-71,39],[6,-71,57,],0xFFFFFF,[3173,3174,3175,3205,3206,3207],[3175,3176,3177,3207,3208,3209],[3174,3175,3176,3206,3207,3208]],
[[6,-71,57],[-2,-71,39],[8,-81,56,],0xFFFFFF,[3174,3175,3176,3206,3207,3208],[3175,3176,3177,3207,3208,3209],[3176,3177,3178,3208,3209,3210]],
[[-2,-71,39],[0,-81,38],[8,-81,56,],0xFFFFFF,[3175,3176,3177,3207,3208,3209],[3177,3178,3179,3209,3210,3211],[3176,3177,3178,3208,3209,3210]],
[[8,-81,56],[0,-81,38],[11,-91,54,],0xFFFFFF,[3176,3177,3178,3208,3209,3210],[3177,3178,3179,3209,3210,3211],[3178,3179,3210,3211]],
[[0,-81,38],[3,-91,37],[11,-91,54,],0xFFFFFF,[3177,3178,3179,3209,3210,3211],[3179,3211],[3178,3179,3210,3211]],
[[42,60,38],[36,60,25],[25,55,46,],0xFFFFFF,[3148,3180],[3148,3149,3180,3181],[3148,3149,3150,3180,3181,3182]],
[[36,60,25],[18,55,31],[25,55,46,],0xFFFFFF,[3148,3149,3180,3181],[3149,3150,3151,3181,3182,3183],[3148,3149,3150,3180,3181,3182]],
[[25,55,46],[18,55,31],[18,49,50,],0xFFFFFF,[3148,3149,3150,3180,3181,3182],[3149,3150,3151,3181,3182,3183],[3150,3151,3152,3182,3183,3184]],
[[18,55,31],[10,49,34],[18,49,50,],0xFFFFFF,[3149,3150,3151,3181,3182,3183],[3151,3152,3153,3183,3184,3185],[3150,3151,3152,3182,3183,3184]],
[[18,49,50],[10,49,34],[12,39,53,],0xFFFFFF,[3150,3151,3152,3182,3183,3184],[3151,3152,3153,3183,3184,3185],[3152,3153,3154,3184,3185,3186]],
[[10,49,34],[4,39,36],[12,39,53,],0xFFFFFF,[3151,3152,3153,3183,3184,3185],[3153,3154,3155,3185,3186,3187],[3152,3153,3154,3184,3185,3186]],
[[12,39,53],[4,39,36],[10,29,55,],0xFFFFFF,[3152,3153,3154,3184,3185,3186],[3153,3154,3155,3185,3186,3187],[3154,3155,3156,3186,3187,3188]],
[[4,39,36],[1,29,37],[10,29,55,],0xFFFFFF,[3153,3154,3155,3185,3186,3187],[3155,3156,3157,3187,3188,3189],[3154,3155,3156,3186,3187,3188]],
[[10,29,55],[1,29,37],[8,19,56,],0xFFFFFF,[3154,3155,3156,3186,3187,3188],[3155,3156,3157,3187,3188,3189],[3156,3157,3158,3188,3189,3190]],
[[1,29,37],[0,19,38],[8,19,56,],0xFFFFFF,[3155,3156,3157,3187,3188,3189],[3157,3158,3159,3189,3190,3191],[3156,3157,3158,3188,3189,3190]],
[[8,19,56],[0,19,38],[6,9,57,],0xFFFFFF,[3156,3157,3158,3188,3189,3190],[3157,3158,3159,3189,3190,3191],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[0,19,38],[-1,9,39],[6,9,57,],0xFFFFFF,[3157,3158,3159,3189,3190,3191],[3159,3160,3161,3191,3192,3193],[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192]],
[[6,9,57],[-1,9,39],[5,-1,58,],0xFFFFFF,[1221,1223,1224,1233,1242,1243,3158,3159,3160,3190,3191,3192],[3159,3160,3161,3191,3192,3193],[3160,3161,3162,3192,3193,3194]],
[[-1,9,39],[-3,-1,39],[5,-1,58,],0xFFFFFF,[3159,3160,3161,3191,3192,3193],[3161,3162,3163,3193,3194,3195],[3160,3161,3162,3192,3193,3194]],
[[5,-1,58],[-3,-1,39],[4,-11,58,],0xFFFFFF,[3160,3161,3162,3192,3193,3194],[3161,3162,3163,3193,3194,3195],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[-3,-1,39],[-4,-11,40],[4,-11,58,],0xFFFFFF,[3161,3162,3163,3193,3194,3195],[3163,3164,3165,3195,3196,3197],[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196]],
[[4,-11,58],[-4,-11,40],[3,-21,59,],0xFFFFFF,[1226,1227,1228,1235,1236,1237,3162,3163,3164,3194,3195,3196],[3163,3164,3165,3195,3196,3197],[3164,3165,3166,3196,3197,3198]],
[[-4,-11,40],[-5,-21,40],[3,-21,59,],0xFFFFFF,[3163,3164,3165,3195,3196,3197],[3165,3166,3167,3197,3198,3199],[3164,3165,3166,3196,3197,3198]],
[[3,-21,59],[-5,-21,40],[3,-31,59,],0xFFFFFF,[3164,3165,3166,3196,3197,3198],[3165,3166,3167,3197,3198,3199],[3166,3167,3168,3198,3199,3200]],
[[-5,-21,40],[-5,-31,40],[3,-31,59,],0xFFFFFF,[3165,3166,3167,3197,3198,3199],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3166,3167,3168,3198,3199,3200]],
[[3,-31,59],[-5,-31,40],[3,-41,59,],0xFFFFFF,[3166,3167,3168,3198,3199,3200],[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3168,3169,3170,3200,3201,3202]],
[[-5,-31,40],[-5,-41,40],[3,-41,59,],0xFFFFFF,[3102,3103,3104,3134,3135,3136,3167,3168,3169,3199,3200,3201],[3169,3170,3171,3201,3202,3203],[3168,3169,3170,3200,3201,3202]],
[[3,-41,59],[-5,-41,40],[3,-51,58,],0xFFFFFF,[3168,3169,3170,3200,3201,3202],[3169,3170,3171,3201,3202,3203],[3170,3171,3172,3202,3203,3204]],
[[-5,-41,40],[-4,-51,40],[3,-51,58,],0xFFFFFF,[3169,3170,3171,3201,3202,3203],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[3170,3171,3172,3202,3203,3204]],
[[3,-51,58],[-4,-51,40],[4,-61,58,],0xFFFFFF,[3170,3171,3172,3202,3203,3204],[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[3172,3173,3174,3204,3205,3206]],
[[-4,-51,40],[-3,-61,39],[4,-61,58,],0xFFFFFF,[1246,1247,1248,1257,1258,1259,3171,3172,3173,3203,3204,3205],[3173,3174,3175,3205,3206,3207],[3172,3173,3174,3204,3205,3206]],
[[4,-61,58],[-3,-61,39],[6,-71,57,],0xFFFFFF,[3172,3173,3174,3204,3205,3206],[3173,3174,3175,3205,3206,3207],[3174,3175,3176,3206,3207,3208]],
[[-3,-61,39],[-2,-71,39],[6,-71,57,],0xFFFFFF,[3173,3174,3175,3205,3206,3207],[3175,3176,3177,3207,3208,3209],[3174,3175,3176,3206,3207,3208]],
[[6,-71,57],[-2,-71,39],[8,-81,56,],0xFFFFFF,[3174,3175,3176,3206,3207,3208],[3175,3176,3177,3207,3208,3209],[3176,3177,3178,3208,3209,3210]],
[[-2,-71,39],[0,-81,38],[8,-81,56,],0xFFFFFF,[3175,3176,3177,3207,3208,3209],[3177,3178,3179,3209,3210,3211],[3176,3177,3178,3208,3209,3210]],
[[8,-81,56],[0,-81,38],[11,-91,54,],0xFFFFFF,[3176,3177,3178,3208,3209,3210],[3177,3178,3179,3209,3210,3211],[3178,3179,3210,3211]],
[[0,-81,38],[3,-91,37],[11,-91,54,],0xFFFFFF,[3177,3178,3179,3209,3210,3211],[3179,3211],[3178,3179,3210,3211]],
[[49,60,49],[41,60,37],[34,55,59,],0xFFFFFF,[1266,1269,3212,3244],[3212,3213,3244,3245],[3212,3213,3214,3244,3245,3246]],
[[41,60,37],[25,55,46],[34,55,59,],0xFFFFFF,[3212,3213,3244,3245],[3213,3214,3215,3245,3246,3247],[3212,3213,3214,3244,3245,3246]],
[[34,55,59],[25,55,46],[28,49,65,],0xFFFFFF,[3212,3213,3214,3244,3245,3246],[3213,3214,3215,3245,3246,3247],[3214,3215,3216,3246,3247,3248]],
[[25,55,46],[18,49,50],[28,49,65,],0xFFFFFF,[3213,3214,3215,3245,3246,3247],[3215,3216,3217,3247,3248,3249],[3214,3215,3216,3246,3247,3248]],
[[28,49,65],[18,49,50],[23,39,69,],0xFFFFFF,[3214,3215,3216,3246,3247,3248],[3215,3216,3217,3247,3248,3249],[3216,3217,3218,3248,3249,3250]],
[[18,49,50],[12,39,53],[23,39,69,],0xFFFFFF,[3215,3216,3217,3247,3248,3249],[3217,3218,3219,3249,3250,3251],[3216,3217,3218,3248,3249,3250]],
[[23,39,69],[12,39,53],[21,29,71,],0xFFFFFF,[3216,3217,3218,3248,3249,3250],[3217,3218,3219,3249,3250,3251],[3218,3219,3220,3250,3251,3252]],
[[12,39,53],[10,29,55],[21,29,71,],0xFFFFFF,[3217,3218,3219,3249,3250,3251],[3219,3220,3221,3251,3252,3253],[3218,3219,3220,3250,3251,3252]],
[[21,29,71],[10,29,55],[19,19,72,],0xFFFFFF,[3218,3219,3220,3250,3251,3252],[3219,3220,3221,3251,3252,3253],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319]],
[[10,29,55],[8,19,56],[19,19,72,],0xFFFFFF,[3219,3220,3221,3251,3252,3253],[3221,3222,3223,3253,3254,3255],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319]],
[[19,19,72],[8,19,56],[17,9,73,],0xFFFFFF,[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[3221,3222,3223,3253,3254,3255],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[8,19,56],[6,9,57],[17,9,73,],0xFFFFFF,[3221,3222,3223,3253,3254,3255],[3223,3224,3225,3255,3256,3257],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[17,9,73],[6,9,57],[16,-1,74,],0xFFFFFF,[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256],[3223,3224,3225,3255,3256,3257],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258]],
[[6,9,57],[5,-1,58],[16,-1,74,],0xFFFFFF,[3223,3224,3225,3255,3256,3257],[3225,3226,3227,3257,3258,3259],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258]],
[[16,-1,74],[5,-1,58],[16,-11,75,],0xFFFFFF,[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[3225,3226,3227,3257,3258,3259],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[5,-1,58],[4,-11,58],[16,-11,75,],0xFFFFFF,[3225,3226,3227,3257,3258,3259],[3227,3228,3229,3259,3260,3261],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[16,-11,75],[4,-11,58],[15,-21,75,],0xFFFFFF,[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260],[3227,3228,3229,3259,3260,3261],[3228,3229,3230,3260,3261,3262]],
[[4,-11,58],[3,-21,59],[15,-21,75,],0xFFFFFF,[3227,3228,3229,3259,3260,3261],[3229,3230,3231,3261,3262,3263],[3228,3229,3230,3260,3261,3262]],
[[15,-21,75],[3,-21,59],[15,-31,76,],0xFFFFFF,[3228,3229,3230,3260,3261,3262],[3229,3230,3231,3261,3262,3263],[3230,3231,3232,3262,3263,3264]],
[[3,-21,59],[3,-31,59],[15,-31,76,],0xFFFFFF,[3229,3230,3231,3261,3262,3263],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[3230,3231,3232,3262,3263,3264]],
[[15,-31,76],[3,-31,59],[15,-41,76,],0xFFFFFF,[3230,3231,3232,3262,3263,3264],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[3232,3233,3234,3264,3265,3266]],
[[3,-31,59],[3,-41,59],[15,-41,76,],0xFFFFFF,[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[3233,3234,3235,3265,3266,3267],[3232,3233,3234,3264,3265,3266]],
[[15,-41,76],[3,-41,59],[15,-51,75,],0xFFFFFF,[3232,3233,3234,3264,3265,3266],[3233,3234,3235,3265,3266,3267],[3234,3235,3236,3266,3267,3268]],
[[3,-41,59],[3,-51,58],[15,-51,75,],0xFFFFFF,[3233,3234,3235,3265,3266,3267],[3235,3236,3237,3267,3268,3269],[3234,3235,3236,3266,3267,3268]],
[[15,-51,75],[3,-51,58],[16,-61,75,],0xFFFFFF,[3234,3235,3236,3266,3267,3268],[3235,3236,3237,3267,3268,3269],[3236,3237,3238,3268,3269,3270]],
[[3,-51,58],[4,-61,58],[16,-61,75,],0xFFFFFF,[3235,3236,3237,3267,3268,3269],[3237,3238,3239,3269,3270,3271],[3236,3237,3238,3268,3269,3270]],
[[16,-61,75],[4,-61,58],[17,-71,73,],0xFFFFFF,[3236,3237,3238,3268,3269,3270],[3237,3238,3239,3269,3270,3271],[3238,3239,3240,3270,3271,3272]],
[[4,-61,58],[6,-71,57],[17,-71,73,],0xFFFFFF,[3237,3238,3239,3269,3270,3271],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[3238,3239,3240,3270,3271,3272]],
[[17,-71,73],[6,-71,57],[19,-81,72,],0xFFFFFF,[3238,3239,3240,3270,3271,3272],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[6,-71,57],[8,-81,56],[19,-81,72,],0xFFFFFF,[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[3241,3242,3243,3273,3274,3275],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[19,-81,72],[8,-81,56],[22,-91,70,],0xFFFFFF,[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370],[3241,3242,3243,3273,3274,3275],[3242,3243,3274,3275]],
[[8,-81,56],[11,-91,54],[22,-91,70,],0xFFFFFF,[3241,3242,3243,3273,3274,3275],[3243,3275],[3242,3243,3274,3275]],
[[49,60,49],[41,60,37],[34,55,59,],0xFFFFFF,[1266,1269,3212,3244],[3212,3213,3244,3245],[3212,3213,3214,3244,3245,3246]],
[[41,60,37],[25,55,46],[34,55,59,],0xFFFFFF,[3212,3213,3244,3245],[3213,3214,3215,3245,3246,3247],[3212,3213,3214,3244,3245,3246]],
[[34,55,59],[25,55,46],[28,49,65,],0xFFFFFF,[3212,3213,3214,3244,3245,3246],[3213,3214,3215,3245,3246,3247],[3214,3215,3216,3246,3247,3248]],
[[25,55,46],[18,49,50],[28,49,65,],0xFFFFFF,[3213,3214,3215,3245,3246,3247],[3215,3216,3217,3247,3248,3249],[3214,3215,3216,3246,3247,3248]],
[[28,49,65],[18,49,50],[23,39,69,],0xFFFFFF,[3214,3215,3216,3246,3247,3248],[3215,3216,3217,3247,3248,3249],[3216,3217,3218,3248,3249,3250]],
[[18,49,50],[12,39,53],[23,39,69,],0xFFFFFF,[3215,3216,3217,3247,3248,3249],[3217,3218,3219,3249,3250,3251],[3216,3217,3218,3248,3249,3250]],
[[23,39,69],[12,39,53],[21,29,71,],0xFFFFFF,[3216,3217,3218,3248,3249,3250],[3217,3218,3219,3249,3250,3251],[3218,3219,3220,3250,3251,3252]],
[[12,39,53],[10,29,55],[21,29,71,],0xFFFFFF,[3217,3218,3219,3249,3250,3251],[3219,3220,3221,3251,3252,3253],[3218,3219,3220,3250,3251,3252]],
[[21,29,71],[10,29,55],[19,19,72,],0xFFFFFF,[3218,3219,3220,3250,3251,3252],[3219,3220,3221,3251,3252,3253],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319]],
[[10,29,55],[8,19,56],[19,19,72,],0xFFFFFF,[3219,3220,3221,3251,3252,3253],[3221,3222,3223,3253,3254,3255],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319]],
[[19,19,72],[8,19,56],[17,9,73,],0xFFFFFF,[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[3221,3222,3223,3253,3254,3255],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[8,19,56],[6,9,57],[17,9,73,],0xFFFFFF,[3221,3222,3223,3253,3254,3255],[3223,3224,3225,3255,3256,3257],[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256]],
[[17,9,73],[6,9,57],[16,-1,74,],0xFFFFFF,[1285,1287,1288,1297,1306,1307,3222,3223,3224,3254,3255,3256],[3223,3224,3225,3255,3256,3257],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258]],
[[6,9,57],[5,-1,58],[16,-1,74,],0xFFFFFF,[3223,3224,3225,3255,3256,3257],[3225,3226,3227,3257,3258,3259],[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258]],
[[16,-1,74],[5,-1,58],[16,-11,75,],0xFFFFFF,[1353,1354,1355,1362,1363,1364,3224,3225,3226,3256,3257,3258],[3225,3226,3227,3257,3258,3259],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[5,-1,58],[4,-11,58],[16,-11,75,],0xFFFFFF,[3225,3226,3227,3257,3258,3259],[3227,3228,3229,3259,3260,3261],[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260]],
[[16,-11,75],[4,-11,58],[15,-21,75,],0xFFFFFF,[1290,1291,1292,1299,1300,1301,3226,3227,3228,3258,3259,3260],[3227,3228,3229,3259,3260,3261],[3228,3229,3230,3260,3261,3262]],
[[4,-11,58],[3,-21,59],[15,-21,75,],0xFFFFFF,[3227,3228,3229,3259,3260,3261],[3229,3230,3231,3261,3262,3263],[3228,3229,3230,3260,3261,3262]],
[[15,-21,75],[3,-21,59],[15,-31,76,],0xFFFFFF,[3228,3229,3230,3260,3261,3262],[3229,3230,3231,3261,3262,3263],[3230,3231,3232,3262,3263,3264]],
[[3,-21,59],[3,-31,59],[15,-31,76,],0xFFFFFF,[3229,3230,3231,3261,3262,3263],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[3230,3231,3232,3262,3263,3264]],
[[15,-31,76],[3,-31,59],[15,-41,76,],0xFFFFFF,[3230,3231,3232,3262,3263,3264],[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[3232,3233,3234,3264,3265,3266]],
[[3,-31,59],[3,-41,59],[15,-41,76,],0xFFFFFF,[1230,1231,1232,1239,1240,1241,3231,3232,3233,3263,3264,3265],[3233,3234,3235,3265,3266,3267],[3232,3233,3234,3264,3265,3266]],
[[15,-41,76],[3,-41,59],[15,-51,75,],0xFFFFFF,[3232,3233,3234,3264,3265,3266],[3233,3234,3235,3265,3266,3267],[3234,3235,3236,3266,3267,3268]],
[[3,-41,59],[3,-51,58],[15,-51,75,],0xFFFFFF,[3233,3234,3235,3265,3266,3267],[3235,3236,3237,3267,3268,3269],[3234,3235,3236,3266,3267,3268]],
[[15,-51,75],[3,-51,58],[16,-61,75,],0xFFFFFF,[3234,3235,3236,3266,3267,3268],[3235,3236,3237,3267,3268,3269],[3236,3237,3238,3268,3269,3270]],
[[3,-51,58],[4,-61,58],[16,-61,75,],0xFFFFFF,[3235,3236,3237,3267,3268,3269],[3237,3238,3239,3269,3270,3271],[3236,3237,3238,3268,3269,3270]],
[[16,-61,75],[4,-61,58],[17,-71,73,],0xFFFFFF,[3236,3237,3238,3268,3269,3270],[3237,3238,3239,3269,3270,3271],[3238,3239,3240,3270,3271,3272]],
[[4,-61,58],[6,-71,57],[17,-71,73,],0xFFFFFF,[3237,3238,3239,3269,3270,3271],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[3238,3239,3240,3270,3271,3272]],
[[17,-71,73],[6,-71,57],[19,-81,72,],0xFFFFFF,[3238,3239,3240,3270,3271,3272],[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[6,-71,57],[8,-81,56],[19,-81,72,],0xFFFFFF,[1249,1250,1251,1260,1261,1262,1314,1315,1316,1325,1326,1327,3239,3240,3241,3271,3272,3273],[3241,3242,3243,3273,3274,3275],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370]],
[[19,-81,72],[8,-81,56],[22,-91,70,],0xFFFFFF,[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370],[3241,3242,3243,3273,3274,3275],[3242,3243,3274,3275]],
[[8,-81,56],[11,-91,54],[22,-91,70,],0xFFFFFF,[3241,3242,3243,3273,3274,3275],[3243,3275],[3242,3243,3274,3275]],
[[59,60,58],[48,60,47],[46,55,71,],0xFFFFFF,[3276,3308],[3276,3277,3308,3309],[3276,3277,3278,3308,3309,3310]],
[[48,60,47],[34,55,59],[46,55,71,],0xFFFFFF,[3276,3277,3308,3309],[3277,3278,3279,3309,3310,3311],[3276,3277,3278,3308,3309,3310]],
[[46,55,71],[34,55,59],[40,49,77,],0xFFFFFF,[3276,3277,3278,3308,3309,3310],[3277,3278,3279,3309,3310,3311],[3278,3279,3280,3310,3311,3312]],
[[34,55,59],[28,49,65],[40,49,77,],0xFFFFFF,[3277,3278,3279,3309,3310,3311],[3279,3280,3281,3311,3312,3313],[3278,3279,3280,3310,3311,3312]],
[[40,49,77],[28,49,65],[36,39,82,],0xFFFFFF,[3278,3279,3280,3310,3311,3312],[3279,3280,3281,3311,3312,3313],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[28,49,65],[23,39,69],[36,39,82,],0xFFFFFF,[3279,3280,3281,3311,3312,3313],[3281,3282,3283,3313,3314,3315],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[36,39,82],[23,39,69],[34,29,84,],0xFFFFFF,[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314],[3281,3282,3283,3313,3314,3315],[3282,3283,3284,3314,3315,3316]],
[[23,39,69],[21,29,71],[34,29,84,],0xFFFFFF,[3281,3282,3283,3313,3314,3315],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[3282,3283,3284,3314,3315,3316]],
[[34,29,84],[21,29,71],[33,19,86,],0xFFFFFF,[3282,3283,3284,3314,3315,3316],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318]],
[[21,29,71],[19,19,72],[33,19,86,],0xFFFFFF,[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318]],
[[33,19,86],[19,19,72],[32,9,88,],0xFFFFFF,[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[19,19,72],[17,9,73],[32,9,88,],0xFFFFFF,[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[32,9,88],[17,9,73],[31,-1,89,],0xFFFFFF,[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[3288,3289,3290,3320,3321,3322]],
[[17,9,73],[16,-1,74],[31,-1,89,],0xFFFFFF,[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[3289,3290,3291,3321,3322,3323],[3288,3289,3290,3320,3321,3322]],
[[31,-1,89],[16,-1,74],[30,-11,89,],0xFFFFFF,[3288,3289,3290,3320,3321,3322],[3289,3290,3291,3321,3322,3323],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[16,-1,74],[16,-11,75],[30,-11,89,],0xFFFFFF,[3289,3290,3291,3321,3322,3323],[3291,3292,3293,3323,3324,3325],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[30,-11,89],[16,-11,75],[30,-21,90,],0xFFFFFF,[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324],[3291,3292,3293,3323,3324,3325],[3292,3293,3294,3324,3325,3326]],
[[16,-11,75],[15,-21,75],[30,-21,90,],0xFFFFFF,[3291,3292,3293,3323,3324,3325],[3293,3294,3295,3325,3326,3327],[3292,3293,3294,3324,3325,3326]],
[[30,-21,90],[15,-21,75],[29,-31,90,],0xFFFFFF,[3292,3293,3294,3324,3325,3326],[3293,3294,3295,3325,3326,3327],[3294,3295,3296,3326,3327,3328]],
[[15,-21,75],[15,-31,76],[29,-31,90,],0xFFFFFF,[3293,3294,3295,3325,3326,3327],[3295,3296,3297,3327,3328,3329],[3294,3295,3296,3326,3327,3328]],
[[29,-31,90],[15,-31,76],[29,-41,90,],0xFFFFFF,[3294,3295,3296,3326,3327,3328],[3295,3296,3297,3327,3328,3329],[3296,3297,3298,3328,3329,3330]],
[[15,-31,76],[15,-41,76],[29,-41,90,],0xFFFFFF,[3295,3296,3297,3327,3328,3329],[3297,3298,3299,3329,3330,3331],[3296,3297,3298,3328,3329,3330]],
[[29,-41,90],[15,-41,76],[30,-51,90,],0xFFFFFF,[3296,3297,3298,3328,3329,3330],[3297,3298,3299,3329,3330,3331],[3298,3299,3300,3330,3331,3332]],
[[15,-41,76],[15,-51,75],[30,-51,90,],0xFFFFFF,[3297,3298,3299,3329,3330,3331],[3299,3300,3301,3331,3332,3333],[3298,3299,3300,3330,3331,3332]],
[[30,-51,90],[15,-51,75],[30,-61,89,],0xFFFFFF,[3298,3299,3300,3330,3331,3332],[3299,3300,3301,3331,3332,3333],[3300,3301,3302,3332,3333,3334]],
[[15,-51,75],[16,-61,75],[30,-61,89,],0xFFFFFF,[3299,3300,3301,3331,3332,3333],[3301,3302,3303,3333,3334,3335],[3300,3301,3302,3332,3333,3334]],
[[30,-61,89],[16,-61,75],[32,-71,88,],0xFFFFFF,[3300,3301,3302,3332,3333,3334],[3301,3302,3303,3333,3334,3335],[3302,3303,3304,3334,3335,3336]],
[[16,-61,75],[17,-71,73],[32,-71,88,],0xFFFFFF,[3301,3302,3303,3333,3334,3335],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[3302,3303,3304,3334,3335,3336]],
[[32,-71,88],[17,-71,73],[33,-81,86,],0xFFFFFF,[3302,3303,3304,3334,3335,3336],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[17,-71,73],[19,-81,72],[33,-81,86,],0xFFFFFF,[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[3305,3306,3307,3337,3338,3339],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[33,-81,86],[19,-81,72],[35,-91,83,],0xFFFFFF,[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338],[3305,3306,3307,3337,3338,3339],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[19,-81,72],[22,-91,70],[35,-91,83,],0xFFFFFF,[3305,3306,3307,3337,3338,3339],[1317,1318,1328,1329,3307,3339],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[59,60,58],[48,60,47],[46,55,71,],0xFFFFFF,[3276,3308],[3276,3277,3308,3309],[3276,3277,3278,3308,3309,3310]],
[[48,60,47],[34,55,59],[46,55,71,],0xFFFFFF,[3276,3277,3308,3309],[3277,3278,3279,3309,3310,3311],[3276,3277,3278,3308,3309,3310]],
[[46,55,71],[34,55,59],[40,49,77,],0xFFFFFF,[3276,3277,3278,3308,3309,3310],[3277,3278,3279,3309,3310,3311],[3278,3279,3280,3310,3311,3312]],
[[34,55,59],[28,49,65],[40,49,77,],0xFFFFFF,[3277,3278,3279,3309,3310,3311],[3279,3280,3281,3311,3312,3313],[3278,3279,3280,3310,3311,3312]],
[[40,49,77],[28,49,65],[36,39,82,],0xFFFFFF,[3278,3279,3280,3310,3311,3312],[3279,3280,3281,3311,3312,3313],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[28,49,65],[23,39,69],[36,39,82,],0xFFFFFF,[3279,3280,3281,3311,3312,3313],[3281,3282,3283,3313,3314,3315],[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314]],
[[36,39,82],[23,39,69],[34,29,84,],0xFFFFFF,[1337,1338,1339,1343,1344,1345,3280,3281,3282,3312,3313,3314],[3281,3282,3283,3313,3314,3315],[3282,3283,3284,3314,3315,3316]],
[[23,39,69],[21,29,71],[34,29,84,],0xFFFFFF,[3281,3282,3283,3313,3314,3315],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[3282,3283,3284,3314,3315,3316]],
[[34,29,84],[21,29,71],[33,19,86,],0xFFFFFF,[3282,3283,3284,3314,3315,3316],[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318]],
[[21,29,71],[19,19,72],[33,19,86,],0xFFFFFF,[1340,1341,1346,1347,1348,1350,3283,3284,3285,3315,3316,3317],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318]],
[[33,19,86],[19,19,72],[32,9,88,],0xFFFFFF,[1412,1413,1414,1415,1434,1435,3284,3285,3286,3316,3317,3318],[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[19,19,72],[17,9,73],[32,9,88,],0xFFFFFF,[1348,1349,1350,1351,1370,1371,3220,3221,3222,3252,3253,3254,3285,3286,3287,3317,3318,3319],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320]],
[[32,9,88],[17,9,73],[31,-1,89,],0xFFFFFF,[1349,1351,1352,1361,1370,1371,3286,3287,3288,3318,3319,3320],[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[3288,3289,3290,3320,3321,3322]],
[[17,9,73],[16,-1,74],[31,-1,89,],0xFFFFFF,[1352,1353,1361,1362,1370,1371,3287,3288,3289,3319,3320,3321],[3289,3290,3291,3321,3322,3323],[3288,3289,3290,3320,3321,3322]],
[[31,-1,89],[16,-1,74],[30,-11,89,],0xFFFFFF,[3288,3289,3290,3320,3321,3322],[3289,3290,3291,3321,3322,3323],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[16,-1,74],[16,-11,75],[30,-11,89,],0xFFFFFF,[3289,3290,3291,3321,3322,3323],[3291,3292,3293,3323,3324,3325],[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324]],
[[30,-11,89],[16,-11,75],[30,-21,90,],0xFFFFFF,[1354,1355,1356,1363,1364,1365,3290,3291,3292,3322,3323,3324],[3291,3292,3293,3323,3324,3325],[3292,3293,3294,3324,3325,3326]],
[[16,-11,75],[15,-21,75],[30,-21,90,],0xFFFFFF,[3291,3292,3293,3323,3324,3325],[3293,3294,3295,3325,3326,3327],[3292,3293,3294,3324,3325,3326]],
[[30,-21,90],[15,-21,75],[29,-31,90,],0xFFFFFF,[3292,3293,3294,3324,3325,3326],[3293,3294,3295,3325,3326,3327],[3294,3295,3296,3326,3327,3328]],
[[15,-21,75],[15,-31,76],[29,-31,90,],0xFFFFFF,[3293,3294,3295,3325,3326,3327],[3295,3296,3297,3327,3328,3329],[3294,3295,3296,3326,3327,3328]],
[[29,-31,90],[15,-31,76],[29,-41,90,],0xFFFFFF,[3294,3295,3296,3326,3327,3328],[3295,3296,3297,3327,3328,3329],[3296,3297,3298,3328,3329,3330]],
[[15,-31,76],[15,-41,76],[29,-41,90,],0xFFFFFF,[3295,3296,3297,3327,3328,3329],[3297,3298,3299,3329,3330,3331],[3296,3297,3298,3328,3329,3330]],
[[29,-41,90],[15,-41,76],[30,-51,90,],0xFFFFFF,[3296,3297,3298,3328,3329,3330],[3297,3298,3299,3329,3330,3331],[3298,3299,3300,3330,3331,3332]],
[[15,-41,76],[15,-51,75],[30,-51,90,],0xFFFFFF,[3297,3298,3299,3329,3330,3331],[3299,3300,3301,3331,3332,3333],[3298,3299,3300,3330,3331,3332]],
[[30,-51,90],[15,-51,75],[30,-61,89,],0xFFFFFF,[3298,3299,3300,3330,3331,3332],[3299,3300,3301,3331,3332,3333],[3300,3301,3302,3332,3333,3334]],
[[15,-51,75],[16,-61,75],[30,-61,89,],0xFFFFFF,[3299,3300,3301,3331,3332,3333],[3301,3302,3303,3333,3334,3335],[3300,3301,3302,3332,3333,3334]],
[[30,-61,89],[16,-61,75],[32,-71,88,],0xFFFFFF,[3300,3301,3302,3332,3333,3334],[3301,3302,3303,3333,3334,3335],[3302,3303,3304,3334,3335,3336]],
[[16,-61,75],[17,-71,73],[32,-71,88,],0xFFFFFF,[3301,3302,3303,3333,3334,3335],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[3302,3303,3304,3334,3335,3336]],
[[32,-71,88],[17,-71,73],[33,-81,86,],0xFFFFFF,[3302,3303,3304,3334,3335,3336],[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[17,-71,73],[19,-81,72],[33,-81,86,],0xFFFFFF,[1378,1379,1380,1389,1390,1391,3303,3304,3305,3335,3336,3337],[3305,3306,3307,3337,3338,3339],[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338]],
[[33,-81,86],[19,-81,72],[35,-91,83,],0xFFFFFF,[1379,1380,1381,1390,1391,1392,3304,3305,3306,3336,3337,3338],[3305,3306,3307,3337,3338,3339],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[19,-81,72],[22,-91,70],[35,-91,83,],0xFFFFFF,[3305,3306,3307,3337,3338,3339],[1317,1318,1328,1329,3307,3339],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403]],
[[69,60,65],[58,60,57],[59,55,80,],0xFFFFFF,[1394,1397,3340,3372],[3340,3341,3372,3373],[3340,3341,3342,3372,3373,3374]],
[[58,60,57],[46,55,71],[59,55,80,],0xFFFFFF,[3340,3341,3372,3373],[3341,3342,3343,3373,3374,3375],[3340,3341,3342,3372,3373,3374]],
[[59,55,80],[46,55,71],[55,49,87,],0xFFFFFF,[3340,3341,3342,3372,3373,3374],[3341,3342,3343,3373,3374,3375],[3342,3343,3344,3374,3375,3376]],
[[46,55,71],[40,49,77],[55,49,87,],0xFFFFFF,[3341,3342,3343,3373,3374,3375],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[3342,3343,3344,3374,3375,3376]],
[[55,49,87],[40,49,77],[52,39,93,],0xFFFFFF,[3342,3343,3344,3374,3375,3376],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[3344,3345,3346,3376,3377,3378]],
[[40,49,77],[36,39,82],[52,39,93,],0xFFFFFF,[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[3344,3345,3346,3376,3377,3378]],
[[52,39,93],[36,39,82],[50,29,95,],0xFFFFFF,[3344,3345,3346,3376,3377,3378],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[3346,3347,3348,3378,3379,3380]],
[[36,39,82],[34,29,84],[50,29,95,],0xFFFFFF,[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[3347,3348,3349,3379,3380,3381],[3346,3347,3348,3378,3379,3380]],
[[50,29,95],[34,29,84],[49,19,97,],0xFFFFFF,[3346,3347,3348,3378,3379,3380],[3347,3348,3349,3379,3380,3381],[3348,3349,3350,3380,3381,3382]],
[[34,29,84],[33,19,86],[49,19,97,],0xFFFFFF,[3347,3348,3349,3379,3380,3381],[3349,3350,3351,3381,3382,3383],[3348,3349,3350,3380,3381,3382]],
[[49,19,97],[33,19,86],[48,9,99,],0xFFFFFF,[3348,3349,3350,3380,3381,3382],[3349,3350,3351,3381,3382,3383],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[33,19,86],[32,9,88],[48,9,99,],0xFFFFFF,[3349,3350,3351,3381,3382,3383],[3351,3352,3353,3383,3384,3385],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[48,9,99],[32,9,88],[47,-1,100,],0xFFFFFF,[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384],[3351,3352,3353,3383,3384,3385],[3352,3353,3354,3384,3385,3386]],
[[32,9,88],[31,-1,89],[47,-1,100,],0xFFFFFF,[3351,3352,3353,3383,3384,3385],[3353,3354,3355,3385,3386,3387],[3352,3353,3354,3384,3385,3386]],
[[47,-1,100],[31,-1,89],[47,-11,101,],0xFFFFFF,[3352,3353,3354,3384,3385,3386],[3353,3354,3355,3385,3386,3387],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[31,-1,89],[30,-11,89],[47,-11,101,],0xFFFFFF,[3353,3354,3355,3385,3386,3387],[3355,3356,3357,3387,3388,3389],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[47,-11,101],[30,-11,89],[46,-21,102,],0xFFFFFF,[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388],[3355,3356,3357,3387,3388,3389],[3356,3357,3358,3388,3389,3390]],
[[30,-11,89],[30,-21,90],[46,-21,102,],0xFFFFFF,[3355,3356,3357,3387,3388,3389],[3357,3358,3359,3389,3390,3391],[3356,3357,3358,3388,3389,3390]],
[[46,-21,102],[30,-21,90],[46,-31,102,],0xFFFFFF,[3356,3357,3358,3388,3389,3390],[3357,3358,3359,3389,3390,3391],[3358,3359,3360,3390,3391,3392]],
[[30,-21,90],[29,-31,90],[46,-31,102,],0xFFFFFF,[3357,3358,3359,3389,3390,3391],[3359,3360,3361,3391,3392,3393],[3358,3359,3360,3390,3391,3392]],
[[46,-31,102],[29,-31,90],[46,-41,102,],0xFFFFFF,[3358,3359,3360,3390,3391,3392],[3359,3360,3361,3391,3392,3393],[3360,3361,3362,3392,3393,3394]],
[[29,-31,90],[29,-41,90],[46,-41,102,],0xFFFFFF,[3359,3360,3361,3391,3392,3393],[3361,3362,3363,3393,3394,3395],[3360,3361,3362,3392,3393,3394]],
[[46,-41,102],[29,-41,90],[47,-51,102,],0xFFFFFF,[3360,3361,3362,3392,3393,3394],[3361,3362,3363,3393,3394,3395],[3362,3363,3364,3394,3395,3396]],
[[29,-41,90],[30,-51,90],[47,-51,102,],0xFFFFFF,[3361,3362,3363,3393,3394,3395],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[3362,3363,3364,3394,3395,3396]],
[[47,-51,102],[30,-51,90],[47,-61,101,],0xFFFFFF,[3362,3363,3364,3394,3395,3396],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[3364,3365,3366,3396,3397,3398]],
[[30,-51,90],[30,-61,89],[47,-61,101,],0xFFFFFF,[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[3365,3366,3367,3397,3398,3399],[3364,3365,3366,3396,3397,3398]],
[[47,-61,101],[30,-61,89],[48,-71,99,],0xFFFFFF,[3364,3365,3366,3396,3397,3398],[3365,3366,3367,3397,3398,3399],[3366,3367,3368,3398,3399,3400]],
[[30,-61,89],[32,-71,88],[48,-71,99,],0xFFFFFF,[3365,3366,3367,3397,3398,3399],[3367,3368,3369,3399,3400,3401],[3366,3367,3368,3398,3399,3400]],
[[48,-71,99],[32,-71,88],[49,-81,97,],0xFFFFFF,[3366,3367,3368,3398,3399,3400],[3367,3368,3369,3399,3400,3401],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[32,-71,88],[33,-81,86],[49,-81,97,],0xFFFFFF,[3367,3368,3369,3399,3400,3401],[3369,3370,3371,3401,3402,3403],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[49,-81,97],[33,-81,86],[51,-91,94,],0xFFFFFF,[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402],[3369,3370,3371,3401,3402,3403],[3370,3371,3402,3403]],
[[33,-81,86],[35,-91,83],[51,-91,94,],0xFFFFFF,[3369,3370,3371,3401,3402,3403],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403],[3370,3371,3402,3403]],
[[69,60,65],[58,60,57],[59,55,80,],0xFFFFFF,[1394,1397,3340,3372],[3340,3341,3372,3373],[3340,3341,3342,3372,3373,3374]],
[[58,60,57],[46,55,71],[59,55,80,],0xFFFFFF,[3340,3341,3372,3373],[3341,3342,3343,3373,3374,3375],[3340,3341,3342,3372,3373,3374]],
[[59,55,80],[46,55,71],[55,49,87,],0xFFFFFF,[3340,3341,3342,3372,3373,3374],[3341,3342,3343,3373,3374,3375],[3342,3343,3344,3374,3375,3376]],
[[46,55,71],[40,49,77],[55,49,87,],0xFFFFFF,[3341,3342,3343,3373,3374,3375],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[3342,3343,3344,3374,3375,3376]],
[[55,49,87],[40,49,77],[52,39,93,],0xFFFFFF,[3342,3343,3344,3374,3375,3376],[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[3344,3345,3346,3376,3377,3378]],
[[40,49,77],[36,39,82],[52,39,93,],0xFFFFFF,[1332,1335,1336,1337,1342,1343,3343,3344,3345,3375,3376,3377],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[3344,3345,3346,3376,3377,3378]],
[[52,39,93],[36,39,82],[50,29,95,],0xFFFFFF,[3344,3345,3346,3376,3377,3378],[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[3346,3347,3348,3378,3379,3380]],
[[36,39,82],[34,29,84],[50,29,95,],0xFFFFFF,[1402,1403,1404,1408,1409,1410,3345,3346,3347,3377,3378,3379],[3347,3348,3349,3379,3380,3381],[3346,3347,3348,3378,3379,3380]],
[[50,29,95],[34,29,84],[49,19,97,],0xFFFFFF,[3346,3347,3348,3378,3379,3380],[3347,3348,3349,3379,3380,3381],[3348,3349,3350,3380,3381,3382]],
[[34,29,84],[33,19,86],[49,19,97,],0xFFFFFF,[3347,3348,3349,3379,3380,3381],[3349,3350,3351,3381,3382,3383],[3348,3349,3350,3380,3381,3382]],
[[49,19,97],[33,19,86],[48,9,99,],0xFFFFFF,[3348,3349,3350,3380,3381,3382],[3349,3350,3351,3381,3382,3383],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[33,19,86],[32,9,88],[48,9,99,],0xFFFFFF,[3349,3350,3351,3381,3382,3383],[3351,3352,3353,3383,3384,3385],[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384]],
[[48,9,99],[32,9,88],[47,-1,100,],0xFFFFFF,[1413,1415,1416,1425,1434,1435,3350,3351,3352,3382,3383,3384],[3351,3352,3353,3383,3384,3385],[3352,3353,3354,3384,3385,3386]],
[[32,9,88],[31,-1,89],[47,-1,100,],0xFFFFFF,[3351,3352,3353,3383,3384,3385],[3353,3354,3355,3385,3386,3387],[3352,3353,3354,3384,3385,3386]],
[[47,-1,100],[31,-1,89],[47,-11,101,],0xFFFFFF,[3352,3353,3354,3384,3385,3386],[3353,3354,3355,3385,3386,3387],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[31,-1,89],[30,-11,89],[47,-11,101,],0xFFFFFF,[3353,3354,3355,3385,3386,3387],[3355,3356,3357,3387,3388,3389],[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388]],
[[47,-11,101],[30,-11,89],[46,-21,102,],0xFFFFFF,[1418,1419,1420,1427,1428,1429,3354,3355,3356,3386,3387,3388],[3355,3356,3357,3387,3388,3389],[3356,3357,3358,3388,3389,3390]],
[[30,-11,89],[30,-21,90],[46,-21,102,],0xFFFFFF,[3355,3356,3357,3387,3388,3389],[3357,3358,3359,3389,3390,3391],[3356,3357,3358,3388,3389,3390]],
[[46,-21,102],[30,-21,90],[46,-31,102,],0xFFFFFF,[3356,3357,3358,3388,3389,3390],[3357,3358,3359,3389,3390,3391],[3358,3359,3360,3390,3391,3392]],
[[30,-21,90],[29,-31,90],[46,-31,102,],0xFFFFFF,[3357,3358,3359,3389,3390,3391],[3359,3360,3361,3391,3392,3393],[3358,3359,3360,3390,3391,3392]],
[[46,-31,102],[29,-31,90],[46,-41,102,],0xFFFFFF,[3358,3359,3360,3390,3391,3392],[3359,3360,3361,3391,3392,3393],[3360,3361,3362,3392,3393,3394]],
[[29,-31,90],[29,-41,90],[46,-41,102,],0xFFFFFF,[3359,3360,3361,3391,3392,3393],[3361,3362,3363,3393,3394,3395],[3360,3361,3362,3392,3393,3394]],
[[46,-41,102],[29,-41,90],[47,-51,102,],0xFFFFFF,[3360,3361,3362,3392,3393,3394],[3361,3362,3363,3393,3394,3395],[3362,3363,3364,3394,3395,3396]],
[[29,-41,90],[30,-51,90],[47,-51,102,],0xFFFFFF,[3361,3362,3363,3393,3394,3395],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[3362,3363,3364,3394,3395,3396]],
[[47,-51,102],[30,-51,90],[47,-61,101,],0xFFFFFF,[3362,3363,3364,3394,3395,3396],[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[3364,3365,3366,3396,3397,3398]],
[[30,-51,90],[30,-61,89],[47,-61,101,],0xFFFFFF,[1438,1439,1440,1449,1450,1451,3363,3364,3365,3395,3396,3397],[3365,3366,3367,3397,3398,3399],[3364,3365,3366,3396,3397,3398]],
[[47,-61,101],[30,-61,89],[48,-71,99,],0xFFFFFF,[3364,3365,3366,3396,3397,3398],[3365,3366,3367,3397,3398,3399],[3366,3367,3368,3398,3399,3400]],
[[30,-61,89],[32,-71,88],[48,-71,99,],0xFFFFFF,[3365,3366,3367,3397,3398,3399],[3367,3368,3369,3399,3400,3401],[3366,3367,3368,3398,3399,3400]],
[[48,-71,99],[32,-71,88],[49,-81,97,],0xFFFFFF,[3366,3367,3368,3398,3399,3400],[3367,3368,3369,3399,3400,3401],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[32,-71,88],[33,-81,86],[49,-81,97,],0xFFFFFF,[3367,3368,3369,3399,3400,3401],[3369,3370,3371,3401,3402,3403],[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402]],
[[49,-81,97],[33,-81,86],[51,-91,94,],0xFFFFFF,[1443,1444,1445,1454,1455,1456,3368,3369,3370,3400,3401,3402],[3369,3370,3371,3401,3402,3403],[3370,3371,3402,3403]],
[[33,-81,86],[35,-91,83],[51,-91,94,],0xFFFFFF,[3369,3370,3371,3401,3402,3403],[1381,1382,1392,1393,3306,3307,3338,3339,3371,3403],[3370,3371,3402,3403]],
[[81,60,70],[68,60,64],[74,55,87,],0xFFFFFF,[1458,1461,3404,3436],[1458,1459,1461,1462,3404,3405,3436,3437],[3404,3405,3406,3436,3437,3438]],
[[68,60,64],[59,55,80],[74,55,87,],0xFFFFFF,[1458,1459,1461,1462,3404,3405,3436,3437],[3405,3406,3407,3437,3438,3439],[3404,3405,3406,3436,3437,3438]],
[[74,55,87],[59,55,80],[71,49,95,],0xFFFFFF,[3404,3405,3406,3436,3437,3438],[3405,3406,3407,3437,3438,3439],[3406,3407,3408,3438,3439,3440]],
[[59,55,80],[55,49,87],[71,49,95,],0xFFFFFF,[3405,3406,3407,3437,3438,3439],[3407,3408,3409,3439,3440,3441],[3406,3407,3408,3438,3439,3440]],
[[71,49,95],[55,49,87],[69,39,101,],0xFFFFFF,[3406,3407,3408,3438,3439,3440],[3407,3408,3409,3439,3440,3441],[3408,3409,3410,3440,3441,3442]],
[[55,49,87],[52,39,93],[69,39,101,],0xFFFFFF,[3407,3408,3409,3439,3440,3441],[3409,3410,3411,3441,3442,3443],[3408,3409,3410,3440,3441,3442]],
[[69,39,101],[52,39,93],[68,29,104,],0xFFFFFF,[3408,3409,3410,3440,3441,3442],[3409,3410,3411,3441,3442,3443],[3410,3411,3412,3442,3443,3444]],
[[52,39,93],[50,29,95],[68,29,104,],0xFFFFFF,[3409,3410,3411,3441,3442,3443],[3411,3412,3413,3443,3444,3445],[3410,3411,3412,3442,3443,3444]],
[[68,29,104],[50,29,95],[67,19,106,],0xFFFFFF,[3410,3411,3412,3442,3443,3444],[3411,3412,3413,3443,3444,3445],[3412,3413,3414,3444,3445,3446]],
[[50,29,95],[49,19,97],[67,19,106,],0xFFFFFF,[3411,3412,3413,3443,3444,3445],[3413,3414,3415,3445,3446,3447],[3412,3413,3414,3444,3445,3446]],
[[67,19,106],[49,19,97],[66,9,107,],0xFFFFFF,[3412,3413,3414,3444,3445,3446],[3413,3414,3415,3445,3446,3447],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[49,19,97],[48,9,99],[66,9,107,],0xFFFFFF,[3413,3414,3415,3445,3446,3447],[3415,3416,3417,3447,3448,3449],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[66,9,107],[48,9,99],[66,-1,109,],0xFFFFFF,[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[3415,3416,3417,3447,3448,3449],[3416,3417,3418,3448,3449,3450]],
[[48,9,99],[47,-1,100],[66,-1,109,],0xFFFFFF,[3415,3416,3417,3447,3448,3449],[3417,3418,3419,3449,3450,3451],[3416,3417,3418,3448,3449,3450]],
[[66,-1,109],[47,-1,100],[65,-11,110,],0xFFFFFF,[3416,3417,3418,3448,3449,3450],[3417,3418,3419,3449,3450,3451],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[47,-1,100],[47,-11,101],[65,-11,110,],0xFFFFFF,[3417,3418,3419,3449,3450,3451],[3419,3420,3421,3451,3452,3453],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[65,-11,110],[47,-11,101],[65,-21,111,],0xFFFFFF,[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[3419,3420,3421,3451,3452,3453],[3420,3421,3422,3452,3453,3454]],
[[47,-11,101],[46,-21,102],[65,-21,111,],0xFFFFFF,[3419,3420,3421,3451,3452,3453],[3421,3422,3423,3453,3454,3455],[3420,3421,3422,3452,3453,3454]],
[[65,-21,111],[46,-21,102],[65,-31,111,],0xFFFFFF,[3420,3421,3422,3452,3453,3454],[3421,3422,3423,3453,3454,3455],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521]],
[[46,-21,102],[46,-31,102],[65,-31,111,],0xFFFFFF,[3421,3422,3423,3453,3454,3455],[3423,3424,3425,3455,3456,3457],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521]],
[[65,-31,111],[46,-31,102],[65,-41,111,],0xFFFFFF,[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[3423,3424,3425,3455,3456,3457],[3424,3425,3426,3456,3457,3458]],
[[46,-31,102],[46,-41,102],[65,-41,111,],0xFFFFFF,[3423,3424,3425,3455,3456,3457],[3425,3426,3427,3457,3458,3459],[3424,3425,3426,3456,3457,3458]],
[[65,-41,111],[46,-41,102],[65,-51,110,],0xFFFFFF,[3424,3425,3426,3456,3457,3458],[3425,3426,3427,3457,3458,3459],[3426,3427,3428,3458,3459,3460]],
[[46,-41,102],[47,-51,102],[65,-51,110,],0xFFFFFF,[3425,3426,3427,3457,3458,3459],[3427,3428,3429,3459,3460,3461],[3426,3427,3428,3458,3459,3460]],
[[65,-51,110],[47,-51,102],[66,-61,109,],0xFFFFFF,[3426,3427,3428,3458,3459,3460],[3427,3428,3429,3459,3460,3461],[3428,3429,3430,3460,3461,3462]],
[[47,-51,102],[47,-61,101],[66,-61,109,],0xFFFFFF,[3427,3428,3429,3459,3460,3461],[3429,3430,3431,3461,3462,3463],[3428,3429,3430,3460,3461,3462]],
[[66,-61,109],[47,-61,101],[66,-71,108,],0xFFFFFF,[3428,3429,3430,3460,3461,3462],[3429,3430,3431,3461,3462,3463],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529]],
[[47,-61,101],[48,-71,99],[66,-71,108,],0xFFFFFF,[3429,3430,3431,3461,3462,3463],[3431,3432,3433,3463,3464,3465],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529]],
[[66,-71,108],[48,-71,99],[67,-81,105,],0xFFFFFF,[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3431,3432,3433,3463,3464,3465],[3432,3433,3434,3464,3465,3466]],
[[48,-71,99],[49,-81,97],[67,-81,105,],0xFFFFFF,[3431,3432,3433,3463,3464,3465],[3433,3434,3435,3465,3466,3467],[3432,3433,3434,3464,3465,3466]],
[[67,-81,105],[49,-81,97],[68,-91,102,],0xFFFFFF,[3432,3433,3434,3464,3465,3466],[3433,3434,3435,3465,3466,3467],[3434,3435,3466,3467]],
[[49,-81,97],[51,-91,94],[68,-91,102,],0xFFFFFF,[3433,3434,3435,3465,3466,3467],[3435,3467],[3434,3435,3466,3467]],
[[81,60,70],[68,60,64],[74,55,87,],0xFFFFFF,[1458,1461,3404,3436],[1458,1459,1461,1462,3404,3405,3436,3437],[3404,3405,3406,3436,3437,3438]],
[[68,60,64],[59,55,80],[74,55,87,],0xFFFFFF,[1458,1459,1461,1462,3404,3405,3436,3437],[3405,3406,3407,3437,3438,3439],[3404,3405,3406,3436,3437,3438]],
[[74,55,87],[59,55,80],[71,49,95,],0xFFFFFF,[3404,3405,3406,3436,3437,3438],[3405,3406,3407,3437,3438,3439],[3406,3407,3408,3438,3439,3440]],
[[59,55,80],[55,49,87],[71,49,95,],0xFFFFFF,[3405,3406,3407,3437,3438,3439],[3407,3408,3409,3439,3440,3441],[3406,3407,3408,3438,3439,3440]],
[[71,49,95],[55,49,87],[69,39,101,],0xFFFFFF,[3406,3407,3408,3438,3439,3440],[3407,3408,3409,3439,3440,3441],[3408,3409,3410,3440,3441,3442]],
[[55,49,87],[52,39,93],[69,39,101,],0xFFFFFF,[3407,3408,3409,3439,3440,3441],[3409,3410,3411,3441,3442,3443],[3408,3409,3410,3440,3441,3442]],
[[69,39,101],[52,39,93],[68,29,104,],0xFFFFFF,[3408,3409,3410,3440,3441,3442],[3409,3410,3411,3441,3442,3443],[3410,3411,3412,3442,3443,3444]],
[[52,39,93],[50,29,95],[68,29,104,],0xFFFFFF,[3409,3410,3411,3441,3442,3443],[3411,3412,3413,3443,3444,3445],[3410,3411,3412,3442,3443,3444]],
[[68,29,104],[50,29,95],[67,19,106,],0xFFFFFF,[3410,3411,3412,3442,3443,3444],[3411,3412,3413,3443,3444,3445],[3412,3413,3414,3444,3445,3446]],
[[50,29,95],[49,19,97],[67,19,106,],0xFFFFFF,[3411,3412,3413,3443,3444,3445],[3413,3414,3415,3445,3446,3447],[3412,3413,3414,3444,3445,3446]],
[[67,19,106],[49,19,97],[66,9,107,],0xFFFFFF,[3412,3413,3414,3444,3445,3446],[3413,3414,3415,3445,3446,3447],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[49,19,97],[48,9,99],[66,9,107,],0xFFFFFF,[3413,3414,3415,3445,3446,3447],[3415,3416,3417,3447,3448,3449],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513]],
[[66,9,107],[48,9,99],[66,-1,109,],0xFFFFFF,[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[3415,3416,3417,3447,3448,3449],[3416,3417,3418,3448,3449,3450]],
[[48,9,99],[47,-1,100],[66,-1,109,],0xFFFFFF,[3415,3416,3417,3447,3448,3449],[3417,3418,3419,3449,3450,3451],[3416,3417,3418,3448,3449,3450]],
[[66,-1,109],[47,-1,100],[65,-11,110,],0xFFFFFF,[3416,3417,3418,3448,3449,3450],[3417,3418,3419,3449,3450,3451],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[47,-1,100],[47,-11,101],[65,-11,110,],0xFFFFFF,[3417,3418,3419,3449,3450,3451],[3419,3420,3421,3451,3452,3453],[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452]],
[[65,-11,110],[47,-11,101],[65,-21,111,],0xFFFFFF,[1482,1483,1484,1491,1492,1493,1547,1548,1549,1556,1557,1558,3418,3419,3420,3450,3451,3452],[3419,3420,3421,3451,3452,3453],[3420,3421,3422,3452,3453,3454]],
[[47,-11,101],[46,-21,102],[65,-21,111,],0xFFFFFF,[3419,3420,3421,3451,3452,3453],[3421,3422,3423,3453,3454,3455],[3420,3421,3422,3452,3453,3454]],
[[65,-21,111],[46,-21,102],[65,-31,111,],0xFFFFFF,[3420,3421,3422,3452,3453,3454],[3421,3422,3423,3453,3454,3455],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521]],
[[46,-21,102],[46,-31,102],[65,-31,111,],0xFFFFFF,[3421,3422,3423,3453,3454,3455],[3423,3424,3425,3455,3456,3457],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521]],
[[65,-31,111],[46,-31,102],[65,-41,111,],0xFFFFFF,[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[3423,3424,3425,3455,3456,3457],[3424,3425,3426,3456,3457,3458]],
[[46,-31,102],[46,-41,102],[65,-41,111,],0xFFFFFF,[3423,3424,3425,3455,3456,3457],[3425,3426,3427,3457,3458,3459],[3424,3425,3426,3456,3457,3458]],
[[65,-41,111],[46,-41,102],[65,-51,110,],0xFFFFFF,[3424,3425,3426,3456,3457,3458],[3425,3426,3427,3457,3458,3459],[3426,3427,3428,3458,3459,3460]],
[[46,-41,102],[47,-51,102],[65,-51,110,],0xFFFFFF,[3425,3426,3427,3457,3458,3459],[3427,3428,3429,3459,3460,3461],[3426,3427,3428,3458,3459,3460]],
[[65,-51,110],[47,-51,102],[66,-61,109,],0xFFFFFF,[3426,3427,3428,3458,3459,3460],[3427,3428,3429,3459,3460,3461],[3428,3429,3430,3460,3461,3462]],
[[47,-51,102],[47,-61,101],[66,-61,109,],0xFFFFFF,[3427,3428,3429,3459,3460,3461],[3429,3430,3431,3461,3462,3463],[3428,3429,3430,3460,3461,3462]],
[[66,-61,109],[47,-61,101],[66,-71,108,],0xFFFFFF,[3428,3429,3430,3460,3461,3462],[3429,3430,3431,3461,3462,3463],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529]],
[[47,-61,101],[48,-71,99],[66,-71,108,],0xFFFFFF,[3429,3430,3431,3461,3462,3463],[3431,3432,3433,3463,3464,3465],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529]],
[[66,-71,108],[48,-71,99],[67,-81,105,],0xFFFFFF,[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3431,3432,3433,3463,3464,3465],[3432,3433,3434,3464,3465,3466]],
[[48,-71,99],[49,-81,97],[67,-81,105,],0xFFFFFF,[3431,3432,3433,3463,3464,3465],[3433,3434,3435,3465,3466,3467],[3432,3433,3434,3464,3465,3466]],
[[67,-81,105],[49,-81,97],[68,-91,102,],0xFFFFFF,[3432,3433,3434,3464,3465,3466],[3433,3434,3435,3465,3466,3467],[3434,3435,3466,3467]],
[[49,-81,97],[51,-91,94],[68,-91,102,],0xFFFFFF,[3433,3434,3435,3465,3466,3467],[3435,3467],[3434,3435,3466,3467]],
[[94,60,73],[80,60,69],[89,55,91,],0xFFFFFF,[1522,1525,3468,3500],[1522,1523,1525,1526,3468,3469,3500,3501],[3468,3469,3470,3500,3501,3502]],
[[80,60,69],[74,55,87],[89,55,91,],0xFFFFFF,[1522,1523,1525,1526,3468,3469,3500,3501],[3469,3470,3471,3501,3502,3503],[3468,3469,3470,3500,3501,3502]],
[[89,55,91],[74,55,87],[88,49,99,],0xFFFFFF,[3468,3469,3470,3500,3501,3502],[3469,3470,3471,3501,3502,3503],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[74,55,87],[71,49,95],[88,49,99,],0xFFFFFF,[3469,3470,3471,3501,3502,3503],[3471,3472,3473,3503,3504,3505],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[88,49,99],[71,49,95],[87,39,106,],0xFFFFFF,[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504],[3471,3472,3473,3503,3504,3505],[3472,3473,3474,3504,3505,3506]],
[[71,49,95],[69,39,101],[87,39,106,],0xFFFFFF,[3471,3472,3473,3503,3504,3505],[3473,3474,3475,3505,3506,3507],[3472,3473,3474,3504,3505,3506]],
[[87,39,106],[69,39,101],[86,29,109,],0xFFFFFF,[3472,3473,3474,3504,3505,3506],[3473,3474,3475,3505,3506,3507],[3474,3475,3476,3506,3507,3508]],
[[69,39,101],[68,29,104],[86,29,109,],0xFFFFFF,[3473,3474,3475,3505,3506,3507],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[3474,3475,3476,3506,3507,3508]],
[[86,29,109],[68,29,104],[86,19,111,],0xFFFFFF,[3474,3475,3476,3506,3507,3508],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[3476,3477,3478,3508,3509,3510]],
[[68,29,104],[67,19,106],[86,19,111,],0xFFFFFF,[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[3477,3478,3479,3509,3510,3511],[3476,3477,3478,3508,3509,3510]],
[[86,19,111],[67,19,106],[86,9,113,],0xFFFFFF,[3476,3477,3478,3508,3509,3510],[3477,3478,3479,3509,3510,3511],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[67,19,106],[66,9,107],[86,9,113,],0xFFFFFF,[3477,3478,3479,3509,3510,3511],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[86,9,113],[66,9,107],[85,-1,114,],0xFFFFFF,[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[3480,3481,3482,3512,3513,3514]],
[[66,9,107],[66,-1,109],[85,-1,114,],0xFFFFFF,[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[3481,3482,3483,3513,3514,3515],[3480,3481,3482,3512,3513,3514]],
[[85,-1,114],[66,-1,109],[85,-11,115,],0xFFFFFF,[3480,3481,3482,3512,3513,3514],[3481,3482,3483,3513,3514,3515],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[66,-1,109],[65,-11,110],[85,-11,115,],0xFFFFFF,[3481,3482,3483,3513,3514,3515],[3483,3484,3485,3515,3516,3517],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[85,-11,115],[65,-11,110],[85,-21,116,],0xFFFFFF,[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516],[3483,3484,3485,3515,3516,3517],[3484,3485,3486,3516,3517,3518]],
[[65,-11,110],[65,-21,111],[85,-21,116,],0xFFFFFF,[3483,3484,3485,3515,3516,3517],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[3484,3485,3486,3516,3517,3518]],
[[85,-21,116],[65,-21,111],[85,-31,116,],0xFFFFFF,[3484,3485,3486,3516,3517,3518],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585]],
[[65,-21,111],[65,-31,111],[85,-31,116,],0xFFFFFF,[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585]],
[[85,-31,116],[65,-31,111],[85,-41,116,],0xFFFFFF,[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[3488,3489,3490,3520,3521,3522]],
[[65,-31,111],[65,-41,111],[85,-41,116,],0xFFFFFF,[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[3488,3489,3490,3520,3521,3522]],
[[85,-41,116],[65,-41,111],[85,-51,116,],0xFFFFFF,[3488,3489,3490,3520,3521,3522],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589]],
[[65,-41,111],[65,-51,110],[85,-51,116,],0xFFFFFF,[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589]],
[[85,-51,116],[65,-51,110],[85,-61,114,],0xFFFFFF,[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[3492,3493,3494,3524,3525,3526]],
[[65,-51,110],[66,-61,109],[85,-61,114,],0xFFFFFF,[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[3493,3494,3495,3525,3526,3527],[3492,3493,3494,3524,3525,3526]],
[[85,-61,114],[66,-61,109],[86,-71,113,],0xFFFFFF,[3492,3493,3494,3524,3525,3526],[3493,3494,3495,3525,3526,3527],[3494,3495,3496,3526,3527,3528]],
[[66,-61,109],[66,-71,108],[86,-71,113,],0xFFFFFF,[3493,3494,3495,3525,3526,3527],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3494,3495,3496,3526,3527,3528]],
[[86,-71,113],[66,-71,108],[86,-81,110,],0xFFFFFF,[3494,3495,3496,3526,3527,3528],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3496,3497,3498,3528,3529,3530]],
[[66,-71,108],[67,-81,105],[86,-81,110,],0xFFFFFF,[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3497,3498,3499,3529,3530,3531],[3496,3497,3498,3528,3529,3530]],
[[86,-81,110],[67,-81,105],[87,-91,107,],0xFFFFFF,[3496,3497,3498,3528,3529,3530],[3497,3498,3499,3529,3530,3531],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[67,-81,105],[68,-91,102],[87,-91,107,],0xFFFFFF,[3497,3498,3499,3529,3530,3531],[1509,1510,1520,1521,3499,3531],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[94,60,73],[80,60,69],[89,55,91,],0xFFFFFF,[1522,1525,3468,3500],[1522,1523,1525,1526,3468,3469,3500,3501],[3468,3469,3470,3500,3501,3502]],
[[80,60,69],[74,55,87],[89,55,91,],0xFFFFFF,[1522,1523,1525,1526,3468,3469,3500,3501],[3469,3470,3471,3501,3502,3503],[3468,3469,3470,3500,3501,3502]],
[[89,55,91],[74,55,87],[88,49,99,],0xFFFFFF,[3468,3469,3470,3500,3501,3502],[3469,3470,3471,3501,3502,3503],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[74,55,87],[71,49,95],[88,49,99,],0xFFFFFF,[3469,3470,3471,3501,3502,3503],[3471,3472,3473,3503,3504,3505],[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504]],
[[88,49,99],[71,49,95],[87,39,106,],0xFFFFFF,[1524,1527,1528,1529,1534,1535,3470,3471,3472,3502,3503,3504],[3471,3472,3473,3503,3504,3505],[3472,3473,3474,3504,3505,3506]],
[[71,49,95],[69,39,101],[87,39,106,],0xFFFFFF,[3471,3472,3473,3503,3504,3505],[3473,3474,3475,3505,3506,3507],[3472,3473,3474,3504,3505,3506]],
[[87,39,106],[69,39,101],[86,29,109,],0xFFFFFF,[3472,3473,3474,3504,3505,3506],[3473,3474,3475,3505,3506,3507],[3474,3475,3476,3506,3507,3508]],
[[69,39,101],[68,29,104],[86,29,109,],0xFFFFFF,[3473,3474,3475,3505,3506,3507],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[3474,3475,3476,3506,3507,3508]],
[[86,29,109],[68,29,104],[86,19,111,],0xFFFFFF,[3474,3475,3476,3506,3507,3508],[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[3476,3477,3478,3508,3509,3510]],
[[68,29,104],[67,19,106],[86,19,111,],0xFFFFFF,[1532,1533,1538,1539,1540,1542,3475,3476,3477,3507,3508,3509],[3477,3478,3479,3509,3510,3511],[3476,3477,3478,3508,3509,3510]],
[[86,19,111],[67,19,106],[86,9,113,],0xFFFFFF,[3476,3477,3478,3508,3509,3510],[3477,3478,3479,3509,3510,3511],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[67,19,106],[66,9,107],[86,9,113,],0xFFFFFF,[3477,3478,3479,3509,3510,3511],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512]],
[[86,9,113],[66,9,107],[85,-1,114,],0xFFFFFF,[1541,1543,1544,1553,1562,1563,3478,3479,3480,3510,3511,3512],[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[3480,3481,3482,3512,3513,3514]],
[[66,9,107],[66,-1,109],[85,-1,114,],0xFFFFFF,[1477,1479,1480,1489,1498,1499,3414,3415,3416,3446,3447,3448,3479,3480,3481,3511,3512,3513],[3481,3482,3483,3513,3514,3515],[3480,3481,3482,3512,3513,3514]],
[[85,-1,114],[66,-1,109],[85,-11,115,],0xFFFFFF,[3480,3481,3482,3512,3513,3514],[3481,3482,3483,3513,3514,3515],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[66,-1,109],[65,-11,110],[85,-11,115,],0xFFFFFF,[3481,3482,3483,3513,3514,3515],[3483,3484,3485,3515,3516,3517],[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516]],
[[85,-11,115],[65,-11,110],[85,-21,116,],0xFFFFFF,[1546,1547,1548,1555,1556,1557,3482,3483,3484,3514,3515,3516],[3483,3484,3485,3515,3516,3517],[3484,3485,3486,3516,3517,3518]],
[[65,-11,110],[65,-21,111],[85,-21,116,],0xFFFFFF,[3483,3484,3485,3515,3516,3517],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[3484,3485,3486,3516,3517,3518]],
[[85,-21,116],[65,-21,111],[85,-31,116,],0xFFFFFF,[3484,3485,3486,3516,3517,3518],[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585]],
[[65,-21,111],[65,-31,111],[85,-31,116,],0xFFFFFF,[1484,1485,1486,1493,1494,1495,3485,3486,3487,3517,3518,3519],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585]],
[[85,-31,116],[65,-31,111],[85,-41,116,],0xFFFFFF,[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[3488,3489,3490,3520,3521,3522]],
[[65,-31,111],[65,-41,111],[85,-41,116,],0xFFFFFF,[3422,3423,3424,3454,3455,3456,3487,3488,3489,3519,3520,3521],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[3488,3489,3490,3520,3521,3522]],
[[85,-41,116],[65,-41,111],[85,-51,116,],0xFFFFFF,[3488,3489,3490,3520,3521,3522],[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589]],
[[65,-41,111],[65,-51,110],[85,-51,116,],0xFFFFFF,[1564,1565,1566,1575,1576,1577,3489,3490,3491,3521,3522,3523],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589]],
[[85,-51,116],[65,-51,110],[85,-61,114,],0xFFFFFF,[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[3492,3493,3494,3524,3525,3526]],
[[65,-51,110],[66,-61,109],[85,-61,114,],0xFFFFFF,[1566,1567,1568,1577,1578,1579,3491,3492,3493,3523,3524,3525],[3493,3494,3495,3525,3526,3527],[3492,3493,3494,3524,3525,3526]],
[[85,-61,114],[66,-61,109],[86,-71,113,],0xFFFFFF,[3492,3493,3494,3524,3525,3526],[3493,3494,3495,3525,3526,3527],[3494,3495,3496,3526,3527,3528]],
[[66,-61,109],[66,-71,108],[86,-71,113,],0xFFFFFF,[3493,3494,3495,3525,3526,3527],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3494,3495,3496,3526,3527,3528]],
[[86,-71,113],[66,-71,108],[86,-81,110,],0xFFFFFF,[3494,3495,3496,3526,3527,3528],[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3496,3497,3498,3528,3529,3530]],
[[66,-71,108],[67,-81,105],[86,-81,110,],0xFFFFFF,[3430,3431,3432,3462,3463,3464,3495,3496,3497,3527,3528,3529],[3497,3498,3499,3529,3530,3531],[3496,3497,3498,3528,3529,3530]],
[[86,-81,110],[67,-81,105],[87,-91,107,],0xFFFFFF,[3496,3497,3498,3528,3529,3530],[3497,3498,3499,3529,3530,3531],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[67,-81,105],[68,-91,102],[87,-91,107,],0xFFFFFF,[3497,3498,3499,3529,3530,3531],[1509,1510,1520,1521,3499,3531],[1573,1574,1584,1585,3498,3499,3530,3531]],
[[107,60,74],[93,60,73],[106,55,92,],0xFFFFFF,[3532,3564],[3532,3533,3564,3565],[3532,3533,3534,3564,3565,3566]],
[[93,60,73],[89,55,91],[106,55,92,],0xFFFFFF,[3532,3533,3564,3565],[3533,3534,3535,3565,3566,3567],[3532,3533,3534,3564,3565,3566]],
[[106,55,92],[89,55,91],[106,49,101,],0xFFFFFF,[3532,3533,3534,3564,3565,3566],[3533,3534,3535,3565,3566,3567],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568]],
[[89,55,91],[88,49,99],[106,49,101,],0xFFFFFF,[3533,3534,3535,3565,3566,3567],[3535,3536,3537,3567,3568,3569],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568]],
[[106,49,101],[88,49,99],[106,39,107,],0xFFFFFF,[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[3535,3536,3537,3567,3568,3569],[3536,3537,3538,3568,3569,3570]],
[[88,49,99],[87,39,106],[106,39,107,],0xFFFFFF,[3535,3536,3537,3567,3568,3569],[3537,3538,3539,3569,3570,3571],[3536,3537,3538,3568,3569,3570]],
[[106,39,107],[87,39,106],[106,29,110,],0xFFFFFF,[3536,3537,3538,3568,3569,3570],[3537,3538,3539,3569,3570,3571],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[87,39,106],[86,29,109],[106,29,110,],0xFFFFFF,[3537,3538,3539,3569,3570,3571],[3539,3540,3541,3571,3572,3573],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[106,29,110],[86,29,109],[106,19,113,],0xFFFFFF,[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572],[3539,3540,3541,3571,3572,3573],[3540,3541,3542,3572,3573,3574]],
[[86,29,109],[86,19,111],[106,19,113,],0xFFFFFF,[3539,3540,3541,3571,3572,3573],[3541,3542,3543,3573,3574,3575],[3540,3541,3542,3572,3573,3574]],
[[106,19,113],[86,19,111],[106,9,114,],0xFFFFFF,[3540,3541,3542,3572,3573,3574],[3541,3542,3543,3573,3574,3575],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[86,19,111],[86,9,113],[106,9,114,],0xFFFFFF,[3541,3542,3543,3573,3574,3575],[3543,3544,3545,3575,3576,3577],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[106,9,114],[86,9,113],[105,-1,116,],0xFFFFFF,[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576],[3543,3544,3545,3575,3576,3577],[3544,3545,3546,3576,3577,3578]],
[[86,9,113],[85,-1,114],[105,-1,116,],0xFFFFFF,[3543,3544,3545,3575,3576,3577],[3545,3546,3547,3577,3578,3579],[3544,3545,3546,3576,3577,3578]],
[[105,-1,116],[85,-1,114],[106,-11,117,],0xFFFFFF,[3544,3545,3546,3576,3577,3578],[3545,3546,3547,3577,3578,3579],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[85,-1,114],[85,-11,115],[106,-11,117,],0xFFFFFF,[3545,3546,3547,3577,3578,3579],[3547,3548,3549,3579,3580,3581],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[106,-11,117],[85,-11,115],[106,-21,118,],0xFFFFFF,[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580],[3547,3548,3549,3579,3580,3581],[3548,3549,3550,3580,3581,3582]],
[[85,-11,115],[85,-21,116],[106,-21,118,],0xFFFFFF,[3547,3548,3549,3579,3580,3581],[3549,3550,3551,3581,3582,3583],[3548,3549,3550,3580,3581,3582]],
[[106,-21,118],[85,-21,116],[106,-31,118,],0xFFFFFF,[3548,3549,3550,3580,3581,3582],[3549,3550,3551,3581,3582,3583],[3550,3551,3552,3582,3583,3584]],
[[85,-21,116],[85,-31,116],[106,-31,118,],0xFFFFFF,[3549,3550,3551,3581,3582,3583],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3550,3551,3552,3582,3583,3584]],
[[106,-31,118],[85,-31,116],[106,-41,118,],0xFFFFFF,[3550,3551,3552,3582,3583,3584],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3552,3553,3554,3584,3585,3586]],
[[85,-31,116],[85,-41,116],[106,-41,118,],0xFFFFFF,[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3553,3554,3555,3585,3586,3587],[3552,3553,3554,3584,3585,3586]],
[[106,-41,118],[85,-41,116],[105,-51,117,],0xFFFFFF,[3552,3553,3554,3584,3585,3586],[3553,3554,3555,3585,3586,3587],[3554,3555,3556,3586,3587,3588]],
[[85,-41,116],[85,-51,116],[105,-51,117,],0xFFFFFF,[3553,3554,3555,3585,3586,3587],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[3554,3555,3556,3586,3587,3588]],
[[105,-51,117],[85,-51,116],[105,-61,116,],0xFFFFFF,[3554,3555,3556,3586,3587,3588],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[3556,3557,3558,3588,3589,3590]],
[[85,-51,116],[85,-61,114],[105,-61,116,],0xFFFFFF,[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[3557,3558,3559,3589,3590,3591],[3556,3557,3558,3588,3589,3590]],
[[105,-61,116],[85,-61,114],[106,-71,114,],0xFFFFFF,[3556,3557,3558,3588,3589,3590],[3557,3558,3559,3589,3590,3591],[3558,3559,3560,3590,3591,3592]],
[[85,-61,114],[86,-71,113],[106,-71,114,],0xFFFFFF,[3557,3558,3559,3589,3590,3591],[3559,3560,3561,3591,3592,3593],[3558,3559,3560,3590,3591,3592]],
[[106,-71,114],[86,-71,113],[106,-81,112,],0xFFFFFF,[3558,3559,3560,3590,3591,3592],[3559,3560,3561,3591,3592,3593],[3560,3561,3562,3592,3593,3594]],
[[86,-71,113],[86,-81,110],[106,-81,112,],0xFFFFFF,[3559,3560,3561,3591,3592,3593],[3561,3562,3563,3593,3594,3595],[3560,3561,3562,3592,3593,3594]],
[[106,-81,112],[86,-81,110],[106,-91,109,],0xFFFFFF,[3560,3561,3562,3592,3593,3594],[3561,3562,3563,3593,3594,3595],[3562,3563,3594,3595]],
[[86,-81,110],[87,-91,107],[106,-91,109,],0xFFFFFF,[3561,3562,3563,3593,3594,3595],[3563,3595],[3562,3563,3594,3595]],
[[107,60,74],[93,60,73],[106,55,92,],0xFFFFFF,[3532,3564],[3532,3533,3564,3565],[3532,3533,3534,3564,3565,3566]],
[[93,60,73],[89,55,91],[106,55,92,],0xFFFFFF,[3532,3533,3564,3565],[3533,3534,3535,3565,3566,3567],[3532,3533,3534,3564,3565,3566]],
[[106,55,92],[89,55,91],[106,49,101,],0xFFFFFF,[3532,3533,3534,3564,3565,3566],[3533,3534,3535,3565,3566,3567],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568]],
[[89,55,91],[88,49,99],[106,49,101,],0xFFFFFF,[3533,3534,3535,3565,3566,3567],[3535,3536,3537,3567,3568,3569],[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568]],
[[106,49,101],[88,49,99],[106,39,107,],0xFFFFFF,[560,561,562,563,730,731,732,733,2372,2373,2374,2375,2665,2666,2667,2668,3534,3535,3536,3566,3567,3568],[3535,3536,3537,3567,3568,3569],[3536,3537,3538,3568,3569,3570]],
[[88,49,99],[87,39,106],[106,39,107,],0xFFFFFF,[3535,3536,3537,3567,3568,3569],[3537,3538,3539,3569,3570,3571],[3536,3537,3538,3568,3569,3570]],
[[106,39,107],[87,39,106],[106,29,110,],0xFFFFFF,[3536,3537,3538,3568,3569,3570],[3537,3538,3539,3569,3570,3571],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[87,39,106],[86,29,109],[106,29,110,],0xFFFFFF,[3537,3538,3539,3569,3570,3571],[3539,3540,3541,3571,3572,3573],[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572]],
[[106,29,110],[86,29,109],[106,19,113,],0xFFFFFF,[1595,1596,1597,1601,1602,1603,3538,3539,3540,3570,3571,3572],[3539,3540,3541,3571,3572,3573],[3540,3541,3542,3572,3573,3574]],
[[86,29,109],[86,19,111],[106,19,113,],0xFFFFFF,[3539,3540,3541,3571,3572,3573],[3541,3542,3543,3573,3574,3575],[3540,3541,3542,3572,3573,3574]],
[[106,19,113],[86,19,111],[106,9,114,],0xFFFFFF,[3540,3541,3542,3572,3573,3574],[3541,3542,3543,3573,3574,3575],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[86,19,111],[86,9,113],[106,9,114,],0xFFFFFF,[3541,3542,3543,3573,3574,3575],[3543,3544,3545,3575,3576,3577],[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576]],
[[106,9,114],[86,9,113],[105,-1,116,],0xFFFFFF,[1605,1607,1608,1617,1626,1627,3542,3543,3544,3574,3575,3576],[3543,3544,3545,3575,3576,3577],[3544,3545,3546,3576,3577,3578]],
[[86,9,113],[85,-1,114],[105,-1,116,],0xFFFFFF,[3543,3544,3545,3575,3576,3577],[3545,3546,3547,3577,3578,3579],[3544,3545,3546,3576,3577,3578]],
[[105,-1,116],[85,-1,114],[106,-11,117,],0xFFFFFF,[3544,3545,3546,3576,3577,3578],[3545,3546,3547,3577,3578,3579],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[85,-1,114],[85,-11,115],[106,-11,117,],0xFFFFFF,[3545,3546,3547,3577,3578,3579],[3547,3548,3549,3579,3580,3581],[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580]],
[[106,-11,117],[85,-11,115],[106,-21,118,],0xFFFFFF,[1610,1611,1612,1619,1620,1621,3546,3547,3548,3578,3579,3580],[3547,3548,3549,3579,3580,3581],[3548,3549,3550,3580,3581,3582]],
[[85,-11,115],[85,-21,116],[106,-21,118,],0xFFFFFF,[3547,3548,3549,3579,3580,3581],[3549,3550,3551,3581,3582,3583],[3548,3549,3550,3580,3581,3582]],
[[106,-21,118],[85,-21,116],[106,-31,118,],0xFFFFFF,[3548,3549,3550,3580,3581,3582],[3549,3550,3551,3581,3582,3583],[3550,3551,3552,3582,3583,3584]],
[[85,-21,116],[85,-31,116],[106,-31,118,],0xFFFFFF,[3549,3550,3551,3581,3582,3583],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3550,3551,3552,3582,3583,3584]],
[[106,-31,118],[85,-31,116],[106,-41,118,],0xFFFFFF,[3550,3551,3552,3582,3583,3584],[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3552,3553,3554,3584,3585,3586]],
[[85,-31,116],[85,-41,116],[106,-41,118,],0xFFFFFF,[3486,3487,3488,3518,3519,3520,3551,3552,3553,3583,3584,3585],[3553,3554,3555,3585,3586,3587],[3552,3553,3554,3584,3585,3586]],
[[106,-41,118],[85,-41,116],[105,-51,117,],0xFFFFFF,[3552,3553,3554,3584,3585,3586],[3553,3554,3555,3585,3586,3587],[3554,3555,3556,3586,3587,3588]],
[[85,-41,116],[85,-51,116],[105,-51,117,],0xFFFFFF,[3553,3554,3555,3585,3586,3587],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[3554,3555,3556,3586,3587,3588]],
[[105,-51,117],[85,-51,116],[105,-61,116,],0xFFFFFF,[3554,3555,3556,3586,3587,3588],[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[3556,3557,3558,3588,3589,3590]],
[[85,-51,116],[85,-61,114],[105,-61,116,],0xFFFFFF,[3490,3491,3492,3522,3523,3524,3555,3556,3557,3587,3588,3589],[3557,3558,3559,3589,3590,3591],[3556,3557,3558,3588,3589,3590]],
[[105,-61,116],[85,-61,114],[106,-71,114,],0xFFFFFF,[3556,3557,3558,3588,3589,3590],[3557,3558,3559,3589,3590,3591],[3558,3559,3560,3590,3591,3592]],
[[85,-61,114],[86,-71,113],[106,-71,114,],0xFFFFFF,[3557,3558,3559,3589,3590,3591],[3559,3560,3561,3591,3592,3593],[3558,3559,3560,3590,3591,3592]],
[[106,-71,114],[86,-71,113],[106,-81,112,],0xFFFFFF,[3558,3559,3560,3590,3591,3592],[3559,3560,3561,3591,3592,3593],[3560,3561,3562,3592,3593,3594]],
[[86,-71,113],[86,-81,110],[106,-81,112,],0xFFFFFF,[3559,3560,3561,3591,3592,3593],[3561,3562,3563,3593,3594,3595],[3560,3561,3562,3592,3593,3594]],
[[106,-81,112],[86,-81,110],[106,-91,109,],0xFFFFFF,[3560,3561,3562,3592,3593,3594],[3561,3562,3563,3593,3594,3595],[3562,3563,3594,3595]],
[[86,-81,110],[87,-91,107],[106,-91,109,],0xFFFFFF,[3561,3562,3563,3593,3594,3595],[3563,3595],[3562,3563,3594,3595]],
[[176,60,-24],[179,60,-10],[193,55,-30,],0xFFFFFF,[3596,3602],[3596,3597,3602,3603],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[179,60,-10],[197,55,-14],[193,55,-30,],0xFFFFFF,[3596,3597,3602,3603],[3597,3598,3599,3603,3604,3605],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[193,55,-30],[197,55,-14],[201,49,-33,],0xFFFFFF,[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604],[3597,3598,3599,3603,3604,3605],[3598,3599,3600,3604,3605,3606]],
[[197,55,-14],[206,49,-15],[201,49,-33,],0xFFFFFF,[3597,3598,3599,3603,3604,3605],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[3598,3599,3600,3604,3605,3606]],
[[201,49,-33],[206,49,-15],[207,39,-35,],0xFFFFFF,[3598,3599,3600,3604,3605,3606],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[3600,3601,3606,3607,3608,3634]],
[[206,49,-15],[212,39,-16],[207,39,-35,],0xFFFFFF,[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[3601,3607,3608,3609,3634,3635],[3600,3601,3606,3607,3608,3634]],
[[176,60,-24],[179,60,-10],[193,55,-30,],0xFFFFFF,[3596,3602],[3596,3597,3602,3603],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[179,60,-10],[197,55,-14],[193,55,-30,],0xFFFFFF,[3596,3597,3602,3603],[3597,3598,3599,3603,3604,3605],[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604]],
[[193,55,-30],[197,55,-14],[201,49,-33,],0xFFFFFF,[1650,1651,1652,1656,1657,1658,3596,3597,3598,3602,3603,3604],[3597,3598,3599,3603,3604,3605],[3598,3599,3600,3604,3605,3606]],
[[197,55,-14],[206,49,-15],[201,49,-33,],0xFFFFFF,[3597,3598,3599,3603,3604,3605],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[3598,3599,3600,3604,3605,3606]],
[[201,49,-33],[206,49,-15],[207,39,-35,],0xFFFFFF,[3598,3599,3600,3604,3605,3606],[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[3600,3601,3606,3607,3608,3634]],
[[206,49,-15],[212,39,-16],[207,39,-35,],0xFFFFFF,[1653,1654,1655,1659,1660,1661,3599,3600,3601,3605,3606,3607],[3601,3607,3608,3609,3634,3635],[3600,3601,3606,3607,3608,3634]],
[[207,39,-35],[212,39,-16],[210,29,-36,],0xFFFFFF,[3600,3601,3606,3607,3608,3634],[3601,3607,3608,3609,3634,3635],[3608,3609,3610,3634,3635,3636]],
[[212,39,-16],[215,29,-17],[210,29,-36,],0xFFFFFF,[3601,3607,3608,3609,3634,3635],[3609,3610,3611,3635,3636,3637],[3608,3609,3610,3634,3635,3636]],
[[210,29,-36],[215,29,-17],[212,19,-36,],0xFFFFFF,[3608,3609,3610,3634,3635,3636],[3609,3610,3611,3635,3636,3637],[3610,3611,3612,3636,3637,3638]],
[[215,29,-17],[217,19,-17],[212,19,-36,],0xFFFFFF,[3609,3610,3611,3635,3636,3637],[3611,3612,3613,3637,3638,3639],[3610,3611,3612,3636,3637,3638]],
[[212,19,-36],[217,19,-17],[214,9,-37,],0xFFFFFF,[3610,3611,3612,3636,3637,3638],[3611,3612,3613,3637,3638,3639],[3612,3613,3614,3638,3639,3640]],
[[217,19,-17],[219,9,-17],[214,9,-37,],0xFFFFFF,[3611,3612,3613,3637,3638,3639],[3613,3614,3615,3639,3640,3641],[3612,3613,3614,3638,3639,3640]],
[[214,9,-37],[219,9,-17],[216,-1,-37,],0xFFFFFF,[3612,3613,3614,3638,3639,3640],[3613,3614,3615,3639,3640,3641],[3614,3615,3616,3640,3641,3642]],
[[219,9,-17],[220,-1,-18],[216,-1,-37,],0xFFFFFF,[3613,3614,3615,3639,3640,3641],[3615,3616,3617,3641,3642,3643],[3614,3615,3616,3640,3641,3642]],
[[216,-1,-37],[220,-1,-18],[217,-11,-38,],0xFFFFFF,[3614,3615,3616,3640,3641,3642],[3615,3616,3617,3641,3642,3643],[3616,3617,3618,3642,3643,3644]],
[[220,-1,-18],[222,-11,-18],[217,-11,-38,],0xFFFFFF,[3615,3616,3617,3641,3642,3643],[3617,3618,3619,3643,3644,3645],[3616,3617,3618,3642,3643,3644]],
[[217,-11,-38],[222,-11,-18],[217,-21,-38,],0xFFFFFF,[3616,3617,3618,3642,3643,3644],[3617,3618,3619,3643,3644,3645],[3618,3619,3620,3644,3645,3646]],
[[222,-11,-18],[222,-21,-18],[217,-21,-38,],0xFFFFFF,[3617,3618,3619,3643,3644,3645],[3619,3620,3621,3645,3646,3647],[3618,3619,3620,3644,3645,3646]],
[[217,-21,-38],[222,-21,-18],[218,-31,-38,],0xFFFFFF,[3618,3619,3620,3644,3645,3646],[3619,3620,3621,3645,3646,3647],[3620,3621,3622,3646,3647,3648]],
[[222,-21,-18],[223,-31,-18],[218,-31,-38,],0xFFFFFF,[3619,3620,3621,3645,3646,3647],[3621,3622,3623,3647,3648,3649],[3620,3621,3622,3646,3647,3648]],
[[218,-31,-38],[223,-31,-18],[217,-41,-38,],0xFFFFFF,[3620,3621,3622,3646,3647,3648],[3621,3622,3623,3647,3648,3649],[3622,3623,3624,3648,3649,3650]],
[[223,-31,-18],[222,-41,-18],[217,-41,-38,],0xFFFFFF,[3621,3622,3623,3647,3648,3649],[3623,3624,3625,3649,3650,3651],[3622,3623,3624,3648,3649,3650]],
[[217,-41,-38],[222,-41,-18],[217,-51,-38,],0xFFFFFF,[3622,3623,3624,3648,3649,3650],[3623,3624,3625,3649,3650,3651],[3624,3625,3626,3650,3651,3652]],
[[222,-41,-18],[222,-51,-18],[217,-51,-38,],0xFFFFFF,[3623,3624,3625,3649,3650,3651],[3625,3626,3627,3651,3652,3653],[3624,3625,3626,3650,3651,3652]],
[[217,-51,-38],[222,-51,-18],[216,-61,-38,],0xFFFFFF,[3624,3625,3626,3650,3651,3652],[3625,3626,3627,3651,3652,3653],[3626,3627,3628,3652,3653,3654]],
[[222,-51,-18],[221,-61,-18],[216,-61,-38,],0xFFFFFF,[3625,3626,3627,3651,3652,3653],[3627,3628,3629,3653,3654,3655],[3626,3627,3628,3652,3653,3654]],
[[216,-61,-38],[221,-61,-18],[214,-71,-37,],0xFFFFFF,[3626,3627,3628,3652,3653,3654],[3627,3628,3629,3653,3654,3655],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[221,-61,-18],[219,-71,-17],[214,-71,-37,],0xFFFFFF,[3627,3628,3629,3653,3654,3655],[3629,3630,3631,3655,3656,3657],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[214,-71,-37],[219,-71,-17],[212,-81,-36,],0xFFFFFF,[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[3629,3630,3631,3655,3656,3657],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658]],
[[219,-71,-17],[217,-81,-17],[212,-81,-36,],0xFFFFFF,[3629,3630,3631,3655,3656,3657],[3631,3632,3633,3657,3658,3659],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658]],
[[212,-81,-36],[217,-81,-17],[209,-91,-35,],0xFFFFFF,[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[3631,3632,3633,3657,3658,3659],[3632,3633,3658,3659]],
[[217,-81,-17],[213,-91,-17],[209,-91,-35,],0xFFFFFF,[3631,3632,3633,3657,3658,3659],[3633,3659],[3632,3633,3658,3659]],
[[207,39,-35],[212,39,-16],[210,29,-36,],0xFFFFFF,[3600,3601,3606,3607,3608,3634],[3601,3607,3608,3609,3634,3635],[3608,3609,3610,3634,3635,3636]],
[[212,39,-16],[215,29,-17],[210,29,-36,],0xFFFFFF,[3601,3607,3608,3609,3634,3635],[3609,3610,3611,3635,3636,3637],[3608,3609,3610,3634,3635,3636]],
[[210,29,-36],[215,29,-17],[212,19,-36,],0xFFFFFF,[3608,3609,3610,3634,3635,3636],[3609,3610,3611,3635,3636,3637],[3610,3611,3612,3636,3637,3638]],
[[215,29,-17],[217,19,-17],[212,19,-36,],0xFFFFFF,[3609,3610,3611,3635,3636,3637],[3611,3612,3613,3637,3638,3639],[3610,3611,3612,3636,3637,3638]],
[[212,19,-36],[217,19,-17],[214,9,-37,],0xFFFFFF,[3610,3611,3612,3636,3637,3638],[3611,3612,3613,3637,3638,3639],[3612,3613,3614,3638,3639,3640]],
[[217,19,-17],[219,9,-17],[214,9,-37,],0xFFFFFF,[3611,3612,3613,3637,3638,3639],[3613,3614,3615,3639,3640,3641],[3612,3613,3614,3638,3639,3640]],
[[214,9,-37],[219,9,-17],[216,-1,-37,],0xFFFFFF,[3612,3613,3614,3638,3639,3640],[3613,3614,3615,3639,3640,3641],[3614,3615,3616,3640,3641,3642]],
[[219,9,-17],[220,-1,-18],[216,-1,-37,],0xFFFFFF,[3613,3614,3615,3639,3640,3641],[3615,3616,3617,3641,3642,3643],[3614,3615,3616,3640,3641,3642]],
[[216,-1,-37],[220,-1,-18],[217,-11,-38,],0xFFFFFF,[3614,3615,3616,3640,3641,3642],[3615,3616,3617,3641,3642,3643],[3616,3617,3618,3642,3643,3644]],
[[220,-1,-18],[222,-11,-18],[217,-11,-38,],0xFFFFFF,[3615,3616,3617,3641,3642,3643],[3617,3618,3619,3643,3644,3645],[3616,3617,3618,3642,3643,3644]],
[[217,-11,-38],[222,-11,-18],[217,-21,-38,],0xFFFFFF,[3616,3617,3618,3642,3643,3644],[3617,3618,3619,3643,3644,3645],[3618,3619,3620,3644,3645,3646]],
[[222,-11,-18],[222,-21,-18],[217,-21,-38,],0xFFFFFF,[3617,3618,3619,3643,3644,3645],[3619,3620,3621,3645,3646,3647],[3618,3619,3620,3644,3645,3646]],
[[217,-21,-38],[222,-21,-18],[218,-31,-38,],0xFFFFFF,[3618,3619,3620,3644,3645,3646],[3619,3620,3621,3645,3646,3647],[3620,3621,3622,3646,3647,3648]],
[[222,-21,-18],[223,-31,-18],[218,-31,-38,],0xFFFFFF,[3619,3620,3621,3645,3646,3647],[3621,3622,3623,3647,3648,3649],[3620,3621,3622,3646,3647,3648]],
[[218,-31,-38],[223,-31,-18],[217,-41,-38,],0xFFFFFF,[3620,3621,3622,3646,3647,3648],[3621,3622,3623,3647,3648,3649],[3622,3623,3624,3648,3649,3650]],
[[223,-31,-18],[222,-41,-18],[217,-41,-38,],0xFFFFFF,[3621,3622,3623,3647,3648,3649],[3623,3624,3625,3649,3650,3651],[3622,3623,3624,3648,3649,3650]],
[[217,-41,-38],[222,-41,-18],[217,-51,-38,],0xFFFFFF,[3622,3623,3624,3648,3649,3650],[3623,3624,3625,3649,3650,3651],[3624,3625,3626,3650,3651,3652]],
[[222,-41,-18],[222,-51,-18],[217,-51,-38,],0xFFFFFF,[3623,3624,3625,3649,3650,3651],[3625,3626,3627,3651,3652,3653],[3624,3625,3626,3650,3651,3652]],
[[217,-51,-38],[222,-51,-18],[216,-61,-38,],0xFFFFFF,[3624,3625,3626,3650,3651,3652],[3625,3626,3627,3651,3652,3653],[3626,3627,3628,3652,3653,3654]],
[[222,-51,-18],[221,-61,-18],[216,-61,-38,],0xFFFFFF,[3625,3626,3627,3651,3652,3653],[3627,3628,3629,3653,3654,3655],[3626,3627,3628,3652,3653,3654]],
[[216,-61,-38],[221,-61,-18],[214,-71,-37,],0xFFFFFF,[3626,3627,3628,3652,3653,3654],[3627,3628,3629,3653,3654,3655],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[221,-61,-18],[219,-71,-17],[214,-71,-37,],0xFFFFFF,[3627,3628,3629,3653,3654,3655],[3629,3630,3631,3655,3656,3657],[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656]],
[[214,-71,-37],[219,-71,-17],[212,-81,-36,],0xFFFFFF,[1700,1701,1702,1708,1709,1710,2365,2366,2367,2658,2659,2660,3628,3629,3630,3654,3655,3656],[3629,3630,3631,3655,3656,3657],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658]],
[[219,-71,-17],[217,-81,-17],[212,-81,-36,],0xFFFFFF,[3629,3630,3631,3655,3656,3657],[3631,3632,3633,3657,3658,3659],[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658]],
[[212,-81,-36],[217,-81,-17],[209,-91,-35,],0xFFFFFF,[2367,2368,2369,2660,2661,2662,3630,3631,3632,3656,3657,3658],[3631,3632,3633,3657,3658,3659],[3632,3633,3658,3659]],
[[217,-81,-17],[213,-91,-17],[209,-91,-35,],0xFFFFFF,[3631,3632,3633,3657,3658,3659],[3633,3659],[3632,3633,3658,3659]],
[[179,60,-11],[180,60,2],[197,55,-14,],0xFFFFFF,[3660,3666],[3660,3661,3666,3667],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[180,60,2],[198,55,1],[197,55,-14,],0xFFFFFF,[3660,3661,3666,3667],[3661,3662,3663,3667,3668,3669],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[197,55,-14],[198,55,1],[206,49,-15,],0xFFFFFF,[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668],[3661,3662,3663,3667,3668,3669],[3662,3663,3664,3668,3669,3670]],
[[198,55,1],[207,49,1],[206,49,-15,],0xFFFFFF,[3661,3662,3663,3667,3668,3669],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[3662,3663,3664,3668,3669,3670]],
[[206,49,-15],[207,49,1],[212,39,-16,],0xFFFFFF,[3662,3663,3664,3668,3669,3670],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[3664,3665,3670,3671,3672,3698]],
[[207,49,1],[213,39,1],[212,39,-16,],0xFFFFFF,[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[3665,3671,3672,3673,3698,3699],[3664,3665,3670,3671,3672,3698]],
[[179,60,-11],[180,60,2],[197,55,-14,],0xFFFFFF,[3660,3666],[3660,3661,3666,3667],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[180,60,2],[198,55,1],[197,55,-14,],0xFFFFFF,[3660,3661,3666,3667],[3661,3662,3663,3667,3668,3669],[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668]],
[[197,55,-14],[198,55,1],[206,49,-15,],0xFFFFFF,[1714,1715,1716,1720,1721,1722,3660,3661,3662,3666,3667,3668],[3661,3662,3663,3667,3668,3669],[3662,3663,3664,3668,3669,3670]],
[[198,55,1],[207,49,1],[206,49,-15,],0xFFFFFF,[3661,3662,3663,3667,3668,3669],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[3662,3663,3664,3668,3669,3670]],
[[206,49,-15],[207,49,1],[212,39,-16,],0xFFFFFF,[3662,3663,3664,3668,3669,3670],[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[3664,3665,3670,3671,3672,3698]],
[[207,49,1],[213,39,1],[212,39,-16,],0xFFFFFF,[1717,1718,1719,1723,1724,1725,3663,3664,3665,3669,3670,3671],[3665,3671,3672,3673,3698,3699],[3664,3665,3670,3671,3672,3698]],
[[212,39,-16],[213,39,1],[215,29,-17,],0xFFFFFF,[3664,3665,3670,3671,3672,3698],[3665,3671,3672,3673,3698,3699],[3672,3673,3674,3698,3699,3700]],
[[213,39,1],[216,29,1],[215,29,-17,],0xFFFFFF,[3665,3671,3672,3673,3698,3699],[3673,3674,3675,3699,3700,3701],[3672,3673,3674,3698,3699,3700]],
[[215,29,-17],[216,29,1],[217,19,-17,],0xFFFFFF,[3672,3673,3674,3698,3699,3700],[3673,3674,3675,3699,3700,3701],[3674,3675,3676,3700,3701,3702]],
[[216,29,1],[218,19,1],[217,19,-17,],0xFFFFFF,[3673,3674,3675,3699,3700,3701],[3675,3676,3677,3701,3702,3703],[3674,3675,3676,3700,3701,3702]],
[[217,19,-17],[218,19,1],[219,9,-17,],0xFFFFFF,[3674,3675,3676,3700,3701,3702],[3675,3676,3677,3701,3702,3703],[3676,3677,3678,3702,3703,3704]],
[[218,19,1],[220,9,2],[219,9,-17,],0xFFFFFF,[3675,3676,3677,3701,3702,3703],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3676,3677,3678,3702,3703,3704]],
[[219,9,-17],[220,9,2],[220,-1,-18,],0xFFFFFF,[3676,3677,3678,3702,3703,3704],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3678,3679,3680,3704,3705,3706]],
[[220,9,2],[222,-1,2],[220,-1,-18,],0xFFFFFF,[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3679,3680,3681,3705,3706,3707],[3678,3679,3680,3704,3705,3706]],
[[220,-1,-18],[222,-1,2],[222,-11,-18,],0xFFFFFF,[3678,3679,3680,3704,3705,3706],[3679,3680,3681,3705,3706,3707],[3680,3681,3682,3706,3707,3708]],
[[222,-1,2],[223,-11,2],[222,-11,-18,],0xFFFFFF,[3679,3680,3681,3705,3706,3707],[3681,3682,3683,3707,3708,3709],[3680,3681,3682,3706,3707,3708]],
[[222,-11,-18],[223,-11,2],[222,-21,-18,],0xFFFFFF,[3680,3681,3682,3706,3707,3708],[3681,3682,3683,3707,3708,3709],[3682,3683,3684,3708,3709,3710]],
[[223,-11,2],[224,-21,2],[222,-21,-18,],0xFFFFFF,[3681,3682,3683,3707,3708,3709],[3683,3684,3685,3709,3710,3711],[3682,3683,3684,3708,3709,3710]],
[[222,-21,-18],[224,-21,2],[223,-31,-18,],0xFFFFFF,[3682,3683,3684,3708,3709,3710],[3683,3684,3685,3709,3710,3711],[3684,3685,3686,3710,3711,3712]],
[[224,-21,2],[224,-31,2],[223,-31,-18,],0xFFFFFF,[3683,3684,3685,3709,3710,3711],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[3684,3685,3686,3710,3711,3712]],
[[223,-31,-18],[224,-31,2],[222,-41,-18,],0xFFFFFF,[3684,3685,3686,3710,3711,3712],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[3686,3687,3688,3712,3713,3714]],
[[224,-31,2],[224,-41,2],[222,-41,-18,],0xFFFFFF,[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[3687,3688,3689,3713,3714,3715],[3686,3687,3688,3712,3713,3714]],
[[222,-41,-18],[224,-41,2],[222,-51,-18,],0xFFFFFF,[3686,3687,3688,3712,3713,3714],[3687,3688,3689,3713,3714,3715],[3688,3689,3690,3714,3715,3716]],
[[224,-41,2],[223,-51,2],[222,-51,-18,],0xFFFFFF,[3687,3688,3689,3713,3714,3715],[3689,3690,3691,3715,3716,3717],[3688,3689,3690,3714,3715,3716]],
[[222,-51,-18],[223,-51,2],[221,-61,-18,],0xFFFFFF,[3688,3689,3690,3714,3715,3716],[3689,3690,3691,3715,3716,3717],[3690,3691,3692,3716,3717,3718]],
[[223,-51,2],[222,-61,2],[221,-61,-18,],0xFFFFFF,[3689,3690,3691,3715,3716,3717],[3691,3692,3693,3717,3718,3719],[3690,3691,3692,3716,3717,3718]],
[[221,-61,-18],[222,-61,2],[219,-71,-17,],0xFFFFFF,[3690,3691,3692,3716,3717,3718],[3691,3692,3693,3717,3718,3719],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[222,-61,2],[220,-71,2],[219,-71,-17,],0xFFFFFF,[3691,3692,3693,3717,3718,3719],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[219,-71,-17],[220,-71,2],[217,-81,-17,],0xFFFFFF,[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[3694,3695,3696,3720,3721,3722]],
[[220,-71,2],[218,-81,1],[217,-81,-17,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[3695,3696,3697,3721,3722,3723],[3694,3695,3696,3720,3721,3722]],
[[217,-81,-17],[218,-81,1],[213,-91,-17,],0xFFFFFF,[3694,3695,3696,3720,3721,3722],[3695,3696,3697,3721,3722,3723],[3696,3697,3722,3723]],
[[218,-81,1],[215,-91,1],[213,-91,-17,],0xFFFFFF,[3695,3696,3697,3721,3722,3723],[3697,3723],[3696,3697,3722,3723]],
[[212,39,-16],[213,39,1],[215,29,-17,],0xFFFFFF,[3664,3665,3670,3671,3672,3698],[3665,3671,3672,3673,3698,3699],[3672,3673,3674,3698,3699,3700]],
[[213,39,1],[216,29,1],[215,29,-17,],0xFFFFFF,[3665,3671,3672,3673,3698,3699],[3673,3674,3675,3699,3700,3701],[3672,3673,3674,3698,3699,3700]],
[[215,29,-17],[216,29,1],[217,19,-17,],0xFFFFFF,[3672,3673,3674,3698,3699,3700],[3673,3674,3675,3699,3700,3701],[3674,3675,3676,3700,3701,3702]],
[[216,29,1],[218,19,1],[217,19,-17,],0xFFFFFF,[3673,3674,3675,3699,3700,3701],[3675,3676,3677,3701,3702,3703],[3674,3675,3676,3700,3701,3702]],
[[217,19,-17],[218,19,1],[219,9,-17,],0xFFFFFF,[3674,3675,3676,3700,3701,3702],[3675,3676,3677,3701,3702,3703],[3676,3677,3678,3702,3703,3704]],
[[218,19,1],[220,9,2],[219,9,-17,],0xFFFFFF,[3675,3676,3677,3701,3702,3703],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3676,3677,3678,3702,3703,3704]],
[[219,9,-17],[220,9,2],[220,-1,-18,],0xFFFFFF,[3676,3677,3678,3702,3703,3704],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3678,3679,3680,3704,3705,3706]],
[[220,9,2],[222,-1,2],[220,-1,-18,],0xFFFFFF,[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3679,3680,3681,3705,3706,3707],[3678,3679,3680,3704,3705,3706]],
[[220,-1,-18],[222,-1,2],[222,-11,-18,],0xFFFFFF,[3678,3679,3680,3704,3705,3706],[3679,3680,3681,3705,3706,3707],[3680,3681,3682,3706,3707,3708]],
[[222,-1,2],[223,-11,2],[222,-11,-18,],0xFFFFFF,[3679,3680,3681,3705,3706,3707],[3681,3682,3683,3707,3708,3709],[3680,3681,3682,3706,3707,3708]],
[[222,-11,-18],[223,-11,2],[222,-21,-18,],0xFFFFFF,[3680,3681,3682,3706,3707,3708],[3681,3682,3683,3707,3708,3709],[3682,3683,3684,3708,3709,3710]],
[[223,-11,2],[224,-21,2],[222,-21,-18,],0xFFFFFF,[3681,3682,3683,3707,3708,3709],[3683,3684,3685,3709,3710,3711],[3682,3683,3684,3708,3709,3710]],
[[222,-21,-18],[224,-21,2],[223,-31,-18,],0xFFFFFF,[3682,3683,3684,3708,3709,3710],[3683,3684,3685,3709,3710,3711],[3684,3685,3686,3710,3711,3712]],
[[224,-21,2],[224,-31,2],[223,-31,-18,],0xFFFFFF,[3683,3684,3685,3709,3710,3711],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[3684,3685,3686,3710,3711,3712]],
[[223,-31,-18],[224,-31,2],[222,-41,-18,],0xFFFFFF,[3684,3685,3686,3710,3711,3712],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[3686,3687,3688,3712,3713,3714]],
[[224,-31,2],[224,-41,2],[222,-41,-18,],0xFFFFFF,[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[3687,3688,3689,3713,3714,3715],[3686,3687,3688,3712,3713,3714]],
[[222,-41,-18],[224,-41,2],[222,-51,-18,],0xFFFFFF,[3686,3687,3688,3712,3713,3714],[3687,3688,3689,3713,3714,3715],[3688,3689,3690,3714,3715,3716]],
[[224,-41,2],[223,-51,2],[222,-51,-18,],0xFFFFFF,[3687,3688,3689,3713,3714,3715],[3689,3690,3691,3715,3716,3717],[3688,3689,3690,3714,3715,3716]],
[[222,-51,-18],[223,-51,2],[221,-61,-18,],0xFFFFFF,[3688,3689,3690,3714,3715,3716],[3689,3690,3691,3715,3716,3717],[3690,3691,3692,3716,3717,3718]],
[[223,-51,2],[222,-61,2],[221,-61,-18,],0xFFFFFF,[3689,3690,3691,3715,3716,3717],[3691,3692,3693,3717,3718,3719],[3690,3691,3692,3716,3717,3718]],
[[221,-61,-18],[222,-61,2],[219,-71,-17,],0xFFFFFF,[3690,3691,3692,3716,3717,3718],[3691,3692,3693,3717,3718,3719],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[222,-61,2],[220,-71,2],[219,-71,-17,],0xFFFFFF,[3691,3692,3693,3717,3718,3719],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720]],
[[219,-71,-17],[220,-71,2],[217,-81,-17,],0xFFFFFF,[1764,1765,1766,1772,1773,1774,3692,3693,3694,3718,3719,3720],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[3694,3695,3696,3720,3721,3722]],
[[220,-71,2],[218,-81,1],[217,-81,-17,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[3695,3696,3697,3721,3722,3723],[3694,3695,3696,3720,3721,3722]],
[[217,-81,-17],[218,-81,1],[213,-91,-17,],0xFFFFFF,[3694,3695,3696,3720,3721,3722],[3695,3696,3697,3721,3722,3723],[3696,3697,3722,3723]],
[[218,-81,1],[215,-91,1],[213,-91,-17,],0xFFFFFF,[3695,3696,3697,3721,3722,3723],[3697,3723],[3696,3697,3722,3723]],
[[180,60,1],[178,60,15],[198,55,1,],0xFFFFFF,[3724,3730],[3724,3725,3730,3731],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[178,60,15],[197,55,17],[198,55,1,],0xFFFFFF,[3724,3725,3730,3731],[3725,3726,3727,3731,3732,3733],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[198,55,1],[197,55,17],[207,49,1,],0xFFFFFF,[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732],[3725,3726,3727,3731,3732,3733],[3726,3727,3728,3732,3733,3734]],
[[197,55,17],[205,49,19],[207,49,1,],0xFFFFFF,[3725,3726,3727,3731,3732,3733],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[3726,3727,3728,3732,3733,3734]],
[[207,49,1],[205,49,19],[213,39,1,],0xFFFFFF,[3726,3727,3728,3732,3733,3734],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[3728,3729,3734,3735,3736,3762]],
[[205,49,19],[211,39,20],[213,39,1,],0xFFFFFF,[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[3729,3735,3736,3737,3762,3763],[3728,3729,3734,3735,3736,3762]],
[[180,60,1],[178,60,15],[198,55,1,],0xFFFFFF,[3724,3730],[3724,3725,3730,3731],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[178,60,15],[197,55,17],[198,55,1,],0xFFFFFF,[3724,3725,3730,3731],[3725,3726,3727,3731,3732,3733],[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732]],
[[198,55,1],[197,55,17],[207,49,1,],0xFFFFFF,[1778,1779,1780,1784,1785,1786,3724,3725,3726,3730,3731,3732],[3725,3726,3727,3731,3732,3733],[3726,3727,3728,3732,3733,3734]],
[[197,55,17],[205,49,19],[207,49,1,],0xFFFFFF,[3725,3726,3727,3731,3732,3733],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[3726,3727,3728,3732,3733,3734]],
[[207,49,1],[205,49,19],[213,39,1,],0xFFFFFF,[3726,3727,3728,3732,3733,3734],[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[3728,3729,3734,3735,3736,3762]],
[[205,49,19],[211,39,20],[213,39,1,],0xFFFFFF,[1781,1782,1783,1787,1788,1789,3727,3728,3729,3733,3734,3735],[3729,3735,3736,3737,3762,3763],[3728,3729,3734,3735,3736,3762]],
[[213,39,1],[211,39,20],[216,29,1,],0xFFFFFF,[3728,3729,3734,3735,3736,3762],[3729,3735,3736,3737,3762,3763],[3736,3737,3738,3762,3763,3764]],
[[211,39,20],[214,29,21],[216,29,1,],0xFFFFFF,[3729,3735,3736,3737,3762,3763],[3737,3738,3739,3763,3764,3765],[3736,3737,3738,3762,3763,3764]],
[[216,29,1],[214,29,21],[218,19,1,],0xFFFFFF,[3736,3737,3738,3762,3763,3764],[3737,3738,3739,3763,3764,3765],[3738,3739,3740,3764,3765,3766]],
[[214,29,21],[216,19,21],[218,19,1,],0xFFFFFF,[3737,3738,3739,3763,3764,3765],[3739,3740,3741,3765,3766,3767],[3738,3739,3740,3764,3765,3766]],
[[218,19,1],[216,19,21],[220,9,2,],0xFFFFFF,[3738,3739,3740,3764,3765,3766],[3739,3740,3741,3765,3766,3767],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768]],
[[216,19,21],[218,9,21],[220,9,2,],0xFFFFFF,[3739,3740,3741,3765,3766,3767],[3741,3742,3743,3767,3768,3769],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768]],
[[220,9,2],[218,9,21],[222,-1,2,],0xFFFFFF,[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3741,3742,3743,3767,3768,3769],[3742,3743,3744,3768,3769,3770]],
[[218,9,21],[220,-1,22],[222,-1,2,],0xFFFFFF,[3741,3742,3743,3767,3768,3769],[3743,3744,3745,3769,3770,3771],[3742,3743,3744,3768,3769,3770]],
[[222,-1,2],[220,-1,22],[223,-11,2,],0xFFFFFF,[3742,3743,3744,3768,3769,3770],[3743,3744,3745,3769,3770,3771],[3744,3745,3746,3770,3771,3772]],
[[220,-1,22],[221,-11,22],[223,-11,2,],0xFFFFFF,[3743,3744,3745,3769,3770,3771],[3745,3746,3747,3771,3772,3773],[3744,3745,3746,3770,3771,3772]],
[[223,-11,2],[221,-11,22],[224,-21,2,],0xFFFFFF,[3744,3745,3746,3770,3771,3772],[3745,3746,3747,3771,3772,3773],[3746,3747,3748,3772,3773,3774]],
[[221,-11,22],[222,-21,22],[224,-21,2,],0xFFFFFF,[3745,3746,3747,3771,3772,3773],[3747,3748,3749,3773,3774,3775],[3746,3747,3748,3772,3773,3774]],
[[224,-21,2],[222,-21,22],[224,-31,2,],0xFFFFFF,[3746,3747,3748,3772,3773,3774],[3747,3748,3749,3773,3774,3775],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776]],
[[222,-21,22],[222,-31,22],[224,-31,2,],0xFFFFFF,[3747,3748,3749,3773,3774,3775],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776]],
[[224,-31,2],[222,-31,22],[224,-41,2,],0xFFFFFF,[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[3750,3751,3752,3776,3777,3778]],
[[222,-31,22],[222,-41,22],[224,-41,2,],0xFFFFFF,[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[3751,3752,3753,3777,3778,3779],[3750,3751,3752,3776,3777,3778]],
[[224,-41,2],[222,-41,22],[223,-51,2,],0xFFFFFF,[3750,3751,3752,3776,3777,3778],[3751,3752,3753,3777,3778,3779],[3752,3753,3754,3778,3779,3780]],
[[222,-41,22],[221,-51,22],[223,-51,2,],0xFFFFFF,[3751,3752,3753,3777,3778,3779],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[3752,3753,3754,3778,3779,3780]],
[[223,-51,2],[221,-51,22],[222,-61,2,],0xFFFFFF,[3752,3753,3754,3778,3779,3780],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[3754,3755,3756,3780,3781,3782]],
[[221,-51,22],[220,-61,22],[222,-61,2,],0xFFFFFF,[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[3755,3756,3757,3781,3782,3783],[3754,3755,3756,3780,3781,3782]],
[[222,-61,2],[220,-61,22],[220,-71,2,],0xFFFFFF,[3754,3755,3756,3780,3781,3782],[3755,3756,3757,3781,3782,3783],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-61,22],[218,-71,21],[220,-71,2,],0xFFFFFF,[3755,3756,3757,3781,3782,3783],[3757,3758,3759,3783,3784,3785],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-71,2],[218,-71,21],[218,-81,1,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[3757,3758,3759,3783,3784,3785],[3758,3759,3760,3784,3785,3786]],
[[218,-71,21],[216,-81,21],[218,-81,1,],0xFFFFFF,[3757,3758,3759,3783,3784,3785],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3758,3759,3760,3784,3785,3786]],
[[218,-81,1],[216,-81,21],[215,-91,1,],0xFFFFFF,[3758,3759,3760,3784,3785,3786],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3760,3761,3786,3787]],
[[216,-81,21],[213,-91,20],[215,-91,1,],0xFFFFFF,[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3761,3787],[3760,3761,3786,3787]],
[[213,39,1],[211,39,20],[216,29,1,],0xFFFFFF,[3728,3729,3734,3735,3736,3762],[3729,3735,3736,3737,3762,3763],[3736,3737,3738,3762,3763,3764]],
[[211,39,20],[214,29,21],[216,29,1,],0xFFFFFF,[3729,3735,3736,3737,3762,3763],[3737,3738,3739,3763,3764,3765],[3736,3737,3738,3762,3763,3764]],
[[216,29,1],[214,29,21],[218,19,1,],0xFFFFFF,[3736,3737,3738,3762,3763,3764],[3737,3738,3739,3763,3764,3765],[3738,3739,3740,3764,3765,3766]],
[[214,29,21],[216,19,21],[218,19,1,],0xFFFFFF,[3737,3738,3739,3763,3764,3765],[3739,3740,3741,3765,3766,3767],[3738,3739,3740,3764,3765,3766]],
[[218,19,1],[216,19,21],[220,9,2,],0xFFFFFF,[3738,3739,3740,3764,3765,3766],[3739,3740,3741,3765,3766,3767],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768]],
[[216,19,21],[218,9,21],[220,9,2,],0xFFFFFF,[3739,3740,3741,3765,3766,3767],[3741,3742,3743,3767,3768,3769],[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768]],
[[220,9,2],[218,9,21],[222,-1,2,],0xFFFFFF,[3677,3678,3679,3703,3704,3705,3740,3741,3742,3766,3767,3768],[3741,3742,3743,3767,3768,3769],[3742,3743,3744,3768,3769,3770]],
[[218,9,21],[220,-1,22],[222,-1,2,],0xFFFFFF,[3741,3742,3743,3767,3768,3769],[3743,3744,3745,3769,3770,3771],[3742,3743,3744,3768,3769,3770]],
[[222,-1,2],[220,-1,22],[223,-11,2,],0xFFFFFF,[3742,3743,3744,3768,3769,3770],[3743,3744,3745,3769,3770,3771],[3744,3745,3746,3770,3771,3772]],
[[220,-1,22],[221,-11,22],[223,-11,2,],0xFFFFFF,[3743,3744,3745,3769,3770,3771],[3745,3746,3747,3771,3772,3773],[3744,3745,3746,3770,3771,3772]],
[[223,-11,2],[221,-11,22],[224,-21,2,],0xFFFFFF,[3744,3745,3746,3770,3771,3772],[3745,3746,3747,3771,3772,3773],[3746,3747,3748,3772,3773,3774]],
[[221,-11,22],[222,-21,22],[224,-21,2,],0xFFFFFF,[3745,3746,3747,3771,3772,3773],[3747,3748,3749,3773,3774,3775],[3746,3747,3748,3772,3773,3774]],
[[224,-21,2],[222,-21,22],[224,-31,2,],0xFFFFFF,[3746,3747,3748,3772,3773,3774],[3747,3748,3749,3773,3774,3775],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776]],
[[222,-21,22],[222,-31,22],[224,-31,2,],0xFFFFFF,[3747,3748,3749,3773,3774,3775],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776]],
[[224,-31,2],[222,-31,22],[224,-41,2,],0xFFFFFF,[3685,3686,3687,3711,3712,3713,3748,3749,3750,3774,3775,3776],[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[3750,3751,3752,3776,3777,3778]],
[[222,-31,22],[222,-41,22],[224,-41,2,],0xFFFFFF,[1813,1814,1815,1821,1822,1823,3749,3750,3751,3775,3776,3777],[3751,3752,3753,3777,3778,3779],[3750,3751,3752,3776,3777,3778]],
[[224,-41,2],[222,-41,22],[223,-51,2,],0xFFFFFF,[3750,3751,3752,3776,3777,3778],[3751,3752,3753,3777,3778,3779],[3752,3753,3754,3778,3779,3780]],
[[222,-41,22],[221,-51,22],[223,-51,2,],0xFFFFFF,[3751,3752,3753,3777,3778,3779],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[3752,3753,3754,3778,3779,3780]],
[[223,-51,2],[221,-51,22],[222,-61,2,],0xFFFFFF,[3752,3753,3754,3778,3779,3780],[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[3754,3755,3756,3780,3781,3782]],
[[221,-51,22],[220,-61,22],[222,-61,2,],0xFFFFFF,[1817,1825,1826,1827,1834,1835,3753,3754,3755,3779,3780,3781],[3755,3756,3757,3781,3782,3783],[3754,3755,3756,3780,3781,3782]],
[[222,-61,2],[220,-61,22],[220,-71,2,],0xFFFFFF,[3754,3755,3756,3780,3781,3782],[3755,3756,3757,3781,3782,3783],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-61,22],[218,-71,21],[220,-71,2,],0xFFFFFF,[3755,3756,3757,3781,3782,3783],[3757,3758,3759,3783,3784,3785],[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784]],
[[220,-71,2],[218,-71,21],[218,-81,1,],0xFFFFFF,[1765,1766,1767,1773,1774,1775,1828,1829,1830,1836,1837,1838,3693,3694,3695,3719,3720,3721,3756,3757,3758,3782,3783,3784],[3757,3758,3759,3783,3784,3785],[3758,3759,3760,3784,3785,3786]],
[[218,-71,21],[216,-81,21],[218,-81,1,],0xFFFFFF,[3757,3758,3759,3783,3784,3785],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3758,3759,3760,3784,3785,3786]],
[[218,-81,1],[216,-81,21],[215,-91,1,],0xFFFFFF,[3758,3759,3760,3784,3785,3786],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3760,3761,3786,3787]],
[[216,-81,21],[213,-91,20],[215,-91,1,],0xFFFFFF,[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3761,3787],[3760,3761,3786,3787]],
[[179,60,14],[175,60,28],[197,55,17,],0xFFFFFF,[3788,3794],[3788,3789,3794,3795],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[175,60,28],[192,55,33],[197,55,17,],0xFFFFFF,[3788,3789,3794,3795],[3789,3790,3791,3795,3796,3797],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[197,55,17],[192,55,33],[205,49,19,],0xFFFFFF,[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796],[3789,3790,3791,3795,3796,3797],[3790,3791,3792,3796,3797,3798]],
[[192,55,33],[200,49,36],[205,49,19,],0xFFFFFF,[3789,3790,3791,3795,3796,3797],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[3790,3791,3792,3796,3797,3798]],
[[205,49,19],[200,49,36],[211,39,20,],0xFFFFFF,[3790,3791,3792,3796,3797,3798],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[3792,3793,3798,3799,3800,3826]],
[[200,49,36],[206,39,38],[211,39,20,],0xFFFFFF,[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[3793,3799,3800,3801,3826,3827],[3792,3793,3798,3799,3800,3826]],
[[179,60,14],[175,60,28],[197,55,17,],0xFFFFFF,[3788,3794],[3788,3789,3794,3795],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[175,60,28],[192,55,33],[197,55,17,],0xFFFFFF,[3788,3789,3794,3795],[3789,3790,3791,3795,3796,3797],[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796]],
[[197,55,17],[192,55,33],[205,49,19,],0xFFFFFF,[1842,1843,1844,1848,1849,1850,3788,3789,3790,3794,3795,3796],[3789,3790,3791,3795,3796,3797],[3790,3791,3792,3796,3797,3798]],
[[192,55,33],[200,49,36],[205,49,19,],0xFFFFFF,[3789,3790,3791,3795,3796,3797],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[3790,3791,3792,3796,3797,3798]],
[[205,49,19],[200,49,36],[211,39,20,],0xFFFFFF,[3790,3791,3792,3796,3797,3798],[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[3792,3793,3798,3799,3800,3826]],
[[200,49,36],[206,39,38],[211,39,20,],0xFFFFFF,[1845,1846,1847,1851,1852,1853,3791,3792,3793,3797,3798,3799],[3793,3799,3800,3801,3826,3827],[3792,3793,3798,3799,3800,3826]],
[[211,39,20],[206,39,38],[214,29,21,],0xFFFFFF,[3792,3793,3798,3799,3800,3826],[3793,3799,3800,3801,3826,3827],[3800,3801,3802,3826,3827,3828]],
[[206,39,38],[209,29,39],[214,29,21,],0xFFFFFF,[3793,3799,3800,3801,3826,3827],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3800,3801,3802,3826,3827,3828]],
[[214,29,21],[209,29,39],[216,19,21,],0xFFFFFF,[3800,3801,3802,3826,3827,3828],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3802,3803,3804,3828,3829,3830]],
[[209,29,39],[211,19,40],[216,19,21,],0xFFFFFF,[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3803,3804,3805,3829,3830,3831],[3802,3803,3804,3828,3829,3830]],
[[216,19,21],[211,19,40],[218,9,21,],0xFFFFFF,[3802,3803,3804,3828,3829,3830],[3803,3804,3805,3829,3830,3831],[3804,3805,3806,3830,3831,3832]],
[[211,19,40],[213,9,41],[218,9,21,],0xFFFFFF,[3803,3804,3805,3829,3830,3831],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[3804,3805,3806,3830,3831,3832]],
[[218,9,21],[213,9,41],[220,-1,22,],0xFFFFFF,[3804,3805,3806,3830,3831,3832],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[3806,3807,3808,3832,3833,3834]],
[[213,9,41],[214,-1,41],[220,-1,22,],0xFFFFFF,[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[3807,3808,3809,3833,3834,3835],[3806,3807,3808,3832,3833,3834]],
[[220,-1,22],[214,-1,41],[221,-11,22,],0xFFFFFF,[3806,3807,3808,3832,3833,3834],[3807,3808,3809,3833,3834,3835],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[214,-1,41],[215,-11,42],[221,-11,22,],0xFFFFFF,[3807,3808,3809,3833,3834,3835],[3809,3810,3811,3835,3836,3837],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[221,-11,22],[215,-11,42],[222,-21,22,],0xFFFFFF,[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836],[3809,3810,3811,3835,3836,3837],[3810,3811,3812,3836,3837,3838]],
[[215,-11,42],[216,-21,42],[222,-21,22,],0xFFFFFF,[3809,3810,3811,3835,3836,3837],[3811,3812,3813,3837,3838,3839],[3810,3811,3812,3836,3837,3838]],
[[222,-21,22],[216,-21,42],[222,-31,22,],0xFFFFFF,[3810,3811,3812,3836,3837,3838],[3811,3812,3813,3837,3838,3839],[3812,3813,3814,3838,3839,3840]],
[[216,-21,42],[216,-31,42],[222,-31,22,],0xFFFFFF,[3811,3812,3813,3837,3838,3839],[3813,3814,3815,3839,3840,3841],[3812,3813,3814,3838,3839,3840]],
[[222,-31,22],[216,-31,42],[222,-41,22,],0xFFFFFF,[3812,3813,3814,3838,3839,3840],[3813,3814,3815,3839,3840,3841],[3814,3815,3816,3840,3841,3842]],
[[216,-31,42],[216,-41,42],[222,-41,22,],0xFFFFFF,[3813,3814,3815,3839,3840,3841],[3815,3816,3817,3841,3842,3843],[3814,3815,3816,3840,3841,3842]],
[[222,-41,22],[216,-41,42],[221,-51,22,],0xFFFFFF,[3814,3815,3816,3840,3841,3842],[3815,3816,3817,3841,3842,3843],[3816,3817,3818,3842,3843,3844]],
[[216,-41,42],[216,-51,42],[221,-51,22,],0xFFFFFF,[3815,3816,3817,3841,3842,3843],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[3816,3817,3818,3842,3843,3844]],
[[221,-51,22],[216,-51,42],[220,-61,22,],0xFFFFFF,[3816,3817,3818,3842,3843,3844],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[3818,3819,3820,3844,3845,3846]],
[[216,-51,42],[214,-61,41],[220,-61,22,],0xFFFFFF,[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[3819,3820,3821,3845,3846,3847],[3818,3819,3820,3844,3845,3846]],
[[220,-61,22],[214,-61,41],[218,-71,21,],0xFFFFFF,[3818,3819,3820,3844,3845,3846],[3819,3820,3821,3845,3846,3847],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[214,-61,41],[213,-71,41],[218,-71,21,],0xFFFFFF,[3819,3820,3821,3845,3846,3847],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[218,-71,21],[213,-71,41],[216,-81,21,],0xFFFFFF,[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850]],
[[213,-71,41],[211,-81,40],[216,-81,21,],0xFFFFFF,[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850]],
[[216,-81,21],[211,-81,40],[213,-91,20,],0xFFFFFF,[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3824,3825,3850,3851]],
[[211,-81,40],[207,-91,39],[213,-91,20,],0xFFFFFF,[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3825,3851],[3824,3825,3850,3851]],
[[211,39,20],[206,39,38],[214,29,21,],0xFFFFFF,[3792,3793,3798,3799,3800,3826],[3793,3799,3800,3801,3826,3827],[3800,3801,3802,3826,3827,3828]],
[[206,39,38],[209,29,39],[214,29,21,],0xFFFFFF,[3793,3799,3800,3801,3826,3827],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3800,3801,3802,3826,3827,3828]],
[[214,29,21],[209,29,39],[216,19,21,],0xFFFFFF,[3800,3801,3802,3826,3827,3828],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3802,3803,3804,3828,3829,3830]],
[[209,29,39],[211,19,40],[216,19,21,],0xFFFFFF,[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3803,3804,3805,3829,3830,3831],[3802,3803,3804,3828,3829,3830]],
[[216,19,21],[211,19,40],[218,9,21,],0xFFFFFF,[3802,3803,3804,3828,3829,3830],[3803,3804,3805,3829,3830,3831],[3804,3805,3806,3830,3831,3832]],
[[211,19,40],[213,9,41],[218,9,21,],0xFFFFFF,[3803,3804,3805,3829,3830,3831],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[3804,3805,3806,3830,3831,3832]],
[[218,9,21],[213,9,41],[220,-1,22,],0xFFFFFF,[3804,3805,3806,3830,3831,3832],[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[3806,3807,3808,3832,3833,3834]],
[[213,9,41],[214,-1,41],[220,-1,22,],0xFFFFFF,[1859,1860,1861,1869,1870,1871,3805,3806,3807,3831,3832,3833],[3807,3808,3809,3833,3834,3835],[3806,3807,3808,3832,3833,3834]],
[[220,-1,22],[214,-1,41],[221,-11,22,],0xFFFFFF,[3806,3807,3808,3832,3833,3834],[3807,3808,3809,3833,3834,3835],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[214,-1,41],[215,-11,42],[221,-11,22,],0xFFFFFF,[3807,3808,3809,3833,3834,3835],[3809,3810,3811,3835,3836,3837],[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836]],
[[221,-11,22],[215,-11,42],[222,-21,22,],0xFFFFFF,[1862,1863,1872,1873,1874,1882,3808,3809,3810,3834,3835,3836],[3809,3810,3811,3835,3836,3837],[3810,3811,3812,3836,3837,3838]],
[[215,-11,42],[216,-21,42],[222,-21,22,],0xFFFFFF,[3809,3810,3811,3835,3836,3837],[3811,3812,3813,3837,3838,3839],[3810,3811,3812,3836,3837,3838]],
[[222,-21,22],[216,-21,42],[222,-31,22,],0xFFFFFF,[3810,3811,3812,3836,3837,3838],[3811,3812,3813,3837,3838,3839],[3812,3813,3814,3838,3839,3840]],
[[216,-21,42],[216,-31,42],[222,-31,22,],0xFFFFFF,[3811,3812,3813,3837,3838,3839],[3813,3814,3815,3839,3840,3841],[3812,3813,3814,3838,3839,3840]],
[[222,-31,22],[216,-31,42],[222,-41,22,],0xFFFFFF,[3812,3813,3814,3838,3839,3840],[3813,3814,3815,3839,3840,3841],[3814,3815,3816,3840,3841,3842]],
[[216,-31,42],[216,-41,42],[222,-41,22,],0xFFFFFF,[3813,3814,3815,3839,3840,3841],[3815,3816,3817,3841,3842,3843],[3814,3815,3816,3840,3841,3842]],
[[222,-41,22],[216,-41,42],[221,-51,22,],0xFFFFFF,[3814,3815,3816,3840,3841,3842],[3815,3816,3817,3841,3842,3843],[3816,3817,3818,3842,3843,3844]],
[[216,-41,42],[216,-51,42],[221,-51,22,],0xFFFFFF,[3815,3816,3817,3841,3842,3843],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[3816,3817,3818,3842,3843,3844]],
[[221,-51,22],[216,-51,42],[220,-61,22,],0xFFFFFF,[3816,3817,3818,3842,3843,3844],[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[3818,3819,3820,3844,3845,3846]],
[[216,-51,42],[214,-61,41],[220,-61,22,],0xFFFFFF,[1881,1889,1890,1891,1898,1899,3817,3818,3819,3843,3844,3845],[3819,3820,3821,3845,3846,3847],[3818,3819,3820,3844,3845,3846]],
[[220,-61,22],[214,-61,41],[218,-71,21,],0xFFFFFF,[3818,3819,3820,3844,3845,3846],[3819,3820,3821,3845,3846,3847],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[214,-61,41],[213,-71,41],[218,-71,21,],0xFFFFFF,[3819,3820,3821,3845,3846,3847],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848]],
[[218,-71,21],[213,-71,41],[216,-81,21,],0xFFFFFF,[1892,1893,1894,1900,1901,1902,3820,3821,3822,3846,3847,3848],[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850]],
[[213,-71,41],[211,-81,40],[216,-81,21,],0xFFFFFF,[1893,1894,1895,1901,1902,1903,3821,3822,3823,3847,3848,3849],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850]],
[[216,-81,21],[211,-81,40],[213,-91,20,],0xFFFFFF,[3759,3760,3761,3785,3786,3787,3822,3823,3824,3848,3849,3850],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3824,3825,3850,3851]],
[[211,-81,40],[207,-91,39],[213,-91,20,],0xFFFFFF,[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3825,3851],[3824,3825,3850,3851]],
[[175,60,26],[169,60,39],[192,55,33,],0xFFFFFF,[3852,3858],[3852,3853,3858,3859],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[169,60,39],[185,55,47],[192,55,33,],0xFFFFFF,[3852,3853,3858,3859],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[192,55,33],[185,55,47],[200,49,36,],0xFFFFFF,[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[3854,3855,3856,3860,3861,3862]],
[[185,55,47],[193,49,52],[200,49,36,],0xFFFFFF,[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[3854,3855,3856,3860,3861,3862]],
[[200,49,36],[193,49,52],[206,39,38,],0xFFFFFF,[3854,3855,3856,3860,3861,3862],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[3856,3857,3862,3863,3864,3890]],
[[193,49,52],[198,39,55],[206,39,38,],0xFFFFFF,[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[3857,3863,3864,3865,3890,3891],[3856,3857,3862,3863,3864,3890]],
[[175,60,26],[169,60,39],[192,55,33,],0xFFFFFF,[3852,3858],[3852,3853,3858,3859],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[169,60,39],[185,55,47],[192,55,33,],0xFFFFFF,[3852,3853,3858,3859],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860]],
[[192,55,33],[185,55,47],[200,49,36,],0xFFFFFF,[1906,1907,1908,1912,1913,1914,3852,3853,3854,3858,3859,3860],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[3854,3855,3856,3860,3861,3862]],
[[185,55,47],[193,49,52],[200,49,36,],0xFFFFFF,[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[3854,3855,3856,3860,3861,3862]],
[[200,49,36],[193,49,52],[206,39,38,],0xFFFFFF,[3854,3855,3856,3860,3861,3862],[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[3856,3857,3862,3863,3864,3890]],
[[193,49,52],[198,39,55],[206,39,38,],0xFFFFFF,[1909,1910,1911,1915,1916,1917,3855,3856,3857,3861,3862,3863],[3857,3863,3864,3865,3890,3891],[3856,3857,3862,3863,3864,3890]],
[[206,39,38],[198,39,55],[209,29,39,],0xFFFFFF,[3856,3857,3862,3863,3864,3890],[3857,3863,3864,3865,3890,3891],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892]],
[[198,39,55],[200,29,57],[209,29,39,],0xFFFFFF,[3857,3863,3864,3865,3890,3891],[3865,3866,3867,3891,3892,3893],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892]],
[[209,29,39],[200,29,57],[211,19,40,],0xFFFFFF,[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3865,3866,3867,3891,3892,3893],[3866,3867,3868,3892,3893,3894]],
[[200,29,57],[202,19,58],[211,19,40,],0xFFFFFF,[3865,3866,3867,3891,3892,3893],[3867,3868,3869,3893,3894,3895],[3866,3867,3868,3892,3893,3894]],
[[211,19,40],[202,19,58],[213,9,41,],0xFFFFFF,[3866,3867,3868,3892,3893,3894],[3867,3868,3869,3893,3894,3895],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[202,19,58],[204,9,59],[213,9,41,],0xFFFFFF,[3867,3868,3869,3893,3894,3895],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[213,9,41],[204,9,59],[214,-1,41,],0xFFFFFF,[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[3870,3871,3872,3896,3897,3898]],
[[204,9,59],[205,-1,59],[214,-1,41,],0xFFFFFF,[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[3871,3872,3873,3897,3898,3899],[3870,3871,3872,3896,3897,3898]],
[[214,-1,41],[205,-1,59],[215,-11,42,],0xFFFFFF,[3870,3871,3872,3896,3897,3898],[3871,3872,3873,3897,3898,3899],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[205,-1,59],[206,-11,60],[215,-11,42,],0xFFFFFF,[3871,3872,3873,3897,3898,3899],[3873,3874,3875,3899,3900,3901],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[215,-11,42],[206,-11,60],[216,-21,42,],0xFFFFFF,[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900],[3873,3874,3875,3899,3900,3901],[3874,3875,3876,3900,3901,3902]],
[[206,-11,60],[207,-21,60],[216,-21,42,],0xFFFFFF,[3873,3874,3875,3899,3900,3901],[3875,3876,3877,3901,3902,3903],[3874,3875,3876,3900,3901,3902]],
[[216,-21,42],[207,-21,60],[216,-31,42,],0xFFFFFF,[3874,3875,3876,3900,3901,3902],[3875,3876,3877,3901,3902,3903],[3876,3877,3878,3902,3903,3904]],
[[207,-21,60],[207,-31,61],[216,-31,42,],0xFFFFFF,[3875,3876,3877,3901,3902,3903],[3877,3878,3879,3903,3904,3905],[3876,3877,3878,3902,3903,3904]],
[[216,-31,42],[207,-31,61],[216,-41,42,],0xFFFFFF,[3876,3877,3878,3902,3903,3904],[3877,3878,3879,3903,3904,3905],[3878,3879,3880,3904,3905,3906]],
[[207,-31,61],[207,-41,60],[216,-41,42,],0xFFFFFF,[3877,3878,3879,3903,3904,3905],[3879,3880,3881,3905,3906,3907],[3878,3879,3880,3904,3905,3906]],
[[216,-41,42],[207,-41,60],[216,-51,42,],0xFFFFFF,[3878,3879,3880,3904,3905,3906],[3879,3880,3881,3905,3906,3907],[3880,3881,3882,3906,3907,3908]],
[[207,-41,60],[207,-51,60],[216,-51,42,],0xFFFFFF,[3879,3880,3881,3905,3906,3907],[3881,3882,3883,3907,3908,3909],[3880,3881,3882,3906,3907,3908]],
[[216,-51,42],[207,-51,60],[214,-61,41,],0xFFFFFF,[3880,3881,3882,3906,3907,3908],[3881,3882,3883,3907,3908,3909],[3882,3883,3884,3908,3909,3910]],
[[207,-51,60],[206,-61,60],[214,-61,41,],0xFFFFFF,[3881,3882,3883,3907,3908,3909],[3883,3884,3885,3909,3910,3911],[3882,3883,3884,3908,3909,3910]],
[[214,-61,41],[206,-61,60],[213,-71,41,],0xFFFFFF,[3882,3883,3884,3908,3909,3910],[3883,3884,3885,3909,3910,3911],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[206,-61,60],[204,-71,59],[213,-71,41,],0xFFFFFF,[3883,3884,3885,3909,3910,3911],[3885,3886,3887,3911,3912,3913],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[213,-71,41],[204,-71,59],[211,-81,40,],0xFFFFFF,[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912],[3885,3886,3887,3911,3912,3913],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914]],
[[204,-71,59],[202,-81,57],[211,-81,40,],0xFFFFFF,[3885,3886,3887,3911,3912,3913],[3887,3888,3889,3913,3914,3915],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914]],
[[211,-81,40],[202,-81,57],[207,-91,39,],0xFFFFFF,[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3887,3888,3889,3913,3914,3915],[3888,3889,3914,3915]],
[[202,-81,57],[199,-91,56],[207,-91,39,],0xFFFFFF,[3887,3888,3889,3913,3914,3915],[3889,3915],[3888,3889,3914,3915]],
[[206,39,38],[198,39,55],[209,29,39,],0xFFFFFF,[3856,3857,3862,3863,3864,3890],[3857,3863,3864,3865,3890,3891],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892]],
[[198,39,55],[200,29,57],[209,29,39,],0xFFFFFF,[3857,3863,3864,3865,3890,3891],[3865,3866,3867,3891,3892,3893],[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892]],
[[209,29,39],[200,29,57],[211,19,40,],0xFFFFFF,[1855,1856,1857,1865,1866,1867,3801,3802,3803,3827,3828,3829,3864,3865,3866,3890,3891,3892],[3865,3866,3867,3891,3892,3893],[3866,3867,3868,3892,3893,3894]],
[[200,29,57],[202,19,58],[211,19,40,],0xFFFFFF,[3865,3866,3867,3891,3892,3893],[3867,3868,3869,3893,3894,3895],[3866,3867,3868,3892,3893,3894]],
[[211,19,40],[202,19,58],[213,9,41,],0xFFFFFF,[3866,3867,3868,3892,3893,3894],[3867,3868,3869,3893,3894,3895],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[202,19,58],[204,9,59],[213,9,41,],0xFFFFFF,[3867,3868,3869,3893,3894,3895],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896]],
[[213,9,41],[204,9,59],[214,-1,41,],0xFFFFFF,[1922,1923,1924,1932,1933,1934,3868,3869,3870,3894,3895,3896],[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[3870,3871,3872,3896,3897,3898]],
[[204,9,59],[205,-1,59],[214,-1,41,],0xFFFFFF,[1923,1924,1925,1933,1934,1935,3869,3870,3871,3895,3896,3897],[3871,3872,3873,3897,3898,3899],[3870,3871,3872,3896,3897,3898]],
[[214,-1,41],[205,-1,59],[215,-11,42,],0xFFFFFF,[3870,3871,3872,3896,3897,3898],[3871,3872,3873,3897,3898,3899],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[205,-1,59],[206,-11,60],[215,-11,42,],0xFFFFFF,[3871,3872,3873,3897,3898,3899],[3873,3874,3875,3899,3900,3901],[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900]],
[[215,-11,42],[206,-11,60],[216,-21,42,],0xFFFFFF,[1926,1927,1936,1937,1938,1946,3872,3873,3874,3898,3899,3900],[3873,3874,3875,3899,3900,3901],[3874,3875,3876,3900,3901,3902]],
[[206,-11,60],[207,-21,60],[216,-21,42,],0xFFFFFF,[3873,3874,3875,3899,3900,3901],[3875,3876,3877,3901,3902,3903],[3874,3875,3876,3900,3901,3902]],
[[216,-21,42],[207,-21,60],[216,-31,42,],0xFFFFFF,[3874,3875,3876,3900,3901,3902],[3875,3876,3877,3901,3902,3903],[3876,3877,3878,3902,3903,3904]],
[[207,-21,60],[207,-31,61],[216,-31,42,],0xFFFFFF,[3875,3876,3877,3901,3902,3903],[3877,3878,3879,3903,3904,3905],[3876,3877,3878,3902,3903,3904]],
[[216,-31,42],[207,-31,61],[216,-41,42,],0xFFFFFF,[3876,3877,3878,3902,3903,3904],[3877,3878,3879,3903,3904,3905],[3878,3879,3880,3904,3905,3906]],
[[207,-31,61],[207,-41,60],[216,-41,42,],0xFFFFFF,[3877,3878,3879,3903,3904,3905],[3879,3880,3881,3905,3906,3907],[3878,3879,3880,3904,3905,3906]],
[[216,-41,42],[207,-41,60],[216,-51,42,],0xFFFFFF,[3878,3879,3880,3904,3905,3906],[3879,3880,3881,3905,3906,3907],[3880,3881,3882,3906,3907,3908]],
[[207,-41,60],[207,-51,60],[216,-51,42,],0xFFFFFF,[3879,3880,3881,3905,3906,3907],[3881,3882,3883,3907,3908,3909],[3880,3881,3882,3906,3907,3908]],
[[216,-51,42],[207,-51,60],[214,-61,41,],0xFFFFFF,[3880,3881,3882,3906,3907,3908],[3881,3882,3883,3907,3908,3909],[3882,3883,3884,3908,3909,3910]],
[[207,-51,60],[206,-61,60],[214,-61,41,],0xFFFFFF,[3881,3882,3883,3907,3908,3909],[3883,3884,3885,3909,3910,3911],[3882,3883,3884,3908,3909,3910]],
[[214,-61,41],[206,-61,60],[213,-71,41,],0xFFFFFF,[3882,3883,3884,3908,3909,3910],[3883,3884,3885,3909,3910,3911],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[206,-61,60],[204,-71,59],[213,-71,41,],0xFFFFFF,[3883,3884,3885,3909,3910,3911],[3885,3886,3887,3911,3912,3913],[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912]],
[[213,-71,41],[204,-71,59],[211,-81,40,],0xFFFFFF,[1956,1957,1958,1964,1965,1966,3884,3885,3886,3910,3911,3912],[3885,3886,3887,3911,3912,3913],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914]],
[[204,-71,59],[202,-81,57],[211,-81,40,],0xFFFFFF,[3885,3886,3887,3911,3912,3913],[3887,3888,3889,3913,3914,3915],[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914]],
[[211,-81,40],[202,-81,57],[207,-91,39,],0xFFFFFF,[3823,3824,3825,3849,3850,3851,3886,3887,3888,3912,3913,3914],[3887,3888,3889,3913,3914,3915],[3888,3889,3914,3915]],
[[202,-81,57],[199,-91,56],[207,-91,39,],0xFFFFFF,[3887,3888,3889,3913,3914,3915],[3889,3915],[3888,3889,3914,3915]],
[[169,60,38],[161,60,50],[185,55,47,],0xFFFFFF,[1970,1976,3916,3922],[3916,3917,3922,3923],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[161,60,50],[176,55,60],[185,55,47,],0xFFFFFF,[3916,3917,3922,3923],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[185,55,47],[176,55,60],[193,49,52,],0xFFFFFF,[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[176,55,60],[182,49,66],[193,49,52,],0xFFFFFF,[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[193,49,52],[182,49,66],[198,39,55,],0xFFFFFF,[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[3920,3921,3926,3927,3928,3954]],
[[182,49,66],[187,39,70],[198,39,55,],0xFFFFFF,[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[3921,3927,3928,3929,3954,3955],[3920,3921,3926,3927,3928,3954]],
[[169,60,38],[161,60,50],[185,55,47,],0xFFFFFF,[1970,1976,3916,3922],[3916,3917,3922,3923],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[161,60,50],[176,55,60],[185,55,47,],0xFFFFFF,[3916,3917,3922,3923],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924]],
[[185,55,47],[176,55,60],[193,49,52,],0xFFFFFF,[1970,1971,1972,1976,1977,1978,3853,3854,3855,3859,3860,3861,3916,3917,3918,3922,3923,3924],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[176,55,60],[182,49,66],[193,49,52,],0xFFFFFF,[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926]],
[[193,49,52],[182,49,66],[198,39,55,],0xFFFFFF,[1972,1973,1974,1978,1979,1980,3918,3919,3920,3924,3925,3926],[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[3920,3921,3926,3927,3928,3954]],
[[182,49,66],[187,39,70],[198,39,55,],0xFFFFFF,[1973,1974,1975,1979,1980,1981,3919,3920,3921,3925,3926,3927],[3921,3927,3928,3929,3954,3955],[3920,3921,3926,3927,3928,3954]],
[[198,39,55],[187,39,70],[200,29,57,],0xFFFFFF,[3920,3921,3926,3927,3928,3954],[3921,3927,3928,3929,3954,3955],[3928,3929,3930,3954,3955,3956]],
[[187,39,70],[189,29,72],[200,29,57,],0xFFFFFF,[3921,3927,3928,3929,3954,3955],[3929,3930,3931,3955,3956,3957],[3928,3929,3930,3954,3955,3956]],
[[200,29,57],[189,29,72],[202,19,58,],0xFFFFFF,[3928,3929,3930,3954,3955,3956],[3929,3930,3931,3955,3956,3957],[3930,3931,3932,3956,3957,3958]],
[[189,29,72],[191,19,74],[202,19,58,],0xFFFFFF,[3929,3930,3931,3955,3956,3957],[3931,3932,3933,3957,3958,3959],[3930,3931,3932,3956,3957,3958]],
[[202,19,58],[191,19,74],[204,9,59,],0xFFFFFF,[3930,3931,3932,3956,3957,3958],[3931,3932,3933,3957,3958,3959],[3932,3933,3934,3958,3959,3960]],
[[191,19,74],[192,9,75],[204,9,59,],0xFFFFFF,[3931,3932,3933,3957,3958,3959],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[3932,3933,3934,3958,3959,3960]],
[[204,9,59],[192,9,75],[205,-1,59,],0xFFFFFF,[3932,3933,3934,3958,3959,3960],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[3934,3935,3936,3960,3961,3962]],
[[192,9,75],[193,-1,76],[205,-1,59,],0xFFFFFF,[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3934,3935,3936,3960,3961,3962]],
[[205,-1,59],[193,-1,76],[206,-11,60,],0xFFFFFF,[3934,3935,3936,3960,3961,3962],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3936,3937,3938,3962,3963,3964]],
[[193,-1,76],[194,-11,77],[206,-11,60,],0xFFFFFF,[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3937,3938,3939,3963,3964,3965],[3936,3937,3938,3962,3963,3964]],
[[206,-11,60],[194,-11,77],[207,-21,60,],0xFFFFFF,[3936,3937,3938,3962,3963,3964],[3937,3938,3939,3963,3964,3965],[3938,3939,3940,3964,3965,3966]],
[[194,-11,77],[195,-21,77],[207,-21,60,],0xFFFFFF,[3937,3938,3939,3963,3964,3965],[3939,3940,3941,3965,3966,3967],[3938,3939,3940,3964,3965,3966]],
[[207,-21,60],[195,-21,77],[207,-31,61,],0xFFFFFF,[3938,3939,3940,3964,3965,3966],[3939,3940,3941,3965,3966,3967],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[195,-21,77],[195,-31,77],[207,-31,61,],0xFFFFFF,[3939,3940,3941,3965,3966,3967],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[207,-31,61],[195,-31,77],[207,-41,60,],0xFFFFFF,[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[3942,3943,3944,3968,3969,3970]],
[[195,-31,77],[195,-41,77],[207,-41,60,],0xFFFFFF,[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[3943,3944,3945,3969,3970,3971],[3942,3943,3944,3968,3969,3970]],
[[207,-41,60],[195,-41,77],[207,-51,60,],0xFFFFFF,[3942,3943,3944,3968,3969,3970],[3943,3944,3945,3969,3970,3971],[3944,3945,3946,3970,3971,3972]],
[[195,-41,77],[194,-51,77],[207,-51,60,],0xFFFFFF,[3943,3944,3945,3969,3970,3971],[3945,3946,3947,3971,3972,3973],[3944,3945,3946,3970,3971,3972]],
[[207,-51,60],[194,-51,77],[206,-61,60,],0xFFFFFF,[3944,3945,3946,3970,3971,3972],[3945,3946,3947,3971,3972,3973],[3946,3947,3948,3972,3973,3974]],
[[194,-51,77],[194,-61,76],[206,-61,60,],0xFFFFFF,[3945,3946,3947,3971,3972,3973],[3947,3948,3949,3973,3974,3975],[3946,3947,3948,3972,3973,3974]],
[[206,-61,60],[194,-61,76],[204,-71,59,],0xFFFFFF,[3946,3947,3948,3972,3973,3974],[3947,3948,3949,3973,3974,3975],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[194,-61,76],[192,-71,75],[204,-71,59,],0xFFFFFF,[3947,3948,3949,3973,3974,3975],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[204,-71,59],[192,-71,75],[202,-81,57,],0xFFFFFF,[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[3950,3951,3952,3976,3977,3978]],
[[192,-71,75],[190,-81,73],[202,-81,57,],0xFFFFFF,[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[3950,3951,3952,3976,3977,3978]],
[[202,-81,57],[190,-81,73],[199,-91,56,],0xFFFFFF,[3950,3951,3952,3976,3977,3978],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[3952,3953,3978,3979]],
[[190,-81,73],[188,-91,71],[199,-91,56,],0xFFFFFF,[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[3953,3979],[3952,3953,3978,3979]],
[[198,39,55],[187,39,70],[200,29,57,],0xFFFFFF,[3920,3921,3926,3927,3928,3954],[3921,3927,3928,3929,3954,3955],[3928,3929,3930,3954,3955,3956]],
[[187,39,70],[189,29,72],[200,29,57,],0xFFFFFF,[3921,3927,3928,3929,3954,3955],[3929,3930,3931,3955,3956,3957],[3928,3929,3930,3954,3955,3956]],
[[200,29,57],[189,29,72],[202,19,58,],0xFFFFFF,[3928,3929,3930,3954,3955,3956],[3929,3930,3931,3955,3956,3957],[3930,3931,3932,3956,3957,3958]],
[[189,29,72],[191,19,74],[202,19,58,],0xFFFFFF,[3929,3930,3931,3955,3956,3957],[3931,3932,3933,3957,3958,3959],[3930,3931,3932,3956,3957,3958]],
[[202,19,58],[191,19,74],[204,9,59,],0xFFFFFF,[3930,3931,3932,3956,3957,3958],[3931,3932,3933,3957,3958,3959],[3932,3933,3934,3958,3959,3960]],
[[191,19,74],[192,9,75],[204,9,59,],0xFFFFFF,[3931,3932,3933,3957,3958,3959],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[3932,3933,3934,3958,3959,3960]],
[[204,9,59],[192,9,75],[205,-1,59,],0xFFFFFF,[3932,3933,3934,3958,3959,3960],[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[3934,3935,3936,3960,3961,3962]],
[[192,9,75],[193,-1,76],[205,-1,59,],0xFFFFFF,[2050,2051,2052,2060,2061,2062,3933,3934,3935,3959,3960,3961],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3934,3935,3936,3960,3961,3962]],
[[205,-1,59],[193,-1,76],[206,-11,60,],0xFFFFFF,[3934,3935,3936,3960,3961,3962],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3936,3937,3938,3962,3963,3964]],
[[193,-1,76],[194,-11,77],[206,-11,60,],0xFFFFFF,[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3937,3938,3939,3963,3964,3965],[3936,3937,3938,3962,3963,3964]],
[[206,-11,60],[194,-11,77],[207,-21,60,],0xFFFFFF,[3936,3937,3938,3962,3963,3964],[3937,3938,3939,3963,3964,3965],[3938,3939,3940,3964,3965,3966]],
[[194,-11,77],[195,-21,77],[207,-21,60,],0xFFFFFF,[3937,3938,3939,3963,3964,3965],[3939,3940,3941,3965,3966,3967],[3938,3939,3940,3964,3965,3966]],
[[207,-21,60],[195,-21,77],[207,-31,61,],0xFFFFFF,[3938,3939,3940,3964,3965,3966],[3939,3940,3941,3965,3966,3967],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[195,-21,77],[195,-31,77],[207,-31,61,],0xFFFFFF,[3939,3940,3941,3965,3966,3967],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968]],
[[207,-31,61],[195,-31,77],[207,-41,60,],0xFFFFFF,[2004,2005,2006,2012,2013,2014,3940,3941,3942,3966,3967,3968],[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[3942,3943,3944,3968,3969,3970]],
[[195,-31,77],[195,-41,77],[207,-41,60,],0xFFFFFF,[2005,2006,2007,2013,2014,2015,3941,3942,3943,3967,3968,3969],[3943,3944,3945,3969,3970,3971],[3942,3943,3944,3968,3969,3970]],
[[207,-41,60],[195,-41,77],[207,-51,60,],0xFFFFFF,[3942,3943,3944,3968,3969,3970],[3943,3944,3945,3969,3970,3971],[3944,3945,3946,3970,3971,3972]],
[[195,-41,77],[194,-51,77],[207,-51,60,],0xFFFFFF,[3943,3944,3945,3969,3970,3971],[3945,3946,3947,3971,3972,3973],[3944,3945,3946,3970,3971,3972]],
[[207,-51,60],[194,-51,77],[206,-61,60,],0xFFFFFF,[3944,3945,3946,3970,3971,3972],[3945,3946,3947,3971,3972,3973],[3946,3947,3948,3972,3973,3974]],
[[194,-51,77],[194,-61,76],[206,-61,60,],0xFFFFFF,[3945,3946,3947,3971,3972,3973],[3947,3948,3949,3973,3974,3975],[3946,3947,3948,3972,3973,3974]],
[[206,-61,60],[194,-61,76],[204,-71,59,],0xFFFFFF,[3946,3947,3948,3972,3973,3974],[3947,3948,3949,3973,3974,3975],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[194,-61,76],[192,-71,75],[204,-71,59,],0xFFFFFF,[3947,3948,3949,3973,3974,3975],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976]],
[[204,-71,59],[192,-71,75],[202,-81,57,],0xFFFFFF,[1957,1958,1959,1965,1966,1967,2020,2021,2022,2028,2029,2030,3948,3949,3950,3974,3975,3976],[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[3950,3951,3952,3976,3977,3978]],
[[192,-71,75],[190,-81,73],[202,-81,57,],0xFFFFFF,[2021,2022,2023,2029,2030,2031,3949,3950,3951,3975,3976,3977],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[3950,3951,3952,3976,3977,3978]],
[[202,-81,57],[190,-81,73],[199,-91,56,],0xFFFFFF,[3950,3951,3952,3976,3977,3978],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[3952,3953,3978,3979]],
[[190,-81,73],[188,-91,71],[199,-91,56,],0xFFFFFF,[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[3953,3979],[3952,3953,3978,3979]],
[[162,60,48],[151,60,58],[176,55,60,],0xFFFFFF,[2034,2040,3980,3986],[3980,3981,3986,3987],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[151,60,58],[164,55,72],[176,55,60,],0xFFFFFF,[3980,3981,3986,3987],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[176,55,60],[164,55,72],[182,49,66,],0xFFFFFF,[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[3982,3983,3984,3988,3989,3990]],
[[164,55,72],[169,49,78],[182,49,66,],0xFFFFFF,[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[3982,3983,3984,3988,3989,3990]],
[[182,49,66],[169,49,78],[187,39,70,],0xFFFFFF,[3982,3983,3984,3988,3989,3990],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[169,49,78],[173,39,83],[187,39,70,],0xFFFFFF,[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[3985,3991,3992,3993,4018,4019],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[162,60,48],[151,60,58],[176,55,60,],0xFFFFFF,[2034,2040,3980,3986],[3980,3981,3986,3987],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[151,60,58],[164,55,72],[176,55,60,],0xFFFFFF,[3980,3981,3986,3987],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988]],
[[176,55,60],[164,55,72],[182,49,66,],0xFFFFFF,[2034,2035,2036,2040,2041,2042,3917,3918,3919,3923,3924,3925,3980,3981,3982,3986,3987,3988],[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[3982,3983,3984,3988,3989,3990]],
[[164,55,72],[169,49,78],[182,49,66,],0xFFFFFF,[2035,2036,2037,2041,2042,2043,3981,3982,3983,3987,3988,3989],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[3982,3983,3984,3988,3989,3990]],
[[182,49,66],[169,49,78],[187,39,70,],0xFFFFFF,[3982,3983,3984,3988,3989,3990],[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[169,49,78],[173,39,83],[187,39,70,],0xFFFFFF,[2037,2038,2039,2043,2044,2045,3983,3984,3985,3989,3990,3991],[3985,3991,3992,3993,4018,4019],[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018]],
[[187,39,70],[173,39,83],[189,29,72,],0xFFFFFF,[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018],[3985,3991,3992,3993,4018,4019],[3992,3993,3994,4018,4019,4020]],
[[173,39,83],[175,29,86],[189,29,72,],0xFFFFFF,[3985,3991,3992,3993,4018,4019],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[3992,3993,3994,4018,4019,4020]],
[[189,29,72],[175,29,86],[191,19,74,],0xFFFFFF,[3992,3993,3994,4018,4019,4020],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[3994,3995,3996,4020,4021,4022]],
[[175,29,86],[177,19,87],[191,19,74,],0xFFFFFF,[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[3994,3995,3996,4020,4021,4022]],
[[191,19,74],[177,19,87],[192,9,75,],0xFFFFFF,[3994,3995,3996,4020,4021,4022],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[3996,3997,3998,4022,4023,4024]],
[[177,19,87],[178,9,89],[192,9,75,],0xFFFFFF,[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[3997,3998,3999,4023,4024,4025],[3996,3997,3998,4022,4023,4024]],
[[192,9,75],[178,9,89],[193,-1,76,],0xFFFFFF,[3996,3997,3998,4022,4023,4024],[3997,3998,3999,4023,4024,4025],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026]],
[[178,9,89],[179,-1,90],[193,-1,76,],0xFFFFFF,[3997,3998,3999,4023,4024,4025],[3999,4000,4001,4025,4026,4027],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026]],
[[193,-1,76],[179,-1,90],[194,-11,77,],0xFFFFFF,[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3999,4000,4001,4025,4026,4027],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[179,-1,90],[179,-11,91],[194,-11,77,],0xFFFFFF,[3999,4000,4001,4025,4026,4027],[4001,4002,4003,4027,4028,4029],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[194,-11,77],[179,-11,91],[195,-21,77,],0xFFFFFF,[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028],[4001,4002,4003,4027,4028,4029],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030]],
[[179,-11,91],[180,-21,91],[195,-21,77,],0xFFFFFF,[4001,4002,4003,4027,4028,4029],[4003,4004,4005,4029,4030,4031],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030]],
[[195,-21,77],[180,-21,91],[195,-31,77,],0xFFFFFF,[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[4003,4004,4005,4029,4030,4031],[4004,4005,4006,4030,4031,4032]],
[[180,-21,91],[180,-31,92],[195,-31,77,],0xFFFFFF,[4003,4004,4005,4029,4030,4031],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[4004,4005,4006,4030,4031,4032]],
[[195,-31,77],[180,-31,92],[195,-41,77,],0xFFFFFF,[4004,4005,4006,4030,4031,4032],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[180,-31,92],[180,-41,92],[195,-41,77,],0xFFFFFF,[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[4007,4008,4009,4033,4034,4035],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[195,-41,77],[180,-41,92],[194,-51,77,],0xFFFFFF,[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034],[4007,4008,4009,4033,4034,4035],[4008,4009,4010,4034,4035,4036]],
[[180,-41,92],[180,-51,91],[194,-51,77,],0xFFFFFF,[4007,4008,4009,4033,4034,4035],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[4008,4009,4010,4034,4035,4036]],
[[194,-51,77],[180,-51,91],[194,-61,76,],0xFFFFFF,[4008,4009,4010,4034,4035,4036],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[180,-51,91],[179,-61,90],[194,-61,76,],0xFFFFFF,[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[4011,4012,4013,4037,4038,4039],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[194,-61,76],[179,-61,90],[192,-71,75,],0xFFFFFF,[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038],[4011,4012,4013,4037,4038,4039],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[179,-61,90],[178,-71,89],[192,-71,75,],0xFFFFFF,[4011,4012,4013,4037,4038,4039],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[192,-71,75],[178,-71,89],[190,-81,73,],0xFFFFFF,[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042]],
[[178,-71,89],[176,-81,87],[190,-81,73,],0xFFFFFF,[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042]],
[[190,-81,73],[176,-81,87],[188,-91,71,],0xFFFFFF,[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[176,-81,87],[174,-91,84],[188,-91,71,],0xFFFFFF,[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[4017,4043],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[187,39,70],[173,39,83],[189,29,72,],0xFFFFFF,[2038,2039,2044,2045,2046,2056,3984,3985,3990,3991,3992,4018],[3985,3991,3992,3993,4018,4019],[3992,3993,3994,4018,4019,4020]],
[[173,39,83],[175,29,86],[189,29,72,],0xFFFFFF,[3985,3991,3992,3993,4018,4019],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[3992,3993,3994,4018,4019,4020]],
[[189,29,72],[175,29,86],[191,19,74,],0xFFFFFF,[3992,3993,3994,4018,4019,4020],[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[3994,3995,3996,4020,4021,4022]],
[[175,29,86],[177,19,87],[191,19,74,],0xFFFFFF,[2047,2048,2049,2057,2058,2059,3993,3994,3995,4019,4020,4021],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[3994,3995,3996,4020,4021,4022]],
[[191,19,74],[177,19,87],[192,9,75,],0xFFFFFF,[3994,3995,3996,4020,4021,4022],[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[3996,3997,3998,4022,4023,4024]],
[[177,19,87],[178,9,89],[192,9,75,],0xFFFFFF,[2049,2050,2051,2059,2060,2061,3995,3996,3997,4021,4022,4023],[3997,3998,3999,4023,4024,4025],[3996,3997,3998,4022,4023,4024]],
[[192,9,75],[178,9,89],[193,-1,76,],0xFFFFFF,[3996,3997,3998,4022,4023,4024],[3997,3998,3999,4023,4024,4025],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026]],
[[178,9,89],[179,-1,90],[193,-1,76,],0xFFFFFF,[3997,3998,3999,4023,4024,4025],[3999,4000,4001,4025,4026,4027],[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026]],
[[193,-1,76],[179,-1,90],[194,-11,77,],0xFFFFFF,[3935,3936,3937,3961,3962,3963,3998,3999,4000,4024,4025,4026],[3999,4000,4001,4025,4026,4027],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[179,-1,90],[179,-11,91],[194,-11,77,],0xFFFFFF,[3999,4000,4001,4025,4026,4027],[4001,4002,4003,4027,4028,4029],[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028]],
[[194,-11,77],[179,-11,91],[195,-21,77,],0xFFFFFF,[2054,2055,2064,2065,2066,2074,4000,4001,4002,4026,4027,4028],[4001,4002,4003,4027,4028,4029],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030]],
[[179,-11,91],[180,-21,91],[195,-21,77,],0xFFFFFF,[4001,4002,4003,4027,4028,4029],[4003,4004,4005,4029,4030,4031],[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030]],
[[195,-21,77],[180,-21,91],[195,-31,77,],0xFFFFFF,[2003,2004,2005,2011,2012,2013,4002,4003,4004,4028,4029,4030],[4003,4004,4005,4029,4030,4031],[4004,4005,4006,4030,4031,4032]],
[[180,-21,91],[180,-31,92],[195,-31,77,],0xFFFFFF,[4003,4004,4005,4029,4030,4031],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[4004,4005,4006,4030,4031,4032]],
[[195,-31,77],[180,-31,92],[195,-41,77,],0xFFFFFF,[4004,4005,4006,4030,4031,4032],[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[180,-31,92],[180,-41,92],[195,-41,77,],0xFFFFFF,[2069,2070,2071,2077,2078,2079,4005,4006,4007,4031,4032,4033],[4007,4008,4009,4033,4034,4035],[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034]],
[[195,-41,77],[180,-41,92],[194,-51,77,],0xFFFFFF,[2070,2071,2072,2078,2079,2080,4006,4007,4008,4032,4033,4034],[4007,4008,4009,4033,4034,4035],[4008,4009,4010,4034,4035,4036]],
[[180,-41,92],[180,-51,91],[194,-51,77,],0xFFFFFF,[4007,4008,4009,4033,4034,4035],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[4008,4009,4010,4034,4035,4036]],
[[194,-51,77],[180,-51,91],[194,-61,76,],0xFFFFFF,[4008,4009,4010,4034,4035,4036],[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[180,-51,91],[179,-61,90],[194,-61,76,],0xFFFFFF,[2073,2081,2082,2083,2090,2091,4009,4010,4011,4035,4036,4037],[4011,4012,4013,4037,4038,4039],[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038]],
[[194,-61,76],[179,-61,90],[192,-71,75,],0xFFFFFF,[2082,2083,2084,2090,2091,2092,4010,4011,4012,4036,4037,4038],[4011,4012,4013,4037,4038,4039],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[179,-61,90],[178,-71,89],[192,-71,75,],0xFFFFFF,[4011,4012,4013,4037,4038,4039],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040]],
[[192,-71,75],[178,-71,89],[190,-81,73,],0xFFFFFF,[2084,2085,2086,2092,2093,2094,4012,4013,4014,4038,4039,4040],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042]],
[[178,-71,89],[176,-81,87],[190,-81,73,],0xFFFFFF,[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042]],
[[190,-81,73],[176,-81,87],[188,-91,71,],0xFFFFFF,[3951,3952,3953,3977,3978,3979,4014,4015,4016,4040,4041,4042],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[176,-81,87],[174,-91,84],[188,-91,71,],0xFFFFFF,[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[4017,4043],[2088,2089,2096,2097,4016,4017,4042,4043]],
[[152,60,57],[140,60,65],[164,55,72,],0xFFFFFF,[2098,2104,4044,4050],[2098,2099,2104,2105,4044,4045,4050,4051],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[140,60,65],[150,55,81],[164,55,72,],0xFFFFFF,[2098,2099,2104,2105,4044,4045,4050,4051],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[164,55,72],[150,55,81],[169,49,78,],0xFFFFFF,[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[4046,4047,4048,4052,4053,4054]],
[[150,55,81],[155,49,88],[169,49,78,],0xFFFFFF,[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[4046,4047,4048,4052,4053,4054]],
[[169,49,78],[155,49,88],[173,39,83,],0xFFFFFF,[4046,4047,4048,4052,4053,4054],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[4048,4049,4054,4055,4056,4082]],
[[155,49,88],[158,39,94],[173,39,83,],0xFFFFFF,[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[4048,4049,4054,4055,4056,4082]],
[[152,60,57],[140,60,65],[164,55,72,],0xFFFFFF,[2098,2104,4044,4050],[2098,2099,2104,2105,4044,4045,4050,4051],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[140,60,65],[150,55,81],[164,55,72,],0xFFFFFF,[2098,2099,2104,2105,4044,4045,4050,4051],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052]],
[[164,55,72],[150,55,81],[169,49,78,],0xFFFFFF,[2098,2099,2100,2104,2105,2106,4044,4045,4046,4050,4051,4052],[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[4046,4047,4048,4052,4053,4054]],
[[150,55,81],[155,49,88],[169,49,78,],0xFFFFFF,[2099,2100,2101,2105,2106,2107,4045,4046,4047,4051,4052,4053],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[4046,4047,4048,4052,4053,4054]],
[[169,49,78],[155,49,88],[173,39,83,],0xFFFFFF,[4046,4047,4048,4052,4053,4054],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[4048,4049,4054,4055,4056,4082]],
[[155,49,88],[158,39,94],[173,39,83,],0xFFFFFF,[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[4048,4049,4054,4055,4056,4082]],
[[173,39,83],[158,39,94],[175,29,86,],0xFFFFFF,[4048,4049,4054,4055,4056,4082],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[158,39,94],[159,29,96],[175,29,86,],0xFFFFFF,[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[4057,4058,4059,4083,4084,4085],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[175,29,86],[159,29,96],[177,19,87,],0xFFFFFF,[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084],[4057,4058,4059,4083,4084,4085],[4058,4059,4060,4084,4085,4086]],
[[159,29,96],[160,19,98],[177,19,87,],0xFFFFFF,[4057,4058,4059,4083,4084,4085],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[4058,4059,4060,4084,4085,4086]],
[[177,19,87],[160,19,98],[178,9,89,],0xFFFFFF,[4058,4059,4060,4084,4085,4086],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[4060,4061,4062,4086,4087,4088]],
[[160,19,98],[161,9,100],[178,9,89,],0xFFFFFF,[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[4060,4061,4062,4086,4087,4088]],
[[178,9,89],[161,9,100],[179,-1,90,],0xFFFFFF,[4060,4061,4062,4086,4087,4088],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[4062,4063,4064,4088,4089,4090]],
[[161,9,100],[162,-1,101],[179,-1,90,],0xFFFFFF,[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[4062,4063,4064,4088,4089,4090]],
[[179,-1,90],[162,-1,101],[179,-11,91,],0xFFFFFF,[4062,4063,4064,4088,4089,4090],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[4064,4065,4066,4090,4091,4092]],
[[162,-1,101],[162,-11,102],[179,-11,91,],0xFFFFFF,[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[4064,4065,4066,4090,4091,4092]],
[[179,-11,91],[162,-11,102],[180,-21,91,],0xFFFFFF,[4064,4065,4066,4090,4091,4092],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[4066,4067,4068,4092,4093,4094]],
[[162,-11,102],[163,-21,103],[180,-21,91,],0xFFFFFF,[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[4067,4068,4069,4093,4094,4095],[4066,4067,4068,4092,4093,4094]],
[[180,-21,91],[163,-21,103],[180,-31,92,],0xFFFFFF,[4066,4067,4068,4092,4093,4094],[4067,4068,4069,4093,4094,4095],[4068,4069,4070,4094,4095,4096]],
[[163,-21,103],[163,-31,103],[180,-31,92,],0xFFFFFF,[4067,4068,4069,4093,4094,4095],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[4068,4069,4070,4094,4095,4096]],
[[180,-31,92],[163,-31,103],[180,-41,92,],0xFFFFFF,[4068,4069,4070,4094,4095,4096],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[4070,4071,4072,4096,4097,4098]],
[[163,-31,103],[163,-41,103],[180,-41,92,],0xFFFFFF,[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[4071,4072,4073,4097,4098,4099],[4070,4071,4072,4096,4097,4098]],
[[180,-41,92],[163,-41,103],[180,-51,91,],0xFFFFFF,[4070,4071,4072,4096,4097,4098],[4071,4072,4073,4097,4098,4099],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[163,-41,103],[163,-51,103],[180,-51,91,],0xFFFFFF,[4071,4072,4073,4097,4098,4099],[4073,4074,4075,4099,4100,4101],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[180,-51,91],[163,-51,103],[179,-61,90,],0xFFFFFF,[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100],[4073,4074,4075,4099,4100,4101],[4074,4075,4076,4100,4101,4102]],
[[163,-51,103],[162,-61,102],[179,-61,90,],0xFFFFFF,[4073,4074,4075,4099,4100,4101],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[4074,4075,4076,4100,4101,4102]],
[[179,-61,90],[162,-61,102],[178,-71,89,],0xFFFFFF,[4074,4075,4076,4100,4101,4102],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[162,-61,102],[161,-71,100],[178,-71,89,],0xFFFFFF,[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[178,-71,89],[161,-71,100],[176,-81,87,],0xFFFFFF,[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106]],
[[161,-71,100],[160,-81,98],[176,-81,87,],0xFFFFFF,[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106]],
[[176,-81,87],[160,-81,98],[174,-91,84,],0xFFFFFF,[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[160,-81,98],[158,-91,95],[174,-91,84,],0xFFFFFF,[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[4081,4107],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[173,39,83],[158,39,94],[175,29,86,],0xFFFFFF,[4048,4049,4054,4055,4056,4082],[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[158,39,94],[159,29,96],[175,29,86,],0xFFFFFF,[2166,2167,2172,2173,2174,2184,4049,4055,4056,4057,4082,4083],[4057,4058,4059,4083,4084,4085],[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084]],
[[175,29,86],[159,29,96],[177,19,87,],0xFFFFFF,[2110,2111,2112,2120,2121,2122,4056,4057,4058,4082,4083,4084],[4057,4058,4059,4083,4084,4085],[4058,4059,4060,4084,4085,4086]],
[[159,29,96],[160,19,98],[177,19,87,],0xFFFFFF,[4057,4058,4059,4083,4084,4085],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[4058,4059,4060,4084,4085,4086]],
[[177,19,87],[160,19,98],[178,9,89,],0xFFFFFF,[4058,4059,4060,4084,4085,4086],[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[4060,4061,4062,4086,4087,4088]],
[[160,19,98],[161,9,100],[178,9,89,],0xFFFFFF,[2113,2114,2115,2123,2124,2125,4059,4060,4061,4085,4086,4087],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[4060,4061,4062,4086,4087,4088]],
[[178,9,89],[161,9,100],[179,-1,90,],0xFFFFFF,[4060,4061,4062,4086,4087,4088],[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[4062,4063,4064,4088,4089,4090]],
[[161,9,100],[162,-1,101],[179,-1,90,],0xFFFFFF,[2115,2116,2117,2125,2126,2127,4061,4062,4063,4087,4088,4089],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[4062,4063,4064,4088,4089,4090]],
[[179,-1,90],[162,-1,101],[179,-11,91,],0xFFFFFF,[4062,4063,4064,4088,4089,4090],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[4064,4065,4066,4090,4091,4092]],
[[162,-1,101],[162,-11,102],[179,-11,91,],0xFFFFFF,[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[4064,4065,4066,4090,4091,4092]],
[[179,-11,91],[162,-11,102],[180,-21,91,],0xFFFFFF,[4064,4065,4066,4090,4091,4092],[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[4066,4067,4068,4092,4093,4094]],
[[162,-11,102],[163,-21,103],[180,-21,91,],0xFFFFFF,[2119,2129,2130,2131,2138,2139,4065,4066,4067,4091,4092,4093],[4067,4068,4069,4093,4094,4095],[4066,4067,4068,4092,4093,4094]],
[[180,-21,91],[163,-21,103],[180,-31,92,],0xFFFFFF,[4066,4067,4068,4092,4093,4094],[4067,4068,4069,4093,4094,4095],[4068,4069,4070,4094,4095,4096]],
[[163,-21,103],[163,-31,103],[180,-31,92,],0xFFFFFF,[4067,4068,4069,4093,4094,4095],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[4068,4069,4070,4094,4095,4096]],
[[180,-31,92],[163,-31,103],[180,-41,92,],0xFFFFFF,[4068,4069,4070,4094,4095,4096],[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[4070,4071,4072,4096,4097,4098]],
[[163,-31,103],[163,-41,103],[180,-41,92,],0xFFFFFF,[2133,2134,2135,2141,2142,2143,4069,4070,4071,4095,4096,4097],[4071,4072,4073,4097,4098,4099],[4070,4071,4072,4096,4097,4098]],
[[180,-41,92],[163,-41,103],[180,-51,91,],0xFFFFFF,[4070,4071,4072,4096,4097,4098],[4071,4072,4073,4097,4098,4099],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[163,-41,103],[163,-51,103],[180,-51,91,],0xFFFFFF,[4071,4072,4073,4097,4098,4099],[4073,4074,4075,4099,4100,4101],[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100]],
[[180,-51,91],[163,-51,103],[179,-61,90,],0xFFFFFF,[2136,2137,2144,2145,2146,2154,4072,4073,4074,4098,4099,4100],[4073,4074,4075,4099,4100,4101],[4074,4075,4076,4100,4101,4102]],
[[163,-51,103],[162,-61,102],[179,-61,90,],0xFFFFFF,[4073,4074,4075,4099,4100,4101],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[4074,4075,4076,4100,4101,4102]],
[[179,-61,90],[162,-61,102],[178,-71,89,],0xFFFFFF,[4074,4075,4076,4100,4101,4102],[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[162,-61,102],[161,-71,100],[178,-71,89,],0xFFFFFF,[2147,2148,2149,2155,2156,2157,4075,4076,4077,4101,4102,4103],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104]],
[[178,-71,89],[161,-71,100],[176,-81,87,],0xFFFFFF,[2148,2149,2150,2156,2157,2158,4013,4014,4015,4039,4040,4041,4076,4077,4078,4102,4103,4104],[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106]],
[[161,-71,100],[160,-81,98],[176,-81,87,],0xFFFFFF,[2149,2150,2151,2157,2158,2159,4077,4078,4079,4103,4104,4105],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106]],
[[176,-81,87],[160,-81,98],[174,-91,84,],0xFFFFFF,[4015,4016,4017,4041,4042,4043,4078,4079,4080,4104,4105,4106],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[160,-81,98],[158,-91,95],[174,-91,84,],0xFFFFFF,[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[4081,4107],[2152,2153,2160,2161,4080,4081,4106,4107]],
[[141,60,65],[128,60,71],[150,55,81,],0xFFFFFF,[4108,4114],[2162,2163,2168,2169,4108,4109,4114,4115],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[128,60,71],[136,55,87],[150,55,81,],0xFFFFFF,[2162,2163,2168,2169,4108,4109,4114,4115],[4109,4110,4111,4115,4116,4117],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[150,55,81],[136,55,87],[155,49,88,],0xFFFFFF,[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116],[4109,4110,4111,4115,4116,4117],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118]],
[[136,55,87],[139,49,95],[155,49,88,],0xFFFFFF,[4109,4110,4111,4115,4116,4117],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118]],
[[155,49,88],[139,49,95],[158,39,94,],0xFFFFFF,[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[4112,4113,4118,4119,4120,4146]],
[[139,49,95],[141,39,101],[158,39,94,],0xFFFFFF,[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[4113,4119,4120,4121,4146,4147],[4112,4113,4118,4119,4120,4146]],
[[141,60,65],[128,60,71],[150,55,81,],0xFFFFFF,[4108,4114],[2162,2163,2168,2169,4108,4109,4114,4115],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[128,60,71],[136,55,87],[150,55,81,],0xFFFFFF,[2162,2163,2168,2169,4108,4109,4114,4115],[4109,4110,4111,4115,4116,4117],[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116]],
[[150,55,81],[136,55,87],[155,49,88,],0xFFFFFF,[2162,2163,2164,2168,2169,2170,4108,4109,4110,4114,4115,4116],[4109,4110,4111,4115,4116,4117],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118]],
[[136,55,87],[139,49,95],[155,49,88,],0xFFFFFF,[4109,4110,4111,4115,4116,4117],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118]],
[[155,49,88],[139,49,95],[158,39,94,],0xFFFFFF,[2101,2102,2103,2107,2108,2109,4047,4048,4049,4053,4054,4055,4110,4111,4112,4116,4117,4118],[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[4112,4113,4118,4119,4120,4146]],
[[139,49,95],[141,39,101],[158,39,94,],0xFFFFFF,[2165,2166,2167,2171,2172,2173,4111,4112,4113,4117,4118,4119],[4113,4119,4120,4121,4146,4147],[4112,4113,4118,4119,4120,4146]],
[[158,39,94],[141,39,101],[159,29,96,],0xFFFFFF,[4112,4113,4118,4119,4120,4146],[4113,4119,4120,4121,4146,4147],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148]],
[[141,39,101],[142,29,104],[159,29,96,],0xFFFFFF,[4113,4119,4120,4121,4146,4147],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148]],
[[159,29,96],[142,29,104],[160,19,98,],0xFFFFFF,[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[4122,4123,4124,4148,4149,4150]],
[[142,29,104],[142,19,106],[160,19,98,],0xFFFFFF,[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[4122,4123,4124,4148,4149,4150]],
[[160,19,98],[142,19,106],[161,9,100,],0xFFFFFF,[4122,4123,4124,4148,4149,4150],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[4124,4125,4126,4150,4151,4152]],
[[142,19,106],[143,9,108],[161,9,100,],0xFFFFFF,[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[4124,4125,4126,4150,4151,4152]],
[[161,9,100],[143,9,108],[162,-1,101,],0xFFFFFF,[4124,4125,4126,4150,4151,4152],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[143,9,108],[143,-1,110],[162,-1,101,],0xFFFFFF,[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[4127,4128,4129,4153,4154,4155],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[162,-1,101],[143,-1,110],[162,-11,102,],0xFFFFFF,[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[4127,4128,4129,4153,4154,4155],[4128,4129,4130,4154,4155,4156]],
[[143,-1,110],[144,-11,111],[162,-11,102,],0xFFFFFF,[4127,4128,4129,4153,4154,4155],[4129,4130,4131,4155,4156,4157],[4128,4129,4130,4154,4155,4156]],
[[162,-11,102],[144,-11,111],[163,-21,103,],0xFFFFFF,[4128,4129,4130,4154,4155,4156],[4129,4130,4131,4155,4156,4157],[4130,4131,4132,4156,4157,4158]],
[[144,-11,111],[144,-21,111],[163,-21,103,],0xFFFFFF,[4129,4130,4131,4155,4156,4157],[4131,4132,4133,4157,4158,4159],[4130,4131,4132,4156,4157,4158]],
[[163,-21,103],[144,-21,111],[163,-31,103,],0xFFFFFF,[4130,4131,4132,4156,4157,4158],[4131,4132,4133,4157,4158,4159],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[144,-21,111],[144,-31,112],[163,-31,103,],0xFFFFFF,[4131,4132,4133,4157,4158,4159],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[163,-31,103],[144,-31,112],[163,-41,103,],0xFFFFFF,[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[4134,4135,4136,4160,4161,4162]],
[[144,-31,112],[144,-41,111],[163,-41,103,],0xFFFFFF,[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[4135,4136,4137,4161,4162,4163],[4134,4135,4136,4160,4161,4162]],
[[163,-41,103],[144,-41,111],[163,-51,103,],0xFFFFFF,[4134,4135,4136,4160,4161,4162],[4135,4136,4137,4161,4162,4163],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[144,-41,111],[144,-51,111],[163,-51,103,],0xFFFFFF,[4135,4136,4137,4161,4162,4163],[4137,4138,4139,4163,4164,4165],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[163,-51,103],[144,-51,111],[162,-61,102,],0xFFFFFF,[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164],[4137,4138,4139,4163,4164,4165],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[144,-51,111],[144,-61,110],[162,-61,102,],0xFFFFFF,[4137,4138,4139,4163,4164,4165],[4139,4140,4141,4165,4166,4167],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[162,-61,102],[144,-61,110],[161,-71,100,],0xFFFFFF,[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166],[4139,4140,4141,4165,4166,4167],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[144,-61,110],[143,-71,108],[161,-71,100,],0xFFFFFF,[4139,4140,4141,4165,4166,4167],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[161,-71,100],[143,-71,108],[160,-81,98,],0xFFFFFF,[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170]],
[[143,-71,108],[142,-81,106],[160,-81,98,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[4143,4144,4145,4169,4170,4171],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170]],
[[160,-81,98],[142,-81,106],[158,-91,95,],0xFFFFFF,[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[4143,4144,4145,4169,4170,4171],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[142,-81,106],[141,-91,103],[158,-91,95,],0xFFFFFF,[4143,4144,4145,4169,4170,4171],[2217,2225,4145,4171],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[158,39,94],[141,39,101],[159,29,96,],0xFFFFFF,[4112,4113,4118,4119,4120,4146],[4113,4119,4120,4121,4146,4147],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148]],
[[141,39,101],[142,29,104],[159,29,96,],0xFFFFFF,[4113,4119,4120,4121,4146,4147],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148]],
[[159,29,96],[142,29,104],[160,19,98,],0xFFFFFF,[2111,2112,2113,2121,2122,2123,4120,4121,4122,4146,4147,4148],[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[4122,4123,4124,4148,4149,4150]],
[[142,29,104],[142,19,106],[160,19,98,],0xFFFFFF,[2175,2176,2177,2185,2186,2187,4121,4122,4123,4147,4148,4149],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[4122,4123,4124,4148,4149,4150]],
[[160,19,98],[142,19,106],[161,9,100,],0xFFFFFF,[4122,4123,4124,4148,4149,4150],[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[4124,4125,4126,4150,4151,4152]],
[[142,19,106],[143,9,108],[161,9,100,],0xFFFFFF,[2177,2178,2179,2187,2188,2189,4123,4124,4125,4149,4150,4151],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[4124,4125,4126,4150,4151,4152]],
[[161,9,100],[143,9,108],[162,-1,101,],0xFFFFFF,[4124,4125,4126,4150,4151,4152],[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[143,9,108],[143,-1,110],[162,-1,101,],0xFFFFFF,[2179,2180,2181,2189,2190,2191,4125,4126,4127,4151,4152,4153],[4127,4128,4129,4153,4154,4155],[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154]],
[[162,-1,101],[143,-1,110],[162,-11,102,],0xFFFFFF,[2180,2181,2182,2190,2191,2192,4063,4064,4065,4089,4090,4091,4126,4127,4128,4152,4153,4154],[4127,4128,4129,4153,4154,4155],[4128,4129,4130,4154,4155,4156]],
[[143,-1,110],[144,-11,111],[162,-11,102,],0xFFFFFF,[4127,4128,4129,4153,4154,4155],[4129,4130,4131,4155,4156,4157],[4128,4129,4130,4154,4155,4156]],
[[162,-11,102],[144,-11,111],[163,-21,103,],0xFFFFFF,[4128,4129,4130,4154,4155,4156],[4129,4130,4131,4155,4156,4157],[4130,4131,4132,4156,4157,4158]],
[[144,-11,111],[144,-21,111],[163,-21,103,],0xFFFFFF,[4129,4130,4131,4155,4156,4157],[4131,4132,4133,4157,4158,4159],[4130,4131,4132,4156,4157,4158]],
[[163,-21,103],[144,-21,111],[163,-31,103,],0xFFFFFF,[4130,4131,4132,4156,4157,4158],[4131,4132,4133,4157,4158,4159],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[144,-21,111],[144,-31,112],[163,-31,103,],0xFFFFFF,[4131,4132,4133,4157,4158,4159],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160]],
[[163,-31,103],[144,-31,112],[163,-41,103,],0xFFFFFF,[2196,2197,2198,2204,2205,2206,4132,4133,4134,4158,4159,4160],[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[4134,4135,4136,4160,4161,4162]],
[[144,-31,112],[144,-41,111],[163,-41,103,],0xFFFFFF,[2197,2198,2199,2205,2206,2207,4133,4134,4135,4159,4160,4161],[4135,4136,4137,4161,4162,4163],[4134,4135,4136,4160,4161,4162]],
[[163,-41,103],[144,-41,111],[163,-51,103,],0xFFFFFF,[4134,4135,4136,4160,4161,4162],[4135,4136,4137,4161,4162,4163],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[144,-41,111],[144,-51,111],[163,-51,103,],0xFFFFFF,[4135,4136,4137,4161,4162,4163],[4137,4138,4139,4163,4164,4165],[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164]],
[[163,-51,103],[144,-51,111],[162,-61,102,],0xFFFFFF,[2200,2201,2208,2209,2210,2218,4136,4137,4138,4162,4163,4164],[4137,4138,4139,4163,4164,4165],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[144,-51,111],[144,-61,110],[162,-61,102,],0xFFFFFF,[4137,4138,4139,4163,4164,4165],[4139,4140,4141,4165,4166,4167],[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166]],
[[162,-61,102],[144,-61,110],[161,-71,100,],0xFFFFFF,[2210,2211,2212,2218,2219,2220,4138,4139,4140,4164,4165,4166],[4139,4140,4141,4165,4166,4167],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[144,-61,110],[143,-71,108],[161,-71,100,],0xFFFFFF,[4139,4140,4141,4165,4166,4167],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168]],
[[161,-71,100],[143,-71,108],[160,-81,98,],0xFFFFFF,[2212,2213,2214,2220,2221,2222,4140,4141,4142,4166,4167,4168],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170]],
[[143,-71,108],[142,-81,106],[160,-81,98,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[4143,4144,4145,4169,4170,4171],[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170]],
[[160,-81,98],[142,-81,106],[158,-91,95,],0xFFFFFF,[4079,4080,4081,4105,4106,4107,4142,4143,4144,4168,4169,4170],[4143,4144,4145,4169,4170,4171],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[142,-81,106],[141,-91,103],[158,-91,95,],0xFFFFFF,[4143,4144,4145,4169,4170,4171],[2217,2225,4145,4171],[2216,2217,2224,2225,4144,4145,4170,4171]],
[[130,60,70],[116,60,73],[136,55,87,],0xFFFFFF,[2226,2232,4172,4178],[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[116,60,73],[120,55,91],[136,55,87,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[4173,4174,4175,4179,4180,4181],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[136,55,87],[120,55,91],[139,49,95,],0xFFFFFF,[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180],[4173,4174,4175,4179,4180,4181],[4174,4175,4176,4180,4181,4182]],
[[120,55,91],[121,49,100],[139,49,95,],0xFFFFFF,[4173,4174,4175,4179,4180,4181],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[4174,4175,4176,4180,4181,4182]],
[[139,49,95],[121,49,100],[141,39,101,],0xFFFFFF,[4174,4175,4176,4180,4181,4182],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[4176,4177,4182,4183,4184,4210]],
[[121,49,100],[122,39,106],[141,39,101,],0xFFFFFF,[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[4177,4183,4184,4185,4210,4211],[4176,4177,4182,4183,4184,4210]],
[[130,60,70],[116,60,73],[136,55,87,],0xFFFFFF,[2226,2232,4172,4178],[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[116,60,73],[120,55,91],[136,55,87,],0xFFFFFF,[558,559,728,729,2226,2227,2232,2233,2370,2371,2663,2664,4172,4173,4178,4179],[4173,4174,4175,4179,4180,4181],[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180]],
[[136,55,87],[120,55,91],[139,49,95,],0xFFFFFF,[2226,2227,2228,2232,2233,2234,4172,4173,4174,4178,4179,4180],[4173,4174,4175,4179,4180,4181],[4174,4175,4176,4180,4181,4182]],
[[120,55,91],[121,49,100],[139,49,95,],0xFFFFFF,[4173,4174,4175,4179,4180,4181],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[4174,4175,4176,4180,4181,4182]],
[[139,49,95],[121,49,100],[141,39,101,],0xFFFFFF,[4174,4175,4176,4180,4181,4182],[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[4176,4177,4182,4183,4184,4210]],
[[121,49,100],[122,39,106],[141,39,101,],0xFFFFFF,[2229,2230,2231,2235,2236,2237,4175,4176,4177,4181,4182,4183],[4177,4183,4184,4185,4210,4211],[4176,4177,4182,4183,4184,4210]],
[[141,39,101],[122,39,106],[142,29,104,],0xFFFFFF,[4176,4177,4182,4183,4184,4210],[4177,4183,4184,4185,4210,4211],[4184,4185,4186,4210,4211,4212]],
[[122,39,106],[123,29,109],[142,29,104,],0xFFFFFF,[4177,4183,4184,4185,4210,4211],[4185,4186,4187,4211,4212,4213],[4184,4185,4186,4210,4211,4212]],
[[142,29,104],[123,29,109],[142,19,106,],0xFFFFFF,[4184,4185,4186,4210,4211,4212],[4185,4186,4187,4211,4212,4213],[4186,4187,4188,4212,4213,4214]],
[[123,29,109],[123,19,111],[142,19,106,],0xFFFFFF,[4185,4186,4187,4211,4212,4213],[4187,4188,4189,4213,4214,4215],[4186,4187,4188,4212,4213,4214]],
[[142,19,106],[123,19,111],[143,9,108,],0xFFFFFF,[4186,4187,4188,4212,4213,4214],[4187,4188,4189,4213,4214,4215],[4188,4189,4190,4214,4215,4216]],
[[123,19,111],[123,9,113],[143,9,108,],0xFFFFFF,[4187,4188,4189,4213,4214,4215],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[4188,4189,4190,4214,4215,4216]],
[[143,9,108],[123,9,113],[143,-1,110,],0xFFFFFF,[4188,4189,4190,4214,4215,4216],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[4190,4191,4192,4216,4217,4218]],
[[123,9,113],[124,-1,114],[143,-1,110,],0xFFFFFF,[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[4191,4192,4193,4217,4218,4219],[4190,4191,4192,4216,4217,4218]],
[[143,-1,110],[124,-1,114],[144,-11,111,],0xFFFFFF,[4190,4191,4192,4216,4217,4218],[4191,4192,4193,4217,4218,4219],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[124,-1,114],[124,-11,116],[144,-11,111,],0xFFFFFF,[4191,4192,4193,4217,4218,4219],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[144,-11,111],[124,-11,116],[144,-21,111,],0xFFFFFF,[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[124,-11,116],[124,-21,116],[144,-21,111,],0xFFFFFF,[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[4195,4196,4197,4221,4222,4223],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[144,-21,111],[124,-21,116],[144,-31,112,],0xFFFFFF,[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222],[4195,4196,4197,4221,4222,4223],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[124,-21,116],[124,-31,117],[144,-31,112,],0xFFFFFF,[4195,4196,4197,4221,4222,4223],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[144,-31,112],[124,-31,117],[144,-41,111,],0xFFFFFF,[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[124,-31,117],[124,-41,116],[144,-41,111,],0xFFFFFF,[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[144,-41,111],[124,-41,116],[144,-51,111,],0xFFFFFF,[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[124,-41,116],[124,-51,116],[144,-51,111,],0xFFFFFF,[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[4201,4202,4203,4227,4228,4229],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[144,-51,111],[124,-51,116],[144,-61,110,],0xFFFFFF,[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228],[4201,4202,4203,4227,4228,4229],[4202,4203,4204,4228,4229,4230]],
[[124,-51,116],[124,-61,115],[144,-61,110,],0xFFFFFF,[4201,4202,4203,4227,4228,4229],[4203,4204,4205,4229,4230,4231],[4202,4203,4204,4228,4229,4230]],
[[144,-61,110],[124,-61,115],[143,-71,108,],0xFFFFFF,[4202,4203,4204,4228,4229,4230],[4203,4204,4205,4229,4230,4231],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[124,-61,115],[123,-71,113],[143,-71,108,],0xFFFFFF,[4203,4204,4205,4229,4230,4231],[4205,4206,4207,4231,4232,4233],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[143,-71,108],[123,-71,113],[142,-81,106,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[4205,4206,4207,4231,4232,4233],[4206,4207,4208,4232,4233,4234]],
[[123,-71,113],[123,-81,111],[142,-81,106,],0xFFFFFF,[4205,4206,4207,4231,4232,4233],[4207,4208,4209,4233,4234,4235],[4206,4207,4208,4232,4233,4234]],
[[142,-81,106],[123,-81,111],[141,-91,103,],0xFFFFFF,[4206,4207,4208,4232,4233,4234],[4207,4208,4209,4233,4234,4235],[4208,4209,4234,4235]],
[[123,-81,111],[123,-91,107],[141,-91,103,],0xFFFFFF,[4207,4208,4209,4233,4234,4235],[2281,2289,4209,4235],[4208,4209,4234,4235]],
[[141,39,101],[122,39,106],[142,29,104,],0xFFFFFF,[4176,4177,4182,4183,4184,4210],[4177,4183,4184,4185,4210,4211],[4184,4185,4186,4210,4211,4212]],
[[122,39,106],[123,29,109],[142,29,104,],0xFFFFFF,[4177,4183,4184,4185,4210,4211],[4185,4186,4187,4211,4212,4213],[4184,4185,4186,4210,4211,4212]],
[[142,29,104],[123,29,109],[142,19,106,],0xFFFFFF,[4184,4185,4186,4210,4211,4212],[4185,4186,4187,4211,4212,4213],[4186,4187,4188,4212,4213,4214]],
[[123,29,109],[123,19,111],[142,19,106,],0xFFFFFF,[4185,4186,4187,4211,4212,4213],[4187,4188,4189,4213,4214,4215],[4186,4187,4188,4212,4213,4214]],
[[142,19,106],[123,19,111],[143,9,108,],0xFFFFFF,[4186,4187,4188,4212,4213,4214],[4187,4188,4189,4213,4214,4215],[4188,4189,4190,4214,4215,4216]],
[[123,19,111],[123,9,113],[143,9,108,],0xFFFFFF,[4187,4188,4189,4213,4214,4215],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[4188,4189,4190,4214,4215,4216]],
[[143,9,108],[123,9,113],[143,-1,110,],0xFFFFFF,[4188,4189,4190,4214,4215,4216],[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[4190,4191,4192,4216,4217,4218]],
[[123,9,113],[124,-1,114],[143,-1,110,],0xFFFFFF,[2243,2244,2245,2253,2254,2255,4189,4190,4191,4215,4216,4217],[4191,4192,4193,4217,4218,4219],[4190,4191,4192,4216,4217,4218]],
[[143,-1,110],[124,-1,114],[144,-11,111,],0xFFFFFF,[4190,4191,4192,4216,4217,4218],[4191,4192,4193,4217,4218,4219],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[124,-1,114],[124,-11,116],[144,-11,111,],0xFFFFFF,[4191,4192,4193,4217,4218,4219],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220]],
[[144,-11,111],[124,-11,116],[144,-21,111,],0xFFFFFF,[2246,2247,2256,2257,2258,2266,4192,4193,4194,4218,4219,4220],[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[124,-11,116],[124,-21,116],[144,-21,111,],0xFFFFFF,[572,573,574,742,743,744,2384,2385,2386,2677,2678,2679,4193,4194,4195,4219,4220,4221],[4195,4196,4197,4221,4222,4223],[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222]],
[[144,-21,111],[124,-21,116],[144,-31,112,],0xFFFFFF,[2258,2259,2260,2266,2267,2268,4194,4195,4196,4220,4221,4222],[4195,4196,4197,4221,4222,4223],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[124,-21,116],[124,-31,117],[144,-31,112,],0xFFFFFF,[4195,4196,4197,4221,4222,4223],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224]],
[[144,-31,112],[124,-31,117],[144,-41,111,],0xFFFFFF,[2260,2261,2262,2268,2269,2270,4196,4197,4198,4222,4223,4224],[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[124,-31,117],[124,-41,116],[144,-41,111,],0xFFFFFF,[2261,2262,2263,2269,2270,2271,4197,4198,4199,4223,4224,4225],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226]],
[[144,-41,111],[124,-41,116],[144,-51,111,],0xFFFFFF,[2262,2263,2264,2270,2271,2272,4198,4199,4200,4224,4225,4226],[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[124,-41,116],[124,-51,116],[144,-51,111,],0xFFFFFF,[578,579,580,748,749,750,2390,2391,2392,2683,2684,2685,4199,4200,4201,4225,4226,4227],[4201,4202,4203,4227,4228,4229],[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228]],
[[144,-51,111],[124,-51,116],[144,-61,110,],0xFFFFFF,[2264,2265,2272,2273,2274,2282,4200,4201,4202,4226,4227,4228],[4201,4202,4203,4227,4228,4229],[4202,4203,4204,4228,4229,4230]],
[[124,-51,116],[124,-61,115],[144,-61,110,],0xFFFFFF,[4201,4202,4203,4227,4228,4229],[4203,4204,4205,4229,4230,4231],[4202,4203,4204,4228,4229,4230]],
[[144,-61,110],[124,-61,115],[143,-71,108,],0xFFFFFF,[4202,4203,4204,4228,4229,4230],[4203,4204,4205,4229,4230,4231],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[124,-61,115],[123,-71,113],[143,-71,108,],0xFFFFFF,[4203,4204,4205,4229,4230,4231],[4205,4206,4207,4231,4232,4233],[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232]],
[[143,-71,108],[123,-71,113],[142,-81,106,],0xFFFFFF,[2213,2214,2215,2221,2222,2223,2276,2277,2278,2284,2285,2286,4141,4142,4143,4167,4168,4169,4204,4205,4206,4230,4231,4232],[4205,4206,4207,4231,4232,4233],[4206,4207,4208,4232,4233,4234]],
[[123,-71,113],[123,-81,111],[142,-81,106,],0xFFFFFF,[4205,4206,4207,4231,4232,4233],[4207,4208,4209,4233,4234,4235],[4206,4207,4208,4232,4233,4234]],
[[142,-81,106],[123,-81,111],[141,-91,103,],0xFFFFFF,[4206,4207,4208,4232,4233,4234],[4207,4208,4209,4233,4234,4235],[4208,4209,4234,4235]],
[[123,-81,111],[123,-91,107],[141,-91,103,],0xFFFFFF,[4207,4208,4209,4233,4234,4235],[2281,2289,4209,4235],[4208,4209,4234,4235]],
[[180,48,-44],[187,48,-31],[182,38,-46,],0xFFFFFF,[4236,4473,4474],[4236,4237],[4236,4237,4238]],
[[187,48,-31],[189,38,-32],[182,38,-46,],0xFFFFFF,[4236,4237],[4237,4238,4239],[4236,4237,4238]],
[[182,38,-46],[189,38,-32],[184,28,-47,],0xFFFFFF,[4236,4237,4238],[4237,4238,4239],[4238,4239,4240]],
[[189,38,-32],[191,28,-32],[184,28,-47,],0xFFFFFF,[4237,4238,4239],[4239,4240,4241],[4238,4239,4240]],
[[184,28,-47],[191,28,-32],[185,18,-47,],0xFFFFFF,[4238,4239,4240],[4239,4240,4241],[4240,4241,4242]],
[[191,28,-32],[192,18,-33],[185,18,-47,],0xFFFFFF,[4239,4240,4241],[4241,4242,4243],[4240,4241,4242]],
[[185,18,-47],[192,18,-33],[186,8,-48,],0xFFFFFF,[4240,4241,4242],[4241,4242,4243],[4242,4243,4244]],
[[192,18,-33],[194,8,-33],[186,8,-48,],0xFFFFFF,[4241,4242,4243],[4243,4244,4245],[4242,4243,4244]],
[[186,8,-48],[194,8,-33],[187,-2,-48,],0xFFFFFF,[4242,4243,4244],[4243,4244,4245],[4244,4245,4246,4482,4483,4484]],
[[194,8,-33],[194,-2,-34],[187,-2,-48,],0xFFFFFF,[4243,4244,4245],[4245,4246,4247],[4244,4245,4246,4482,4483,4484]],
[[187,-2,-48],[194,-2,-34],[187,-12,-48,],0xFFFFFF,[4244,4245,4246,4482,4483,4484],[4245,4246,4247],[4246,4247,4248,4484,4485,4486]],
[[194,-2,-34],[194,-12,-34],[187,-12,-48,],0xFFFFFF,[4245,4246,4247],[4247,4248,4249],[4246,4247,4248,4484,4485,4486]],
[[187,-12,-48],[194,-12,-34],[187,-22,-48,],0xFFFFFF,[4246,4247,4248,4484,4485,4486],[4247,4248,4249],[4248,4249,4250,4486,4487,4488]],
[[194,-12,-34],[194,-22,-33],[187,-22,-48,],0xFFFFFF,[4247,4248,4249],[4249,4250,4251],[4248,4249,4250,4486,4487,4488]],
[[187,-22,-48],[194,-22,-33],[186,-32,-48,],0xFFFFFF,[4248,4249,4250,4486,4487,4488],[4249,4250,4251],[4250,4251,4252]],
[[194,-22,-33],[193,-32,-33],[186,-32,-48,],0xFFFFFF,[4249,4250,4251],[4251,4252,4253],[4250,4251,4252]],
[[186,-32,-48],[193,-32,-33],[185,-42,-47,],0xFFFFFF,[4250,4251,4252],[4251,4252,4253],[4252,4253,4254,4490,4491,4492]],
[[193,-32,-33],[192,-42,-33],[185,-42,-47,],0xFFFFFF,[4251,4252,4253],[4253,4254,4255],[4252,4253,4254,4490,4491,4492]],
[[185,-42,-47],[192,-42,-33],[183,-52,-46,],0xFFFFFF,[4252,4253,4254,4490,4491,4492],[4253,4254,4255],[4254,4255,4256,4492,4493,4494]],
[[192,-42,-33],[190,-52,-32],[183,-52,-46,],0xFFFFFF,[4253,4254,4255],[4255,4256,4257],[4254,4255,4256,4492,4493,4494]],
[[183,-52,-46],[190,-52,-32],[181,-62,-45,],0xFFFFFF,[4254,4255,4256,4492,4493,4494],[4255,4256,4257],[4256,4257,4258,4494,4495,4496]],
[[190,-52,-32],[188,-62,-31],[181,-62,-45,],0xFFFFFF,[4255,4256,4257],[4257,4258,4259],[4256,4257,4258,4494,4495,4496]],
[[181,-62,-45],[188,-62,-31],[179,-72,-43,],0xFFFFFF,[4256,4257,4258,4494,4495,4496],[4257,4258,4259],[4258,4259,4260]],
[[188,-62,-31],[185,-72,-30],[179,-72,-43,],0xFFFFFF,[4257,4258,4259],[4259,4260,4261],[4258,4259,4260]],
[[179,-72,-43],[185,-72,-30],[176,-82,-42,],0xFFFFFF,[4258,4259,4260],[4259,4260,4261],[4260,4261,4262]],
[[185,-72,-30],[182,-82,-29],[176,-82,-42,],0xFFFFFF,[4259,4260,4261],[4261,4262,4263],[4260,4261,4262]],
[[176,-82,-42],[182,-82,-29],[172,-92,-40,],0xFFFFFF,[4260,4261,4262],[4261,4262,4263],[4262,4263]],
[[182,-82,-29],[178,-92,-27],[172,-92,-40,],0xFFFFFF,[4261,4262,4263],[4263],[4262,4263]],
[[21,38,-30],[28,38,-44],[19,28,-31,],0xFFFFFF,[4264,4316,4317],[4264,4265,4317],[4264,4265,4266]],
[[28,38,-44],[26,28,-45],[19,28,-31,],0xFFFFFF,[4264,4265,4317],[846,847,4265,4266,4267,4320,4321,4322],[4264,4265,4266]],
[[19,28,-31],[26,28,-45],[18,18,-31,],0xFFFFFF,[4264,4265,4266],[846,847,4265,4266,4267,4320,4321,4322],[4266,4267,4268]],
[[26,28,-45],[25,18,-46],[18,18,-31,],0xFFFFFF,[846,847,4265,4266,4267,4320,4321,4322],[4267,4268,4269],[4266,4267,4268]],
[[18,18,-31],[25,18,-46],[17,8,-32,],0xFFFFFF,[4266,4267,4268],[4267,4268,4269],[4268,4269,4270]],
[[25,18,-46],[24,8,-47],[17,8,-32,],0xFFFFFF,[4267,4268,4269],[4269,4270,4271],[4268,4269,4270]],
[[17,8,-32],[24,8,-47],[16,-2,-32,],0xFFFFFF,[4268,4269,4270],[4269,4270,4271],[4270,4271,4272]],
[[24,8,-47],[23,-2,-47],[16,-2,-32,],0xFFFFFF,[4269,4270,4271],[4271,4272,4273],[4270,4271,4272]],
[[16,-2,-32],[23,-2,-47],[16,-12,-32,],0xFFFFFF,[4270,4271,4272],[4271,4272,4273],[4272,4273,4274]],
[[23,-2,-47],[23,-12,-47],[16,-12,-32,],0xFFFFFF,[4271,4272,4273],[4273,4274,4275,4328,4329,4330],[4272,4273,4274]],
[[16,-12,-32],[23,-12,-47],[16,-22,-32,],0xFFFFFF,[4272,4273,4274],[4273,4274,4275,4328,4329,4330],[4274,4275,4276]],
[[23,-12,-47],[23,-22,-47],[16,-22,-32,],0xFFFFFF,[4273,4274,4275,4328,4329,4330],[4275,4276,4277,4330,4331,4348],[4274,4275,4276]],
[[16,-22,-32],[23,-22,-47],[17,-32,-32,],0xFFFFFF,[4274,4275,4276],[4275,4276,4277,4330,4331,4348],[4276,4277,4278]],
[[23,-22,-47],[24,-32,-46],[17,-32,-32,],0xFFFFFF,[4275,4276,4277,4330,4331,4348],[4277,4278,4279],[4276,4277,4278]],
[[17,-32,-32],[24,-32,-46],[19,-42,-31,],0xFFFFFF,[4276,4277,4278],[4277,4278,4279],[4278,4279,4280]],
[[24,-32,-46],[25,-42,-46],[19,-42,-31,],0xFFFFFF,[4277,4278,4279],[4279,4280,4281],[4278,4279,4280]],
[[19,-42,-31],[25,-42,-46],[20,-52,-31,],0xFFFFFF,[4278,4279,4280],[4279,4280,4281],[4280,4281,4282]],
[[25,-42,-46],[27,-52,-45],[20,-52,-31,],0xFFFFFF,[4279,4280,4281],[4281,4282,4283],[4280,4281,4282]],
[[20,-52,-31],[27,-52,-45],[23,-62,-30,],0xFFFFFF,[4280,4281,4282],[4281,4282,4283],[4282,4283,4284]],
[[27,-52,-45],[29,-62,-44],[23,-62,-30,],0xFFFFFF,[4281,4282,4283],[4283,4284,4285],[4282,4283,4284]],
[[23,-62,-30],[29,-62,-44],[25,-72,-29,],0xFFFFFF,[4282,4283,4284],[4283,4284,4285],[4284,4285,4286]],
[[29,-62,-44],[32,-72,-42],[25,-72,-29,],0xFFFFFF,[4283,4284,4285],[4285,4286,4287,4356,4357,4358],[4284,4285,4286]],
[[25,-72,-29],[32,-72,-42],[29,-82,-27,],0xFFFFFF,[4284,4285,4286],[4285,4286,4287,4356,4357,4358],[4286,4287,4288]],
[[32,-72,-42],[35,-82,-40],[29,-82,-27,],0xFFFFFF,[4285,4286,4287,4356,4357,4358],[4287,4288,4289],[4286,4287,4288]],
[[29,-82,-27],[35,-82,-40],[32,-92,-26,],0xFFFFFF,[4286,4287,4288],[4287,4288,4289],[4288,4289]],
[[35,-82,-40],[38,-92,-39],[32,-92,-26,],0xFFFFFF,[4287,4288,4289],[4289,4360,4361],[4288,4289]],
[[31,38,-27],[37,38,-41],[29,28,-27,],0xFFFFFF,[4290,4318,4319],[4290,4291,4319],[4290,4291,4292]],
[[37,38,-41],[36,28,-42],[29,28,-27,],0xFFFFFF,[4290,4291,4319],[4291,4292,4293],[4290,4291,4292]],
[[29,28,-27],[36,28,-42],[27,18,-28,],0xFFFFFF,[4290,4291,4292],[4291,4292,4293],[4292,4293,4294]],
[[36,28,-42],[34,18,-43],[27,18,-28,],0xFFFFFF,[4291,4292,4293],[4293,4294,4295],[4292,4293,4294]],
[[27,18,-28],[34,18,-43],[26,8,-28,],0xFFFFFF,[4292,4293,4294],[4293,4294,4295],[4294,4295,4296]],
[[34,18,-43],[33,8,-43],[26,8,-28,],0xFFFFFF,[4293,4294,4295],[4295,4296,4297],[4294,4295,4296]],
[[26,8,-28],[33,8,-43],[26,-2,-29,],0xFFFFFF,[4294,4295,4296],[4295,4296,4297],[4296,4297,4298]],
[[33,8,-43],[33,-2,-44],[26,-2,-29,],0xFFFFFF,[4295,4296,4297],[4297,4298,4299],[4296,4297,4298]],
[[26,-2,-29],[33,-2,-44],[26,-12,-29,],0xFFFFFF,[4296,4297,4298],[4297,4298,4299],[4298,4299,4300]],
[[33,-2,-44],[33,-12,-44],[26,-12,-29,],0xFFFFFF,[4297,4298,4299],[4299,4300,4301],[4298,4299,4300]],
[[26,-12,-29],[33,-12,-44],[26,-22,-28,],0xFFFFFF,[4298,4299,4300],[4299,4300,4301],[4300,4301,4302]],
[[33,-12,-44],[33,-22,-43],[26,-22,-28,],0xFFFFFF,[4299,4300,4301],[4301,4302,4303],[4300,4301,4302]],
[[26,-22,-28],[33,-22,-43],[27,-32,-28,],0xFFFFFF,[4300,4301,4302],[4301,4302,4303],[4302,4303,4304]],
[[33,-22,-43],[34,-32,-43],[27,-32,-28,],0xFFFFFF,[4301,4302,4303],[4303,4304,4305],[4302,4303,4304]],
[[27,-32,-28],[34,-32,-43],[28,-42,-28,],0xFFFFFF,[4302,4303,4304],[4303,4304,4305],[4304,4305,4306]],
[[34,-32,-43],[35,-42,-42],[28,-42,-28,],0xFFFFFF,[4303,4304,4305],[4305,4306,4307],[4304,4305,4306]],
[[28,-42,-28],[35,-42,-42],[30,-52,-27,],0xFFFFFF,[4304,4305,4306],[4305,4306,4307],[4306,4307,4308]],
[[35,-42,-42],[36,-52,-41],[30,-52,-27,],0xFFFFFF,[4305,4306,4307],[4307,4308,4309],[4306,4307,4308]],
[[30,-52,-27],[36,-52,-41],[32,-62,-26,],0xFFFFFF,[4306,4307,4308],[4307,4308,4309],[4308,4309,4310]],
[[36,-52,-41],[38,-62,-40],[32,-62,-26,],0xFFFFFF,[4307,4308,4309],[4309,4310,4311],[4308,4309,4310]],
[[32,-62,-26],[38,-62,-40],[35,-72,-25,],0xFFFFFF,[4308,4309,4310],[4309,4310,4311],[4310,4311,4312]],
[[38,-62,-40],[41,-72,-39],[35,-72,-25,],0xFFFFFF,[4309,4310,4311],[4311,4312,4313],[4310,4311,4312]],
[[35,-72,-25],[41,-72,-39],[38,-82,-24,],0xFFFFFF,[4310,4311,4312],[4311,4312,4313],[4312,4313,4314]],
[[41,-72,-39],[44,-82,-37],[38,-82,-24,],0xFFFFFF,[4311,4312,4313],[4313,4314,4315,5356],[4312,4313,4314]],
[[38,-82,-24],[44,-82,-37],[42,-92,-23,],0xFFFFFF,[4312,4313,4314],[4313,4314,4315,5356],[4314,4315]],
[[44,-82,-37],[47,-92,-35],[42,-92,-23,],0xFFFFFF,[4313,4314,4315,5356],[4315],[4314,4315]],
[[24,48,-29],[30,48,-43],[21,38,-30,],0xFFFFFF,[4316],[4316,4317],[4264,4316,4317]],
[[30,48,-43],[28,38,-44],[21,38,-30,],0xFFFFFF,[4316,4317],[4264,4265,4317],[4264,4316,4317]],
[[33,48,-26],[40,48,-40],[31,38,-27,],0xFFFFFF,[4318],[4318,4319],[4290,4318,4319]],
[[40,48,-40],[37,38,-41],[31,38,-27,],0xFFFFFF,[4318,4319],[4290,4291,4319],[4290,4318,4319]],
[[28,38,-44],[37,38,-57],[26,28,-45,],0xFFFFFF,[4320,4344,4345],[4320,4321,4345,4625,5070],[846,847,4265,4266,4267,4320,4321,4322]],
[[37,38,-57],[35,28,-58],[26,28,-45,],0xFFFFFF,[4320,4321,4345,4625,5070],[4321,4322,4323,4625,4626,4627],[846,847,4265,4266,4267,4320,4321,4322]],
[[26,28,-45],[35,28,-58],[25,18,-46,],0xFFFFFF,[846,847,4265,4266,4267,4320,4321,4322],[4321,4322,4323,4625,4626,4627],[4322,4323,4324]],
[[35,28,-58],[34,18,-59],[25,18,-46,],0xFFFFFF,[4321,4322,4323,4625,4626,4627],[4323,4324,4325,4627,4628,4629],[4322,4323,4324]],
[[25,18,-46],[34,18,-59],[24,8,-47,],0xFFFFFF,[4322,4323,4324],[4323,4324,4325,4627,4628,4629],[4324,4325,4326]],
[[34,18,-59],[33,8,-60],[24,8,-47,],0xFFFFFF,[4323,4324,4325,4627,4628,4629],[4325,4326,4327,4440,4444,4629,4630],[4324,4325,4326]],
[[24,8,-47],[33,8,-60],[23,-2,-47,],0xFFFFFF,[4324,4325,4326],[4325,4326,4327,4440,4444,4629,4630],[4326,4327,4328]],
[[33,8,-60],[33,-2,-60],[23,-2,-47,],0xFFFFFF,[4325,4326,4327,4440,4444,4629,4630],[4327,4328,4329],[4326,4327,4328]],
[[23,-2,-47],[33,-2,-60],[23,-12,-47,],0xFFFFFF,[4326,4327,4328],[4327,4328,4329],[4273,4274,4275,4328,4329,4330]],
[[33,-2,-60],[33,-12,-61],[23,-12,-47,],0xFFFFFF,[4327,4328,4329],[4329,4330,4331],[4273,4274,4275,4328,4329,4330]],
[[23,-12,-47],[33,-12,-61],[23,-22,-47,],0xFFFFFF,[4273,4274,4275,4328,4329,4330],[4329,4330,4331],[4275,4276,4277,4330,4331,4348]],
[[33,-12,-61],[33,-22,-60],[23,-22,-47,],0xFFFFFF,[4329,4330,4331],[4331,4348,4349,4378,4379,4384],[4275,4276,4277,4330,4331,4348]],
[[37,38,-39],[46,38,-52],[35,28,-40,],0xFFFFFF,[4332,4346,4347],[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4332,4333,4334]],
[[46,38,-52],[44,28,-53],[35,28,-40,],0xFFFFFF,[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[4332,4333,4334]],
[[35,28,-40],[44,28,-53],[33,18,-41,],0xFFFFFF,[4332,4333,4334],[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[4334,4335,4336]],
[[44,28,-53],[43,18,-54],[33,18,-41,],0xFFFFFF,[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[4334,4335,4336]],
[[33,18,-41],[43,18,-54],[33,8,-42,],0xFFFFFF,[4334,4335,4336],[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[4336,4337,4338]],
[[43,18,-54],[42,8,-55],[33,8,-42,],0xFFFFFF,[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[4336,4337,4338]],
[[33,8,-42],[42,8,-55],[32,-2,-42,],0xFFFFFF,[4336,4337,4338],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[4338,4339,4340]],
[[42,8,-55],[41,-2,-55],[32,-2,-42,],0xFFFFFF,[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[4339,4340,4341],[4338,4339,4340]],
[[32,-2,-42],[41,-2,-55],[32,-12,-42,],0xFFFFFF,[4338,4339,4340],[4339,4340,4341],[4340,4341,4342]],
[[41,-2,-55],[41,-12,-56],[32,-12,-42,],0xFFFFFF,[4339,4340,4341],[4341,4342,4343],[4340,4341,4342]],
[[32,-12,-42],[41,-12,-56],[32,-22,-42,],0xFFFFFF,[4340,4341,4342],[4341,4342,4343],[4342,4343,4362]],
[[41,-12,-56],[42,-22,-55],[32,-22,-42,],0xFFFFFF,[4341,4342,4343],[4343,4362,4363],[4342,4343,4362]],
[[30,48,-43],[39,48,-55],[28,38,-44,],0xFFFFFF,[4344],[4344,4345,5070,5071],[4320,4344,4345]],
[[39,48,-55],[37,38,-57],[28,38,-44,],0xFFFFFF,[4344,4345,5070,5071],[4320,4321,4345,4625,5070],[4320,4344,4345]],
[[39,48,-38],[48,48,-50],[37,38,-39,],0xFFFFFF,[4346],[4346,4347,5071,5234,5238,5271,5275],[4332,4346,4347]],
[[48,48,-50],[46,38,-52],[37,38,-39,],0xFFFFFF,[4346,4347,5071,5234,5238,5271,5275],[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4332,4346,4347]],
[[23,-22,-47],[33,-22,-60],[24,-32,-46,],0xFFFFFF,[4275,4276,4277,4330,4331,4348],[4331,4348,4349,4378,4379,4384],[4348,4349,4350]],
[[33,-22,-60],[34,-32,-60],[24,-32,-46,],0xFFFFFF,[4331,4348,4349,4378,4379,4384],[4349,4350,4351],[4348,4349,4350]],
[[24,-32,-46],[34,-32,-60],[25,-42,-46,],0xFFFFFF,[4348,4349,4350],[4349,4350,4351],[4350,4351,4352]],
[[34,-32,-60],[35,-42,-59],[25,-42,-46,],0xFFFFFF,[4349,4350,4351],[4351,4352,4353],[4350,4351,4352]],
[[25,-42,-46],[35,-42,-59],[27,-52,-45,],0xFFFFFF,[4350,4351,4352],[4351,4352,4353],[4352,4353,4354]],
[[35,-42,-59],[36,-52,-58],[27,-52,-45,],0xFFFFFF,[4351,4352,4353],[4353,4354,4355],[4352,4353,4354]],
[[27,-52,-45],[36,-52,-58],[29,-62,-44,],0xFFFFFF,[4352,4353,4354],[4353,4354,4355],[4354,4355,4356]],
[[36,-52,-58],[38,-62,-56],[29,-62,-44,],0xFFFFFF,[4353,4354,4355],[4355,4356,4357],[4354,4355,4356]],
[[29,-62,-44],[38,-62,-56],[32,-72,-42,],0xFFFFFF,[4354,4355,4356],[4355,4356,4357],[4285,4286,4287,4356,4357,4358]],
[[38,-62,-56],[40,-72,-54],[32,-72,-42,],0xFFFFFF,[4355,4356,4357],[4357,4358,4359],[4285,4286,4287,4356,4357,4358]],
[[32,-72,-42],[40,-72,-54],[35,-82,-40,],0xFFFFFF,[4285,4286,4287,4356,4357,4358],[4357,4358,4359],[4358,4359,4360]],
[[40,-72,-54],[43,-82,-52],[35,-82,-40,],0xFFFFFF,[4357,4358,4359],[4359,4360,4361,4394,4395,4396],[4358,4359,4360]],
[[35,-82,-40],[43,-82,-52],[38,-92,-39,],0xFFFFFF,[4358,4359,4360],[4359,4360,4361,4394,4395,4396],[4289,4360,4361]],
[[43,-82,-52],[46,-92,-50],[38,-92,-39,],0xFFFFFF,[4359,4360,4361,4394,4395,4396],[4361],[4289,4360,4361]],
[[32,-22,-42],[42,-22,-55],[33,-32,-41,],0xFFFFFF,[4342,4343,4362],[4343,4362,4363],[4362,4363,4364]],
[[42,-22,-55],[42,-32,-55],[33,-32,-41,],0xFFFFFF,[4343,4362,4363],[4363,4364,4365],[4362,4363,4364]],
[[33,-32,-41],[42,-32,-55],[34,-42,-41,],0xFFFFFF,[4362,4363,4364],[4363,4364,4365],[4364,4365,4366]],
[[42,-32,-55],[43,-42,-54],[34,-42,-41,],0xFFFFFF,[4363,4364,4365],[4365,4366,4367],[4364,4365,4366]],
[[34,-42,-41],[43,-42,-54],[36,-52,-40,],0xFFFFFF,[4364,4365,4366],[4365,4366,4367],[4366,4367,4368]],
[[43,-42,-54],[45,-52,-53],[36,-52,-40,],0xFFFFFF,[4365,4366,4367],[4367,4368,4369],[4366,4367,4368]],
[[36,-52,-40],[45,-52,-53],[38,-62,-39,],0xFFFFFF,[4366,4367,4368],[4367,4368,4369],[4368,4369,4370]],
[[45,-52,-53],[47,-62,-51],[38,-62,-39,],0xFFFFFF,[4367,4368,4369],[4369,4370,4371],[4368,4369,4370]],
[[38,-62,-39],[47,-62,-51],[40,-72,-37,],0xFFFFFF,[4368,4369,4370],[4369,4370,4371],[4370,4371,4372]],
[[47,-62,-51],[49,-72,-49],[40,-72,-37,],0xFFFFFF,[4369,4370,4371],[4371,4372,4373],[4370,4371,4372]],
[[40,-72,-37],[49,-72,-49],[43,-82,-35,],0xFFFFFF,[4370,4371,4372],[4371,4372,4373],[4372,4373,4374]],
[[49,-72,-49],[52,-82,-47],[43,-82,-35,],0xFFFFFF,[4371,4372,4373],[4373,4374,4375,5351,5352,5407],[4372,4373,4374]],
[[43,-82,-35],[52,-82,-47],[47,-92,-34,],0xFFFFFF,[4372,4373,4374],[4373,4374,4375,5351,5352,5407],[4374,4375]],
[[52,-82,-47],[54,-92,-45],[47,-92,-34,],0xFFFFFF,[4373,4374,4375,5351,5352,5407],[4375,4443],[4374,4375]],
[[33,-2,-60],[48,-2,-72],[33,-12,-61,],0xFFFFFF,[4376,4444],[4376,4377,4410],[4376,4377,4378]],
[[48,-2,-72],[44,-12,-72],[33,-12,-61,],0xFFFFFF,[4376,4377,4410],[4377,4378,4379],[4376,4377,4378]],
[[33,-12,-61],[44,-12,-72],[33,-22,-60,],0xFFFFFF,[4376,4377,4378],[4377,4378,4379],[4331,4348,4349,4378,4379,4384]],
[[44,-12,-72],[45,-22,-72],[33,-22,-60,],0xFFFFFF,[4377,4378,4379],[4379,4384,4385,4412,4413,4418],[4331,4348,4349,4378,4379,4384]],
[[40,-2,-54],[55,-2,-66],[40,-12,-54,],0xFFFFFF,[4380],[4380,4381],[4380,4381,4382]],
[[55,-2,-66],[52,-12,-66],[40,-12,-54,],0xFFFFFF,[4380,4381],[4381,4382,4383],[4380,4381,4382]],
[[40,-12,-54],[52,-12,-66],[41,-22,-54,],0xFFFFFF,[4380,4381,4382],[4381,4382,4383],[4382,4383,4397]],
[[52,-12,-66],[52,-22,-66],[41,-22,-54,],0xFFFFFF,[4381,4382,4383],[4383,4397,4398],[4382,4383,4397]],
[[33,-22,-60],[45,-22,-72],[34,-32,-60,],0xFFFFFF,[4331,4348,4349,4378,4379,4384],[4379,4384,4385,4412,4413,4418],[4384,4385,4386]],
[[45,-22,-72],[45,-32,-71],[34,-32,-60,],0xFFFFFF,[4379,4384,4385,4412,4413,4418],[4385,4386,4387],[4384,4385,4386]],
[[34,-32,-60],[45,-32,-71],[35,-42,-59,],0xFFFFFF,[4384,4385,4386],[4385,4386,4387],[4386,4387,4388]],
[[45,-32,-71],[46,-42,-70],[35,-42,-59,],0xFFFFFF,[4385,4386,4387],[4387,4388,4389],[4386,4387,4388]],
[[35,-42,-59],[46,-42,-70],[36,-52,-58,],0xFFFFFF,[4386,4387,4388],[4387,4388,4389],[4388,4389,4390]],
[[46,-42,-70],[47,-52,-69],[36,-52,-58,],0xFFFFFF,[4387,4388,4389],[4389,4390,4391],[4388,4389,4390]],
[[36,-52,-58],[47,-52,-69],[38,-62,-56,],0xFFFFFF,[4388,4389,4390],[4389,4390,4391],[4390,4391,4392]],
[[47,-52,-69],[49,-62,-67],[38,-62,-56,],0xFFFFFF,[4389,4390,4391],[4391,4392,4393],[4390,4391,4392]],
[[38,-62,-56],[49,-62,-67],[40,-72,-54,],0xFFFFFF,[4390,4391,4392],[4391,4392,4393],[4392,4393,4394]],
[[49,-62,-67],[51,-72,-65],[40,-72,-54,],0xFFFFFF,[4391,4392,4393],[4393,4394,4395],[4392,4393,4394]],
[[40,-72,-54],[51,-72,-65],[43,-82,-52,],0xFFFFFF,[4392,4393,4394],[4393,4394,4395],[4359,4360,4361,4394,4395,4396]],
[[51,-72,-65],[53,-82,-62],[43,-82,-52,],0xFFFFFF,[4393,4394,4395],[4395,4396],[4359,4360,4361,4394,4395,4396]],
[[43,-82,-52],[53,-82,-62],[46,-92,-50,],0xFFFFFF,[4359,4360,4361,4394,4395,4396],[4395,4396],[4396,4442,4443]],
[[41,-22,-54],[52,-22,-66],[41,-32,-53,],0xFFFFFF,[4382,4383,4397],[4383,4397,4398],[4397,4398,4399]],
[[52,-22,-66],[53,-32,-65],[41,-32,-53,],0xFFFFFF,[4383,4397,4398],[4398,4399,4400],[4397,4398,4399]],
[[41,-32,-53],[53,-32,-65],[42,-42,-53,],0xFFFFFF,[4397,4398,4399],[4398,4399,4400],[4399,4400,4401]],
[[53,-32,-65],[54,-42,-64],[42,-42,-53,],0xFFFFFF,[4398,4399,4400],[4400,4401,4402],[4399,4400,4401]],
[[42,-42,-53],[54,-42,-64],[44,-52,-51,],0xFFFFFF,[4399,4400,4401],[4400,4401,4402],[4401,4402,4403]],
[[54,-42,-64],[55,-52,-63],[44,-52,-51,],0xFFFFFF,[4400,4401,4402],[4402,4403,4404],[4401,4402,4403]],
[[44,-52,-51],[55,-52,-63],[46,-62,-50,],0xFFFFFF,[4401,4402,4403],[4402,4403,4404],[4403,4404,4405]],
[[55,-52,-63],[56,-62,-61],[46,-62,-50,],0xFFFFFF,[4402,4403,4404],[4404,4405,4406],[4403,4404,4405]],
[[46,-62,-50],[56,-62,-61],[48,-72,-48,],0xFFFFFF,[4403,4404,4405],[4404,4405,4406],[4405,4406,4407]],
[[56,-62,-61],[58,-72,-58],[48,-72,-48,],0xFFFFFF,[4404,4405,4406],[4406,4407,4408],[4405,4406,4407]],
[[48,-72,-48],[58,-72,-58],[51,-82,-46,],0xFFFFFF,[4405,4406,4407],[4406,4407,4408],[4407,4408,4409]],
[[58,-72,-58],[61,-82,-56],[51,-82,-46,],0xFFFFFF,[4406,4407,4408],[4408,4409,5351],[4407,4408,4409]],
[[51,-82,-46],[61,-82,-56],[53,-92,-43,],0xFFFFFF,[4407,4408,4409],[4408,4409,5351],[4409]],
[[48,-2,-72],[58,-2,-82],[44,-12,-72,],0xFFFFFF,[4376,4377,4410],[4410,4411,4440,4441,4444,4609],[4410,4411,4412]],
[[58,-2,-82],[58,-12,-82],[44,-12,-72,],0xFFFFFF,[4410,4411,4440,4441,4444,4609],[4411,4412,4413,4597,4609,4610],[4410,4411,4412]],
[[44,-12,-72],[58,-12,-82],[45,-22,-72,],0xFFFFFF,[4410,4411,4412],[4411,4412,4413,4597,4609,4610],[4379,4384,4385,4412,4413,4418]],
[[58,-12,-82],[58,-22,-82],[45,-22,-72,],0xFFFFFF,[4411,4412,4413,4597,4609,4610],[4413,4418,4419,4597,4598,4607],[4379,4384,4385,4412,4413,4418]],
[[54,-2,-65],[67,-2,-74],[51,-12,-65,],0xFFFFFF,[4414],[4414,4415],[4414,4415,4416]],
[[67,-2,-74],[64,-12,-74],[51,-12,-65,],0xFFFFFF,[4414,4415],[4415,4416,4417,4597,4598,4610,5305,5306,5307],[4414,4415,4416]],
[[51,-12,-65],[64,-12,-74],[51,-22,-64,],0xFFFFFF,[4414,4415,4416],[4415,4416,4417,4597,4598,4610,5305,5306,5307],[4416,4417,4429]],
[[64,-12,-74],[65,-22,-74],[51,-22,-64,],0xFFFFFF,[4415,4416,4417,4597,4598,4610,5305,5306,5307],[4417,4429,4430,4598,4607,4608,5307,5308,5309],[4416,4417,4429]],
[[45,-22,-72],[58,-22,-82],[45,-32,-71,],0xFFFFFF,[4379,4384,4385,4412,4413,4418],[4413,4418,4419,4597,4598,4607],[4418,4419,4420]],
[[58,-22,-82],[59,-32,-81],[45,-32,-71,],0xFFFFFF,[4413,4418,4419,4597,4598,4607],[4419,4420,4421,4599,4607,4608],[4418,4419,4420]],
[[45,-32,-71],[59,-32,-81],[46,-42,-70,],0xFFFFFF,[4418,4419,4420],[4419,4420,4421,4599,4607,4608],[4420,4421,4422]],
[[59,-32,-81],[59,-42,-80],[46,-42,-70,],0xFFFFFF,[4419,4420,4421,4599,4607,4608],[4421,4422,4423,4599,4600,4601],[4420,4421,4422]],
[[46,-42,-70],[59,-42,-80],[47,-52,-69,],0xFFFFFF,[4420,4421,4422],[4421,4422,4423,4599,4600,4601],[4422,4423,4424]],
[[59,-42,-80],[60,-52,-78],[47,-52,-69,],0xFFFFFF,[4421,4422,4423,4599,4600,4601],[4423,4424,4425,4601,4602,4603],[4422,4423,4424]],
[[47,-52,-69],[60,-52,-78],[49,-62,-67,],0xFFFFFF,[4422,4423,4424],[4423,4424,4425,4601,4602,4603],[870,871,872,4424,4425,4426]],
[[60,-52,-78],[61,-62,-76],[49,-62,-67,],0xFFFFFF,[4423,4424,4425,4601,4602,4603],[4425,4426,4427,4603,4604,4605],[870,871,872,4424,4425,4426]],
[[49,-62,-67],[61,-62,-76],[51,-72,-65,],0xFFFFFF,[870,871,872,4424,4425,4426],[4425,4426,4427,4603,4604,4605],[4426,4427,4428]],
[[61,-62,-76],[63,-72,-73],[51,-72,-65,],0xFFFFFF,[4425,4426,4427,4603,4604,4605],[4427,4428,4442,4605,4606],[4426,4427,4428]],
[[51,-72,-65],[63,-72,-73],[53,-82,-62,],0xFFFFFF,[4426,4427,4428],[4427,4428,4442,4605,4606],[4428]],
[[51,-22,-64],[65,-22,-74],[52,-32,-64,],0xFFFFFF,[4416,4417,4429],[4417,4429,4430,4598,4607,4608,5307,5308,5309],[4429,4430,4431]],
[[65,-22,-74],[65,-32,-73],[52,-32,-64,],0xFFFFFF,[4417,4429,4430,4598,4607,4608,5307,5308,5309],[4430,4431,4432,4599,4600,4608,5309,5310,5313],[4429,4430,4431]],
[[52,-32,-64],[65,-32,-73],[52,-42,-63,],0xFFFFFF,[4429,4430,4431],[4430,4431,4432,4599,4600,4608,5309,5310,5313],[4431,4432,4433]],
[[65,-32,-73],[66,-42,-72],[52,-42,-63,],0xFFFFFF,[4430,4431,4432,4599,4600,4608,5309,5310,5313],[4432,4433,4434,4600,4601,4602,5311,5313,5314],[4431,4432,4433]],
[[52,-42,-63],[66,-42,-72],[54,-52,-61,],0xFFFFFF,[4431,4432,4433],[4432,4433,4434,4600,4601,4602,5311,5313,5314],[4433,4434,4435]],
[[66,-42,-72],[67,-52,-70],[54,-52,-61,],0xFFFFFF,[4432,4433,4434,4600,4601,4602,5311,5313,5314],[4434,4435,4436,4602,4603,4604,5311,5312,5315],[4433,4434,4435]],
[[54,-52,-61],[67,-52,-70],[55,-62,-59,],0xFFFFFF,[4433,4434,4435],[4434,4435,4436,4602,4603,4604,5311,5312,5315],[4435,4436,4437]],
[[67,-52,-70],[68,-62,-68],[55,-62,-59,],0xFFFFFF,[4434,4435,4436,4602,4603,4604,5311,5312,5315],[4436,4437,4438,4604,4605,4606,5315,5316,5317],[4435,4436,4437]],
[[55,-62,-59],[68,-62,-68],[57,-72,-57,],0xFFFFFF,[4435,4436,4437],[4436,4437,4438,4604,4605,4606,5315,5316,5317],[4437,4438,4439]],
[[68,-62,-68],[69,-72,-66],[57,-72,-57,],0xFFFFFF,[4436,4437,4438,4604,4605,4606,5315,5316,5317],[4438,4439,4442,4443,4606,5317,5318,5342,5343],[4437,4438,4439]],
[[57,-72,-57],[69,-72,-66],[59,-82,-54,],0xFFFFFF,[4437,4438,4439],[4438,4439,4442,4443,4606,5317,5318,5342,5343],[4439]],
[[33,8,-60],[42,8,-55],[58,-2,-82,],0xFFFFFF,[4325,4326,4327,4440,4444,4629,4630],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[4410,4411,4440,4441,4444,4609]],
[[42,8,-55],[64,-2,-74],[58,-2,-82,],0xFFFFFF,[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[4441,4609,4610,5302,5305],[4410,4411,4440,4441,4444,4609]],
[[63,-72,-73],[69,-72,-66],[46,-92,-50,],0xFFFFFF,[4427,4428,4442,4605,4606],[4438,4439,4442,4443,4606,5317,5318,5342,5343],[4396,4442,4443]],
[[69,-72,-66],[54,-92,-45],[46,-92,-50,],0xFFFFFF,[4438,4439,4442,4443,4606,5317,5318,5342,5343],[4375,4443],[4396,4442,4443]],
[[33,8,-60],[58,-2,-82],[33,-2,-60,],0xFFFFFF,[4325,4326,4327,4440,4444,4629,4630],[4410,4411,4440,4441,4444,4609],[4376,4444]],
[[171,48,-41],[177,48,-27],[173,38,-42,],0xFFFFFF,[4445],[4445,4446],[4445,4446,4447]],
[[177,48,-27],[180,38,-28],[173,38,-42,],0xFFFFFF,[4445,4446],[4446,4447,4448],[4445,4446,4447]],
[[173,38,-42],[180,38,-28],[175,28,-43,],0xFFFFFF,[4445,4446,4447],[4446,4447,4448],[4447,4448,4449]],
[[180,38,-28],[182,28,-29],[175,28,-43,],0xFFFFFF,[4446,4447,4448],[4448,4449,4450],[4447,4448,4449]],
[[175,28,-43],[182,28,-29],[176,18,-44,],0xFFFFFF,[4447,4448,4449],[4448,4449,4450],[4449,4450,4451]],
[[182,28,-29],[183,18,-29],[176,18,-44,],0xFFFFFF,[4448,4449,4450],[4450,4451,4452],[4449,4450,4451]],
[[176,18,-44],[183,18,-29],[177,8,-45,],0xFFFFFF,[4449,4450,4451],[4450,4451,4452],[4451,4452,4453]],
[[183,18,-29],[184,8,-30],[177,8,-45,],0xFFFFFF,[4450,4451,4452],[4452,4453,4454],[4451,4452,4453]],
[[177,8,-45],[184,8,-30],[177,-2,-45,],0xFFFFFF,[4451,4452,4453],[4452,4453,4454],[4453,4454,4455]],
[[184,8,-30],[185,-2,-30],[177,-2,-45,],0xFFFFFF,[4452,4453,4454],[4454,4455,4456],[4453,4454,4455]],
[[177,-2,-45],[185,-2,-30],[178,-12,-45,],0xFFFFFF,[4453,4454,4455],[4454,4455,4456],[4455,4456,4457]],
[[185,-2,-30],[185,-12,-30],[178,-12,-45,],0xFFFFFF,[4454,4455,4456],[4456,4457,4458],[4455,4456,4457]],
[[178,-12,-45],[185,-12,-30],[177,-22,-45,],0xFFFFFF,[4455,4456,4457],[4456,4457,4458],[4457,4458,4459]],
[[185,-12,-30],[185,-22,-30],[177,-22,-45,],0xFFFFFF,[4456,4457,4458],[4458,4459,4460],[4457,4458,4459]],
[[177,-22,-45],[185,-22,-30],[177,-32,-44,],0xFFFFFF,[4457,4458,4459],[4458,4459,4460],[4459,4460,4461]],
[[185,-22,-30],[184,-32,-30],[177,-32,-44,],0xFFFFFF,[4458,4459,4460],[4460,4461,4462],[4459,4460,4461]],
[[177,-32,-44],[184,-32,-30],[175,-42,-44,],0xFFFFFF,[4459,4460,4461],[4460,4461,4462],[4461,4462,4463]],
[[184,-32,-30],[183,-42,-29],[175,-42,-44,],0xFFFFFF,[4460,4461,4462],[4462,4463,4464],[4461,4462,4463]],
[[175,-42,-44],[183,-42,-29],[174,-52,-43,],0xFFFFFF,[4461,4462,4463],[4462,4463,4464],[4463,4464,4465]],
[[183,-42,-29],[181,-52,-29],[174,-52,-43,],0xFFFFFF,[4462,4463,4464],[4464,4465,4466],[4463,4464,4465]],
[[174,-52,-43],[181,-52,-29],[172,-62,-42,],0xFFFFFF,[4463,4464,4465],[4464,4465,4466],[4465,4466,4467]],
[[181,-52,-29],[179,-62,-28],[172,-62,-42,],0xFFFFFF,[4464,4465,4466],[4466,4467,4468],[4465,4466,4467]],
[[172,-62,-42],[179,-62,-28],[169,-72,-40,],0xFFFFFF,[4465,4466,4467],[4466,4467,4468],[4467,4468,4469]],
[[179,-62,-28],[176,-72,-27],[169,-72,-40,],0xFFFFFF,[4466,4467,4468],[4468,4469,4470],[4467,4468,4469]],
[[169,-72,-40],[176,-72,-27],[166,-82,-38,],0xFFFFFF,[4467,4468,4469],[4468,4469,4470],[4469,4470,4471]],
[[176,-72,-27],[172,-82,-25],[166,-82,-38,],0xFFFFFF,[4468,4469,4470],[4470,4471,4472],[4469,4470,4471]],
[[166,-82,-38],[172,-82,-25],[163,-92,-36,],0xFFFFFF,[4469,4470,4471],[4470,4471,4472],[4471,4472]],
[[172,-82,-25],[169,-92,-24],[163,-92,-36,],0xFFFFFF,[4470,4471,4472],[4472],[4471,4472]],
[[171,48,-57],[180,48,-44],[173,38,-58,],0xFFFFFF,[4473,5072,5073],[4236,4473,4474],[4473,4474,4475,4631,4632,5073]],
[[180,48,-44],[182,38,-46],[173,38,-58,],0xFFFFFF,[4236,4473,4474],[2593,2594,2886,2887,4474,4475,4476],[4473,4474,4475,4631,4632,5073]],
[[173,38,-58],[182,38,-46],[175,28,-60,],0xFFFFFF,[4473,4474,4475,4631,4632,5073],[2593,2594,2886,2887,4474,4475,4476],[4475,4476,4477,4632,4633,4634]],
[[182,38,-46],[184,28,-47],[175,28,-60,],0xFFFFFF,[2593,2594,2886,2887,4474,4475,4476],[4476,4477,4478],[4475,4476,4477,4632,4633,4634]],
[[175,28,-60],[184,28,-47],[176,18,-61,],0xFFFFFF,[4475,4476,4477,4632,4633,4634],[4476,4477,4478],[4477,4478,4479,4634,4635,4636]],
[[184,28,-47],[185,18,-47],[176,18,-61,],0xFFFFFF,[4476,4477,4478],[4478,4479,4480],[4477,4478,4479,4634,4635,4636]],
[[176,18,-61],[185,18,-47],[177,8,-61,],0xFFFFFF,[4477,4478,4479,4634,4635,4636],[4478,4479,4480],[4479,4480,4481,4562,4563,4594,4636]],
[[185,18,-47],[186,8,-48],[177,8,-61,],0xFFFFFF,[4478,4479,4480],[4480,4481,4482],[4479,4480,4481,4562,4563,4594,4636]],
[[177,8,-61],[186,8,-48],[177,-2,-62,],0xFFFFFF,[4479,4480,4481,4562,4563,4594,4636],[4480,4481,4482],[4481,4482,4483,4529,4530,4594]],
[[186,8,-48],[187,-2,-48],[177,-2,-62,],0xFFFFFF,[4480,4481,4482],[4244,4245,4246,4482,4483,4484],[4481,4482,4483,4529,4530,4594]],
[[177,-2,-62],[187,-2,-48],[177,-12,-62,],0xFFFFFF,[4481,4482,4483,4529,4530,4594],[4244,4245,4246,4482,4483,4484],[4483,4484,4485]],
[[187,-2,-48],[187,-12,-48],[177,-12,-62,],0xFFFFFF,[4244,4245,4246,4482,4483,4484],[4246,4247,4248,4484,4485,4486],[4483,4484,4485]],
[[177,-12,-62],[187,-12,-48],[177,-22,-62,],0xFFFFFF,[4483,4484,4485],[4246,4247,4248,4484,4485,4486],[4485,4486,4487]],
[[187,-12,-48],[187,-22,-48],[177,-22,-62,],0xFFFFFF,[4246,4247,4248,4484,4485,4486],[4248,4249,4250,4486,4487,4488],[4485,4486,4487]],
[[177,-22,-62],[187,-22,-48],[176,-32,-61,],0xFFFFFF,[4485,4486,4487],[4248,4249,4250,4486,4487,4488],[4487,4488,4489,4534,4535,4536]],
[[187,-22,-48],[186,-32,-48],[176,-32,-61,],0xFFFFFF,[4248,4249,4250,4486,4487,4488],[4488,4489,4490],[4487,4488,4489,4534,4535,4536]],
[[176,-32,-61],[186,-32,-48],[175,-42,-60,],0xFFFFFF,[4487,4488,4489,4534,4535,4536],[4488,4489,4490],[4489,4490,4491,4536,4537,4538]],
[[186,-32,-48],[185,-42,-47],[175,-42,-60,],0xFFFFFF,[4488,4489,4490],[4252,4253,4254,4490,4491,4492],[4489,4490,4491,4536,4537,4538]],
[[175,-42,-60],[185,-42,-47],[174,-52,-59,],0xFFFFFF,[4489,4490,4491,4536,4537,4538],[4252,4253,4254,4490,4491,4492],[4491,4492,4493]],
[[185,-42,-47],[183,-52,-46],[174,-52,-59,],0xFFFFFF,[4252,4253,4254,4490,4491,4492],[4254,4255,4256,4492,4493,4494],[4491,4492,4493]],
[[174,-52,-59],[183,-52,-46],[172,-62,-57,],0xFFFFFF,[4491,4492,4493],[4254,4255,4256,4492,4493,4494],[4493,4494,4495,4540,4541,4542]],
[[183,-52,-46],[181,-62,-45],[172,-62,-57,],0xFFFFFF,[4254,4255,4256,4492,4493,4494],[4256,4257,4258,4494,4495,4496],[4493,4494,4495,4540,4541,4542]],
[[172,-62,-57],[181,-62,-45],[170,-72,-55,],0xFFFFFF,[4493,4494,4495,4540,4541,4542],[4256,4257,4258,4494,4495,4496],[4495,4496,4497]],
[[181,-62,-45],[179,-72,-43],[170,-72,-55,],0xFFFFFF,[4256,4257,4258,4494,4495,4496],[4496,4497,4498],[4495,4496,4497]],
[[170,-72,-55],[179,-72,-43],[167,-82,-53,],0xFFFFFF,[4495,4496,4497],[4496,4497,4498],[4497,4498,4499]],
[[179,-72,-43],[176,-82,-42],[167,-82,-53,],0xFFFFFF,[4496,4497,4498],[4498,4499,4500],[4497,4498,4499]],
[[167,-82,-53],[176,-82,-42],[164,-92,-51,],0xFFFFFF,[4497,4498,4499],[4498,4499,4500],[4499,4500,4593,4596]],
[[176,-82,-42],[172,-92,-40],[164,-92,-51,],0xFFFFFF,[4498,4499,4500],[4500],[4499,4500,4593,4596]],
[[162,48,-52],[171,48,-39],[164,38,-53,],0xFFFFFF,[4501,5072,5247,5284,5325],[4501,4502],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285]],
[[171,48,-39],[174,38,-41],[164,38,-53,],0xFFFFFF,[4501,4502],[4502,4503,4504],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285]],
[[164,38,-53],[174,38,-41],[166,28,-55,],0xFFFFFF,[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285],[4502,4503,4504],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322]],
[[174,38,-41],[175,28,-42],[166,28,-55,],0xFFFFFF,[4502,4503,4504],[4504,4505,4506],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322]],
[[166,28,-55],[175,28,-42],[167,18,-56,],0xFFFFFF,[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322],[4504,4505,4506],[4505,4506,4507,4633,4634,4635,5322,5323]],
[[175,28,-42],[177,18,-42],[167,18,-56,],0xFFFFFF,[4504,4505,4506],[4506,4507,4508],[4505,4506,4507,4633,4634,4635,5322,5323]],
[[167,18,-56],[177,18,-42],[168,8,-56,],0xFFFFFF,[4505,4506,4507,4633,4634,4635,5322,5323],[4506,4507,4508],[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324]],
[[177,18,-42],[178,8,-43],[168,8,-56,],0xFFFFFF,[4506,4507,4508],[4508,4509,4510],[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324]],
[[168,8,-56],[178,8,-43],[168,-2,-57,],0xFFFFFF,[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324],[4508,4509,4510],[4509,4510,4511]],
[[178,8,-43],[178,-2,-43],[168,-2,-57,],0xFFFFFF,[4508,4509,4510],[4510,4511,4512],[4509,4510,4511]],
[[168,-2,-57],[178,-2,-43],[169,-12,-57,],0xFFFFFF,[4509,4510,4511],[4510,4511,4512],[4511,4512,4513]],
[[178,-2,-43],[178,-12,-43],[169,-12,-57,],0xFFFFFF,[4510,4511,4512],[4512,4513,4514],[4511,4512,4513]],
[[169,-12,-57],[178,-12,-43],[168,-22,-57,],0xFFFFFF,[4511,4512,4513],[4512,4513,4514],[4513,4514,4515]],
[[178,-12,-43],[178,-22,-43],[168,-22,-57,],0xFFFFFF,[4512,4513,4514],[4514,4515,4516],[4513,4514,4515]],
[[168,-22,-57],[178,-22,-43],[168,-32,-56,],0xFFFFFF,[4513,4514,4515],[4514,4515,4516],[4515,4516,4517]],
[[178,-22,-43],[177,-32,-43],[168,-32,-56,],0xFFFFFF,[4514,4515,4516],[4516,4517,4518],[4515,4516,4517]],
[[168,-32,-56],[177,-32,-43],[167,-42,-55,],0xFFFFFF,[4515,4516,4517],[4516,4517,4518],[4517,4518,4519]],
[[177,-32,-43],[176,-42,-42],[167,-42,-55,],0xFFFFFF,[4516,4517,4518],[4518,4519,4520],[4517,4518,4519]],
[[167,-42,-55],[176,-42,-42],[165,-52,-54,],0xFFFFFF,[4517,4518,4519],[4518,4519,4520],[4519,4520,4521]],
[[176,-42,-42],[175,-52,-41],[165,-52,-54,],0xFFFFFF,[4518,4519,4520],[4520,4521,4522],[4519,4520,4521]],
[[165,-52,-54],[175,-52,-41],[163,-62,-52,],0xFFFFFF,[4519,4520,4521],[4520,4521,4522],[4521,4522,4523]],
[[175,-52,-41],[173,-62,-40],[163,-62,-52,],0xFFFFFF,[4520,4521,4522],[4522,4523,4524],[4521,4522,4523]],
[[163,-62,-52],[173,-62,-40],[161,-72,-50,],0xFFFFFF,[4521,4522,4523],[4522,4523,4524],[4523,4524,4525]],
[[173,-62,-40],[170,-72,-38],[161,-72,-50,],0xFFFFFF,[4522,4523,4524],[4524,4525,4526],[4523,4524,4525]],
[[161,-72,-50],[170,-72,-38],[159,-82,-48,],0xFFFFFF,[4523,4524,4525],[4524,4525,4526],[4525,4526,4527]],
[[170,-72,-38],[167,-82,-37],[159,-82,-48,],0xFFFFFF,[4524,4525,4526],[4526,4527,4528],[4525,4526,4527]],
[[159,-82,-48],[167,-82,-37],[156,-92,-46,],0xFFFFFF,[4525,4526,4527],[4526,4527,4528],[4527,4528,4592,4593]],
[[167,-82,-37],[164,-92,-35],[156,-92,-46,],0xFFFFFF,[4526,4527,4528],[4528],[4527,4528,4592,4593]],
[[163,-2,-73],[177,-2,-62],[165,-12,-73,],0xFFFFFF,[4529],[4481,4482,4483,4529,4530,4594],[4529,4530,4531]],
[[177,-2,-62],[177,-12,-62],[165,-12,-73,],0xFFFFFF,[4481,4482,4483,4529,4530,4594],[4530,4531,4532],[4529,4530,4531]],
[[165,-12,-73],[177,-12,-62],[165,-22,-73,],0xFFFFFF,[4529,4530,4531],[4530,4531,4532],[4531,4532,4533,4567,4568,4569]],
[[177,-12,-62],[177,-22,-62],[165,-22,-73,],0xFFFFFF,[4530,4531,4532],[4532,4533,4534],[4531,4532,4533,4567,4568,4569]],
[[165,-22,-73],[177,-22,-62],[165,-32,-72,],0xFFFFFF,[4531,4532,4533,4567,4568,4569],[4532,4533,4534],[4533,4534,4535]],
[[177,-22,-62],[176,-32,-61],[165,-32,-72,],0xFFFFFF,[4532,4533,4534],[4487,4488,4489,4534,4535,4536],[4533,4534,4535]],
[[165,-32,-72],[176,-32,-61],[164,-42,-71,],0xFFFFFF,[4533,4534,4535],[4487,4488,4489,4534,4535,4536],[4535,4536,4537,4571,4572,4573]],
[[176,-32,-61],[175,-42,-60],[164,-42,-71,],0xFFFFFF,[4487,4488,4489,4534,4535,4536],[4489,4490,4491,4536,4537,4538],[4535,4536,4537,4571,4572,4573]],
[[164,-42,-71],[175,-42,-60],[163,-52,-70,],0xFFFFFF,[4535,4536,4537,4571,4572,4573],[4489,4490,4491,4536,4537,4538],[4537,4538,4539]],
[[175,-42,-60],[174,-52,-59],[163,-52,-70,],0xFFFFFF,[4489,4490,4491,4536,4537,4538],[4538,4539,4540],[4537,4538,4539]],
[[163,-52,-70],[174,-52,-59],[161,-62,-68,],0xFFFFFF,[4537,4538,4539],[4538,4539,4540],[2582,2583,2584,2875,2876,2877,4539,4540,4541]],
[[174,-52,-59],[172,-62,-57],[161,-62,-68,],0xFFFFFF,[4538,4539,4540],[4493,4494,4495,4540,4541,4542],[2582,2583,2584,2875,2876,2877,4539,4540,4541]],
[[161,-62,-68],[172,-62,-57],[159,-72,-66,],0xFFFFFF,[2582,2583,2584,2875,2876,2877,4539,4540,4541],[4493,4494,4495,4540,4541,4542],[2584,2585,2877,2878,4541,4542,4543,4589,4595]],
[[172,-62,-57],[170,-72,-55],[159,-72,-66,],0xFFFFFF,[4493,4494,4495,4540,4541,4542],[4542,4543,4544],[2584,2585,2877,2878,4541,4542,4543,4589,4595]],
[[159,-72,-66],[170,-72,-55],[157,-82,-63,],0xFFFFFF,[2584,2585,2877,2878,4541,4542,4543,4589,4595],[4542,4543,4544],[4543,4544,4595,4596]],
[[170,-72,-55],[167,-82,-53],[157,-82,-63,],0xFFFFFF,[4542,4543,4544],[4544,4596],[4543,4544,4595,4596]],
[[169,8,-55],[169,-2,-55],[158,-2,-67,],0xFFFFFF,[4545],[4545,4546,4547],[4545,4546]],
[[158,-2,-67],[169,-2,-55],[158,-12,-67,],0xFFFFFF,[4545,4546],[4545,4546,4547],[4546,4547,4548]],
[[169,-2,-55],[170,-12,-55],[158,-12,-67,],0xFFFFFF,[4545,4546,4547],[4547,4548,4549],[4546,4547,4548]],
[[158,-12,-67],[170,-12,-55],[157,-22,-67,],0xFFFFFF,[4546,4547,4548],[4547,4548,4549],[4548,4549,4550]],
[[170,-12,-55],[169,-22,-55],[157,-22,-67,],0xFFFFFF,[4547,4548,4549],[4549,4550,4551],[4548,4549,4550]],
[[157,-22,-67],[169,-22,-55],[157,-32,-66,],0xFFFFFF,[4548,4549,4550],[4549,4550,4551],[4550,4551,4552]],
[[169,-22,-55],[169,-32,-55],[157,-32,-66,],0xFFFFFF,[4549,4550,4551],[4551,4552,4553],[4550,4551,4552]],
[[157,-32,-66],[169,-32,-55],[156,-42,-65,],0xFFFFFF,[4550,4551,4552],[4551,4552,4553],[4552,4553,4554]],
[[169,-32,-55],[168,-42,-54],[156,-42,-65,],0xFFFFFF,[4551,4552,4553],[4553,4554,4555],[4552,4553,4554]],
[[156,-42,-65],[168,-42,-54],[155,-52,-64,],0xFFFFFF,[4552,4553,4554],[4553,4554,4555],[4554,4555,4556]],
[[168,-42,-54],[166,-52,-53],[155,-52,-64,],0xFFFFFF,[4553,4554,4555],[4555,4556,4557],[4554,4555,4556]],
[[155,-52,-64],[166,-52,-53],[153,-62,-62,],0xFFFFFF,[4554,4555,4556],[4555,4556,4557],[4556,4557,4558]],
[[166,-52,-53],[164,-62,-51],[153,-62,-62,],0xFFFFFF,[4555,4556,4557],[4557,4558,4559],[4556,4557,4558]],
[[153,-62,-62],[164,-62,-51],[152,-72,-59,],0xFFFFFF,[4556,4557,4558],[4557,4558,4559],[4558,4559,4560]],
[[164,-62,-51],[162,-72,-49],[152,-72,-59,],0xFFFFFF,[4557,4558,4559],[4559,4560,4561],[4558,4559,4560]],
[[152,-72,-59],[162,-72,-49],[149,-82,-57,],0xFFFFFF,[4558,4559,4560],[4559,4560,4561],[4560,4561]],
[[162,-72,-49],[160,-82,-47],[149,-82,-57,],0xFFFFFF,[4559,4560,4561],[4561],[4560,4561]],
[[168,8,-56],[177,8,-61],[145,-2,-75,],0xFFFFFF,[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324],[4479,4480,4481,4562,4563,4594,4636],[4562,4563,4611,5321,5326]],
[[177,8,-61],[152,-2,-82],[145,-2,-75,],0xFFFFFF,[4479,4480,4481,4562,4563,4594,4636],[4563,4611,4612],[4562,4563,4611,5321,5326]],
[[150,-2,-82],[163,-2,-73],[152,-12,-83,],0xFFFFFF,[4564,4594],[4564,4565],[4564,4565,4566,4612,4613,4614]],
[[163,-2,-73],[165,-12,-73],[152,-12,-83,],0xFFFFFF,[4564,4565],[4565,4566,4567],[4564,4565,4566,4612,4613,4614]],
[[152,-12,-83],[165,-12,-73],[151,-22,-82,],0xFFFFFF,[4564,4565,4566,4612,4613,4614],[4565,4566,4567],[4566,4567,4568,4614,4615,4616]],
[[165,-12,-73],[165,-22,-73],[151,-22,-82,],0xFFFFFF,[4565,4566,4567],[4531,4532,4533,4567,4568,4569],[4566,4567,4568,4614,4615,4616]],
[[151,-22,-82],[165,-22,-73],[151,-32,-82,],0xFFFFFF,[4566,4567,4568,4614,4615,4616],[4531,4532,4533,4567,4568,4569],[4568,4569,4570,4616,4617,4618]],
[[165,-22,-73],[165,-32,-72],[151,-32,-82,],0xFFFFFF,[4531,4532,4533,4567,4568,4569],[4569,4570,4571],[4568,4569,4570,4616,4617,4618]],
[[151,-32,-82],[165,-32,-72],[150,-42,-80,],0xFFFFFF,[4568,4569,4570,4616,4617,4618],[4569,4570,4571],[4570,4571,4572,4618,4619,4620]],
[[165,-32,-72],[164,-42,-71],[150,-42,-80,],0xFFFFFF,[4569,4570,4571],[4535,4536,4537,4571,4572,4573],[4570,4571,4572,4618,4619,4620]],
[[150,-42,-80],[164,-42,-71],[149,-52,-79,],0xFFFFFF,[4570,4571,4572,4618,4619,4620],[4535,4536,4537,4571,4572,4573],[4572,4573,4574,4620,4621,4622]],
[[164,-42,-71],[163,-52,-70],[149,-52,-79,],0xFFFFFF,[4535,4536,4537,4571,4572,4573],[4573,4574,4575],[4572,4573,4574,4620,4621,4622]],
[[149,-52,-79],[163,-52,-70],[148,-62,-77,],0xFFFFFF,[4572,4573,4574,4620,4621,4622],[4573,4574,4575],[4574,4575,4588,4622,4623,4624]],
[[163,-52,-70],[161,-62,-68],[148,-62,-77,],0xFFFFFF,[4573,4574,4575],[4575,4588,4589],[4574,4575,4588,4622,4623,4624]],
[[143,-2,-75],[159,-2,-66],[145,-12,-75,],0xFFFFFF,[4576],[4576,4577],[4576,4577,4578,4611,4612,4613,5326,5327,5328]],
[[159,-2,-66],[159,-12,-66],[145,-12,-75,],0xFFFFFF,[4576,4577],[4577,4578,4579],[4576,4577,4578,4611,4612,4613,5326,5327,5328]],
[[145,-12,-75],[159,-12,-66],[145,-22,-75,],0xFFFFFF,[4576,4577,4578,4611,4612,4613,5326,5327,5328],[4577,4578,4579],[4578,4579,4580,4613,4614,4615,5328,5329,5336]],
[[159,-12,-66],[159,-22,-65],[145,-22,-75,],0xFFFFFF,[4577,4578,4579],[4579,4580,4581],[4578,4579,4580,4613,4614,4615,5328,5329,5336]],
[[145,-22,-75],[159,-22,-65],[145,-32,-74,],0xFFFFFF,[4578,4579,4580,4613,4614,4615,5328,5329,5336],[4579,4580,4581],[4580,4581,4582,4615,4616,4617,5330,5336,5337]],
[[159,-22,-65],[158,-32,-65],[145,-32,-74,],0xFFFFFF,[4579,4580,4581],[4581,4582,4583],[4580,4581,4582,4615,4616,4617,5330,5336,5337]],
[[145,-32,-74],[158,-32,-65],[144,-42,-73,],0xFFFFFF,[4580,4581,4582,4615,4616,4617,5330,5336,5337],[4581,4582,4583],[4582,4583,4584,4617,4618,4619,5330,5331,5338]],
[[158,-32,-65],[157,-42,-64],[144,-42,-73,],0xFFFFFF,[4581,4582,4583],[4583,4584,4585],[4582,4583,4584,4617,4618,4619,5330,5331,5338]],
[[144,-42,-73],[157,-42,-64],[143,-52,-71,],0xFFFFFF,[4582,4583,4584,4617,4618,4619,5330,5331,5338],[4583,4584,4585],[4584,4585,4586,4619,4620,4621,5332,5338,5339]],
[[157,-42,-64],[156,-52,-62],[143,-52,-71,],0xFFFFFF,[4583,4584,4585],[4585,4586,4587],[4584,4585,4586,4619,4620,4621,5332,5338,5339]],
[[143,-52,-71],[156,-52,-62],[142,-62,-69,],0xFFFFFF,[4584,4585,4586,4619,4620,4621,5332,5338,5339],[4585,4586,4587],[4586,4587,4590,4621,4622,4623,5332,5333,5334]],
[[156,-52,-62],[155,-62,-60],[142,-62,-69,],0xFFFFFF,[4585,4586,4587],[4587,4590,4591],[4586,4587,4590,4621,4622,4623,5332,5333,5334]],
[[148,-62,-77],[161,-62,-68],[147,-72,-74,],0xFFFFFF,[4574,4575,4588,4622,4623,4624],[4575,4588,4589],[4588,4589,4592,4593,4595,4624]],
[[161,-62,-68],[159,-72,-66],[147,-72,-74,],0xFFFFFF,[4575,4588,4589],[2584,2585,2877,2878,4541,4542,4543,4589,4595],[4588,4589,4592,4593,4595,4624]],
[[142,-62,-69],[155,-62,-60],[140,-72,-66,],0xFFFFFF,[4586,4587,4590,4621,4622,4623,5332,5333,5334],[4587,4590,4591],[4590,4591,4592,4623,4624,5334,5335,5340,5341]],
[[155,-62,-60],[153,-72,-58],[140,-72,-66,],0xFFFFFF,[4587,4590,4591],[4591],[4590,4591,4592,4623,4624,5334,5335,5340,5341]],
[[140,-72,-66],[147,-72,-74],[156,-92,-46,],0xFFFFFF,[4590,4591,4592,4623,4624,5334,5335,5340,5341],[4588,4589,4592,4593,4595,4624],[4527,4528,4592,4593]],
[[147,-72,-74],[164,-92,-51],[156,-92,-46,],0xFFFFFF,[4588,4589,4592,4593,4595,4624],[4499,4500,4593,4596],[4527,4528,4592,4593]],
[[150,-2,-82],[177,8,-61],[177,-2,-62,],0xFFFFFF,[4564,4594],[4479,4480,4481,4562,4563,4594,4636],[4481,4482,4483,4529,4530,4594]],
[[147,-72,-74],[159,-72,-66],[157,-82,-63,],0xFFFFFF,[4588,4589,4592,4593,4595,4624],[2584,2585,2877,2878,4541,4542,4543,4589,4595],[4543,4544,4595,4596]],
[[157,-82,-63],[167,-82,-53],[164,-92,-51,],0xFFFFFF,[4543,4544,4595,4596],[4544,4596],[4499,4500,4593,4596]],
[[58,-12,-82],[64,-12,-74],[58,-22,-82,],0xFFFFFF,[4411,4412,4413,4597,4609,4610],[4415,4416,4417,4597,4598,4610,5305,5306,5307],[4413,4418,4419,4597,4598,4607]],
[[64,-12,-74],[65,-22,-74],[58,-22,-82,],0xFFFFFF,[4415,4416,4417,4597,4598,4610,5305,5306,5307],[4417,4429,4430,4598,4607,4608,5307,5308,5309],[4413,4418,4419,4597,4598,4607]],
[[59,-32,-81],[65,-32,-73],[59,-42,-80,],0xFFFFFF,[4419,4420,4421,4599,4607,4608],[4430,4431,4432,4599,4600,4608,5309,5310,5313],[4421,4422,4423,4599,4600,4601]],
[[65,-32,-73],[66,-42,-72],[59,-42,-80,],0xFFFFFF,[4430,4431,4432,4599,4600,4608,5309,5310,5313],[4432,4433,4434,4600,4601,4602,5311,5313,5314],[4421,4422,4423,4599,4600,4601]],
[[59,-42,-80],[66,-42,-72],[60,-52,-78,],0xFFFFFF,[4421,4422,4423,4599,4600,4601],[4432,4433,4434,4600,4601,4602,5311,5313,5314],[4423,4424,4425,4601,4602,4603]],
[[66,-42,-72],[67,-52,-70],[60,-52,-78,],0xFFFFFF,[4432,4433,4434,4600,4601,4602,5311,5313,5314],[4434,4435,4436,4602,4603,4604,5311,5312,5315],[4423,4424,4425,4601,4602,4603]],
[[60,-52,-78],[67,-52,-70],[61,-62,-76,],0xFFFFFF,[4423,4424,4425,4601,4602,4603],[4434,4435,4436,4602,4603,4604,5311,5312,5315],[4425,4426,4427,4603,4604,4605]],
[[67,-52,-70],[68,-62,-68],[61,-62,-76,],0xFFFFFF,[4434,4435,4436,4602,4603,4604,5311,5312,5315],[4436,4437,4438,4604,4605,4606,5315,5316,5317],[4425,4426,4427,4603,4604,4605]],
[[61,-62,-76],[68,-62,-68],[63,-72,-73,],0xFFFFFF,[4425,4426,4427,4603,4604,4605],[4436,4437,4438,4604,4605,4606,5315,5316,5317],[4427,4428,4442,4605,4606]],
[[68,-62,-68],[69,-72,-66],[63,-72,-73,],0xFFFFFF,[4436,4437,4438,4604,4605,4606,5315,5316,5317],[4438,4439,4442,4443,4606,5317,5318,5342,5343],[4427,4428,4442,4605,4606]],
[[58,-22,-82],[65,-22,-74],[59,-32,-81,],0xFFFFFF,[4413,4418,4419,4597,4598,4607],[4417,4429,4430,4598,4607,4608,5307,5308,5309],[4419,4420,4421,4599,4607,4608]],
[[65,-22,-74],[65,-32,-73],[59,-32,-81,],0xFFFFFF,[4417,4429,4430,4598,4607,4608,5307,5308,5309],[4430,4431,4432,4599,4600,4608,5309,5310,5313],[4419,4420,4421,4599,4607,4608]],
[[58,-2,-82],[64,-2,-74],[58,-12,-82,],0xFFFFFF,[4410,4411,4440,4441,4444,4609],[4441,4609,4610,5302,5305],[4411,4412,4413,4597,4609,4610]],
[[64,-2,-74],[64,-12,-74],[58,-12,-82,],0xFFFFFF,[4441,4609,4610,5302,5305],[4415,4416,4417,4597,4598,4610,5305,5306,5307],[4411,4412,4413,4597,4609,4610]],
[[145,-2,-75],[152,-2,-82],[145,-12,-75,],0xFFFFFF,[4562,4563,4611,5321,5326],[4563,4611,4612],[4576,4577,4578,4611,4612,4613,5326,5327,5328]],
[[152,-2,-82],[152,-12,-83],[145,-12,-75,],0xFFFFFF,[4563,4611,4612],[4564,4565,4566,4612,4613,4614],[4576,4577,4578,4611,4612,4613,5326,5327,5328]],
[[145,-12,-75],[152,-12,-83],[145,-22,-75,],0xFFFFFF,[4576,4577,4578,4611,4612,4613,5326,5327,5328],[4564,4565,4566,4612,4613,4614],[4578,4579,4580,4613,4614,4615,5328,5329,5336]],
[[152,-12,-83],[151,-22,-82],[145,-22,-75,],0xFFFFFF,[4564,4565,4566,4612,4613,4614],[4566,4567,4568,4614,4615,4616],[4578,4579,4580,4613,4614,4615,5328,5329,5336]],
[[145,-22,-75],[151,-22,-82],[145,-32,-74,],0xFFFFFF,[4578,4579,4580,4613,4614,4615,5328,5329,5336],[4566,4567,4568,4614,4615,4616],[4580,4581,4582,4615,4616,4617,5330,5336,5337]],
[[151,-22,-82],[151,-32,-82],[145,-32,-74,],0xFFFFFF,[4566,4567,4568,4614,4615,4616],[4568,4569,4570,4616,4617,4618],[4580,4581,4582,4615,4616,4617,5330,5336,5337]],
[[145,-32,-74],[151,-32,-82],[144,-42,-73,],0xFFFFFF,[4580,4581,4582,4615,4616,4617,5330,5336,5337],[4568,4569,4570,4616,4617,4618],[4582,4583,4584,4617,4618,4619,5330,5331,5338]],
[[151,-32,-82],[150,-42,-80],[144,-42,-73,],0xFFFFFF,[4568,4569,4570,4616,4617,4618],[4570,4571,4572,4618,4619,4620],[4582,4583,4584,4617,4618,4619,5330,5331,5338]],
[[144,-42,-73],[150,-42,-80],[143,-52,-71,],0xFFFFFF,[4582,4583,4584,4617,4618,4619,5330,5331,5338],[4570,4571,4572,4618,4619,4620],[4584,4585,4586,4619,4620,4621,5332,5338,5339]],
[[150,-42,-80],[149,-52,-79],[143,-52,-71,],0xFFFFFF,[4570,4571,4572,4618,4619,4620],[4572,4573,4574,4620,4621,4622],[4584,4585,4586,4619,4620,4621,5332,5338,5339]],
[[143,-52,-71],[149,-52,-79],[142,-62,-69,],0xFFFFFF,[4584,4585,4586,4619,4620,4621,5332,5338,5339],[4572,4573,4574,4620,4621,4622],[4586,4587,4590,4621,4622,4623,5332,5333,5334]],
[[149,-52,-79],[148,-62,-77],[142,-62,-69,],0xFFFFFF,[4572,4573,4574,4620,4621,4622],[4574,4575,4588,4622,4623,4624],[4586,4587,4590,4621,4622,4623,5332,5333,5334]],
[[142,-62,-69],[148,-62,-77],[140,-72,-66,],0xFFFFFF,[4586,4587,4590,4621,4622,4623,5332,5333,5334],[4574,4575,4588,4622,4623,4624],[4590,4591,4592,4623,4624,5334,5335,5340,5341]],
[[148,-62,-77],[147,-72,-74],[140,-72,-66,],0xFFFFFF,[4574,4575,4588,4622,4623,4624],[4588,4589,4592,4593,4595,4624],[4590,4591,4592,4623,4624,5334,5335,5340,5341]],
[[37,38,-57],[46,38,-52],[35,28,-58,],0xFFFFFF,[4320,4321,4345,4625,5070],[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4321,4322,4323,4625,4626,4627]],
[[46,38,-52],[44,28,-53],[35,28,-58,],0xFFFFFF,[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[4321,4322,4323,4625,4626,4627]],
[[35,28,-58],[44,28,-53],[34,18,-59,],0xFFFFFF,[4321,4322,4323,4625,4626,4627],[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[4323,4324,4325,4627,4628,4629]],
[[44,28,-53],[43,18,-54],[34,18,-59,],0xFFFFFF,[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[4323,4324,4325,4627,4628,4629]],
[[34,18,-59],[43,18,-54],[33,8,-60,],0xFFFFFF,[4323,4324,4325,4627,4628,4629],[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[4325,4326,4327,4440,4444,4629,4630]],
[[43,18,-54],[42,8,-55],[33,8,-60,],0xFFFFFF,[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[4325,4326,4327,4440,4444,4629,4630]],
[[164,38,-53],[173,38,-58],[166,28,-55,],0xFFFFFF,[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285],[4473,4474,4475,4631,4632,5073],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322]],
[[173,38,-58],[175,28,-60],[166,28,-55,],0xFFFFFF,[4473,4474,4475,4631,4632,5073],[4475,4476,4477,4632,4633,4634],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322]],
[[166,28,-55],[175,28,-60],[167,18,-56,],0xFFFFFF,[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322],[4475,4476,4477,4632,4633,4634],[4505,4506,4507,4633,4634,4635,5322,5323]],
[[175,28,-60],[176,18,-61],[167,18,-56,],0xFFFFFF,[4475,4476,4477,4632,4633,4634],[4477,4478,4479,4634,4635,4636],[4505,4506,4507,4633,4634,4635,5322,5323]],
[[167,18,-56],[176,18,-61],[168,8,-56,],0xFFFFFF,[4505,4506,4507,4633,4634,4635,5322,5323],[4477,4478,4479,4634,4635,4636],[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324]],
[[176,18,-61],[177,8,-61],[168,8,-56,],0xFFFFFF,[4477,4478,4479,4634,4635,4636],[4479,4480,4481,4562,4563,4594,4636],[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324]],
[[106,109,0],[69,99,6],[71,99,12,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4637,4638,4639],[4637,4638,4648,4649,4658]],
[[71,99,12],[69,99,6],[58,89,17,],0xFFFFFF,[4637,4638,4648,4649,4658],[4637,4638,4639],[4638,4639,4640,4649,4650,4651]],
[[69,99,6],[56,89,8],[58,89,17,],0xFFFFFF,[4637,4638,4639],[4639,4640,4641],[4638,4639,4640,4649,4650,4651]],
[[58,89,17],[56,89,8],[49,79,20,],0xFFFFFF,[4638,4639,4640,4649,4650,4651],[4639,4640,4641],[4640,4641,4642,4651,4652,4653]],
[[56,89,8],[46,79,10],[49,79,20,],0xFFFFFF,[4639,4640,4641],[4641,4642,4643],[4640,4641,4642,4651,4652,4653]],
[[49,79,20],[46,79,10],[41,69,23,],0xFFFFFF,[4640,4641,4642,4651,4652,4653],[4641,4642,4643],[4642,4643,4644,4653,4654,4655]],
[[46,79,10],[38,69,11],[41,69,23,],0xFFFFFF,[4641,4642,4643],[4643,4644,4645],[4642,4643,4644,4653,4654,4655]],
[[41,69,23],[38,69,11],[34,59,26,],0xFFFFFF,[4642,4643,4644,4653,4654,4655],[4643,4644,4645],[4644,4645,4646,4655,4656,4657]],
[[38,69,11],[30,59,13],[34,59,26,],0xFFFFFF,[4643,4644,4645],[4645,4646,4647],[4644,4645,4646,4655,4656,4657]],
[[34,59,26],[30,59,13],[28,49,28,],0xFFFFFF,[4644,4645,4646,4655,4656,4657],[4645,4646,4647],[4646,4647,4657]],
[[28,49,28],[30,59,13],[24,49,14,],0xFFFFFF,[4646,4647,4657],[4645,4646,4647],[4647,4733,4734]],
[[73,99,18],[71,99,12],[62,89,25,],0xFFFFFF,[4648,4658],[4637,4638,4648,4649,4658],[4648,4649,4650]],
[[71,99,12],[58,89,17],[62,89,25,],0xFFFFFF,[4637,4638,4648,4649,4658],[4638,4639,4640,4649,4650,4651],[4648,4649,4650]],
[[62,89,25],[58,89,17],[53,79,30,],0xFFFFFF,[4648,4649,4650],[4638,4639,4640,4649,4650,4651],[4650,4651,4652]],
[[58,89,17],[49,79,20],[53,79,30,],0xFFFFFF,[4638,4639,4640,4649,4650,4651],[4640,4641,4642,4651,4652,4653],[4650,4651,4652]],
[[53,79,30],[49,79,20],[46,69,34,],0xFFFFFF,[4650,4651,4652],[4640,4641,4642,4651,4652,4653],[4652,4653,4654]],
[[49,79,20],[41,69,23],[46,69,34,],0xFFFFFF,[4640,4641,4642,4651,4652,4653],[4642,4643,4644,4653,4654,4655],[4652,4653,4654]],
[[46,69,34],[41,69,23],[39,59,38,],0xFFFFFF,[4652,4653,4654],[4642,4643,4644,4653,4654,4655],[4654,4655,4656]],
[[41,69,23],[34,59,26],[39,59,38,],0xFFFFFF,[4642,4643,4644,4653,4654,4655],[4644,4645,4646,4655,4656,4657],[4654,4655,4656]],
[[39,59,38],[34,59,26],[34,49,41,],0xFFFFFF,[4654,4655,4656],[4644,4645,4646,4655,4656,4657],[4656,4657]],
[[34,49,41],[34,59,26],[28,49,28,],0xFFFFFF,[4656,4657],[4644,4645,4646,4655,4656,4657],[4646,4647,4657]],
[[106,109,0],[71,99,12],[73,99,18,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4637,4638,4648,4649,4658],[4648,4658]],
[[77,99,23],[73,99,18],[67,89,32,],0xFFFFFF,[4659,4669],[4659,4660,4669],[4659,4660,4661]],
[[73,99,18],[62,89,25],[67,89,32,],0xFFFFFF,[4659,4660,4669],[4660,4661,4662],[4659,4660,4661]],
[[67,89,32],[62,89,25],[59,79,38,],0xFFFFFF,[4659,4660,4661],[4660,4661,4662],[4661,4662,4663,4673,4674,4675]],
[[62,89,25],[53,79,30],[59,79,38,],0xFFFFFF,[4660,4661,4662],[4662,4663,4664],[4661,4662,4663,4673,4674,4675]],
[[59,79,38],[53,79,30],[53,69,44,],0xFFFFFF,[4661,4662,4663,4673,4674,4675],[4662,4663,4664],[4663,4664,4665]],
[[53,79,30],[46,69,34],[53,69,44,],0xFFFFFF,[4662,4663,4664],[4664,4665,4666],[4663,4664,4665]],
[[53,69,44],[46,69,34],[47,59,49,],0xFFFFFF,[4663,4664,4665],[4664,4665,4666],[4665,4666,4667]],
[[46,69,34],[39,59,38],[47,59,49,],0xFFFFFF,[4664,4665,4666],[4666,4667,4668],[4665,4666,4667]],
[[47,59,49],[39,59,38],[42,49,53,],0xFFFFFF,[4665,4666,4667],[4666,4667,4668],[4667,4668]],
[[42,49,53],[39,59,38],[34,49,41,],0xFFFFFF,[4667,4668],[4666,4667,4668],[4668]],
[[106,109,0],[73,99,18],[77,99,23,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4659,4660,4669],[4659,4669]],
[[82,99,28],[77,99,23],[73,89,38,],0xFFFFFF,[4670,4680,4681,4682,4691],[4670,4671,4680],[4670,4671,4672]],
[[77,99,23],[67,89,32],[73,89,38,],0xFFFFFF,[4670,4671,4680],[4671,4672,4673],[4670,4671,4672]],
[[73,89,38],[67,89,32],[67,79,46,],0xFFFFFF,[4670,4671,4672],[4671,4672,4673],[4672,4673,4674,4684,4685,4686]],
[[67,89,32],[59,79,38],[67,79,46,],0xFFFFFF,[4671,4672,4673],[4661,4662,4663,4673,4674,4675],[4672,4673,4674,4684,4685,4686]],
[[67,79,46],[59,79,38],[61,69,52,],0xFFFFFF,[4672,4673,4674,4684,4685,4686],[4661,4662,4663,4673,4674,4675],[4674,4675,4676,4686,4687,4688]],
[[59,79,38],[53,69,44],[61,69,52,],0xFFFFFF,[4661,4662,4663,4673,4674,4675],[4675,4676,4677],[4674,4675,4676,4686,4687,4688]],
[[61,69,52],[53,69,44],[56,59,58,],0xFFFFFF,[4674,4675,4676,4686,4687,4688],[4675,4676,4677],[4676,4677,4678]],
[[53,69,44],[47,59,49],[56,59,58,],0xFFFFFF,[4675,4676,4677],[4677,4678,4679],[4676,4677,4678]],
[[56,59,58],[47,59,49],[52,49,63,],0xFFFFFF,[4676,4677,4678],[4677,4678,4679],[4678,4679]],
[[52,49,63],[47,59,49],[42,49,53,],0xFFFFFF,[4678,4679],[4677,4678,4679],[4679]],
[[106,109,0],[77,99,23],[82,99,28,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4670,4671,4680],[4670,4680,4681,4682,4691]],
[[87,99,32],[82,99,28],[80,89,43,],0xFFFFFF,[4681,4691],[4670,4680,4681,4682,4691],[4681,4682,4683,4693,4694,4695]],
[[82,99,28],[73,89,38],[80,89,43,],0xFFFFFF,[4670,4680,4681,4682,4691],[4682,4683,4684],[4681,4682,4683,4693,4694,4695]],
[[80,89,43],[73,89,38],[75,79,52,],0xFFFFFF,[4681,4682,4683,4693,4694,4695],[4682,4683,4684],[4683,4684,4685]],
[[73,89,38],[67,79,46],[75,79,52,],0xFFFFFF,[4682,4683,4684],[4672,4673,4674,4684,4685,4686],[4683,4684,4685]],
[[75,79,52],[67,79,46],[71,69,59,],0xFFFFFF,[4683,4684,4685],[4672,4673,4674,4684,4685,4686],[4685,4686,4687]],
[[67,79,46],[61,69,52],[71,69,59,],0xFFFFFF,[4672,4673,4674,4684,4685,4686],[4674,4675,4676,4686,4687,4688],[4685,4686,4687]],
[[71,69,59],[61,69,52],[67,59,66,],0xFFFFFF,[4685,4686,4687],[4674,4675,4676,4686,4687,4688],[4687,4688,4689]],
[[61,69,52],[56,59,58],[67,59,66,],0xFFFFFF,[4674,4675,4676,4686,4687,4688],[4688,4689,4690],[4687,4688,4689]],
[[67,59,66],[56,59,58],[64,49,71,],0xFFFFFF,[4687,4688,4689],[4688,4689,4690],[4689,4690,4701]],
[[64,49,71],[56,59,58],[52,49,63,],0xFFFFFF,[4689,4690,4701],[4688,4689,4690],[4690]],
[[106,109,0],[82,99,28],[87,99,32,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4670,4680,4681,4682,4691],[4681,4691]],
[[93,99,34],[87,99,32],[88,89,47,],0xFFFFFF,[4692,4702],[4692,4693,4702],[4692,4693,4694,4704,4705,4706]],
[[87,99,32],[80,89,43],[88,89,47,],0xFFFFFF,[4692,4693,4702],[4681,4682,4683,4693,4694,4695],[4692,4693,4694,4704,4705,4706]],
[[88,89,47],[80,89,43],[85,79,56,],0xFFFFFF,[4692,4693,4694,4704,4705,4706],[4681,4682,4683,4693,4694,4695],[4694,4695,4696,4706,4707,4708]],
[[80,89,43],[75,79,52],[85,79,56,],0xFFFFFF,[4681,4682,4683,4693,4694,4695],[4695,4696,4697],[4694,4695,4696,4706,4707,4708]],
[[85,79,56],[75,79,52],[82,69,64,],0xFFFFFF,[4694,4695,4696,4706,4707,4708],[4695,4696,4697],[4696,4697,4698]],
[[75,79,52],[71,69,59],[82,69,64,],0xFFFFFF,[4695,4696,4697],[4697,4698,4699],[4696,4697,4698]],
[[82,69,64],[71,69,59],[79,59,71,],0xFFFFFF,[4696,4697,4698],[4697,4698,4699],[4698,4699,4700,4710,4711,4712]],
[[71,69,59],[67,59,66],[79,59,71,],0xFFFFFF,[4697,4698,4699],[4699,4700,4701],[4698,4699,4700,4710,4711,4712]],
[[79,59,71],[67,59,66],[77,49,77,],0xFFFFFF,[4698,4699,4700,4710,4711,4712],[4699,4700,4701],[4700,4701]],
[[77,49,77],[67,59,66],[64,49,71,],0xFFFFFF,[4700,4701],[4699,4700,4701],[4689,4690,4701]],
[[106,109,0],[87,99,32],[93,99,34,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4692,4693,4702],[4692,4702]],
[[99,99,36],[93,99,34],[97,89,49,],0xFFFFFF,[4703,4713,4714,4715,4724],[4703,4704,4713],[4703,4704,4705]],
[[93,99,34],[88,89,47],[97,89,49,],0xFFFFFF,[4703,4704,4713],[4692,4693,4694,4704,4705,4706],[4703,4704,4705]],
[[97,89,49],[88,89,47],[95,79,59,],0xFFFFFF,[4703,4704,4705],[4692,4693,4694,4704,4705,4706],[4705,4706,4707]],
[[88,89,47],[85,79,56],[95,79,59,],0xFFFFFF,[4692,4693,4694,4704,4705,4706],[4694,4695,4696,4706,4707,4708],[4705,4706,4707]],
[[95,79,59],[85,79,56],[94,69,67,],0xFFFFFF,[4705,4706,4707],[4694,4695,4696,4706,4707,4708],[4707,4708,4709,4719,4720,4721]],
[[85,79,56],[82,69,64],[94,69,67,],0xFFFFFF,[4694,4695,4696,4706,4707,4708],[4708,4709,4710],[4707,4708,4709,4719,4720,4721]],
[[94,69,67],[82,69,64],[92,59,75,],0xFFFFFF,[4707,4708,4709,4719,4720,4721],[4708,4709,4710],[4709,4710,4711,4721,4722,4723]],
[[82,69,64],[79,59,71],[92,59,75,],0xFFFFFF,[4708,4709,4710],[4698,4699,4700,4710,4711,4712],[4709,4710,4711,4721,4722,4723]],
[[92,59,75],[79,59,71],[91,49,81,],0xFFFFFF,[4709,4710,4711,4721,4722,4723],[4698,4699,4700,4710,4711,4712],[4711,4712]],
[[91,49,81],[79,59,71],[77,49,77,],0xFFFFFF,[4711,4712],[4698,4699,4700,4710,4711,4712],[4712]],
[[106,109,0],[93,99,34],[99,99,36,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4703,4704,4713],[4703,4713,4714,4715,4724]],
[[106,99,37],[99,99,36],[106,89,50,],0xFFFFFF,[4714,4724],[4703,4713,4714,4715,4724],[4714,4715,4716]],
[[99,99,36],[97,89,49],[106,89,50,],0xFFFFFF,[4703,4713,4714,4715,4724],[4715,4716,4717],[4714,4715,4716]],
[[106,89,50],[97,89,49],[106,79,60,],0xFFFFFF,[4714,4715,4716],[4715,4716,4717],[4716,4717,4718]],
[[97,89,49],[95,79,59],[106,79,60,],0xFFFFFF,[4715,4716,4717],[4717,4718,4719],[4716,4717,4718]],
[[106,79,60],[95,79,59],[106,69,68,],0xFFFFFF,[4716,4717,4718],[4717,4718,4719],[4718,4719,4720]],
[[95,79,59],[94,69,67],[106,69,68,],0xFFFFFF,[4717,4718,4719],[4707,4708,4709,4719,4720,4721],[4718,4719,4720]],
[[106,69,68],[94,69,67],[105,59,76,],0xFFFFFF,[4718,4719,4720],[4707,4708,4709,4719,4720,4721],[4720,4721,4722]],
[[94,69,67],[92,59,75],[105,59,76,],0xFFFFFF,[4707,4708,4709,4719,4720,4721],[4709,4710,4711,4721,4722,4723],[4720,4721,4722]],
[[105,59,76],[92,59,75],[105,49,82,],0xFFFFFF,[4720,4721,4722],[4709,4710,4711,4721,4722,4723],[4722,4723]],
[[105,49,82],[92,59,75],[91,49,81,],0xFFFFFF,[4722,4723],[4709,4710,4711,4721,4722,4723],[4723]],
[[106,109,0],[99,99,36],[106,99,37,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4703,4713,4714,4715,4724],[4714,4724]],
[[69,99,6],[68,99,0],[56,89,8,],0xFFFFFF,[4725,4735],[4725,4726,4735],[4725,4726,4727]],
[[68,99,0],[55,89,0],[56,89,8,],0xFFFFFF,[4725,4726,4735],[4726,4727,4728],[4725,4726,4727]],
[[56,89,8],[55,89,0],[46,79,10,],0xFFFFFF,[4725,4726,4727],[4726,4727,4728],[4727,4728,4729]],
[[55,89,0],[45,79,0],[46,79,10,],0xFFFFFF,[4726,4727,4728],[4728,4729,4730],[4727,4728,4729]],
[[46,79,10],[45,79,0],[38,69,11,],0xFFFFFF,[4727,4728,4729],[4728,4729,4730],[4729,4730,4731]],
[[45,79,0],[37,69,0],[38,69,11,],0xFFFFFF,[4728,4729,4730],[4730,4731,4732,4740,4741,4742],[4729,4730,4731]],
[[38,69,11],[37,69,0],[30,59,13,],0xFFFFFF,[4729,4730,4731],[4730,4731,4732,4740,4741,4742],[4731,4732,4733]],
[[37,69,0],[29,59,0],[30,59,13,],0xFFFFFF,[4730,4731,4732,4740,4741,4742],[4732,4733,4734,4742,4743,4744],[4731,4732,4733]],
[[30,59,13],[29,59,0],[24,49,14,],0xFFFFFF,[4731,4732,4733],[4732,4733,4734,4742,4743,4744],[4647,4733,4734]],
[[24,49,14],[29,59,0],[23,49,0,],0xFFFFFF,[4647,4733,4734],[4732,4733,4734,4742,4743,4744],[4734]],
[[106,109,0],[68,99,0],[69,99,6,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4725,4726,4735],[4725,4735]],
[[68,99,0],[69,99,-6],[55,89,0,],0xFFFFFF,[4736,4746],[4736,4737,4746],[4736,4737,4738]],
[[69,99,-6],[56,89,-8],[55,89,0,],0xFFFFFF,[4736,4737,4746],[4737,4738,4739],[4736,4737,4738]],
[[55,89,0],[56,89,-8],[45,79,0,],0xFFFFFF,[4736,4737,4738],[4737,4738,4739],[4738,4739,4740]],
[[56,89,-8],[46,79,-10],[45,79,0,],0xFFFFFF,[4737,4738,4739],[4739,4740,4741],[4738,4739,4740]],
[[45,79,0],[46,79,-10],[37,69,0,],0xFFFFFF,[4738,4739,4740],[4739,4740,4741],[4730,4731,4732,4740,4741,4742]],
[[46,79,-10],[38,69,-11],[37,69,0,],0xFFFFFF,[4739,4740,4741],[4741,4742,4743],[4730,4731,4732,4740,4741,4742]],
[[37,69,0],[38,69,-11],[29,59,0,],0xFFFFFF,[4730,4731,4732,4740,4741,4742],[4741,4742,4743],[4732,4733,4734,4742,4743,4744]],
[[38,69,-11],[30,59,-13],[29,59,0,],0xFFFFFF,[4741,4742,4743],[4743,4744,4745],[4732,4733,4734,4742,4743,4744]],
[[29,59,0],[30,59,-13],[23,49,0,],0xFFFFFF,[4732,4733,4734,4742,4743,4744],[4743,4744,4745],[4744,4745]],
[[23,49,0],[30,59,-13],[24,49,-14,],0xFFFFFF,[4744,4745],[4743,4744,4745],[4745]],
[[106,109,0],[69,99,-6],[68,99,0,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4736,4737,4746],[4736,4746]],
[[69,99,-6],[71,99,-12],[56,89,-8,],0xFFFFFF,[4747,4757],[4747,4748,4757],[4747,4748,4749]],
[[71,99,-12],[58,89,-17],[56,89,-8,],0xFFFFFF,[4747,4748,4757],[4748,4749,4750],[4747,4748,4749]],
[[56,89,-8],[58,89,-17],[46,79,-10,],0xFFFFFF,[4747,4748,4749],[4748,4749,4750],[4749,4750,4751]],
[[58,89,-17],[49,79,-20],[46,79,-10,],0xFFFFFF,[4748,4749,4750],[4750,4751,4752],[4749,4750,4751]],
[[46,79,-10],[49,79,-20],[38,69,-11,],0xFFFFFF,[4749,4750,4751],[4750,4751,4752],[4751,4752,4753]],
[[49,79,-20],[41,69,-23],[38,69,-11,],0xFFFFFF,[4750,4751,4752],[4752,4753,4754,4762,4763,4764],[4751,4752,4753]],
[[38,69,-11],[41,69,-23],[30,59,-13,],0xFFFFFF,[4751,4752,4753],[4752,4753,4754,4762,4763,4764],[4753,4754,4755]],
[[41,69,-23],[34,59,-26],[30,59,-13,],0xFFFFFF,[4752,4753,4754,4762,4763,4764],[4754,4755,4756,4764,4765,4766],[4753,4754,4755]],
[[30,59,-13],[34,59,-26],[24,49,-14,],0xFFFFFF,[4753,4754,4755],[4754,4755,4756,4764,4765,4766],[4755,4756]],
[[24,49,-14],[34,59,-26],[28,49,-28,],0xFFFFFF,[4755,4756],[4754,4755,4756,4764,4765,4766],[4756,4766,4767]],
[[106,109,0],[71,99,-12],[69,99,-6,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4747,4748,4757],[4747,4757]],
[[71,99,-12],[73,99,-18],[58,89,-17,],0xFFFFFF,[4758,4768],[4758,4759,4768],[4758,4759,4760]],
[[73,99,-18],[62,89,-25],[58,89,-17,],0xFFFFFF,[4758,4759,4768],[4759,4760,4761],[4758,4759,4760]],
[[58,89,-17],[62,89,-25],[49,79,-20,],0xFFFFFF,[4758,4759,4760],[4759,4760,4761],[4760,4761,4762]],
[[62,89,-25],[53,79,-30],[49,79,-20,],0xFFFFFF,[4759,4760,4761],[4761,4762,4763,5019,5020,5038],[4760,4761,4762]],
[[49,79,-20],[53,79,-30],[41,69,-23,],0xFFFFFF,[4760,4761,4762],[4761,4762,4763,5019,5020,5038],[4752,4753,4754,4762,4763,4764]],
[[53,79,-30],[46,69,-34],[41,69,-23,],0xFFFFFF,[4761,4762,4763,5019,5020,5038],[4763,4764,4765,5020,5021,5022],[4752,4753,4754,4762,4763,4764]],
[[41,69,-23],[46,69,-34],[34,59,-26,],0xFFFFFF,[4752,4753,4754,4762,4763,4764],[4763,4764,4765,5020,5021,5022],[4754,4755,4756,4764,4765,4766]],
[[46,69,-34],[39,59,-38],[34,59,-26,],0xFFFFFF,[4763,4764,4765,5020,5021,5022],[4765,4766,4767,4905,5022,5023],[4754,4755,4756,4764,4765,4766]],
[[34,59,-26],[39,59,-38],[28,49,-28,],0xFFFFFF,[4754,4755,4756,4764,4765,4766],[4765,4766,4767,4905,5022,5023],[4756,4766,4767]],
[[28,49,-28],[39,59,-38],[34,49,-41,],0xFFFFFF,[4756,4766,4767],[4765,4766,4767,4905,5022,5023],[4767]],
[[106,109,0],[73,99,-18],[71,99,-12,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4758,4759,4768],[4758,4768]],
[[138,99,-18],[141,99,-12],[149,89,-24,],0xFFFFFF,[4769,4774,4959,4960,4961],[4769,4770,4774],[4769,4770,4778]],
[[141,99,-12],[153,89,-16],[149,89,-24,],0xFFFFFF,[4769,4770,4774],[4770,4778,4779,4780,4781,4788],[4769,4770,4778]],
[[171,69,-22],[178,59,-24],[172,59,-36,],0xFFFFFF,[4771,4775,4777,4785,4786,4787],[4771,4772,4773],[4771,4772,4775,5060,5061]],
[[172,59,-36],[178,59,-24],[178,49,-39,],0xFFFFFF,[4771,4772,4775,5060,5061],[4771,4772,4773],[4772,4773]],
[[178,59,-24],[183,49,-26],[178,49,-39,],0xFFFFFF,[4771,4772,4773],[4773],[4772,4773]],
[[106,109,0],[141,99,-12],[138,99,-18,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4769,4770,4774],[4769,4774,4959,4960,4961]],
[[166,69,-33],[171,69,-22],[172,59,-36,],0xFFFFFF,[4775,4776,4777,5061,5062,5063,5064],[4771,4775,4777,4785,4786,4787],[4771,4772,4775,5060,5061]],
[[158,79,-29],[163,79,-19],[166,69,-33,],0xFFFFFF,[4776,4778,4779,5064,5065,5066],[4776,4777,4779],[4775,4776,4777,5061,5062,5063,5064]],
[[163,79,-19],[171,69,-22],[166,69,-33,],0xFFFFFF,[4776,4777,4779],[4771,4775,4777,4785,4786,4787],[4775,4776,4777,5061,5062,5063,5064]],
[[149,89,-24],[153,89,-16],[158,79,-29,],0xFFFFFF,[4769,4770,4778],[4770,4778,4779,4780,4781,4788],[4776,4778,4779,5064,5065,5066]],
[[153,89,-16],[163,79,-19],[158,79,-29,],0xFFFFFF,[4770,4778,4779,4780,4781,4788],[4776,4777,4779],[4776,4778,4779,5064,5065,5066]],
[[141,99,-12],[142,99,-5],[153,89,-16,],0xFFFFFF,[4780,4790],[4780,4781,4790],[4770,4778,4779,4780,4781,4788]],
[[142,99,-5],[155,89,-7],[153,89,-16,],0xFFFFFF,[4780,4781,4790],[4781,4788,4789],[4770,4778,4779,4780,4781,4788]],
[[174,69,-10],[181,59,-11],[178,59,-24,],0xFFFFFF,[4782,4785,4787],[4782,4783,4784],[4782,4783,4785]],
[[178,59,-24],[181,59,-11],[183,49,-26,],0xFFFFFF,[4782,4783,4785],[4782,4783,4784],[4783,4784]],
[[181,59,-11],[187,49,-12],[183,49,-26,],0xFFFFFF,[4782,4783,4784],[4784],[4783,4784]],
[[171,69,-22],[174,69,-10],[178,59,-24,],0xFFFFFF,[4771,4775,4777,4785,4786,4787],[4782,4785,4787],[4782,4783,4785]],
[[163,79,-19],[165,79,-9],[171,69,-22,],0xFFFFFF,[4786,4788,4789],[4786,4787,4789],[4771,4775,4777,4785,4786,4787]],
[[165,79,-9],[174,69,-10],[171,69,-22,],0xFFFFFF,[4786,4787,4789],[4782,4785,4787],[4771,4775,4777,4785,4786,4787]],
[[153,89,-16],[155,89,-7],[163,79,-19,],0xFFFFFF,[4770,4778,4779,4780,4781,4788],[4781,4788,4789],[4786,4788,4789]],
[[155,89,-7],[165,79,-9],[163,79,-19,],0xFFFFFF,[4781,4788,4789],[4786,4787,4789],[4786,4788,4789]],
[[106,109,0],[142,99,-5],[141,99,-12,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4780,4781,4790],[4780,4790]],
[[142,99,-5],[143,99,0],[155,89,-7,],0xFFFFFF,[4791,4801],[4791,4792,4801],[4791,4792,4799]],
[[143,99,0],[156,89,0],[155,89,-7,],0xFFFFFF,[4791,4792,4801],[4792,4799,4800],[4791,4792,4799]],
[[174,69,1],[182,59,1],[181,59,-11,],0xFFFFFF,[4793,4796,4798],[4793,4794,4795],[4793,4794,4796]],
[[181,59,-11],[182,59,1],[187,49,-12,],0xFFFFFF,[4793,4794,4796],[4793,4794,4795],[4794,4795]],
[[182,59,1],[188,49,1],[187,49,-12,],0xFFFFFF,[4793,4794,4795],[4795],[4794,4795]],
[[174,69,-10],[174,69,1],[181,59,-11,],0xFFFFFF,[4796,4797,4798],[4793,4796,4798],[4793,4794,4796]],
[[165,79,-9],[166,79,1],[174,69,-10,],0xFFFFFF,[4797,4799,4800],[4797,4798,4800],[4796,4797,4798]],
[[166,79,1],[174,69,1],[174,69,-10,],0xFFFFFF,[4797,4798,4800],[4793,4796,4798],[4796,4797,4798]],
[[155,89,-7],[156,89,0],[165,79,-9,],0xFFFFFF,[4791,4792,4799],[4792,4799,4800],[4797,4799,4800]],
[[156,89,0],[166,79,1],[165,79,-9,],0xFFFFFF,[4792,4799,4800],[4797,4798,4800],[4797,4799,4800]],
[[106,109,0],[143,99,0],[142,99,-5,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4791,4792,4801],[4791,4801]],
[[143,99,0],[142,99,7],[156,89,0,],0xFFFFFF,[4802,4812],[4802,4803,4812],[4802,4803,4810]],
[[142,99,7],[155,89,9],[156,89,0,],0xFFFFFF,[4802,4803,4812],[4803,4810,4811],[4802,4803,4810]],
[[173,69,13],[180,59,14],[182,59,1,],0xFFFFFF,[4804,4807,4809],[4804,4805,4806],[4804,4805,4807]],
[[182,59,1],[180,59,14],[188,49,1,],0xFFFFFF,[4804,4805,4807],[4804,4805,4806],[4805,4806]],
[[180,59,14],[186,49,15],[188,49,1,],0xFFFFFF,[4804,4805,4806],[4806],[4805,4806]],
[[174,69,1],[173,69,13],[182,59,1,],0xFFFFFF,[4807,4808,4809],[4804,4807,4809],[4804,4805,4807]],
[[166,79,1],[165,79,11],[174,69,1,],0xFFFFFF,[4808,4810,4811],[4808,4809,4811],[4807,4808,4809]],
[[165,79,11],[173,69,13],[174,69,1,],0xFFFFFF,[4808,4809,4811],[4804,4807,4809],[4807,4808,4809]],
[[156,89,0],[155,89,9],[166,79,1,],0xFFFFFF,[4802,4803,4810],[4803,4810,4811],[4808,4810,4811]],
[[155,89,9],[165,79,11],[166,79,1,],0xFFFFFF,[4803,4810,4811],[4808,4809,4811],[4808,4810,4811]],
[[106,109,0],[142,99,7],[143,99,0,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4802,4803,4812],[4802,4812]],
[[142,99,7],[140,99,13],[155,89,9,],0xFFFFFF,[4813,4823],[4813,4814,4823],[4813,4814,4821]],
[[140,99,13],[152,89,17],[155,89,9,],0xFFFFFF,[4813,4814,4823],[4814,4821,4822],[4813,4814,4821]],
[[170,69,24],[177,59,27],[180,59,14,],0xFFFFFF,[4815,4818,4820,4829,4830,4831],[4815,4816,4817],[4815,4816,4818]],
[[180,59,14],[177,59,27],[186,49,15,],0xFFFFFF,[4815,4816,4818],[4815,4816,4817],[4816,4817]],
[[177,59,27],[182,49,29],[186,49,15,],0xFFFFFF,[4815,4816,4817],[4817],[4816,4817]],
[[173,69,13],[170,69,24],[180,59,14,],0xFFFFFF,[4818,4819,4820],[4815,4818,4820,4829,4830,4831],[4815,4816,4818]],
[[165,79,11],[162,79,21],[173,69,13,],0xFFFFFF,[4819,4821,4822],[4819,4820,4822,4830,4832,4833],[4818,4819,4820]],
[[162,79,21],[170,69,24],[173,69,13,],0xFFFFFF,[4819,4820,4822,4830,4832,4833],[4815,4818,4820,4829,4830,4831],[4818,4819,4820]],
[[155,89,9],[152,89,17],[165,79,11,],0xFFFFFF,[4813,4814,4821],[4814,4821,4822],[4819,4821,4822]],
[[152,89,17],[162,79,21],[165,79,11,],0xFFFFFF,[4814,4821,4822],[4819,4820,4822,4830,4832,4833],[4819,4821,4822]],
[[106,109,0],[140,99,13],[142,99,7,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4813,4814,4823],[4813,4823]],
[[140,99,13],[137,99,19],[152,89,17,],0xFFFFFF,[4824,4834],[4824,4825,4834,4835,4845],[4824,4825,4832]],
[[137,99,19],[149,89,25],[152,89,17,],0xFFFFFF,[4824,4825,4834,4835,4845],[4825,4832,4833],[4824,4825,4832]],
[[165,69,35],[171,59,39],[177,59,27,],0xFFFFFF,[4826,4829,4831],[4826,4827,4828],[4826,4827,4829]],
[[177,59,27],[171,59,39],[182,49,29,],0xFFFFFF,[4826,4827,4829],[4826,4827,4828],[4827,4828]],
[[171,59,39],[176,49,42],[182,49,29,],0xFFFFFF,[4826,4827,4828],[4828],[4827,4828]],
[[170,69,24],[165,69,35],[177,59,27,],0xFFFFFF,[4815,4818,4820,4829,4830,4831],[4826,4829,4831],[4826,4827,4829]],
[[162,79,21],[157,79,31],[170,69,24,],0xFFFFFF,[4819,4820,4822,4830,4832,4833],[4830,4831,4833],[4815,4818,4820,4829,4830,4831]],
[[157,79,31],[165,69,35],[170,69,24,],0xFFFFFF,[4830,4831,4833],[4826,4829,4831],[4815,4818,4820,4829,4830,4831]],
[[152,89,17],[149,89,25],[162,79,21,],0xFFFFFF,[4824,4825,4832],[4825,4832,4833],[4819,4820,4822,4830,4832,4833]],
[[149,89,25],[157,79,31],[162,79,21,],0xFFFFFF,[4825,4832,4833],[4830,4831,4833],[4819,4820,4822,4830,4832,4833]],
[[106,109,0],[137,99,19],[140,99,13,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4824,4825,4834,4835,4845],[4824,4834]],
[[137,99,19],[134,99,24],[149,89,25,],0xFFFFFF,[4824,4825,4834,4835,4845],[4835,4836,4845],[4835,4836,4843]],
[[134,99,24],[143,89,32],[149,89,25,],0xFFFFFF,[4835,4836,4845],[4836,4843,4844],[4835,4836,4843]],
[[158,69,45],[163,59,50],[171,59,39,],0xFFFFFF,[4837,4840,4842,4851,4852,4853],[4837,4838,4839,4848,4849,4851],[4837,4838,4840]],
[[171,59,39],[163,59,50],[176,49,42,],0xFFFFFF,[4837,4838,4840],[4837,4838,4839,4848,4849,4851],[4838,4839]],
[[163,59,50],[168,49,54],[176,49,42,],0xFFFFFF,[4837,4838,4839,4848,4849,4851],[4839,4849,4850],[4838,4839]],
[[165,69,35],[158,69,45],[171,59,39,],0xFFFFFF,[4840,4841,4842],[4837,4840,4842,4851,4852,4853],[4837,4838,4840]],
[[157,79,31],[151,79,39],[165,69,35,],0xFFFFFF,[4841,4843,4844],[4841,4842,4844,4852,4854,4855],[4840,4841,4842]],
[[151,79,39],[158,69,45],[165,69,35,],0xFFFFFF,[4841,4842,4844,4852,4854,4855],[4837,4840,4842,4851,4852,4853],[4840,4841,4842]],
[[149,89,25],[143,89,32],[157,79,31,],0xFFFFFF,[4835,4836,4843],[4836,4843,4844],[4841,4843,4844]],
[[143,89,32],[151,79,39],[157,79,31,],0xFFFFFF,[4836,4843,4844],[4841,4842,4844,4852,4854,4855],[4841,4843,4844]],
[[106,109,0],[134,99,24],[137,99,19,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4835,4836,4845],[4824,4825,4834,4835,4845]],
[[134,99,24],[129,99,28],[143,89,32,],0xFFFFFF,[4846,4856],[4846,4847,4856],[4846,4847,4854]],
[[129,99,28],[137,89,38],[143,89,32,],0xFFFFFF,[4846,4847,4856],[4847,4854,4855],[4846,4847,4854]],
[[149,69,53],[153,59,59],[163,59,50,],0xFFFFFF,[4848,4851,4853,4862,4863,4864],[4848,4849,4850],[4837,4838,4839,4848,4849,4851]],
[[163,59,50],[153,59,59],[168,49,54,],0xFFFFFF,[4837,4838,4839,4848,4849,4851],[4848,4849,4850],[4839,4849,4850]],
[[153,59,59],[157,49,64],[168,49,54,],0xFFFFFF,[4848,4849,4850],[4850],[4839,4849,4850]],
[[158,69,45],[149,69,53],[163,59,50,],0xFFFFFF,[4837,4840,4842,4851,4852,4853],[4848,4851,4853,4862,4863,4864],[4837,4838,4839,4848,4849,4851]],
[[151,79,39],[144,79,46],[158,69,45,],0xFFFFFF,[4841,4842,4844,4852,4854,4855],[4852,4853,4855],[4837,4840,4842,4851,4852,4853]],
[[144,79,46],[149,69,53],[158,69,45,],0xFFFFFF,[4852,4853,4855],[4848,4851,4853,4862,4863,4864],[4837,4840,4842,4851,4852,4853]],
[[143,89,32],[137,89,38],[151,79,39,],0xFFFFFF,[4846,4847,4854],[4847,4854,4855],[4841,4842,4844,4852,4854,4855]],
[[137,89,38],[144,79,46],[151,79,39,],0xFFFFFF,[4847,4854,4855],[4852,4853,4855],[4841,4842,4844,4852,4854,4855]],
[[106,109,0],[129,99,28],[134,99,24,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4846,4847,4856],[4846,4856]],
[[129,99,28],[124,99,32],[137,89,38,],0xFFFFFF,[4857,4867],[4857,4858,4867],[4857,4858,4865]],
[[124,99,32],[130,89,43],[137,89,38,],0xFFFFFF,[4857,4858,4867],[4858,4865,4866],[4857,4858,4865]],
[[139,69,60],[142,59,66],[153,59,59,],0xFFFFFF,[4859,4862,4864,4873,4874,4875],[4859,4860,4861],[4859,4860,4862]],
[[153,59,59],[142,59,66],[157,49,64,],0xFFFFFF,[4859,4860,4862],[4859,4860,4861],[4860,4861]],
[[142,59,66],[145,49,72],[157,49,64,],0xFFFFFF,[4859,4860,4861],[4861,4871,4872],[4860,4861]],
[[149,69,53],[139,69,60],[153,59,59,],0xFFFFFF,[4848,4851,4853,4862,4863,4864],[4859,4862,4864,4873,4874,4875],[4859,4860,4862]],
[[144,79,46],[135,79,52],[149,69,53,],0xFFFFFF,[4863,4865,4866],[4863,4864,4866],[4848,4851,4853,4862,4863,4864]],
[[135,79,52],[139,69,60],[149,69,53,],0xFFFFFF,[4863,4864,4866],[4859,4862,4864,4873,4874,4875],[4848,4851,4853,4862,4863,4864]],
[[137,89,38],[130,89,43],[144,79,46,],0xFFFFFF,[4857,4858,4865],[4858,4865,4866],[4863,4865,4866]],
[[130,89,43],[135,79,52],[144,79,46,],0xFFFFFF,[4858,4865,4866],[4863,4864,4866],[4863,4865,4866]],
[[106,109,0],[124,99,32],[129,99,28,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4857,4858,4867],[4857,4867]],
[[124,99,32],[118,99,35],[130,89,43,],0xFFFFFF,[4868,4878],[4868,4869,4878,4879,4889],[4868,4869,4876]],
[[118,99,35],[122,89,47],[130,89,43,],0xFFFFFF,[4868,4869,4878,4879,4889],[4869,4876,4877,4879,4880,4887],[4868,4869,4876]],
[[128,69,65],[130,59,72],[142,59,66,],0xFFFFFF,[4870,4873,4875,4884,4885,4886],[4870,4871,4872,4881,4882,4884],[4870,4871,4873]],
[[142,59,66],[130,59,72],[145,49,72,],0xFFFFFF,[4870,4871,4873],[4870,4871,4872,4881,4882,4884],[4861,4871,4872]],
[[130,59,72],[132,49,77],[145,49,72,],0xFFFFFF,[4870,4871,4872,4881,4882,4884],[4872,4882,4883],[4861,4871,4872]],
[[139,69,60],[128,69,65],[142,59,66,],0xFFFFFF,[4859,4862,4864,4873,4874,4875],[4870,4873,4875,4884,4885,4886],[4870,4871,4873]],
[[135,79,52],[125,79,57],[139,69,60,],0xFFFFFF,[4874,4876,4877],[4874,4875,4877],[4859,4862,4864,4873,4874,4875]],
[[125,79,57],[128,69,65],[139,69,60,],0xFFFFFF,[4874,4875,4877],[4870,4873,4875,4884,4885,4886],[4859,4862,4864,4873,4874,4875]],
[[130,89,43],[122,89,47],[135,79,52,],0xFFFFFF,[4868,4869,4876],[4869,4876,4877,4879,4880,4887],[4874,4876,4877]],
[[122,89,47],[125,79,57],[135,79,52,],0xFFFFFF,[4869,4876,4877,4879,4880,4887],[4874,4875,4877],[4874,4876,4877]],
[[106,109,0],[118,99,35],[124,99,32,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4868,4869,4878,4879,4889],[4868,4878]],
[[118,99,35],[111,99,36],[122,89,47,],0xFFFFFF,[4868,4869,4878,4879,4889],[4879,4880,4889],[4869,4876,4877,4879,4880,4887]],
[[111,99,36],[113,89,49],[122,89,47,],0xFFFFFF,[4879,4880,4889],[4880,4887,4888],[4869,4876,4877,4879,4880,4887]],
[[116,69,68],[117,59,75],[130,59,72,],0xFFFFFF,[4881,4884,4886,4895,4896,4897],[4881,4882,4883,4892,4893,4895],[4870,4871,4872,4881,4882,4884]],
[[130,59,72],[117,59,75],[132,49,77,],0xFFFFFF,[4870,4871,4872,4881,4882,4884],[4881,4882,4883,4892,4893,4895],[4872,4882,4883]],
[[117,59,75],[118,49,81],[132,49,77,],0xFFFFFF,[4881,4882,4883,4892,4893,4895],[4883],[4872,4882,4883]],
[[128,69,65],[116,69,68],[130,59,72,],0xFFFFFF,[4870,4873,4875,4884,4885,4886],[4881,4884,4886,4895,4896,4897],[4870,4871,4872,4881,4882,4884]],
[[125,79,57],[115,79,59],[128,69,65,],0xFFFFFF,[4885,4887,4888],[4885,4886,4888],[4870,4873,4875,4884,4885,4886]],
[[115,79,59],[116,69,68],[128,69,65,],0xFFFFFF,[4885,4886,4888],[4881,4884,4886,4895,4896,4897],[4870,4873,4875,4884,4885,4886]],
[[122,89,47],[113,89,49],[125,79,57,],0xFFFFFF,[4869,4876,4877,4879,4880,4887],[4880,4887,4888],[4885,4887,4888]],
[[113,89,49],[115,79,59],[125,79,57,],0xFFFFFF,[4880,4887,4888],[4885,4886,4888],[4885,4887,4888]],
[[106,109,0],[111,99,36],[118,99,35,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4879,4880,4889],[4868,4869,4878,4879,4889]],
[[111,99,36],[105,99,37],[113,89,49,],0xFFFFFF,[4890,4900],[4890,4891,4900],[4890,4891,4898]],
[[105,99,37],[105,89,50],[113,89,49,],0xFFFFFF,[4890,4891,4900],[4891,4898,4899],[4890,4891,4898]],
[[104,69,68],[104,59,76],[117,59,75,],0xFFFFFF,[4892,4895,4897],[4892,4893,4894],[4881,4882,4883,4892,4893,4895]],
[[117,59,75],[104,59,76],[118,49,81,],0xFFFFFF,[4881,4882,4883,4892,4893,4895],[4892,4893,4894],[4893,4894]],
[[104,59,76],[104,49,82],[118,49,81,],0xFFFFFF,[4892,4893,4894],[4894],[4893,4894]],
[[116,69,68],[104,69,68],[117,59,75,],0xFFFFFF,[4881,4884,4886,4895,4896,4897],[4892,4895,4897],[4881,4882,4883,4892,4893,4895]],
[[115,79,59],[104,79,60],[116,69,68,],0xFFFFFF,[4896,4898,4899],[4896,4897,4899],[4881,4884,4886,4895,4896,4897]],
[[104,79,60],[104,69,68],[116,69,68,],0xFFFFFF,[4896,4897,4899],[4892,4895,4897],[4881,4884,4886,4895,4896,4897]],
[[113,89,49],[105,89,50],[115,79,59,],0xFFFFFF,[4890,4891,4898],[4891,4898,4899],[4896,4898,4899]],
[[105,89,50],[104,79,60],[115,79,59,],0xFFFFFF,[4891,4898,4899],[4896,4897,4899],[4896,4898,4899]],
[[106,109,0],[105,99,37],[111,99,36,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4890,4891,4900],[4890,4900]],
[[73,99,-18],[77,99,-23],[62,89,-25,],0xFFFFFF,[4901,4907],[4901,4902,4907],[4901,4902,4903]],
[[77,99,-23],[67,89,-32],[62,89,-25,],0xFFFFFF,[4901,4902,4907],[4902,4903,4904,4908,4909,4910],[4901,4902,4903]],
[[62,89,-25],[67,89,-32],[53,79,-30,],0xFFFFFF,[4901,4902,4903],[4902,4903,4904,4908,4909,4910],[4903,4904]],
[[67,89,-32],[59,79,-38],[53,79,-30,],0xFFFFFF,[4902,4903,4904,4908,4909,4910],[4904,5036,5037,5038],[4903,4904]],
[[39,59,-38],[47,59,-49],[34,49,-41,],0xFFFFFF,[4765,4766,4767,4905,5022,5023],[4905,4906,5023,5024,5025],[4905,4906]],
[[34,49,-41],[47,59,-49],[42,49,-53,],0xFFFFFF,[4905,4906],[4905,4906,5023,5024,5025],[4906]],
[[106,109,0],[77,99,-23],[73,99,-18,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4901,4902,4907],[4901,4907]],
[[77,99,-23],[82,99,-28],[67,89,-32,],0xFFFFFF,[4908,4914],[4908,4909,4914],[4902,4903,4904,4908,4909,4910]],
[[82,99,-28],[73,89,-38],[67,89,-32,],0xFFFFFF,[4908,4909,4914],[4909,4910,4911],[4902,4903,4904,4908,4909,4910]],
[[67,89,-32],[73,89,-38],[59,79,-38,],0xFFFFFF,[4902,4903,4904,4908,4909,4910],[4909,4910,4911],[4910,4911]],
[[73,89,-38],[67,79,-46],[59,79,-38,],0xFFFFFF,[4909,4910,4911],[4911,5034,5035,5036],[4910,4911]],
[[47,59,-49],[56,59,-58],[42,49,-53,],0xFFFFFF,[4912],[4912,4913,5025,5027,5039],[4912,4913]],
[[42,49,-53],[56,59,-58],[52,49,-63,],0xFFFFFF,[4912,4913],[4912,4913,5025,5027,5039],[4913]],
[[106,109,0],[82,99,-28],[77,99,-23,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4908,4909,4914],[4908,4914]],
[[82,99,-28],[87,99,-32],[73,89,-38,],0xFFFFFF,[4915,4921],[4915,4916,4921],[4915,4916,4917]],
[[87,99,-32],[80,89,-43],[73,89,-38,],0xFFFFFF,[4915,4916,4921],[4916,4917,4918],[4915,4916,4917]],
[[73,89,-38],[80,89,-43],[67,79,-46,],0xFFFFFF,[4915,4916,4917],[4916,4917,4918],[4917,4918]],
[[80,89,-43],[75,79,-52],[67,79,-46,],0xFFFFFF,[4916,4917,4918],[4918,5032,5033,5034],[4917,4918]],
[[56,59,-58],[67,59,-66],[52,49,-63,],0xFFFFFF,[4919],[4919,4920,5027,5028,5029,5030,5096,5097,5112],[4919,4920]],
[[52,49,-63],[67,59,-66],[64,49,-71,],0xFFFFFF,[4919,4920],[4919,4920,5027,5028,5029,5030,5096,5097,5112],[4920]],
[[106,109,0],[87,99,-32],[82,99,-28,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4915,4916,4921],[4915,4921]],
[[87,99,-32],[93,99,-34],[80,89,-43,],0xFFFFFF,[4922,4932],[4922,4923,4932,4933,4943],[4922,4923,4924]],
[[93,99,-34],[88,89,-47],[80,89,-43,],0xFFFFFF,[4922,4923,4932,4933,4943],[4923,4924,4925,4933,4934,4935],[4922,4923,4924]],
[[80,89,-43],[88,89,-47],[75,79,-52,],0xFFFFFF,[4922,4923,4924],[4923,4924,4925,4933,4934,4935],[4924,4925,4926]],
[[88,89,-47],[85,79,-56],[75,79,-52,],0xFFFFFF,[4923,4924,4925,4933,4934,4935],[4925,4926,4927],[4924,4925,4926]],
[[75,79,-52],[85,79,-56],[71,69,-59,],0xFFFFFF,[4924,4925,4926],[4925,4926,4927],[4926,4927,4928,5030,5031,5032]],
[[85,79,-56],[82,69,-64],[71,69,-59,],0xFFFFFF,[4925,4926,4927],[4927,4928,4929,5097,5098,5099],[4926,4927,4928,5030,5031,5032]],
[[71,69,-59],[82,69,-64],[67,59,-66,],0xFFFFFF,[4926,4927,4928,5030,5031,5032],[4927,4928,4929,5097,5098,5099],[4928,4929,4930]],
[[82,69,-64],[79,59,-71],[67,59,-66,],0xFFFFFF,[4927,4928,4929,5097,5098,5099],[4929,4930,4931,4939,4940,4941],[4928,4929,4930]],
[[67,59,-66],[79,59,-71],[64,49,-71,],0xFFFFFF,[4928,4929,4930],[4929,4930,4931,4939,4940,4941],[4930,4931]],
[[64,49,-71],[79,59,-71],[77,49,-77,],0xFFFFFF,[4930,4931],[4929,4930,4931,4939,4940,4941],[4931]],
[[106,109,0],[93,99,-34],[87,99,-32,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4922,4923,4932,4933,4943],[4922,4932]],
[[93,99,-34],[99,99,-36],[88,89,-47,],0xFFFFFF,[4922,4923,4932,4933,4943],[4933,4934,4943,4944,4954],[4923,4924,4925,4933,4934,4935]],
[[99,99,-36],[97,89,-49],[88,89,-47,],0xFFFFFF,[4933,4934,4943,4944,4954],[4934,4935,4936],[4923,4924,4925,4933,4934,4935]],
[[88,89,-47],[97,89,-49],[85,79,-56,],0xFFFFFF,[4923,4924,4925,4933,4934,4935],[4934,4935,4936],[4935,4936,4937]],
[[97,89,-49],[95,79,-59],[85,79,-56,],0xFFFFFF,[4934,4935,4936],[4936,4937,4938,5099,5100,5101],[4935,4936,4937]],
[[85,79,-56],[95,79,-59],[82,69,-64,],0xFFFFFF,[4935,4936,4937],[4936,4937,4938,5099,5100,5101],[4937,4938,4939]],
[[95,79,-59],[94,69,-67],[82,69,-64,],0xFFFFFF,[4936,4937,4938,5099,5100,5101],[4938,4939,4940],[4937,4938,4939]],
[[82,69,-64],[94,69,-67],[79,59,-71,],0xFFFFFF,[4937,4938,4939],[4938,4939,4940],[4929,4930,4931,4939,4940,4941]],
[[94,69,-67],[92,59,-75],[79,59,-71,],0xFFFFFF,[4938,4939,4940],[4940,4941,4942],[4929,4930,4931,4939,4940,4941]],
[[79,59,-71],[92,59,-75],[77,49,-77,],0xFFFFFF,[4929,4930,4931,4939,4940,4941],[4940,4941,4942],[4941,4942]],
[[77,49,-77],[92,59,-75],[91,49,-81,],0xFFFFFF,[4941,4942],[4940,4941,4942],[4942]],
[[106,109,0],[99,99,-36],[93,99,-34,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4933,4934,4943,4944,4954],[4922,4923,4932,4933,4943]],
[[99,99,-36],[105,99,-37],[97,89,-49,],0xFFFFFF,[4933,4934,4943,4944,4954],[4944,4945,4954,4998,5008],[4944,4945,4946]],
[[105,99,-37],[106,89,-50],[97,89,-49,],0xFFFFFF,[4944,4945,4954,4998,5008],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[4944,4945,4946]],
[[97,89,-49],[106,89,-50],[95,79,-59,],0xFFFFFF,[4944,4945,4946],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[4946,4947,4948]],
[[106,89,-50],[106,79,-60],[95,79,-59,],0xFFFFFF,[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[4947,4948,4949,5000,5001,5002],[4946,4947,4948]],
[[95,79,-59],[106,79,-60],[94,69,-67,],0xFFFFFF,[4946,4947,4948],[4947,4948,4949,5000,5001,5002],[4948,4949,4950]],
[[106,79,-60],[105,69,-68],[94,69,-67,],0xFFFFFF,[4947,4948,4949,5000,5001,5002],[4949,4950,4951,5002,5003,5004],[4948,4949,4950]],
[[94,69,-67],[105,69,-68],[92,59,-75,],0xFFFFFF,[4948,4949,4950],[4949,4950,4951,5002,5003,5004],[4950,4951,4952]],
[[105,69,-68],[105,59,-76],[92,59,-75,],0xFFFFFF,[4949,4950,4951,5002,5003,5004],[4951,4952,4953,5004,5005,5006],[4950,4951,4952]],
[[92,59,-75],[105,59,-76],[91,49,-81,],0xFFFFFF,[4950,4951,4952],[4951,4952,4953,5004,5005,5006],[4952,4953]],
[[91,49,-81],[105,59,-76],[105,49,-82,],0xFFFFFF,[4952,4953],[4951,4952,4953,5004,5005,5006],[4953,5006,5007]],
[[106,109,0],[105,99,-37],[99,99,-36,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4944,4945,4954,4998,5008],[4933,4934,4943,4944,4954]],
[[165,59,-47],[172,59,-36],[170,49,-51,],0xFFFFFF,[4955,4962,4963,5058,5059,5060],[4955,4956],[4955,4956]],
[[172,59,-36],[178,49,-39],[170,49,-51,],0xFFFFFF,[4955,4956],[4956],[4955,4956]],
[[144,89,-31],[149,89,-24],[152,79,-38,],0xFFFFFF,[4957,4959,4960],[4957,4958,4960],[4957,4958,4965,5066,5067,5068]],
[[149,89,-24],[158,79,-29],[152,79,-38,],0xFFFFFF,[4957,4958,4960],[4958],[4957,4958,4965,5066,5067,5068]],
[[134,99,-23],[138,99,-18],[144,89,-31,],0xFFFFFF,[4959,4961,4966,4967,4968],[4769,4774,4959,4960,4961],[4957,4959,4960]],
[[138,99,-18],[149,89,-24],[144,89,-31,],0xFFFFFF,[4769,4774,4959,4960,4961],[4957,4958,4960],[4957,4959,4960]],
[[106,109,0],[138,99,-18],[134,99,-23,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4769,4774,4959,4960,4961],[4959,4961,4966,4967,4968]],
[[156,59,-57],[165,59,-47],[160,49,-62,],0xFFFFFF,[4962,4969,4970,5056,5057,5058],[4955,4962,4963,5058,5059,5060],[4962,4963]],
[[165,59,-47],[170,49,-51],[160,49,-62,],0xFFFFFF,[4955,4962,4963,5058,5059,5060],[4963],[4962,4963]],
[[138,89,-37],[144,89,-31],[145,79,-45,],0xFFFFFF,[4964,4966,4967],[4964,4965,4967],[4964,4965,5050,5068,5069]],
[[144,89,-31],[152,79,-38],[145,79,-45,],0xFFFFFF,[4964,4965,4967],[4957,4958,4965,5066,5067,5068],[4964,4965,5050,5068,5069]],
[[130,99,-28],[134,99,-23],[138,89,-37,],0xFFFFFF,[4966,4968,4973,4974,4975],[4959,4961,4966,4967,4968],[4964,4966,4967]],
[[134,99,-23],[144,89,-31],[138,89,-37,],0xFFFFFF,[4959,4961,4966,4967,4968],[4964,4965,4967],[4964,4966,4967]],
[[106,109,0],[134,99,-23],[130,99,-28,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4959,4961,4966,4967,4968],[4966,4968,4973,4974,4975]],
[[145,59,-65],[156,59,-57],[148,49,-70,],0xFFFFFF,[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[4962,4969,4970,5056,5057,5058],[4969,4970,4978]],
[[156,59,-57],[160,49,-62],[148,49,-70,],0xFFFFFF,[4962,4969,4970,5056,5057,5058],[4970],[4969,4970,4978]],
[[131,89,-43],[138,89,-37],[137,79,-51,],0xFFFFFF,[4971,4973,4974],[4971,4972,4974],[4971,4972,5050,5051]],
[[138,89,-37],[145,79,-45],[137,79,-51,],0xFFFFFF,[4971,4972,4974],[4972],[4971,4972,5050,5051]],
[[125,99,-31],[130,99,-28],[131,89,-43,],0xFFFFFF,[4973,4975],[4966,4968,4973,4974,4975],[4971,4973,4974]],
[[130,99,-28],[138,89,-37],[131,89,-43,],0xFFFFFF,[4966,4968,4973,4974,4975],[4971,4972,4974],[4971,4973,4974]],
[[106,109,0],[130,99,-28],[125,99,-31,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4966,4968,4973,4974,4975],[4973,4975]],
[[141,69,-59],[145,59,-65],[133,59,-71,],0xFFFFFF,[4976,4979,4981,5051,5052,5053],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[4976,4977,4979]],
[[133,59,-71],[145,59,-65],[135,49,-76,],0xFFFFFF,[4976,4977,4979],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[4977,4978,4989]],
[[145,59,-65],[148,49,-70],[135,49,-76,],0xFFFFFF,[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[4969,4970,4978],[4977,4978,4989]],
[[130,69,-64],[141,69,-59],[133,59,-71,],0xFFFFFF,[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[4976,4979,4981,5051,5052,5053],[4976,4977,4979]],
[[127,79,-56],[137,79,-51],[130,69,-64,],0xFFFFFF,[4980,4982,4983],[4980,4981,4983],[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110]],
[[137,79,-51],[141,69,-59],[130,69,-64,],0xFFFFFF,[4980,4981,4983],[4976,4979,4981,5051,5052,5053],[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110]],
[[123,89,-46],[131,89,-43],[127,79,-56,],0xFFFFFF,[4982,4984,4985,4993,4994,4996],[4982,4983,4985],[4980,4982,4983]],
[[131,89,-43],[137,79,-51],[127,79,-56,],0xFFFFFF,[4982,4983,4985],[4980,4981,4983],[4980,4982,4983]],
[[119,99,-34],[125,99,-31],[123,89,-46,],0xFFFFFF,[4984,4986],[4984,4985,4986],[4982,4984,4985,4993,4994,4996]],
[[125,99,-31],[131,89,-43],[123,89,-46,],0xFFFFFF,[4984,4985,4986],[4982,4983,4985],[4982,4984,4985,4993,4994,4996]],
[[106,109,0],[125,99,-31],[119,99,-34,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4984,4985,4986],[4984,4986]],
[[130,69,-64],[133,59,-71],[120,59,-74,],0xFFFFFF,[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[4987,4988,4989],[4987,4988,4990,5005,5006,5007]],
[[120,59,-74],[133,59,-71],[121,49,-80,],0xFFFFFF,[4987,4988,4990,5005,5006,5007],[4987,4988,4989],[4988,4989,5007]],
[[133,59,-71],[135,49,-76],[121,49,-80,],0xFFFFFF,[4987,4988,4989],[4977,4978,4989],[4988,4989,5007]],
[[119,69,-67],[130,69,-64],[120,59,-74,],0xFFFFFF,[4990,4991,4992,5003,5004,5005],[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[4987,4988,4990,5005,5006,5007]],
[[117,79,-59],[127,79,-56],[119,69,-67,],0xFFFFFF,[4991,4993,4994,5001,5002,5003,5109,5110],[4991,4992,4994],[4990,4991,4992,5003,5004,5005]],
[[127,79,-56],[130,69,-64],[119,69,-67,],0xFFFFFF,[4991,4992,4994],[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[4990,4991,4992,5003,5004,5005]],
[[115,89,-49],[123,89,-46],[117,79,-59,],0xFFFFFF,[4993,4995,4996,4999,5000,5001],[4982,4984,4985,4993,4994,4996],[4991,4993,4994,5001,5002,5003,5109,5110]],
[[123,89,-46],[127,79,-56],[117,79,-59,],0xFFFFFF,[4982,4984,4985,4993,4994,4996],[4991,4992,4994],[4991,4993,4994,5001,5002,5003,5109,5110]],
[[113,99,-36],[119,99,-34],[115,89,-49,],0xFFFFFF,[4995,4997,4998,4999,5008],[4995,4996,4997],[4993,4995,4996,4999,5000,5001]],
[[119,99,-34],[123,89,-46],[115,89,-49,],0xFFFFFF,[4995,4996,4997],[4982,4984,4985,4993,4994,4996],[4993,4995,4996,4999,5000,5001]],
[[106,109,0],[119,99,-34],[113,99,-36,],0xFFFFFF,[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4995,4996,4997],[4995,4997,4998,4999,5008]],
[[105,99,-37],[113,99,-36],[106,89,-50,],0xFFFFFF,[4944,4945,4954,4998,5008],[4995,4997,4998,4999,5008],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109]],
[[113,99,-36],[115,89,-49],[106,89,-50,],0xFFFFFF,[4995,4997,4998,4999,5008],[4993,4995,4996,4999,5000,5001],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109]],
[[106,89,-50],[115,89,-49],[106,79,-60,],0xFFFFFF,[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[4993,4995,4996,4999,5000,5001],[4947,4948,4949,5000,5001,5002]],
[[115,89,-49],[117,79,-59],[106,79,-60,],0xFFFFFF,[4993,4995,4996,4999,5000,5001],[4991,4993,4994,5001,5002,5003,5109,5110],[4947,4948,4949,5000,5001,5002]],
[[106,79,-60],[117,79,-59],[105,69,-68,],0xFF0000,[4947,4948,4949,5000,5001,5002],[4991,4993,4994,5001,5002,5003,5109,5110],[4949,4950,4951,5002,5003,5004]],
[[117,79,-59],[119,69,-67],[105,69,-68,],0xFF0000,[4991,4993,4994,5001,5002,5003,5109,5110],[4990,4991,4992,5003,5004,5005],[4949,4950,4951,5002,5003,5004]],
[[105,69,-68],[119,69,-67],[105,59,-76,],0xFF0000,[4949,4950,4951,5002,5003,5004],[4990,4991,4992,5003,5004,5005],[4951,4952,4953,5004,5005,5006]],
[[119,69,-67],[120,59,-74],[105,59,-76,],0xFFFFFF,[4990,4991,4992,5003,5004,5005],[4987,4988,4990,5005,5006,5007],[4951,4952,4953,5004,5005,5006]],
[[105,59,-76],[120,59,-74],[105,49,-82,],0xFFFFFF,[4951,4952,4953,5004,5005,5006],[4987,4988,4990,5005,5006,5007],[4953,5006,5007]],
[[120,59,-74],[121,49,-80],[105,49,-82,],0xFFFFFF,[4987,4988,4990,5005,5006,5007],[4988,4989,5007],[4953,5006,5007]],
[[105,99,-37],[106,109,0],[113,99,-36,],0xFFFFFF,[4944,4945,4954,4998,5008],[4637,4658,4669,4680,4691,4702,4713,4724,4735,4746,4757,4768,4774,4790,4801,4812,4823,4834,4845,4856,4867,4878,4889,4900,4907,4914,4921,4932,4943,4954,4961,4968,4975,4986,4997,5008],[4995,4997,4998,4999,5008]],
[[67,69,-37],[65,64,-37],[60,69,0,],0xFFFF00,[5009,5018,5031,5032,5033],[5009,5010,5029,5030,5031],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[65,64,-37],[62,62,-37],[60,69,0,],0xFFFFFF,[5009,5010,5029,5030,5031],[5010,5011,5028,5029],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[62,62,-37],[57,62,-37],[60,69,0,],0xFFFFFF,[5010,5011,5028,5029],[5011,5012,5027,5028,5039],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[57,62,-37],[54,64,-37],[60,69,0,],0xFFFFFF,[5011,5012,5027,5028,5039],[5012,5013,5024,5025,5039],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[54,64,-37],[53,69,-37],[60,69,0,],0xFFFF00,[5012,5013,5024,5025,5039],[5013,5014,5021,5022,5023,5024],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[53,69,-37],[54,73,-37],[60,69,0,],0xFFFF00,[5013,5014,5021,5022,5023,5024],[5014,5015,5019,5020,5021],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[54,73,-37],[57,75,-37],[60,69,0,],0xFFFF00,[5014,5015,5019,5020,5021],[5015,5016,5019,5037,5038],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[57,75,-37],[62,75,-37],[60,69,0,],0xFFFF00,[5015,5016,5019,5037,5038],[5016,5017,5035,5036,5037],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[62,75,-37],[65,73,-37],[60,69,0,],0xFFFF00,[5016,5017,5035,5036,5037],[5017,5018,5033,5034,5035],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[65,73,-37],[67,69,-37],[60,69,0,],0xFFFF00,[5017,5018,5033,5034,5035],[5009,5018,5031,5032,5033],[5009,5010,5011,5012,5013,5014,5015,5016,5017,5018]],
[[57,75,-37],[54,73,-37],[53,79,-30,],0xFFFFFF,[5015,5016,5019,5037,5038],[5014,5015,5019,5020,5021],[4761,4762,4763,5019,5020,5038]],
[[54,73,-37],[46,69,-34],[53,79,-30,],0xFFFFFF,[5014,5015,5019,5020,5021],[4763,4764,4765,5020,5021,5022],[4761,4762,4763,5019,5020,5038]],
[[53,69,-37],[46,69,-34],[54,73,-37,],0xFFFFFF,[5013,5014,5021,5022,5023,5024],[4763,4764,4765,5020,5021,5022],[5014,5015,5019,5020,5021]],
[[53,69,-37],[39,59,-38],[46,69,-34,],0xFFFFFF,[5013,5014,5021,5022,5023,5024],[4765,4766,4767,4905,5022,5023],[4763,4764,4765,5020,5021,5022]],
[[53,69,-37],[47,59,-49],[39,59,-38,],0xFFFFFF,[5013,5014,5021,5022,5023,5024],[4905,4906,5023,5024,5025],[4765,4766,4767,4905,5022,5023]],
[[47,59,-49],[53,69,-37],[54,64,-37,],0xFFFFFF,[4905,4906,5023,5024,5025],[5013,5014,5021,5022,5023,5024],[5012,5013,5024,5025,5039]],
[[54,64,-37],[56,59,-58],[47,59,-49,],0xFFFFFF,[5012,5013,5024,5025,5039],[4912,4913,5025,5027,5039],[4905,4906,5023,5024,5025]],
[[57,61,-37],[57,61,-37],[56,58,-58,],0xFFFFFF,[5026,5026],[5026,5026],[5026]],
[[57,62,-37],[67,59,-66],[56,59,-58,],0xFFFFFF,[5011,5012,5027,5028,5039],[4919,4920,5027,5028,5029,5030,5096,5097,5112],[4912,4913,5025,5027,5039]],
[[57,62,-37],[62,62,-37],[67,59,-66,],0xFFFFFF,[5011,5012,5027,5028,5039],[5010,5011,5028,5029],[4919,4920,5027,5028,5029,5030,5096,5097,5112]],
[[62,62,-37],[65,64,-37],[67,59,-66,],0xFFFFFF,[5010,5011,5028,5029],[5009,5010,5029,5030,5031],[4919,4920,5027,5028,5029,5030,5096,5097,5112]],
[[65,64,-37],[71,69,-59],[67,59,-66,],0xFFFFFF,[5009,5010,5029,5030,5031],[4926,4927,4928,5030,5031,5032],[4919,4920,5027,5028,5029,5030,5096,5097,5112]],
[[65,64,-37],[67,69,-37],[71,69,-59,],0xFFFFFF,[5009,5010,5029,5030,5031],[5009,5018,5031,5032,5033],[4926,4927,4928,5030,5031,5032]],
[[67,69,-37],[75,79,-52],[71,69,-59,],0xFFFFFF,[5009,5018,5031,5032,5033],[4918,5032,5033,5034],[4926,4927,4928,5030,5031,5032]],
[[67,69,-37],[65,73,-37],[75,79,-52,],0xFFFFFF,[5009,5018,5031,5032,5033],[5017,5018,5033,5034,5035],[4918,5032,5033,5034]],
[[65,73,-37],[67,79,-46],[75,79,-52,],0xFFFFFF,[5017,5018,5033,5034,5035],[4911,5034,5035,5036],[4918,5032,5033,5034]],
[[65,73,-37],[62,75,-37],[67,79,-46,],0xFFFFFF,[5017,5018,5033,5034,5035],[5016,5017,5035,5036,5037],[4911,5034,5035,5036]],
[[62,75,-37],[59,79,-38],[67,79,-46,],0xFFFFFF,[5016,5017,5035,5036,5037],[4904,5036,5037,5038],[4911,5034,5035,5036]],
[[62,75,-37],[57,75,-37],[59,79,-38,],0xFFFFFF,[5016,5017,5035,5036,5037],[5015,5016,5019,5037,5038],[4904,5036,5037,5038]],
[[57,75,-37],[53,79,-30],[59,79,-38,],0xFFFFFF,[5015,5016,5019,5037,5038],[4761,4762,4763,5019,5020,5038],[4904,5036,5037,5038]],
[[54,64,-37],[57,62,-37],[56,59,-58,],0xFFFFFF,[5012,5013,5024,5025,5039],[5011,5012,5027,5028,5039],[4912,4913,5025,5027,5039]],
[[145,69,-36],[146,73,-36],[152,69,0,],0xFFFF00,[5040,5049,5052,5053,5054],[5040,5041,5050,5051,5052,5069],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[146,73,-36],[149,75,-36],[152,69,0,],0xFFFF00,[5040,5041,5050,5051,5052,5069],[5041,5042,5067,5068,5069],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[149,75,-36],[154,75,-36],[152,69,0,],0xFFFF00,[5041,5042,5067,5068,5069],[5042,5043,5065,5066,5067],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[154,75,-36],[157,73,-36],[152,69,0,],0xFFFF00,[5042,5043,5065,5066,5067],[5043,5044,5063,5064,5065],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[157,73,-36],[159,69,-36],[152,69,0,],0xFFFF00,[5043,5044,5063,5064,5065],[5044,5045,5062,5063],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[159,69,-36],[157,64,-36],[152,69,0,],0xFFFF00,[5044,5045,5062,5063],[5045,5046,5059,5060,5061,5062],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[157,64,-36],[154,62,-36],[152,69,0,],0xFFFF00,[5045,5046,5059,5060,5061,5062],[5046,5047,5057,5058,5059],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[154,62,-36],[149,62,-36],[152,69,0,],0xFFFF00,[5046,5047,5057,5058,5059],[5047,5048,5055,5056,5057],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[149,62,-36],[146,64,-36],[152,69,0,],0xFFFF00,[5047,5048,5055,5056,5057],[5048,5049,5054,5055],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[146,64,-36],[145,69,-36],[152,69,0,],0xFFFF00,[5048,5049,5054,5055],[5040,5049,5052,5053,5054],[5040,5041,5042,5043,5044,5045,5046,5047,5048,5049]],
[[146,73,-36],[137,79,-51],[145,79,-45,],0xFFFFFF,[5040,5041,5050,5051,5052,5069],[4971,4972,5050,5051],[4964,4965,5050,5068,5069]],
[[146,73,-36],[141,69,-59],[137,79,-51,],0xFFFFFF,[5040,5041,5050,5051,5052,5069],[4976,4979,4981,5051,5052,5053],[4971,4972,5050,5051]],
[[141,69,-59],[146,73,-36],[145,69,-36,],0xFFFFFF,[4976,4979,4981,5051,5052,5053],[5040,5041,5050,5051,5052,5069],[5040,5049,5052,5053,5054]],
[[145,69,-36],[145,59,-65],[141,69,-59,],0xFFFFFF,[5040,5049,5052,5053,5054],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[4976,4979,4981,5051,5052,5053]],
[[145,59,-65],[145,69,-36],[146,64,-36,],0xFFFFFF,[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[5040,5049,5052,5053,5054],[5048,5049,5054,5055]],
[[146,64,-36],[149,62,-36],[145,59,-65,],0xFFFFFF,[5048,5049,5054,5055],[5047,5048,5055,5056,5057],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113]],
[[149,62,-36],[156,59,-57],[145,59,-65,],0xFFFFFF,[5047,5048,5055,5056,5057],[4962,4969,4970,5056,5057,5058],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113]],
[[149,62,-36],[154,62,-36],[156,59,-57,],0xFFFFFF,[5047,5048,5055,5056,5057],[5046,5047,5057,5058,5059],[4962,4969,4970,5056,5057,5058]],
[[154,62,-36],[165,59,-47],[156,59,-57,],0xFFFFFF,[5046,5047,5057,5058,5059],[4955,4962,4963,5058,5059,5060],[4962,4969,4970,5056,5057,5058]],
[[154,62,-36],[157,64,-36],[165,59,-47,],0xFFFFFF,[5046,5047,5057,5058,5059],[5045,5046,5059,5060,5061,5062],[4955,4962,4963,5058,5059,5060]],
[[157,64,-36],[172,59,-36],[165,59,-47,],0xFFFFFF,[5045,5046,5059,5060,5061,5062],[4771,4772,4775,5060,5061],[4955,4962,4963,5058,5059,5060]],
[[157,64,-36],[166,69,-33],[172,59,-36,],0xFFFFFF,[5045,5046,5059,5060,5061,5062],[4775,4776,4777,5061,5062,5063,5064],[4771,4772,4775,5060,5061]],
[[157,64,-36],[159,69,-36],[166,69,-33,],0xFFFFFF,[5045,5046,5059,5060,5061,5062],[5044,5045,5062,5063],[4775,4776,4777,5061,5062,5063,5064]],
[[159,69,-36],[157,73,-36],[166,69,-33,],0xFFFFFF,[5044,5045,5062,5063],[5043,5044,5063,5064,5065],[4775,4776,4777,5061,5062,5063,5064]],
[[157,73,-36],[158,79,-29],[166,69,-33,],0xFFFFFF,[5043,5044,5063,5064,5065],[4776,4778,4779,5064,5065,5066],[4775,4776,4777,5061,5062,5063,5064]],
[[157,73,-36],[154,75,-36],[158,79,-29,],0xFFFFFF,[5043,5044,5063,5064,5065],[5042,5043,5065,5066,5067],[4776,4778,4779,5064,5065,5066]],
[[154,75,-36],[152,79,-38],[158,79,-29,],0xFFFFFF,[5042,5043,5065,5066,5067],[4957,4958,4965,5066,5067,5068],[4776,4778,4779,5064,5065,5066]],
[[154,75,-36],[149,75,-36],[152,79,-38,],0xFFFFFF,[5042,5043,5065,5066,5067],[5041,5042,5067,5068,5069],[4957,4958,4965,5066,5067,5068]],
[[149,75,-36],[145,79,-45],[152,79,-38,],0xFFFFFF,[5041,5042,5067,5068,5069],[4964,4965,5050,5068,5069],[4957,4958,4965,5066,5067,5068]],
[[149,75,-36],[146,73,-36],[145,79,-45,],0xFFFFFF,[5041,5042,5067,5068,5069],[5040,5041,5050,5051,5052,5069],[4964,4965,5050,5068,5069]],
[[39,48,-55],[46,38,-52],[37,38,-57,],0xFFFFFF,[4344,4345,5070,5071],[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4320,4321,4345,4625,5070]],
[[46,38,-52],[39,48,-55],[48,48,-50,],0xFFFFFF,[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[4344,4345,5070,5071],[4346,4347,5071,5234,5238,5271,5275]],
[[162,48,-52],[171,48,-57],[164,38,-53,],0xFFFFFF,[4501,5072,5247,5284,5325],[4473,5072,5073],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285]],
[[171,48,-57],[173,38,-58],[164,38,-53,],0xFFFFFF,[4473,5072,5073],[4473,4474,4475,4631,4632,5073],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285]],
[[50,48,-64],[56,48,-78],[56,48,-64,],0xFFFFFF,[5074,5112],[5074,5075,5096,5112],[5074,5075,5076]],
[[56,48,-64],[56,48,-78],[66,48,-94,],0xFFFFFF,[5074,5075,5076],[5074,5075,5096,5112],[5075,5076,5077,5096,5097,5098]],
[[56,48,-64],[66,48,-94],[66,48,-63,],0xFFFFFF,[5074,5075,5076],[5075,5076,5077,5096,5097,5098],[5076,5077,5078]],
[[66,48,-63],[66,48,-94],[76,48,-104,],0xFFFFFF,[5076,5077,5078],[5075,5076,5077,5096,5097,5098],[5077,5078,5079,5098,5099,5100]],
[[66,48,-63],[76,48,-104],[76,48,-63,],0xFFFFFF,[5076,5077,5078],[5077,5078,5079,5098,5099,5100],[5078,5079,5080]],
[[76,48,-63],[76,48,-104],[86,48,-110,],0xFFFFFF,[5078,5079,5080],[5077,5078,5079,5098,5099,5100],[5079,5080,5081,5100,5101,5102]],
[[76,48,-63],[86,48,-110],[86,48,-63,],0xFFFFFF,[5078,5079,5080],[5079,5080,5081,5100,5101,5102],[5080,5081,5082]],
[[86,48,-63],[86,48,-110],[96,48,-113,],0xFFFFFF,[5080,5081,5082],[5079,5080,5081,5100,5101,5102],[5081,5082,5094,5102,5103]],
[[86,48,-63],[96,48,-113],[96,48,-63,],0xFFFFFF,[5080,5081,5082],[5081,5082,5094,5102,5103],[5082,5094,5095]],
[[106,48,-63],[106,48,-115],[116,48,-113,],0xFFFFFF,[5083,5084,5095],[5083,5094,5095,5103,5108],[5083,5084,5085,5086,5104,5105,5108,5109,5110]],
[[106,48,-63],[116,48,-113],[116,48,-63,],0xFFFFFF,[5083,5084,5095],[5083,5084,5085,5086,5104,5105,5108,5109,5110],[5084,5085]],
[[116,48,-63],[116,48,-113],[126,48,-63,],0xFFFFFF,[5084,5085],[5083,5084,5085,5086,5104,5105,5108,5109,5110],[5085,5086,5087]],
[[126,48,-63],[116,48,-113],[126,48,-110,],0xFFFFFF,[5085,5086,5087],[5083,5084,5085,5086,5104,5105,5108,5109,5110],[5086,5087,5088,5104]],
[[126,48,-63],[126,48,-110],[136,48,-63,],0xFFFFFF,[5085,5086,5087],[5086,5087,5088,5104],[5087,5088,5089]],
[[126,48,-110],[136,48,-104],[136,48,-63,],0xFFFFFF,[5086,5087,5088,5104],[5088,5089,5090,5105,5106,5107],[5087,5088,5089]],
[[136,48,-63],[136,48,-104],[146,48,-63,],0xFFFFFF,[5087,5088,5089],[5088,5089,5090,5105,5106,5107],[5089,5090,5091]],
[[146,48,-63],[136,48,-104],[146,48,-94,],0xFFFFFF,[5089,5090,5091],[5088,5089,5090,5105,5106,5107],[5090,5091,5092,5107,5111]],
[[146,48,-63],[146,48,-94],[156,48,-62,],0xFFFFFF,[5089,5090,5091],[5090,5091,5092,5107,5111],[5091,5092,5093]],
[[156,48,-62],[146,48,-94],[156,48,-77,],0xFFFFFF,[5091,5092,5093],[5090,5091,5092,5107,5111],[5092,5093,5111,5113]],
[[156,48,-77],[160,48,-62],[156,48,-62,],0xFFFFFF,[5092,5093,5111,5113],[5093,5113],[5091,5092,5093]],
[[96,48,-63],[96,48,-113],[106,48,-115,],0xFFFFFF,[5082,5094,5095],[5081,5082,5094,5102,5103],[5083,5094,5095,5103,5108]],
[[106,48,-115],[106,48,-63],[96,48,-63,],0xFFFFFF,[5083,5094,5095,5103,5108],[5083,5084,5095],[5082,5094,5095]],
[[56,48,-78],[67,59,-66],[66,48,-94,],0xFFFFFF,[5074,5075,5096,5112],[4919,4920,5027,5028,5029,5030,5096,5097,5112],[5075,5076,5077,5096,5097,5098]],
[[67,59,-66],[82,69,-64],[66,48,-94,],0xFFFFFF,[4919,4920,5027,5028,5029,5030,5096,5097,5112],[4927,4928,4929,5097,5098,5099],[5075,5076,5077,5096,5097,5098]],
[[82,69,-64],[76,48,-104],[66,48,-94,],0xFFFFFF,[4927,4928,4929,5097,5098,5099],[5077,5078,5079,5098,5099,5100],[5075,5076,5077,5096,5097,5098]],
[[82,69,-64],[95,79,-59],[76,48,-104,],0xFFFFFF,[4927,4928,4929,5097,5098,5099],[4936,4937,4938,5099,5100,5101],[5077,5078,5079,5098,5099,5100]],
[[95,79,-59],[86,48,-110],[76,48,-104,],0xFFFFFF,[4936,4937,4938,5099,5100,5101],[5079,5080,5081,5100,5101,5102],[5077,5078,5079,5098,5099,5100]],
[[95,79,-59],[106,89,-50],[86,48,-110,],0xFFFFFF,[4936,4937,4938,5099,5100,5101],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[5079,5080,5081,5100,5101,5102]],
[[86,48,-110],[106,89,-50],[96,48,-113,],0xFFFFFF,[5079,5080,5081,5100,5101,5102],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[5081,5082,5094,5102,5103]],
[[106,89,-50],[106,48,-115],[96,48,-113,],0xFFFFFF,[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[5083,5094,5095,5103,5108],[5081,5082,5094,5102,5103]],
[[130,69,-64],[126,48,-110],[116,48,-113,],0xFFFFFF,[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[5086,5087,5088,5104],[5083,5084,5085,5086,5104,5105,5108,5109,5110]],
[[130,69,-64],[136,48,-104],[116,48,-113,],0xFFFFFF,[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[5088,5089,5090,5105,5106,5107],[5083,5084,5085,5086,5104,5105,5108,5109,5110]],
[[130,69,-64],[145,59,-65],[136,48,-104,],0xFFFFFF,[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[5088,5089,5090,5105,5106,5107]],
[[145,59,-65],[146,48,-94],[136,48,-104,],0xFFFFFF,[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[5090,5091,5092,5107,5111],[5088,5089,5090,5105,5106,5107]],
[[106,89,-50],[116,48,-113],[106,48,-115,],0xFFFFFF,[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[5083,5084,5085,5086,5104,5105,5108,5109,5110],[5083,5094,5095,5103,5108]],
[[116,48,-113],[106,89,-50],[117,79,-59,],0xFFFFFF,[5083,5084,5085,5086,5104,5105,5108,5109,5110],[4945,4946,4947,4998,4999,5000,5101,5102,5103,5108,5109],[4991,4993,4994,5001,5002,5003,5109,5110]],
[[117,79,-59],[130,69,-64],[116,48,-113,],0xFFFFFF,[4991,4993,4994,5001,5002,5003,5109,5110],[4979,4980,4981,4987,4990,4992,5104,5105,5106,5110],[5083,5084,5085,5086,5104,5105,5108,5109,5110]],
[[145,59,-65],[156,48,-77],[146,48,-94,],0xFFFFFF,[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[5092,5093,5111,5113],[5090,5091,5092,5107,5111]],
[[50,48,-64],[67,59,-66],[56,48,-78,],0xFFFFFF,[5074,5112],[4919,4920,5027,5028,5029,5030,5096,5097,5112],[5074,5075,5096,5112]],
[[156,48,-77],[145,59,-65],[160,48,-62,],0xFFFFFF,[5092,5093,5111,5113],[4969,4976,4977,4978,5053,5054,5055,5056,5106,5107,5111,5113],[5093,5113]],
[[91,77,-79],[96,85,-68],[106,71,-87,],0xFF0000,[5114,5124,5125,5128],[5114,5115,5122,5123,5124],[5114,5115,5116,5117,5128,5129,5130,5131]],
[[96,85,-68],[106,85,-68],[106,71,-87,],0xFF0000,[5114,5115,5122,5123,5124],[5115,5117],[5114,5115,5116,5117,5128,5129,5130,5131]],
[[121,77,-79],[106,71,-87],[116,85,-68,],0xFF0000,[5116,5126,5127,5130],[5114,5115,5116,5117,5128,5129,5130,5131],[5116,5117,5123,5126]],
[[116,85,-68],[106,71,-87],[106,85,-68,],0xFF0000,[5116,5117,5123,5126],[5114,5115,5116,5117,5128,5129,5130,5131],[5115,5117]],
[[76,61,-74],[86,78,-53],[106,61,-90,],0xFFFFFF,[5118,5128,5129],[5118,5119,5122,5124,5125],[5118,5119,5120,5121,5129,5131]],
[[86,78,-53],[106,80,-52],[106,61,-90,],0xFF0000,[5118,5119,5122,5124,5125],[5119,5121],[5118,5119,5120,5121,5129,5131]],
[[136,61,-74],[106,61,-90],[126,78,-53,],0xFFFFFF,[5120,5127,5130,5131],[5118,5119,5120,5121,5129,5131],[5120,5121,5122,5123,5126,5127]],
[[126,78,-53],[106,61,-90],[106,80,-52,],0xFF0000,[5120,5121,5122,5123,5126,5127],[5118,5119,5120,5121,5129,5131],[5119,5121]],
[[86,78,-53],[126,78,-53],[96,85,-68,],0xFFFFFF,[5118,5119,5122,5124,5125],[5120,5121,5122,5123,5126,5127],[5114,5115,5122,5123,5124]],
[[126,78,-53],[116,85,-68],[96,85,-68,],0xFFFFFF,[5120,5121,5122,5123,5126,5127],[5116,5117,5123,5126],[5114,5115,5122,5123,5124]],
[[86,78,-53],[96,85,-68],[91,77,-79,],0xFFFFFF,[5118,5119,5122,5124,5125],[5114,5115,5122,5123,5124],[5114,5124,5125,5128]],
[[91,77,-79],[76,71,-74],[86,78,-53,],0xFFFFFF,[5114,5124,5125,5128],[5125],[5118,5119,5122,5124,5125]],
[[116,85,-68],[126,78,-53],[121,77,-79,],0xFFFFFF,[5116,5117,5123,5126],[5120,5121,5122,5123,5126,5127],[5116,5126,5127,5130]],
[[121,77,-79],[126,78,-53],[136,61,-74,],0xFFFFFF,[5116,5126,5127,5130],[5120,5121,5122,5123,5126,5127],[5120,5127,5130,5131]],
[[106,71,-87],[76,61,-74],[91,77,-79,],0xFF0000,[5114,5115,5116,5117,5128,5129,5130,5131],[5118,5128,5129],[5114,5124,5125,5128]],
[[76,61,-74],[106,71,-87],[106,61,-90,],0xFF0000,[5118,5128,5129],[5114,5115,5116,5117,5128,5129,5130,5131],[5118,5119,5120,5121,5129,5131]],
[[106,71,-87],[121,77,-79],[136,61,-74,],0xFF0000,[5114,5115,5116,5117,5128,5129,5130,5131],[5116,5126,5127,5130],[5120,5127,5130,5131]],
[[106,71,-87],[136,61,-74],[106,61,-90,],0xFF0000,[5114,5115,5116,5117,5128,5129,5130,5131],[5120,5127,5130,5131],[5118,5119,5120,5121,5129,5131]],
[[88,81,-58],[92,82,-64],[80,68,-76,],0xFFFFFF,[5132,5139,5141],[5132,5133,5136,5141],[5132,5133,5139,5142]],
[[80,68,-76],[92,82,-64],[86,72,-77,],0xFFFFFF,[5132,5133,5139,5142],[5132,5133,5136,5141],[5133,5136,5142]],
[[127,72,-77],[119,82,-64],[131,68,-76,],0xFFFFFF,[5134],[5134,5135],[5134,5135,5140,5143]],
[[119,82,-64],[122,81,-59],[131,68,-76,],0xFFFFFF,[5134,5135],[5135,5138,5140],[5134,5135,5140,5143]],
[[92,82,-64],[86,72,-77],[18,121,-9,],0xFFFFFF,[5132,5133,5136,5141],[5133,5136,5142],[5136,5139,5141,5142]],
[[119,82,-64],[194,121,-9],[127,72,-77,],0xFFFFFF,[5137,5138],[5137,5138,5140,5143],[5137]],
[[122,81,-59],[194,121,-9],[119,82,-64,],0xFFFFFF,[5135,5138,5140],[5137,5138,5140,5143],[5137,5138]],
[[88,81,-58],[18,121,-9],[80,68,-76,],0xFFFFFF,[5132,5139,5141],[5136,5139,5141,5142],[5132,5133,5139,5142]],
[[122,81,-59],[131,68,-76],[194,121,-9,],0xFFFFFF,[5135,5138,5140],[5134,5135,5140,5143],[5137,5138,5140,5143]],
[[88,81,-58],[92,82,-64],[18,121,-9,],0xFFFFFF,[5132,5139,5141],[5132,5133,5136,5141],[5136,5139,5141,5142]],
[[80,68,-76],[86,72,-77],[18,121,-9,],0xFFFFFF,[5132,5133,5139,5142],[5133,5136,5142],[5136,5139,5141,5142]],
[[131,68,-76],[194,121,-9],[126,72,-77,],0xFFFFFF,[5134,5135,5140,5143],[5137,5138,5140,5143],[5143]],
[[86,134,20],[86,134,-5],[76,95,20,],0xFFFFFF,[5144,5146,5147,5214,5215,5216],[5144,5145,5147],[5144,5145,5214,5226,5227]],
[[76,95,20],[86,134,-5],[76,95,-5,],0xFFFFFF,[5144,5145,5214,5226,5227],[5144,5145,5147],[5145]],
[[89,142,20],[89,142,-5],[86,134,20,],0xFFFFFF,[5146,5148,5149,5216,5217,5218],[5146,5148],[5144,5146,5147,5214,5215,5216]],
[[89,142,-5],[86,134,-5],[86,134,20,],0xFFFFFF,[5147],[5144,5145,5147],[5144,5146,5147,5214,5215,5216]],
[[89,142,-5],[89,142,-5],[89,142,20,],0xFFFFFF,[5146,5148],[5148,5149],[5146,5148,5149,5216,5217,5218]],
[[96,145,20],[89,142,-5],[89,142,20,],0xFFFFFF,[5149,5150,5224,5225],[5148,5149],[5146,5148,5149,5216,5217,5218]],
[[96,145,20],[96,145,-5],[89,142,-4,],0xFFFFFF,[5149,5150,5224,5225],[5150,5157,5158],[5150]],
[[126,134,-5],[126,134,20],[136,95,-5,],0xFFFFFF,[5151,5154],[5151,5152,5154,5219,5220],[5151,5152]],
[[126,134,20],[136,95,20],[136,95,-5,],0xFFFFFF,[5151,5152,5154,5219,5220],[5152,5206,5219],[5151,5152]],
[[122,142,-5],[122,142,20],[126,134,-4,],0xFFFFFF,[5153,5155],[5153,5154],[5153]],
[[122,142,20],[126,134,20],[126,134,-5,],0xFFFFFF,[5153,5154],[5151,5152,5154,5219,5220],[5151,5154]],
[[122,142,-5],[116,145,-5],[122,142,20,],0xFFFFFF,[5153,5155],[5155,5156,5158],[5155]],
[[116,145,-5],[116,145,20],[122,142,20,],0xFFFFFF,[5155,5156,5158],[5156,5222,5223,5225],[5156,5220,5221,5222]],
[[96,145,19],[116,145,19],[96,145,-5,],0xFFFFFF,[5157,5218],[5157,5158],[5150,5157,5158]],
[[116,145,19],[116,145,-5],[96,145,-5,],0xFFFFFF,[5157,5158],[5155,5156,5158],[5150,5157,5158]],
[[86,134,-4],[86,134,-29],[76,95,-4,],0xFFFFFF,[5159,5161,5162],[5159,5160,5162,5196,5197],[5159,5160]],
[[76,95,-4],[86,134,-29],[76,95,-29,],0xFFFFFF,[5159,5160],[5159,5160,5162,5196,5197],[5160,5190,5197,5198]],
[[89,142,-4],[89,142,-29],[86,134,-4,],0xFFFFFF,[5161,5163,5164],[5161,5162,5163],[5159,5161,5162]],
[[89,142,-29],[86,134,-29],[86,134,-4,],0xFFFFFF,[5161,5162,5163],[5159,5160,5162,5196,5197],[5159,5161,5162]],
[[89,142,-29],[89,142,-29],[89,142,-4,],0xFFFFFF,[5161,5162,5163],[5163,5164,5165,5195,5196],[5161,5163,5164]],
[[96,145,-4],[89,142,-29],[89,142,-4,],0xFFFFFF,[5164,5165],[5163,5164,5165,5195,5196],[5161,5163,5164]],
[[96,145,-4],[96,145,-29],[89,142,-29,],0xFFFFFF,[5164,5165],[5165,5166,5167,5195,5199],[5163,5164,5165,5195,5196]],
[[96,145,-4],[116,145,-4],[96,145,-29,],0xFFFFFF,[5166],[5166,5167],[5165,5166,5167,5195,5199]],
[[116,145,-4],[116,145,-29],[96,145,-29,],0xFFFFFF,[5166,5167],[5167,5172,5173,5194,5199,5200],[5165,5166,5167,5195,5199]],
[[126,134,-29],[126,134,-4],[136,95,-29,],0xFFFFFF,[5168,5170,5171,5193,5201],[5168,5169,5171],[5168,5169,5190,5191,5192,5201]],
[[126,134,-4],[136,95,-4],[136,95,-29,],0xFFFFFF,[5168,5169,5171],[5169],[5168,5169,5190,5191,5192,5201]],
[[122,142,-29],[122,142,-4],[126,134,-29,],0xFFFFFF,[5170,5172,5193,5194],[5170,5171],[5168,5170,5171,5193,5201]],
[[122,142,-4],[126,134,-4],[126,134,-29,],0xFFFFFF,[5170,5171],[5168,5169,5171],[5168,5170,5171,5193,5201]],
[[122,142,-29],[116,145,-29],[122,142,-4,],0xFFFFFF,[5170,5172,5193,5194],[5167,5172,5173,5194,5199,5200],[5172]],
[[116,145,-29],[116,145,-4],[122,142,-4,],0xFFFFFF,[5167,5172,5173,5194,5199,5200],[5173],[5173]],
[[121,74,115],[91,74,115],[121,46,95,],0x0000FF,[5174,5176,5177,5178,5183,5184,5185],[5174,5175,5181,5182,5185,5186,5187],[5174,5175,5178,5179,5180]],
[[91,74,115],[91,46,95],[121,46,95,],0x0000FF,[5174,5175,5181,5182,5185,5186,5187],[5175,5180,5186],[5174,5175,5178,5179,5180]],
[[122,77,125],[121,74,115],[126,70,121,],0xFFFFFF,[5176,5183,5209,5210,5211],[5174,5176,5177,5178,5183,5184,5185],[5176,5177,5207,5208,5209]],
[[126,70,121],[121,74,115],[136,38,99,],0xFFFFFF,[5176,5177,5207,5208,5209],[5174,5176,5177,5178,5183,5184,5185],[5177,5178,5179,5206,5207]],
[[121,74,115],[121,46,95],[136,38,99,],0xFFFFFF,[5174,5176,5177,5178,5183,5184,5185],[5174,5175,5178,5179,5180],[5177,5178,5179,5206,5207]],
[[121,46,95],[76,38,99],[136,38,99,],0xFFFFFF,[5174,5175,5178,5179,5180],[5179,5180,5186,5187,5226],[5177,5178,5179,5206,5207]],
[[121,46,95],[91,46,95],[76,38,99,],0xFFFFFF,[5174,5175,5178,5179,5180],[5175,5180,5186],[5179,5180,5186,5187,5226]],
[[91,74,115],[89,77,125],[86,70,121,],0xFFFFFF,[5174,5175,5181,5182,5185,5186,5187],[5181,5182,5202,5203,5204],[5181,5187,5202,5226,5227]],
[[91,74,115],[96,79,127],[89,77,125,],0xFFFFFF,[5174,5175,5181,5182,5185,5186,5187],[5182,5184,5185,5204,5205,5212],[5181,5182,5202,5203,5204]],
[[121,74,115],[122,77,125],[116,79,127,],0xFFFFFF,[5174,5176,5177,5178,5183,5184,5185],[5176,5183,5209,5210,5211],[5183,5184,5211,5212,5213]],
[[116,79,127],[96,79,127],[121,74,115,],0xFFFFFF,[5183,5184,5211,5212,5213],[5182,5184,5185,5204,5205,5212],[5174,5176,5177,5178,5183,5184,5185]],
[[96,79,127],[91,74,115],[121,74,115,],0xFFFFFF,[5182,5184,5185,5204,5205,5212],[5174,5175,5181,5182,5185,5186,5187],[5174,5176,5177,5178,5183,5184,5185]],
[[91,74,115],[76,38,99],[91,46,95,],0xFFFFFF,[5174,5175,5181,5182,5185,5186,5187],[5179,5180,5186,5187,5226],[5175,5180,5186]],
[[91,74,115],[86,70,121],[76,38,99,],0xFFFFFF,[5174,5175,5181,5182,5185,5186,5187],[5181,5187,5202,5226,5227],[5179,5180,5186,5187,5226]],
[[96,136,-19],[116,136,-19],[96,101,-19,],0x0000FF,[5188,5195,5196,5197,5198,5199,5200],[5188,5189,5192,5193,5194,5200,5201],[5188,5189,5190,5191,5198]],
[[116,136,-19],[116,101,-19],[96,101,-19,],0x0000FF,[5188,5189,5192,5193,5194,5200,5201],[5189,5191,5192],[5188,5189,5190,5191,5198]],
[[96,101,-19],[136,95,-29],[76,95,-29,],0xFFFFFF,[5188,5189,5190,5191,5198],[5168,5169,5190,5191,5192,5201],[5160,5190,5197,5198]],
[[96,101,-19],[116,101,-19],[136,95,-29,],0xFFFFFF,[5188,5189,5190,5191,5198],[5189,5191,5192],[5168,5169,5190,5191,5192,5201]],
[[116,136,-19],[136,95,-29],[116,101,-19,],0xFFFFFF,[5188,5189,5192,5193,5194,5200,5201],[5168,5169,5190,5191,5192,5201],[5189,5191,5192]],
[[116,136,-19],[122,142,-29],[126,134,-29,],0xFFFFFF,[5188,5189,5192,5193,5194,5200,5201],[5170,5172,5193,5194],[5168,5170,5171,5193,5201]],
[[116,136,-19],[116,145,-29],[122,142,-29,],0xFFFFFF,[5188,5189,5192,5193,5194,5200,5201],[5167,5172,5173,5194,5199,5200],[5170,5172,5193,5194]],
[[96,136,-19],[89,142,-29],[96,145,-29,],0xFFFFFF,[5188,5195,5196,5197,5198,5199,5200],[5163,5164,5165,5195,5196],[5165,5166,5167,5195,5199]],
[[96,136,-19],[86,134,-29],[89,142,-29,],0xFFFFFF,[5188,5195,5196,5197,5198,5199,5200],[5159,5160,5162,5196,5197],[5163,5164,5165,5195,5196]],
[[96,136,-19],[76,95,-29],[86,134,-29,],0xFFFFFF,[5188,5195,5196,5197,5198,5199,5200],[5160,5190,5197,5198],[5159,5160,5162,5196,5197]],
[[96,136,-19],[96,101,-19],[76,95,-29,],0xFFFFFF,[5188,5195,5196,5197,5198,5199,5200],[5188,5189,5190,5191,5198],[5160,5190,5197,5198]],
[[96,145,-29],[116,145,-29],[96,136,-19,],0xFFFFFF,[5165,5166,5167,5195,5199],[5167,5172,5173,5194,5199,5200],[5188,5195,5196,5197,5198,5199,5200]],
[[116,145,-29],[116,136,-19],[96,136,-19,],0xFFFFFF,[5167,5172,5173,5194,5199,5200],[5188,5189,5192,5193,5194,5200,5201],[5188,5195,5196,5197,5198,5199,5200]],
[[116,136,-19],[126,134,-29],[136,95,-29,],0xFFFFFF,[5188,5189,5192,5193,5194,5200,5201],[5168,5170,5171,5193,5201],[5168,5169,5190,5191,5192,5201]],
[[89,77,125],[86,127,42],[86,70,121,],0xFFFFFF,[5181,5182,5202,5203,5204],[5202,5203,5214,5215,5227],[5181,5187,5202,5226,5227]],
[[89,77,125],[89,133,47],[86,127,42,],0xFFFFFF,[5181,5182,5202,5203,5204],[5203,5204,5205,5215,5216,5217],[5202,5203,5214,5215,5227]],
[[96,79,127],[89,133,47],[89,77,125,],0xFFFFFF,[5182,5184,5185,5204,5205,5212],[5203,5204,5205,5215,5216,5217],[5181,5182,5202,5203,5204]],
[[89,133,47],[96,79,127],[96,135,48,],0xFFFFFF,[5203,5204,5205,5215,5216,5217],[5182,5184,5185,5204,5205,5212],[5205]],
[[126,126,42],[136,38,99],[136,95,20,],0xFFFFFF,[5206,5207,5208,5219,5220,5221],[5177,5178,5179,5206,5207],[5152,5206,5219]],
[[126,126,42],[126,70,121],[136,38,99,],0xFFFFFF,[5206,5207,5208,5219,5220,5221],[5176,5177,5207,5208,5209],[5177,5178,5179,5206,5207]],
[[122,133,47],[126,70,121],[126,126,42,],0xFFFFFF,[5208,5209,5210,5221,5222,5223],[5176,5177,5207,5208,5209],[5206,5207,5208,5219,5220,5221]],
[[122,77,125],[126,70,121],[122,133,47,],0xFFFFFF,[5176,5183,5209,5210,5211],[5176,5177,5207,5208,5209],[5208,5209,5210,5221,5222,5223]],
[[116,135,49],[122,77,125],[122,133,47,],0xFFFFFF,[5210,5211,5213,5223,5224,5225],[5176,5183,5209,5210,5211],[5208,5209,5210,5221,5222,5223]],
[[116,135,49],[116,79,127],[122,77,125,],0xFFFFFF,[5210,5211,5213,5223,5224,5225],[5183,5184,5211,5212,5213],[5176,5183,5209,5210,5211]],
[[96,79,127],[116,79,127],[96,135,49,],0xFFFFFF,[5182,5184,5185,5204,5205,5212],[5183,5184,5211,5212,5213],[5212,5213,5217,5218,5224]],
[[116,79,127],[116,135,49],[96,135,49,],0xFFFFFF,[5183,5184,5211,5212,5213],[5210,5211,5213,5223,5224,5225],[5212,5213,5217,5218,5224]],
[[86,127,42],[86,134,20],[76,95,20,],0xFFFFFF,[5202,5203,5214,5215,5227],[5144,5146,5147,5214,5215,5216],[5144,5145,5214,5226,5227]],
[[89,133,47],[86,134,20],[86,127,42,],0xFFFFFF,[5203,5204,5205,5215,5216,5217],[5144,5146,5147,5214,5215,5216],[5202,5203,5214,5215,5227]],
[[89,133,47],[89,142,20],[86,134,20,],0xFFFFFF,[5203,5204,5205,5215,5216,5217],[5146,5148,5149,5216,5217,5218],[5144,5146,5147,5214,5215,5216]],
[[96,135,49],[89,142,20],[89,133,47,],0xFFFFFF,[5212,5213,5217,5218,5224],[5146,5148,5149,5216,5217,5218],[5203,5204,5205,5215,5216,5217]],
[[96,135,49],[96,145,19],[89,142,20,],0xFFFFFF,[5212,5213,5217,5218,5224],[5157,5218],[5146,5148,5149,5216,5217,5218]],
[[126,134,20],[126,126,42],[136,95,20,],0xFFFFFF,[5151,5152,5154,5219,5220],[5206,5207,5208,5219,5220,5221],[5152,5206,5219]],
[[122,142,20],[126,126,42],[126,134,20,],0xFFFFFF,[5156,5220,5221,5222],[5206,5207,5208,5219,5220,5221],[5151,5152,5154,5219,5220]],
[[122,142,20],[122,133,47],[126,126,42,],0xFFFFFF,[5156,5220,5221,5222],[5208,5209,5210,5221,5222,5223],[5206,5207,5208,5219,5220,5221]],
[[116,145,20],[122,133,47],[122,142,20,],0xFFFFFF,[5156,5222,5223,5225],[5208,5209,5210,5221,5222,5223],[5156,5220,5221,5222]],
[[116,145,20],[116,135,49],[122,133,47,],0xFFFFFF,[5156,5222,5223,5225],[5210,5211,5213,5223,5224,5225],[5208,5209,5210,5221,5222,5223]],
[[96,135,49],[116,135,49],[96,145,20,],0xFFFFFF,[5212,5213,5217,5218,5224],[5210,5211,5213,5223,5224,5225],[5149,5150,5224,5225]],
[[116,135,49],[116,145,20],[96,145,20,],0xFFFFFF,[5210,5211,5213,5223,5224,5225],[5156,5222,5223,5225],[5149,5150,5224,5225]],
[[86,70,121],[76,95,20],[76,38,99,],0xFFFFFF,[5181,5187,5202,5226,5227],[5144,5145,5214,5226,5227],[5179,5180,5186,5187,5226]],
[[86,70,121],[86,127,42],[76,95,20,],0xFFFFFF,[5181,5187,5202,5226,5227],[5202,5203,5214,5215,5227],[5144,5145,5214,5226,5227]],
[[79,23,-61],[51,28,-61],[56,37,-61,],0x00FF00,[5228,5229,5230,5256],[5228,5236,5237,5265,5273,5274,5304,5320],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[56,37,-61],[84,42,-61],[79,23,-61,],0x00FF00,[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[5229,5230,5242,5243,5244,5245,5246],[5228,5229,5230,5256]],
[[84,42,-61],[91,32,-61],[79,23,-61,],0x00FF00,[5229,5230,5242,5243,5244,5245,5246],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5228,5229,5230,5256]],
[[132,23,-61],[155,37,-61],[160,28,-61,],0x00FF00,[5231,5232,5233,5257],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5231,5249,5268,5286,5322,5323,5324]],
[[155,37,-61],[132,23,-61],[127,42,-61,],0x00FF00,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5231,5232,5233,5257],[5232,5233,5252,5253,5254,5255,5263]],
[[127,42,-61],[132,23,-61],[120,32,-61,],0x00FF00,[5232,5233,5252,5253,5254,5255,5263],[5231,5232,5233,5257],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[48,48,-50],[56,37,-61],[46,38,-52,],0x000000,[4346,4347,5071,5234,5238,5271,5275],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272]],
[[46,38,-52],[56,37,-61],[44,28,-53,],0x000000,[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320]],
[[44,28,-53],[51,28,-61],[43,18,-54,],0x000000,[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[5228,5236,5237,5265,5273,5274,5304,5320],[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274]],
[[43,18,-54],[51,28,-61],[42,8,-55,],0x000000,[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[5228,5236,5237,5265,5273,5274,5304,5320],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304]],
[[56,37,-61],[48,48,-50],[50,48,-61,],0x000000,[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[4346,4347,5071,5234,5238,5271,5275],[5238,5239,5275,5276]],
[[50,48,-61],[56,48,-61],[56,37,-61,],0x000000,[5238,5239,5275,5276],[5239,5240,5276,5277],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[56,48,-61],[66,48,-61],[56,37,-61,],0x000000,[5239,5240,5276,5277],[5240,5241,5277,5278],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[66,48,-61],[76,48,-61],[56,37,-61,],0x000000,[5240,5241,5277,5278],[5241,5242,5243,5278,5279,5280],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[56,37,-61],[76,48,-61],[84,42,-61,],0x000000,[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[5241,5242,5243,5278,5279,5280],[5229,5230,5242,5243,5244,5245,5246]],
[[76,48,-61],[86,48,-61],[84,42,-61,],0x000000,[5241,5242,5243,5278,5279,5280],[5243,5244,5280,5281],[5229,5230,5242,5243,5244,5245,5246]],
[[86,48,-61],[96,48,-61],[84,42,-61,],0x000000,[5243,5244,5280,5281],[5244,5245,5281,5282],[5229,5230,5242,5243,5244,5245,5246]],
[[96,48,-61],[106,48,-60],[84,42,-61,],0x000000,[5244,5245,5281,5282],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5229,5230,5242,5243,5244,5245,5246]],
[[84,42,-61],[106,48,-60],[91,32,-61,],0x000000,[5229,5230,5242,5243,5244,5245,5246],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298]],
[[155,37,-61],[162,48,-52],[164,38,-53,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[4501,5072,5247,5284,5325],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285]],
[[155,37,-61],[164,38,-53],[166,28,-55,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322]],
[[155,37,-61],[166,28,-55],[160,28,-61,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322],[5231,5249,5268,5286,5322,5323,5324]],
[[155,36,-61],[160,47,-61],[160,47,-61,],0x000000,[5250,5287],[5250,5250,5287,5287],[5250,5250,5287,5287]],
[[155,37,-61],[156,48,-61],[160,48,-61,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5251,5264,5288,5301],[5251,5288,5325]],
[[136,48,-61],[127,42,-61],[126,48,-61,],0x000000,[5252,5289],[5232,5233,5252,5253,5254,5255,5263],[5252,5253,5289,5290]],
[[127,42,-61],[116,48,-61],[126,48,-61,],0x000000,[5232,5233,5252,5253,5254,5255,5263],[5253,5254,5290,5291],[5252,5253,5289,5290]],
[[127,42,-61],[106,48,-60],[116,48,-61,],0x000000,[5232,5233,5252,5253,5254,5255,5263],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5253,5254,5290,5291]],
[[106,48,-60],[127,42,-61],[120,32,-61,],0x000000,[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5232,5233,5252,5253,5254,5255,5263],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[91,32,-61],[106,23,-61],[79,23,-61,],0x000000,[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5256,5257,5258,5259],[5228,5229,5230,5256]],
[[106,23,-61],[120,32,-61],[132,23,-61,],0x000000,[5256,5257,5258,5259],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297],[5231,5232,5233,5257]],
[[106,23,-61],[106,33,-61],[120,32,-61,],0x000000,[5256,5257,5258,5259],[5258,5259,5260,5261],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[106,23,-61],[91,32,-61],[106,33,-61,],0x000000,[5256,5257,5258,5259],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5258,5259,5260,5261]],
[[106,33,-61],[106,48,-60],[120,32,-61,],0x000000,[5258,5259,5260,5261],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[106,33,-61],[91,32,-61],[106,48,-60,],0x000000,[5258,5259,5260,5261],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298]],
[[146,48,-61],[155,37,-61],[136,48,-60,],0x000000,[5262,5264,5299,5301],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5262,5263,5299,5300]],
[[155,37,-61],[127,42,-61],[136,48,-60,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5232,5233,5252,5253,5254,5255,5263],[5262,5263,5299,5300]],
[[146,48,-61],[156,48,-61],[155,37,-61,],0x000000,[5262,5264,5299,5301],[5251,5264,5288,5301],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325]],
[[79,23,-63],[51,28,-61],[56,37,-61,],0x00FF00,[5265,5266,5267,5293,5303,5304],[5228,5236,5237,5265,5273,5274,5304,5320],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[56,37,-61],[84,42,-63],[79,23,-63,],0x00FF00,[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[5266,5267,5279,5280,5281,5282,5283],[5265,5266,5267,5293,5303,5304]],
[[84,42,-63],[91,32,-61],[79,23,-63,],0x00FF00,[5266,5267,5279,5280,5281,5282,5283],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5265,5266,5267,5293,5303,5304]],
[[132,23,-63],[155,37,-61],[160,28,-61,],0x00FF00,[5268,5269,5270,5294,5319,5324],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5231,5249,5268,5286,5322,5323,5324]],
[[155,37,-61],[132,23,-63],[127,42,-63,],0x00FF00,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5268,5269,5270,5294,5319,5324],[5269,5270,5289,5290,5291,5292,5300]],
[[127,42,-63],[132,23,-63],[120,32,-61,],0x00FF00,[5269,5270,5289,5290,5291,5292,5300],[5268,5269,5270,5294,5319,5324],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[48,48,-50],[56,37,-61],[46,38,-52,],0x000000,[4346,4347,5071,5234,5238,5271,5275],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272]],
[[46,38,-52],[56,37,-61],[44,28,-53,],0x000000,[4332,4333,4347,4625,4626,5070,5071,5234,5235,5271,5272],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320]],
[[44,28,-53],[51,28,-61],[43,18,-54,],0x000000,[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[5228,5236,5237,5265,5273,5274,5304,5320],[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274]],
[[43,18,-54],[51,28,-61],[42,8,-55,],0x000000,[4335,4336,4337,4628,4629,4630,5236,5237,5273,5274],[5228,5236,5237,5265,5273,5274,5304,5320],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304]],
[[56,37,-61],[48,48,-50],[50,48,-61,],0x000000,[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[4346,4347,5071,5234,5238,5271,5275],[5238,5239,5275,5276]],
[[50,48,-61],[56,48,-61],[56,37,-61,],0x000000,[5238,5239,5275,5276],[5239,5240,5276,5277],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[56,48,-61],[66,48,-61],[56,37,-61,],0x000000,[5239,5240,5276,5277],[5240,5241,5277,5278],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[66,48,-61],[76,48,-61],[56,37,-61,],0x000000,[5240,5241,5277,5278],[5241,5242,5243,5278,5279,5280],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320]],
[[56,37,-61],[76,48,-61],[84,42,-63,],0x000000,[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[5241,5242,5243,5278,5279,5280],[5266,5267,5279,5280,5281,5282,5283]],
[[76,48,-61],[86,48,-61],[84,42,-63,],0x000000,[5241,5242,5243,5278,5279,5280],[5243,5244,5280,5281],[5266,5267,5279,5280,5281,5282,5283]],
[[86,48,-61],[96,48,-61],[84,42,-63,],0x000000,[5243,5244,5280,5281],[5244,5245,5281,5282],[5266,5267,5279,5280,5281,5282,5283]],
[[96,48,-61],[106,48,-60],[84,42,-63,],0x000000,[5244,5245,5281,5282],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5266,5267,5279,5280,5281,5282,5283]],
[[84,42,-63],[106,48,-60],[91,32,-61,],0x000000,[5266,5267,5279,5280,5281,5282,5283],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298]],
[[155,37,-61],[162,48,-52],[164,38,-53,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[4501,5072,5247,5284,5325],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285]],
[[155,37,-61],[164,38,-53],[166,28,-55,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[4501,4502,4503,4631,5072,5073,5247,5248,5284,5285],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322]],
[[155,37,-61],[166,28,-55],[160,28,-61,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322],[5231,5249,5268,5286,5322,5323,5324]],
[[155,36,-61],[160,47,-61],[160,47,-61,],0x000000,[5250,5287],[5250,5250,5287,5287],[5250,5250,5287,5287]],
[[155,37,-61],[156,48,-61],[160,48,-61,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5251,5264,5288,5301],[5251,5288,5325]],
[[136,48,-61],[127,42,-63],[126,48,-61,],0x000000,[5252,5289],[5269,5270,5289,5290,5291,5292,5300],[5252,5253,5289,5290]],
[[127,42,-63],[116,48,-61],[126,48,-61,],0x000000,[5269,5270,5289,5290,5291,5292,5300],[5253,5254,5290,5291],[5252,5253,5289,5290]],
[[127,42,-63],[106,48,-60],[116,48,-61,],0x000000,[5269,5270,5289,5290,5291,5292,5300],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5253,5254,5290,5291]],
[[106,48,-60],[127,42,-63],[120,32,-61,],0x000000,[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5269,5270,5289,5290,5291,5292,5300],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[91,32,-61],[106,23,-73],[79,23,-63,],0x000000,[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[5265,5266,5267,5293,5303,5304]],
[[106,23,-73],[120,32,-61],[132,23,-63,],0x000000,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297],[5268,5269,5270,5294,5319,5324]],
[[106,23,-73],[106,33,-65],[120,32,-61,],0x000000,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[5295,5296,5297,5298],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[106,23,-73],[91,32,-61],[106,33,-65,],0x000000,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5295,5296,5297,5298]],
[[106,33,-65],[106,48,-60],[120,32,-61,],0x000000,[5295,5296,5297,5298],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298],[5233,5255,5257,5258,5260,5270,5292,5294,5295,5297]],
[[106,33,-65],[91,32,-61],[106,48,-60,],0x000000,[5295,5296,5297,5298],[5230,5246,5256,5259,5261,5267,5283,5293,5296,5298],[5245,5246,5254,5255,5260,5261,5282,5283,5291,5292,5297,5298]],
[[146,48,-61],[155,37,-61],[136,48,-60,],0x000000,[5262,5264,5299,5301],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5262,5263,5299,5300]],
[[155,37,-61],[127,42,-63],[136,48,-60,],0x000000,[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325],[5269,5270,5289,5290,5291,5292,5300],[5262,5263,5299,5300]],
[[146,48,-61],[156,48,-61],[155,37,-61,],0x000000,[5262,5264,5299,5301],[5251,5264,5288,5301],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325]],
[[42,8,-55],[106,23,-73],[64,-2,-74,],0xFFFFFF,[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[4441,4609,4610,5302,5305]],
[[106,23,-73],[42,8,-55],[79,23,-63,],0xFF0000,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[5265,5266,5267,5293,5303,5304]],
[[79,23,-63],[42,8,-55],[51,28,-61,],0x000000,[5265,5266,5267,5293,5303,5304],[4337,4338,4339,4440,4441,4630,5237,5274,5302,5303,5304],[5228,5236,5237,5265,5273,5274,5304,5320]],
[[64,-2,-74],[106,23,-73],[64,-12,-74,],0xFFFFFF,[4441,4609,4610,5302,5305],[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[4415,4416,4417,4597,4598,4610,5305,5306,5307]],
[[106,23,-73],[106,12,-96],[64,-12,-74,],0xFFFFFF,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[5306,5307,5308,5327,5328,5329],[4415,4416,4417,4597,4598,4610,5305,5306,5307]],
[[64,-12,-74],[106,12,-96],[65,-22,-74,],0xFFFFFF,[4415,4416,4417,4597,4598,4610,5305,5306,5307],[5306,5307,5308,5327,5328,5329],[4417,4429,4430,4598,4607,4608,5307,5308,5309]],
[[106,12,-96],[106,2,-96],[65,-22,-74,],0xFFFFFF,[5306,5307,5308,5327,5328,5329],[5308,5329],[4417,4429,4430,4598,4607,4608,5307,5308,5309]],
[[65,-22,-74],[91,-6,-88],[65,-32,-73,],0xFFFFFF,[4417,4429,4430,4598,4607,4608,5307,5308,5309],[5309,5310],[4430,4431,4432,4599,4600,4608,5309,5310,5313]],
[[91,-6,-88],[91,-17,-87],[65,-32,-73,],0xFFFFFF,[5309,5310],[5310],[4430,4431,4432,4599,4600,4608,5309,5310,5313]],
[[66,-42,-72],[91,-26,-87],[67,-52,-70,],0xFFFFFF,[4432,4433,4434,4600,4601,4602,5311,5313,5314],[5311,5312],[4434,4435,4436,4602,4603,4604,5311,5312,5315]],
[[91,-26,-87],[91,-38,-86],[67,-52,-70,],0xFFFFFF,[5311,5312],[5312],[4434,4435,4436,4602,4603,4604,5311,5312,5315]],
[[65,-32,-73],[106,-8,-96],[66,-42,-72,],0xFFFFFF,[4430,4431,4432,4599,4600,4608,5309,5310,5313],[5313,5314,5330,5331],[4432,4433,4434,4600,4601,4602,5311,5313,5314]],
[[106,-8,-96],[106,-18,-96],[66,-42,-72,],0xFFFFFF,[5313,5314,5330,5331],[5314,5331],[4432,4433,4434,4600,4601,4602,5311,5313,5314]],
[[67,-52,-70],[106,-29,-96],[68,-62,-68,],0xFFFFFF,[4434,4435,4436,4602,4603,4604,5311,5312,5315],[5315,5316,5332,5333],[4436,4437,4438,4604,4605,4606,5315,5316,5317]],
[[106,-29,-96],[106,-39,-96],[68,-62,-68,],0xFFFFFF,[5315,5316,5332,5333],[5316,5317,5318,5333,5334,5335],[4436,4437,4438,4604,4605,4606,5315,5316,5317]],
[[68,-62,-68],[106,-39,-96],[69,-72,-66,],0xFFFFFF,[4436,4437,4438,4604,4605,4606,5315,5316,5317],[5316,5317,5318,5333,5334,5335],[4438,4439,4442,4443,4606,5317,5318,5342,5343]],
[[106,-39,-96],[106,-50,-96],[69,-72,-66,],0xFFFFFF,[5316,5317,5318,5333,5334,5335],[5318,5335,5340,5342],[4438,4439,4442,4443,4606,5317,5318,5342,5343]],
[[106,23,-73],[132,23,-63],[168,8,-56,],0xFF0000,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[5268,5269,5270,5294,5319,5324],[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324]],
[[44,28,-53],[56,37,-61],[51,28,-61,],0x000000,[4333,4334,4335,4626,4627,4628,5235,5236,5272,5273,5320],[5228,5229,5234,5235,5238,5239,5240,5241,5242,5265,5266,5271,5272,5275,5276,5277,5278,5279,5320],[5228,5236,5237,5265,5273,5274,5304,5320]],
[[106,23,-73],[168,8,-56],[145,-2,-75,],0xFFFFFF,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324],[4562,4563,4611,5321,5326]],
[[160,28,-61],[166,28,-55],[167,18,-56,],0x000000,[5231,5249,5268,5286,5322,5323,5324],[4503,4504,4505,4631,4632,4633,5248,5249,5285,5286,5322],[4505,4506,4507,4633,4634,4635,5322,5323]],
[[168,8,-56],[160,28,-61],[167,18,-56,],0x000000,[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324],[5231,5249,5268,5286,5322,5323,5324],[4505,4506,4507,4633,4634,4635,5322,5323]],
[[168,8,-56],[132,23,-63],[160,28,-61,],0x000000,[4507,4508,4509,4562,4635,4636,5319,5321,5323,5324],[5268,5269,5270,5294,5319,5324],[5231,5249,5268,5286,5322,5323,5324]],
[[160,48,-61],[162,48,-52],[155,37,-61,],0x000000,[5251,5288,5325],[4501,5072,5247,5284,5325],[5231,5232,5247,5248,5249,5251,5262,5263,5264,5268,5269,5284,5285,5286,5288,5299,5300,5301,5325]],
[[106,23,-73],[145,-2,-75],[145,-12,-75,],0xFFFFFF,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[4562,4563,4611,5321,5326],[4576,4577,4578,4611,4612,4613,5326,5327,5328]],
[[106,23,-73],[145,-12,-75],[106,12,-96,],0xFFFFFF,[5293,5294,5295,5296,5302,5303,5305,5306,5319,5321,5326,5327],[4576,4577,4578,4611,4612,4613,5326,5327,5328],[5306,5307,5308,5327,5328,5329]],
[[145,-12,-75],[145,-22,-75],[106,12,-96,],0xFFFFFF,[4576,4577,4578,4611,4612,4613,5326,5327,5328],[4578,4579,4580,4613,4614,4615,5328,5329,5336],[5306,5307,5308,5327,5328,5329]],
[[106,12,-96],[145,-22,-75],[106,2,-96,],0xFFFFFF,[5306,5307,5308,5327,5328,5329],[4578,4579,4580,4613,4614,4615,5328,5329,5336],[5308,5329]],
[[106,-8,-96],[145,-32,-74],[144,-42,-73,],0xFFFFFF,[5313,5314,5330,5331],[4580,4581,4582,4615,4616,4617,5330,5336,5337],[4582,4583,4584,4617,4618,4619,5330,5331,5338]],
[[106,-8,-96],[144,-42,-73],[106,-18,-96,],0xFFFFFF,[5313,5314,5330,5331],[4582,4583,4584,4617,4618,4619,5330,5331,5338],[5314,5331]],
[[106,-29,-96],[143,-52,-71],[142,-62,-69,],0xFFFFFF,[5315,5316,5332,5333],[4584,4585,4586,4619,4620,4621,5332,5338,5339],[4586,4587,4590,4621,4622,4623,5332,5333,5334]],
[[106,-29,-96],[142,-62,-69],[106,-39,-96,],0xFFFFFF,[5315,5316,5332,5333],[4586,4587,4590,4621,4622,4623,5332,5333,5334],[5316,5317,5318,5333,5334,5335]],
[[142,-62,-69],[140,-72,-66],[106,-39,-96,],0xFFFFFF,[4586,4587,4590,4621,4622,4623,5332,5333,5334],[4590,4591,4592,4623,4624,5334,5335,5340,5341],[5316,5317,5318,5333,5334,5335]],
[[106,-39,-96],[140,-72,-66],[106,-50,-96,],0xFFFFFF,[5316,5317,5318,5333,5334,5335],[4590,4591,4592,4623,4624,5334,5335,5340,5341],[5318,5335,5340,5342]],
[[121,-6,-88],[145,-22,-75],[145,-32,-74,],0xFFFFFF,[5336,5337],[4578,4579,4580,4613,4614,4615,5328,5329,5336],[4580,4581,4582,4615,4616,4617,5330,5336,5337]],
[[121,-6,-88],[145,-32,-74],[121,-18,-87,],0xFFFFFF,[5336,5337],[4580,4581,4582,4615,4616,4617,5330,5336,5337],[5337]],
[[121,-27,-87],[144,-42,-73],[143,-52,-71,],0xFFFFFF,[5338,5339],[4582,4583,4584,4617,4618,4619,5330,5331,5338],[4584,4585,4586,4619,4620,4621,5332,5338,5339]],
[[121,-27,-87],[143,-52,-71],[121,-39,-86,],0xFFFFFF,[5338,5339],[4584,4585,4586,4619,4620,4621,5332,5338,5339],[5339]],
[[106,-50,-82],[106,-50,-96],[140,-72,-66,],0xFFFFFF,[5340,5341,5342,5343,5346,5348],[5318,5335,5340,5342],[4590,4591,4592,4623,4624,5334,5335,5340,5341]],
[[118,-57,-66],[106,-50,-82],[140,-72,-66,],0xFFFFFF,[5341,5349,5350],[5340,5341,5342,5343,5346,5348],[4590,4591,4592,4623,4624,5334,5335,5340,5341]],
[[106,-50,-82],[69,-72,-66],[106,-50,-96,],0xFFFFFF,[5340,5341,5342,5343,5346,5348],[4438,4439,4442,4443,4606,5317,5318,5342,5343],[5318,5335,5340,5342]],
[[106,-50,-82],[94,-57,-66],[69,-72,-66,],0xFFFFFF,[5340,5341,5342,5343,5346,5348],[5343,5345,5346,5350],[4438,4439,4442,4443,4606,5317,5318,5342,5343]],
[[94,-83,-66],[106,-71,-82],[117,-83,-66,],0xFF0000,[5344,5345,5349,5350],[5344,5345,5346,5347,5348],[5344,5347]],
[[94,-57,-66],[106,-71,-82],[94,-83,-66,],0xFF0000,[5343,5345,5346,5350],[5344,5345,5346,5347,5348],[5344,5345,5349,5350]],
[[94,-57,-66],[106,-50,-82],[106,-71,-82,],0xFF0000,[5343,5345,5346,5350],[5340,5341,5342,5343,5346,5348],[5344,5345,5346,5347,5348]],
[[115,-57,-66],[117,-83,-66],[106,-71,-82,],0xFF0000,[5347,5348],[5344,5347],[5344,5345,5346,5347,5348]],
[[106,-71,-82],[106,-50,-82],[115,-57,-66,],0xFF0000,[5344,5345,5346,5347,5348],[5340,5341,5342,5343,5346,5348],[5347,5348]],
[[118,-57,-66],[94,-83,-66],[118,-83,-66,],0xFFFFFF,[5341,5349,5350],[5344,5345,5349,5350],[5349]],
[[118,-57,-66],[94,-57,-66],[94,-83,-66,],0xFFFFFF,[5341,5349,5350],[5343,5345,5346,5350],[5344,5345,5349,5350]],
[[52,-82,-47],[33,-81,-86],[61,-82,-56,],0xFFFFFF,[4373,4374,4375,5351,5352,5407],[623,624,625,793,794,795,864,865,5351,5352],[4408,4409,5351]],
[[19,-81,-72],[33,-81,-86],[52,-82,-47,],0xFFFFFF,[622,623,624,792,793,794,5352],[623,624,625,793,794,795,864,865,5351,5352],[4373,4374,4375,5351,5352,5407]],
[[8,-81,-56],[19,-81,-72],[44,-82,-37,],0xFFFFFF,[5353],[5353,5354],[5353,5354,5411]],
[[44,-82,-37],[19,-81,-72],[52,-82,-47,],0xFFFFFF,[5353,5354,5411],[5353,5354],[5354]],
[[0,-81,-38],[8,-81,-56],[39,-82,-26,],0xFFFFFF,[5355],[5355,5356],[5355,5356,5413]],
[[39,-82,-26],[8,-81,-56],[44,-82,-37,],0xFFFFFF,[5355,5356,5413],[5355,5356],[4313,4314,4315,5356]],
[[-4,-81,-19],[0,-81,-38],[35,-82,-14,],0xFFFFFF,[5357],[5357,5358],[5357,5358,5415]],
[[35,-82,-14],[0,-81,-38],[39,-82,-26,],0xFFFFFF,[5357,5358,5415],[5357,5358],[5358]],
[[-6,-81,0],[-4,-81,-19],[34,-82,-1,],0xFFFFFF,[5359],[5359,5360],[5359,5360,5417]],
[[34,-82,-1],[-4,-81,-19],[35,-82,-14,],0xFFFFFF,[5359,5360,5417],[5359,5360],[5360]],
[[-4,-81,19],[-6,-81,0],[34,-82,10,],0xFFFFFF,[1123,1124,1125,1134,1135,1136,5361],[1059,1060,1061,1070,1071,1072,5361,5362],[5361,5362,5419]],
[[34,-82,10],[-6,-81,0],[34,-82,-1,],0xFFFFFF,[5361,5362,5419],[1059,1060,1061,1070,1071,1072,5361,5362],[5362]],
[[0,-81,38],[-4,-81,19],[37,-82,22,],0xFFFFFF,[5363],[5363,5364],[5363,5364,5421]],
[[37,-82,22],[-4,-81,19],[34,-82,10,],0xFFFFFF,[5363,5364,5421],[5363,5364],[5364]],
[[8,-81,56],[0,-81,38],[42,-82,34,],0xFFFFFF,[5365],[5365,5366],[5365,5366,5423]],
[[42,-82,34],[0,-81,38],[37,-82,22,],0xFFFFFF,[5365,5366,5423],[5365,5366],[5366]],
[[19,-81,72],[8,-81,56],[49,-82,44,],0xFFFFFF,[5367],[5367,5368],[5367,5368,5425]],
[[49,-82,44],[8,-81,56],[42,-82,34,],0xFFFFFF,[5367,5368,5425],[5367,5368],[5368]],
[[33,-81,86],[19,-81,72],[58,-82,53,],0xFFFFFF,[5369],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370],[5369,5370,5427]],
[[58,-82,53],[19,-81,72],[49,-82,44,],0xFFFFFF,[5369,5370,5427],[1315,1316,1317,1326,1327,1328,3240,3241,3242,3272,3273,3274,5369,5370],[5370]],
[[49,-81,97],[33,-81,86],[68,-82,61,],0xFFFFFF,[5371],[5371,5372],[5371,5372,5429]],
[[68,-82,61],[33,-81,86],[58,-82,53,],0xFFFFFF,[5371,5372,5429],[5371,5372],[5372]],
[[67,-81,105],[49,-81,97],[79,-82,66,],0xFFFFFF,[1507,1508,1509,1518,1519,1520,5373],[5373,5374],[5373,5374,5376,5431]],
[[79,-82,66],[49,-81,97],[68,-82,61,],0xFFFFFF,[5373,5374,5376,5431],[5373,5374],[5374]],
[[86,-81,110],[67,-81,105],[91,-82,70,],0xFFFFFF,[5375],[5375,5376],[5375,5376,5433]],
[[91,-82,70],[67,-81,105],[79,-82,66,],0xFFFFFF,[5375,5376,5433],[5375,5376],[5373,5374,5376,5431]],
[[106,-81,112],[86,-81,110],[104,-82,71,],0xFFFFFF,[5377],[5377,5378],[5377,5378,5435]],
[[104,-82,71],[86,-81,110],[91,-82,70,],0xFFFFFF,[5377,5378,5435],[5377,5378],[5378]],
[[125,-81,110],[105,-81,112],[116,-82,71,],0xFFFFFF,[5379],[5379,5380],[5379,5380]],
[[116,-82,71],[105,-81,112],[104,-82,71,],0xFFFFFF,[5379,5380],[5379,5380],[5380]],
[[144,-81,105],[125,-81,110],[128,-82,68,],0xFFFFFF,[5381],[5381,5382],[5381,5382,5459]],
[[128,-82,68],[125,-81,110],[116,-82,71,],0xFFFFFF,[5381,5382,5459],[5381,5382],[5382,5459,5460,5461]],
[[162,-81,97],[144,-81,105],[140,-82,63,],0xFFFFFF,[5383,5385,5386],[5383,5384],[5383,5384]],
[[140,-82,63],[144,-81,105],[128,-82,68,],0xFFFFFF,[5383,5384],[5383,5384],[5384]],
[[178,-81,86],[162,-81,97],[150,-82,56,],0xFFFFFF,[5385],[5383,5385,5386],[5385,5386]],
[[150,-82,56],[162,-81,97],[140,-82,63,],0xFFFFFF,[5385,5386],[5383,5385,5386],[5386]],
[[192,-81,72],[178,-81,86],[159,-82,47,],0xFFFFFF,[5387],[5387,5388],[5387,5388,5453]],
[[159,-82,47],[178,-81,86],[150,-82,56,],0xFFFFFF,[5387,5388,5453],[5387,5388],[5388,5453,5454]],
[[203,-81,56],[192,-81,72],[167,-82,37,],0xFFFFFF,[5389],[5389,5390],[5389,5390]],
[[167,-82,37],[192,-81,72],[159,-82,47,],0xFFFFFF,[5389,5390],[5389,5390],[5390]],
[[211,-81,38],[203,-81,56],[172,-82,26,],0xFFFFFF,[5391],[5391,5392],[5391,5392]],
[[172,-82,26],[203,-81,56],[167,-82,37,],0xFFFFFF,[5391,5392],[5391,5392],[5392]],
[[216,-81,19],[211,-81,38],[176,-82,14,],0xFFFFFF,[5393],[5393,5394],[5393,5394]],
[[176,-82,14],[211,-81,38],[172,-82,26,],0xFFFFFF,[5393,5394],[5393,5394],[5394]],
[[218,-81,0],[216,-81,19],[177,-82,1,],0xFFFFFF,[5395],[5395,5396],[5395,5396]],
[[177,-82,1],[216,-81,19],[176,-82,14,],0xFFFFFF,[5395,5396],[5395,5396],[5396,5445,5446,5447]],
[[216,-81,-19],[218,-81,0],[177,-82,-10,],0xFFFFFF,[5397],[5397,5398],[5397,5398]],
[[177,-82,-10],[218,-81,0],[177,-82,1,],0xFFFFFF,[5397,5398],[5397,5398],[5398,5445]],
[[211,-81,-38],[216,-81,-19],[174,-82,-22,],0xFFFFFF,[5399],[5399,5400],[5399,5400]],
[[174,-82,-22],[216,-81,-19],[177,-82,-10,],0xFFFFFF,[5399,5400],[5399,5400],[5400]],
[[203,-81,-56],[211,-81,-38],[169,-82,-34,],0xFFFFFF,[5401],[5401,5402],[5401,5402]],
[[169,-82,-34],[211,-81,-38],[174,-82,-22,],0xFFFFFF,[5401,5402],[5401,5402],[5402]],
[[192,-81,-72],[203,-81,-56],[162,-82,-44,],0xFFFFFF,[5403],[5403,5404],[5403,5404]],
[[162,-82,-44],[203,-81,-56],[169,-82,-34,],0xFFFFFF,[5403,5404],[5403,5404],[5404]],
[[178,-81,-86],[192,-81,-72],[153,-82,-53,],0xFFFFFF,[5405],[5405,5406],[5405,5406,5409]],
[[153,-82,-53],[192,-81,-72],[162,-82,-44,],0xFFFFFF,[5405,5406,5409],[5405,5406],[5406,5409,5410]],
[[52,-82,-47],[61,-82,-56],[52,-112,-47,],0xFFFFFF,[4373,4374,4375,5351,5352,5407],[5407,5408],[5407,5408,5484]],
[[61,-82,-56],[61,-112,-56],[52,-112,-47,],0xFFFFFF,[5407,5408],[5408],[5407,5408,5484]],
[[153,-82,-53],[162,-82,-44],[153,-112,-53,],0xFFFFFF,[5405,5406,5409],[5406,5409,5410],[5409,5410]],
[[162,-82,-44],[162,-112,-44],[153,-112,-53,],0xFFFFFF,[5406,5409,5410],[5410],[5409,5410]],
[[44,-82,-37],[52,-82,-47],[44,-112,-37,],0xFFFFFF,[5353,5354,5411],[5411,5412],[5411,5412,5482]],
[[52,-82,-47],[52,-112,-47],[44,-112,-37,],0xFFFFFF,[5411,5412],[5412],[5411,5412,5482]],
[[39,-82,-26],[44,-82,-37],[39,-112,-26,],0xFFFFFF,[5355,5356,5413],[5413,5414],[5413,5414,5416]],
[[44,-82,-37],[44,-112,-37],[39,-112,-26,],0xFFFFFF,[5413,5414],[5414],[5413,5414,5416]],
[[35,-82,-14],[39,-82,-26],[35,-112,-14,],0xFFFFFF,[5357,5358,5415],[5415,5416],[5415,5416]],
[[39,-82,-26],[39,-112,-26],[35,-112,-14,],0xFFFFFF,[5415,5416],[5413,5414,5416],[5415,5416]],
[[34,-82,-1],[35,-82,-14],[34,-112,-1,],0xFFFFFF,[5359,5360,5417],[5417,5418],[5417,5418,5479,5480]],
[[35,-82,-14],[35,-112,-14],[34,-112,-1,],0xFFFFFF,[5417,5418],[5418],[5417,5418,5479,5480]],
[[34,-82,10],[34,-82,-1],[34,-112,10,],0xFFFFFF,[5361,5362,5419],[5419,5420],[5419,5420,5479]],
[[34,-82,-1],[34,-112,-1],[34,-112,10,],0xFFFFFF,[5419,5420],[5420],[5419,5420,5479]],
[[37,-82,22],[34,-82,10],[37,-112,22,],0xFFFFFF,[5363,5364,5421],[5421,5422],[5421,5422,5424]],
[[34,-82,10],[34,-112,10],[37,-112,22,],0xFFFFFF,[5421,5422],[5422],[5421,5422,5424]],
[[42,-82,34],[37,-82,22],[42,-112,34,],0xFFFFFF,[5365,5366,5423],[5423,5424],[5423,5424]],
[[37,-82,22],[37,-112,22],[42,-112,34,],0xFFFFFF,[5423,5424],[5421,5422,5424],[5423,5424]],
[[49,-82,44],[42,-82,34],[49,-112,44,],0xFFFFFF,[5367,5368,5425],[5425,5426],[5425,5426]],
[[42,-82,34],[42,-112,34],[49,-112,44,],0xFFFFFF,[5425,5426],[5426],[5425,5426]],
[[58,-82,53],[49,-82,44],[58,-112,53,],0xFFFFFF,[5369,5370,5427],[5427,5428],[5427,5428]],
[[49,-82,44],[49,-112,44],[58,-112,53,],0xFFFFFF,[5427,5428],[5428],[5427,5428]],
[[68,-82,61],[58,-82,53],[68,-112,61,],0xFFFFFF,[5371,5372,5429],[5429,5430],[5429,5430,5510]],
[[58,-82,53],[58,-112,53],[68,-112,61,],0xFFFFFF,[5429,5430],[5430],[5429,5430,5510]],
[[79,-82,66],[68,-82,61],[79,-112,66,],0xFFFFFF,[5373,5374,5376,5431],[5431,5432],[5431,5432]],
[[68,-82,61],[68,-112,61],[79,-112,66,],0xFFFFFF,[5431,5432],[5432],[5431,5432]],
[[91,-82,70],[79,-82,66],[91,-112,70,],0xFFFFFF,[5375,5376,5433],[5433,5434],[5433,5434,5508]],
[[79,-82,66],[79,-112,66],[91,-112,70,],0xFFFFFF,[5433,5434],[5434],[5433,5434,5508]],
[[104,-82,71],[91,-82,70],[104,-112,71,],0xFFFFFF,[5377,5378,5435],[5435,5436],[5435,5436,5462]],
[[91,-82,70],[91,-112,70],[104,-112,71,],0xFFFFFF,[5435,5436],[5436],[5435,5436,5462]],
[[162,-82,-44],[169,-82,-34],[162,-112,-44,],0xFFFFFF,[5437],[5437,5438],[5437,5438]],
[[169,-82,-34],[169,-112,-34],[162,-112,-44,],0xFFFFFF,[5437,5438],[5438],[5437,5438]],
[[169,-82,-34],[174,-82,-22],[169,-112,-34,],0xFFFFFF,[5439],[5439,5440],[5439,5440]],
[[174,-82,-22],[174,-112,-22],[169,-112,-34,],0xFFFFFF,[5439,5440],[5440,5496],[5439,5440]],
[[174,-82,-22],[177,-82,-10],[174,-112,-22,],0xFFFFFF,[5441],[5441,5442],[5441,5442]],
[[177,-82,-10],[177,-112,-10],[174,-112,-22,],0xFFFFFF,[5441,5442],[5442],[5441,5442]],
[[177,-82,-10],[177,-82,1],[177,-112,-10,],0xFFFFFF,[5443],[5443,5444],[5443,5444]],
[[177,-82,1],[177,-112,1],[177,-112,-10,],0xFFFFFF,[5443,5444],[5444],[5443,5444]],
[[177,-82,1],[176,-82,14],[177,-112,1,],0xFFFFFF,[5398,5445],[5396,5445,5446,5447],[5445,5446]],
[[176,-82,14],[176,-112,14],[177,-112,1,],0xFFFFFF,[5396,5445,5446,5447],[5446,5499],[5445,5446]],
[[176,-82,14],[172,-82,26],[176,-112,14,],0xFFFFFF,[5396,5445,5446,5447],[5447,5448],[5447,5448]],
[[172,-82,26],[172,-112,26],[176,-112,14,],0xFFFFFF,[5447,5448],[5448],[5447,5448]],
[[172,-82,26],[167,-82,37],[172,-112,26,],0xFFFFFF,[5449],[5449,5450],[5449,5450,5500]],
[[167,-82,37],[167,-112,37],[172,-112,26,],0xFFFFFF,[5449,5450],[5450],[5449,5450,5500]],
[[167,-82,37],[159,-82,47],[167,-112,37,],0xFFFFFF,[5451],[5451,5452],[5451,5452]],
[[159,-82,47],[159,-112,47],[167,-112,37,],0xFFFFFF,[5451,5452],[5452,5502],[5451,5452]],
[[159,-82,47],[150,-82,56],[159,-112,47,],0xFFFFFF,[5387,5388,5453],[5388,5453,5454],[5453,5454]],
[[150,-82,56],[150,-112,56],[159,-112,47,],0xFFFFFF,[5388,5453,5454],[5454],[5453,5454]],
[[150,-82,56],[140,-82,63],[150,-112,56,],0xFFFFFF,[5455],[5455,5456],[5455,5456]],
[[140,-82,63],[140,-112,63],[150,-112,56,],0xFFFFFF,[5455,5456],[5456],[5455,5456]],
[[140,-82,63],[128,-82,68],[140,-112,63,],0xFFFFFF,[5457],[5457,5458],[5457,5458,5504]],
[[128,-82,68],[128,-112,68],[140,-112,63,],0xFFFFFF,[5457,5458],[5458,5459,5460,5505],[5457,5458,5504]],
[[128,-82,68],[116,-82,71],[128,-112,68,],0xFFFFFF,[5381,5382,5459],[5382,5459,5460,5461],[5458,5459,5460,5505]],
[[116,-82,71],[116,-112,71],[128,-112,68,],0xFFFFFF,[5382,5459,5460,5461],[5460,5461,5462],[5458,5459,5460,5505]],
[[116,-82,71],[103,-82,71],[116,-112,71,],0xFFFFFF,[5382,5459,5460,5461],[5461,5462],[5460,5461,5462]],
[[103,-82,71],[104,-112,71],[116,-112,71,],0xFFFFFF,[5461,5462],[5435,5436,5462],[5460,5461,5462]],
[[61,-69,-56],[71,-69,-63],[61,-112,-56,],0xFFFFFF,[5463],[5463,5464],[5463,5464,5485]],
[[71,-69,-63],[71,-112,-63],[61,-112,-56,],0xFFFFFF,[5463,5464],[5464],[5463,5464,5485]],
[[71,-69,-63],[83,-65,-68],[71,-112,-63,],0xFFFFFF,[5465],[5465,5466],[5465,5466]],
[[83,-65,-68],[83,-112,-68],[71,-112,-63,],0xFFFFFF,[5465,5466],[5466],[5465,5466]],
[[83,-65,-68],[95,-56,-71],[83,-112,-68,],0xFFFFFF,[5467],[5467,5468],[5467,5468,5486]],
[[95,-56,-71],[95,-112,-71],[83,-112,-68,],0xFFFFFF,[5467,5468],[5468],[5467,5468,5486]],
[[95,-84,-71],[107,-84,-71],[95,-113,-71,],0xFFFFFF,[5469],[5469,5470,5477],[5469,5470]],
[[107,-84,-71],[107,-113,-71],[95,-113,-71,],0xFFFFFF,[5469,5470,5477],[5470,5477,5478],[5469,5470]],
[[143,-69,-61],[153,-69,-53],[143,-112,-61,],0xFFFFFF,[5471],[5471,5472],[5471,5472]],
[[153,-69,-53],[153,-112,-53],[143,-112,-61,],0xFFFFFF,[5471,5472],[5472],[5471,5472]],
[[132,-65,-66],[143,-69,-61],[132,-112,-66,],0xFFFFFF,[5473],[5473,5474],[5473,5474,5476,5490]],
[[143,-69,-61],[143,-112,-61],[132,-112,-66,],0xFFFFFF,[5473,5474],[5474],[5473,5474,5476,5490]],
[[117,-56,-70],[132,-65,-66],[117,-112,-70,],0xFFFFFF,[5475],[5475,5476],[5475,5476]],
[[132,-65,-66],[132,-112,-66],[117,-112,-70,],0xFFFFFF,[5475,5476],[5473,5474,5476,5490],[5475,5476]],
[[107,-84,-71],[117,-84,-70],[107,-113,-71,],0xFFFFFF,[5469,5470,5477],[5477,5478],[5470,5477,5478]],
[[117,-84,-70],[117,-113,-70],[107,-113,-71,],0xFFFFFF,[5477,5478],[5478],[5470,5477,5478]],
[[34,-112,10],[34,-112,-1],[106,-111,0,],0xFFFFFF,[5419,5420,5479],[5417,5418,5479,5480],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[34,-112,-1],[35,-112,-14],[106,-111,0,],0xFFFFFF,[5417,5418,5479,5480],[5480],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[35,-112,-14],[39,-112,-26],[106,-111,0,],0xFFFFFF,[5481],[5481],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[39,-112,-26],[44,-112,-37],[106,-111,0,],0xFFFFFF,[5482],[5411,5412,5482],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[44,-112,-37],[52,-112,-47],[106,-111,0,],0xFFFFFF,[5483],[5483],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[52,-112,-47],[61,-112,-56],[106,-111,0,],0xFFFFFF,[5407,5408,5484],[5484],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[61,-112,-56],[71,-112,-63],[106,-111,0,],0xFFFFFF,[5463,5464,5485],[5485],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[71,-112,-63],[83,-112,-68],[106,-111,0,],0xFFFFFF,[5486],[5467,5468,5486],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[83,-112,-68],[95,-112,-71],[106,-111,0,],0xFFFFFF,[5487],[5487,5488],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[95,-112,-71],[107,-112,-71],[106,-111,0,],0xFFFFFF,[5487,5488],[5488,5489],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[107,-112,-71],[120,-112,-70],[106,-111,0,],0xFFFFFF,[5488,5489],[5489],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[120,-112,-70],[132,-112,-66],[106,-111,0,],0xFFFFFF,[5490],[5473,5474,5476,5490],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[132,-112,-66],[143,-112,-61],[106,-111,0,],0xFFFFFF,[5491],[5491],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[143,-112,-61],[153,-112,-53],[106,-111,0,],0xFFFFFF,[5492],[5492],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[153,-112,-53],[162,-112,-44],[106,-111,0,],0xFFFFFF,[5493],[5493],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[162,-112,-44],[169,-112,-34],[106,-111,0,],0xFFFFFF,[5494],[5494],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[169,-112,-34],[174,-112,-22],[106,-111,0,],0xFFFFFF,[5495],[5495],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[174,-112,-22],[177,-112,-10],[106,-111,0,],0xFFFFFF,[5440,5496],[5496],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[177,-112,-10],[177,-112,1],[106,-111,0,],0xFFFFFF,[5497],[5497],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[177,-112,1],[176,-112,14],[106,-111,0,],0xFFFFFF,[5498],[5498],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[176,-112,14],[172,-112,26],[106,-111,0,],0xFFFFFF,[5446,5499],[5499],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[172,-112,26],[167,-112,37],[106,-111,0,],0xFFFFFF,[5449,5450,5500],[5500],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[167,-112,37],[159,-112,47],[106,-111,0,],0xFFFFFF,[5501],[5501],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[159,-112,47],[150,-112,56],[106,-111,0,],0xFFFFFF,[5452,5502],[5502,5503],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[150,-112,56],[140,-112,63],[106,-111,0,],0xFFFFFF,[5502,5503],[5503],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[140,-112,63],[128,-112,68],[106,-111,0,],0xFFFFFF,[5457,5458,5504],[5504],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[128,-112,68],[116,-112,71],[106,-111,0,],0xFFFFFF,[5458,5459,5460,5505],[5505],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[116,-112,71],[104,-112,71],[106,-111,0,],0xFFFFFF,[5506],[5506],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[104,-112,71],[91,-112,70],[106,-111,0,],0xFFFFFF,[5507],[5507],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[91,-112,70],[79,-112,66],[106,-111,0,],0xFFFFFF,[5433,5434,5508],[5508,5509],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[79,-112,66],[68,-112,61],[106,-111,0,],0xFFFFFF,[5508,5509],[5509],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[68,-112,61],[58,-112,53],[106,-111,0,],0xFFFFFF,[5429,5430,5510],[5510],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[58,-112,53],[49,-112,44],[106,-111,0,],0xFFFFFF,[5511],[5511],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[49,-112,44],[42,-112,34],[106,-111,0,],0xFFFFFF,[5512],[5512],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[42,-112,34],[37,-112,22],[106,-111,0,],0xFFFFFF,[5513],[5513],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[37,-112,22],[34,-112,10],[106,-111,0,],0xFFFFFF,[5514],[5514],[5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514]],
[[-104,42,0],[-104,20,0],[-102,41,0,],0xFFFFFF,[0,5515],[0,1,5515,5516],[0,1,5515,5516]],
[[-104,20,0],[-102,20,0],[-102,41,0,],0xFFFFFF,[0,1,5515,5516],[1,5516],[0,1,5515,5516]],
[[-106,37,0],[-107,35,0],[-100,37,0,],0xFFFFFF,[2,5517],[2,3,5517,5518],[2,3,5517,5518]],
[[-107,35,0],[-100,35,0],[-100,37,0,],0xFFFFFF,[2,3,5517,5518],[3,5518],[2,3,5517,5518]],
[[-104,34,0],[-107,27,0],[-104,30,0,],0xFFFFFF,[4,5519],[4,5,5519,5520],[4,5,5519,5520]],
[[-107,27,0],[-106,26,0],[-104,30,0,],0xFFFFFF,[4,5,5519,5520],[5,5520],[4,5,5519,5520]],
[[-102,33,0],[-103,30,0],[-101,29,0,],0xFFFFFF,[6,7,5521,5522],[6,5521],[6,7,5521,5522]],
[[-102,33,0],[-101,29,0],[-100,31,0,],0xFFFFFF,[6,7,5521,5522],[6,7,5521,5522],[7,23,5522,5538]],
[[-97,41,0],[-100,36,0],[-98,35,0,],0xFFFFFF,[8,9,5523,5524],[8,10,11,5523,5525,5526],[8,9,5523,5524]],
[[-97,41,0],[-98,35,0],[-95,40,0,],0xFFFFFF,[8,9,5523,5524],[8,9,5523,5524],[9,5524]],
[[-96,35,0],[-100,36,0],[-97,34,0,],0xFFFFFF,[10,11,5525,5526],[8,10,11,5523,5525,5526],[10,5525]],
[[-96,35,0],[-99,37,0],[-100,36,0,],0xFFFFFF,[10,11,5525,5526],[11,5526],[8,10,11,5523,5525,5526]],
[[-95,38,0],[-99,32,0],[-97,32,0,],0xFFFFFF,[12,13,5527,5528],[12,22,23,5527,5537,5538],[12,13,5527,5528]],
[[-95,38,0],[-97,32,0],[-94,37,0,],0xFFFFFF,[12,13,5527,5528],[12,13,5527,5528],[13,5528]],
[[-89,41,0],[-92,36,0],[-90,35,0,],0xFFFFFF,[14,15,5529,5530],[14,16,17,5529,5531,5532],[14,15,5529,5530]],
[[-89,41,0],[-90,35,0],[-88,40,0,],0xFFFFFF,[14,15,5529,5530],[14,15,5529,5530],[15,5530]],
[[-88,36,0],[-92,36,0],[-89,34,0,],0xFFFFFF,[16,17,5531,5532],[14,16,17,5529,5531,5532],[16,5531]],
[[-88,36,0],[-91,38,0],[-92,36,0,],0xFFFFFF,[16,17,5531,5532],[17,5532],[14,16,17,5529,5531,5532]],
[[-88,39,0],[-91,33,0],[-90,33,0,],0xFFFFFF,[18,19,5533,5534],[18,26,27,5533,5541,5542],[18,19,5533,5534]],
[[-88,39,0],[-90,33,0],[-87,38,0,],0xFFFFFF,[18,19,5533,5534],[18,19,5533,5534],[19,5534]],
[[-96,34,0],[-94,31,0],[-95,35,0,],0xFFFFFF,[20,5535],[20,21,5535,5536],[20,21,5535,5536]],
[[-95,35,0],[-94,31,0],[-93,31,0,],0xFFFFFF,[20,21,5535,5536],[20,21,5535,5536],[21,22,23,5536,5537,5538]],
[[-99,32,0],[-93,31,0],[-94,33,0,],0xFFFFFF,[12,22,23,5527,5537,5538],[21,22,23,5536,5537,5538],[22,5537]],
[[-99,32,0],[-100,31,0],[-93,31,0,],0xFFFFFF,[12,22,23,5527,5537,5538],[7,23,5522,5538],[21,22,23,5536,5537,5538]],
[[-88,34,0],[-87,31,0],[-87,35,0,],0xFFFFFF,[24,5539],[24,25,5539,5540],[24,25,5539,5540]],
[[-87,35,0],[-87,31,0],[-86,32,0,],0xFFFFFF,[24,25,5539,5540],[24,25,5539,5540],[25,26,27,5540,5541,5542]],
[[-91,33,0],[-86,32,0],[-86,33,0,],0xFFFFFF,[18,26,27,5533,5541,5542],[25,26,27,5540,5541,5542],[26,5541]],
[[-91,33,0],[-92,31,0],[-86,32,0,],0xFFFFFF,[18,26,27,5533,5541,5542],[27,5542],[25,26,27,5540,5541,5542]],
[[-94,41,0],[-94,28,0],[-92,30,0,],0xFFFFFF,[28,29,5543,5544],[28,30,31,5543,5545,5546],[28,29,30,5543,5544,5545]],
[[-92,30,0],[-92,41,0],[-94,41,0,],0xFFFFFF,[28,29,30,5543,5544,5545],[29,5544],[28,29,5543,5544]],
[[-94,28,0],[-91,26,0],[-92,30,0,],0xFFFFFF,[28,30,31,5543,5545,5546],[30,31,32,5545,5546,5547],[28,29,30,5543,5544,5545]],
[[-91,26,0],[-94,28,0],[-92,24,0,],0xFFFFFF,[30,31,32,5545,5546,5547],[28,30,31,5543,5545,5546],[31,32,33,5546,5547,5548]],
[[-91,26,0],[-92,24,0],[-90,24,0,],0xFFFFFF,[30,31,32,5545,5546,5547],[31,32,33,5546,5547,5548],[32,33,34,5547,5548,5549]],
[[-92,24,0],[-90,21,0],[-90,24,0,],0xFFFFFF,[31,32,33,5546,5547,5548],[33,34,35,5548,5549,5550],[32,33,34,5547,5548,5549]],
[[-90,24,0],[-90,21,0],[-88,22,0,],0xFFFFFF,[32,33,34,5547,5548,5549],[33,34,35,5548,5549,5550],[34,35,36,37,5549,5550,5551,5552]],
[[-90,21,0],[-87,20,0],[-88,22,0,],0xFFFFFF,[33,34,35,5548,5549,5550],[35,36,5550,5551],[34,35,36,37,5549,5550,5551,5552]],
[[-88,22,0],[-87,20,0],[-86,21,0,],0xFFFFFF,[34,35,36,37,5549,5550,5551,5552],[35,36,5550,5551],[36,37,38,5551,5552,5553]],
[[-86,21,0],[-87,24,0],[-88,22,0,],0xFFFFFF,[36,37,38,5551,5552,5553],[37,38,5552,5553],[34,35,36,37,5549,5550,5551,5552]],
[[-87,24,0],[-86,21,0],[-85,23,0,],0xFFFFFF,[37,38,5552,5553],[36,37,38,5551,5552,5553],[38,5553]],
[[-100,30,0],[-100,28,0],[-85,30,0,],0xFFFFFF,[39,5554],[39,40,5554,5555],[39,40,5554,5555]],
[[-85,30,0],[-100,28,0],[-85,28,0,],0xFFFFFF,[39,40,5554,5555],[39,40,5554,5555],[40,5555]],
[[-90,31,0],[-89,29,0],[-88,32,0,],0xFFFFFF,[41,5556],[41,42,5556,5557],[41,42,5556,5557]],
[[-88,32,0],[-89,29,0],[-87,29,0,],0xFFFFFF,[41,42,5556,5557],[41,42,5556,5557],[42,5557]],
[[-99,26,0],[-97,29,0],[-99,29,0,],0xFFFFFF,[43,44,48,5558,5559,5563],[43,44,5558,5559],[43,5558]],
[[-99,26,0],[-97,25,0],[-97,29,0,],0xFFFFFF,[43,44,48,5558,5559,5563],[44,45,48,5559,5560,5563],[43,44,5558,5559]],
[[-97,25,0],[-100,23,0],[-98,22,0,],0xFFFFFF,[44,45,48,5559,5560,5563],[45,46,48,5560,5561,5563],[45,46,47,5560,5561,5562]],
[[-100,23,0],[-101,21,0],[-98,22,0,],0xFFFFFF,[45,46,48,5560,5561,5563],[46,47,5561,5562],[45,46,47,5560,5561,5562]],
[[-98,22,0],[-101,21,0],[-100,20,0,],0xFFFFFF,[45,46,47,5560,5561,5562],[46,47,5561,5562],[47,5562]],
[[-99,26,0],[-100,23,0],[-97,25,0,],0xFFFFFF,[43,44,48,5558,5559,5563],[45,46,48,5560,5561,5563],[44,45,48,5559,5560,5563]],
[[-97,27,0],[-98,26,0],[-95,24,0,],0xFFFFFF,[49,50,5564,5565],[49,5564],[49,50,5564,5565]],
[[-95,24,0],[-94,25,0],[-97,27,0,],0xFFFFFF,[49,50,5564,5565],[50,5565],[49,50,5564,5565]],
[[-89,28,0],[-89,24,0],[-87,27,0,],0xFFFFFF,[51,52,5566,5567],[51,52,53,5566,5567,5568],[51,5566]],
[[-89,24,0],[-89,28,0],[-91,25,0,],0xFFFFFF,[51,52,53,5566,5567,5568],[51,52,5566,5567],[52,53,54,5567,5568,5569]],
[[-91,25,0],[-92,22,0],[-89,24,0,],0xFFFFFF,[52,53,54,5567,5568,5569],[53,54,55,5568,5569,5570],[51,52,53,5566,5567,5568]],
[[-92,22,0],[-91,25,0],[-94,23,0,],0xFFFFFF,[53,54,55,5568,5569,5570],[52,53,54,5567,5568,5569],[54,55,56,5569,5570,5571]],
[[-94,23,0],[-96,20,0],[-92,22,0,],0xFFFFFF,[54,55,56,5569,5570,5571],[55,56,5570,5571],[53,54,55,5568,5569,5570]],
[[-96,20,0],[-94,23,0],[-97,22,0,],0xFFFFFF,[55,56,5570,5571],[54,55,56,5569,5570,5571],[56,5571]],
[[-83,40,0],[-82,38,0],[-78,38,0,],0xFFFFFF,[57,58,5572,5573],[57,5572],[57,58,59,60,5572,5573,5574,5575]],
[[-83,40,0],[-78,38,0],[-78,40,0,],0xFFFFFF,[57,58,5572,5573],[57,58,59,60,5572,5573,5574,5575],[58,59,5573,5574]],
[[-78,40,0],[-78,38,0],[-76,40,0,],0xFFFFFF,[58,59,5573,5574],[57,58,59,60,5572,5573,5574,5575],[59,60,61,62,5574,5575,5576,5577]],
[[-78,38,0],[-75,38,0],[-76,40,0,],0xFFFFFF,[57,58,59,60,5572,5573,5574,5575],[60,61,5575,5576],[59,60,61,62,5574,5575,5576,5577]],
[[-75,38,0],[-72,39,0],[-76,40,0,],0xFFFFFF,[60,61,5575,5576],[61,62,5576,5577],[59,60,61,62,5574,5575,5576,5577]],
[[-76,40,0],[-72,39,0],[-73,41,0,],0xFFFFFF,[59,60,61,62,5574,5575,5576,5577],[61,62,5576,5577],[62,5577]],
[[-82,21,0],[-72,24,0],[-83,23,0,],0xFFFFFF,[63,64,5578,5579],[63,64,5578,5579],[63,5578]],
[[-82,21,0],[-71,23,0],[-72,24,0,],0xFFFFFF,[63,64,5578,5579],[64,5579],[63,64,5578,5579]],
[[-83,38,0],[-83,36,0],[-70,36,0,],0xFFFFFF,[65,66,5580,5581],[65,5580],[65,66,5580,5581]],
[[-83,38,0],[-70,36,0],[-70,38,0,],0xFFFFFF,[65,66,5580,5581],[65,66,5580,5581],[66,5581]],
[[-76,38,0],[-78,38,0],[-77,23,0,],0xFFFFFF,[67,68,5582,5583],[67,5582],[67,68,5582,5583]],
[[-76,38,0],[-77,23,0],[-76,23,0,],0xFFFFFF,[67,68,5582,5583],[67,68,5582,5583],[68,5583]],
[[-82,28,0],[-80,28,0],[-82,35,0,],0xFFFFFF,[69,83,84,5584,5598,5599],[69,70,5584,5585],[69,70,73,5584,5585,5588]],
[[-82,35,0],[-80,28,0],[-80,35,0,],0xFFFFFF,[69,70,73,5584,5585,5588],[69,70,5584,5585],[70,5585]],
[[-73,35,0],[-73,28,0],[-72,28,0,],0xFFFFFF,[71,72,5586,5587],[71,5586],[71,72,5586,5587]],
[[-73,35,0],[-72,28,0],[-71,35,0,],0xFFFFFF,[71,72,5586,5587],[71,72,5586,5587],[72,73,74,5587,5588,5589]],
[[-82,35,0],[-80,33,0],[-71,35,0,],0xFFFFFF,[69,70,73,5584,5585,5588],[73,74,5588,5589],[72,73,74,5587,5588,5589]],
[[-80,33,0],[-73,33,0],[-71,35,0,],0xFFFFFF,[73,74,5588,5589],[74,5589],[72,73,74,5587,5588,5589]],
[[-80,32,0],[-80,31,0],[-78,32,0,],0xFFFFFF,[75,5590],[75,76,5590,5591],[75,76,77,78,5590,5591,5592,5593]],
[[-80,31,0],[-78,31,0],[-78,32,0,],0xFFFFFF,[75,76,5590,5591],[76,78,5591,5593],[75,76,77,78,5590,5591,5592,5593]],
[[-76,32,0],[-78,32,0],[-76,31,0,],0xFFFFFF,[77,79,80,5592,5594,5595],[75,76,77,78,5590,5591,5592,5593],[77,78,80,5592,5593,5595]],
[[-76,31,0],[-78,32,0],[-78,31,0,],0xFFFFFF,[77,78,80,5592,5593,5595],[75,76,77,78,5590,5591,5592,5593],[76,78,5591,5593]],
[[-73,32,0],[-76,32,0],[-73,31,0,],0xFFFFFF,[79,81,82,5594,5596,5597],[77,79,80,5592,5594,5595],[79,80,82,5594,5595,5597]],
[[-73,31,0],[-76,32,0],[-76,31,0,],0xFFFFFF,[79,80,82,5594,5595,5597],[77,79,80,5592,5594,5595],[77,78,80,5592,5593,5595]],
[[-71,32,0],[-73,32,0],[-71,31,0,],0xFFFFFF,[81,5596],[79,81,82,5594,5596,5597],[81,82,5596,5597]],
[[-71,31,0],[-73,32,0],[-73,31,0,],0xFFFFFF,[81,82,5596,5597],[79,81,82,5594,5596,5597],[79,80,82,5594,5595,5597]],
[[-82,29,0],[-82,28,0],[-80,29,0,],0xFFFFFF,[83,5598],[69,83,84,5584,5598,5599],[83,84,85,5598,5599,5600]],
[[-82,28,0],[-80,28,0],[-80,29,0,],0xFFFFFF,[69,83,84,5584,5598,5599],[84,85,86,5599,5600,5601],[83,84,85,5598,5599,5600]],
[[-80,29,0],[-80,28,0],[-78,29,0,],0xFFFFFF,[83,84,85,5598,5599,5600],[84,85,86,5599,5600,5601],[85,86,87,88,5600,5601,5602,5603]],
[[-80,28,0],[-78,28,0],[-78,29,0,],0xFFFFFF,[84,85,86,5599,5600,5601],[86,88,5601,5603],[85,86,87,88,5600,5601,5602,5603]],
[[-76,29,0],[-78,29,0],[-76,28,0,],0xFFFFFF,[87,89,90,5602,5604,5605],[85,86,87,88,5600,5601,5602,5603],[87,88,90,5602,5603,5605]],
[[-76,28,0],[-78,29,0],[-78,28,0,],0xFFFFFF,[87,88,90,5602,5603,5605],[85,86,87,88,5600,5601,5602,5603],[86,88,5601,5603]],
[[-73,29,0],[-76,29,0],[-73,28,0,],0xFFFFFF,[89,91,92,5604,5606,5607],[87,89,90,5602,5604,5605],[89,90,92,5604,5605,5607]],
[[-73,28,0],[-76,29,0],[-76,28,0,],0xFFFFFF,[89,90,92,5604,5605,5607],[87,89,90,5602,5604,5605],[87,88,90,5602,5603,5605]],
[[-71,29,0],[-73,29,0],[-71,28,0,],0xFFFFFF,[91,5606],[89,91,92,5604,5606,5607],[91,92,5606,5607]],
[[-71,28,0],[-73,29,0],[-73,28,0,],0xFFFFFF,[91,92,5606,5607],[89,91,92,5604,5606,5607],[89,90,92,5604,5605,5607]],
[[-82,27,0],[-81,25,0],[-71,27,0,],0xFFFFFF,[93,5608],[93,94,5608,5609],[93,94,5608,5609]],
[[-71,27,0],[-81,25,0],[-71,25,0,],0xFFFFFF,[93,94,5608,5609],[93,94,5608,5609],[94,5609]],
[[-69,36,0],[-67,36,0],[-69,40,0,],0xFFFFFF,[95,97,101,102,5610,5612,5616,5617],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[95,96,5610,5611]],
[[-67,36,0],[-67,40,0],[-69,40,0,],0xFFFFFF,[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[96,5611],[95,96,5610,5611]],
[[-69,36,0],[-69,34,0],[-67,36,0,],0xFFFFFF,[95,97,101,102,5610,5612,5616,5617],[97,98,99,102,5612,5613,5614,5617],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619]],
[[-69,34,0],[-67,34,0],[-67,36,0,],0xFFFFFF,[97,98,99,102,5612,5613,5614,5617],[98,99,100,104,5613,5614,5615,5619],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619]],
[[-69,34,0],[-69,28,0],[-67,34,0,],0xFFFFFF,[97,98,99,102,5612,5613,5614,5617],[99,100,109,110,5614,5615,5624,5625],[98,99,100,104,5613,5614,5615,5619]],
[[-67,34,0],[-69,28,0],[-67,28,0,],0xFFFFFF,[98,99,100,104,5613,5614,5615,5619],[99,100,109,110,5614,5615,5624,5625],[100,109,5615,5624]],
[[-71,36,0],[-71,34,0],[-69,36,0,],0xFFFFFF,[101,5616],[101,102,5616,5617],[95,97,101,102,5610,5612,5616,5617]],
[[-71,34,0],[-69,34,0],[-69,36,0,],0xFFFFFF,[101,102,5616,5617],[97,98,99,102,5612,5613,5614,5617],[95,97,101,102,5610,5612,5616,5617]],
[[-65,36,0],[-67,36,0],[-65,34,0,],0xFFFFFF,[103,105,106,5618,5620,5621],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[103,104,106,107,108,5618,5619,5621,5622,5623]],
[[-65,34,0],[-67,36,0],[-67,34,0,],0xFFFFFF,[103,104,106,107,108,5618,5619,5621,5622,5623],[95,96,97,98,103,104,5610,5611,5612,5613,5618,5619],[98,99,100,104,5613,5614,5615,5619]],
[[-62,36,0],[-65,36,0],[-62,34,0,],0xFFFFFF,[105,5620],[103,105,106,5618,5620,5621],[105,106,107,5620,5621,5622]],
[[-65,36,0],[-65,34,0],[-62,34,0,],0xFFFFFF,[103,105,106,5618,5620,5621],[103,104,106,107,108,5618,5619,5621,5622,5623],[105,106,107,5620,5621,5622]],
[[-62,34,0],[-65,34,0],[-62,24,0,],0xFFFFFF,[105,106,107,5620,5621,5622],[103,104,106,107,108,5618,5619,5621,5622,5623],[107,108,114,5622,5623,5629]],
[[-65,34,0],[-65,24,0],[-62,24,0,],0xFFFFFF,[103,104,106,107,108,5618,5619,5621,5622,5623],[108,114,115,5623,5629,5630],[107,108,114,5622,5623,5629]],
[[-67,28,0],[-69,28,0],[-68,24,0,],0xFFFFFF,[100,109,5615,5624],[99,100,109,110,5614,5615,5624,5625],[109,110,111,5624,5625,5626]],
[[-69,28,0],[-70,24,0],[-68,24,0,],0xFFFFFF,[99,100,109,110,5614,5615,5624,5625],[110,111,112,5625,5626,5627],[109,110,111,5624,5625,5626]],
[[-70,24,0],[-70,21,0],[-68,24,0,],0xFFFFFF,[110,111,112,5625,5626,5627],[111,112,113,5626,5627,5628],[109,110,111,5624,5625,5626]],
[[-70,21,0],[-70,24,0],[-74,21,0,],0xFFFFFF,[111,112,113,5626,5627,5628],[110,111,112,5625,5626,5627],[112,113,5627,5628]],
[[-74,21,0],[-72,20,0],[-70,21,0,],0xFFFFFF,[112,113,5627,5628],[113,5628],[111,112,113,5626,5627,5628]],
[[-62,24,0],[-65,24,0],[-63,22,0,],0xFFFFFF,[107,108,114,5622,5623,5629],[108,114,115,5623,5629,5630],[114,115,116,5629,5630,5631]],
[[-65,24,0],[-65,23,0],[-63,22,0,],0xFFFFFF,[108,114,115,5623,5629,5630],[115,116,117,118,5630,5631,5632,5633],[114,115,116,5629,5630,5631]],
[[-65,23,0],[-65,20,0],[-63,22,0,],0xFFFFFF,[115,116,117,118,5630,5631,5632,5633],[116,117,5631,5632],[114,115,116,5629,5630,5631]],
[[-68,20,0],[-65,20,0],[-65,23,0,],0xFFFFFF,[117,118,5632,5633],[116,117,5631,5632],[115,116,117,118,5630,5631,5632,5633]],
[[-67,22,0],[-68,20,0],[-65,23,0,],0xFFFFFF,[118,5633],[117,118,5632,5633],[115,116,117,118,5630,5631,5632,5633]],
[[-59,40,0],[-57,37,0],[-58,41,0,],0xFFFFFF,[119,5634],[119,120,5634,5635],[119,120,5634,5635]],
[[-58,41,0],[-57,37,0],[-55,38,0,],0xFFFFFF,[119,120,5634,5635],[119,120,5634,5635],[120,5635]],
[[-55,40,0],[-53,37,0],[-54,41,0,],0xFFFFFF,[121,5636],[121,122,5636,5637],[121,122,5636,5637]],
[[-54,41,0],[-53,37,0],[-52,38,0,],0xFFFFFF,[121,122,5636,5637],[121,122,5636,5637],[122,5637]],
[[-51,37,0],[-49,36,0],[-49,41,0,],0xFFFFFF,[123,5638],[123,124,5638,5639],[123,124,5638,5639]],
[[-49,36,0],[-47,40,0],[-49,41,0,],0xFFFFFF,[123,124,5638,5639],[124,5639],[123,124,5638,5639]],
[[-58,36,0],[-58,35,0],[-57,36,0,],0xFFFFFF,[125,5640],[125,126,135,5640,5641,5650],[125,126,127,5640,5641,5642]],
[[-58,35,0],[-57,35,0],[-57,36,0,],0xFFFFFF,[125,126,135,5640,5641,5650],[126,127,128,135,136,5641,5642,5643,5650,5651],[125,126,127,5640,5641,5642]],
[[-57,36,0],[-57,35,0],[-54,36,0,],0xFFFFFF,[125,126,127,5640,5641,5642],[126,127,128,135,136,5641,5642,5643,5650,5651],[127,128,129,5642,5643,5644]],
[[-57,35,0],[-54,35,0],[-54,36,0,],0xFFFFFF,[126,127,128,135,136,5641,5642,5643,5650,5651],[128,129,130,137,5643,5644,5645,5652],[127,128,129,5642,5643,5644]],
[[-54,36,0],[-54,35,0],[-52,36,0,],0xFFFFFF,[127,128,129,5642,5643,5644],[128,129,130,137,5643,5644,5645,5652],[129,130,131,5644,5645,5646]],
[[-54,35,0],[-52,35,0],[-52,36,0,],0xFFFFFF,[128,129,130,137,5643,5644,5645,5652],[130,131,132,137,138,5645,5646,5647,5652,5653],[129,130,131,5644,5645,5646]],
[[-52,36,0],[-52,35,0],[-50,36,0,],0xFFFFFF,[129,130,131,5644,5645,5646],[130,131,132,137,138,5645,5646,5647,5652,5653],[131,132,133,5646,5647,5648]],
[[-52,35,0],[-50,35,0],[-50,36,0,],0xFFFFFF,[130,131,132,137,138,5645,5646,5647,5652,5653],[132,133,134,139,5647,5648,5649,5654],[131,132,133,5646,5647,5648]],
[[-50,36,0],[-50,35,0],[-48,36,0,],0xFFFFFF,[131,132,133,5646,5647,5648],[132,133,134,139,5647,5648,5649,5654],[133,134,5648,5649]],
[[-50,35,0],[-48,35,0],[-48,36,0,],0xFFFFFF,[132,133,134,139,5647,5648,5649,5654],[134,139,140,5649,5654,5655],[133,134,5648,5649]],
[[-58,35,0],[-58,33,0],[-57,35,0,],0xFFFFFF,[125,126,135,5640,5641,5650],[135,136,141,5650,5651,5656],[126,127,128,135,136,5641,5642,5643,5650,5651]],
[[-58,33,0],[-57,33,0],[-57,35,0,],0xFFFFFF,[135,136,141,5650,5651,5656],[136,141,142,143,5651,5656,5657,5658],[126,127,128,135,136,5641,5642,5643,5650,5651]],
[[-54,35,0],[-54,33,0],[-52,35,0,],0xFFFFFF,[128,129,130,137,5643,5644,5645,5652],[137,138,143,144,145,5652,5653,5658,5659,5660],[130,131,132,137,138,5645,5646,5647,5652,5653]],
[[-54,33,0],[-52,33,0],[-52,35,0,],0xFFFFFF,[137,138,143,144,145,5652,5653,5658,5659,5660],[138,145,146,147,5653,5660,5661,5662],[130,131,132,137,138,5645,5646,5647,5652,5653]],
[[-50,35,0],[-50,33,0],[-48,35,0,],0xFFFFFF,[132,133,134,139,5647,5648,5649,5654],[139,140,147,148,149,5654,5655,5662,5663,5664],[134,139,140,5649,5654,5655]],
[[-50,33,0],[-48,33,0],[-48,35,0,],0xFFFFFF,[139,140,147,148,149,5654,5655,5662,5663,5664],[140,149,150,5655,5664,5665],[134,139,140,5649,5654,5655]],
[[-58,33,0],[-58,31,0],[-57,33,0,],0xFFFFFF,[135,136,141,5650,5651,5656],[141,142,151,5656,5657,5666],[136,141,142,143,5651,5656,5657,5658]],
[[-58,31,0],[-57,31,0],[-57,33,0,],0xFFFFFF,[141,142,151,5656,5657,5666],[142,143,144,151,152,5657,5658,5659,5666,5667],[136,141,142,143,5651,5656,5657,5658]],
[[-57,33,0],[-57,31,0],[-54,33,0,],0xFFFFFF,[136,141,142,143,5651,5656,5657,5658],[142,143,144,151,152,5657,5658,5659,5666,5667],[137,138,143,144,145,5652,5653,5658,5659,5660]],
[[-57,31,0],[-54,31,0],[-54,33,0,],0xFFFFFF,[142,143,144,151,152,5657,5658,5659,5666,5667],[144,145,146,153,5659,5660,5661,5668],[137,138,143,144,145,5652,5653,5658,5659,5660]],
[[-54,33,0],[-54,31,0],[-52,33,0,],0xFFFFFF,[137,138,143,144,145,5652,5653,5658,5659,5660],[144,145,146,153,5659,5660,5661,5668],[138,145,146,147,5653,5660,5661,5662]],
[[-54,31,0],[-52,31,0],[-52,33,0,],0xFFFFFF,[144,145,146,153,5659,5660,5661,5668],[146,147,148,153,154,5661,5662,5663,5668,5669],[138,145,146,147,5653,5660,5661,5662]],
[[-52,33,0],[-52,31,0],[-50,33,0,],0xFFFFFF,[138,145,146,147,5653,5660,5661,5662],[146,147,148,153,154,5661,5662,5663,5668,5669],[139,140,147,148,149,5654,5655,5662,5663,5664]],
[[-52,31,0],[-50,31,0],[-50,33,0,],0xFFFFFF,[146,147,148,153,154,5661,5662,5663,5668,5669],[148,149,150,155,5663,5664,5665,5670],[139,140,147,148,149,5654,5655,5662,5663,5664]],
[[-50,33,0],[-50,31,0],[-48,33,0,],0xFFFFFF,[139,140,147,148,149,5654,5655,5662,5663,5664],[148,149,150,155,5663,5664,5665,5670],[140,149,150,5655,5664,5665]],
[[-50,31,0],[-48,31,0],[-48,33,0,],0xFFFFFF,[148,149,150,155,5663,5664,5665,5670],[150,155,156,5665,5670,5671],[140,149,150,5655,5664,5665]],
[[-58,31,0],[-58,30,0],[-57,31,0,],0xFFFFFF,[141,142,151,5656,5657,5666],[151,152,157,5666,5667,5672],[142,143,144,151,152,5657,5658,5659,5666,5667]],
[[-58,30,0],[-57,30,0],[-57,31,0,],0xFFFFFF,[151,152,157,5666,5667,5672],[152,157,158,161,5667,5672,5673,5676],[142,143,144,151,152,5657,5658,5659,5666,5667]],
[[-54,31,0],[-54,30,0],[-52,31,0,],0xFFFFFF,[144,145,146,153,5659,5660,5661,5668],[153,154,161,162,163,5668,5669,5676,5677,5678],[146,147,148,153,154,5661,5662,5663,5668,5669]],
[[-54,30,0],[-52,30,0],[-52,31,0,],0xFFFFFF,[153,154,161,162,163,5668,5669,5676,5677,5678],[154,163,164,165,5669,5678,5679,5680],[146,147,148,153,154,5661,5662,5663,5668,5669]],
[[-50,31,0],[-50,30,0],[-48,31,0,],0xFFFFFF,[148,149,150,155,5663,5664,5665,5670],[155,156,165,166,167,5670,5671,5680,5681,5682],[150,155,156,5665,5670,5671]],
[[-50,30,0],[-48,30,0],[-48,31,0,],0xFFFFFF,[155,156,165,166,167,5670,5671,5680,5681,5682],[156,167,168,5671,5682,5683],[150,155,156,5665,5670,5671]],
[[-58,30,0],[-58,28,0],[-57,30,0,],0xFFFFFF,[151,152,157,5666,5667,5672],[157,158,159,5672,5673,5674],[152,157,158,161,5667,5672,5673,5676]],
[[-58,28,0],[-57,28,0],[-57,30,0,],0xFFFFFF,[157,158,159,5672,5673,5674],[158,159,160,161,162,5673,5674,5675,5676,5677],[152,157,158,161,5667,5672,5673,5676]],
[[-58,28,0],[-58,27,0],[-57,28,0,],0xFFFFFF,[157,158,159,5672,5673,5674],[159,160,5674,5675],[158,159,160,161,162,5673,5674,5675,5676,5677]],
[[-58,27,0],[-57,27,0],[-57,28,0,],0xFFFFFF,[159,160,5674,5675],[160,5675],[158,159,160,161,162,5673,5674,5675,5676,5677]],
[[-57,30,0],[-57,28,0],[-54,30,0,],0xFFFFFF,[152,157,158,161,5667,5672,5673,5676],[158,159,160,161,162,5673,5674,5675,5676,5677],[153,154,161,162,163,5668,5669,5676,5677,5678]],
[[-57,28,0],[-54,28,0],[-54,30,0,],0xFFFFFF,[158,159,160,161,162,5673,5674,5675,5676,5677],[162,163,164,179,5677,5678,5679,5694],[153,154,161,162,163,5668,5669,5676,5677,5678]],
[[-54,30,0],[-54,28,0],[-52,30,0,],0xFFFFFF,[153,154,161,162,163,5668,5669,5676,5677,5678],[162,163,164,179,5677,5678,5679,5694],[154,163,164,165,5669,5678,5679,5680]],
[[-54,28,0],[-52,28,0],[-52,30,0,],0xFFFFFF,[162,163,164,179,5677,5678,5679,5694],[164,165,166,179,180,5679,5680,5681,5694,5695],[154,163,164,165,5669,5678,5679,5680]],
[[-52,30,0],[-52,28,0],[-50,30,0,],0xFFFFFF,[154,163,164,165,5669,5678,5679,5680],[164,165,166,179,180,5679,5680,5681,5694,5695],[155,156,165,166,167,5670,5671,5680,5681,5682]],
[[-52,28,0],[-50,28,0],[-50,30,0,],0xFFFFFF,[164,165,166,179,180,5679,5680,5681,5694,5695],[166,167,168,169,5681,5682,5683,5684],[155,156,165,166,167,5670,5671,5680,5681,5682]],
[[-50,30,0],[-50,28,0],[-48,30,0,],0xFFFFFF,[155,156,165,166,167,5670,5671,5680,5681,5682],[166,167,168,169,5681,5682,5683,5684],[156,167,168,5671,5682,5683]],
[[-50,28,0],[-48,28,0],[-48,30,0,],0xFFFFFF,[166,167,168,169,5681,5682,5683,5684],[168,169,170,5683,5684,5685],[156,167,168,5671,5682,5683]],
[[-50,28,0],[-50,27,0],[-48,28,0,],0xFFFFFF,[166,167,168,169,5681,5682,5683,5684],[169,170,5684,5685],[168,169,170,5683,5684,5685]],
[[-50,27,0],[-48,27,0],[-48,28,0,],0xFFFFFF,[169,170,5684,5685],[170,5685],[168,169,170,5683,5684,5685]],
[[-54,26,0],[-59,26,0],[-54,25,0,],0xFFFFFF,[171,173,179,180,5686,5688,5694,5695],[171,172,5686,5687],[171,172,173,174,177,5686,5687,5688,5689,5692]],
[[-54,25,0],[-59,26,0],[-59,25,0,],0xFFFFFF,[171,172,173,174,177,5686,5687,5688,5689,5692],[171,172,5686,5687],[172,5687]],
[[-54,26,0],[-54,25,0],[-52,26,0,],0xFFFFFF,[171,173,179,180,5686,5688,5694,5695],[171,172,173,174,177,5686,5687,5688,5689,5692],[173,174,175,180,5688,5689,5690,5695]],
[[-54,25,0],[-52,25,0],[-52,26,0,],0xFFFFFF,[171,172,173,174,177,5686,5687,5688,5689,5692],[174,175,176,177,178,5689,5690,5691,5692,5693],[173,174,175,180,5688,5689,5690,5695]],
[[-52,26,0],[-52,25,0],[-47,26,0,],0xFFFFFF,[173,174,175,180,5688,5689,5690,5695],[174,175,176,177,178,5689,5690,5691,5692,5693],[175,176,5690,5691]],
[[-52,25,0],[-47,25,0],[-47,26,0,],0xFFFFFF,[174,175,176,177,178,5689,5690,5691,5692,5693],[176,5691],[175,176,5690,5691]],
[[-54,25,0],[-54,20,0],[-52,25,0,],0xFFFFFF,[171,172,173,174,177,5686,5687,5688,5689,5692],[177,178,5692,5693],[174,175,176,177,178,5689,5690,5691,5692,5693]],
[[-52,25,0],[-54,20,0],[-52,20,0,],0xFFFFFF,[174,175,176,177,178,5689,5690,5691,5692,5693],[177,178,5692,5693],[178,5693]],
[[-54,28,0],[-54,26,0],[-52,28,0,],0xFFFFFF,[162,163,164,179,5677,5678,5679,5694],[171,173,179,180,5686,5688,5694,5695],[164,165,166,179,180,5679,5680,5681,5694,5695]],
[[-52,28,0],[-54,26,0],[-52,26,0,],0xFFFFFF,[164,165,166,179,180,5679,5680,5681,5694,5695],[171,173,179,180,5686,5688,5694,5695],[173,174,175,180,5688,5689,5690,5695]],
[[-46,41,0],[-45,33,0],[-44,41,0,],0xFFFFFF,[181,5696],[181,182,183,5696,5697,5698],[181,182,5696,5697]],
[[-44,41,0],[-45,33,0],[-44,33,0,],0xFFFFFF,[181,182,5696,5697],[181,182,183,5696,5697,5698],[182,183,184,5697,5698,5699]],
[[-45,33,0],[-45,29,0],[-44,33,0,],0xFFFFFF,[181,182,183,5696,5697,5698],[183,184,198,5698,5699,5700,5700,5713],[182,183,184,5697,5698,5699]],
[[-44,33,0],[-45,29,0],[-43,28,0,],0xFFFFFF,[182,183,184,5697,5698,5699],[183,184,198,5698,5699,5700,5700,5713],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715]],
[[-45,29,0],[-44,26,0],[-45,29,0,],0xFFFFFF,[183,184,198,5698,5699,5700,5700,5713],[186,188,198,5700,5701,5703,5713],[183,184,198,5698,5699,5700,5700,5713]],
[[-44,26,0],[-43,24,0],[-43,28,0,],0xFFFFFF,[186,188,198,5700,5701,5703,5713],[186,187,188,189,192,5701,5702,5703,5704,5707],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715]],
[[-43,28,0],[-43,24,0],[-42,26,0,],0xFFFFFF,[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[186,187,188,189,192,5701,5702,5703,5704,5707],[187,192,193,199,5702,5707,5708,5714]],
[[-44,26,0],[-47,24,0],[-43,24,0,],0xFFFFFF,[186,188,198,5700,5701,5703,5713],[188,189,190,5703,5704,5705],[186,187,188,189,192,5701,5702,5703,5704,5707]],
[[-47,24,0],[-47,21,0],[-43,24,0,],0xFFFFFF,[188,189,190,5703,5704,5705],[189,190,191,5704,5705,5706],[186,187,188,189,192,5701,5702,5703,5704,5707]],
[[-47,21,0],[-47,24,0],[-50,22,0,],0xFFFFFF,[189,190,191,5704,5705,5706],[188,189,190,5703,5704,5705],[190,191,5705,5706]],
[[-50,22,0],[-49,19,0],[-47,21,0,],0xFFFFFF,[190,191,5705,5706],[191,5706],[189,190,191,5704,5705,5706]],
[[-43,24,0],[-42,21,0],[-42,26,0,],0xFFFFFF,[186,187,188,189,192,5701,5702,5703,5704,5707],[192,193,5707,5708],[187,192,193,199,5702,5707,5708,5714]],
[[-42,26,0],[-42,21,0],[-40,23,0,],0xFFFFFF,[187,192,193,199,5702,5707,5708,5714],[192,193,5707,5708],[193,194,195,197,5708,5709,5710,5712]],
[[-40,23,0],[-42,22,0],[-40,20,0,],0xFFFFFF,[193,194,195,197,5708,5709,5710,5712],[194,5709],[194,195,5709,5710]],
[[-40,23,0],[-40,20,0],[-38,22,0,],0xFFFFFF,[193,194,195,197,5708,5709,5710,5712],[194,195,5709,5710],[195,196,197,5710,5711,5712]],
[[-38,22,0],[-38,24,0],[-40,26,0,],0xFFFFFF,[195,196,197,5710,5711,5712],[196,5711],[196,197,5711,5712]],
[[-40,26,0],[-40,23,0],[-38,22,0,],0xFFFFFF,[196,197,5711,5712],[193,194,195,197,5708,5709,5710,5712],[195,196,197,5710,5711,5712]],
[[-45,29,0],[-44,26,0],[-43,28,0,],0xFFFFFF,[183,184,198,5698,5699,5700,5700,5713],[186,188,198,5700,5701,5703,5713],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715]],
[[-43,28,0],[-42,26,0],[-40,29,0,],0xFFFFFF,[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715],[187,192,193,199,5702,5707,5708,5714],[199,200,201,5714,5715,5716]],
[[-40,29,0],[-41,32,0],[-43,28,0,],0xFFFFFF,[199,200,201,5714,5715,5716],[200,201,5715,5716],[184,186,187,198,199,200,5699,5701,5702,5713,5714,5715]],
[[-41,32,0],[-40,29,0],[-39,32,0,],0xFFFFFF,[200,201,5715,5716],[199,200,201,5714,5715,5716],[201,5716]],
[[-48,35,0],[-48,33,0],[-39,35,0,],0xFFFFFF,[202,5717],[202,203,5717,5718],[202,203,5717,5718]],
[[-48,33,0],[-39,33,0],[-39,35,0,],0xFFFFFF,[202,203,5717,5718],[203,5718],[202,203,5717,5718]],
[[-43,39,0],[-41,36,0],[-41,40,0,],0xFFFFFF,[204,5719],[204,205,5719,5720],[204,205,5719,5720]],
[[-41,40,0],[-41,36,0],[-40,37,0,],0xFFFFFF,[204,205,5719,5720],[204,205,5719,5720],[205,5720]],
[[-24,35,0],[-26,35,0],[-24,32,0,],0xFFFFFF,[206,212,213,216,5721,5727,5728,5731],[206,207,210,216,217,5721,5722,5725,5731,5732],[206,207,213,218,5721,5722,5728,5733]],
[[-24,32,0],[-26,35,0],[-26,32,0,],0xFFFFFF,[206,207,213,218,5721,5722,5728,5733],[206,207,210,216,217,5721,5722,5725,5731,5732],[207,210,211,218,219,5722,5725,5726,5733,5734]],
[[-35,35,0],[-35,32,0],[-34,35,0,],0xFFFFFF,[208,5723],[208,209,5723,5724],[208,209,210,211,5723,5724,5725,5726]],
[[-35,32,0],[-34,32,0],[-34,35,0,],0xFFFFFF,[208,209,5723,5724],[209,211,5724,5726],[208,209,210,211,5723,5724,5725,5726]],
[[-26,35,0],[-34,35,0],[-26,32,0,],0xFFFFFF,[206,207,210,216,217,5721,5722,5725,5731,5732],[208,209,210,211,5723,5724,5725,5726],[207,210,211,218,219,5722,5725,5726,5733,5734]],
[[-26,32,0],[-34,35,0],[-34,32,0,],0xFFFFFF,[207,210,211,218,219,5722,5725,5726,5733,5734],[208,209,210,211,5723,5724,5725,5726],[209,211,5724,5726]],
[[-17,35,0],[-24,35,0],[-17,32,0,],0xFFFFFF,[212,214,215,5727,5729,5730],[206,212,213,216,5721,5727,5728,5731],[212,213,215,5727,5728,5730]],
[[-17,32,0],[-24,35,0],[-24,32,0,],0xFFFFFF,[212,213,215,5727,5728,5730],[206,212,213,216,5721,5727,5728,5731],[206,207,213,218,5721,5722,5728,5733]],
[[-15,35,0],[-17,35,0],[-15,32,0,],0xFFFFFF,[214,5729],[212,214,215,5727,5729,5730],[214,215,5729,5730]],
[[-15,32,0],[-17,35,0],[-17,32,0,],0xFFFFFF,[214,215,5729,5730],[212,214,215,5727,5729,5730],[212,213,215,5727,5728,5730]],
[[-24,35,0],[-24,40,0],[-26,35,0,],0xFFFFFF,[206,212,213,216,5721,5727,5728,5731],[216,217,5731,5732],[206,207,210,216,217,5721,5722,5725,5731,5732]],
[[-26,35,0],[-24,40,0],[-26,40,0,],0xFFFFFF,[206,207,210,216,217,5721,5722,5725,5731,5732],[216,217,5731,5732],[217,5732]],
[[-24,32,0],[-26,32,0],[-24,24,0,],0xFFFFFF,[206,207,213,218,5721,5722,5728,5733],[207,210,211,218,219,5722,5725,5726,5733,5734],[218,219,220,224,225,5733,5734,5735,5739,5740]],
[[-24,24,0],[-26,32,0],[-26,24,0,],0xFFFFFF,[218,219,220,224,225,5733,5734,5735,5739,5740],[207,210,211,218,219,5722,5725,5726,5733,5734],[219,220,221,222,5734,5735,5736,5737]],
[[-24,24,0],[-26,24,0],[-24,22,0,],0xFFFFFF,[218,219,220,224,225,5733,5734,5735,5739,5740],[219,220,221,222,5734,5735,5736,5737],[220,221,225,5735,5736,5740]],
[[-24,22,0],[-26,24,0],[-26,22,0,],0xFFFFFF,[220,221,225,5735,5736,5740],[219,220,221,222,5734,5735,5736,5737],[221,222,223,5736,5737,5738]],
[[-26,24,0],[-34,24,0],[-26,22,0,],0xFFFFFF,[219,220,221,222,5734,5735,5736,5737],[222,223,5737,5738],[221,222,223,5736,5737,5738]],
[[-26,22,0],[-34,24,0],[-34,22,0,],0xFFFFFF,[221,222,223,5736,5737,5738],[222,223,5737,5738],[223,5738]],
[[-17,24,0],[-24,24,0],[-17,22,0,],0xFFFFFF,[224,5739],[218,219,220,224,225,5733,5734,5735,5739,5740],[224,225,5739,5740]],
[[-17,22,0],[-24,24,0],[-24,22,0,],0xFFFFFF,[224,225,5739,5740],[218,219,220,224,225,5733,5734,5735,5739,5740],[220,221,225,5735,5736,5740]],

	
];
		　
		public static var scr_width:Number = 500;
		public static var scr_height:Number = 500;
		public static var world_cordinate:Array = new Array(local_cordinate.length);
		public static var screen_cordinate:Array = new Array(local_cordinate.length);
		public static var light:Light = new Light();
		public static var position:Array = new Array(3);
		public static var xRotMatrix:Array = new Array(3);
		public static var yRotMatrix:Array = new Array(3);
		public static var zRotMatrix:Array = new Array(3);
		public static var result:Array = new Array(3);
		public static var fl:Number = 250;
		public static var vpX:Number = 0;
		public static var vpY:Number = 0;
		public static var cX:Number = 0;
		public static var cY:Number = 0;
		public static var cZ:Number = 0;
		public static var init_scr:BitmapData = new BitmapData(scr_width, scr_height);
		public static var scr:BitmapData = new BitmapData(scr_width, scr_height);
		public static var z_buffer:Array;
		public static var z_buf:Boolean = false;
		public static var wire:Boolean = false;
		public static var rotate:Boolean = false;
		
	}	