/**
 * Copyright dfrm ( http://wonderfl.net/user/dfrm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/in6A
 */

package {
    import caurina.transitions.Tweener;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
		private var container:Sprite;
		private var mesh:Sprite;
		private var circ:Sprite;
		private var dummy:Sprite;
		private var bmd:BitmapData;
		private var timer:Timer;
		private var t:Number = 0;
		private var line:Shape;
		
        public function FlashTest() {
            // write as3 code here..
            Init();
            EventListeners();
        }
        
		private function Init():void {
            container = new Sprite();
            container.x = stage.stageWidth/2;
            container.y = stage.stageHeight/2;
            addChild(container);
            
            bmd = new BitmapData(2, 2, true);
            bmd.setPixel32(0, 0, 0x00000000);
            bmd.setPixel32(0, 1, 0xff000000);
            bmd.setPixel32(1, 0, 0xff000000);
            bmd.setPixel32(1, 1, 0x00000000);
                
            mesh = new Sprite();
            mesh.graphics.beginBitmapFill(bmd);
            mesh.graphics.drawCircle(0, 0, 80);
            mesh.graphics.endFill();
            container.addChild(mesh);
                
            circ = new Sprite();
            circ.graphics.beginFill(0x0, 1);
            circ.graphics.drawCircle(0, 0, 70);
            circ.graphics.endFill();
            container.addChild(circ);
            
            dummy = new Sprite();
            dummy.graphics.beginFill(0x0,0);
            dummy.graphics.drawCircle(0, 0, 70);
            dummy.graphics.endFill();
            dummy.buttonMode = true;
            container.addChild(dummy);
            
                
            timer = new Timer(50,0);
            timer.start();
            timer.addEventListener(TimerEvent.TIMER, _tick);
                
            function _tick(e:TimerEvent):void{
            	t += 0.05;
            	mesh.graphics.clear();
            	mesh.graphics.beginBitmapFill(bmd);
            	mesh.graphics.drawCircle(0, 0, 85+(5*Math.sin(t*Math.PI)));
            	mesh.graphics.endFill();
            };
		}
		
		private function EventListeners():void{
		    dummy.addEventListener(MouseEvent.ROLL_OVER, _onRollOver);
		    dummy.addEventListener(MouseEvent.ROLL_OUT, _onRollOut);
		}
		
		private function _onRollOver(e:MouseEvent):void{
		    circ.scaleX = circ.scaleY = 1.3;
		    Tweener.addTween(circ,{
		        scaleX:1,
		        scaleY:1,
		        time:0.4,
		        transition:"easeOutBack"
		    });
		    drawRandomLine(true);
		};
		
		private function _onRollOut(e:MouseEvent):void{
		    circ.scaleX = circ.scaleY = 1;
		    drawRandomLine(false);
		};
		
		private function drawRandomLine(draw:Boolean):void{
		    var sY:int = stage.stageHeight/2;
		    if(draw==true){
                var timer2:Timer = new Timer(5,0);
                timer2.start();
                timer2.addEventListener(TimerEvent.TIMER, _tick);
    		    line = new Shape();
                function _tick(e:TimerEvent):void{
                    line.graphics.clear();
        		    line.graphics.lineStyle(1,0x0);
        		    line.graphics.moveTo(0,sY+Math.random()*40-20);
        		    line.graphics.lineTo(stage.stageWidth,sY+Math.random()*40-20);
        		};
    	    	addChild(line);
	    	} else {
	    	    timer2 = null;
	    	    removeChild(line);
	    	}
		};
    }
}