/**
 * Copyright mikelito33bdx ( http://wonderfl.net/user/mikelito33bdx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/imo5
 */

package {
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Matrix;
    
    [SWF(frameRate="30", width="465", height="465")]
    public class Main extends Sprite {
        
        private const PICTURE_NUMBER:int = 7;
        private const FIRST_CENTER:int = 4;
        
        private var _actualCenter:int;
        private var _pictureList:Array;
        private var _xList:Array;
        public function Main() {
            
            _actualCenter = FIRST_CENTER;
            
            create();
            getPositionX();
            putPictures();
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function create():void {
            _pictureList = [];
            
            for (var i:int = 0; i < PICTURE_NUMBER; i++ ){
                var sp:Sprite = new Sprite();
                sp.graphics.beginFill(0x000000);
                sp.graphics.drawCircle(0, 0, 10);
                sp.graphics.endFill();
                
                var picture:Sprite = new Sprite();
                picture.graphics.beginFill(0xFFFFFF * Math.random(), 0.8);
                picture.graphics.drawRect(0, 0, 100, 100);
                picture.graphics.endFill();
                var myMatrix:Matrix = picture.transform.matrix;
                myMatrix.translate( -picture.width / 2, -picture.height / 2);
                picture.transform.matrix = myMatrix;
                sp.addChild(picture);
                this.addChild(sp);
                //
                _pictureList.push(sp);
                
                sp.y = stage.stageHeight / 2;
            }
        }
        
        private function getPositionX():void {
            _xList = [];
            for (var i:int = 0; i < PICTURE_NUMBER * 2 - 1; i++ ) {
                //trace(i);
                if (i < PICTURE_NUMBER - 1) {
                    _xList.push(stage.stageWidth / 2 - 100 - 50 * (PICTURE_NUMBER - 2 - i));
                }else if(i == PICTURE_NUMBER - 1) {
                    _xList.push(stage.stageWidth / 2);
                }else {
                    _xList.push(stage.stageWidth / 2 + 100 + 50 * (i - PICTURE_NUMBER) );
                }
            }
            //trace(_xList);
        }
        
        private function putPictures():void {
            var myNum:int = PICTURE_NUMBER - FIRST_CENTER;
            for (var i:int = 0; i < PICTURE_NUMBER; i++ ) {
                _pictureList[i].x = _xList[myNum + i];
                
                if (i < FIRST_CENTER - 1) {
                    _pictureList[i].rotationY = -90;
                }else if(i == FIRST_CENTER - 1) {
                    _pictureList[i].scaleX = 1.5;
                    _pictureList[i].scaleY = 1.5;
                }else {
                    _pictureList[i].rotationY = 90;
                }
            }
        }
        
        private var _clicked:Boolean;
        private function onClick(event:MouseEvent):void {
            
            if (1 <= _actualCenter && _actualCenter <= PICTURE_NUMBER && !_clicked) {
                
                _clicked = true;
                
                if (mouseX < stage.stageWidth / 2) {
                    if (_actualCenter == 1) {
                        _actualCenter = 1;
                    }else {
                        _actualCenter--;
                    }
                }else if (stage.stageWidth / 2 < mouseX) {
                    if (_actualCenter == PICTURE_NUMBER) {
                        _actualCenter = PICTURE_NUMBER;
                    }else {
                        _actualCenter++;
                    }
                }
                
                var myNum:int = PICTURE_NUMBER - _actualCenter;
                for (var i:int = 0; i < PICTURE_NUMBER; i++ ) {
                    if ((i < _actualCenter - 1)) {
                        BetweenAS3.tween(_pictureList[i], { x:_xList[myNum + i], scaleX:1, scaleY:1, rotationY:-90 }, null, 1 / 4, Cubic.easeOut ).play();
                    }else if (i == _actualCenter - 1) {
                        var myTween:ITween = BetweenAS3.tween(_pictureList[i], { x:_xList[myNum + i], scaleX:1.5, scaleY:1.5, rotationY:0 }, null, 1 / 4, Cubic.easeOut );
                        myTween.addEventListener(TweenEvent.COMPLETE, onComplete);
                        myTween.play();
                    }else {
                        BetweenAS3.tween(_pictureList[i], { x:_xList[myNum + i], scaleX:1, scaleY:1, rotationY:90 }, null, 1 / 4, Cubic.easeOut ).play();
                    }
                }
            }
        }
        
        private function onComplete(event:TweenEvent):void {
            //trace("hoge")
            _clicked = false;
        }
        
    }
    
}