/**
 * Copyright tricksy ( http://wonderfl.net/user/tricksy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/imKH8
 */

// forked from ProjectNya's 星と空間  [color]
// forked from ProjectNya's 星と空間 
////////////////////////////////////////////////////////////////////////////////
// 星と空間  [Papervision3D]
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var particles:ParticleField;
        private var angle:Number = 90;
        private static var radius:uint = 1000;
        private var panel:Sprite;

        public function Main() {
            //Wonderfl.capture_delay(8);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            scene = new Scene3D();
            camera =new Camera3D();
            camera.z = -1000;
            camera.focus = 500;
            camera.zoom = 1;
            camera.target = DisplayObject3D.ZERO;
            viewport = new Viewport3D(0, 0, true, false);
            addChild(viewport);
            renderer = new BasicRenderEngine();
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
            for (var n:uint = 0; n < 360; n++) {
                var color:ColorHSV = new ColorHSV(n, 0.4);
                var pm:ParticleMaterial = new ParticleMaterial(color.value, 0.8, 1, 1);
                var particles:ParticleField = new ParticleField(pm, 10, 8, 5000, 5000, 5000);
                scene.addChild(particles);
            }
            panel = new Sprite();
            addChild(panel);
            panel.x = 232;
            panel.y = 445;
        }
        private function render(evt:Event):void {
            angle ++;
            var cp:Number = Math.sin(angle*Math.PI/180)*radius*0.4+ radius*0.6;
            camera.x = cp*Math.sin(angle*Math.PI/180);
            camera.y = cp*Math.sin(angle*Math.PI/180);
            camera.z = cp*Math.cos(angle*Math.PI/180);
            renderer.renderScene(scene, camera, viewport);
        }
    }
}