/**
 * Copyright oreore ( http://wonderfl.net/user/oreore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ilsS
 */

// forked from oreore's 円運動
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.utils.*;
	
	/**
	 * ...
	 * @author oreore
	 */
	public class Main extends Sprite 
	{
		private var _arrow:Arrow;
		private var rotate:Number = 0;
		private var _stageH:Number;
		private var _stageW:Number;
		private var _stageH2:Number;
		private var _stageW2:Number;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			_stageH = stage.stageHeight;
			_stageW = stage.stageWidth;
			_stageH2 = stage.stageHeight *.5;
			_stageW2 = stage.stageWidth *.5;
			
			//矢印を作成
			_arrow = new Arrow();
			_arrow.x = stage.stageWidth*.5;
			_arrow.y = stage.stageHeight * .5;
			addChild(_arrow);
			
			this.addEventListener(Event.ENTER_FRAME, onLoop);
			
		}
		
		
		private function onLoop(e:Event):void 
		{
			
			
			rotate += 2;
			var rad:Number = rotate*Math.PI/180;
			
			var sin:Number = Math.sin(rad);
			var cos:Number = Math.cos(rad);
			
			_arrow.x = sin * 200 + _stageW2;
			_arrow.y = cos * 200 + _stageH2;
			
			var dx:Number = mouseX - _arrow.x;
			var dy:Number = mouseY - _arrow.y;
			_arrow.rotation = Math.atan2(dy,dx) * 180 / Math.PI;
			
		}
		
		
		
	}
	
}

import flash.display.Sprite;

class Arrow extends Sprite
{
	
	public function Arrow() 
	{
		init();
	}
	
	private function init():void
	{
		graphics.lineStyle(1, 0, 1)
		graphics.moveTo(-50, -25);
		graphics.beginFill(0xff6633);
		graphics.lineTo(0, -25);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, 0);
		graphics.lineTo(0, 50);
		graphics.lineTo(0, 25);
		graphics.lineTo(-50,25);
		graphics.lineTo(-50,-25 );
		graphics.endFill();
	}	
}
