/**
 * Copyright Abarrow ( http://wonderfl.net/user/Abarrow )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ilLn
 */

// forked from Abarrow's Noise Encode
package {
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;


    public class PixelBitmap extends Sprite {
        
        //private const _url:String = "http://farm4.static.flickr.com/3216/2751164680_bc66bfbda9.jpg"; 
        private const _url:String = "http://fast.mediamatic.nl/f/rqqp/image/3262-465-465-size.jpg";          
        private var bit:BitmapData;           
      
        public function PixelBitmap()
        {

            configureAssets();
        }

        private function configureAssets():void{
            var _loader:Loader=new Loader();            
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);

            var request:URLRequest = new URLRequest(_url);

            _loader.load(request, new LoaderContext(true));
            _loader.name = 'test';                   
        }

        private function completeHandler(event:Event):void {          
             var source:Bitmap = Bitmap(LoaderInfo(event.target).content);
             bit=new BitmapData(source.width, source.height, true, 0x00000000);
             bit.draw(source);
             var hold:Bitmap=new Bitmap(bit);
             addChild(hold);
             //procecess the image
             addEventListener(Event.ENTER_FRAME, enter); 
        }
        private function enter(event:Event):void{
             for(var ex:int=0;ex<bit.width;ex++){
                for(var ey:int=0;ey<bit.width;ey++){
                    var pixelValue:uint=bit.getPixel(ex, ey);
                    var bri:uint=((pixelValue>>16&0xff)+(pixelValue>>8&0xff)+(pixelValue&0xff))/3;
                    if(ey>0){
                        var pixelValu:uint=bit.getPixel(ex, ey-1);
                        var brie:uint=((pixelValu>>16&0xff)+(pixelValu>>8&0xff)+(pixelValu&0xff))/3;
                        if(bri>brie&&Math.random()<0.5){
                            bit.setPixel(ex,ey,pixelValu);
                            bit.setPixel(ex,ey-1,pixelValue);
                        }else if(Math.random()<0.05){
                            var nex:int=ex+Math.floor(Math.random()*7)-3;
                            if(nex>0&&nex<bit.width){
                                bit.setPixel(ex, ey, bit.getPixel(nex,ey));
                                bit.setPixel(nex, ey, pixelValue);
                            }
                        }
                    }
                }
             }
         }
         public function parseColor(r:uint, g:uint, b:uint, a:int=-1):uint{
            if(a==-1){
                return parseInt("0x"+hexChannel(r)+hexChannel(g)+hexChannel(b));
            }else{
                return parseInt("0x"+hexChannel(a)+hexChannel(r)+hexChannel(g)+hexChannel(b));
            }
         }
         public function hexChannel(cha:uint):String{
            if(cha>255){
                return 'ff';
            }else{
                var str:String=cha.toString(16);
                if(str.length==1){
                    return '0'+str;
                }else{
                    return str;
                }
            }
         }
    }
}
