/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ikgN
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import idv.cjcat.stardust.common.actions.Age;
	import idv.cjcat.stardust.common.actions.DeathLife;
	import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;
	import idv.cjcat.stardust.common.clocks.ImpulseClock;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.common.emitters.Emitter;
	import idv.cjcat.stardust.common.initializers.Life;
	import idv.cjcat.stardust.common.math.UniformRandom;
	import idv.cjcat.stardust.common.particles.Particle;
	import idv.cjcat.stardust.twoD.emitters.Emitter2D;
	
	/**
	 * ★＝生きているパーティクル
	 * ☆＝死んだパーティクル
	 * @author paq89
	 */
	[SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 60)]
	public class Main extends Sprite 
	{
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			var textField:TextField = new TextField();
			textField.width = 465;
			textField.height = 465;
			textField.wordWrap = true;
			addChild(textField);
			
			var emitter:Emitter2D = new Emitter2D(new SteadyClock(1));
			emitter.addInitializer(new Life(new UniformRandom(50, 50)));
			emitter.addInitializer(new FunctionInitializer(
				function(particle:Particle):void{
					textField.appendText("★");
					particle.target = textField.length - 1;
					
				}
			));
			var trigger:DeathTrigger = new DeathTrigger();
			trigger.addAction(new FunctionAction(
				function(emitter:Emitter, particle:Particle, time:Number):void
				{
					var txt:String = textField.text;
					var n:Number = particle.target;
					textField.text = txt.substr(0, n) + "☆" + txt.substr(n+1, txt.length);
				}
			));
			emitter.addAction(trigger);
			emitter.addAction(new Age());
			emitter.addAction(new DeathLife());
			addEventListener(Event.ENTER_FRAME, emitter.step);
		}
		
	}
	
}
import idv.cjcat.stardust.common.actions.Action;
import idv.cjcat.stardust.common.emitters.Emitter;
import idv.cjcat.stardust.common.initializers.Initializer;
import idv.cjcat.stardust.common.particles.Particle;

class FunctionAction extends Action 
{
	private var func:Function;
	
	public function FunctionAction(func:Function)
	{
		this.func = func;
	}
	
	override public function update(emitter:Emitter, particle:Particle, time:Number):void
	{
		func(emitter, particle, time);
	}
}

class FunctionInitializer extends Initializer
{
	private var func:Function;
	
	public function FunctionInitializer(func:Function)
	{
		this.func = func;
	}
	
	override public function initialize(particle:Particle):void {
		func(particle);
	}
}