/**
 * Copyright russ ( http://wonderfl.net/user/russ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ik74
 */

package {
import flash.display.Sprite;
import flash.events.MouseEvent;

public class SpriteMouseOver extends Sprite {
    public function SpriteMouseOver():void {
        var s1:Sprite = new Sprite();
        s1.name = "s1";
        s1.graphics.lineStyle(1, 0x000000);
        s1.graphics.beginFill(0x00FFFF);
        s1.graphics.drawCircle(50, 50, 20);
        s1.graphics.drawCircle(20, 20, 10);
        stage.addChild(s1);
        s1.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover);
        s1.addEventListener(MouseEvent.ROLL_OUT, onMouseRollout);

        var s2:Sprite = new Sprite();
        s2.name = "s2";
        s2.graphics.lineStyle(1, 0x000000);
        s2.graphics.beginFill(0xFF0000);
        s2.graphics.drawEllipse(100, 100, 25, 10);
        s2.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover);
        s2.addEventListener(MouseEvent.ROLL_OUT, onMouseRollout);
        stage.addChild(s2);
        trace("s1 width is " + s1.width);
        trace("s2 width is " + s2.width);
    }

    private function onMouseRollout(e:MouseEvent):void {
        e.target.alpha = 1;
    }

    private function onMouseRollover(e:MouseEvent):void {
        trace("Rolled over target: " + e.target.name + " (currentTarget = " + e.currentTarget.name + ")");
        e.target.alpha = 0.5;
    }
}
}
