/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ijxf
 */

package{
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.geom.Matrix;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.filters.GlowFilter;
	public class BitmapCollision1 extends Sprite{
		private var bmpd1:BitmapData;
		private var bmp1:Bitmap;
		private var bmpd2:BitmapData;
		private var bmp2:Bitmap;
		
		public function BitmapCollision1(){
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			var star:Star = new Star(50);
			
			bmpd1 = new BitmapData(100, 100, true, 0);
			bmpd1.draw(star, new Matrix(1, 0, 0, 1, 50, 50));
			bmp1 = new Bitmap(bmpd1);
			bmp1.x = 200;
			bmp1.y = 200;
			addChild(bmp1);
			
			bmpd2 = new BitmapData(100, 100, true, 0);
			bmpd2.draw(star, new Matrix(1, 0, 0, 1, 50, 50));
			bmp2 = new Bitmap(bmpd2);
			addChild(bmp2);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoving);
		}
		
		private function onMouseMoving(e:MouseEvent):void{
			bmp2.x = mouseX - 50;
			bmp2.y = mouseY - 50;
			
			if(bmpd1.hitTest(new Point(bmp1.x, bmp1.y), 255, bmpd2, new Point(bmp2.x, bmp2.y), 255))
			{
				bmp1.filters = [new GlowFilter()];
				bmp2.filters = [new GlowFilter()];
			}
			else
			{
				bmp1.filters = [];
				bmp2.filters = [];
			}
		}
	}
}
		
import flash.display.Sprite;
class Star extends Sprite{
	public function Star(radius:Number, color:uint = 0xFFFFFF):void{
		graphics.lineStyle(0);
		graphics.moveTo(radius, 0);
		graphics.beginFill(color);
		for(var i:int = 1; i < 11; i++){
			var radius2:Number = radius;
			if(i % 2 > 0){
				radius2 = radius / 2;
			}
			var angle:Number = Math.PI * 2 / 10 * i;
			graphics.lineTo(Math.cos(angle) * radius2, Math.sin(angle) * radius2);
		}
	}
} 
