/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ijx9
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    public class Spring extends Sprite {
        private var spring:Number = .1;
        private var friction:Number = .85;
        private var springLength:Number = 100;
        private var balls:Array;
        private var numBalls:Number = 5;
        private var currentBall:Ball;
        
        private var txtTest:TextField;     
                
        public function Spring() {
            init();
        }
        
        private function init():void {
            txtTest = new TextField();
            txtTest.multiline = true;
            txtTest.autoSize = TextFieldAutoSize.LEFT;
            addChild(txtTest);
            
            balls = [];
            
            for (var i:int = 0; i < numBalls; i++) {
                var ball:Ball = new Ball(20);
                ball.name = "ball"+i;
                ball.x = Math.random() * stage.stageWidth;
                ball.y = Math.random() * stage.stageHeight;
                addChild(ball);
                
                ball.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
                
                balls.push(ball);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var left:Number = 0;
            var right:Number = stage.stageWidth;
            var top:Number = 0;
            var bottom:Number = stage.stageHeight;
            
            graphics.clear();
            graphics.lineStyle(1);
            
           for (var i:int = 0; i < balls.length; i++) {
                var ball:Ball = balls[i] as Ball;
                
                //spring the ball
                for (var k:int = 0; k < numBalls; k++) {
                    if (i != k) { // check if the ball isnt springing to itself
                        if (!ball.isDragging) {
                            springTo(ball, balls[k]);
                        }
                    }
                }
                
                //boundaries
                if (ball.x + ball.radius > right) {
                    ball.x = right - ball.radius;
                } else if (ball.x - ball.radius < left) {
                    ball.x = left + ball.radius;
                }
                
                if (ball.y + ball.radius > bottom) {
                    ball.y = bottom - ball.radius;
                } else if (ball.y - ball.radius < top) {
                    ball.y = top + ball.radius;
                }
                
                
                //draw the guide lines
                graphics.moveTo(ball.x, ball.y);
                
                if (i != balls.length - 1) {
                    graphics.lineTo(balls[i+1].x, balls[i+1].y);
                } else {
                    graphics.lineTo(balls[0].x, balls[0].y);
                }
 
            }
        }
        
        private function springTo(ballA:Ball, ballB:Ball):void {
            var dx:Number = ballB.x - ballA.x;
            var dy:Number = ballB.y - ballA.y;
            
            var angle:Number = Math.atan2(dy,dx);
            var targetX:Number = ballB.x - Math.cos(angle) * springLength;
            var targetY:Number = ballB.y - Math.sin(angle) * springLength;
            ballA.vx += (targetX - ballA.x) * spring;
            ballA.vy += (targetY - ballA.y) * spring;
            ballA.vx *= friction;
            ballA.vy *= friction;
            ballA.x += ballA.vx;
            ballA.y += ballA.vy;
        }

        
        private function onPress(e:MouseEvent):void {
            var ball:Ball = e.currentTarget as Ball;
            ball.isDragging = true;
            ball.startDrag();
            
            currentBall = ball;
            
            stage.addEventListener(MouseEvent.MOUSE_UP, onRelease);
        }
        
        private function onRelease(e:MouseEvent):void {
            currentBall.stopDrag();
            currentBall.isDragging = false;
        }



    }
}




//ball class
import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;   
    public var isDragging:Boolean = false; 
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}