/**
 * Copyright takashi08 ( http://wonderfl.net/user/takashi08 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ijjB
 */

// forked from siny's papervision3D:003CUBEのある面にクリック判定
//赤い面をクリックすると赤い面が正面にくる
//もう一度クリックすると元に戻る
//元はマウスの座標に応じて動く
package {
    import flash.events.*;
    import flash.display.Sprite;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.events.*;
    
[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]    
    public class FlashTest extends Sprite {
        
            public var scene:Scene3D; //シーンを定義するクラス
        public var camera:Camera3D; //カメラを定義するクラス
        public var viewport:Viewport3D; //ビューポートを定義するクラス
        public var renderer:BasicRenderEngine; //レンダラーを定義するクラス
        
        public var material_fr:ColorMaterial; //マテリアルを定義するクラス
        public var material_bk:ColorMaterial; //マテリアルを定義するクラス
        public var material_rt:ColorMaterial; //マテリアルを定義するクラス
        public var material_lt:ColorMaterial; //マテリアルを定義するクラス
        public var material_top:ColorMaterial; //マテリアルを定義するクラス
        public var material_btm:ColorMaterial; //マテリアルを定義するクラス
        
        public var materials:MaterialsList;
        
        public var cube:Cube; //Cubeを定義
        
        public var do3d:DisplayObject3D = new DisplayObject3D();
        
        public var rY:Number;
        public var rX:Number;
            
        public function FlashTest() {
            scene = new Scene3D(); //シーンを定義するクラス
            camera = new Camera3D(); //カメラを定義するクラス
            camera.fov = 50; //カメラの視野角を設定
            viewport = new Viewport3D(465, 465, false, true); //ビューポートを定義するクラス
            addChild(viewport); //ビューポートをステージの表示リストに追加
            //viewport.opaqueBackground = 0x000000; //ビューポートの背景色を指定
            renderer = new BasicRenderEngine(); //レンダラーを定義するクラス
            material_fr = new ColorMaterial( 0xaaaaaa ); //マテリアルを定義するクラス
            material_bk = new ColorMaterial( 0xff0000 );
            material_rt = new ColorMaterial( 0xcccccc );
            material_lt = new ColorMaterial( 0xdddddd );
            material_top = new ColorMaterial( 0xeeeeee );
            material_btm = new ColorMaterial( 0xffffff );
            material_fr.interactive = true;
            material_bk.interactive = true;
            material_rt.interactive = true;
            material_lt.interactive = true;
            material_top.interactive = true;
            material_btm.interactive = true;
            materials = new MaterialsList //複数のマテリアルをまとめて管理するクラス
            ({
            front    : material_fr,    //正面のマテリアルを指定
            back    : material_bk,    //背面のマテリアルを指定
            right    : material_rt,    //右面のマテリアルを指定
            left    : material_lt,    //左面のマテリアルを指定
            top        : material_top,    //上面のマテリアルを指定
            bottom    : material_btm    // 底面のマテリアルを指定
            });
            cube = new Cube( materials, 300, 300, 300 ); //Cubeを定義
            do3d.addChild(cube);
            scene.addChild(do3d);
            addEventListener(Event.ENTER_FRAME, onEnterFrame, false, 0, true);
            cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick);
            viewport.buttonMode = true;
        }
        
       public function onClick(event:InteractiveScene3DEvent):void {
            
            if(event.renderHitData.material == material_fr){
                //do3d.z -= 100;
            } else if(event.renderHitData.material == material_bk){
                removeEventListener(Event.ENTER_FRAME, onEnterFrame);
                cube.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick);
                addEventListener(Event.ENTER_FRAME, onEnterFramebk, false, 0, true);
                cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick2);
            } else if(event.renderHitData.material == material_rt){
                //do3d.x += 100;
            } else if(event.renderHitData.material == material_lt){
                //do3d.x -= 100;
            } else if(event.renderHitData.material == material_top){
               // do3d.y += 100;
            } else if(event.renderHitData.material == material_btm){
               // do3d.y -= 100;
            } 
        }
        
        public function onClick2(event:InteractiveScene3DEvent):void {
            removeEventListener(Event.ENTER_FRAME, onEnterFramebk);
            cube.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick2);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame, false, 0, true);
            cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick);
        }
        
        public function onEnterFramebk(event:Event):void {
            rY = 0;
            rX = 0;
            do3d.rotationY += (rY - do3d.rotationY)*0.1;
            do3d.rotationX += (rX - do3d.rotationX)*0.1;
            renderer.renderScene(scene, camera, viewport); //レンダリング処理
        }
        
        public function onEnterFrame(event:Event):void {
            rY = mouseX/stage.stageWidth*360;
            rX = -mouseY/stage.stageHeight*360;
            do3d.rotationY += (rY - do3d.rotationY)*0.01;
            do3d.rotationX += (rX - do3d.rotationX)*0.01;
            renderer.renderScene(scene, camera, viewport); //レンダリング処理
        }
        
    }
}