/**
 * Copyright dory ( http://wonderfl.net/user/dory )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ijXP
 */

// forked from paq's TweetToSpeech
package
{
    import flash.events.MouseEvent;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import com.adobe.serialization.json.JSON;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    /**
     *
     * @author dory
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class TweetToSpeech extends Sprite
    {
        private var _queue:StringQueue;
        private var _speaker:Speaker;
        private var _request:URLRequest;
        private var _loader:URLLoader;
        private var _tweet:TextField;
        private var _startButton:SimpleButton;
        
        public function TweetToSpeech()
        {
            WonderflTemplate.init(this, init);
        }
        
        private function init():void
        {
            // 変数の初期化
            _queue = new StringQueue();
            _speaker = new Speaker(_queue);
            _request = new URLRequest();
            _loader = new URLLoader();
            
            _createUI();
            
            _loader.addEventListener(Event.COMPLETE, _onLoadComplete);
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
                
        private function _createUI():void
        {
            _createBG();
            
            _startButton = new SimpleButton();
            _startButton.text = "START";
            addChild( _startButton );
            _startButton.addEventListener( MouseEvent.CLICK, _btnClick );
            
            _startButton.x = stage.stageWidth / 2 - _startButton.width / 2;
            _startButton.y = stage.stageHeight / 2;
            
            var tf:TextFormat = new TextFormat();
            tf.color = 0xffffff;
            
            _tweet = new TextField();
            _tweet.defaultTextFormat = tf;
            _tweet.wordWrap = true;
            _tweet.x = stage.stageWidth / 2 - 200;
            _tweet.y = stage.stageHeight / 2 - 100;
            _tweet.width = 400;
            _tweet.height = 80;
            addChild(_tweet);
        }
        
        private function _createBG():void {
            var bgAnime:BGAnime = new BGAnime();
            addChild( bgAnime );
        }

        private function _btnClick( event:MouseEvent ):void {
            trace("search");
            _queue.clear();
            _search();
            _tweet.text = "";
        }
        
        private function _search():void
        {
            _request.url = "http://search.twitter.com/search.json?q=" 
                + encodeURIComponent("好き") + "+OR+" + encodeURIComponent("愛") + "+OR+" + encodeURIComponent("幸せ");
            _loader.load(_request);
        }
        
        private function _onEnterFrame(event:Event):void
        {
            _speaker.step();
            if (_speaker.job && _tweet.text != _speaker.job)
            {
                _tweet.text = _speaker.job;
            }
        }
        
        private function _onLoadComplete(event:Event):void
        {
            var json:Object = JSON.decode(event.target.data);
            for each (var tweet:Object in json.results)
            {
                var str:String = tweet.text || "";
                str = str.replace( /https?:\/\/[-_.!~*'()\w;\/?:@&=+$,%#]+/gi, "")
                         .replace(/@[\w]+\s/gi, "")
                         .replace(/RT\s.+$/gi, "")
                         .replace(/^\s+/i, "")
                         .replace("\n", "")
                         .substr(0, 100);
                if (str != "")
                {
                    trace(str)
                    _queue.push(str)
                }
            }
        }
    }
    
}
import flash.filters.BlurFilter;

//----------------------------------------------------------------------------

import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Stage;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.net.URLRequest;
import flash.net.URLVariables;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;

//----------------------------------------------------------------------------
internal class BGAnime extends Sprite
{
    private static const HEART_NUM:int = 40;
    private var heartList:Array = new Array();
    public function BGAnime():void {
        addEventListener( Event.ADDED_TO_STAGE, init );
    }
    
    private function init( event:Event ):void {
        graphics.beginFill( 0x2f0f00 );
        graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
        graphics.endFill();
        for ( var i:int = 0; i < HEART_NUM; i++ ) {
            var heart:Heart = new Heart();
            heart.x = Math.random() * stage.stageWidth;
            heart.y = Math.random() * stage.stageHeight;
            addChild( heart );
            heartList.push( heart );
        }

        addEventListener( Event.ENTER_FRAME, anime );
    }
    
    private function anime( event:Event ):void {
        for ( var i:int = 0; i < HEART_NUM; i++ ) {
            var heart:Heart = heartList[ i ];
            heart.y -= heart.speed;
            if ( heart.y < -50 ) {
                heart.y = 500; 
            }
        }
    }
}

/**
 * Heart Class
 * @author dory
 */
class Heart extends Sprite
{
    private const COL_RANDOM:Number = Math.random() * 100 + 1;
    
    private var _speed:Number;
    public function get speed():Number {
        return _speed;
    }

    private var p:Array = [
        {x:11, y:-16, anchorX:16, anchorY:-6},
        {x:20, y:6, anchorX:0, anchorY:16},
        {x:-20, y:6, anchorX:-16, anchorY:-6},
        {x:-11, y:-16, anchorX:0, anchorY:0},
    ];
    
    public function Heart() 
    {
        _speed = Math.random() + 0.5;
        draw();
    }
    
    private function draw():void {
        fillDraw();
        lineDraw();

        var blur:BlurFilter = new BlurFilter(8, 8);
        filters = [blur];
    }

    private function fillDraw():void {
        var scaleRandom:Number = Math.random() + 0.5;
        
        var col1:uint = 0xcc6666 + COL_RANDOM;
        var col2:uint = 0x663333 + COL_RANDOM;
        
        graphics.beginGradientFill("radial", [col1, col2], [1, 1], [0, 127]);
        graphics.moveTo(0, 0);
        for (var i:int = 0; i < p.length; i++ ) {
            graphics.curveTo(p[i].x * scaleRandom, p[i].y * scaleRandom, p[i].anchorX * scaleRandom, p[i].anchorY * scaleRandom);
        }
        graphics.endFill();
    }

    private function lineDraw():void {
        var posRandomX:Number = Math.random() * 20 - 10;
        var posRandomY:Number = Math.random() * 30 - 15;
        var scaleRandom:Number = Math.random() * 1.5 + 1.0;
        
        var col:uint = 0xcc6666 + COL_RANDOM;
        
        graphics.lineStyle(1, col);
        graphics.moveTo(posRandomX, posRandomY);
        for (var i:int = 0; i < p.length; i++ ) {
            graphics.curveTo(p[i].x * scaleRandom + posRandomX, p[i].y * scaleRandom + posRandomY,             p[i].anchorX * scaleRandom + posRandomX,                 p[i].anchorY * scaleRandom + posRandomY);
        }
        graphics.endFill();
    }
}


internal class SimpleButton extends Sprite
{
    private var textField:TextField = new TextField();
    public function set text( value:String ):void {
        textField.text = value;
    }
    public function get text():String {
        return textField.text;
    }
    
    public function SimpleButton() 
    {
        textField.autoSize = TextFieldAutoSize.CENTER;
        addChild( textField );
        graphics.beginFill( 0xff8080, 0.6 );
        graphics.drawRoundRect( 0, 0, 100, 20, 10, 10 );
        graphics.endFill();
    }
    
}

internal class StringQueue extends Object
{
    private var _queue:Vector.<String>;
    public function StringQueue() { _queue = new Vector.<String>(); }
    public function checkPoll():Boolean { return _queue.length > 0; }
    public function isEmpty():Boolean { return _queue.length == 0; }
    public function poll():String { return _queue.shift(); }
    public function push(str:String):void { _queue.push(str) }
    public function clear():void { _queue.length = 0; }
}

//----------------------------------------------------------------------------

internal class Speaker extends Object
{
    private var _isPlaying:Boolean;
    public function get isPlaying():Boolean { return _isPlaying; }
    
    private var _job:String;
    public function get job():String { return _job; }
    
    private var _queue:StringQueue;
    public function get queue():StringQueue { return _queue; }
    
    private var _request:URLRequest;
    private var _variables:URLVariables;
    
    private var _sound:Sound;
    private var _soundChannel:SoundChannel;
    
    public function Speaker(queue:StringQueue)
    {
        _queue = queue;
        _request = new URLRequest("http://wonder-tools.appspot.com/api/tts");
        _variables = new URLVariables();
        _request.data = _variables;
    }
    
    public function step():void
    {
        if (!_isPlaying && _queue.checkPoll())
        {
            _job = _variables.q = _queue.poll();
            _variables.tl = "ja";
            _isPlaying = true;
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, _onSoundLoadComplete);
            _sound.load(_request);
        }
    }
    
    private function _onSoundLoadComplete(event:Event):void
    {
        _soundChannel = _sound.play();
        _soundChannel.addEventListener(Event.SOUND_COMPLETE, _onSoundComplete);
    }
    
    private function _onSoundComplete(event:Event):void
    {
        _soundChannel.removeEventListener(Event.SOUND_COMPLETE, _onSoundComplete);
        _sound.removeEventListener(Event.SOUND_COMPLETE, _onSoundComplete);
        
        _isPlaying = false;
        
        _soundChannel = null;
        _sound = null;
    }
}

//----------------------------------------------------------------------------

internal class WonderflTemplate extends Object
{
    private static var _stage:Stage;
    private static var _target:DisplayObjectContainer;
    private static var _handler:Function;
    private static var _frameRate:int;
    private static var _background:Shape;
    private static var _backgroundColor:uint;
    
    public static function init(target:DisplayObjectContainer, handler:Function, backgroundColor:uint=0xFFFFFF, frameRate:int = 60):void
    {
        _target = target;
        _handler = handler;
        _frameRate = frameRate;
        _backgroundColor = backgroundColor;
        
        Wonderfl.capture_delay(10);
        
        _target.addEventListener(Event.ADDED_TO_STAGE, _onAddToStage);
    }
    
    private static function _onAddToStage(event:Event):void
    {
        _target.removeEventListener(Event.ADDED_TO_STAGE, _onAddToStage);
        
        // Stage
        _stage = _target.stage
        _stage.align = StageAlign.TOP_LEFT;
        _stage.scaleMode = StageScaleMode.NO_SCALE;
        _stage.frameRate = _frameRate;
        _stage.addEventListener(Event.RESIZE, _onResize);
        
        // Background
        _background = new Shape();
        _target.addChildAt(_background, 0);
        _onResize();
        
        _handler();
    }
    
    private static function _onResize(event:Event = null):void
    {
        // Background drawing
        var g:Graphics = _background.graphics;
        g.clear();
        g.beginFill(_backgroundColor);
        g.drawRect(0, 0, _stage.stageWidth, _stage.stageHeight);
    }
}