/**
 * Copyright fujiopera ( http://wonderfl.net/user/fujiopera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iiyO
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    
    /**
     * ...
     * @author inu
     * ListView
     * スマートフォンによくあるニョーンって操作できるやつです。
     * コーディングはテキトウ.
     * ドラッグ操作で推移。
     * flashDevelopとwondefl連携テスト　　2011.11.28 fujiopera
     */
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            var list:ListView = new ListView(465, 440, 0xffffff);
            list.y = 25;
            
            var itemNum:int = Math.random() * 50 + 1;
            for (var i:int = 0; i < itemNum;i++ ){
                list.add(new Item(465,Math.random()*100+20,"item "+i));
            }
            addChild(list);
            
            var tf:TextField = new TextField();
            tf.text = " ListView";
            tf.background = true;
            tf.backgroundColor = 0x888888;
            tf.width = 465;
            tf.height = 25;
            addChild(tf);
        }
        
    }
    
}

import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.events.*;

class ListView extends Sprite{
    
    public var listSp:Sprite;
    public var barSp:Sprite;
    
    public var itemA:Vector.<Sprite>;
    
    private var mouseY1:Number=0;
    private var mouseY2:Number=0;
    public var itemHeight:Number=0;
    
    private var downStageY:Number=-1;
    private var downListY:Number = -1;
    
    public var moveY:Number = 0;
    public var h:Number=0;
    
    public function ListView(w:int, h:int,backgroundColor:uint=0xFFFFFF) 
    {
        this.h = h;
        graphics.beginFill(backgroundColor);
        graphics.drawRect(0, 0, w, h);
        
        listSp = new Sprite();
        addChild(listSp);
        scrollRect = new Rectangle(0, 0, w, h);
        listSp.addEventListener(MouseEvent.MOUSE_DOWN, down);
        listSp.addEventListener(MouseEvent.MOUSE_UP, up);
        addEventListener(MouseEvent.ROLL_OUT, out);
        addEventListener(MouseEvent.MOUSE_MOVE, move);
        
        barSp = new Sprite();
        barSp.alpha = 0.5;
        barSp.x = w - 7;
        barSet();
        barSp.visible = false;
        addChild(barSp);
        
        itemA = new Vector.<Sprite>();
    }
    
    private function move(e:MouseEvent):void {
        if (!e.buttonDown || downStageY == -1) return;
        if (itemHeight > h)barSp.visible = true;
        listSp.y = downListY + (e.stageY - downStageY);
        mouseY2 = mouseY1;
        mouseY1 = listSp.y;
    }
    
    private function down(e:MouseEvent):void {
        mouseY2 = listSp.y;
        mouseY1 = listSp.y;
        downStageY = e.stageY;
        downListY = listSp.y;
        removeEventListener(Event.ENTER_FRAME, ent);
        if (itemHeight > h){
            barSp.addEventListener(Event.ENTER_FRAME, barEnt)
        }
    }
    
    private function out(e:MouseEvent):void {
        if (!e.buttonDown) return;
        addEventListener(Event.ENTER_FRAME, ent);
        moveY = 0;
        downStageY = -1;
        downListY = -1;
    }
    
    private function up(e:MouseEvent):void {
        if (downStageY == -1) return;
        downStageY = -1;
        downListY = -1;
        addEventListener(Event.ENTER_FRAME, ent);
        moveY = (mouseY1 - mouseY2) * (int(Math.abs((mouseY1 - mouseY2) / 20)) + 1);
    }
    
    private function ent(e:Event):void {
        moveY *= 0.95;
        if (listSp.y > 0 || listSp.y < -itemHeight + h) moveY *= 0.5;
        if (Math.abs(moveY)<0.1 && listSp.y > 0) { listSp.y -= listSp.y / 4;}
        if (Math.abs(moveY)<0.1 && listSp.y < -itemHeight + Math.min(h,itemHeight)) { listSp.y += (Math.min(h,itemHeight) - (listSp.y + itemHeight)) / 4; }
        if (Math.abs(moveY) < 50) listSp.y += moveY;
        else listSp.y += moveY / Math.abs(moveY) * 50;
        if (Math.abs(moveY) < 0.1 && listSp.y <= 0 && (listSp.y >= -itemHeight + h || (h > itemHeight && listSp.y == 0))) {
            removeEventListener(Event.ENTER_FRAME, ent);
            barSp.visible = false;
            barSp.removeEventListener(Event.ENTER_FRAME,barEnt)
        }
    }
    
    public function add(sprite:Sprite):void {
        itemA.push(sprite);
        sprite.y = itemHeight;
        itemHeight += sprite.height;
        listSp.addChild(sprite);
        barSet() ;
    }
    
    private var barH:Number;
    
    private function barEnt(e:Event):void {
        barSp.y = -listSp.y / (itemHeight - h) * (h - barH);
    }
    
    private function barSet():void {
        barSp.graphics.clear();
        barSp.graphics.lineStyle(0,0xFFFFFF);
        barSp.graphics.beginFill(0xAAAAAA);
        barH = h-(itemHeight-h)*0.5;
        if (barH < 50) barH = 50;
        if (barH > h) barH = h;
        barSp.graphics.drawRect(0, 0, 4, barH);
    }
    
}

class Item extends Sprite {
    public function Item(w:int,h:int,text:String) {
        graphics.lineStyle(1, 0x000000);
        graphics.beginFill(Math.random()*0xffffff,0.5);
        graphics.drawRect( -1, 0, w+2, h);
        var tf:TextField = new TextField();
        tf.autoSize="left";
        tf.text = text;
        addChild(tf);
    }
}