/**
 * Copyright mapache ( http://wonderfl.net/user/mapache )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ii49
 */

// forked from mousepancyo's モザイクエフェクト
/*

ローカルから画像データを読み込んでモザイクエフェクト
をかけながら画像をただ表示するだけという、
ある意味自分用のメモ。。。

画面をクリックで画像を読み込むダイアログが出ます。
（再読込時も画面をクリック）

*/

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.events.IOErrorEvent;
    import flash.net.FileReference;
    import flash.net.FileFilter;
    import flash.utils.Timer;
    import flash.geom.Matrix
    
    import flash.events.TimerEvent;

    [SWF(width=465, height=465, backgroundColor=0, frameRate=24)]

    public class Main extends Sprite {
        private static const W:Number = 465
        private static const H:Number = 465
        private static const MOSAIC_RANGE:int = 16
        private static const SPEED:Number = 0.2
        
        private var _fr:FileReference = new FileReference()
        private var _bmd:BitmapData;
        private var _bm:Bitmap;
        private var _flg:Boolean
        
        private var _copyBmd:BitmapData
        private var _drawBmd:BitmapData
        private var _mosaicCount:Number

        public function Main(){
            stage.addEventListener(MouseEvent.CLICK, fileBrowse)
        }
        
        private function fileBrowse(e:MouseEvent):void{
            var imagesFilter:FileFilter = new FileFilter("Images", "*.jpg;*.gif;*.png");
            _fr.browse([imagesFilter])
            _fr.addEventListener(Event.SELECT, fileLoad)
            _fr.addEventListener(Event.CANCEL, cancel)
            //
            stage.removeEventListener(MouseEvent.CLICK, fileBrowse)
        }
        private function fileLoad(e:Event):void{
            _fr.removeEventListener(Event.SELECT, fileLoad)
            //
            _fr.load()
            _fr.addEventListener(Event.OPEN, open)
            _fr.addEventListener(ProgressEvent.PROGRESS, progress)
            _fr.addEventListener(Event.COMPLETE, complete)
            _fr.addEventListener(IOErrorEvent.IO_ERROR, ioError)
            //
            function open(e:Event):void{
                //
            }
            function progress(e:ProgressEvent):void{
                //
            }
            function complete(e:Event):void{
                removedEventListener()
                addImage()
            }
            function ioError(e:IOErrorEvent):void{
                removedEventListener()
            }
            //
            function removedEventListener():void{
                _fr.removeEventListener(Event.OPEN, open)
                _fr.removeEventListener(ProgressEvent.PROGRESS, progress)
                _fr.removeEventListener(Event.COMPLETE, complete)
                _fr.removeEventListener(IOErrorEvent.IO_ERROR, ioError)
            }
        }
        private function cancel(e:Event):void{
            _fr.removeEventListener(Event.SELECT, fileLoad)
            _fr.removeEventListener(Event.CANCEL, cancel)
            stage.addEventListener(MouseEvent.CLICK, fileBrowse)
        }
        
        private function addImage():void{
            var loader:Loader = new Loader();
            loader.loadBytes(_fr.data)
            loader.contentLoaderInfo.addEventListener(Event.INIT, init);
            //
            function init(e:Event):void{
                var r:Number = loader.width / loader.height
                _mosaicCount = MOSAIC_RANGE
                //
                if(_bm){
                    removeChild(_bm)
                    _drawBmd.dispose()
                    _bm = null
                }
                //
                if(r >= 1){
                    var m:Number = W / loader.width
                    _bmd = new BitmapData(W, H / r , true, 0)
                }else{
                    m = H / loader.height
                    _bmd = new BitmapData(W * r, H , true, 0)
                }
                _drawBmd = new BitmapData(_bmd.width, _bmd.height, true, 0)
                _bm = new Bitmap(_drawBmd, "auto", false)
                _bm.x = (W / 2 - _bmd.width / 2)
                _bm.y = (H / 2 - _bmd.height / 2)
                _bm.scaleX = _bm.scaleY = _mosaicCount
                addChild(_bm)
                //
                _bmd.draw(loader.content, new Matrix(m, 0, 0, m))
                update(null)
                //
                var timer:Timer = new Timer(1500, 1)
                timer.addEventListener(TimerEvent.TIMER_COMPLETE, timerComplete)
                timer.start()
                //
                function timerComplete(e:TimerEvent):void{
                    timer.removeEventListener(TimerEvent.TIMER_COMPLETE, timerComplete)
                    addEventListener(Event.ENTER_FRAME, update)
                    timer = null
                }
            }
        }
        
        private function update(e:Event):void{
            if(_mosaicCount >= 1){
                _copyBmd = new BitmapData(_bmd.width / _mosaicCount , _bmd.height / _mosaicCount , true, 0)
                _copyBmd.draw(_bmd, new Matrix(1 / _mosaicCount, 0, 0, 1 / _mosaicCount))
                _drawBmd.draw(_copyBmd)
                _bm.scaleX = _bm.scaleY = _mosaicCount
                _mosaicCount -= SPEED
            }else{
                removeEventListener(Event.ENTER_FRAME, update)
                _mosaicCount = MOSAIC_RANGE
                _bmd.dispose()
                _copyBmd.dispose()
                stage.addEventListener(MouseEvent.CLICK, fileBrowse)
            }
        }
        
        private function bmdResized(src:BitmapData, hRatio:Number, vRatio:Number):BitmapData{
          var res:BitmapData = new BitmapData(Math.ceil(src.width * hRatio), Math.ceil(src.height * vRatio));
          res.draw(src, new Matrix(hRatio, 0, 0, vRatio), null, null, null, true);
          return res;
        }
    }
}