/**
 * Copyright CoremindJP ( http://wonderfl.net/user/CoremindJP )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ihI6
 */

// forked from andres_works's particle smoke!!
package 
{
    import caurina.transitions.Tweener;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;
    /**
     * ...クリックで拡大！
     * @author ta-ta
     */
    [SWF(width = 465, height = 465, backgroundColor = 0, frameRate = 30)]
    public class Main extends Sprite 
    {
        private static const R:Number = 0.017453;
        public var ms:Number = 0.2;
            
        private var
            clen    :int                = 150000,//15万
            tlen    :int                = 720,
            ct      :Vector.<Number>    = new Vector.<Number>(tlen, true),
            st      :Vector.<Number>    = new Vector.<Number>(tlen, true),
            cvs     :BitmapData         = new BitmapData(465, 465, false, 0),
            ctf     :ColorTransform     = new ColorTransform(),
            cmfArr  :Array              = [0.8, 0, 0, 0, -16, 0, 0.8, 0, 0, -16, 0, 0, 0.8, 0, -16],
            cmf     :ColorMatrixFilter  = new ColorMatrixFilter(cmfArr),
            bf      :BlurFilter         = new BlurFilter(1, 1),
            cp      :Point              = new Point(),
            vp      :Point              = new Point(),
            img     :BitmapData,
            top     :Circle;
        
        public function Main():void 
        {
            initsourceImage();
            initAngleTable();
            initCircle();
            addChild(new Bitmap(cvs));
            
            setInterval(colorUpdate, 3000);
            stage.addEventListener(Event.ENTER_FRAME    , update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdh);
            stage.addEventListener(MouseEvent.MOUSE_UP  , muh);
        }
        
        private function initsourceImage():void
        {
            //var _s:Shape = new Shape();
            //_s.graphics.beginFill(0x2040AB);
            //_s.graphics.drawRect(0, 0, 1, 1);
            //_s.graphics.endFill();
            //_s.filters = [new BevelFilter(4, 90, 0xFFFFFF, 0.6, 0, 0.6)];
            img = new BitmapData(1, 1, true, 0xFFFFFFFF);
            //img.draw(_s);
        }
        
        private function initAngleTable():void 
        {
            var _base:Number = 360 / 720;
            
            for (var i:int = 0; i < 720; i++) 
            {
                ct[i] = Math.cos(R * _base * i);
                st[i] = Math.sin(R * _base * i);
            }
        }
        
        private function initCircle():void
        {
            top = new Circle(Math.random() * 719, Math.random() * 4 - 2, Math.random() * 1 - 2, null);
            for (var i:int = clen - 2; 0 <= i; i--) top = new Circle(Math.random() * 719, Math.random() * 30 - 15, Math.random() * 10 - 5, top);
        }
        
        public function update(e:Event):void
        {
            var
                _r:Number,
                _a:int,
                _px:Number = 232.5,
                _py:Number = 232.5,
                _ms:Number = ms,
                _cvs:BitmapData = cvs,
                _img:BitmapData = img,
                _cvsRect:Rectangle = _cvs.rect,
                _imgRect:Rectangle = _img.rect;
                
            _cvs.lock();
            for (var _circle:Circle = top; _circle; _circle = _circle.next)
            {
                _circle.update();
                
                _r = _circle.radius;
                _a = _circle.angleIndex;
                _px += ct[_a] * _r * _ms;
                _py += st[_a] * _r * _ms;
                _cvs.setPixel(_px, _py, 0xFFFFFF);
            }
            _cvs.applyFilter(_cvs, _cvsRect, cp, cmf);
            _cvs.applyFilter(_cvs, _cvsRect, cp, bf);
            _cvs.unlock();
            
            tr < cmfArr[0]  ? cmfArr[0]  -= 0.001: cmfArr[0]  += 0.001;
            tg < cmfArr[6]  ? cmfArr[6]  -= 0.001: cmfArr[6]  += 0.001;
            tb < cmfArr[12] ? cmfArr[12] -= 0.001: cmfArr[12] += 0.001;
            cmf.matrix  = cmfArr;
        }
        
        
        private function mdh(e:MouseEvent):void
        {
            Tweener.addTween(this, {ms:0.8, time:1, transition:"linear"})
        }
        
        private function muh(e:MouseEvent):void
        {
            Tweener.addTween(this, {ms:0.2, time:5, transition:"easeOutBack"})
        }
        
        private var tr:Number;
        private var tg:Number;
        private var tb:Number;
        private function colorUpdate():void
        {
            tr = Math.random() * 1.2;
            tg = Math.random() * 1.3;
            tb = Math.random() * 1.4;
        }

    }
    
}

class Circle
{
    public var
        radius:Number,
        angleIndex:int,
        next:Circle;
        
    private var aii:int;
        
    public function Circle(
        angleIndex:int,
        radius:Number,
        aii:int,
        next:Circle)
    {
        this.angleIndex = angleIndex;
        this.radius     = radius;
        this.aii        = aii;
        this.next       = next;
    }
    
    public function update():void
    {
        angleIndex += aii;
        if (angleIndex <= 0) angleIndex = 719;
        if (angleIndex >= 720) angleIndex = 0;
    }
}
