/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/igly
 */

// forked from aont's XY Model MC
// forked from aont's Ising Model MC
package {
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.events.Event;
	import flash.text.TextFieldAutoSize;
	
	[SWF(backgroundColor="#000000",width="276",height="390",frameRate = "30")]
	public class IsingFlash extends Sprite
	{
		private var ising:IsingModel;
		//private var myTimer:Timer;
		private var running:Boolean = true;
		
		private var Temp_tb:TextField;
		private var Bond_tb:TextField;
		private var Times_tb:TextField;
		//private var Interval_tb:TextField;

		private var start_stop_button:TextField;
		//private var init_button:TextField;
		public function IsingFlash()
		{
			this.ising = new IsingModel(256,256);
			var bmp:Bitmap = new Bitmap(this.ising.Canvas);
			bmp.x=10;
			bmp.y=10;
			this.addChild(bmp);
			
			this.CreateLabel(10,276,"Tempereture");
			this.Temp_tb = CreateNumField(106,274,"");
			
			this.CreateLabel(10,304,"Bond");
			this.Bond_tb = CreateNumField(106,302,"");
			
			this.CreateLabel(10,332,"Times");
			this.Times_tb = CreateNumField(106,330,"");
			
			//this.CreateLabel(10,360,"Interval");
			//this.Interval_tb = CreateNumField(106,358,"");
			
			var set_button:TextField = CreateButton(221,358,"Set");
			set_button.addEventListener(MouseEvent.CLICK,this.Set_Click);
			
			var reset_button:TextField = CreateButton(154,358,"Reset");
			reset_button.addEventListener(MouseEvent.CLICK,this.Reset_Click);
			
			var init_button:TextField = CreateButton(99,358,"Init");
			init_button.addEventListener(MouseEvent.CLICK,this.isingRandomize);
			
			this.start_stop_button = CreateButton(10,358,"Pause");
			this.start_stop_button.addEventListener(MouseEvent.CLICK,this.start_stop);

			
			//this.myTimer = new Timer(1,0);
			//this.myTimer.addEventListener(TimerEvent.TIMER,Advance);
			this.Reset_Click(null);
			//this.myTimer.start();
			this.addEventListener(Event.ENTER_FRAME,enterframe );
		}
		
		private function CreateNumField(x:int,y:int,def:String):TextField
		{
			var tf:TextField = new TextField();
			tf.x=x;
			tf.y=y;
			tf.height = 22;
			tf.width=80;
			
			tf.text=def;
			tf.type = TextFieldType.INPUT;
			tf.background=true;
			tf.backgroundColor=0xffffff;
			tf.border=true;
			tf.borderColor=0x808080;
			this.addChild(tf);
			return tf;
		}
		private function CreateLabel(x:int,y:int,def:String):TextField
		{
			var tf:TextField = new TextField();
			tf.textColor = 0xffffff;
			tf.x=x;
			tf.y=y;
			tf.text=def;
			this.addChild(tf);
			return tf;
		}
		private function CreateButton(x:int,y:int,def:String):TextField
		{
			var tf:TextField = new TextField();
			tf.x=x;
			tf.y=y;
			tf.height = 22;
			tf.width=40;
			tf.text=def;
			tf.selectable=false;
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.background=true;
			tf.backgroundColor=0xf0f0f0;
			tf.border=true;
			tf.borderColor=0x808080;
			this.addChild(tf);
			return tf;
		}
		
		private function enterframe(event:Event):void
		{
			if(running)
			{			
				//this.myTimer.stop();
				this.ising.Advance();
				//this.myTimer.start();

			}				
		}
		private function Reset_Click(e:MouseEvent):void
		{			
			this.Temp_tb.text = this.ising.Tempereture.toString();
			this.Bond_tb.text = this.ising.Bond.toString();
			this.Times_tb.text = this.ising.Times.toString();
			//this.Interval_tb.text = this.myTimer.delay.toString();
		}
		private function Set_Click(e:MouseEvent):void
		{
			 this.ising.Tempereture=Number(this.Temp_tb.text);
			 this.ising.Bond=Number(this.Bond_tb.text);
			 this.ising.Times=Number(this.Times_tb.text);
			 //this.myTimer.delay=Number(this.Interval_tb.text);
		}
		private function isingRandomize(e:MouseEvent):void
		{						
			this.ising.Randomize();
		}
		
		
		private function start_stop(e:MouseEvent):void
		{
			if(this.running = !this.running)
			{
				//this.myTimer.start();
				this.start_stop_button.text = "Pause";
			}
			else
			{
				//this.myTimer.stop();
				this.start_stop_button.text = "Start";
			}
		}
	}
}
import flash.display.BitmapData;
class IsingModel
{
	public var Width:int;
	public var Height:int;
	public var Canvas:BitmapData;
	public var States:Array;
	
	public function IsingModel(Width:int, Height:int)
	{
		this.Bond = 1;
		this.Tempereture=300;
		this.Width=Width;
		this.Height=Height;
		this.Canvas=new BitmapData(Width,Height,false);
		this.States = new Array(Width*Height);
		Randomize();
	}
	
	public function Randomize():void
	{
		for(var w:int=0;w<Width;w++)
		{
			for(var h:int=0;h<Height;h++)
			{
				var s:Number = Math.random()*2*Math.PI;
				this.States[w+h*Width] = s;
				this.Canvas.setPixel(w,h,HSVtoRGB(s*180/Math.PI,1,1));
			}
		}
	}
	
	public var Bond:Number;
	public var Tempereture:Number;
	public const k_b:Number=1.3806503e-23;
	public var Times:int=9096;
	public function Advance():void
	{
		this.Canvas.lock();
		for(var t:int=0;t<this.Times;t++)
		{
			this.AdvanceOnce();
		}
		this.Canvas.unlock();
	}
	
	

	private function AdvanceOnce():void
	{
		
		var x:int = Math.floor(Math.random()*this.Width);
		var y:int = Math.floor(Math.random()*this.Height);
		
		var s_:Number = Math.random()*2*Math.PI;
		var states:Array = this.States;
		var s:Number = states[x+y*Width];
		
		var deltaEnergy:Number = 0;			
		if(x>0)
			deltaEnergy += -Math.cos(s_-states[x-1+y*Width])+Math.cos(s-states[x-1+y*Width]);
		if(x<this.Width-1)
			deltaEnergy += -Math.cos(s_-states[x+1+y*Width])+Math.cos(s-states[x+1+y*Width]);
		if(y>0)
			deltaEnergy += -Math.cos(s_-states[x+(y-1)*Width])+Math.cos(s-states[x+(y-1)*Width]);
		if(y<this.Height-1)
			deltaEnergy += -Math.cos(s_-states[x+(y+1)*Width])+Math.cos(s-states[x+(y+1)*Width]);
		deltaEnergy *= this.Bond;
		if(deltaEnergy<0)
		{
			states[x+y*Width] = s_;
			this.Canvas.setPixel(x,y,HSVtoRGB(s_*180/Math.PI,1,1));
		}
		else
		{
			var P:Number=Math.exp(-deltaEnergy/(this.k_b*this.Tempereture));
			if(P>Math.random())
			{
				this.Canvas.setPixel(x,y,HSVtoRGB(s_*180/Math.PI,1,1));
				states[x+y*Width] = s_;
			}
		}			
	}		

	private static function HSVtoRGB( h:Number, s:Number, v:Number ):uint
	{
		var rgb:uint = 0;
        var hi:uint = Math.floor(h / 60.0) % 6;
        var f:Number = h / 60.0 - hi;
        var vv:uint = Math.round(255 * v);
        var pp:uint = Math.round(255 * v * ( 1 - s ));
        var qq:uint = Math.round(255 * v * ( 1 - f * s ));
        var tt:uint = Math.round(255 * v * ( 1 - (1 - f) * s ));
        if ( vv > 255 ) vv = 255;
        if ( pp > 255 ) pp = 255;
        if ( qq > 255 ) qq = 255;
        if ( tt > 255 ) tt = 255;
        switch (hi) {
            case 0: rgb = (vv << 16) | (tt << 8) | pp; break;
            case 1: rgb = (qq << 16) | (vv << 8) | pp; break;
            case 2: rgb = (pp << 16) | (vv << 8) | tt; break;
            case 3: rgb = (pp << 16) | (qq << 8) | vv; break;
            case 4: rgb = (tt << 16) | (pp << 8) | vv; break;
            case 5: rgb = (vv << 16) | (pp << 8) | qq; break;
        }
		return rgb;
	}
	

}