/**
 * Copyright kataribe ( http://wonderfl.net/user/kataribe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ifw7X
 */

package {
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.FileReference;
    import flash.utils.ByteArray;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import mx.graphics.codec.PNGEncoder;
    import com.bit101.components.PushButton;
    public class FlashTest extends Sprite {
        private var x_val:TextField = new TextField();
        private var y_val:TextField = new TextField();
        
        public function FlashTest() {
            // write as3 code here..
            var tmp:TextField;

            //x_val
            tmp = new TextField();
            tmp.text = "x :";
            addChild(tmp);
            x_val.type = "input";
            x_val.border = true;
            x_val.x = 20;
            x_val.height = 20;
            x_val.restrict = "0-9";
            addChild(x_val);
            
            //y_val
            tmp = new TextField();
            tmp.text = "y :";
            tmp.y = 20;
            addChild(tmp);
            y_val.type = "input";
            y_val.border = true;
            y_val.x = 20;
            y_val.y = 20;
            y_val.height = 20;
            y_val.restrict = "0-9";
            addChild(y_val);
            
            //save
            new PushButton(this, 0, 50, "save", save);
        }
        
        //保存
        private function save(e:Event):void{
            new FileReference().save(
                new PNGEncoder().encode(
                    generate(
                        parseInt(x_val.text.toString()),
                        parseInt(y_val.text.toString())
                    )
                ),
                "a.png"
            );
        }
        
        //ビットマップデータを生成
        private function generate(w:uint, h:uint):BitmapData{
            var bmd:BitmapData = new BitmapData(w, h, true, 0x00FFFFFF);
            var th:uint;

            if(w<h){
                th = w/2;
            }else{
                th = h/2;
            }
            
            var point:Point = new Point();
            var cen:Point = new Point(th, th);
            var max_dis:Number = Point.distance(cen, new Point())-th;
            var dis:Number
            for(var x:uint=0; x<th; ++x){
                for(var y:uint=0; y<th; ++y){
                    point.x = x;
                    point.y = y;
                    dis = Point.distance(cen, point)-th;
                    if(0<dis){
                        bmd.setPixel32(x, y, ((uint)(0xFF*(dis/max_dis/2)))<<24);
                    }
                }
            }
            
            var bmd2:BitmapData = new BitmapData(th, h, true, 0x00FFFFFF);
            bmd2.draw(bmd);
            bmd.draw(bmd2, new Matrix(1, 0, 0, -1, 0, h));
            bmd.draw(bmd, new Matrix(-1, 0, 0, 1, w, 0));

            return bmd;
        }

    }
}