/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ifZa
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    //import net.hires.debug.Stats;
    import flash.display.Loader;
    import flash.display.LoaderInfo;

    /**
     * ...
     * @author moriya
     */
    public class Main extends Sprite
    {
        private const FADE:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,-0x10);
        private const STW:uint = stage.stageWidth, STH:uint = stage.stageHeight;

        private var brkNum:Number=0.04
        private var offsetX:int = 0;
        private var offsetY:int = 0;

        private var btmdList:Array = [];
        private var btmpList:Array = [];

        private var btmpList2:Array = [];

        private var cntrBMD:BitmapData
        private var sp:Sprite = new Sprite();

        private var cMax:Number;
        private var rMax:Number;
        private var c:int;//行
        private var r:int;//列
        private const cpart:int=1;//横刻み
        private const rpart:int=4;//縦刻み

        private var tf:TextField;
        private var isSwitch:Boolean = true;
        private var mtx:Matrix;

        private var a_num:Number = 1;
        private var b_num:Number = 0;
        private var c_num:Number = 0;
        private var d_num:Number = 1;
        private var tx_num:Number = 0;
        private var ty_num:Number = 0;

        private var context:LoaderContext;
        private var _imgLoader:Loader;
        private var _imgLoaderB:Loader;
        private var _imgLoaderInfo:LoaderInfo;

        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            tf = new TextField();
            tf.x = 200;
            addChild(tf);

            var url:String = "http://assets.wonderfl.net/images/related_images/3/30/3008/3008881cd570037d810bd92b5d51d589ecdbce63m";
            var urlReq:URLRequest = new URLRequest(url);
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            _imgLoader = new Loader();
            _imgLoaderInfo = _imgLoader.contentLoaderInfo;
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageloaded);
            _imgLoader.load(urlReq,context);

        }
        private function onImageloaded(e:Event):void
        {
            //addChild(_imgLoader);

            var bmd:BitmapData = new BitmapData(_imgLoader.width,_imgLoader.height);
            bmd.draw(_imgLoader);
            var bmp:Bitmap = new Bitmap(bmd);
            //addChild(bmp);
            setting(bmd)
        }

        private function setting(_bmd:BitmapData):void
        {

            tf.text="Setting.."

            var img:Object = _imgLoader;
            var bmd:BitmapData = _bmd

            offsetX = STW * 0.5 - img.width * 0.5;
            offsetY = STH * 0.5 - img.height * 0.5;

            cntrBMD = new BitmapData(STW, STH, true, 0xFFFFFFFF);
            var cntr:Bitmap = new Bitmap(cntrBMD);
            var cnt:int = 0;

            addChild(cntr);
            //cntr.x = STW *0.5;
            //cntr.y = STH * 0.5;

            c = 0;//行
            r = 0;//列
            cMax = img.width / cpart;
            rMax = img.height/rpart;
            cMax=(img.width % cpart == 0)?(cMax):(cMax+1);
            rMax=(img.height % rpart == 0)?(rMax):(rMax+1);

            for (var i:int=0; i < rMax; i++ )
            {
                r = rpart * i;
                for (var j:int=0; j < cMax; j++ )
                {
                    var _obj:Object = new Object();

                    c = cpart * j;
                    var _cbmd:BitmapData = new BitmapData(cpart, rpart, true, 0xFFFFFFFF);
                    _cbmd.copyPixels(bmd, new Rectangle(c, r, cpart, rpart), new Point(0, 0), null, null, false);

                    var _cbm:Bitmap = new Bitmap(_cbmd);
                    sp.addChild(_cbm);
                    _obj.bmp = _cbm
                    _obj.x = c+offsetX;
                    _obj.y = r+offsetY;
                    btmpList.push(_obj);

                    _cbm.x = Math.random() * STW;//c + j;
                    _cbm.y = Math.random() * STH//r + i;

                    var _obj2:Object = new Object();
                    _obj2.x = _cbm.x;
                    _obj2.y = _cbm.y;
                    btmpList2.push(_obj2);
                }
            }

            addEventListener(Event.ENTER_FRAME, fn_update);
            var clickField:Sprite = new Sprite();
            clickField.graphics.beginFill(0xFFFFFF, 0);
            clickField.graphics.drawRect(0, 0, STW, STH);
            clickField.graphics.endFill();

            clickField.buttonMode = true;
            clickField.addEventListener(MouseEvent.CLICK, fn_click);
            addChild(clickField);

            tf.text = rMax * cMax + 'p';

            addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);

            //addChild(new Stats());
        }

        private function fn_click(e:MouseEvent):void
        {
            if (isSwitch)
            {
                isSwitch = false
                tf.text = '戻る';
            }else
            {
                isSwitch = true;
                tf.text = '再生';
            }

        }

        private function KeyDown(event:KeyboardEvent):void
        {
            switch (event.keyCode)
            {
                /////////////////Y軸方向の傾斜回転/////////////////////////////
                case 38 :
                    //矢印上
                    if (b_num != 180)
                    {
                        b_num -=  5;
                }
                else
                {
                    b_num = 0;
                }

                break;
            case 40 :
                //矢印下
                if (b_num != 0)
                {
                    b_num +=  5;
            }
            else
            {
                b_num = 180;
            }

            break;
            ////////////////X軸方向の拡大縮小回転、位置///////////////////////////////
        case 39 :
            //矢印右
            a_num +=  0.1;
        break;
        case 37 :
            //矢印左
            a_num -=  0.1;
        break;

        /////////////////Y軸方向の拡大縮小回転、位置//////////////////////////////
        case 104 :
            //テンキーの8
            d_num -=  0.1;
            trace(d_num);
        break;

        case 98 :
            //テンキーの2
            d_num +=  0.1;
        break;
        /////////////////X軸方向の傾斜回転//////////////////////////////
        case 100 :
            //テンキーの6
            if (c_num != 0)
            {
                c_num -=  5;
        }
        else
        {
            c_num = 180;
        }
        break;

    case 102 :
        //テンキーの4
        if (c_num != 180)
        {
            c_num +=  5;
    }
    else
    {
        c_num = 0;
    }
    trace(c_num);

    break;

    /////////////////X座標//////////////////////////////
case 107 :
    //テンキーの+
    tx_num +=  5;
break;

case 109 :
    //テンキーの-
    tx_num -=  5;

break;

/////////////////リセット///////////////////////////////////
case 96 :
    a_num = 1;
    b_num = 0;
    c_num = 0;
    d_num = 1;
    tx_num = 220;
    ty_num = 150;

break;

}
}
private function fn_update(e:Event):void
{
    var _bmpList:Array = [];
    //btmpList1
    //=btmpList2

    var _cnt:int = 0;
    for (var i:int=0; i < rMax; i++ )
    {
        r = rpart * i;
        for (var j:int=0; j < cMax; j++ )
        {

            //値 += (目標値 - 現在の値) * 減速値*

            var _oldX:Number = btmpList[_cnt].oldX;
            var _oldY:Number = btmpList[_cnt].oldY;
            var _bmp:Bitmap = btmpList[_cnt].bmp
            var _x:Number = _bmp.x;
            var _y:Number = _bmp.y;
            var _trgtX:Number = 0;
            var _trgtY:Number = 0;

            if (isSwitch)
            {
                _trgtX = btmpList[_cnt].x;
                _trgtY = btmpList[_cnt].y;
            }else
            {
                _trgtX = btmpList2[_cnt].x;
                _trgtY = btmpList2[_cnt].y;
            }

            _x += (_trgtX - _x) * brkNum;
            if (Math.floor(_oldX*10) == Math.floor(_x*10))
            {
                _bmp.x = _trgtX;
            }else
            {
                _bmp.x = _x;
            }

            _y += (_trgtY - _y) * brkNum;
            if (Math.floor(_oldY*10) == Math.floor(_y*10))
            {
                _bmp.y = _trgtY;
            }else
            {
                _bmp.y = _y;
            }

            btmpList[_cnt].oldX = _bmp.x
            btmpList[_cnt].oldY=_bmp.y

            _cnt++
        }
    }

    mtx = new Matrix(a_num,b_num,c_num,d_num,tx_num,ty_num);
    // mtx.translate(p.x, p.y);
    //cntrBMD.draw(p, mtx, null);
    cntrBMD.colorTransform(cntrBMD.rect, FADE);
    cntrBMD.draw(sp, mtx, null);

    //cntrBMD.copyPixels(canvas.bitmapData,new Rectangle(0,0,img.width,img.height),new Point(0,0),null,null,false);

}

}

}

//

//
/*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
* */

