/**
 * Copyright xzardaz ( http://wonderfl.net/user/xzardaz )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/ieXh
 */

package 
{
    import flash.geom.Vector3D; 
    //import flash.display.Sprite; 
    //import flash.display.Shape; 
    import flash.display.*;
    import flash.geom.Point; 
    import flash.events.*;
    import flash.utils.getTimer; 
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.geom.Matrix;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.system.LoaderContext;
    import flash.system.ApplicationDomain;
    

    public class ProjectionDragger extends Sprite 
    { 
    
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
    
        private var center : Sprite; 
        private var boxPanel:Shape; 
        private var inDrag:Boolean = false; 
        
        public var Mx:Number=0;
        public var My:Number=0;
         
        public var bmpData:BitmapData;
         
         public function ProjectionDragger():void 
        { 
            root.transform.matrix=null;
            stage.addEventListener(KeyboardEvent.KEY_DOWN,pressW);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            Security.loadPolicyFile('http://api.facebook.com/crossdomain.xml');
            Security.allowDomain('http://http://wonderfl.net/');
            Security.allowInsecureDomain('http://http://wonderfl.net/');
               
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler); 
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR , scError);
            
            var request:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/d/d6/d6ac/d6ac1b471af71d05cd1531d9c4f7f5a7f040afbb");
            //loader.x = 80 * numChildren;,erContext(true));
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            context.applicationDomain = ApplicationDomain.currentDomain;

            loader.load(request, context); 
            
            
             
        }  
        
        private function mouseMove(e:MouseEvent):void
        {
            //root.transform.matrix3D.appendRotation(Mx-e.localX,new Vector3D(0,1,0),new Vector3D(200,0,0));
            //wtrace(e.stageX);
            Mx=e.localX;
            My=e.localY;
        }

        
        private function pressW(event:KeyboardEvent):void 
        {
            if(event.keyCode==87) root.transform.matrix3D.appendTranslation(0,0,-4);
            if(event.keyCode==83) root.transform.matrix3D.appendTranslation(0,0,4);
            if(event.keyCode==65) root.transform.matrix3D.appendTranslation(4,0,0);
            if(event.keyCode==68) root.transform.matrix3D.appendTranslation(-4,0,0);
            if(event.keyCode==81) root.transform.matrix3D.appendRotation(2,new Vector3D(0,1,0),new Vector3D(200,0,0));
            if(event.keyCode==69) root.transform.matrix3D.appendRotation(-2,new Vector3D(0,1,0),new Vector3D(200,0,0));
            //wtrace(event.keyCode);
        }

        
        private function ioErrorHandler(e:IOErrorEvent):void
        {
            wtrace(e);
        }
        
        private function scError(e:SecurityErrorEvent):void {wtrace(e)};

        
        private function completeHandler(event:Event):void {
            
            var loaderInfo:LoaderInfo = LoaderInfo(event.target);
            
            bmpData = new BitmapData(loaderInfo.width, loaderInfo.height, false, 0x88000000); 
            
            try
            {
                bmpData.draw(loaderInfo.loader);
            }
            catch( e : SecurityError )
            {                
                wtrace(e);
            }
            
            createScene(); 
            createCenter();
        }
        
        
        private function duplicateImage(original:Bitmap):Bitmap {
            var image:Bitmap = new Bitmap(original.bitmapData.clone());
            image.x = 80 * numChildren;
            addChild(image);
            return image;
        }
        
         public function createCenter():void 
         {   
              var  centerRadius:int = 20; 
     
              center = new Sprite(); 
     
              // circle 
              center.graphics.lineStyle(1, 0x000099); 
              center.graphics.beginFill(0xCCCCCC, 0.5); 
              center.graphics.drawCircle(0, 0, centerRadius); 
              center.graphics.endFill(); 
              // cross hairs 
              center.graphics.moveTo(0, centerRadius); 
              center.graphics.lineTo(0, -centerRadius); 
              center.graphics.moveTo(centerRadius, 0); 
              center.graphics.lineTo(-centerRadius, 0); 
              center.x = 175; 
              center.y = 175; 
              center.z = 0; 
              this.addChild(center); 
     
              center.addEventListener(MouseEvent.MOUSE_DOWN, startDragProjectionCenter); 
              center.addEventListener(MouseEvent.MOUSE_UP, stopDragProjectionCenter); 
              center.addEventListener( MouseEvent.MOUSE_MOVE, doDragProjectionCenter); 
              root.transform.perspectiveProjection.projectionCenter = new Point(center.x, center.y);
              root.transform.perspectiveProjection.fieldOfView=45; 
              root.transform.matrix3D.appendScale(1.5,1.5,1.5);
              root.transform.matrix3D.appendTranslation(0,-150,0);
        } 
        public function createBoxes():void 
        { 
            // createBoxPanel(); 
            var boxWidth:int = 50; 
            var boxHeight:int = 50; 
            var numLayers:int = 12; 
            var depthPerLayer:int = 50;  
             
            // var boxVec:Vector.<Shape> = new Vector.<Shape>(numLayers); 
            for (var i:int = 0; i < numLayers; i++) 
            {                 this.addChild(createBox(150, 50, (numLayers - i) * depthPerLayer, boxWidth, boxHeight, 0xCCCCFF, i*12, i*6)); 
                this.addChild(createBox(50, 150,  (numLayers - i) * depthPerLayer, boxWidth, boxHeight, 0xFFCCCC, i*12, i*6)); 
                this.addChild(createBox(250, 150, (numLayers - i) * depthPerLayer, boxWidth, boxHeight, 0xCCFFCC, 0, i*12)); 
                this.addChild(createBox(150, 250, (numLayers - i) * depthPerLayer, boxWidth, boxHeight, 0xDDDDDD, i*12, 0)); 
            } 
        } 
         
        public function createBox(xPos:int = 0, yPos:int = 0, zPos:int = 100, w:int = 50, h:int = 50, color:int = 0xDDDDDD, angleX:int=0, angleY:int=0):Shape 
        { 
            //wtrace(bmpData.histogram);
           //var matrix:Matrix = new Matrix();
           //var libraryBitmapData:BitmapData = new LibraryBitmapClassName(0, 0);
            var matrix:Matrix = new Matrix(); // x skew 1,0,1,1,0,0
            var box:Shape = new Shape();   
            box.graphics.beginBitmapFill(this.bmpData, matrix, false); 
            box.graphics.lineStyle(2, 0x666666);  
            //box.graphics.beginFill(color, 1.0); 
            box.graphics.drawRect(0, 0, w, h); 
            box.graphics.endFill();  
            box.x = xPos; 
            box.y = yPos; 
            box.z = zPos; 
            box.rotationX=angleX;
            box.rotationY=angleY;
            return box; 
        } 
        
         
        public function createScene():Shape 
        { 
            var matrix:Matrix = new Matrix(1,0,1,2,0,0); // x skew 1,0,1,1,0,0
            var box:Shape = new Shape();   
            box.graphics.beginBitmapFill(this.bmpData, matrix, true);  
            box.graphics.drawRect(0, 0, 400, 600); 
            box.graphics.endFill();  
            box.x = 0; 
            box.y = 0; 
            box.z = 0; 
            box.rotationX=90;
            box.rotationY=0;
            this.addChild(box);   
            var box2:Shape = new Shape();   
            box2.graphics.beginBitmapFill(this.bmpData, matrix, true);
            box2.graphics.drawRect(0, 0, 450, 750); 
            box2.graphics.endFill(); 
            box2.x = 0; 
            box2.y = 450; 
            box2.z = 0; 
            box2.rotationX=90;
            box2.rotationY=0;
            this.addChild(box2); 
            var box4:Shape = new Shape();   
            box4.graphics.beginBitmapFill(this.bmpData, matrix, false);
            box4.graphics.drawRect(0, 0, 450, 750); 
            box4.graphics.endFill(); 
            box4.x = 0; 
            box4.y = 0; 
            box4.z = -100; 
            box4.rotationX=0;
            box4.rotationY=0;
            //this.addChild(box4);
            return box; 
        } 
        
        public function startDragProjectionCenter(e:Event):void  
        {  
            center.startDrag(); 
            inDrag = true; 
        } 
         
        public function doDragProjectionCenter(e:Event):void  
        {  
            if (inDrag) 
            { 
                root.transform.perspectiveProjection.projectionCenter = new Point(center.x, center.y); 
            } 
        } 
         
        public function stopDragProjectionCenter(e:Event):void 
        { 
            center.stopDrag();  
            root.transform.perspectiveProjection.projectionCenter = new Point(center.x, center.y); 
            inDrag = false; 
        } 
        
        private function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = stage.stageHeight - 20;
//addChild(tracefield);
            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
    } 
}