/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ieW6
 */

// forked from yd_niku's flash on 2009-10-6
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.system.*;
    import flash.utils.*;
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite {
        public function FlashTest() {
            if( stage ) init();
            else addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        private var _canvas:BitmapData;
        private var _source:BitmapData;
        private var _map:BitmapData;
        
        private function init(e:Event=null):void {
            removeEventListener( Event.ADDED_TO_STAGE, init );
            stage.addEventListener( Event.RESIZE, resize );
            resize();
            
            _source= new BitmapData(rect.width,rect.height,false,0);
            
            _canvas = _source.clone();
            addChild( new Bitmap( _canvas ) );
            
            _map = _source.clone();
            var mapdisplay:DisplayObject = addChild( new Bitmap(_map) );
            mapdisplay.alpha = 0.5;
            mapdisplay.blendMode = BlendMode.ADD;
            
            buildForceMap();
            
            var l:int = 10000;
            for( var i:int = 0; i<l; ++i ) {
                var p :Particle = new Particle;
                p.x = rect.width * Math.random();
                p.y = rect.height* Math.random();
                _particles.push( p );
            }
            
            addEventListener( Event.ENTER_FRAME, update );
            update();
            
            var timer:Timer = new Timer(10000);
            timer.addEventListener( TimerEvent.TIMER, updateTimer );
            timer.start();
        }
        private function updateTimer( e:TimerEvent ):void {
            buildForceMap();
        }
        
        private function buildForceMap():void {
            _map.perlinNoise( 256, 256, 4, Math.random()*0xff>>0, true, true, 5 );
            for( var xx:int=0; xx<=rect.width; xx++ ) {
                _forceMap[xx] = new Vector.<Point>;
                for( var yy:int=0; yy<=rect.height; yy++ ) {
                    var c:uint = _map.getPixel( xx, yy );
                    var r:uint = (c>>16) & 0xff;
                    var g:uint = (c>>8) & 0xff;
                    var b:uint = c& 0xff;
                    _forceMap[xx][yy] = new Point( (r-128) / 256, (b-128) / 256 );
                }
            }    
        }
        
        private var _windDrag:Point = new Point( 0.995, 0.995 );
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        private var _forceMap:Vector.<Vector.<Point>> = new Vector.<Vector.<Point>>;
        
        private var _ctf:ColorTransform = new ColorTransform(0.99, 0.96, 0.92, 0.98 );
        private var _blur:BlurFilter= new BlurFilter(4,4,3);
        
        private function update(e:Event = null):void {
            _canvas.lock();
            _canvas.colorTransform( _canvas.rect, _ctf );
            //_blur.blurY = Math.pow( 2, int(Math.random()*3) +1 );
            for each( var p:Particle in _particles ) {
                if( p.life < 0 ) continue;
                var force:Point = _forceMap[p.x>>0][p.y>>0];
                //catch(e:Error) { continue; }
                
                p.ax *= 0.6;
                p.ay *= 0.6;
                
                p.ax += force.x * 0.01;
                p.ay += force.y * 0.01;
                
                p.vx += p.ax;
                p.vy += p.ay;
                
                p.vx *= _windDrag.x;
                p.vy *= _windDrag.y;
                
                p.x += p.vx;
                p.y += p.vy;
                
                p.life++;
                 
                if( p.x < 0 ) p.x = rect.width;
                else if( p.x > rect.width ) p.x = 0;
                if( p.y < 0 ) p.y = rect.height;
                else if( p.y > rect.height ) p.y = 0;
                
                _canvas.setPixel( p.x, p.y, 0xFFFFFF );
            }
            _canvas.applyFilter( _canvas, rect, distPoint, _blur );
            _canvas.unlock();
        }
        
        public var distPoint:Point = new Point;
        public var rect:Rectangle = new Rectangle();
        public var center:Point = new Point();
        private function resize(e:Event=null):void{
            rect.width = stage.stageWidth;
            rect.height= stage.stageHeight;
            
            center.x=  rect.width/2>>0;
            center.y = rect.height/2>>0;
        }
    }
}

class Particle {
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var life:Number = 100;
}