/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ieLV
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Matrix;
    import flash.filters.*;
    
    public class Professional extends Sprite {
        
        private var mat:Matrix = new Matrix();
        
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var t:Timer = new Timer(1000);
            t.addEventListener( TimerEvent.TIMER, render );
            t.start();
            
            this.filters =  [ new BlurFilter(8,8,2),
                                new ColorMatrixFilter( [64,0,0,0,-99 * 128,
                                0,64,0,0,-99 * 128,
                                0,0,64,0,-99 * 128,
                                0,0,0,1,0])];
        }
        
        private function render( event:TimerEvent ):void
        {
            var g:Graphics = graphics;
            g.clear();
            g.beginFill(0xffffff);
            g.drawRect(0,0,480,480);
            g.endFill();
            
            for (var i:int = 0; i < 4; i ++ )
            {
                var pattern:BitmapData = circle(3+Math.random()*10,1+Math.random()*10, i % 2 == 0 ? 0xff000000 : 0xffffffff);
                
                mat.identity();
                mat.rotate( Math.random() * Math.PI );
                mat.tx = Math.random() * 16;
                mat.ty = Math.random() * 16;
                
                g.beginBitmapFill(pattern,mat);
                g.drawRect(0,0,480,480);
                g.endFill();
             }
        }
        
        
        public function circle( radius:int, whitespace:int, color:uint ):BitmapData{
            
            var size:int = 1 + ( radius + whitespace ) * 2;
            var rows:Array = [];
            for ( var y:int = 0; y < size; y++)
            {
                var cols:Array=[];
                var dy:int = ( 1 + radius + whitespace ) - y;
                for ( var x:int = 0; x < size; x++)
                {
                    var dx:int = ( 1 + radius + whitespace ) - x;
                    cols.push( Math.sqrt( dx*dx + dy*dy) <= radius ? 0 : 1)
                }
                rows.push(cols);
            }
            
            return BitmapPatternBuilder.build(
               rows,
                [color, 0]
            );
        }
    
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}