/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ieKl
 */

// forked from Saqoosha's Quadwarp
// write as3 code here..
// http://www.youtube.com/watch?v=nWTMrgV1CZk
// クリックでマウスモード
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.getTimer;
    
    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
    
    public class Hoge extends Sprite {
        
        private var _topLeft:Bitmap;
        private var _topRight:Bitmap;
        private var _bottomLeft:Bitmap;
        private var _bottomRight:Bitmap;
        
        private var _center:Point;
        private var _isAuto:Boolean = true;
        
        public function Hoge() {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this._onImageLoaded);
            loader.load(new URLRequest('http://a2.twimg.com/profile_images/1138498994/me_default_pic.jpg'), new LoaderContext(true));
        }
        
        private function _onImageLoaded(e:Event):void {
            var loader:Loader = Loader(LoaderInfo(e.target).loader);
            var original:BitmapData = Bitmap(loader.content).bitmapData;
            
            var w:int = original.width >> 1;
            var h:int = original.height >> 1;
            var img:BitmapData = new BitmapData(w, h, false, 0x0);
            img.draw(original);
            this._topLeft = this.addChild(new Bitmap(img)) as Bitmap;
            this._topLeft.smoothing = true;
            
            img = img.clone();
            img.draw(original, new Matrix(1, 0, 0, 1, -w, 0));
            this._topRight = this.addChild(new Bitmap(img)) as Bitmap;
            this._topRight.smoothing = true;
            
            img = img.clone();
            img.draw(original, new Matrix(1, 0, 0, 1, 0, -h));
            this._bottomLeft = this.addChild(new Bitmap(img)) as Bitmap;
            this._bottomLeft.smoothing = true;
            
            img = img.clone();
            img.draw(original, new Matrix(1, 0, 0, 1, -w, -h));
            this._bottomRight = this.addChild(new Bitmap(img)) as Bitmap;
            this._bottomRight.smoothing = true;
            
            this._center = new Point(this.stage.stageWidth / 2, this.stage.stageHeight / 2);
            
            this.addEventListener(Event.ENTER_FRAME, this._update);
            this.stage.addEventListener(MouseEvent.CLICK, this._onClick);
        }
        
        private function _update(e:Event = null):void {
            var cx:Number;
            var cy:Number;
            if (this._isAuto) {
                var t:Number = getTimer() / 1000;
                cx = Math.cos(t) * 120 + this.stage.stageWidth / 2;
                cy = Math.sin(t) * 120 + this.stage.stageHeight / 2;
            } else {
                cx = Math.max(0, Math.min(this.stage.stageWidth, this.stage.mouseX));
                cy = Math.max(0, Math.min(this.stage.stageHeight, this.stage.mouseY));
            }
            this._center.x += (cx - this._center.x) / 10;
            this._center.y += (cy - this._center.y) / 10;
            
            this._topLeft.width = this._center.x;
            this._topLeft.height = this._center.y;
            
            this._topRight.x = this._center.x;
            this._topRight.width = this.stage.stageWidth - this._center.x;
            this._topRight.height = this._center.y;
            
            this._bottomLeft.y = this._center.y;
            this._bottomLeft.width = this._center.x;
            this._bottomLeft.height = this.stage.stageHeight - this._center.y;
            
            this._bottomRight.x = this._center.x;
            this._bottomRight.y = this._center.y;
            this._bottomRight.width = this.stage.stageWidth - this._center.x;
            this._bottomRight.height = this.stage.stageHeight - this._center.y;
        }
        
        private function _onClick(e:MouseEvent):void {
            this._isAuto = !this._isAuto;
        }
    }
}