/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ie1Z
 */

package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Point;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.net.URLVariables;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	
	import com.adobe.serialization.json.JSON;
	
	public class Main extends Sprite {
		
		public function Main() {
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComp);
			loader.load(new URLRequest("http://farm4.static.flickr.com/3038/2326090259_ae1b33ab85.jpg"), new LoaderContext(true));
		}
		public function loadComp(event:Event):void {
			this.addChild(event.target.content);
			
			var loader:URLLoader = new URLLoader();
			var request:URLRequest = new URLRequest("http://api.face.com/faces/detect.format");
			request.data = new URLVariables();
			request.data.api_key = "55d5d7d310d7cb2b2843e744dcdb58a1";
			request.data.urls = event.target.url;
			request.data.api_secret = "2031d04ebb227a11ebf3187379383560";
			loader.addEventListener(Event.COMPLETE, completeHandler );
			loader.load(request);
		}
		
		private function completeHandler(event:Event):void {
			var data:Object = JSON.decode(URLLoader(event.target).data);
			
			var n:int = data.photos[0].tags.length;
			for ( var i:int = 0; i < n; ++i ) {
				var face:Sprite = Face.getSprite(data.photos[0].tags[i], data.photos[0].width, data.photos[0].height);
				var pp:PerspectiveProjection = new PerspectiveProjection();
				pp.projectionCenter = new Point(data.photos[0].tags[i].center.x, data.photos[0].tags[i].center.y);
				face.transform.perspectiveProjection = pp;
				this.addChild(face);
			}
			
			var tf:TextField = new TextField();
			tf.htmlText = "<a href='http://www.flickr.com/photos/larbelaitz/2326090259/sizes/m/' target='_blank'>Photo by larbelaitz</a>"
			tf.autoSize = "left";
			tf.y = data.photos[0].height;
			this.addChild(tf);
		}
	}
}

import flash.display.Sprite;
import flash.geom.Point;
class Face {
	static public function getSprite(tag:Object,photoWidth:Number,photoHeight:Number):Sprite {
		photoWidth *= 0.01;
		photoHeight *= 0.01;
		var size:Number = (new Point(tag.width, tag.height)).length;
		var result:Sprite = new Sprite();
		
		var faceRectSp:Sprite = new Sprite();
		var w:Number = tag.width * photoWidth;
		var h:Number = tag.height * photoHeight;
		if (tag.attributes.gender.value == "male") {
			faceRectSp.graphics.lineStyle(3, 0x0000FF, 0.5);
		}else{
			faceRectSp.graphics.lineStyle(3, 0xFF0000, 0.5);
		}
		faceRectSp.graphics.drawRect(- w * 0.5, - h * 0.5, w, h);
		faceRectSp.rotationX = -tag.pitch;
		faceRectSp.rotationY = -tag.yaw;
		faceRectSp.rotationZ = tag.roll;
		result.addChild(faceRectSp);
		
		
		if (tag.eye_left) {
			result.addChild(getEye(tag, photoWidth, photoHeight, size, tag.eye_left.x, tag.eye_left.y));
		}
		if(tag.eye_right){
			result.addChild(getEye(tag, photoWidth, photoHeight, size, tag.eye_right.x, tag.eye_right.y));
		}
		if(tag.nose){
			tag.nose.x -= tag.center.x;
			tag.nose.y -= tag.center.y;
			var nose:Sprite = new Sprite();
			nose.graphics.beginFill(0xFF0000);
			nose.graphics.drawCircle(0,0, size / 3);
			nose.x = tag.nose.x * photoWidth;
			nose.y = tag.nose.y * photoHeight;
			result.addChild(nose);
		}
		result.graphics.endFill();
		
		
		tag.mouth_left.x -= tag.center.x;
		tag.mouth_left.y -= tag.center.y;
		tag.mouth_center.x -= tag.center.x;
		tag.mouth_center.y -= tag.center.y;
		tag.mouth_right.x -= tag.center.x;
		tag.mouth_right.y -= tag.center.y;
		
		result.graphics.lineStyle(size/5, 0xFFFF00);
		result.graphics.moveTo(tag.mouth_left.x*photoWidth, tag.mouth_left.y*photoHeight);
		result.graphics.lineTo(tag.mouth_center.x*photoWidth, tag.mouth_center.y*photoHeight);
		result.graphics.lineTo(tag.mouth_right.x * photoWidth, tag.mouth_right.y * photoHeight);
		
		result.graphics.lineStyle(1, 0x000000);
		result.graphics.moveTo(tag.mouth_left.x*photoWidth, tag.mouth_left.y*photoHeight);
		result.graphics.lineTo(tag.mouth_center.x*photoWidth, tag.mouth_center.y*photoHeight);
		result.graphics.lineTo(tag.mouth_right.x*photoWidth, tag.mouth_right.y*photoHeight);
		
		result.x = tag.center.x * photoWidth;
		result.y = tag.center.y * photoHeight;
		
		return result;
	}
	static public function getEye(tag:Object, photoWidth:Number, photoHeight:Number, size:Number, x:Number, y:Number):Sprite {
		x -= tag.center.x;
		y -= tag.center.y;
		var result:Sprite = new Sprite();
		result.graphics.beginFill(0xFFFFFF);
		result.graphics.drawCircle(0,0, size / 3);
		var leftEyeBall:Sprite = new Sprite();
		leftEyeBall.graphics.beginFill(0x000000);
		leftEyeBall.graphics.drawCircle(0, 0, size / 8);
		leftEyeBall.z = -4.5;
		result.x = x * photoWidth;
		result.y = y * photoHeight;
		result.z = 0;
		result.addChild(leftEyeBall);
		result.rotationZ = tag.roll;
		result.rotationY = -tag.yaw;
		result.rotationX = -tag.pitch;
		
		return result;
	}
}


import flash.utils.getQualifiedClassName;
class Dump {
	static public function stringFromObject(obj:Object):String {
		var str:String = _dump(obj);
		if (getQualifiedClassName(obj) == "Array") {
			str = "[\n" + str.slice( 0, -2 ) + "\n]";
		}else {
			str = "{\n" + str.slice( 0, -2 ) + "\n}";
		}
		return str;
	}
	static public function object(obj:Object):void {
		trace(stringFromObject(obj));
	}
	static private function _dump(obj:Object, indent:int = 0):String {
		var result:String = "";
		
		var da:String = (getQualifiedClassName(obj) == "Array")?'':'"';
		
		var tab:String = "";
		for ( var i:int = 0; i < indent; ++i ) {
			tab += "    ";
		}
		
		for (var key:String in obj) {
			if (typeof obj[key] == "object") {
				var type:String = getQualifiedClassName(obj[key]);
				if (type == "Object" || type == "Array") {
					result += tab + da + key + da + ":"+((type == "Array")?"[":"{");
					var dump_str:String = _dump(obj[key], indent + 1);
					if (dump_str.length > 0) {
						result += "\n" + dump_str.slice(0, -2) + "\n";
						result += tab;
					}
					result += (type == "Array")?"],\n":"},\n";
				}else {
					result += tab + '"' + key + '":<' + type + ">,\n";
				}
			}else if (typeof obj[key] == "function") {
				result += tab + '"' + key + '":<Function>,\n';
			}else {
				var dd:String = (typeof obj[key] == "string")?"'":"";
				result += tab + da + key + da + ":" + dd + obj[key] +dd + ",\n";
			}
		}
		return result;
	}
}
