/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/idWX
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=235
    public class Euler235 extends Sprite {
        private var _tf : TextField;
  
        public function Euler235() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText("" + (1.0 + solve()) + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        // 前調べで解は1.001と1.003の間に存在、その間s(5000)はrについて単調減少なので符号を逆転させておく
        private function solve() : Number
        {
            var f : Function = function(r : Number) : Number
            {
                return -((897 + 14100 * Math.pow(1 + r, 5000) - 3 * (1 - Math.pow(1 + r, 5000)) / (-r)) / (-r) + 600000000000);
            };
            
            _tf.appendText("" + f(0.001) + "\n");
            _tf.appendText("" + f(0.003) + "\n");
            return binarySearch(0.001, 0.003, f, 1);
        }
        
        // 単調増加関数限定
        private function binarySearch(a : Number, b : Number, f : Function, er : Number) : Number
        {
            var m : Number = (a + b) / 2;
            var vm : Number;
            do{
                vm = f(m);
                if(vm > 0){
                    b = m;
                }else{
                    a = m;
                }
                m = (a + b) / 2;
            }while(vm > er || vm < -er);
            return m;
        }
    }
}