/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/idUH
 */

package  {
    
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import caurina.transitions.Tweener;

    public class Bman extends Sprite {

        private const _terrainSpriteURL:    String = "http://assets.wonderfl.net/images/related_images/3/3b/3bc3/3bc388896de639669a25356c9d98e9ea7858f981";
        private const _characterSpriteURL:    String = "http://assets.wonderfl.net/images/related_images/9/93/935a/935a7171020c2f07e100d43da6a2b17fb04e6019";
        public static const _terrainSize:            Point = new Point ( 32, 32 );
        private const _viewRectangle:        Rectangle = new Rectangle ( -8, -8, _terrainSize.x * 15, _terrainSize.y * 15 );
        
        private var _blocks:Vector.<Vector.<uint>> = new Vector.<Vector.<uint>>;
        private var _bombs:Vector.<Bomb> = new Vector.<Bomb>;
        
        private var _worldContainer:            Sprite;
        private var _character:                BaseUnit;
        public static var _terrainSpriteBMD:        BitmapData;
        private var _characterSpriteBMD:    BitmapData;
        private var _clearBitmapData:    BitmapData = new BitmapData ( _terrainSize.x, _terrainSize.y, true, 0x60 );
        private var _terrainPiece:            uint;
        private var _world:                    Bitmap;
        private var _blockContainer:                    Bitmap;
        private var _fireContainer:                    Bitmap;
        private var _worldData:                Array = [[]];
        private var _worldOffsets:            Array = [];
        private var _keyDatas:                Array = [];
        private var _characterSpeed:        Number = .2;
        private var _characterPosition:           Point = new Point (0, 0);
        
        private var _controllEnabled:        Boolean = true;

        public function Bman () :void {
            addChild ( _worldContainer = new Sprite );
            _worldContainer.x = _viewRectangle.x;
            _worldContainer.y = _viewRectangle.y;
            _blocks.push ( new <uint> [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 1, 1, 0, 1, 1, 3, 1, 1, 0, 1, 1, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 1, 2, 0, 0, 0, 3, 0, 0, 0, 2, 1, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 0, 0, 0, 3, 0, 3, 0, 3, 0, 0, 0, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 0, 3, 0, 0, 3, 2, 3, 0, 0, 3, 0, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 1, 3, 1, 1, 2, 1, 2, 1, 1, 3, 1, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 0, 3, 0, 0, 3, 2, 3, 0, 0, 3, 0, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 0, 0, 0, 3, 0, 3, 0, 3, 0, 0, 0, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 1, 2, 0, 0, 0, 3, 0, 0, 0, 2, 1, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 1, 1, 0, 1, 1, 3, 1, 1, 0, 1, 1, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1 ] );
            _blocks.push ( new <uint> [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ] );
            loadImage ( _terrainSpriteURL, terrainSpriteLoaded );
        }
        
        private function loadImage ( $url:String, $onComplete:Function ) :void {
            var imageLoader:Loader = new Loader ();
            imageLoader.contentLoaderInfo.addEventListener ( Event.COMPLETE, $onComplete );
            var image:URLRequest = new URLRequest ( $url );
            imageLoader.load ( image, new LoaderContext ( true ) );
        }
        
        private function terrainSpriteLoaded ( event:Event ) :void {
             _terrainSpriteBMD = new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 );
             _terrainSpriteBMD.draw ( event.currentTarget.content );
             _terrainPiece = _terrainSpriteBMD.width / _terrainSize.x;
             loadImage ( _characterSpriteURL, characterSpriteLoaded );
        }
        
        private function characterSpriteLoaded ( event:Event ) :void {
            _characterSpriteBMD = new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 );
            _characterSpriteBMD.draw ( event.currentTarget.content );
            init ();
        }
        
        private function init () :void {
            _world = _worldContainer.addChild ( new Bitmap () ) as Bitmap;
            _world.bitmapData = new BitmapData ( _viewRectangle.width, _viewRectangle.height );
            _blockContainer = _worldContainer.addChild ( new Bitmap () ) as Bitmap;
            _blockContainer.bitmapData = new BitmapData ( _viewRectangle.width, _viewRectangle.height, true, 0x60 );
            _fireContainer = _worldContainer.addChild ( new Bitmap () ) as Bitmap;
            _fireContainer.bitmapData = new BitmapData ( _viewRectangle.width, _viewRectangle.height, true, 0x60 );
            _worldOffsets["UP"] = 0;
            _worldOffsets["DOWN"] = 0;
            _worldOffsets["LEFT"] = 0;
            _worldOffsets["RIGHT"] = 0;
            _blockContainer.bitmapData.lock ();
            _world.bitmapData.lock ();
            for ( var i:uint = 0; i < Math.ceil ( _viewRectangle.width / _terrainSize.x ); i++ ) {
                for ( var j:uint = 0; j < Math.ceil ( _viewRectangle.height / _terrainSize.y ); j++ ) {
                    var selectedTerrain:uint = 0;
                    _world.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( selectedTerrain * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( i * _terrainSize.x, j * _terrainSize.y ) );
                    if ( _blocks[j][i] != 0 ) {
                        selectedTerrain = _blocks[j][i];
                        _blockContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( selectedTerrain * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( i * _terrainSize.x, j * _terrainSize.y ) );
                    }
                }
            }
            _blockContainer.bitmapData.unlock ();
            _world.bitmapData.unlock ();
            _character = _worldContainer.addChild ( new BaseUnit ( 5 ) ) as BaseUnit;
            var characterSpriteSetting:CharacterSpriteSetting = new CharacterSpriteSetting ();
            characterSpriteSetting.baseBitmapData = _characterSpriteBMD;
            characterSpriteSetting.animationDelay = 3;
            characterSpriteSetting.startDirection = BaseUnit.LB;
            characterSpriteSetting.spriteSize = new Point ( 80, 64 );
            characterSpriteSetting.spriteOffset = new Point ( -26, -30 );
            characterSpriteSetting.moveAnimationLTStartPoint = new Point ( 0, 192 );
            characterSpriteSetting.moveAnimationLTFrameCount = 4;
            characterSpriteSetting.moveAnimationRTStartPoint = new Point ( 0, 192 );
            characterSpriteSetting.moveAnimationRTFrameCount = 4;
            characterSpriteSetting.moveAnimationLStartPoint = new Point ( 0, 64 );
            characterSpriteSetting.moveAnimationLFrameCount = 4;
            characterSpriteSetting.moveAnimationRStartPoint = new Point ( 0, 128 );
            characterSpriteSetting.moveAnimationRFrameCount = 4;
            characterSpriteSetting.moveAnimationLBStartPoint = new Point ( 0, 0 );
            characterSpriteSetting.moveAnimationLBFrameCount = 4;
            characterSpriteSetting.moveAnimationRBStartPoint = new Point ( 0, 0 );
            characterSpriteSetting.moveAnimationRBFrameCount = 4;
            _character.setCharacterSprite ( characterSpriteSetting );
            _characterPosition = new Point ( 4, 5 );
            _character.x = _characterPosition.x * _terrainSize.x;
            _character.y = _characterPosition.y * _terrainSize.y;
            _keyDatas["UP"] = false;
            _keyDatas["DOWN"] = false;
            _keyDatas["LEFT"] = false;
            _keyDatas["RIGHT"] = false;
            stage.addEventListener ( KeyboardEvent.KEY_DOWN, keyDown );
            stage.addEventListener ( KeyboardEvent.KEY_UP, keyUp );
            stage.addEventListener ( Event.ENTER_FRAME, core );
        }
        
        private function core ( event:Event ) :void {
            if ( _controllEnabled ) {
                if ( _keyDatas["UP"] ) {
                    if ( _blocks[_characterPosition.y - 1][_characterPosition.x] != 1 && _blocks[_characterPosition.y - 1][_characterPosition.x] != 3 && _blocks[_characterPosition.y - 1][_characterPosition.x] != 4 ) {
                        Tweener.addTween ( _character, { y: _character.y - _terrainSize.y, time: _characterSpeed, onComplete: resetControll, transition: "linear" } );
                        _characterPosition.y--;
                        _controllEnabled = false;
                    }
                } else if ( _keyDatas["DOWN"] ) {
                    if ( _blocks[_characterPosition.y + 1][_characterPosition.x] != 1 && _blocks[_characterPosition.y + 1][_characterPosition.x] != 3 && _blocks[_characterPosition.y + 1][_characterPosition.x] != 4 ) {
                        Tweener.addTween ( _character, { y: _character.y + _terrainSize.y, time: _characterSpeed, onComplete: resetControll, transition: "linear" } );
                        _characterPosition.y++;
                        _controllEnabled = false;
                    }
                } else if ( _keyDatas["LEFT"] ) {
                    if ( _blocks[_characterPosition.y][_characterPosition.x - 1] != 1 && _blocks[_characterPosition.y][_characterPosition.x - 1] != 3 && _blocks[_characterPosition.y][_characterPosition.x - 1] != 4 ) {
                        Tweener.addTween ( _character, { x: _character.x - _terrainSize.x, time: _characterSpeed, onComplete: resetControll, transition: "linear" } );
                        _characterPosition.x--;
                        _controllEnabled = false;
                    }
                } else if ( _keyDatas["RIGHT"] ) {
                    if ( _blocks[_characterPosition.y][_characterPosition.x + 1] != 1 && _blocks[_characterPosition.y][_characterPosition.x + 1] != 3 && _blocks[_characterPosition.y][_characterPosition.x + 1] != 4 ) {
                        Tweener.addTween ( _character, { x: _character.x + _terrainSize.x, time: _characterSpeed, onComplete: resetControll, transition: "linear" } );
                        _characterPosition.x++;
                        _controllEnabled = false;
                    }
                }
                var direction:String = _character.direction;
                if ( _keyDatas["UP"] ) {
                    if ( _keyDatas["RIGHT"] )
                        direction = BaseUnit.RT;
                    else if ( _keyDatas["LEFT"] )
                        direction = BaseUnit.LT;
                    else
                        direction = BaseUnit.LT;
                } else if ( _keyDatas["DOWN"] ) {
                    if ( _keyDatas["RIGHT"] )
                        direction = BaseUnit.RB;
                    else if ( _keyDatas["LEFT"] )
                        direction = BaseUnit.LB;
                    else
                        direction = BaseUnit.LB;
                } else if ( _keyDatas["RIGHT"] ) {
                    if ( _keyDatas["UP"] )
                        direction = BaseUnit.RT;
                    else if ( _keyDatas["DOWN"] )
                        direction = BaseUnit.RB;
                    else
                        direction = BaseUnit.R;
                } else if ( _keyDatas["LEFT"] ) {
                    if ( _keyDatas["UP"] )
                        direction = BaseUnit.LT;
                    else if ( _keyDatas["DOWN"] )
                        direction = BaseUnit.LB;
                    else
                        direction = BaseUnit.L;
                }
                if ( _character.direction != direction ) {
                    _character.direction = direction;
                    _character.update ();
                }
            }
            if ( !_controllEnabled )
                _character.update ();
        }
        
        private function resetControll () :void {
            _controllEnabled = true;
        }
        
        private function keyDown ( event:KeyboardEvent ) :void {
            switch ( event.keyCode ) {
                case Keyboard.UP:
                    _keyDatas["UP"] = true;
                    break;
                case Keyboard.DOWN:
                    _keyDatas["DOWN"] = true;
                    break;
                case Keyboard.LEFT:
                    _keyDatas["LEFT"] = true;
                    break;
                case Keyboard.RIGHT:
                    _keyDatas["RIGHT"] = true;
                    break;
                case Keyboard.SPACE:
                    if ( _blocks[_characterPosition.y][_characterPosition.x] == 0 || _blocks[_characterPosition.y][_characterPosition.x + 1] == 2 ) {
                        _blocks[_characterPosition.y][_characterPosition.x] = 4;
                        _bombs.push ( _worldContainer.addChildAt ( new Bomb ( _characterPosition.x, _characterPosition.y, boom ), _worldContainer.getChildIndex ( _character ) - 1 ) as Bomb );
                    }
                    break;
            }
        }
        
        private function boom ( $bomb:Bomb ) :void {
            _fireContainer.bitmapData.lock ();
            _blocks[$bomb.position.y][$bomb.position.x] = 0;
            var points:Vector.<Point> = new Vector.<Point>;
            
            for ( var i:uint = 0; i <= $bomb.fireLength; i++ ) {
                if ( _blocks[$bomb.position.y][$bomb.position.x - i] == 0 || _blocks[$bomb.position.y][$bomb.position.x - i] == 2 ) {
                    _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( ( $bomb.position.x - i ) * _terrainSize.x, $bomb.position.y * _terrainSize.y ) );
                    points.push ( new Point ( $bomb.position.x - i, $bomb.position.y ) );
                } else {
                    if ( _blocks[$bomb.position.y][$bomb.position.x - i] == 3 ) {
                        _blocks[$bomb.position.y][$bomb.position.x - i] = 0;
                        _blockContainer.bitmapData.copyPixels ( _clearBitmapData, new Rectangle ( 0, 0, _terrainSize.x, _terrainSize.y ), new Point ( ( $bomb.position.x - i ) * _terrainSize.x, $bomb.position.y * _terrainSize.y ) );
                        _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( ( $bomb.position.x - i ) * _terrainSize.x, $bomb.position.y * _terrainSize.y ) );
                        points.push ( new Point ( $bomb.position.x - i, $bomb.position.y ) );
                    }
                    break;
                }
            }
            for ( i = 0; i <= $bomb.fireLength; i++ ) {
                if ( _blocks[$bomb.position.y][$bomb.position.x + i] == 0 || _blocks[$bomb.position.y][$bomb.position.x + i] == 2 ) {
                    _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( ( $bomb.position.x + i ) * _terrainSize.x, $bomb.position.y * _terrainSize.y ) );
                    points.push ( new Point ( $bomb.position.x + i, $bomb.position.y ) );
                } else {
                    if ( _blocks[$bomb.position.y][$bomb.position.x + i] == 3 ) {
                        _blocks[$bomb.position.y][$bomb.position.x + i] = 0;
                        _blockContainer.bitmapData.copyPixels ( _clearBitmapData, new Rectangle ( 0, 0, _terrainSize.x, _terrainSize.y ), new Point ( ( $bomb.position.x + i ) * _terrainSize.x, $bomb.position.y * _terrainSize.y ) );
                        _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( ( $bomb.position.x + i ) * _terrainSize.x, $bomb.position.y * _terrainSize.y ) );
                        points.push ( new Point ( $bomb.position.x + i, $bomb.position.y ) );
                    }
                    break;
                }
            }
            for ( i = 0; i <= $bomb.fireLength; i++ ) {
                if ( _blocks[$bomb.position.y - i][$bomb.position.x] == 0 || _blocks[$bomb.position.y - i][$bomb.position.x] == 2 ) {
                    _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( $bomb.position.x * _terrainSize.x, ( $bomb.position.y - i ) * _terrainSize.y ) );
                    points.push ( new Point ( $bomb.position.x, $bomb.position.y - i ) );
                } else {
                    if ( _blocks[$bomb.position.y - i][$bomb.position.x] == 3 ) {
                        _blocks[$bomb.position.y - i][$bomb.position.x] = 0;
                        _blockContainer.bitmapData.copyPixels ( _clearBitmapData, new Rectangle ( 0, 0, _terrainSize.x, _terrainSize.y ), new Point ( $bomb.position.x * _terrainSize.x, ( $bomb.position.y - i ) * _terrainSize.y ) );
                        _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( $bomb.position.x * _terrainSize.x, ( $bomb.position.y - i ) * _terrainSize.y ) );
                        points.push ( new Point ( $bomb.position.x, $bomb.position.y - i ) );
                    }
                    break;
                }
            }
            for ( i = 0; i <= $bomb.fireLength; i++ ) {
                if ( _blocks[$bomb.position.y + i][$bomb.position.x] == 0 || _blocks[$bomb.position.y + i][$bomb.position.x] == 2 ) {
                    _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( $bomb.position.x * _terrainSize.x, ( $bomb.position.y + i ) * _terrainSize.y ) );
                    points.push ( new Point ( $bomb.position.x, $bomb.position.y + i ) );
                } else {
                    if ( _blocks[$bomb.position.y + i][$bomb.position.x] == 3 ) {
                        _blocks[$bomb.position.y + i][$bomb.position.x] = 0;
                        _blockContainer.bitmapData.copyPixels ( _clearBitmapData, new Rectangle ( 0, 0, _terrainSize.x, _terrainSize.y ), new Point ( $bomb.position.x * _terrainSize.x, ( $bomb.position.y + i ) * _terrainSize.y ) );
                        _fireContainer.bitmapData.copyPixels ( _terrainSpriteBMD, new Rectangle ( 5 * _terrainSize.x, 0, _terrainSize.x, _terrainSize.y ), new Point ( $bomb.position.x * _terrainSize.x, ( $bomb.position.y + i ) * _terrainSize.y ) );
                        points.push ( new Point ( $bomb.position.x, $bomb.position.y + i ) );
                    }
                    break;
                }
            }
            Tweener.addTween ( this, { time: 1, onComplete: clearFire, onCompleteParams: [points] } );
            $bomb.dispose ();
            _fireContainer.bitmapData.unlock ();
        }
        
        private function clearFire ( $points:Vector.<Point> ) :void {
            _fireContainer.bitmapData.lock ();
            for ( var i:uint; i < $points.length; i++ ) {
                _fireContainer.bitmapData.copyPixels ( _clearBitmapData, new Rectangle ( 0, 0, _terrainSize.x, _terrainSize.y ), new Point ( $points[i].x * _terrainSize.x, $points[i].y * _terrainSize.y ) );
            }
            _fireContainer.bitmapData.unlock ();
        }
        
        private function keyUp ( event:KeyboardEvent ) :void {
            switch ( event.keyCode ) {
                case Keyboard.UP:
                    _keyDatas["UP"] = false;
                    break;
                case Keyboard.DOWN:
                    _keyDatas["DOWN"] = false;
                    break;
                case Keyboard.LEFT:
                    _keyDatas["LEFT"] = false;
                    break;
                case Keyboard.RIGHT:
                    _keyDatas["RIGHT"] = false;
                    break;
            }
        }
        
    }
    
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
class BaseUnit extends Sprite {
    
    public static const LT:                    String = "BaseUnit.LT";
    public static const RT:                    String = "BaseUnit.RT";
    public static const L:                    String = "BaseUnit.L";
    public static const R:                    String = "BaseUnit.R";
    public static const LB:                    String = "BaseUnit.LB";
    public static const RB:                    String = "BaseUnit.RB";
    
    private var _characterSpriteSetting:    CharacterSpriteSetting;
    
    private var characterSprite:            BitmapData;
    private var characterBitmap:            Bitmap;
    
    private var _direction:                    String;
    
    public var speed:                        Number = .5;
    public var characterRotation:            Number = 0;
    
    private var animationIndex:                uint = 0;
    private var animationDelay:                uint = 0;
    
    public var rotateUnit:                    Boolean = false;
    
    public function BaseUnit ( $speed:Number = .5 ) :void {
        speed = $speed;
    }
    
    public function update () :void {
        updateGraphic ();
    }
    
    public function setCharacterSprite ( $characterSpriteSetting:CharacterSpriteSetting ) :void {
        _characterSpriteSetting = $characterSpriteSetting;
        characterSprite = _characterSpriteSetting.baseBitmapData;
        characterBitmap = new Bitmap ();
        characterBitmap.bitmapData = new BitmapData ( _characterSpriteSetting.spriteSize.x, _characterSpriteSetting.spriteSize.y, true, 0x60 );
        addChild ( characterBitmap );
        characterBitmap.x = _characterSpriteSetting.spriteOffset.x;
        characterBitmap.y = _characterSpriteSetting.spriteOffset.y;
        direction = _characterSpriteSetting.startDirection;
        updateGraphic ( true );
    }
    
    private function updateGraphic ( $forceRefresh:Boolean = false ) :void {
        animationDelay++;
        if ( $forceRefresh )
            animationDelay = _characterSpriteSetting.animationDelay + 1;
        if ( animationDelay > _characterSpriteSetting.animationDelay ) {
            switch ( characterRotation ) {
                case 180:
                    _direction = L;
                    break;
                case 0:
                    _direction = R;
                    break;
                case -120:
                    _direction = LT;
                    break;
                case -45:
                    _direction = RT;
                    break;
                case 135:
                    _direction = LB;
                    break;
                case 60:
                    _direction = RB;
                    break;
            }
            animationDelay = 0;
            characterBitmap.bitmapData.dispose ();
            characterBitmap.bitmapData = new BitmapData ( _characterSpriteSetting.spriteSize.x, _characterSpriteSetting.spriteSize.y, true, 0x60 );
            var copyRectangle:Rectangle = new Rectangle ( 0, 0, _characterSpriteSetting.spriteSize.x, _characterSpriteSetting.spriteSize.y );
            switch ( _direction ) {
                case LT:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationLTFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationLTStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationLTStartPoint.y;
                    break;
                case RT:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationRTFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationRTStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationRTStartPoint.y;
                    break;
                case L:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationLFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationLStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationLStartPoint.y;
                    break;
                case R:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationRFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationRStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationRStartPoint.y;
                    break;
                case LB:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationLBFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationLBStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationLBStartPoint.y;
                    break;
                case RB:
                    if ( animationIndex >= _characterSpriteSetting.moveAnimationRBFrameCount )
                        animationIndex = 0;
                    copyRectangle.x = _characterSpriteSetting.moveAnimationRBStartPoint.x + animationIndex * _characterSpriteSetting.spriteSize.x;
                    copyRectangle.y = _characterSpriteSetting.moveAnimationRBStartPoint.y;
                    break;
            }
            animationIndex++;
            characterBitmap.bitmapData.copyPixels ( characterSprite, copyRectangle, new Point ( 0, 0 ) );
        }
    }
    
    public function get direction () :String {
        return _direction;
    }
    
    public function set direction ( $direction:String ) :void {
        _direction = $direction;
        switch ( $direction ) {
            case L:
                characterRotation = 180;
                break;
            case R:
                characterRotation = 0;
                break;
            case LT:
                characterRotation = -120;
                break;
            case RT:
                characterRotation = -45;
                break;
            case LB:
                characterRotation = 135;
                break;
            case RB:
                characterRotation = 60;
                break;
        }
        animationDelay = _characterSpriteSetting.animationDelay
        if ( rotateUnit )
            rotation = characterRotation;
    }
    
}

import flash.geom.Point;
import flash.display.BitmapData;
class CharacterSpriteSetting {
    
    public var baseBitmapData:                BitmapData;
    
    public var moveAnimationLTStartPoint:    Point; // Left Top
    public var moveAnimationRTStartPoint:    Point; // Right Top
    public var moveAnimationLStartPoint:    Point; // Left
    public var moveAnimationRStartPoint:    Point; // Right
    public var moveAnimationLBStartPoint:    Point; // Left Bottom
    public var moveAnimationRBStartPoint:    Point; // Right Bottom
    public var spriteSize:                    Point;
    public var spriteOffset:                Point;
    
    public var startDirection:                String;
    
    public var animationDelay:                uint;
    public var moveAnimationLTFrameCount:    uint; // Left Top
    public var moveAnimationRTFrameCount:    uint; // Right Top
    public var moveAnimationLFrameCount:    uint; // Left
    public var moveAnimationRFrameCount:    uint; // Right
    public var moveAnimationLBFrameCount:    uint; // Left Bottom
    public var moveAnimationRBFrameCount:    uint; // Right Bottom
    
    public function CharacterSpriteSetting () :void {
    }
    
}

import flash.geom.Point;
import caurina.transitions.Tweener;
import flash.display.Sprite;
class Bomb extends Sprite {
    
    public var position:Point = new Point ();
    private var _animState:Boolean = false;
    private var _graphic:Bitmap;
    private var _basePoint:Point;
    public var fireLength:uint = 3;
    
    public function Bomb ( $x:Number, $y:Number, $boom:Function ) :void {
        x = $x * Bman._terrainSize.x;
        y = $y * Bman._terrainSize.y;
        position = new Point ( $x, $y );
        _basePoint = new Point ( 0, 0 );
        _graphic = addChild ( new Bitmap ( new BitmapData ( Bman._terrainSize.x, Bman._terrainSize.y, true, 0x60 ) ) ) as Bitmap;
        _graphic.bitmapData.copyPixels ( Bman._terrainSpriteBMD, new Rectangle ( 4 * Bman._terrainSize.x, 0, Bman._terrainSize.x, Bman._terrainSize.y ), new Point () );
        nextAnim ();
        Tweener.addTween ( this, { time: 4, onComplete: $boom, onCompleteParams: [this] } );
    }
    
    public function dispose () :void {
        Tweener.removeTweens ( _graphic );
        _graphic.bitmapData.dispose ();
        _graphic = null;
        parent.removeChild ( this );
    }
    
    private function nextAnim () :void {
        if ( _animState )
            Tweener.addTween ( _graphic, { y: _basePoint.y - 5, time: .5, onComplete: nextAnim } );
        else
            Tweener.addTween ( _graphic, { y: _basePoint.y, time: .5, onComplete: nextAnim } );
        _animState = !_animState;
    }
    
}