/**
 * Copyright telcanty ( http://wonderfl.net/user/telcanty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/icmu
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;

    public class FlashTest extends Sprite {
        public var ball:Sprite;
        public var size:int = 10;
        public var speed:int = 5;

        public var xVel:Number = speed * 2 * Math.random() - speed;
        public var yVel:Number = speed * 2 * Math.random() - speed;

        public function FlashTest() {
            ball = new Sprite();
            ball.graphics.beginFill(0xFF0000);
            ball.graphics.drawCircle(size / 2 * -1, size/2 * -1 , size);
            ball.graphics.endFill();
            ball.addEventListener(Event.ENTER_FRAME, _update);
            
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight/2;

            this.addChild(ball);
        }

        private function _update(e:Event = null):void
        {
            //var targetX:Number = ball.x + xVel;
            //var targetY:Number = ball.y + yVel;

            if( ball.x >= stage.stageWidth - size/2)
            {
                xVel *= -1;
            }else if(ball.x <= 0 + size/2)
            {
                xVel *= -1;
            }

            if( ball.y >= stage.stageHeight - size/2)
            {
                yVel *= -1;
            }else if( ball.y <= 0 + size/2)
            {
                yVel *= -1;
            }



            ball.x += xVel; //targetX;
            ball.y += yVel; //targetY;
        }

    }
}