/**
 * Copyright thereallex ( http://wonderfl.net/user/thereallex )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/icmh
 */

// forked from a24's forked from: [QuickBox2D] Doll in space
// forked from paq's [QuickBox2D] Doll in space

package 
{
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import com.actionsnippet.qbox.objects.CircleObject;
	import com.actionsnippet.qbox.QuickBox2D;
	import com.actionsnippet.qbox.QuickObject;
	import flash.display.MovieClip;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(width = 465, height = 465, backgroundColor = 0x333333, frameRate = 60)]
	
	public class Sample extends MovieClip
	{
		private var sim:QuickBox2D;
		private var fixedPoint:b2Vec2 = new b2Vec2(7.25, 7.25);
		private var scale:Number = 30;
		private var balls:Array = new Array();
		
		public function Sample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			sim = new QuickBox2D(this);
			sim.gravity = new b2Vec2(0, 30);
			sim.iterations = 10;
			sim.createStageWalls();
			
			sim.setDefault( { fillColor:0xFFFFFF, lineColor:0x333333 } );
			
			for (var i:int = 0; i < 20; i++) 
			{
				balls.push(sim.addCircle( { x:Math.random() * 15.5, y:Math.random() * 7, radius:1.6*Math.random() } ));
			}
			
			sim.start();
			sim.mouseDrag();
			
			addEventListener(MouseEvent.CLICK, clickHandler);
		}
		
		private function clickHandler(e:MouseEvent):void 
		{
			removeEventListener(MouseEvent.CLICK, clickHandler);
			
			sim.addCircle( { x:7.25, y:7.25, radius:1.6, density:0 } );
			
			for (var i:int = 0; i < 10; i++) 
			{
				var ball:QuickObject = balls[i];
				sim.addCircle( { x:ball.x, y:ball.y, radius:0.2 } );
				ball.fullDestroy();
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			for ( var i:int = 0; i < balls.length; i ++ )
			{
				var ball:QuickObject = balls[i];
				var fp:b2Vec2 = fixedPoint.Copy();
				fp.Subtract(ball.body.GetPosition());
				fp.Normalize();
				fp.Multiply(50);
				ball.body.ApplyForce(fp, ball.body.GetWorldCenter());
				ball.body.ApplyForce(new b2Vec2(0, -30), ball.body.GetWorldCenter());
			}
		}
	}
}

