/**
 * Copyright sph62 ( http://wonderfl.net/user/sph62 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ic5Y
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        
        private var _ptList:Array = [
                        new Point(30,400),
                        new Point(100,200),
                       // new Point(100,100),
                       // new Point(200,100),
                        new Point(300,200),
                        new Point(400,420)]
        private var debug:TextField = new TextField();
        
        public function FlashTest() {
            // write as3 code here..
            addChild(debug);
            debug.autoSize = "left";
            
            var len:int = _ptList.length;
            var pt:Point;
            graphics.lineStyle(1,0);
            for(var i:int = 0;i<len; i++){
                pt = _ptList[i];
                graphics.drawCircle(pt.x,pt.y,4);
            }                
            
            graphics.lineStyle(1,0x0099FF);
            var ptL:Point = _ptList[len-1];
            var tmpPT:Point;
            debug.appendText(ptL + "\n");
            for(i= 0; i<10; i++){
                pt = getBezierPoint(i/10,_ptList)
                debug.appendText(pt + "\n");
                graphics.drawCircle(pt.x,pt.y,4);
            }
            
        }
        
        //n次のベジュ曲線
        private function getBezierPoint(t:Number,ptlist:Array):Point{
            var pt:Point = new Point();
            var len:int = ptlist.length;
            for(var i:int=0;i<len;i++){
               pt = pt.add(
                        ptMulti( nCr(len,i)/10,
                                 ptlist[i]
                        )
                    );
            }
            return pt;
        }
        
        private function nCr(n:int,r:int):int{
          return kaijyo(n) / ( kaijyo(r) * kaijyo(n-r) );
        }
        
        private function ptMulti(k:Number,pt:Point):Point{
            pt.x *= k;
            pt.y *= k;
            return pt;
        }
        
        private function kaijyo(n:int):int{
            var k:int = 1;
            for(var i:int = 0; i < n; i++){
                k *= (n-i);
            }
            return k;
        }
    }
}