/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ibpp
 */

// forked from Makoto_Tanaka's Camera Base on 2010-3-11
package {
    import flash.display.Sprite;
    
    import flash.media.Camera;
    import flash.media.Video;
    
    import flash.accessibility.Accessibility;
    import flash.display.SimpleButton;
    import flash.text.TextField;
    
    import flash.events.MouseEvent;
    
    import flash.text.TextFieldType;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    public class FlashTest extends Sprite {
    	
    		private var _video:Video;
    		private var _bitmap:Bitmap;
    		
        public function FlashTest() {
        		
        		var startSprite:Sprite = createButton("Start",0xff0000,5,5)
        		startSprite.addEventListener(MouseEvent.CLICK, onClickStart);
        		addChild(startSprite);
        		
        		var captureSprite:Sprite = createButton("Capture", 0x00ff00,70,5);
        		captureSprite.addEventListener(MouseEvent.CLICK, onClickCapture);
        		addChild(captureSprite);
        		
        		var bitmapData:BitmapData = new BitmapData(320,240);
        		_bitmap = new Bitmap(bitmapData);
        		_bitmap.y = 250;
            addChild(_bitmap);
        }
        
        // Startボタンクリックイベント
        private function onClickStart(e:MouseEvent):void {
        		e.target.removeEventListener(MouseEvent.CLICK, onClickStart);
        		var camera:Camera = Camera.getCamera();
            
            if(camera) {
            		_video = new Video(267,200);
            		_video.y = 30;
            		_video.attachCamera(camera);
            		addChild(_video);
            }
        }
        
        // Captureボタンクリックイベント
        private function onClickCapture(e:MouseEvent):void {
        		_bitmap.bitmapData.draw(_video);
        }
        
        private function createButton(text_:String, color_:Number, x_:int, y_:int):Sprite {
        		
        		var text:TextField = new TextField();
        		text.text = text_;
        		text.type = TextFieldType.INPUT;
        		
        		var cover:Sprite = new Sprite();
        		cover.graphics.beginFill(0, 0);
        		cover.graphics.drawRoundRect(0,0,60,20,5);
        		cover.graphics.endFill();
        		cover.buttonMode = true;
        		cover.useHandCursor = true;
        		        		
        		var sprite:Sprite = new Sprite();
        		sprite.graphics.beginFill(color_, 0.2);
        		sprite.graphics.drawRoundRect(0,0,60,20,5);
        		sprite.graphics.endFill();
        		sprite.addChild(text);
        		sprite.addChild(cover);
        		sprite.x = x_;
        		sprite.y = y_;
        		
        		return sprite;
        }
    }
}