/**
 * Copyright Joe.Brant ( http://wonderfl.net/user/Joe.Brant )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iayG
 */

// forked from spanvega's BUGS BOWS
package
{
    /*
    * CLICK OUTSIDE PANEL TO
    * GENERATE FRESH SHAPES
    */

    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;

    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;

    import flash.events.Event;
    import flash.events.MouseEvent;

    import com.greensock.easing.*;
    import com.greensock.TweenMax;

    import com.bit101.components.Label;
    import com.bit101.components.CheckBox;
    import com.bit101.components.ComboBox;
    import com.bit101.components.ProgressBar;


    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '60')]

    public class BUGS_BOWS extends Sprite
    {
        private var blob_vector : Vector.<Blob>;

        private var blob_ease : String = 'easeInOut';
        private var blob_tween : Class = Circ;

        private var blob_blend : String = 'hardlight';
        private var blob_speed : Number = 10;
        private var blob_area : Number = 0;
        private var diagonal  : Number;

        private var blob_pixels : BitmapData;
        private var blob_bitmap : Bitmap;
        private var blob_holder : Sprite;

        private var panel_button : CheckBox;
        private var pb_alpha : ProgressBar; 
        private var pb_speed : ProgressBar;
        private var pb_blur  : ProgressBar;
        private var panel  : Sprite;

        private var stageW : Number;
        private var stageH : Number;
        private var appliX : Number;
        private var appliY : Number;


        public function BUGS_BOWS ()
        {
            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init () : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            stageH = stage.stageHeight;
            stageW = stage.stageWidth;

            appliX = stageW / 2;
            appliY = stageH / 2;

            stage.scaleMode = 'noScale';
            stage.align = 'TL';

            diagonal = onDistance (0,0);

            //

            blob_bitmap = new Bitmap ();

            addChild (blob_bitmap);

            blob_pixels = new BitmapData
            (
                stageW, stageH, true, 0xFFFFFF
            );

            //

            onGenerate ();

            // --o PANEL

            onPanel ();

            //

            stage.addEventListener
            (
                MouseEvent.CLICK, onGenerateProxy
            );

            addEventListener (Event.ENTER_FRAME, onRender);
        }

        private function onRender (e : Event) : void
        {
            // --o BITMAPDATA SCROLL [ 0 - 10 ]

            var sx : Number = (blob_speed / appliX) * (mouseX - appliX);
            var sy : Number = (blob_speed / appliY) * (mouseY - appliY);

            sx = -(sx < blob_speed ? sx : blob_speed);
            sy = -(sy < blob_speed ? sy : blob_speed);

            var sp : Number = Math.abs (sx) + Math.abs (sy);

            pb_speed.value = sp / 20;

            // --o BLOB AREA
            
            blob_area = 10 + sp * 6;

            // --o MOUSE DISTANCE

            var distance : Number = onDistance (mouseX, mouseY);

            distance = (distance < diagonal ? distance : diagonal);

            // --o ALPHA MULTIPLIER [ 0.45 - 0.95 ]

            var am : Number = 0.45 + (distance / diagonal * .5);

            pb_alpha.value = am;

            // --o BLUR LEVEL [ 0 - 10 ]

            var bb : Number = 10 - (distance / diagonal) * 10;

            pb_blur.value = bb / 10;

            //

            blob_pixels.colorTransform
            (
                blob_pixels.rect, new ColorTransform (1, 1, 1, am, 0, 0, 0, 0)
            );

            blob_pixels.applyFilter
            (
                blob_pixels, blob_pixels.rect, new Point(0, 0), new BlurFilter (bb, bb)
            );

            blob_pixels.scroll (sx, sy);

            blob_pixels.draw (blob_holder);

            blob_bitmap.bitmapData = blob_pixels;


            for each (var b : Blob in blob_vector)
            {
                // --o BEVEL FILTER ANGLE DISTANCE

                var degrees : Number = Math.atan2
                (mouseY - b.y, mouseX - b.x) * (180 / Math.PI);

                b.bevel.angle = degrees;
                b.bevel.distance = blob_speed + (sp * .5);

                b.filters = [b.bevel, b.glow];

                //

                if (b.moved)
                {    
                    b.moved = false;

                    b.point = onArea (b.width, b.height);

                    // --o INCREASE TWEEN DURATION ACCORDING TO SPEED

                    var duration : Number = 1 + ((20 - sp) * Math.random () / 5);

                    TweenMax.to
                    (
                        b,
                        duration,
                        {
                            x : b.point.x - x,
                            y : b.point.y - y,
                            onCompleteParams : [b],
                            onComplete : onPointMoved,
                            ease : blob_tween[blob_ease]
                        }
                    );
                }
            }
        }

        private function onArea (w : Number, h : Number) : Point
        {
            /*
            USE A LIMITED AREA TO REDUCE TILING EFFECT ON BORDERS 
                DUE TO TWEENS INTERPOLATING OVER THE POINT VALUES
                DISABLED BACK | ELASTIC TWEEN CLASS
            
            DECREASE BLOB AREA ACCORDING TO SPEED TO REGROUP THEM
            */

            return new Point
            (
                blob_area + (w/2) + (Math.random () * (stageW - (w + blob_area*2))),
                blob_area + (h/2) + (Math.random () * (stageH - (h + blob_area*2)))
            );
        }

        private function onDistance (p1 : Number, p2 : Number) : Number
        {
            var n1 : Number = p1 - appliX;
            var n2 : Number = p2 - appliY;

            return Math.sqrt (n1 * n1 + n2 * n2);
        }

        private function onGenerate () : void
        {
            var blob_nb : uint = 15 + Math.round (Math.random () * 15);

            //

            blob_holder = new Sprite ();

            blob_vector = new <Blob> [];

            for (var i : int = 0; i < blob_nb; i++)
            {
                var b : Blob = new Blob
                (
                    new Point (appliX, appliY)
                );

                b.blendMode = blob_blend;

                blob_holder.addChild (b);

                blob_vector.push (b);
            }
        }

        private function onGenerateProxy (e : MouseEvent) : void
        {
            if (! panel.hitTestPoint (mouseX, mouseY))
            {
                onGenerate ();
            }
        }

        //

        private function onPanel () : void
        {
            panel = new Sprite ();

            // --o BACKGROUND

            var rect : Sprite = new Sprite ();
            rect.graphics.lineStyle (1, 0xAAAAAA);
            rect.graphics.beginFill (0xFFFFFF, 0.5);
            rect.graphics.moveTo (0, 0);
            rect.graphics.lineTo (129, 0);
            rect.graphics.lineTo (129, 123);
            rect.graphics.lineTo (20, 123);
            rect.graphics.lineTo (20, 20);
            rect.graphics.lineTo (0, 20);
            rect.graphics.lineTo (0, 0);
            rect.graphics.endFill ();

            panel.addChild (rect);

            // --o CHECKBOX | BTN

            panel_button = new CheckBox (panel, 5, 5, null, onPanelDisplay);
            panel_button.selected = true;

            // --o COMBOBOXES

            var array_tween : Array =
            [
            //  {label:'BACK', data:Back},
                {label:'BOUNCE', data:Bounce},
                {label:'CIRC', data:Circ},
                {label:'CUBIC', data:Cubic},
            //  {label:'ELASTIC', data:Elastic},
                {label:'EXPO', data:Expo},
                {label:'LINEAR', data:Linear},
                {label:'QUAD', data:Quad},
                {label:'QUART', data:Quart},
                {label:'QUINT', data:Quint},
                {label:'SINE', data:Sine},
                {label:'STRONG', data:Strong}
            ];

            var combo_tween : ComboBox = new ComboBox (panel, 25, 5, 'TWEEN', array_tween);
            combo_tween.numVisibleItems = array_tween.length;
            combo_tween.addEventListener
            (
                Event.SELECT, onSelectTween
            );

            var array_ease : Array =
            [
                {label:'EASE IN', data:'easeIn'},
                {label:'EASE OUT', data:'easeOut'},
                {label:'EASE IN OUT', data:'easeInOut'}
            ];
    
            var combo_ease : ComboBox = new ComboBox (panel, 25, 30, 'EASE', array_ease);
            combo_ease.numVisibleItems = array_ease.length; 
            combo_ease.addEventListener
            (
                Event.SELECT, onSelectEase
            );

            var array_blend : Array =
            [
                {label : 'ADD', data : 'add'},
            //  {label : 'ALPHA', data : 'alpha'},
                {label : 'DARKEN', data : 'darken'},
                {label : 'DIFFERENCE', data : 'difference'},
            //  {label : 'ERASE', data : 'erase'},
                {label : 'HARDLIGHT', data : 'hardlight'},
                {label : 'INVERT', data : 'invert'},
                {label : 'LAYER', data : 'layer'},
                {label : 'LIGHTEN', data : 'lighten'},
                {label : 'MULTIPLY', data : 'multiply'},
                {label : 'NORMAL', data : 'normal'},
                {label : 'OVERLAY', data : 'overlay'},
                {label : 'SCREEN', data : 'screen'},
                {label : 'SUBTRACT', data : 'subtract'}
            ];

            var combo_blend : ComboBox = new ComboBox (panel, 25, 55, 'BLEND', array_blend);
            combo_blend.numVisibleItems = array_blend.length;
            combo_blend.addEventListener
            (
                Event.SELECT, onSelectBlend
            );

            // --o METERS

            var lb_alpha : Label = new Label (panel, 91, 75, 'ALPHA');

            pb_alpha = new ProgressBar (panel, 25, 79);
            pb_alpha.width = 60;

            var lb_speed : Label = new Label (panel, 91, 90, 'SPEED');

            pb_speed = new ProgressBar (panel, 25, 94);
            pb_speed.width = 60;

            var lb_blur : Label = new Label (panel, 91, 105, 'BLUR');

            pb_blur = new ProgressBar (panel, 25, 109);
            pb_blur.width = 60;

            //

            panel.x = stageW - (panel.width + 20);
            panel.y = 20;

            addChild (panel);
        }

        private function onPanelDisplay (e : Event = null) : void
        {
            TweenMax.to
            (
                panel, 0.75,
                {x : stageW - (panel_button.selected ? panel.width + 20 : 20), ease : Elastic.easeOut}
            );
        }

        private function onSelectTween (e : Event) : void
        {
            blob_tween = e.target.selectedItem.data;
        }

        private function onSelectEase (e : Event) : void
        {
            blob_ease = e.target.selectedItem.data;
        }

        private function onSelectBlend (e : Event) : void
        {
            blob_blend = e.target.selectedItem.data;

            for each (var b : Blob in blob_vector)
            {
                b.blendMode = blob_blend;
            }
        }

        //

        private function onPointMoved (b :Blob) : void
        {
            b.moved = true;
        }
    }
}


import flash.geom.Point;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.filters.BevelFilter;


class Blob extends Shape
{
    public var color : uint = 0xFF0000 * Math.random ();

    public var glow  : GlowFilter =  new GlowFilter (color);
    public var bevel : BevelFilter = new BevelFilter
    (
        10, 45, 0xFFFFFF, .15, 0xFFFFFF, 0.75, 10, 0
    );

    public var moved : Boolean = true;
    public var point : Point;

    public function Blob (p : Point)
    {
        point = p;
        filters = [bevel, glow];

        graphics.lineStyle (2, 0xFFFFFF);
        graphics.beginFill (color, 1);
        graphics.drawCircle(0, 0, 1 + Math.random () * 14);
        graphics.endFill();

        x = p.x;
        y = p.y;
    }
}