/**
 * Copyright quqjp ( http://wonderfl.net/user/quqjp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iZjJ
 */

// forked from quqjp's 入力タイプのテキストフィールド
package {

    import flash.events.*;
    import flash.text.*;
    import flash.display.Sprite;
    import flash.system.Capabilities;
    import flash.system.IME;
    import flash.system.IMEConversionMode;
    

    /**
     * 入力タイプのTextFieldと、focusがあたったらIMEをONにするTextField。
     */
    public class FlashTest extends Sprite {
        
        
        //debug
        protected var oLogView:LogView;
        
        /**
         * コンストラクタ
         */
        public function FlashTest() {
            
            //ラベル１
            var label:TextField = createTf(false,false);
            label.text = "普通の入力タイプのTextField";
            label.y = 10;
            this.addChild(label);
            
            //入力フィールド
            var tf:TextField = createTf(true);
            tf.y = 30;
            this.addChild(tf);
            
            //ラベル２
            label = createTf(false,false);
            label.text = "入力タイプのTextField(focusあたったらIME日本語ONにします)";
            label.y = 80;
            this.addChild(label);

            //入力フィールド
            tf = createTf(true);
            tf.y = 100;
            this.addChild(tf);
            tf.addEventListener(FocusEvent.FOCUS_IN,onFocusTf_IME);

            //ラベル
            label = createTf(false,false);
            label.text = "入力タイプのTextField(focusあたったらJS promptを開く)";
            label.y = 150;
            this.addChild(label);
            
             //入力フィールド
            tf = createTf(true);
            tf.y = 170;
            this.addChild(tf);
            tf.addEventListener(FocusEvent.FOCUS_IN,onFocusTf_JS);
            
            //ログ出力パネルを準備
            oLogView = new LogView();
            oLogView.y = 350;
            this.addChild(oLogView);
            
            oLogView.appendLog("client info ---------");
            oLogView.appendLog(Capabilities.os);
            oLogView.appendLog(Capabilities.version);
            oLogView.appendLog("---------------------");
                
        }
        
        /**
         * テキストフィールドのフォーカスイベントのハンドリング
         * IME日本語入力を起動します
         */
        protected function onFocusTf_IME(e:FocusEvent):void{
            
            oLogView.appendLog("called:onFocusTf_IME");
            
            if (Capabilities.hasIME)
            {
                try
                {
                    IME.enabled = true;
                    IME.conversionMode = IMEConversionMode.JAPANESE_HIRAGANA ;
                    oLogView.appendLog("set:IMEConversionMode.JAPANESE_HIRAGANA");    
                }
                catch (error:Error)
                {
                    oLogView.appendLog("ERROR:IME ERROR " + error);    
                }
            }else{
                oLogView.appendLog("WARN:IME is not found.");    
            }
        }


        /**
         * Javascript prompt と連携して入力をします
         */
        protected function onFocusTf_JS(e:FocusEvent):void{
                
            oLogView.appendLog("called:onFocusTf_JS");
                
        }        
        
        
        /**
         * TextFieldをつくります
         */
        protected function createTf(typeinput:Boolean = false, border:Boolean = true):TextField{
                
        var tft:TextFormat = new TextFormat();
            tft.size = 16;
        var tf:TextField = new TextField();
        tf.defaultTextFormat = tft;
            if(typeinput) tf.type = TextFieldType.INPUT;
        tf.multiline = true;
        tf.text = "input field.";
        tf.autoSize = TextFieldAutoSize.LEFT;
        tf.border = border;
            return tf;
                    
        }
    }
}


    /**
     * import
     */
        import flash.display.MovieClip;
    import com.bit101.components.*;    
                
    /**
     * コンソールビュー
     * @author kenichi iida (kenichi.iida@quq.jp)
     */
    class LogView extends MovieClip
    {
                
        //
        protected var oTextArea:TextArea;
                
        //ロギング文字
        protected var textstr:String = "";
                
        /**
         * コンストラクタ
         */
        public function LogView() {
            var oWindow:Window = new Window(this, 0, 0, "Console");
            oWindow.draggable = true;
            oWindow.hasMinimizeButton = true;
            oTextArea = new TextArea(oWindow.content, 0, 0, "");
            oTextArea.width = 200;
            oTextArea.height = 100;
            oWindow.width = 200;
            oWindow.height = 110;
        }
        
        /**
         * ログ値設定
         */
        public function log(str:String):void{
            oTextArea.text = str;
        }
        
        /**
         * ログ値追加
         */
        public function appendLog(str:String):void{
                
            this.textstr += str +"\n";
            this.log(this.textstr);
            
        }
        
        /**
         * クリアする
         */
        public function clear():void{
            this.log("");
            this.textstr = "";
        }
        
        /**
         * 初期化
         */
        public function initialize():void{
        }
                
        }

