/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iZPn
 */

// forked from soundkitchen's [1日1Wonderfl]9日目: スプレーっぽいなにか poor code version.
/**
 *  スプレーっぽい効果やってみたよ。
 *
 *  とりあえず解決版:
 *      Graphics は毎回 clear するようにして、
 *      代りに毎回 BitmapData に draw するように変更。
 *      適度にメモリーも開放されてるっぽいし、良いんじゃない？
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    import com.flashdynamix.utils.SWFProfiler;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]

    public class Main extends Sprite
    {
        private var isMouseDown:Boolean;
        private var canvas:Shape;
        private var film:BitmapData;

        /**
         *  コンストラクタ
         */
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        /**
         *  初期化
         */
        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            //  プロファイラを仕込む
            SWFProfiler.init(this);

            //  マウスダウンされてる？フラグ
            isMouseDown = false;

            //  キャンバスとなる Shape 作って
            canvas = new Shape();
            //  特攻まない
            //addChild(canvas);

            //  フィルムとなる BitmapData 作って
            film = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            //  特攻む
            addChild(new Bitmap(film));

            //  ステージにイベント設定
            stage.addEventListener(Event.ENTER_FRAME, step);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        }

        /**
         *  毎フレームの処理
         */
        private function step(evt:Event):void
        {
            //  マウスダウンされてなければおしまい
            if (!isMouseDown) return;

            var i:uint,
                g:Graphics,
                angle:Number, distance:Number,
                tx:Number, ty:Number;

            //  キャンバスの Graphics を何回も使うので変数へ
            g = canvas.graphics;
            //  ほんでもって clear
            g.clear();
            for (i=0; i<30; i++)
            {
                //  ドットを打つ位置を決めるデータを用意
                angle = Math.random() * Math.PI * 2;
                distance = Math.random() * 30;

                //  ドットを打つ位置を決定
                tx = mouseX + Math.cos(angle) * distance;
                ty = mouseY + Math.sin(angle) * distance;

                //  書き込む
                g.beginFill(0xff0000);
                g.drawRect(tx, ty, 1, 1);
                g.endFill();
            }
            //  書き込みを反映
            film.lock();
            film.draw(canvas);
            film.unlock();
        }

        /**
         *  stage のマウスダウン
         */
        private function mouseDownHandler(evt:MouseEvent):void
        {
            isMouseDown = true;
        }

        /**
         *  stage のマウスアップ
         */
        private function mouseUpHandler(evt:MouseEvent):void
        {
            isMouseDown = false;
        }
    }
}

