/**
 * Copyright Rodlaiz ( http://wonderfl.net/user/Rodlaiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iZD9
 */

// forked from lune's forked from: StarDust
// forked from matsu4512's StarDust
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;

	//Flashの背景色、幅、高さの設定
	[SWF(backgroundColor="0x000000", width=465, height=465)]

	public class StarDust extends Sprite
	{
		private var particles:Array=[];

		//発光フィルター
		private var glow:GlowFilter;
		//色を変化させるためのもの
		private var colorTrans:ColorTransform;

		//大量のボールを描画するSprite
		private var canvas:Sprite;
		//表示用Bitmap
		private var bmp:Bitmap;
		//canvasの内容を記録するためのBitmapData
		private var bmpData:BitmapData;

		public function StarDust()
		{
			glow=new GlowFilter(0, 1, 16, 16, 2);
			colorTrans=new ColorTransform(0.8, 0.95, 0.99, 0.9);

			canvas=new Sprite();
			bmpData=new BitmapData(512, 512, true, 0xFF00000);
			bmp=new Bitmap(bmpData);
			addChild(bmp);

			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}

		private function onEnterFrame(event:Event):void
		{
			//ボールの生成, 引数:x座標、y座標、x方向の速度、y方向の速度、半径、色
			var p:Star=new Star(mouseX, mouseY, Math.random() * 10 - 5, Math.random() * 10 - 5, -Math.random() * 10, Math.random() * 10 - 5, Math.random() * 0xffffff, Math.random() * 8 + 5);

			//Glowの色の設定
			glow.color=p.color;
			//フィルターの適用
			p.filters=[glow];

			//配列に追加
			particles.push(p);

			//canvas上に表示(画面上には見えない)
			canvas.addChild(p);

			//配列の長さを取得
			var i:int=particles.length;
			while (i--)
			{
				//配列からの取り出し
				p=particles[i];
				//位置などの更新
				p.x+=p.vx;
				p.y+=p.vy;

				//Z方向の動き
				p.z+=p.vz;
				//回転
				p.rotation+=p.rv;

				p.vx+=0.15
				p.vy+=0.2;

				//画面内にあるかどうか
				if (p.x > stage.stageWidth || p.y > stage.stageHeight)
				{
					//配列から削除
					particles.splice(i, 1);

					//canvas上からも削除
					canvas.removeChild(p);
				}
			}

			//canvas上に描かれている内容をbmpDataに格納
			bmpData.draw(canvas);
			//色変化エフェクトを適用
			bmpData.colorTransform(bmpData.rect, colorTrans);
		}
	}
}

import flash.display.Sprite;


class Star extends Sprite
{
	public var vx:Number;
	public var vy:Number;
	public var vz:Number;
	public var color:uint;
	public var rv:Number;

	public function Star(x:Number, y:Number, vx:Number, vy:Number, vz:Number, rv:Number, color:uint=0xFF0000, r:Number=20.0, p:int=5)
	{
		this.x=x;
		this.y=y;
		this.vx=vx;
		this.vy=vy;
		this.vz=vz;
		this.rv=rv;
		this.color=color;

		var r2:Number=r / 2;
		var angle:Number=-90;
		var addtion:Number=360 / (p * 2);
		graphics.beginFill(0xffffff);
		graphics.moveTo(0, -r);
		for (var i:int=0; i < p * 2; i++)
		{
			angle+=addtion;
			var to_x:Number;
			var to_y:Number;
			var radian:Number=angle * Math.PI / 180;
			if (i % 2)
			{
				to_x=r * Math.cos(radian);
				to_y=r * Math.sin(radian);
			}
			else
			{
				to_x=r2 * Math.cos(radian);
				to_y=r2 * Math.sin(radian);
			}
			graphics.lineTo(to_x, to_y);
		}
		graphics.endFill();
	}
}
