/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iXyv
 */

package {
    import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.display.Graphics;
	import flash.utils.getTimer;
    public class FlashTest extends Sprite {
		private var pt:Point;
		private var rect:Rectangle;
		private var matrix:Matrix;
		private var txt:TextField;
		
		private const COUNT:int = 100000;
        public function FlashTest() {
            // write as3 code here..
            txt = new TextField();
			txt.autoSize = "left";
			addChild(txt);
			
			pt = new Point();
			rect = new Rectangle();
			matrix = new Matrix();
			
			var spr:Sprite = createBtn("one more test", 0, 350);
			
			addChild(spr);
			
			spr.addEventListener(MouseEvent.CLICK, test);
			
			test(null);
        }
		
		private function test(e:MouseEvent):void 
		{
			var time:int;
			var i:int;
			var _pt:Point;
			var _rect:Rectangle;
			var _mat:Matrix;
			
			txt.text = "テスト回数 " + COUNT;
			txt.appendText("\n=========================");
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				_pt = pt.clone();
			}
			
			txt.appendText("\nPoint.clone() " + (getTimer() - time) + " msec");
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				_pt = new Point();
			}
			
			txt.appendText("\nnew Point " + (getTimer() - time) + " msec");
			txt.appendText("\n=========================");
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				_rect = rect.clone();
			}
			
			txt.appendText("\nRectangle.clone() " + (getTimer() - time) + " msec");
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				_rect = new Rectangle();
			}
			
			txt.appendText("\nnew Rectangle " + (getTimer() - time) + " msec");
			txt.appendText("\n=========================");
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				_mat = matrix.clone();
			}
			
			txt.appendText("\nMatrix.clone() " + (getTimer() - time) + " msec");
			
			time = getTimer();
			i = COUNT;
			while (i--)
			{
				_mat = new Matrix();
			}
			
			txt.appendText("\nnew Matrix " + (getTimer() - time) + " msec");
		}
        
        private function createBtn(str:String, x:int, y:int):Sprite
        {
            var txt:TextField = new TextField();
            var spr:Sprite = new Sprite();
            txt.autoSize = "left";
            txt.textColor = 0xFFFFFF;
            txt.text = str;
            txt.selectable = false;
            spr.addChild(txt);
            var g:Graphics = spr.graphics;
            g.beginFill(0, 1);
            g.drawRect(0, 0, spr.width, spr.height);
            g.endFill();
            
            spr.x = x;
            spr.y = y;
            
            addChild(spr);
            
            return spr;
        }
    }
}