/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iXEw
 */

// forked from echo's forked from: forked from: [PV3D]BitmapFileMaterialを利用した場合のクロスドメイン対処方法
// forked from echo's forked from: [PV3D]BitmapFileMaterialを利用した場合のクロスドメイン対処方法
// forked from clockmaker's [PV3D]BitmapFileMaterialを利用した場合のクロスドメイン対処方法
// forked from a24's forked from: [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
// forked from clockmaker's [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
package {
    import flash.system.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    /**
    * 外部画像をBitmapFileMaterialを使って読み込むデモ
    */
    public class Main extends BasicView {
        public function Main():void {
            opaqueBackground = 0x0; // 背景を黒くする
            
            // クロスドメイン対策
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            // 画像ファイルのパス
            const url:String = "http://wonderfl.net/static/tmp/related_images/7f724729f17618874db96e8ba5fad67f3587a467m";
            
            // マテリアル(テクスチャ)をBitmapFileMaterialとして作成
            var material:BitmapFileMaterial = new BitmapFileMaterial(url, true);
            material.doubleSided = true; // 両面にテクスチャを貼る
            
            // 平面を作成
            var tree1:Plane = new Plane(material, 1200, 1200);
            var tree2:Plane = new Plane(material, 1200, 1200);
            tree2.rotationY = 90;
            
            // 画面を表示
            scene.addChild(tree1);
            scene.addChild(tree2);
            
            // レンダリング開始
            startRendering();
            
            // ついでに回転でもさせておく
            addEventListener("enterFrame", function():void {
                tree1.yaw(1);
                tree2.yaw(1);
            });
        }
    }
}