/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iWwr
 */




package
{
    import flash.display.*
    import flash.events.*
    import flash.geom.*
    //import flash.filters.GlowFilter;
    
    
    public class Main extends MovieClip
    { 
        public  const SW           :Number   = stage.stageWidth;
        public  const SH           :Number   = stage.stageHeight;
        private var   _numLines    :uint     = 5;
        private var   _maxSpeed    :Number   = 6;
        private var   _minSpeed    :Number   = 3;
        private var   _radiusMin   :Number   = 40;
        private var   _radiusMax   :Number   = 60;
        private var   _startPt     :Vector3D = new Vector3D(  (    -100), (    SH/2), (0) );
        private var   _halfPt      :Vector3D = new Vector3D(  (_halfPtX), (_halfPtY), (0) );
        private var   _endPt       :Vector3D = new Vector3D(  (  SW+100), (    SH/2), (0) );
        private var   _angleLeft   :Array    = new Array();
        private var   _angleRight  :Array    = new Array();
        private var   _radiLeft    :Array    = new Array();
        private var   _radiRight   :Array    = new Array();
        private var   _halfPtX     :Number   = new Number( Math.abs( _startPt.x-_endPt.x)/2 );
        private var   _halfPtY     :Number   = new Number( Math.abs( _startPt.y-_endPt.y)/2 );
        private var   _halfPtZ     :Number   = new Number( Math.abs( _startPt.z-_endPt.z)/2 );
        
        public function Main ():void
        {    
            stage.frameRate = 60
            //ENTRY POINT:
                                                    
            for (var i:int = 0; i < _numLines; i++)
            {
                _radiLeft.push(_radiusMin + ((_radiusMax - _radiusMin) / (_numLines -1) ) * i);
                _radiRight.push(_radiusMax - ((_radiusMax - _radiusMin) / (_numLines -1) ) * i);
                _angleLeft.push((360 / _numLines) * i);
                _angleRight.push(360 - (360 / _numLines) * i);
            }            
            for (var j:int = 0; j < _numLines; j++)
            {
                var line:MovieClip = new MovieClip();
                line.angle1 = _angleLeft[j];
                line.radius1 = _radiLeft[j];
                line.speed1 = Math.random() * (_maxSpeed - _minSpeed) + _minSpeed;
                line.angle2 = _angleRight[j];
                line.radius2 = _radiRight[j];
                line.speed2 = Math.random() * (_maxSpeed - _minSpeed) + _minSpeed;
                line.colour = 0x0000;
                line.addEventListener(Event.ENTER_FRAME, onLoop);
                //line.filters = [_glow]
                stage.addChild(line);        
            }
        }
        private function onLoop (evt:Event):void
        {
            var line:MovieClip = MovieClip(evt.target);        
            line.tx1 = _startPt2D.x + _halfPt.x / 2 + Math.cos(line.angle1 * (Math.PI / 180)) * line.radius1;
            line.ty1 = _startPt2D.y + Math.sin(line.angle1 * (Math.PI / 180)) * line.radius1;
            line.tz1 = _startPt.z + Math.sin(line.angle1 * (Math.PI / 180)) * line.radius1;
            
            line.tx2 = _endPt2D.x - _midPt2D.x / 2 + Math.cos(line.angle2 * (Math.PI / 180)) * line.radius2;            
            //line.tx2 = _endPt.x - _halfPt.x / 2 + Math.cos(line.angle2 * (Math.PI / 180)) * line.radius2;
            line.ty2 = _endPt2D.y + Math.sin(line.angle2 * (Math.PI / 180)) * line.radius2;
            //line.ty2 = _endPt.y + Math.sin(line.angle2 * (Math.PI / 180)) * line.radius2;
            line.tz2 = _endPt.z - _halfPt.z / 2 + Math.cos(line.angle2 * (Math.PI / 180)) * line.radius2;
            //line.tz2 = _endPt.z - _halfPt.z / 2 + Math.cos(line.angle2 * (Math.PI / 180)) * line.radius2;
            line.midx = (line.tx2 + line.tx1) / 2;
            line.midy = (line.ty2 + line.ty1) / 2;
            line.midz = (line.tz2 + line.tz1) / 2;
            line.angle1 += line.speed1;
            line.angle2 += line.speed2;
            
            var _startPt2D :Point  =  local3DToGlobal( _startPt );
            var _midPt2D   :Point  =  local3DToGlobal( _halfPt  );
            var _endPt2D   :Point  =  local3DToGlobal( _endPt   );
            
            line.graphics.clear(); 
            line.graphics.lineStyle(1, line.colour);
            //line.graphics.moveTo(_startPt.x, _startPt.y);
            line.graphics.moveTo(_startPt2D.x, _startPt2D.y); 
            line.graphics.curveTo(line.tx1, line.ty1, line._halfPtX, line._halfPtY);
            //line.graphics.curveTo(line.tx1, line.ty1, line.midx, line.midy);
            line.graphics.curveTo(line.tx2, line.ty2, _endPt.x, _endPt.y);
            //line.graphics.curveTo(line.tx2, line.ty2, _endPt.x, _endPt.y);
        }
    }
}








// _____________________________________________________________________________________________________________________
// _____________________________________________________________________________________________________________________
// NOTES:_______________________________________________________________________________________________________________

/*
            //_startPt  =  new Vector3D( -100,stage.stageHeight/2,0 )
            //_startPt  =  new Vector3D( SW+100,SH/2,0 )
            //_startPt  =  new Vector3D( Math.abs( _startPt.x-_endPt.x)/2,Math.abs(_startPt.y-_endPt.y)/2,0 )
*/
/*
        //private const _startPt:Point = new Point( -100, stage.stageHeight / 2);
        //private const _endPt:Point = new Point(stage.stageWidth + 100, stage.stageHeight / 2);
        //private const _halfPt:Point = new Point(Math.abs(_startPt.x - _endPt.x) / 2, Math.abs(_startPt.y - _endPt.y) / 2);
        //private const _glow:GlowFilter = new GlowFilter(0x000000, 0.7, 5, 5, 5, 1000); 
*/






/*
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
        }
    }
}
*/