/**
 * Copyright Cao ( http://wonderfl.net/user/Cao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iVtE
 */

Stage.scaleMode = "showAll";
var vi:Video;
var ca:Camera = Camera.get();
ca.setMode(800,600,30);  
var bmp = new flash.display.BitmapData(160, 120, true, 0);
var bmp2 = new flash.display.BitmapData(160, 120, true, 0);
createEmptyMovieClip("mc", 1);
mc._x = 320;
mc.attachBitmap(bmp2, 0);
var bound = bmp.rectangle;
var skin2seg = new flash.filters.ColorMatrixFilter();
var SEGMENT_COLOR:Number = 0x008080;
var SEGMENT_MASK:Number = 0x00C0C0;
vi.attachVideo(ca);
attachBitmap(bmp, 0);
var laplacian = new flash.filters.ConvolutionFilter();
laplacian.matrixX = 5;
laplacian.matrixY = 5;
laplacian.matrix = [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 1, 1, 1, 0.5, 0.5, 1, -16, 1, 0.5, 0.5, 1, 1, 1, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5];
var noiseReduction = new flash.filters.ConvolutionFilter();
noiseReduction.matrixX = 3;
noiseReduction.matrixY = 3;
noiseReduction.matrix = [1, 1, 1, 1, 0, 1, 1, 1, 1];
noiseReduction.bias = -0x400;
var grayscale = new flash.filters.ColorMatrixFilter();
grayscale.matrix = [1 / 3, 1 / 3, 1 / 3, 0, 0, 1 / 3, 1 / 3, 1 / 3, 0, 0, 1 / 3, 1 / 3, 1 / 3, 0, 0, 0, 0, 0, 1, 0];
function onEnterFrame() {
    skin2seg.matrix = createSkinMatrix(uoffset.value, urange.value, voffset.value, vrange.value);
    bmp2.draw(vi);
    bmp.applyFilter(bmp2, bound, null, skin2seg);
    bmp2.applyFilter(bmp2, bound, null, laplacian);
    bmp2.applyFilter(bmp2, bound, null, grayscale);
    bmp.threshold(bmp, bound, null, "!=", SEGMENT_COLOR, 0xFF000000, SEGMENT_MASK, false);
    bmp.threshold(bmp, bound, null, "==", SEGMENT_COLOR, 0xFFFFFFFF, SEGMENT_MASK, false);
    if (splitByContour.value) {
        bmp.threshold(bmp2, bound, null, ">", 0x60, 0xFF000000, 0xFF, false);
    }
    if (doNoiseReduction.value) {
        var bmp3 = bmp.clone();
        bmp3.applyFilter(bmp3, bound, null, noiseReduction);
        bmp.threshold(bmp3, bound, null, "==", 0, 0xFF000000, 0xFF, false);
    }
    if (doLabeling.value) {
        var colors = [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF, 0xFF8000, 0x00FF80, 0x8000FF, 0x80FF00, 0x0080FF, 0xFF0080];
        while (colors.length && labeling(bmp, colors.shift())) {
        }
    }
}
function labeling(bmp, color) {
    var wbr = bmp.getColorBoundsRect(0xFFFFFF, 0xFFFFFF);
    var x = wbr.x;
    for (var y = wbr.y + wbr.height - 1; y >= wbr.y; --y) {
        if (bmp.getPixel(x, y) == 0xFFFFFF) {
            bmp.floodFill(x, y, color);
            var br = bmp.getColorBoundsRect(0xFFFFFF, color);
            if (br.width > 6 && br.height > 6) {
                return true;
            } else {
                bmp.floodFill(x, y, 0);
                return labeling(bmp, color);
            }
        }
    }
    return false;
}
function createSkinMatrix(uoffset, urange, voffset, vrange) {
    var u = 64 / urange;
    var v = 64 / vrange;
    var a = [];
    a.push(0, 0, 0, 0, 0);
    a.push(-0.169 * u, -0.331 * u, +0.500 * u, 0, (urange / 2 - uoffset) * u + 128);
    a.push(+0.500 * v, -0.419 * v, -0.081 * v, 0, (vrange / 2 - voffset) * v + 128);
    a.push(0, 0, 0, 1, 0);
    return a;
}
