/**
 * Copyright 16pavel ( http://wonderfl.net/user/16pavel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iVKS
 */

package {
   	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	
	import flashx.textLayout.formats.BackgroundColor;
	
	import frocessing.color.ColorHSV;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Back;
	import org.libspark.betweenas3.tweens.ITween;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.VectorLetter3D;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.view.BasicView;
	
	[SWF(backgroundColor=0x000000)]
	public class Watch_example extends BasicView
	{
			private var word:Text3D;
			private var sphere:Sphere;
			private var lines:Lines3D;
			private var p:Number = 5.0, r:Number = 25.0, b:Number = 8.0/3.0, D:Number = 0.01;
			//向かう座標
			private var toX:Number, toY:Number, toZ:Number;
			private var hsv:ColorHSV;
			//玉にかけるエフェクト
			private var glow:GlowFilter;
			//Planeを格納するためのVector
			private var particles:Vector.<Plane>;
			public function Watch_example() {
				//文字作成
				word = new Text3D("Hello!!", new HelveticaBold(), null);
				
				for(var i:int = 0; i < word.letters.length; i++){
					var char:VectorLetter3D = word.letters[i];
					//文字色
					var mat:Letter3DMaterial = new Letter3DMaterial(Math.random()*0xFFFFFF);
					//両面表示有効
					mat.doubleSided = true;
					char.material = mat;
					//座標保存{}はObject型
					char.extra = {x:char.x, y:char.y, z:char.z};
					//位置設定
					char.x = Math.random()*2000-1000;
					char.y = Math.random()*2000-1000;
					char.z = Math.random()*2000-1000;
				}
					//初期化
					hsv = new ColorHSV(0, 1, 1);
					glow = new GlowFilter(0, 1, 8, 8, 2);
					toX = toY = toZ = 1;
					particles = new Vector.<Plane>();
					
					//玉の生成
					var mat2:ColorMaterial = new ColorMaterial(0xFFFFFF);
					sphere = new Sphere(mat2, 25);
					sphere.x = sphere.y = sphere.z = 1;
					scene.addChild(sphere);
					
					sphere.useOwnContainer = true;
					var blur:BlurFilter = new BlurFilter();
					sphere.filters = [blur, glow];
					
					camera.target = word;
										
					lines = new Lines3D();

					scene.addChild(word);
					startRendering();
					addEventListener(Event.ENTER_FRAME, onFrame);
				
				
				tween(0);
			}
			
			//文字を中央へ移動
			private function tween(i:int):void{
				var l:VectorLetter3D = word.letters[i];
				var t:ITween = BetweenAS3.to(l, {x:l.extra.x, y:l.extra.y, z:l.extra.z}, 0.5, Back.easeInOut);
				//tween終了後に実行する関数
				if(i+1 != word.letters.length){
					t.onComplete = tween;
					t.onCompleteParams = [i+1];
				}
				else{
					t.onComplete = tween2;
				}
				t.play();
			}
			
			private function tween2():void{
				for(var i:int = 0; i < word.letters.length; i++){
					BetweenAS3.to(word.letters[i], {rotationY:360}, 1.5, Back.easeInOut).play();
				}
			}
			
			private function onFrame(event:Event):void{
				
				//マウスの位置によってカメラの位置変更
				camera.x = (mouseX-stage.stageWidth/2)*5;
				camera.y = (mouseY-stage.stageHeight/2)*5;
				
				var fromX:Number = sphere.x;
				var fromY:Number = sphere.y;
				var fromZ:Number = sphere.z;
				
				var dx:Number, dy:Number, dz:Number;
				
				dx = (-p*toX + p*toY);
				dy = (-toX*toZ + r*toX - toY);
				dz = (toX*toY - b*toZ);
				
				toX += D*dx;
				toY += D*dy;
				toZ += D*dz;
				
				sphere.x = toX*30;
				sphere.y = toY*30;
				sphere.z = toZ*30;
			
				var color:uint = hsv.toRGB().value;
				glow.color = color;
				
				for(var j:int = 0; j < 3; j++){
					
					var mat:ColorMaterial= new ColorMaterial(color);
					
					mat.doubleSided = true;
					var p:Plane = new Plane(mat, 25, 25);
					
					p.x = sphere.x;
					p.y = sphere.y;
					p.z = sphere.z;
					
					p.useOwnContainer = true;
					p.filters = [new BlurFilter()];
					
					p.extra = {vx:Math.random()*6-1, vy:Math.random()*6-1, vz:Math.random()*6-1};
					
					scene.addChild(p);
					particles.push(p);
				}
				
				var i:int = particles.length;
				
				while(i--){
					p = particles[i];
					
					p.x += p.extra.vx;
					p.y += p.extra.vy;
					p.z += p.extra.vz;
					
					p.material.fillAlpha -= 0.05;
					
					if(p.material.fillAlpha <= 0) {
						particles.splice(i, 1);
						scene.removeChild(p);
						p = null;
					}
				}
				hsv.h++;
			}
	}
}