/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iUwz
 */

/*
    やわらかボール。
    curveToの練習。
    
    マウスの座標に反応してボールが変形します。
*/
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="40")]
    public  class main extends Sprite
    {
        private static const CENTER_X:Number = 465/2;
        private static const CENTER_Y:Number = 465/2;
        private static const RADIUS:int = 150;
        private var container:Array;
        private var color:uint;
        
        // コンストラクタ
        public function main()
        {
            // 円の座標を計算する
            container=[];
            for(var i:int=0; i < 20; i++)
            {
                var r:Number=i* Math.PI/10;
                var xx:Number = Math.sin(r) * RADIUS;
                var yy:Number = Math.cos(r) * RADIUS;
                var ball:Ball = new Ball(xx + CENTER_X,yy + CENTER_Y);
                container.push(ball);
            }
            
            // 塗る色を適当に決める
            var colors:Array = [0x770000, 0x007700, 0x000077, 0x777700];
            color = colors[Math.random()*4>>0];
            
            // イベントの追加
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // フレームイベント
        private function onFrame(e:Event):void
        {
            graphics.clear();
            graphics.beginFill(color, 1);
            
            // ボールを描写
            var ball:Ball=container[0]as Ball;
            var last:Ball=container[19]as Ball;
            var startCx:Number=(ball.x + last.x) * 0.5;
            var startCy:Number=(ball.y + last.y) * 0.5;
            graphics.moveTo(startCx, startCy);
            for(var i:int=0; i < 19; i++)
            {
                ball = container[i] as Ball;
                var next:Ball=container[i + 1]as Ball;
                var cx:Number=(ball.x + next.x) * 0.5;
                var cy:Number=(ball.y + next.y) * 0.5;
                graphics.curveTo(ball.x, ball.y, cx, cy);
                ball.render(mouseX, mouseY);
            }
            graphics.curveTo(last.x, last.y, startCx, startCy);
            graphics.endFill();
            last.render(mouseX, mouseY);
        }
    }
}

// ボールを表すクラス
class Ball
{
    public var x:Number;
    public var y:Number;
    private var firstX:Number;
    private var firstY:Number;
    
    // コンストラクタ
    public function Ball(x:Number, y:Number)
    {
        this.x = firstX = x;
        this.y = firstY = y;
    }
    
    // 座標の更新
    public function render(mouseX:Number, mouseY:Number):void
    {
        var theta:Number=Math.atan2(y - mouseY, x - mouseX);
        var d:Number=400 / Math.sqrt(Math.pow(mouseX - x, 2) + Math.pow(mouseY - y, 2));
        x+=d * Math.cos(theta) + (firstX - x) * 0.1;
        y+=d * Math.sin(theta) + (firstY - y) * 0.1;
    }
}