/**
 * Copyright Thumasz ( http://wonderfl.net/user/Thumasz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iSkG
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        private var cirkel:Sprite;
        private var cirkel2:Sprite;            
        
        public var cirkelBreedte:Number = 50;  
        
        public function FlashTest() {
            cirkel = new Sprite();
            cirkel.x = 100;
            cirkel.y = 100;
            
            cirkel2 = new Sprite();
            cirkel2.x = 300;
            cirkel2.y = 200;
            
            this.addChild(cirkel);
            this.addChild(cirkel2);
            
            cirkel2.graphics.lineStyle(3,0,1);
            cirkel2.graphics.beginFill(0xFF0000,1);
            cirkel2.graphics.drawCircle(0,0,cirkelBreedte);
            cirkel2.graphics.drawCircle(0,cirkelBreedte * 0.5, cirkelBreedte * 0.1);
            cirkel2.graphics.moveTo(0,0);
            cirkel2.graphics.lineTo(cirkelBreedte,0);
            cirkel2.graphics.endFill();
            
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function update(e:Event=null):void{
            var afstandX:Number = mouseX-cirkel.x;
            var afstandY:Number = mouseY-cirkel.y;
            //Neem de afstanden tot de muis in beide dimensies
            
            var hoek:Number = Math.atan2(afstandY,afstandX);
            //Bereken de hoek, Atan2 maakt er automatisch radialen van
            
            cirkel.graphics.clear();
            cirkel.graphics.beginFill(0x00FF00,1);
            cirkel.graphics.lineStyle(3,0,1);
            cirkel.graphics.drawCircle(0,0, cirkelBreedte);
            cirkel.graphics.drawCircle(0,cirkelBreedte * 0.5, cirkelBreedte * 0.1);
            cirkel.graphics.endFill();
            //Teken de cirkel
            
            var richtingX:Number = Math.cos(hoek) * cirkelBreedte;
            var richtingY:Number = Math.sin(hoek) * cirkelBreedte;
            cirkel.graphics.moveTo(0,0);
            cirkel.graphics.lineTo(richtingX,richtingY);
            //Teken een lijn richting je muis aan de hand van de hoek
            
            afstandX = mouseX-cirkel2.x;
            afstandY = mouseY-cirkel2.y;
            hoek = Math.atan2(afstandY,afstandX);
            cirkel2.rotation = hoek * 180 / Math.PI;
            // Bereken de hoek van cirkel2 en roteer hem
        }

    }
}